/* uctest.c */
/*
 * Modified by National Institute of Informatics in Japan, 2013-2015.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef UCTEST_MAKE_TABLE
int make_table();
#endif
int test_jis();
int test_sjis();
int test_euc();

int main(int argc, char **argv)
{
	int ret = EXIT_SUCCESS;	/* change to EXIT_FAILURE when test failed. */

#ifdef UCTEST_MAKE_TABLE
	make_table();
#endif

	if (test_jis()) {
		printf("error in test_jis..\n");
		ret = EXIT_FAILURE;
	}
	if (test_sjis()) {
		printf("error in test_sjis..\n");
		ret = EXIT_FAILURE;
	}
	if (test_euc()) {
		printf("error in test_euc..\n");
		ret = EXIT_FAILURE;
	}
	if (ret == EXIT_FAILURE)
		return EXIT_FAILURE;
	else
		return EXIT_SUCCESS;
}

#ifdef UCTEST_MAKE_TABLE
int make_table()
{
	FILE *inf = NULL, *outf = NULL;
	char buf[1024];
	int i, j, k, l, u, br, err = -1;

	if ((inf = fopen("JIS0208.csv", "r")) == NULL) {
		fprintf(stderr, "fopen error! -- inf\n");
		goto done;
	}
	if ((outf = fopen("out.txt", "w")) == NULL) {
		fprintf(stderr, "fopen error! -- outf\n");
		goto done;
	}
	fprintf(outf, "unsigned short kuten[]={\n");

	i = j = 0;
	while (fgets(buf, 1024, inf)) {
		sscanf(buf, "%x,%x,%x", &k, &l, &u);

		br = 1;
		do {
			if (k == (i * 0x100 + j + 0x2121)) {
				fprintf(outf, "0x%.4x,", u);
				br = 0;
			} else {
				fprintf(outf, "    -1,");
			}
			if ((j % 8) == 7)
				fputs("\n\t", outf);

			printf("%x : %x,%x\n", i * 0x100 + j + 0x2121, k, u);
			j++;
			if (j >= 96) {
				i++;
				j = 0;
			}
		} while (br);
	}

	err = 0;
done:
	if (inf)
		fclose(inf);
	if (outf)
		fclose(outf);
	return err;
}
#endif
