#include "aiconfig.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <aicrypto/ok_asn1.h>
#include <aicrypto/ok_tool.h>

static const char md_in[7][128] = {
	"",
	"a",
	"abc",
	"message digest",
	"abcdefghijklmnopqrstuvwxyz",

	"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789",

	"1234567890123456789012345678901234567890"
	"1234567890123456789012345678901234567890"
};

/* MD2 */
#ifdef HAVE_MD2
int test_md2(void)
{
	unsigned char ans[7][16]={
		{0x83,0x50,0xe5,0xa3,0xe2,0x4c,0x15,0x3d,
		 0xf2,0x27,0x5c,0x9f,0x80,0x69,0x27,0x73},
		{0x32,0xec,0x01,0xec,0x4a,0x6d,0xac,0x72,
		 0xc0,0xab,0x96,0xfb,0x34,0xc0,0xb5,0xd1},
		{0xda,0x85,0x3b,0x0d,0x3f,0x88,0xd9,0x9b,
		 0x30,0x28,0x3a,0x69,0xe6,0xde,0xd6,0xbb},
		{0xab,0x4f,0x49,0x6b,0xfb,0x2a,0x53,0x0b,
		 0x21,0x9f,0xf3,0x30,0x31,0xfe,0x06,0xb0},
		{0x4e,0x8d,0xdf,0xf3,0x65,0x02,0x92,0xab,
		 0x5a,0x41,0x08,0xc3,0xaa,0x47,0x94,0x0b},
		{0xda,0x33,0xde,0xf2,0xa4,0x2d,0xf1,0x39,
		 0x75,0x35,0x28,0x46,0xc3,0x03,0x38,0xcd},
		{0xd5,0x97,0x6f,0x79,0xd8,0x3d,0x3a,0x0d,
		 0xc9,0x80,0x6c,0x3c,0x66,0xf3,0xef,0xd8}
	};
	unsigned char ret[16];
	int i;
	int ret_len;
	for (i = 0; i < 7; i++) {
		OK_do_digest(OBJ_HASH_MD2, (unsigned char *)md_in[i],
			     strlen(md_in[i]), ret, &ret_len);

		if (memcmp(ret, ans[i], 16)) {
			printf("error : test md2 -- %d : %s\n", i, md_in[i]);
			return EXIT_FAILURE;
		}
		printf("test md2 ok -- %d\n", i);
	}
	return EXIT_SUCCESS;
}
#endif

/* MD5 */
int test_md5(void)
{
	unsigned char ans[7][16] = {
		{0xd4,0x1d,0x8c,0xd9,0x8f,0x00,0xb2,0x04,
		 0xe9,0x80,0x09,0x98,0xec,0xf8,0x42,0x7e},
		{0x0c,0xc1,0x75,0xb9,0xc0,0xf1,0xb6,0xa8,
		 0x31,0xc3,0x99,0xe2,0x69,0x77,0x26,0x61},
		{0x90,0x01,0x50,0x98,0x3c,0xd2,0x4f,0xb0,
		 0xd6,0x96,0x3f,0x7d,0x28,0xe1,0x7f,0x72},
		{0xf9,0x6b,0x69,0x7d,0x7c,0xb7,0x93,0x8d,
		 0x52,0x5a,0x2f,0x31,0xaa,0xf1,0x61,0xd0},
		{0xc3,0xfc,0xd3,0xd7,0x61,0x92,0xe4,0x00,
		 0x7d,0xfb,0x49,0x6c,0xca,0x67,0xe1,0x3b},
		{0xd1,0x74,0xab,0x98,0xd2,0x77,0xd9,0xf5,
		 0xa5,0x61,0x1c,0x2c,0x9f,0x41,0x9d,0x9f},
		{0x57,0xed,0xf4,0xa2,0x2b,0xe3,0xc9,0x55,
		 0xac,0x49,0xda,0x2e,0x21,0x07,0xb6,0x7a}
	};
	unsigned char ret[16];
	int i;
	int ret_len;
	
	for (i = 0; i < 7; i++) {
		OK_do_digest(OBJ_HASH_MD5, (unsigned char *)md_in[i],
			     strlen(md_in[i]), ret, &ret_len);

		if (memcmp(ret, ans[i], 16)) {
			printf("error : test md5 -- %d : %s\n", i, md_in[i]);
			return EXIT_FAILURE;
		}
		printf("test md5 ok -- %d\n",i);
	}
	return EXIT_SUCCESS;
}

static const char sha_in[] =
	"abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq";

/* SHA-1 */
int test_sha1(void)
{
	SHA1_CTX ctx;
	unsigned char ret[20], in2[1000];
	unsigned char ans1[20] = {
		0x84,0x98,0x3E,0x44,0x1C,0x3B,0xD2,0x6E,0xBA,0xAE,
		0x4A,0xA1,0xF9,0x51,0x29,0xE5,0xE5,0x46,0x70,0xF1};
	unsigned char ans2[20] = {
		0x34,0xAA,0x97,0x3C,0xD4,0xC4,0xDA,0xA4,0xF6,0x1E,
		0xEB,0x2B,0xDB,0xAD,0x27,0x31,0x65,0x34,0x01,0x6F};
	unsigned char ans3[20] = { /* size 0 */
		0xda, 0x39, 0xa3, 0xee, 0x5e, 0x6b, 0x4b, 0x0d,
		0x32, 0x55, 0xbf, 0xef, 0x95, 0x60, 0x18, 0x90,
		0xaf, 0xd8, 0x07, 0x09};
	int i;
	int ret_len;

	/* test 1 */
	OK_do_digest(OBJ_HASH_SHA1, (unsigned char *)sha_in, strlen(sha_in), ret, &ret_len);
	if (memcmp(ret, ans1, 20)) {
		printf("error : test sha1 1\n");
		return EXIT_FAILURE;
	} else {
		printf("test sha1 ok -- 1\n");
	}
	/* test 2 -- skipped */
	/* test 3 -- for message size 0 */
	OK_do_digest(OBJ_HASH_SHA1, (unsigned char *)sha_in, 0, ret, &ret_len);
	if (memcmp(ret, ans3, 20)) {
		printf("error : test sha1 3\n");
		return EXIT_FAILURE;
	} else {
		printf("test sha1 ok -- 3\n");
	}
	return EXIT_SUCCESS;
}

/* SHA-224 */
/* SHA-256 */
int test_sha256(void)
{
	SHA256_CTX	ctx;
	unsigned char ret[SHA256_DIGESTSIZE], in2[1000];

	unsigned char ans1[SHA256_DIGESTSIZE] = {
		0x24,0x8d,0x6a,0x61,0xd2,0x06,0x38,0xb8,
		0xe5,0xc0,0x26,0x93,0x0c,0x3e,0x60,0x39,
		0xa3,0x3c,0xe4,0x59,0x64,0xff,0x21,0x67,
		0xf6,0xec,0xed,0xd4,0x19,0xdb,0x06,0xc1
	};

	unsigned char ans2[SHA256_DIGESTSIZE] = {
		0xcd,0xc7,0x6e,0x5c,0x99,0x14,0xfb,0x92,
		0x81,0xa1,0xc7,0xe2,0x84,0xd7,0x3e,0x67,
		0xf1,0x80,0x9a,0x48,0xa4,0x97,0x20,0x0e,
		0x04,0x6d,0x39,0xcc,0xc7,0x11,0x2c,0xd0
	};

	/* size 0 */
	unsigned char ans3[SHA256_DIGESTSIZE] = {
		0xe3, 0xb0, 0xc4, 0x42, 0x98, 0xfc, 0x1c, 0x14,
		0x9a, 0xfb, 0xf4, 0xc8,	0x99, 0x6f, 0xb9, 0x24,
		0x27, 0xae, 0x41, 0xe4, 0x64, 0x9b, 0x93, 0x4c,
		0xa4, 0x95, 0x99, 0x1b, 0x78, 0x52, 0xb8, 0x55
	};
	int i;
	int ret_len;

	OK_do_digest(OBJ_HASH_SHA256, (unsigned char *)sha_in, strlen(sha_in), ret, &ret_len);
	if (memcmp(ret, ans1, SHA256_DIGESTSIZE)) {
		printf("error : test sha256 1\n");
		return EXIT_FAILURE;
	} else {
		printf("test sha256 ok -- 1\n");
	}

	/* for message size 0 */
	OK_do_digest(OBJ_HASH_SHA256, (unsigned char *)sha_in, 0, ret, &ret_len);
	if (memcmp(ret, ans3, SHA256_DIGESTSIZE)) {
		printf("error : test sha256 3\n");
		return EXIT_FAILURE;
	} else {
		printf("test sha256 ok -- 3\n");
	}

	return EXIT_SUCCESS;
}

/* SHA-384 */
/* SHA-512 */
int test_sha512(void)
{
	SHA512_CTX ctx;
	unsigned char ret[SHA512_DIGESTSIZE], in2[1000];
	char in[] =
	    "abcdefghbcdefghicdefghijdefghijkefghijklfghijklmghijklmn"
	    "hijklmnoijklmnopjklmnopqklmnopqrlmnopqrsmnopqrstnopqrstu";
	unsigned char ans1[SHA512_DIGESTSIZE] = {
		0x8e, 0x95, 0x9b, 0x75, 0xda, 0xe3, 0x13, 0xda,
		0x8c, 0xf4, 0xf7, 0x28, 0x14, 0xfc, 0x14, 0x3f,
		0x8f, 0x77, 0x79, 0xc6, 0xeb, 0x9f, 0x7f, 0xa1,
		0x72, 0x99, 0xae, 0xad, 0xb6, 0x88, 0x90, 0x18,
		0x50, 0x1d, 0x28, 0x9e, 0x49, 0x00, 0xf7, 0xe4,
		0x33, 0x1b, 0x99, 0xde, 0xc4, 0xb5, 0x43, 0x3a,
		0xc7, 0xd3, 0x29, 0xee, 0xb6, 0xdd, 0x26, 0x54,
		0x5e, 0x96, 0xe5, 0x5b, 0x87, 0x4b, 0xe9, 0x09
	};

	/* size 0 */
	unsigned char ans3[SHA512_DIGESTSIZE] = {
		0xcf, 0x83, 0xe1, 0x35, 0x7e, 0xef, 0xb8, 0xbd,
		0xf1, 0x54, 0x28, 0x50, 0xd6, 0x6d, 0x80, 0x07,
		0xd6, 0x20, 0xe4, 0x05, 0x0b, 0x57, 0x15, 0xdc,
		0x83, 0xf4, 0xa9, 0x21, 0xd3, 0x6c, 0xe9, 0xce,
		0x47, 0xd0, 0xd1, 0x3c, 0x5d, 0x85, 0xf2, 0xb0,
		0xff, 0x83, 0x18, 0xd2, 0x87, 0x7e, 0xec, 0x2f,
		0x63, 0xb9, 0x31, 0xbd, 0x47, 0x41, 0x7a, 0x81,
		0xa5, 0x38, 0x32, 0x7a, 0xf9, 0x27, 0xda, 0x3e
	};
	int i;
	int ret_len;

	OK_do_digest(OBJ_HASH_SHA512, (unsigned char *)in, strlen(in), ret, &ret_len);

	if (memcmp(ret, ans1, SHA512_DIGESTSIZE)) {
		printf("error : test sha512 1\n");
		return EXIT_FAILURE;
	} else {
		printf("test sha512 ok -- 1\n");
	}

	/* Test size 0 */
	OK_do_digest(OBJ_HASH_SHA512, (unsigned char *)in, 0, ret, &ret_len);
	if (memcmp(ret, ans3, SHA512_DIGESTSIZE)) {
		printf("error : test sha512 3\n");
		return EXIT_FAILURE;
	} else {
		printf("test sha512 ok -- 3\n");
	}

	return EXIT_SUCCESS;
}

/* SHA-512/224 */
/* SHA-512/256 */

int main(void)
{
	int ret = EXIT_SUCCESS;

#ifdef HAVE_MD2
	if (EXIT_SUCCESS != test_md2()) {
		printf("FAIL: md2\n");
		ret = EXIT_FAILURE;
	}
#endif

	if (EXIT_SUCCESS != test_md5()) {
		printf("FAIL: md5\n");
		ret = EXIT_FAILURE;
	}

	if (EXIT_SUCCESS != test_sha1()) {
		printf("FAIL: sha1\n");
		ret = EXIT_FAILURE;
	}

	if (EXIT_SUCCESS != test_sha256()) {
		printf("FAIL: sha256\n");
		ret = EXIT_FAILURE;
	}

	if (EXIT_SUCCESS != test_sha512()) {
		printf("FAIL: sha512\n");
		ret = EXIT_FAILURE;
	}

	return ret;
}
