/* locktest.c - check lock work for OS implementation. */
/*
 * Modified by National Institute of Informatics in Japan, 2013-2017.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <aicrypto/ok_asn1.h>
#include <aicrypto/ok_err.h>
#include <aicrypto/ok_pem.h>
#include <aicrypto/ok_rsa.h>
#include <aicrypto/ok_tool.h>
#include <aicrypto/ok_x509.h>

int lock_msec = 10000; /* 10 sec */
int wait_msec = 10000; /* 10 sec */

int check_opt(int argc, char **argv);

int main(int argc, char **argv){
  AILock lock = NULL;
  int i,ok = -1;

  ok = check_opt(argc,argv);
  if (EXIT_FAILURE == ok)
	  return EXIT_FAILURE;

  if((lock=OK_init_lock("aitestlock"))==NULL){
    printf("cannot initialize lock\n");
    goto done;
  }

  if(OK_lock(lock,lock_msec)){
    printf("lock timeout error.\n");
    goto done;
  }

  wait_msec /= 1000;
  printf("now waiting for a critical section (for %dsec) ",wait_msec);
  for(i=0; i<wait_msec; i++){
    sleep(1); /* sleep 1 sec */
    printf("."); fflush(stdout);
  }
  printf(" done\n");

  OK_unlock(lock);

  ok = EXIT_SUCCESS;
done:  
  if(ok) printf("%s\n",OK_get_errstr());
  OK_release_lock(lock);
  return ok;
}

int check_opt(int argc, char **argv){
  int   i;

  for(i=1;i<argc;i++){
    if(!strcmp(argv[i],"-s")){
      i++;
      if(i<argc) lock_msec=atoi(argv[i]);
    }else if(!strcmp(argv[i],"-w")){
      i++;
      if(i<argc) wait_msec=atoi(argv[i]);
    }else{
      printf("\
Usage: locktest [OPTION...]\n\
\n\
Options:\n\
  -s msec	set millisecond to lock\n\
  -w msec	set millisecond to wait\n\
");
      return EXIT_FAILURE;
    }
  }
  return EXIT_SUCCESS;
}
