/* digest.c */
/*
 * Copyright (c) 2012-2015 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */
/*
 * Copyright (C) 1998-2002
 * Akira Iwata & Takuto Okuno
 * Akira Iwata Laboratory,
 * Nagoya Institute of Technology in Japan.
 *
 * All rights reserved.
 *
 * This software is written by Takuto Okuno(usapato@anet.ne.jp)
 * And if you want to contact us, send an email to Kimitake Wakayama
 * (wakayama@elcom.nitech.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software must
 *    display the following acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *    Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *     Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *   AKIRA IWATA LABORATORY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *   SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 *   IN NO EVENT SHALL AKIRA IWATA LABORATORY BE LIABLE FOR ANY SPECIAL,
 *   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *   FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *   NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#include "aiconfig.h"

#include <stdio.h>
#include <stdlib.h>
#include <aicrypto/ok_err.h>
#include <aicrypto/ok_asn1.h>
#ifdef HAVE_MD2
#include <aicrypto/ok_md2.h>
#endif
#include <aicrypto/ok_md5.h>
#include <aicrypto/ok_sha1.h>
#include <aicrypto/ok_tool.h>

/**
 * Compute message digest with signature algorithm aioid.
 *
 */
unsigned char *OK_do_digest(int digest_algo,
			    unsigned char *data, unsigned int data_len,
			    unsigned char *ret, int *ret_len)
{
	unsigned char *cp = ret;
	HASHAlgorithm *ha;

	if (ret == NULL) {
		if((cp = (unsigned char*)malloc(AC_MAX_DIGESTSIZE)) == NULL) {
			OK_set_error(ERR_ST_MEMALLOC, ERR_LC_TOOL,
				     ERR_PT_DIGEST, NULL);
			return NULL;
		}
	}

	ha = gethashalgobyaioid(obj_sig2hash(digest_algo));

	if (ha == NULL ||
	    ha->aioid == OBJ_HASH_SHAKE128 ||
	    ha->aioid == OBJ_HASH_SHAKE256) {
		if (ret == NULL) {
			free(cp);
		}
		OK_set_error(ERR_ST_UNSUPPORTED_ALGO, ERR_LC_TOOL,
			     ERR_PT_DIGEST, NULL);
		return NULL;
	}

	*ret_len = ha->hash_size;
	ha->hash_compute(data_len, data, cp);

	return cp;
}
