/*
 * Copyright (c) 2015 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/index.html.
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */

#include "tls_session.h"
#include "tls_compress.h"
#include "tls_alert.h"

#include <string.h>

bool tls_compress_set(TLS *tls, enum compression_algorithm algo) {
	/* do not do divergence by version since compression method
	 * definition is NULL from SSL 3.0 to TLS 1.2.*/
	switch (algo) {
	case TLS_COMPRESSION_NULL:
		tls->pending->compression_algorithm = algo;
		break;

	default:
		/* our implementation of tls must not select other than
		 * NULL. */
		TLS_DPRINTF("compress: cunknown compression algorithm");
		OK_set_error(ERR_ST_TLS_UNKNOWN_COMPRESSION_ALGO,
			     ERR_LC_TLS1, ERR_PT_TLS_COMPRESS + 0, NULL);
		TLS_ALERT_FATAL(tls, TLS_ALERT_DESC_ILLEGAL_PARAMETER);
		return false;
	}

	return true;
}

int16_t tls_compress(TLS *tls,
		     uint8_t *dest, const uint8_t *src, const int32_t len) {
	/* since do not chosen other than NULL as compression algorithm
	 * basically, this function must not become error. */

	switch (tls->active_write.compression_algorithm) {
	case TLS_COMPRESSION_NULL:
		memcpy(dest, src, len);
		break;

	default:
		assert(!"selected compression algorithm is unknown.");
	}

	return len;
}

int16_t tls_decompress(TLS *tls,
		       uint8_t *dest, const uint8_t *src, const int32_t len) {
	/* since do not chosen other than NULL as compression algorithm
	 * basically, this function must not become error. */

	switch (tls->active_read.compression_algorithm) {
	case TLS_COMPRESSION_NULL:
		memcpy(dest, src, len);
		break;

	default:
		assert(!"selected compression algorithm is unknown.");
	}

	return len;
}
