#! /bin/sh
# -*- sh-shell: ash -*-

T=0;
F=1;

OS="`uname -s`"

PATH_PROGRAM=${PATH_PROGRAM:-${top_builddir}/tls}
TEST_TLS_CLIENT="${PATH_PROGRAM}/client"
TEST_TLS_SERVER="${PATH_PROGRAM}/server"

PATH_STM="${srcdir}/test/store"
PATH_P12="${srcdir}/test/p12"

# server certificates
PATH_P12_SERVER1="${PATH_P12}/sv1.example.org.p12"
PATH_P12_SERVER2="${PATH_P12}/sv2.example.org.p12"
PATH_P12_SERVER3="${PATH_P12}/sv3.example.org.p12"

# client certificates
PATH_P12_TESTUSER1="${PATH_P12}/testuser1.p12"
PATH_P12_TESTUSER2="${PATH_P12}/testuser2.p12"
PATH_P12_TESTUSER4="${PATH_P12}/testuser4.p12"

CERT_PASSWORD="password"

PID_SERVER=""

LISTEN_PORT=${LISTEN_PORT:-17777}
SERVER_ADDR=${SERVER_ADDR:-127.0.0.1}
SERVER_PORT=${SERVER_PORT:-${LISTEN_PORT}}

OUT_SERVER=""
OUT_CLIENT=""

RET=""

prepare_test() {
    NUM=$1

    if [ "x$NUM" = "x" ]; then
	NUM=0
    fi

    sleep 1.0

    # to avoid "address already in use", update port number to use.
    LISTEN_PORT=$((LISTEN_PORT + NUM))
    SERVER_PORT=$((SERVER_PORT + NUM))
}

finish() {
    if [ ! "x${PID_SERVER}" = "x" ]; then
	echo "kill: server (${PID_SERVER})"
	kill -TERM ${PID_SERVER}
	PID_SERVER=""
    fi
}

dump_output() {
    echo ""
    echo "------------------------------------------------------------"
    echo "SERVER OUTPUT"
    echo "------------------------------------------------------------"
    echo ""
    cat ${OUT_SERVER}
    echo ""

    echo ""
    echo "------------------------------------------------------------"
    echo "CLIENT OUTPUT"
    echo "------------------------------------------------------------"
    echo ""
    cat ${OUT_CLIENT}
    echo ""

    if [ ! "x${OUT_SERVER}" = "x" ]; then
	rm ${OUT_SERVER}
	OUT_SERVER=""
    fi

    if [ ! "x${OUT_CLIENT}" = "x" ]; then
	rm ${OUT_CLIENT}
	OUT_CLIENT=""
    fi
}

run_server() {
    finish

    if [ "x${OS}" = "xDarwin" ]; then
        OUT_SERVER="`mktemp -t tmp`"    # prefix "tmp" is suitable?
    else
        OUT_SERVER="`mktemp`"
    fi

    echo "run(s): ${TEST_TLS_SERVER} -p ${LISTEN_PORT} -P password -e $@ &"
    ${TEST_TLS_SERVER} -p ${LISTEN_PORT} \
		       -P ${CERT_PASSWORD} \
		       -e \
		       "$@" > ${OUT_SERVER} 2>&1 &
    PID_SERVER=$!

    # wait server startup.
    sleep 1.0
}

run_client() {
    if [ "x${OS}" = "xDarwin" ]; then
        OUT_CLIENT="`mktemp -t tmp`"    # ditto to OUT_SERVER
    else
        OUT_CLIENT="`mktemp`"
    fi

    echo "run(c): ${TEST_TLS_CLIENT} -a ${SERVER_ADDR} -p ${SERVER_PORT} -P password -e $@"
    ${TEST_TLS_CLIENT} -a ${SERVER_ADDR} \
		       -p ${SERVER_PORT} \
		       -P ${CERT_PASSWORD} \
		       -e \
		       "$@" > ${OUT_CLIENT} 2>&1
    RET=$?
    if [ ! "x${RET}" = "x0" ]; then
	return ${F}
    fi

    # wait server output
    wait ${PID_SERVER}
    RET=$?
    if [ ! "x${RET}" = "x0" ]; then
	return ${F}
    fi
    PID_SERVER=""

    return ${T}
}
