#! /bin/sh
# -*- sh-shell: ash -*-

. ${srcdir}/test/test-common.sh

run_test() {
    echo "------------------------------------------------------------"
    echo "CLIENT CERTIFICATE AUTH"
    echo "------------------------------------------------------------"
    echo ""
    echo " * server: use store manager"
    echo " * server: use valid certificate"
    echo "           (sv1.example.org as id in store manager)"
    echo " * server: do NOT accept NULL client certificate."
    echo ""
    echo " * client: do NOT use store manager"
    echo " * client: use valid certificate"
    echo "           (PKCS#12 of TEST USER1)"
    echo ""

    run_server -a -s "${PATH_STM}" -i sv1.example.org

    if ! run_client -c "${PATH_P12_TESTUSER1}"; then
	dump_output
	return ${F}
    fi

    dump_output
    return ${T}
}

main() {
    trap 'finish' 1 2 3 15

    # prepare test.
    prepare_test 4

    if ! run_test; then
	return ${F}
    fi

    return ${T};
}

main
