#! /bin/sh
# -*- sh-shell: ash -*-

. ${srcdir}/test/test-common.sh

run_test() {
    echo "------------------------------------------------------------"
    echo "SERVER CERTIFICATE ONLY"
    echo "------------------------------------------------------------"
    echo ""
    echo " * server: do NOT use store manager"
    echo " * server: use expired certificate"
    echo "           (PKCS#12 of sv2.example.org)"
    echo ""

    # although this test is expected to fail because the server send a
    # expired certificate, by specification from aissl, this test
    # succeeds because can not do certificate verification if store
    # manager (aistore) does not be usable.
    run_server -c "${PATH_P12_SERVER2}"

    if ! run_client; then
	dump_output
	return ${F}
    fi

    dump_output
    return ${T}
}

main() {
    trap 'finish' 1 2 3 15

    # prepare test.
    prepare_test 3

    if ! run_test; then
	return ${F}
    fi

    return ${T};
}

main
