/*
 * Copyright (c) 2015-2016 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/index.html.
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */

#ifndef INCLUSION_GUARD_UUID_BF16C526_C72A_5368_2A82_B206FC2C5DB7
#define INCLUSION_GUARD_UUID_BF16C526_C72A_5368_2A82_B206FC2C5DB7

#include "tls.h"

/**
 * compute PRF_SHA256
 *
 * @param secret     secret key for prf.
 * @param secret_len length of secret.
 * @param label      unique label for prf.
 * @param label_len  length of label.
 * @param seed       seed for prf.
 * @param seed_len   length of seed.
 * @param dest       destination buffer for generated preudo-random.
 * @param dest_len   length of output.
 */
void tls_prf_sha256(const uint8_t *secret,
		    const uint32_t secret_len,
		    const uint8_t *label,
		    const uint32_t label_len,
		    const uint8_t *seed,
		    const uint32_t seed_len,
		    uint8_t *dest,
		    const uint32_t dest_len);

/**
 * compute PRF_SHA384
 *
 * @param secret     secret key for prf.
 * @param secret_len length of secret.
 * @param label      unique label for prf.
 * @param label_len  length of label.
 * @param seed       seed for prf.
 * @param seed_len   length of seed.
 * @param dest       destination buffer for generated preudo-random.
 * @param dest_len   length of output.
 */
void tls_prf_sha384(const uint8_t *secret,
		    const uint32_t secret_len,
		    const uint8_t *label,
		    const uint32_t label_len,
		    const uint8_t *seed,
		    const uint32_t seed_len,
		    uint8_t *dest,
		    const uint32_t dest_len);

#endif /* INCLUSION_GUARD_UUID_BF16C526_C72A_5368_2A82_B206FC2C5DB7 */
