/*
 * Copyright (c) 2015-2019 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/index.html.
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */

#ifndef INCLUSION_GUARD_UUID_0F9C46B2_505C_008A_9BDA_F07B048AD5FB
#define INCLUSION_GUARD_UUID_0F9C46B2_505C_008A_9BDA_F07B048AD5FB

#include "tls_record.h"

/**
 * Size of Additional Authenticated Data (AAD) of TLS 1.2.
 *
 * |--------------|
 * | seq_num  (8) |
 * | type     (1) |
 * | version  (2) |
 * | length   (2) |
 * |--------------|
 */
#define AAD_SIZE_TLS12 (8 + 1 + 2 + 2)

/**
 * Size of Additional Authenticated Data (AAD) of TLS 1.3.
 *
 * |--------------|
 * | type     (1) |
 * | version  (2) |
 * | length   (2) |
 * |--------------|
 */
#define AAD_SIZE_TLS13 (1 + 2 + 2)

#define TLS_AES_GCM_AUTHENTICATION_TAG_SIZE	(16)

#define TLS_CHACHA20_POLY1305_AUTHENTICATION_TAG_SIZE	(16)

/**
 * calculate MAC of specified data.
 *
 * MAC is used by block cipher(for example), and that is included in
 * encrypted data.
 */
bool tls_mac_init(const struct tls_connection conn,
		  const struct tls_protocol_version version,
		  uint8_t *mac,
		  const int32_t mac_len,
		  const enum tls_record_ctype type,
		  const uint8_t *cbuf,
		  const int32_t clen);

/**
 * Generate the additional authenticated data (AAD).
 *
 * AAD is used by AEAD cipher (Described in RFC 5246 section 6.2.3.3).
 *
 * @param[in] TLS context structure.
 * @param[in] conn TLS connection.
 * @param[out] aad buffer of additional authenticated data.
 * The size of this buffer must be greater than or equal to 13 bytes.
 * @param[in] type content type.
 * @param[in] clen byte length of fragment.
 */
bool tls_aad_generate(TLS * tls,
		      const struct tls_connection conn,
		      uint8_t *aad,
		      const enum tls_record_ctype type,
		      const int32_t clen);

#endif /* INCLUSION_GUARD_UUID_0F9C46B2_505C_008A_9BDA_F07B048AD5FB */
