/*
 * Copyright (c) 2019 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/index.html.
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */

#ifndef INCLUSION_GUARD_UUID_3A45DC36_EE72_4837_9C2C_5242310D7DE2
#define INCLUSION_GUARD_UUID_3A45DC36_EE72_4837_9C2C_5242310D7DE2

#include <aicrypto/nrg_kdf.h>

/**
 * maximum length of hash for hkdf.
 */
#define TLS_HKDF_LABEL_HASH_SIZE_MAX	((2 << (16 - 1)) - 1)

/**
 * maximum size of label in HkdfLabel structure.
 */
#define TLS_HKDF_INNER_LABEL_SIZE_MAX	((2 << (8 - 1)) - 1)

/**
 * maximum size of context in HkdfLabel structure.
 */
#define TLS_HKDF_LABEL_CONTEXT_SIZE_MAX	((2 << (8 - 1)) - 1)

/**
 * maximum size of HkdfLabel structure.
 */
#define TLS_HKDF_LABEL_SIZE_MAX	(2 + TLS_HKDF_INNER_LABEL_SIZE_MAX + TLS_HKDF_LABEL_CONTEXT_SIZE_MAX)

/**
 * perform HKDF-Expand-Label process.
 *
 * RFC8446 7.1.  Key Schedule
 *
 *        HKDF-Expand-Label(Secret, Label, Context, Length) =
 *             HKDF-Expand(Secret, HkdfLabel, Length)
 */
bool tls_key_hkdf_expand_label(hkdf_hash_t *hash, uint8_t *secret,
			      char *label, size_t label_len,
			      uint8_t *context, size_t context_len,
			      size_t length, uint8_t *okm);

#endif /* INCLUSION_GUARD_UUID_3A45DC36_EE72_4837_9C2C_5242310D7DE2 */
