/*
 * Copyright (c) 2016-2019 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/index.html.
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */

#ifndef INCLUSION_GUARD_UUID_3CA0495A_A371_45CD_8925_2E97812C4402
#define INCLUSION_GUARD_UUID_3CA0495A_A371_45CD_8925_2E97812C4402

#include "tls_handshake.h"

#define TLS_DS_PADDING_LENGTH	(64)

#define TLS_DS_CONTEXT_STRING_LENGTH	(33)

#define TLS_DS_SEPARATOR_LENGTH	(1)

#define TLS_DS_PREFIX_LENGTH	(TLS_DS_PADDING_LENGTH + \
	TLS_DS_CONTEXT_STRING_LENGTH + TLS_DS_SEPARATOR_LENGTH)

/**
 * write digitally signed hash to the send handshake data.
 */
int32_t tls_digitally_signed_write_hash(TLS *tls, PKCS12 *p12,
					struct tls_hs_msg *msg);

/**
 * read digitally signed hash from received handshake.
 */
int32_t tls_digitally_signed_read_hash(TLS *tls, PKCS12 *p12,
				       struct tls_hs_msg *msg,
				       const uint32_t offset);


#endif /* INCLUSION_GUARD_UUID_3CA0495A_A371_45CD_8925_2E97812C4402 */
