/*
 * Copyright (c) 2015 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/index.html.
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */

#ifndef INCLUSION_GUARD_UUID_4658D32D_84A7_C702_42D9_E92A7E52F225
#define INCLUSION_GUARD_UUID_4658D32D_84A7_C702_42D9_E92A7E52F225

#include "tls.h"

/**
 * set compression algorithm that is used by TLS/SSL communication.
 *
 * compression algorithm that is set by this function is always NULL.
 * current implementation supports NULL compression algorithm only.
 */
bool tls_compress_set(TLS *tls, enum compression_algorithm algo);

/**
 * compress by negotiated compression algorithm.
 */
int16_t tls_compress(TLS *tls,
		     uint8_t *dest, const uint8_t *src, const int32_t len);

/**
 * decompress received data by negotiated compression algorithm.
 */
int16_t tls_decompress(TLS *tls,
		       uint8_t *dest, const uint8_t *src, const int32_t len);

#endif /* INCLUSION_GUARD_UUID_4658D32D_84A7_C702_42D9_E92A7E52F225 */
