/*
 * Copyright (c) 2015 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/index.html.
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */

#ifndef INCLUSION_GUARD_UUID_FE3F7A34_17F9_77DF_1786_913EFC7C96CA
#define INCLUSION_GUARD_UUID_FE3F7A34_17F9_77DF_1786_913EFC7C96CA

#include "tls_record.h"

/**
 * send Change Cipher Spec protocol request.
 *
 * check whether the tls->state is state that should send ccs, and, if
 * so, send ccs. if ccs was sent, initialize tls->active_write.
 */
bool tls_ccs_send(TLS *tls);

/**
 * receive Change Cipher Spec protocol request.
 *
 * check whether the tls->state is state that should receive ccs, and,
 * if so, parse received record data as ccs data. if record was parsed
 * successfully as ccs, initialize tls->active_read.
 */
bool tls_ccs_recv(TLS *tls, struct tls_record *record);

#endif /* INCLUSION_GUARD_UUID_FE3F7A34_17F9_77DF_1786_913EFC7C96CA */
