/*
 * Copyright (c) 2019 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/index.html.
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */

/**
 * @file tls_sv.h
 *
 * This file defines function and structures related to Supported Versions Extension.
 */

#ifndef INCLUSION_GUARD_UUID_430F295C_B8ED_42FD_8EA7_3DFA4EF8555D
#define INCLUSION_GUARD_UUID_430F295C_B8ED_42FD_8EA7_3DFA4EF8555D

#include "tls.h"

/** @see tls_handshake.h */
struct tls_hs_msg;

/**
 * write supported version extention to the handshake data.
 */
int32_t tls_hs_supported_versions_write(TLS *tls, struct tls_hs_msg *msg);

/**
 * read supported version extention from received data.
 */
int32_t tls_hs_supported_versions_read(TLS *tls,
				       const struct tls_hs_msg *msg,
				       const uint32_t offset);

#endif /* INCLUSION_GUARD_UUID_430F295C_B8ED_42FD_8EA7_3DFA4EF8555D */
