/*
 * Copyright (c) 2019 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/index.html.
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */

/**
 * @file tls_servername.h
 *
 * This file define function and structures to TLS Extension.
 */

/**
 * @defgroup tls_sni TLS Extension
 *
 * This module provides Server Name Indication API for TLS connection.
 *
 * For specifications of the extension, see RFC6066
 */

#ifndef INCLUSION_GUARD_UUID_2C7429D4_DDC6_41FC_8B0C_89C26ADE326B
#define INCLUSION_GUARD_UUID_2C7429D4_DDC6_41FC_8B0C_89C26ADE326B


/*
 * RFC 6066 3.  Server Name Indication
 *
 *       enum {
 *           host_name(0), (255)
 *       } NameType;
 */
/**
 * RFC6066 3.  Server Name Indication
 *
 * @ingroup tls_sni
 */
enum tls_hs_server_name_type {
	TLS_SNI_HOST_NAME = 0U,
};

/**
 * Write server_name extension as the extension data.
 */
int32_t tls_hs_servername_write(TLS *tls, struct tls_hs_msg *msg);

/**
 * Read server_name extension as the extension data.
 */
int32_t tls_hs_servername_read(TLS *tls, const struct tls_hs_msg *msg,
			       const uint32_t offset);

#endif /* INCLUSION_GUARD_UUID_2C7429D4_DDC6_41FC_8B0C_89C26ADE326B */
