/*
 * Copyright (c) 2019 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/index.html.
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */

#ifndef INCLUSION_GUARD_UUID_CB8D44DD_9A8F_4C17_8E97_7BC286A60E9D
#define INCLUSION_GUARD_UUID_CB8D44DD_9A8F_4C17_8E97_7BC286A60E9D

#include "tls.h"
#include "tls_handshake_ecdh.h"

/** @see tls_handshake.h */
struct tls_hs_msg;

struct tls_hs_key_share {
	TAILQ_ENTRY(tls_hs_key_share) link;

	/* type of group */
	enum tls_hs_named_curve group;

	struct tls_hs_ecdh_key key;
};

/**
 * max size of key_exchange in KeyShareEntry structure.
 */
#define TLS_EXT_KEY_SHARE_EXCHANGE_SIZE_MAX	((2 << (16 - 1)) - 1)

/**
 * initialize structure that manages an elliptic curve and keypairs.
 */
struct tls_hs_key_share *tls_hs_keyshare_init(void);

/**
 * free memory that is allocated by tls_hs_key_share_init.
 */
void tls_hs_keyshare_free(struct tls_hs_key_share *share);

/**
 * generate keypairs related to a curve given by argument.
 */
bool tls_hs_keyshare_generate(struct tls_hs_key_share *share,
			       enum tls_hs_named_curve group);

/**
 * Write Key Share Extension as the extension data.
 */
int32_t tls_hs_keyshare_write(TLS *tls, struct tls_hs_msg *msg);

/**
 * Read Key Share Extension as the extension data.
 */
int32_t tls_hs_keyshare_read(TLS *tls, const struct tls_hs_msg *msg,
			      const uint32_t offset);

#endif /* INCLUSION_GUARD_UUID_CB8D44DD_9A8F_4C17_8E97_7BC286A60E9D */
