/*
 * Copyright (c) 2019 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/index.html.
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */
#ifndef INCLUSION_GUARD_UUID_76F8D70A_54BE_4AF8_BFBF_5685268D5ABA
#define INCLUSION_GUARD_UUID_76F8D70A_54BE_4AF8_BFBF_5685268D5ABA

struct tls_hs_cookie {
	/* cookie content */
	uint8_t *content;

	/* length of cookie content */
	uint16_t len;
};

/**
 * Write Cookie Extension as the extension data.
 */
int32_t tls_hs_cookie_write(TLS *tls, struct tls_hs_msg *msg);

/**
 * Read Cookie Extension as the extension data.
 */
int32_t tls_hs_cookie_read(TLS *tls, const struct tls_hs_msg *msg,
			   const uint32_t offset);

/**
 * Free memory that is allocated to tls_hs_cookie structure.
 */
void tls_hs_cookie_free(struct tls_hs_cookie *cookie);

#endif /* INCLUSION_GUARD_UUID_76F8D70A_54BE_4AF8_BFBF_5685268D5ABA */
