/*
 * Copyright (c) 2015 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/index.html.
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */

#include "tls_handshake.h"
#include "tls_alert.h"

struct tls_hs_msg * tls_hs_shellodone_compose(TLS *tls UNUSED) {
	struct tls_hs_msg *msg;

	if ((msg = tls_hs_msg_init()) == NULL) {
		TLS_DPRINTF("tls_hs_msg_init");
		return NULL;
	}

	msg->type = TLS_HANDSHAKE_SERVER_HELLO_DONE;

	return msg;
}

bool tls_hs_shellodone_parse(TLS *tls, struct tls_hs_msg *msg) {
	/* Server Hello Done has following structure.
	 *
	 * struct { } ServerHelloDone;
	 *
	 * server hello done indicates the end of the server hello and
	 * associates message. */

	if (msg->type != TLS_HANDSHAKE_SERVER_HELLO_DONE) {
		TLS_DPRINTF("TLS_HANDSHAKE_SERVER_HELLO_DONE");
		OK_set_error(ERR_ST_TLS_UNEXPECTED_MSG, ERR_LC_TLS3,
			     ERR_PT_TLS_HS_MSG_SHELLODONE + 0, NULL);
		TLS_ALERT_FATAL(tls, TLS_ALERT_DESC_UNEXPECTED_MESSAGE);
		return false;
	}

	if (msg->len > 0) {
		TLS_DPRINTF("SERVER HELLO have contents.");
		OK_set_error(ERR_ST_TLS_INVALID_RECORD_LENGTH, ERR_LC_TLS3,
			     ERR_PT_TLS_HS_MSG_SHELLODONE + 1, NULL);
		TLS_ALERT_FATAL(tls, TLS_ALERT_DESC_DECODE_ERROR);
		return false;
	}

	return true;
}
