/* man_del.c */
/*
 * Modified by National Institute of Informatics in Japan, 2014.
 *
 */
/*
 * Copyright (C) 1998-2002
 * Akira Iwata & Takuto Okuno
 * Akira Iwata Laboratory,
 * Nagoya Institute of Technology in Japan.
 *
 * All rights reserved.
 *
 * This software is written by Takuto Okuno(usapato@anet.ne.jp)
 * And if you want to contact us, send an email to Kimitake Wakayama
 * (wakayama@elcom.nitech.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software must
 *    display the following acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *    Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *     Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *   AKIRA IWATA LABORATORY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *   SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 *   IN NO EVENT SHALL AKIRA IWATA LABORATORY BE LIABLE FOR ANY SPECIAL,
 *   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *   FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *   NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <aicrypto/ok_err.h>
#include <aicrypto/ok_asn1.h>
#include <aicrypto/ok_store.h>

/*-----------------------------------------------
   Store Manager : delete store
-----------------------------------------------*/
void STM_delete_store(STManager *stm, CStore *del){
	CStore *cs;

	if((cs=STM_find_store(stm, del))==NULL) return;

	if(cs->prev){
		cs->prev->next = cs->next;
		cs->next->prev = cs->prev;
	}else{
		stm->store     = cs->next;
		cs->next->prev = NULL;
	}
	CStore_free(cs);
}

#if 0
/*-----------------------------------------------
   Store Manager : delete & remove file
-----------------------------------------------*/
void STM_destroy_store(STManager *stm, CStore *del){
	char buf[256];
	CStore *cs;

	if((cs=STM_find_store(stm, del))==NULL) return;

	get_store_fname(buf,stm->path,cs->name,cs->ctx_type){
	if(cs->prev){
		cs->prev->next = cs->next;
		cs->next->prev = cs->prev;
	}else{
		stm->store     = cs->next;
		cs->next->prev = NULL;
	}
}
#endif

/*-----------------------------------------------
   Store Manager : import cert
-----------------------------------------------*/
int STM_del_byID(STManager *stm, char *name, int dev, int ctx, char *unique_id){
	CStore *cs;

	if((cs=STM_find_byName(stm,name,dev,ctx))==NULL){
		OK_set_error(ERR_ST_STO_STORENOTFOUND,ERR_LC_STORE,ERR_PT_MANDEL+1,NULL);
		return -1;
	}
	return CStore_del_byID(cs,unique_id);
}

