/* testclient2.c */
/* SSL test client */
/*
 * Copyright (c) 2012-2015 National Institute of Informatics in Japan, 
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/
 * If you redistribute this file, with or without modifications, you must 
 * include this notice in the file.
 */
/*
 * Copyright (C) 1998-2002
 * Akira Iwata & Takuto Okuno
 * Akira Iwata Laboratory,
 * Nagoya Institute of Technology in Japan.
 *
 * All rights reserved.
 *
 * This software is written by Takuto Okuno(usapato@anet.ne.jp)
 * And if you want to contact us, send an email to Kimitake Wakayama
 * (wakayama@elcom.nitech.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software must
 *    display the following acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *    Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *     Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *   AKIRA IWATA LABORATORY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *   SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 *   IN NO EVENT SHALL AKIRA IWATA LABORATORY BE LIABLE FOR ANY SPECIAL,
 *   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *   FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *   NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#include "aiconfig.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef HAVE_NETDB_H
#include <netdb.h>
#endif

#include <sys/types.h>
#ifdef __WINDOWS__
#undef ULONG
#include <winsock2.h>
#include <io.h>
#else
#include <sys/socket.h>
#include <netinet/in.h>
#endif

#include <aicrypto/ok_err.h>
#include <aicrypto/ok_pkcs.h>
#include <aicrypto/ok_ssl.h>
#include <aicrypto/ok_x509.h>
#include "ssl.h"

char *SSL_SERV="localhost";
char *SSL_SERV4="127.0.0.1";
char *SSL_SERV6="::1";
char *SSL_PORT="11111";
int  vfy_server=0;
int  no_ccert=0;
int  af=AF_UNSPEC;

#ifdef __WINDOWS__
#define P12FNAME		".\\00001.p12"
#else
#define P12FNAME		"./00001.p12"
#endif
#ifndef PATH
#define PATH	"."	/* path to the directory that includes P12FNAME */
#endif

/* test/getfpath.c */
char *get_fpath(char *path, char *filename);

char httpword[]=
"GET / HTTP/1.0\r\nConnection: Keep-Alive\r\nUser-Agent: Mozilla/4.02 [en] (WinNT; U)\r\nHost: nitech.ac.jp:2000\r\nAccept: image/gif, image/x-xbitmap, image/jpeg, image/pjpeg, */*\r\nAccept-Language: en-US,en-GB,en\r\nAccept-Charset: iso-8859-1,*,utf-8\r\n\r\n";

void check_opt(int argc, char **argv);
void test_do(SSL *ssl);

int main(int argc, char **argv){
	SSL *s;
	Cert *ct;
	char buf[64];
	int i, sk = -1, error;
	char *fp_P12FNAME = get_fpath(PATH, P12FNAME);

#ifdef __WINDOWS__
	WSADATA	wsaData;

	if(WSAStartup(MAKEWORD(1, 1), &wsaData) != 0) {
		printf("error : WSAStartup\n");
		return(-1);}
#endif

	check_opt(argc,argv);

	/* 1. get new SSL. and read client certificate & private key */
	s = SSL_new();

	if(!no_ccert){
	    if(SSL_set_client_p12(s,fp_P12FNAME,"abcde")){
		printf("error : SSL_set_client_p12\n");
		return(-1);
	    }

	    printf("read client certificate:\n");
	    ct = SSL_get_client_cert(s);	/* server PKCS#12 file */
	    printf("subject: %s\n",ct->subject);
	    printf("issuer:  %s\n",ct->issuer);
	}

	/* 1.1 choose verifying server certificate or not */
	if(vfy_server){
	    /* set NULL for verify.idx path.
	     * this means that use the default path. (it's depend on the
	     * installation. if you install library at /usr/local/aica
	     * the default path will be /usr/local/aica/certs ...)
	     */
	    if(SSL_set_store(s,NULL)){
	        printf("error : SSL_set_store : %s\n",OK_get_errstr());
	        return(-1);
	    }
	}else{
	    /* don't verify server certificate */
	    SSL_set_vfytype(s,SSL_DONT_VERIFY);
	}

	for(i=0;i<1000;i++){
		struct addrinfo hints;
		struct addrinfo *aihead, *ai;

		printf("\n====================== Connection Test ! ========================\n");

		/* get addrinfo list */
		memset(&hints, 0, sizeof(hints));
		hints.ai_family = af;
		hints.ai_socktype = SOCK_STREAM;
		if((error = getaddrinfo(SSL_SERV, SSL_PORT, &hints, &aihead)) != 0) {
			printf("error : getaddrinfo(%s)\n", gai_strerror(error));
			return -1;
		}

		for (ai = aihead; ai != NULL; ai = ai->ai_next) {
			/* 2. get client socket */
			if (-1 == (sk = socket(ai->ai_family, ai->ai_socktype, ai->ai_protocol))){
				printf("warning : SSL_socket\n");
				goto loop_warn;
			}

			/* 3. connect to the server */
			if(connect(sk,ai->ai_addr,ai->ai_addrlen)){
				printf("warning : SSL_connect\n");
				goto loop_warn;
			}

			break;

loop_warn:
			if (sk != -1) {
				sk = -1;
			}
		}

		if (sk == -1) {
			printf("error : no socket connection to %s\n", SSL_SERV);
			return(-1);
		}

		/* 4. set socket and reuse SSL */
		SSL_set_fd(s,sk);

		/* 5. do SSL handshake :-) */
		if(SSL_handshake(s)){
			printf("error : SSL_handshake\n");
			return(-1);
		}

		printf("SSL connection was established!\n");
		SSL_cspec_str(s->ctx,buf);
		printf("using cipher : %s\n",buf);

		if(s->ctx->sp12){
			printf("read server certificate:\n");
			ct = SSL_get_server_cert(s);	/* client PKCS#12 file */
			printf("subject: %s\n",ct->subject);
			printf("issuer:  %s\n",ct->issuer);
		}

		if(s->opt&SSL_SYS_RECONNECTION)
			printf("Re-connection mode is used in this time !!\n");
		
		/* 6. and now, send messages with SSL_read & SSL_write !! */
		test_do(s);

		freeaddrinfo(aihead);
	}

	SSL_free(s);
#ifdef __WINDOWS__
	WSACleanup();
#endif
}

void test_do(SSL *ssl){
	unsigned char buf[512];
	int	i;
	memset(buf,0,512);

	printf("now write message!\n");
	printf ("Send %zd chars:\n%s\n",strlen(httpword),httpword);
	if(SSL_write(ssl,httpword,strlen(httpword))<0){
		printf("error : SSL_write()\n");
		return;}

	printf("now waiting message!\n");
	if((i=SSL_read(ssl,buf,512))<0){
		printf("error : SSL_write()\n");
		return;}

	buf[i] = '\0';
	printf ("Recv %d chars:\n%s\n",i,buf);

	SSL_shutdown(ssl,2);  /* send SSL/TLS close_notify */

	SSL_close(ssl);
}

void check_opt(int argc, char **argv){
    int   i;
    int   enable_s = 0;

    for(i=1;i<argc;i++){
        if(!strcmp(argv[i],"-s")){
            i++;
	    SSL_SERV=argv[i];
	    enable_s=1;
        }else if(!strcmp(argv[i],"-p")){
            i++;
	    SSL_PORT=argv[i];
        }else if(!strcmp(argv[i],"-v")){
	    vfy_server=1;

        }else if(!strcmp(argv[i],"-nc")){
	    no_ccert=1;

        }else if(!strcmp(argv[i],"-4")){
	    af = AF_INET;
	    if(!enable_s){
		    SSL_SERV=SSL_SERV4;
	    }
        }else if(!strcmp(argv[i],"-6")){
	    af = AF_INET6;
	    if(!enable_s){
		    SSL_SERV=SSL_SERV6;
	    }

	}else{
	    printf("usage:\n");
	    printf("tclnt2 [-s ip_address][-p port][-v][-nc]\n");
	    printf("\t-v  ...verify server certificate.\n");
	    printf("\t-nc ...don't load client certificate.\n");
	    printf("  i.e.  connect to https://www.microsoft.com/  :-)\n");
	    printf("\t-4 ...use IPv4 only\n");
	    printf("\t-6 ...use IPv6 only\n");
	    printf("\ttclnt2 -s 207.46.230.219 -p 443\n");
	    printf("\t\t129.132.7.153 -- www.openssl.org\n");
	    printf("\t\t205.139.94.60 -- www.verisign.net\n");
	    exit(0);
	}
    }
}

