/* ssltestfc.c */
/*
 * Modified by National Institute of Informatics in Japan, 2013-2015.
 *
 */

#include "aiconfig.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef HAVE_NETDB_H
#include <netdb.h>
#endif

#include <sys/types.h>
#ifdef __WINDOWS__
# undef ULONG
# define P12_TESTF	".\\test.p12"
# include <winsock2.h>
# include <io.h>
#else
# define P12_TESTF	"test.p12"
# include <sys/socket.h>
# include <netinet/in.h>
#endif
#ifndef PATH
# define PATH	"."
#endif

#include <aicrypto/ok_pkcs.h>
#include <aicrypto/ok_ssl.h>
#include <aicrypto/ok_x509.h>
#include "ssl.h"

/* test/getfpath.c */
char *get_fpath(char *path, char *filename);


int test_ssl_mem(){
	SSL *s;
	int i;
	char *fp_P12_TESTF = get_fpath(PATH, P12_TESTF);

	/* test ssl */
	for(i=0;i<11;i++){
		s=SSL_new();
		if (SSL_set_server_p12(s,fp_P12_TESTF,"abcde")){
			printf("error : SSL_set_server_p12\n");
			return -1;
		}
		SSL_free(s);
		if((i%5)==0)printf("test ssl new & free -- ok : %d\n",i);
	}
	free(fp_P12_TESTF);
	return 0;
}
