/* ssl_hello.c */
/*
 * Modified by National Institute of Informatics in Japan, 2013-2015.
 *
 */
/*
 * Copyright (C) 1998-2002
 * Akira Iwata & Takuto Okuno
 * Akira Iwata Laboratory,
 * Nagoya Institute of Technology in Japan.
 *
 * All rights reserved.
 *
 * This software is written by Takuto Okuno(usapato@anet.ne.jp)
 * And if you want to contact us, send an email to Kimitake Wakayama
 * (wakayama@elcom.nitech.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *	this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *	this list of conditions and the following disclaimer in the documentation
 *	and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software must
 *	display the following acknowledgment:
 *	"This product includes software developed by Akira Iwata Laboratory,
 *	Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *	acknowledgment:
 *	"This product includes software developed by Akira Iwata Laboratory,
 *	 Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *   AKIRA IWATA LABORATORY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *   SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 *   IN NO EVENT SHALL AKIRA IWATA LABORATORY BE LIABLE FOR ANY SPECIAL,
 *   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *   FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *   NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <aicrypto/ok_err.h>
#include <aicrypto/ok_ssl.h>
#include "ssl.h"

/*-----------------------------------------
  alloc & free & dup SSLClientHello
-----------------------------------------*/
SSLClientHello *SSL_ClientHello_new(void){
	SSLClientHello *ret;

	if((ret=(SSLClientHello*)malloc(sizeof(SSLClientHello)))==NULL){
		OK_set_error(ERR_ST_MEMALLOC,ERR_LC_SSL,ERR_PT_SSL_HELLO,NULL);
		return NULL;
	}
	memset(ret,0,sizeof(SSLClientHello));
	return ret;
}

void SSL_ClientHello_free(SSLClientHello *ch){
	if(ch==NULL) return;

	memset(ch,0,sizeof(SSLClientHello));
	free(ch);
}

SSLClientHello *SSL_ClientHello_dup(SSLClientHello *org){
	SSLClientHello *ret;

	if(org==NULL){
		OK_set_error(ERR_ST_NULLPOINTER,ERR_LC_SSL,ERR_PT_SSL_HELLO+1,NULL);
		return NULL;
	}
	if((ret=SSL_ClientHello_new())==NULL)
		return NULL;

	memcpy(ret,org,sizeof(SSLClientHello));
	return(ret);
}

/*-----------------------------------------
  allocate & free SSLServerHello
-----------------------------------------*/
SSLServerHello *SSL_ServerHello_new(void){
	SSLServerHello *ret;

	if((ret=(SSLServerHello*)malloc(sizeof(SSLServerHello)))==NULL){
		OK_set_error(ERR_ST_MEMALLOC,ERR_LC_SSL,ERR_PT_SSL_HELLO+2,NULL);
		return NULL;
	}

	memset(ret,0,sizeof(SSLServerHello));
	return ret;
}

void SSL_ServerHello_free(SSLServerHello *sh){
	if(sh==NULL) return;

	memset(sh,0,sizeof(SSLServerHello));
	free(sh);
}

SSLServerHello *SSL_ServerHello_dup(SSLServerHello *org){
	SSLServerHello *ret;

	if(org==NULL){
		OK_set_error(ERR_ST_NULLPOINTER,ERR_LC_SSL,ERR_PT_SSL_HELLO+3,NULL);
		return NULL;
	}
	if((ret = SSL_ServerHello_new())==NULL)
		return NULL;

	memcpy(ret,org,sizeof(SSLServerHello));
	return(ret);
}

