/* x509testfc.c */
/*
 * Modified by National Institute of Informatics in Japan, 2013-2014.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <aicrypto/ok_asn1.h>
#include <aicrypto/ok_pem.h>
#include <aicrypto/ok_rsa.h>
#include <aicrypto/ok_spkac.h>
#include <aicrypto/ok_tool.h>
#include <aicrypto/ok_x509.h>

#define USERSPKAC	"test.spkac"
#define USERSPKAC2	"test.spkac~"	/* for writing and reading */
#define USERKEY		"test.key"
#ifndef PATH
# define PATH	"."
#endif

/* test/getfpath.c */
char *get_fpath(char *path, char* filename);


int test_ns_spkac(){
	SPKAC *spk,*dmy;
	Key *prv;
	int i,j;
	char *fp_USERSPKAC = get_fpath(PATH, USERSPKAC);
	char *fp_USERKEY = get_fpath(PATH, USERKEY);

	/* read & verify test */
	for(i=0;i<11;i++){
		if ((spk = SPKAC_read_file(fp_USERSPKAC)) == NULL){
			printf("test SPKAC read file -- error!\n");
			return -1;
		}

		if(SPKAC_verify(spk)){
			printf("test SPKAC signature verify -- error!\n");
			return -1;
		}

		SPKAC_free(spk); spk =NULL;
		if((i%5)==0)printf("test SPKAC signature verify -- ok : %d\n",i);
	}

	/* generate & read & write test */
	for(i=0;i<11;i++){
		OK_set_passwd("abcde");
		if ((prv = (Key*)PEM_read_rsaprv(fp_USERKEY)) == NULL){
			printf("test pem read RSA key file -- error!\n");
			return -1;
		}

		/* set public key & challenge */
		if((spk=SPKAC_new())==NULL) return -1;
		if ((spk->challenge = strdup("aicry test challenge")) == NULL) return -1;

		if((spk->pubkey=(Key*)RSApubkey_new())==NULL) return -1;
		RSAprv_2pub((Prvkey_RSA*)prv,(Pubkey_RSA*)spk->pubkey);
		spk->pubkey_algo = spk->pubkey->key_type;

		/* get new one :-) */
		OK_set_cert_sig_algo(OBJ_SIG_SHA1RSA);

		if((spk->der=SPKAC_toDER(spk,prv,NULL,&j))==NULL){
			printf("cannot create DER encoding with SPKAC -- error!\n");
			return -1;
		}

		/* verify */
		if(SPKAC_verify(spk)){
			printf("test SPKAC signature verify (2)-- error!\n");
			return -1;
		}

		/* save file */
		if(pem_write(spk->der,USERSPKAC2,"","")){
			printf("test SPKAC write file -- error!\n");
			return -1;
		}
#if 1
		if((dmy=SPKAC_read_file(USERSPKAC2))==NULL){
			printf("test SPKAC read file -- error!\n");
			return -1;
		}

		ASN1_skip_(spk->der,&j);
		if(memcmp(spk->der,dmy->der,j)){
			printf("test SPKAC gen DER -- error!\n");
			ASN1_write_der(spk->der,"#errspkac1.der");
			ASN1_write_der(dmy->der,"#errspkac2.der");
			return -1;
		}
#else
		if((dmy=SPKAC_read_file(USERSPKAC))==NULL){
			printf("test SPKAC read file -- error!\n");
			return -1;
		}
		dmy->pubkey = spk->pubkey;
		
		if(!SPKAC_verify(dmy)){ /* should be error */
			printf("test SPKAC signature verify -- error!\n");
			return -1;
		}
#endif
		
		SPKAC_free(spk); spk =NULL;
		SPKAC_free(dmy); dmy =NULL;
		Key_free(prv); prv=NULL;
		if((i%5)==0)printf("test SPKAC generate & read & write -- ok : %d\n",i);
	}
	free(fp_USERSPKAC); free(fp_USERKEY);
	return 0;
}
