/* smimetestfc.c */
/*
 * Modified by National Institute of Informatics in Japan, 2013-2016.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <aicrypto/ok_asn1.h>
#include <aicrypto/ok_mime.h>
#include <aicrypto/ok_pkcs.h>
#include <aicrypto/ok_tool.h>
#include <aicrypto/ok_x509.h>

#define P12_TESTF	"test.p12"

#ifndef PATH
# define PATH	"."
#endif

/* test/getfpath.c */
char *get_fpath(char *path, char *filename);


int test_smime(){
	PKCS12	*p12;
	PKCS7	*p7;
	char *enc,*dec;
	int i;
	int algo[5]={OBJ_CRYALGO_RC2CBC,OBJ_CRYALGO_RC2CBC,OBJ_CRYALGO_RC2CBC,
		     OBJ_CRYALGO_DESCBC,OBJ_CRYALGO_3DESCBC};
	int algo_len[5]={40,64,128,64,192};
	char *fp_P12_TESTF = get_fpath(PATH, P12_TESTF);

	/* encrypt & decrypt */
	for(i=0;i<21;i++){
		char *txt = "This is sample txt file for PKCS#7 Enveloped Data...!#$%&'()==@:;testTEST :-)";

		OK_set_passwd("abcde");
		if ((p12 = P12_read_file(fp_P12_TESTF)) == NULL){
			printf("test smime encrypt : read p12 file -- error!\n");
			return -1;
		}
		OK_clear_passwd();

		OK_set_p7env_cry_algo(algo[i%5]);
		OK_set_p7env_passwd_len(algo_len[i%5]);
		
		if((enc=SMIME_p7m_encrypt(txt,(PKCS7*)p12))==NULL){
			printf("test smime encrypt %d : get pkcs7 message -- error!\n",i);
			return -1;
		}
		if((dec=SMIME_p7m_decrypt(enc,p12))==NULL){
			printf("test smime decrypt %d : get pkcs7 message -- error!\n",i);
			return -1;
		}
		if(strcmp(txt,dec)){
			printf("test smime encrypt & decrypt -- error!\n");
			return -1;
		}

		free(enc);
		free(dec);
		P12_free(p12);
		if((i%5)==0)printf("test smime encrypt & decrypt -- ok : %d\n",i);
	}

	/* signature test */
	for(i=0;i<11;i++){
		char *txt = "This is sample txt file for PKCS#7 Signed Data...!#$%&'()==@:;testTEST :-)";

		OK_set_passwd("abcde");
		if ((p12 = P12_read_file(fp_P12_TESTF)) == NULL){
			printf("test smime sign : read p12 file -- error!\n");
			return -1;
		}
		OK_clear_passwd();

		if((enc=SMIME_p7s_set_signature(txt,p12,0))==NULL){
			printf("test smime sign : set signature -- error!\n");
			return -1;
		}

		if((p7=SMIME_p7s_get_certs(enc))==NULL){
			printf("test smime sign : get certs -- error!\n");
			return -1;
		}
		P7_free(p7);

		if((p7=SMIME_p7s_get_msg(enc,&dec))==NULL){
			printf("test smime sign : get msg -- error!\n");
			return -1;
		}
		if(strcmp(dec,txt)){
			printf("test smime sign : encode msg -- error!\n");
			return -1;
		}
		if(SMIME_p7s_verify(p7,NULL,0)){
			printf("test smime sign : verify -- error!\n");
			return -1;
		}

		P7_free(p7);
		free(enc);
		free(dec);
		P12_free(p12);
		if((i%5)==0)printf("test smime signature -- ok : %d\n",i);
	}
	free(fp_P12_TESTF);

	return 0;
}
