/* mtest.c */
/*
 * Modified by National Institute of Informatics in Japan, 2014-2015.
 *
 */
/*
 * Copyright (C) 1998-2002
 * Akira Iwata & Takuto Okuno
 * Akira Iwata Laboratory,
 * Nagoya Institute of Technology in Japan.
 *
 * All rights reserved.
 *
 * This software is written by Takuto Okuno(usapato@anet.ne.jp)
 * And if you want to contact us, send an email to Kimitake Wakayama
 * (wakayama@elcom.nitech.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software must
 *    display the following acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *    Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *     Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *   AKIRA IWATA LABORATORY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *   SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 *   IN NO EVENT SHALL AKIRA IWATA LABORATORY BE LIABLE FOR ANY SPECIAL,
 *   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *   FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *   NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <aicrypto/ok_mime.h>
#include <aicrypto/ok_tool.h>
#include <aicrypto/ok_x509.h>

unsigned char *get_file2buf(char *fname,int *len);

int main(int argc, char **argv){
	char *dat,*tmp;
	Mail *mail;
	Cert *cert;
	Key  *key;
	int  i;

	if((dat=(char*)get_file2buf("mail.msg",&i))==NULL){
	  printf("cannot get file..\n");
	  exit(1);
	}

	if((mail=Mail_read_str(dat,NULL,NULL))==NULL){
	  printf("cannot get mail..\n");
	  exit(1);
	}

	fprintf(stderr,"get mail structure\n");

	Mail_print(mail);
	Mail_free(mail); free(dat);

	return 0;
}



/*-----------------------------------------------*/
#if 0
	dat=get_file2buf("2.ml",&i);
	mail=Mail_read_str(dat,NULL,NULL);
	Mail_print(mail);
	Mail_free(mail); FREE(dat);

	dat=get_file2buf("3.ml",&i);
	mail=Mail_read_str(dat,NULL,NULL);
	Mail_print(mail);
	Mail_free(mail); FREE(dat);

	dat=get_file2buf("4.ml",&i);
	mail=Mail_read_str(dat,NULL,NULL);
	Mail_print(mail);
	Mail_free(mail); FREE(dat);

	dat=get_file2buf("5.ml",&i);
	mail=Mail_read_str(dat,NULL,NULL);
	Mail_print(mail);
	Mail_free(mail); FREE(dat);

	dat=get_file2buf("6.ml",&i);
	mail=Mail_read_str(dat,NULL,NULL);
	Mail_print(mail);
	Mail_free(mail); FREE(dat);

	dat=get_file2buf("7.ml",&i);
	mail=Mail_read_str(dat,NULL,NULL);
	Mail_print(mail);
	Mail_free(mail); FREE(dat);

	dat=get_file2buf("12.ml",&i);
	mail=Mail_read_str(dat,NULL,NULL);
	Mail_print(mail);
	Mail_free(mail); FREE(dat);

/*---------------------------------------------------*/
/*
	dat=get_file2buf("9.ml",&i);
	mail=Mail_read_str(dat,NULL,NULL);
	if(mail) MBody_decode_file(mail->body);
	if(dat)  FREE(dat);
*/
	OK_set_passwd("abcde");
	key=(Key*)PEM_read_rsaprv("takuto.key");
	cert=read_cert("takuto.cer");

	dat=get_file2buf("15.ml",&i);
	tmp=SMIME_encrypt_mail(dat,cert);
	FREE(dat);

	mail=Mail_read_str(dat,cert,key);
	Mail_print(mail);
//	if(mail) MBody_decode_file(mail->body);
	Mail_free(mail);
	if(dat)  FREE(dat);

	dat=get_file2buf("16.ml",&i);
	mail=Mail_read_str(dat,cert,key);
	Mail_print(mail);
	Mail_free(mail);
	if(dat)  FREE(dat);
/*
	dat=get_file2buf("7.ml",&i);
	mail=Mail_read_str(dat);
	if(mail) MBody_decode_file(mail->body);
	if(dat)  FREE(dat);

	dat=get_file2buf("12.ml",&i);
	mail=Mail_read_str(dat);
	if(mail) MBody_decode_file(mail->body);
	if(dat)  FREE(dat);
	*/
#endif
