/* sha3testnist.h */
/*
 * Copyright (c) 2017 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/index.html.
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */

#ifndef INCLUSION_GUARD_UUID_FC7938C4_F7E3_11E6_AE70_83FA0F686D5D
#define INCLUSION_GUARD_UUID_FC7938C4_F7E3_11E6_AE70_83FA0F686D5D

#ifdef  __cplusplus
extern "C" {
#endif

#include <stdio.h>
#include <stdint.h>

#define NIST_TEST_NUM 6

struct tv
{
	size_t databitlen;
	unsigned char data[204];
};

extern struct tv nist_tv[];

/**
 * Initialize input message.
 *
 */
void init_nist_examples();

/**
 * Get expected data for SHA3-224
 *
 */
uint8_t *get_sha3_224_expected(size_t databitlen);

/**
 * Get expected data for SHA3-256
 *
 */
uint8_t *get_sha3_256_expected(size_t databitlen);

/**
 * Get expected data for SHA3-384
 *
 */
uint8_t *get_sha3_384_expected(size_t databitlen);

/**
 * Get expected data for SHA3-512
 *
 */
uint8_t *get_sha3_512_expected(size_t databitlen);

/**
 * Get expected data for SHAKE128
 *
 */
uint8_t *get_shake128_expected(size_t databitlen);

/**
 * Get expected data for SHAKE256
 *
 */
uint8_t *get_shake256_expected(size_t databitlen);

#ifdef  __cplusplus
}
#endif

#endif	/* INCLUSION_GUARD_UUID_FC7938C4_F7E3_11E6_AE70_83FA0F686D5D */
