/* sha3test.h */
/*
 * Copyright (c) 2014 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/index.html.
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */

#ifndef INCLUSION_GUARD_UUID_CCC9DCF6_BE5E_48F6_9F4F_C6BAFFCF4C1D
#define INCLUSION_GUARD_UUID_CCC9DCF6_BE5E_48F6_9F4F_C6BAFFCF4C1D

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * Compute the digest message of all SHA-3 variants
 *
 */
void test_sha3_all(unsigned char *in);

/**
 * Testcase for SHA3-224
 *
 */
int test_sha3_224();

/**
 * Testcase for SHA3-256
 *
 */
int test_sha3_256();

/**
 * Testcase for SHA3-384
 *
 */
int test_sha3_384();

/**
 * Testcase for SHA3-512
 *
 */
int test_sha3_512();

/**
 * Testcase for SHAKE128
 *
 */
int test_shake128();

/**
 * Testcase for SHAKE256
 *
 */
int test_shake256();


#ifdef  __cplusplus
}
#endif

#endif	/* INCLUSION_GUARD_UUID_CCC9DCF6_BE5E_48F6_9F4F_C6BAFFCF4C1D */
