/* sha3test.c */
/*
 * Copyright (c) 2014-2017 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/index.html.
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */

#include <stdio.h>
#include <stdlib.h>

#include "sha3test.h"
#include "sha3testnist.h"

int main(int argc, char *argv[])
{
	if (argc >= 2) {
		test_sha3_all((unsigned char *)argv[1]);
		return EXIT_SUCCESS;
	}

	init_nist_examples();

	if (test_sha3_224() != 0)
		exit(EXIT_FAILURE);
	if (test_sha3_256() != 0)
		exit(EXIT_FAILURE);
	if (test_sha3_384() != 0)
		exit(EXIT_FAILURE);
	if (test_sha3_512() != 0)
		exit(EXIT_FAILURE);
	if (test_shake128() != 0)
		exit(EXIT_FAILURE);
	if (test_shake256() != 0)
		exit(EXIT_FAILURE);

	return EXIT_SUCCESS;
}
