/* sha2test.c */
/*
 * Copyright (c) 2012-2015 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/index.html.
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */

#include <stdio.h>
#include <stdlib.h>

int test_sha2_all(char *);
int test_sha224(void);
int test_sha256(void);
int test_sha384(void);
int test_sha512(void);
int test_sha512224(void);
int test_sha512256(void);

int main(int argc, char **argv)
{
	if (argc >= 2) {
		test_sha2_all(argv[1]);
		return EXIT_SUCCESS;
	}

	if (test_sha224())
		exit(EXIT_FAILURE);
	if (test_sha256())
		exit(EXIT_FAILURE);
	if (test_sha384())
		exit(EXIT_FAILURE);
	if (test_sha512())
		exit(EXIT_FAILURE);
	if (test_sha512224())
		exit(EXIT_FAILURE);
	if (test_sha512256())
		exit(EXIT_FAILURE);
	return EXIT_SUCCESS;
}
