/* sha2.h */
/*
 * Copyright (c) 2012-2013 National Institute of Informatics in Japan, 
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/index.html.
 * If you redistribute this file, with or without modifications, you must 
 * include this notice in the file.
 */
#ifndef INCLUSION_GUARD_UUID_9E31E18C_82FF_4E9D_A45A_10B9D33D981E
#define INCLUSION_GUARD_UUID_9E31E18C_82FF_4E9D_A45A_10B9D33D981E

#ifdef  __cplusplus
extern "C" {
#endif

/* 3.2 Operations on Words */
/*
 *   3. The right shift operation SHR(X,n), where x is a w-bit
 *      word and n is an integer with 0 <= n < w.
 */
#define SHR(X,n)	((X)>>n)

/*
 *   4. The rotate right (circular right shift) operation ROTR(X,n),
 *      where x is a w-bit word and n is an integer with 0 <= n < w.
 */
#define ROTR(X,w,n)	(((X)>>n)|((X)<<(w-n)))
#define ROTR32(X,n)	ROTR(X,32,n)
#define ROTR64(X,n)	ROTR(X,64,n)

/* 4.1 Functions */
/* Ch(x,y,z) */
#define f1(B,C,D)       (((B)&(C))^((~(B))&(D)))

/* Maj(x,y,z) */
#define f3(B,C,D)       (((B)&(C))^((B)&(D))^((C)&(D)))

/* 4.1.2 SHA-224 and SHA-256 Functions */
#define SUM256_0(x) (ROTR32(x, 2)^ROTR32(x,13)^ROTR32(x,22))
#define SUM256_1(x) (ROTR32(x, 6)^ROTR32(x,11)^ROTR32(x,25))
#define sum256_0(x) (ROTR32(x, 7)^ROTR32(x,18)^SHR(x, 3))
#define sum256_1(x) (ROTR32(x,17)^ROTR32(x,19)^SHR(x,10))

/* 4.1.3 SHA-384 and SHA-512 Functions */
#define SUM512_0(x) (ROTR64(x,28)^ROTR64(x,34)^ROTR64(x,39))
#define SUM512_1(x) (ROTR64(x,14)^ROTR64(x,18)^ROTR64(x,41))
#define sum512_0(x) (ROTR64(x, 1)^ROTR64(x, 8)^SHR(x, 7))
#define sum512_1(x) (ROTR64(x,19)^ROTR64(x,61)^SHR(x, 6))

#ifdef  __cplusplus
}
#endif

#endif /* INCLUSION_GUARD_UUID_9E31E18C_82FF_4E9D_A45A_10B9D33D981E */
