/* sha1test.c */
/*
 * Modified by National Institute of Informatics in Japan, 2014-2015.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <aicrypto/ok_sha1.h>

int test_sha1()
{
	SHA1_CTX ctx;
	unsigned char ret[20], in2[1000];
	char in[] = "abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq";
	unsigned char ans1[20] = {
		0x84, 0x98, 0x3E, 0x44, 0x1C, 0x3B, 0xD2, 0x6E, 0xBA, 0xAE,
		0x4A, 0xA1, 0xF9, 0x51, 0x29, 0xE5, 0xE5, 0x46, 0x70, 0xF1
	};
	unsigned char ans2[20] = {
		0x34, 0xAA, 0x97, 0x3C, 0xD4, 0xC4, 0xDA, 0xA4, 0xF6, 0x1E,
		0xEB, 0x2B, 0xDB, 0xAD, 0x27, 0x31, 0x65, 0x34, 0x01, 0x6F
	};
	unsigned char ans3[20] = {	/* size 0 */
		0xda, 0x39, 0xa3, 0xee, 0x5e, 0x6b, 0x4b, 0x0d,
		0x32, 0x55, 0xbf, 0xef, 0x95, 0x60, 0x18, 0x90,
		0xaf, 0xd8, 0x07, 0x09
	};
	int i;

	/* test 1 */
	OK_SHA1(strlen(in), (unsigned char *)in, ret);
	if (memcmp(ret, ans1, 20)) {
		printf("error : test sha1 1\n");
		return EXIT_FAILURE;
	} else {
		printf("test sha1 ok -- 1\n");
	}
	/* test 2 */
	memset(in2, 'a', 1000);
	SHA1init(&ctx);
	for (i = 0; i < 1000; i++)
		SHA1update(&ctx, in2, 1000);
	SHA1final(ret, &ctx);

	if (memcmp(ret, ans2, 20)) {
		printf("error : test sha1 2\n");
		return EXIT_FAILURE;
	} else {
		printf("test sha1 ok -- 2\n");
	}
	/* Test size 0 */
	OK_SHA1(0, (unsigned char *)in, ret);
	if (memcmp(ret, ans3, 20)) {
		printf("error : test sha1 3\n");
		return EXIT_FAILURE;
	} else {
		printf("test sha1 ok -- 3\n");
	}

	return EXIT_SUCCESS;
}
