/* siggenPSS_3_2048_testfc.c */
/*
 * Copyright (c) 2017 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/index.html.
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */

/*
 * This test vector was created based on SigGen15_186-3.txt from
 * https://csrc.nist.gov/CSRC/media/Projects/Cryptographic-Algorithm-Validation-Program/documents/dss/186-3rsatestvectors.zip
 *
 * The link to the archive file exists in the following URL:
 * https://csrc.nist.gov/projects/cryptographic-algorithm-validation-program/digital-signatures/
 */
/*
 * https://csrc.nist.gov/projects/cryptographic-algorithm-validation-program/digital-signatures/
 * https://csrc.nist.gov/CSRC/media/Projects/Cryptographic-Algorithm-Validation-Program/documents/dss/186-3rsatestvectors.zip
 * SigGenPSS_186-3.txt
 */ 
#include "siggenPSStest.h"

static const unsigned short sn1[] = {
	0xc506, 0x2b58, 0xd853, 0x9c76, 0x5e1e, 0x5dba, 0xf14c, 0xf75d,
	0xd56c, 0x2e13, 0x105f, 0xecfd, 0x1a93, 0x0bbb, 0x5948, 0xff32,
	0x8f12, 0x6abe, 0x7793, 0x59ca, 0x59bc, 0xa752, 0xc308, 0xd281,
	0x573b, 0xc617, 0x8b6c, 0x0fef, 0x7dc4, 0x45e4, 0xf826, 0x4304,
	0x37b9, 0xf9d7, 0x9058, 0x1de5, 0x749c, 0x2cb9, 0xcb26, 0xd42b,
	0x2fee, 0x15b6, 0xb26f, 0x09c9, 0x9670, 0x3364, 0x23b8, 0x6bc5,
	0xbec7, 0x1113, 0x157b, 0xe2d9, 0x44d7, 0xff3e, 0xebff, 0xb284,
	0x1314, 0x3ea3, 0x6755, 0xdb0a, 0xe62f, 0xf5b7, 0x24ee, 0xcb3d,
	0x316b, 0x6bac, 0x67e8, 0x9cac, 0xd817, 0x1937, 0xe2ab, 0x19bd,
	0x353a, 0x89ac, 0xea8c, 0x36f8, 0x1c89, 0xa620, 0xd5fd, 0x2eff,
	0xea89, 0x6601, 0xc7f9, 0xdaca, 0x7f03, 0x3f63, 0x5a3a, 0x9433,
	0x31d1, 0xb1b4, 0xf528, 0x8790, 0xb53a, 0xf352, 0xf112, 0x1ca1,
	0xbef2, 0x05f4, 0x0dc0, 0x12c4, 0x12b4, 0x0bdd, 0x2758, 0x5b94,
	0x6466, 0xd75f, 0x7ee0, 0xa7f9, 0xd549, 0xb4be, 0xce6f, 0x43ac,
	0x3ee6, 0x5fe7, 0xfd37, 0x1233, 0x59d9, 0xf1a8, 0x50ad, 0x450a,
	0xaf5c, 0x94eb, 0x11de, 0xa3fc, 0x0fc6, 0xe985, 0x6b18, 0x05ef,
};

static const unsigned short se1[] = {
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0086, 0xc94f,
};

static const unsigned short sd1[] = {
	0x49e5, 0x786b, 0xb4d3, 0x32f9, 0x4586, 0x327b, 0xde08, 0x8875,
	0x379b, 0x75d1, 0x2848, 0x8f08, 0xe574, 0xab47, 0x1530, 0x2a87,
	0xeea5, 0x2d4c, 0x4a23, 0xd8b9, 0x7af7, 0x9448, 0x0433, 0x7c5f,
	0x55e1, 0x6ba9, 0xffaf, 0xc0c9, 0xfd9b, 0x88ec, 0xa443, 0xf39b,
	0x7967, 0x170d, 0xdb8c, 0xe7dd, 0xb93c, 0x6087, 0xc806, 0x6c4a,
	0x9553, 0x8a44, 0x1b9d, 0xc80d, 0xc9f7, 0x8100, 0x54fd, 0x1e5c,
	0x9d02, 0x50c9, 0x78bb, 0x2d74, 0x8abe, 0x1e94, 0x65d7, 0x1a81,
	0x65d3, 0x126d, 0xce5d, 0xb2ad, 0xacc0, 0x03e9, 0x062b, 0xa37a,
	0x54b6, 0x3e5f, 0x49a4, 0xeafe, 0xbd7e, 0x4bf5, 0xb0a7, 0x96c2,
	0xb3a9, 0x50fa, 0x09c7, 0x98d3, 0xfa3e, 0x86c4, 0xb62c, 0x33ba,
	0x9365, 0xeda0, 0x54e5, 0xfe74, 0xa41f, 0x21b5, 0x9502, 0x6acf,
	0x1093, 0xc90a, 0x8c71, 0x722f, 0x91af, 0x1ed2, 0x9a41, 0xa244,
	0x9a32, 0x0fc7, 0xba31, 0x20e3, 0xe8c3, 0xe424, 0x0c04, 0x925c,
	0xc698, 0xecd6, 0x6c7c, 0x906b, 0xdf24, 0x0ada, 0xd972, 0xb4df,
	0xf486, 0x9d40, 0x0b5d, 0x13e3, 0x3eeb, 0xa38e, 0x075e, 0x872b,
	0x0ed3, 0xe91c, 0xc9c2, 0x8386, 0x7a4f, 0xfc39, 0x01d2, 0x069f,
};

#define HAS_SHA224_TESTVECTOR

#define HAS_SHA256_TESTVECTOR

#define HAS_SHA384_TESTVECTOR

#define HAS_SHA512_TESTVECTOR

/* 10 elements */
static mod2048_t SHA224[] = {
	/* SHA224 [0] */
	{
		/* Msg0 : 128 byte */
		{
			0x37, 0xdd, 0xd9, 0x90, 0x14, 0x78, 0xae, 0x5c,
			0x16, 0x87, 0x87, 0x02, 0xce, 0xa4, 0xa1, 0x9e,
			0x78, 0x6d, 0x35, 0x58, 0x2d, 0xe4, 0x4a, 0xe6,
			0x5a, 0x16, 0xcd, 0x53, 0x70, 0xfb, 0xe3, 0xff,
			0xdd, 0x9e, 0x7e, 0xe8, 0x3c, 0x7d, 0x2f, 0x27,
			0xc8, 0x33, 0x3b, 0xbe, 0x17, 0x54, 0xf0, 0x90,
			0x05, 0x99, 0x39, 0xb1, 0xee, 0x3d, 0x71, 0xe0,
			0x20, 0xa6, 0x75, 0x52, 0x8f, 0x48, 0xfd, 0xb2,
			0xcb, 0xc7, 0x2c, 0x65, 0x30, 0x5b, 0x65, 0x12,
			0x5c, 0x79, 0x61, 0x62, 0xe7, 0xb0, 0x7e, 0x04,
			0x4e, 0xd1, 0x5a, 0xf5, 0x2f, 0x52, 0xa1, 0xfe,
			0xbc, 0xf4, 0x23, 0x7e, 0x6a, 0xa4, 0x2a, 0x69,
			0xe9, 0x9f, 0x0a, 0x91, 0x59, 0xda, 0xf9, 0x24,
			0xbb, 0xa1, 0x21, 0x76, 0xa5, 0x7e, 0xf4, 0x01,
			0x3a, 0x5c, 0xc0, 0xab, 0x5a, 0xec, 0x83, 0x47,
			0x16, 0x48, 0x00, 0x5d, 0x67, 0xd7, 0x12, 0x2e,
		},
		/* S0 : 256 byte */
		{
			0x7e, 0x62, 0x8b, 0xcb, 0xe6, 0xff, 0x83, 0xa9,
			0x37, 0xb8, 0x96, 0x11, 0x97, 0xd8, 0xbd, 0xbb,
			0x32, 0x28, 0x18, 0xaa, 0x8b, 0xdf, 0x30, 0xcd,
			0xfb, 0x67, 0xca, 0x6b, 0xf0, 0x25, 0xef, 0x6f,
			0x09, 0xa9, 0x9d, 0xba, 0x4c, 0x3e, 0xe2, 0x80,
			0x7d, 0x0b, 0x7c, 0x77, 0x77, 0x6c, 0xfe, 0xff,
			0x33, 0xb6, 0x8d, 0x7e, 0x3f, 0xa8, 0x59, 0xc4,
			0x68, 0x86, 0x26, 0xb2, 0x44, 0x18, 0x97, 0xd2,
			0x6e, 0x5d, 0x6b, 0x55, 0x9d, 0xd7, 0x2a, 0x59,
			0x6e, 0x7d, 0xad, 0x7d, 0xef, 0x92, 0x78, 0x41,
			0x9d, 0xb3, 0x75, 0xf7, 0xc6, 0x7c, 0xee, 0x07,
			0x40, 0x39, 0x45, 0x02, 0x21, 0x2e, 0xbd, 0xd4,
			0xa6, 0xc8, 0xd3, 0xaf, 0x6e, 0xe2, 0xfd, 0x69,
			0x6d, 0x85, 0x23, 0xde, 0x69, 0x08, 0x49, 0x2b,
			0x7c, 0xbf, 0x22, 0x54, 0xf1, 0x5a, 0x34, 0x89,
			0x56, 0xc1, 0x98, 0x40, 0xdc, 0x15, 0xa3, 0xd7,
			0x32, 0xef, 0x86, 0x2b, 0x62, 0xed, 0xe0, 0x22,
			0x29, 0x0d, 0xe3, 0xaf, 0x11, 0xca, 0x5e, 0x79,
			0xa3, 0x39, 0x2f, 0xff, 0x06, 0xf7, 0x5a, 0xca,
			0x8c, 0x88, 0xa2, 0xde, 0x18, 0x58, 0xb3, 0x5a,
			0x21, 0x6d, 0x8f, 0x73, 0xfd, 0x70, 0xe9, 0xd6,
			0x79, 0x58, 0xed, 0x39, 0xa6, 0xf8, 0x97, 0x6f,
			0xb9, 0x4e, 0xc6, 0xe6, 0x1f, 0x23, 0x8a, 0x52,
			0xf9, 0xd4, 0x22, 0x41, 0xe8, 0x35, 0x4f, 0x89,
			0xe3, 0xec, 0xe9, 0x4d, 0x6f, 0xa5, 0xbf, 0xbb,
			0xa1, 0xee, 0xb7, 0x0e, 0x16, 0x98, 0xbf, 0xf3,
			0x1a, 0x68, 0x5f, 0xbe, 0x79, 0x9f, 0xb4, 0x4e,
			0xfe, 0x21, 0x33, 0x8e, 0xd6, 0xee, 0xa2, 0x12,
			0x91, 0x55, 0xaa, 0xbc, 0x09, 0x43, 0xbc, 0x9f,
			0x69, 0xa8, 0xe5, 0x88, 0x97, 0xdb, 0x6a, 0x8a,
			0xbc, 0xc2, 0x87, 0x9d, 0x5d, 0x0c, 0x5d, 0x3e,
			0x6d, 0xc5, 0xeb, 0x48, 0xcf, 0x16, 0xda, 0xc8,
		},
		15, /* salt length */
		/* V0 : 15 byte */
		{
			0x46, 0x37, 0x29, 0xb3, 0xea, 0xf4, 0x35, 0x02,
			0xd9, 0xcf, 0xf1, 0x29, 0x92, 0x56, 0x81, 
		},
	},
	/* SHA224 [1] */
	{
		/* Msg1 : 128 byte */
		{
			0x5c, 0x61, 0x54, 0x6b, 0x84, 0x8a, 0x36, 0xe8,
			0xe5, 0x1f, 0x8b, 0xeb, 0x11, 0x40, 0x82, 0x3d,
			0xbd, 0x95, 0xb0, 0x66, 0x60, 0x92, 0x4d, 0x16,
			0xfd, 0xf9, 0xa1, 0xc3, 0x3c, 0xa0, 0xb9, 0x94,
			0xc0, 0x74, 0x5e, 0x7e, 0xb5, 0xbe, 0x48, 0xad,
			0xa8, 0xa5, 0x8e, 0x25, 0x9c, 0xf4, 0x61, 0xa9,
			0x5a, 0x1e, 0xfa, 0xdb, 0x08, 0x80, 0xd1, 0xa6,
			0xfd, 0xe5, 0x10, 0xd9, 0xd4, 0x4f, 0x47, 0x14,
			0xbf, 0xf5, 0x61, 0xe8, 0x1e, 0x88, 0xd7, 0x3a,
			0x51, 0xba, 0x23, 0xe8, 0xca, 0x01, 0x78, 0xb0,
			0x66, 0x98, 0xb0, 0x4d, 0xfd, 0xc8, 0x86, 0xe2,
			0x38, 0x65, 0x05, 0x9c, 0xa2, 0x9b, 0x40, 0x93,
			0x02, 0xeb, 0x44, 0xf2, 0xe9, 0x70, 0x4b, 0x58,
			0x87, 0x67, 0x32, 0x7e, 0xc2, 0xee, 0x2d, 0x19,
			0x8a, 0x0c, 0xba, 0x02, 0x66, 0xf2, 0xd3, 0x94,
			0x53, 0x80, 0x68, 0x55, 0xcf, 0x0b, 0x0c, 0xd9,
		},
		/* S1 : 256 byte */
		{
			0x13, 0x4e, 0x6a, 0xcd, 0x94, 0xb7, 0x6a, 0x86,
			0xe7, 0xff, 0x73, 0x0f, 0x06, 0x4a, 0x3d, 0x48,
			0x0d, 0x1c, 0xff, 0x16, 0x87, 0xb9, 0x93, 0x16,
			0x3c, 0xe0, 0x9f, 0x21, 0xd4, 0x94, 0xa4, 0xa1,
			0x5e, 0x6d, 0x92, 0x75, 0x8a, 0x93, 0xf7, 0xc8,
			0x3e, 0xad, 0x21, 0xc4, 0xca, 0x29, 0x0f, 0x94,
			0x78, 0x24, 0x1c, 0x98, 0x11, 0xc2, 0x31, 0xf3,
			0x2d, 0x9d, 0x17, 0xe0, 0xb4, 0x79, 0xa9, 0xb3,
			0x4c, 0xad, 0x02, 0xe5, 0xbb, 0xdd, 0xe6, 0xc8,
			0xe4, 0xec, 0x4f, 0x35, 0xf9, 0x35, 0x24, 0xf8,
			0xaf, 0xde, 0x49, 0xe6, 0xa4, 0x74, 0x0b, 0xab,
			0x2f, 0x2f, 0xde, 0xff, 0x3f, 0xc5, 0xd9, 0x2a,
			0x1b, 0x50, 0xad, 0xc7, 0xaf, 0x96, 0x4e, 0xec,
			0x82, 0xfb, 0x80, 0xbe, 0x24, 0x09, 0x2a, 0xb2,
			0x87, 0x91, 0x80, 0x7c, 0x66, 0x4a, 0x91, 0x06,
			0xb5, 0xdf, 0x32, 0x96, 0x74, 0x7c, 0x01, 0x4b,
			0x75, 0xd6, 0x9d, 0x18, 0x1f, 0x2e, 0x58, 0xda,
			0xfb, 0xbf, 0x91, 0x27, 0x16, 0x4f, 0x88, 0xc8,
			0x62, 0xa4, 0x8d, 0x5e, 0x9e, 0xdc, 0xd6, 0xd2,
			0xb2, 0xcb, 0xc2, 0x0a, 0xbc, 0xeb, 0x0e, 0x98,
			0xc7, 0xe7, 0x31, 0xd2, 0x7c, 0x8d, 0x04, 0xfa,
			0xd9, 0x5f, 0xf5, 0x0d, 0xd6, 0x4a, 0xf2, 0x0e,
			0x63, 0x88, 0xed, 0x74, 0xb9, 0xb3, 0xcf, 0x33,
			0xb4, 0xa3, 0x16, 0xb0, 0xc7, 0x52, 0xf3, 0x36,
			0x97, 0xe5, 0xa7, 0x44, 0x5a, 0xe2, 0xf7, 0x26,
			0xf3, 0x03, 0x33, 0xf1, 0x07, 0x92, 0x88, 0x72,
			0x77, 0x62, 0x25, 0xa3, 0xe0, 0xb1, 0xb1, 0x4a,
			0x7e, 0x84, 0xf9, 0xa6, 0x95, 0xc7, 0xb3, 0x91,
			0x03, 0x30, 0xd2, 0x25, 0xb4, 0x83, 0x41, 0x10,
			0xb5, 0x4d, 0x6b, 0x05, 0xe6, 0x9d, 0xf6, 0xb7,
			0xa2, 0xc9, 0xdc, 0x35, 0x29, 0x42, 0xe3, 0xbc,
			0xe9, 0x70, 0xce, 0xc6, 0x77, 0x25, 0x32, 0x30,
		},
		15, /* salt length */
		/* V1 : 15 byte */
		{
			0x46, 0x37, 0x29, 0xb3, 0xea, 0xf4, 0x35, 0x02,
			0xd9, 0xcf, 0xf1, 0x29, 0x92, 0x56, 0x81, 
		},
	},
	/* SHA224 [2] */
	{
		/* Msg2 : 128 byte */
		{
			0x75, 0x40, 0xed, 0xea, 0x54, 0xa4, 0xfa, 0x57,
			0x96, 0x84, 0xa5, 0xb5, 0x9c, 0x51, 0xeb, 0x20,
			0xe6, 0x11, 0x06, 0xf8, 0x21, 0x57, 0x91, 0x7c,
			0x61, 0x73, 0xee, 0x9b, 0xab, 0xe6, 0xe5, 0x06,
			0xb6, 0x19, 0x8d, 0x8a, 0xf2, 0x4e, 0x70, 0x9d,
			0xca, 0xd6, 0xea, 0x37, 0x26, 0x84, 0xd2, 0xe3,
			0x35, 0x63, 0x5c, 0x15, 0x69, 0xa4, 0x3e, 0xbe,
			0xc3, 0xda, 0x12, 0x1e, 0x50, 0x6a, 0xfc, 0xd9,
			0xf4, 0x3c, 0x8c, 0x4e, 0x66, 0xb7, 0xe6, 0x24,
			0x7c, 0xed, 0x20, 0x25, 0xa9, 0x12, 0xeb, 0x50,
			0xc4, 0x33, 0x76, 0x29, 0x0a, 0x24, 0x8f, 0x54,
			0x67, 0xbb, 0x0c, 0x62, 0xf1, 0x3b, 0x69, 0xeb,
			0xb5, 0x13, 0xb2, 0xdd, 0xb7, 0xc9, 0xa3, 0x13,
			0x34, 0x31, 0x0f, 0x2a, 0x2a, 0xe2, 0x7e, 0x90,
			0x1b, 0xea, 0x1a, 0xdd, 0x0d, 0xc1, 0xcc, 0x67,
			0xd5, 0x7c, 0xa2, 0x10, 0x95, 0x43, 0x74, 0x63,
		},
		/* S2 : 256 byte */
		{
			0x45, 0x54, 0x1a, 0xa6, 0x5f, 0xbb, 0x07, 0x73,
			0xb1, 0x43, 0x4c, 0x4f, 0xda, 0xaf, 0xe2, 0x3f,
			0xe8, 0x00, 0xf7, 0x8e, 0xba, 0x90, 0x0c, 0x61,
			0x04, 0xa6, 0xf0, 0xe7, 0x6d, 0xc0, 0x8d, 0xae,
			0xdc, 0x28, 0xa3, 0x38, 0x0c, 0x80, 0x78, 0xf8,
			0x20, 0x55, 0xcd, 0x4a, 0x20, 0xcf, 0x30, 0x54,
			0x1c, 0x32, 0xd9, 0xac, 0x62, 0x53, 0x78, 0x35,
			0x5c, 0x15, 0x68, 0x80, 0xb3, 0x5a, 0x29, 0x64,
			0x53, 0x25, 0xd4, 0x88, 0xf7, 0xa0, 0xd2, 0xde,
			0x7d, 0xf9, 0x2c, 0xf9, 0xbc, 0xcd, 0xf8, 0x51,
			0x44, 0x5c, 0x2b, 0x83, 0x4a, 0xd0, 0xe6, 0x84,
			0x9a, 0x65, 0x49, 0xdb, 0x72, 0xaf, 0xfa, 0x7c,
			0xe6, 0x6f, 0xbb, 0xfc, 0x5b, 0xc0, 0x19, 0x45,
			0x04, 0xa5, 0xfb, 0x03, 0x12, 0x67, 0xb6, 0xca,
			0x9b, 0x57, 0xf5, 0x83, 0xe7, 0xe1, 0x1c, 0x92,
			0x7e, 0x3d, 0xc2, 0x03, 0xf7, 0xd6, 0xd4, 0xb9,
			0xdf, 0x67, 0x5d, 0x2a, 0x30, 0x22, 0x31, 0x40,
			0x00, 0x08, 0xfb, 0xbd, 0x4a, 0x05, 0xe1, 0x7f,
			0x88, 0xbe, 0xa0, 0x74, 0xde, 0x9a, 0xb8, 0x21,
			0x1a, 0x18, 0xdc, 0xce, 0xae, 0x6c, 0x9f, 0xd8,
			0xfa, 0xd9, 0x6c, 0xe0, 0x62, 0x6e, 0xb2, 0x5c,
			0x9a, 0xb8, 0x1d, 0xf5, 0x5b, 0xa4, 0xd0, 0xa6,
			0xae, 0x01, 0xeb, 0x25, 0xa2, 0x52, 0x9e, 0x16,
			0xc9, 0x8d, 0xed, 0x28, 0x6c, 0xb3, 0x45, 0xd4,
			0xfd, 0x59, 0x12, 0x42, 0x97, 0xba, 0x9b, 0x3e,
			0xfc, 0xb6, 0x78, 0x84, 0xed, 0x85, 0x3e, 0xa9,
			0x6d, 0x74, 0xe0, 0x09, 0x51, 0x98, 0x7b, 0xcd,
			0xa5, 0x4d, 0x40, 0x4d, 0x08, 0xf2, 0xba, 0xf7,
			0xf0, 0xd7, 0xff, 0x13, 0xd8, 0x1d, 0x1f, 0xa2,
			0x0c, 0xde, 0x1d, 0x21, 0x66, 0x36, 0x84, 0xc1,
			0x3f, 0xfc, 0x71, 0x64, 0x44, 0x8f, 0x4e, 0x85,
			0xa6, 0xc8, 0x11, 0xa8, 0x50, 0xa3, 0xfa, 0xed,
		},
		15, /* salt length */
		/* V2 : 15 byte */
		{
			0x46, 0x37, 0x29, 0xb3, 0xea, 0xf4, 0x35, 0x02,
			0xd9, 0xcf, 0xf1, 0x29, 0x92, 0x56, 0x81, 
		},
	},
	/* SHA224 [3] */
	{
		/* Msg3 : 128 byte */
		{
			0x84, 0x0f, 0xf3, 0x29, 0x93, 0x22, 0x3e, 0xfe,
			0x34, 0x1e, 0xeb, 0x55, 0x55, 0x8e, 0x6a, 0xb1,
			0xfb, 0xae, 0x15, 0xd1, 0x7b, 0xcf, 0x07, 0x31,
			0xed, 0xfd, 0x32, 0xd4, 0xde, 0xe0, 0xac, 0x41,
			0x45, 0xe0, 0x4a, 0xcc, 0xb8, 0x8c, 0x70, 0x16,
			0xe0, 0x3d, 0x27, 0xd7, 0x2b, 0xf6, 0x70, 0xdb,
			0xc0, 0x8f, 0xd9, 0x4b, 0xb8, 0x13, 0x4d, 0x2e,
			0x8b, 0x66, 0x30, 0x2f, 0xc8, 0x2b, 0xac, 0xa1,
			0x0a, 0xe4, 0x45, 0xc0, 0x27, 0x5b, 0xb4, 0x3a,
			0xaa, 0x42, 0xf2, 0xee, 0x84, 0x16, 0x93, 0xf3,
			0xfe, 0x49, 0x55, 0xdc, 0xf2, 0x9f, 0xf9, 0x3a,
			0x3b, 0xd9, 0x51, 0x63, 0x6a, 0x91, 0x9b, 0x72,
			0xba, 0x65, 0x0d, 0x8f, 0x47, 0x57, 0xb1, 0x71,
			0x7a, 0x74, 0x73, 0x20, 0xc8, 0xb4, 0x79, 0x00,
			0x9c, 0x22, 0xb2, 0x0b, 0x91, 0x3c, 0xb2, 0x5e,
			0xe5, 0x9d, 0xbd, 0xf7, 0x2b, 0xd9, 0x21, 0xbd,
		},
		/* S3 : 256 byte */
		{
			0x07, 0xf0, 0x7e, 0xf5, 0xe7, 0x93, 0xd5, 0x9b,
			0x0c, 0x3f, 0x89, 0x9d, 0xc8, 0x46, 0xbb, 0x83,
			0x1d, 0x88, 0xdd, 0x4d, 0x2d, 0x83, 0x45, 0xad,
			0x2d, 0x72, 0x6c, 0x5c, 0x53, 0x2d, 0x13, 0xe0,
			0x5b, 0x26, 0xf0, 0xfd, 0x03, 0xb2, 0xb9, 0xbd,
			0xe7, 0xb6, 0xd5, 0xb6, 0xfe, 0xbc, 0x8f, 0xe5,
			0xd3, 0x22, 0x88, 0x87, 0xea, 0xc4, 0x43, 0xc9,
			0x9e, 0xc3, 0x9f, 0xff, 0xeb, 0x93, 0x97, 0x85,
			0xf8, 0x7b, 0xe8, 0xa9, 0x3e, 0x49, 0x7c, 0xfd,
			0xea, 0x3d, 0x8d, 0x06, 0x35, 0x65, 0x18, 0xa5,
			0x25, 0x4c, 0x59, 0x46, 0x23, 0x64, 0x58, 0xb2,
			0x9f, 0x1c, 0xd4, 0x7e, 0x97, 0x71, 0x8c, 0x80,
			0x5b, 0x16, 0x77, 0x91, 0xd1, 0x0f, 0x93, 0x04,
			0x32, 0x86, 0x35, 0x33, 0x01, 0x16, 0xa2, 0xae,
			0xae, 0x1e, 0x0e, 0xcc, 0x16, 0xbf, 0xd5, 0xa3,
			0x13, 0x56, 0xd0, 0x68, 0x92, 0xb8, 0xca, 0x04,
			0xae, 0xc2, 0x7a, 0x41, 0x73, 0x20, 0xbe, 0x7b,
			0xf6, 0xfc, 0x10, 0x83, 0xd7, 0x0f, 0xa5, 0x22,
			0xc2, 0x38, 0x50, 0xf5, 0xd6, 0xbe, 0xda, 0x1a,
			0x25, 0x1d, 0x1a, 0x5e, 0x71, 0x76, 0x2b, 0xc8,
			0xfd, 0x5f, 0x16, 0xef, 0x0c, 0x7a, 0x96, 0x1f,
			0x48, 0x58, 0xa5, 0xb7, 0x60, 0xa8, 0x03, 0x2f,
			0x3f, 0xd6, 0xbd, 0xce, 0x2e, 0xd2, 0x63, 0x51,
			0xf2, 0xbe, 0xab, 0x8b, 0x89, 0xd9, 0x31, 0x2d,
			0x88, 0x73, 0x6e, 0xe5, 0x25, 0x3a, 0x9d, 0xa6,
			0x75, 0x32, 0x83, 0xe5, 0xb3, 0xd0, 0xd9, 0xcd,
			0xd3, 0xe1, 0x9c, 0xa0, 0xb6, 0x0b, 0x9f, 0xae,
			0x3e, 0x3d, 0xfd, 0x67, 0x83, 0x1d, 0xf7, 0x2e,
			0xd9, 0x61, 0x1d, 0x5f, 0x2b, 0x3a, 0xc2, 0x56,
			0x05, 0x2a, 0x20, 0x7a, 0x52, 0x45, 0xd2, 0xcd,
			0xea, 0xad, 0x0d, 0x12, 0x66, 0xc7, 0x17, 0x7b,
			0x1a, 0x08, 0x44, 0xd5, 0x97, 0x4a, 0x8a, 0x41,
		},
		15, /* salt length */
		/* V3 : 15 byte */
		{
			0x46, 0x37, 0x29, 0xb3, 0xea, 0xf4, 0x35, 0x02,
			0xd9, 0xcf, 0xf1, 0x29, 0x92, 0x56, 0x81, 
		},
	},
	/* SHA224 [4] */
	{
		/* Msg4 : 128 byte */
		{
			0xa5, 0xfb, 0x39, 0x6e, 0xee, 0x40, 0x45, 0xf8,
			0x86, 0x19, 0x1f, 0x7f, 0xf9, 0xea, 0x68, 0xaa,
			0xa1, 0xbc, 0xd8, 0xe7, 0x81, 0x90, 0x3b, 0x60,
			0x71, 0xf3, 0xba, 0x2b, 0x7c, 0xd3, 0x5c, 0xc0,
			0x86, 0x91, 0xcd, 0xb1, 0x31, 0x57, 0x5d, 0x95,
			0x02, 0xac, 0x4b, 0x45, 0xc0, 0x46, 0x44, 0x4c,
			0x1d, 0x1f, 0x27, 0x98, 0x99, 0xcb, 0x0b, 0x76,
			0xa2, 0x08, 0x83, 0xbd, 0x00, 0x97, 0x21, 0x48,
			0x70, 0x4a, 0x38, 0xaa, 0x8f, 0x5f, 0xe6, 0x1e,
			0xfa, 0x0c, 0x52, 0xbd, 0xb4, 0x5b, 0x33, 0xf4,
			0xc8, 0x38, 0x92, 0x34, 0x2f, 0xc8, 0xd0, 0xeb,
			0xf3, 0xfd, 0xea, 0xb4, 0x95, 0x68, 0xfc, 0xca,
			0xad, 0x4e, 0x04, 0xc3, 0xd0, 0xfd, 0xe9, 0x7b,
			0xb6, 0x60, 0xbc, 0x4e, 0x9c, 0xd2, 0x3d, 0x8a,
			0xe8, 0x30, 0xa1, 0x23, 0x0c, 0x32, 0x92, 0xa9,
			0xac, 0xfb, 0x78, 0x78, 0x03, 0xee, 0xf7, 0x2f,
		},
		/* S4 : 256 byte */
		{
			0x44, 0x28, 0xc3, 0x89, 0xd0, 0xc8, 0x0a, 0x93,
			0x20, 0xe4, 0x85, 0x9e, 0x41, 0xcb, 0xd4, 0xa4,
			0x7f, 0x78, 0xe4, 0xda, 0x5d, 0x1c, 0x06, 0x44,
			0xff, 0x50, 0xba, 0xd1, 0x72, 0xde, 0x9f, 0xfe,
			0x74, 0xd8, 0x4a, 0x76, 0xd6, 0xde, 0x4f, 0x72,
			0xbb, 0xe3, 0x4d, 0x7d, 0xcc, 0xaa, 0x03, 0xe1,
			0x32, 0x40, 0x41, 0xcb, 0x98, 0x30, 0x8d, 0x73,
			0xdc, 0xff, 0x0b, 0xcf, 0x7f, 0xfc, 0x35, 0x93,
			0x64, 0x73, 0xcf, 0x3e, 0xc5, 0x3c, 0x66, 0xea,
			0x8a, 0x61, 0x35, 0x74, 0x2e, 0x0e, 0xa9, 0x05,
			0x6a, 0x48, 0x97, 0xa7, 0xcb, 0xd2, 0xb0, 0x65,
			0x4b, 0x34, 0x47, 0x86, 0xbf, 0x30, 0x47, 0xd1,
			0x22, 0xdc, 0xbb, 0xc4, 0xbe, 0xa1, 0x84, 0x0e,
			0x84, 0xbc, 0xe0, 0x66, 0xc3, 0x38, 0x5d, 0xcc,
			0xb0, 0x21, 0xa7, 0x9e, 0x8d, 0xe1, 0x8d, 0xc1,
			0x14, 0xa4, 0x0d, 0x82, 0x41, 0x41, 0xd8, 0x33,
			0x1a, 0x4d, 0xf6, 0x90, 0x1b, 0x34, 0x09, 0xc3,
			0x05, 0x52, 0x51, 0x9b, 0x09, 0x7a, 0x96, 0xde,
			0xd6, 0x79, 0x3c, 0xbb, 0x9a, 0xe1, 0x8b, 0xb9,
			0xa4, 0x18, 0x5b, 0x6f, 0x4e, 0x83, 0xaa, 0xd6,
			0xdc, 0xe8, 0x78, 0xc6, 0x89, 0xbf, 0x59, 0x5d,
			0x27, 0x27, 0x19, 0xb9, 0xf5, 0x0b, 0x3e, 0xde,
			0x18, 0x03, 0xdf, 0xae, 0x6d, 0xd3, 0xf5, 0x4e,
			0x4c, 0xa9, 0xc4, 0x58, 0xc1, 0x44, 0x63, 0xf4,
			0xf1, 0x9a, 0xf6, 0xcc, 0x81, 0x27, 0xbe, 0xc8,
			0x0a, 0x6a, 0x9e, 0x5a, 0x5f, 0xe0, 0xd3, 0xe1,
			0x4d, 0xfc, 0xc6, 0xba, 0x05, 0x27, 0x50, 0xeb,
			0xbf, 0x84, 0xa6, 0x52, 0xad, 0xde, 0x9d, 0x6b,
			0xe6, 0x8d, 0x5b, 0x13, 0x4c, 0xd0, 0x9b, 0xb9,
			0x4d, 0x08, 0x75, 0xe5, 0x52, 0x7f, 0xe3, 0xf3,
			0xfa, 0x2a, 0x51, 0x6d, 0xc0, 0x5c, 0x14, 0xfd,
			0x55, 0x16, 0xdf, 0xf2, 0xd4, 0x34, 0xf0, 0xc4,
		},
		15, /* salt length */
		/* V4 : 15 byte */
		{
			0x46, 0x37, 0x29, 0xb3, 0xea, 0xf4, 0x35, 0x02,
			0xd9, 0xcf, 0xf1, 0x29, 0x92, 0x56, 0x81, 
		},
	},
	/* SHA224 [5] */
	{
		/* Msg5 : 128 byte */
		{
			0x6e, 0x89, 0x15, 0x89, 0xd7, 0x1d, 0x2e, 0xff,
			0x6c, 0xb9, 0x86, 0xb0, 0x71, 0xa3, 0x1e, 0x26,
			0x96, 0xd8, 0xce, 0x67, 0x1f, 0xa1, 0x8c, 0x24,
			0x42, 0x67, 0xeb, 0x33, 0xd0, 0xc8, 0xe2, 0x40,
			0x18, 0xeb, 0xcf, 0xbf, 0x09, 0x10, 0xbb, 0x24,
			0x96, 0x6b, 0xe0, 0x57, 0x5f, 0x32, 0x68, 0x62,
			0x8d, 0xf5, 0x78, 0x6d, 0xfd, 0x2e, 0x6d, 0xed,
			0xa2, 0x19, 0x66, 0x18, 0x24, 0xc5, 0x02, 0x9c,
			0xcd, 0x6b, 0x6b, 0x90, 0xa6, 0x00, 0x93, 0xab,
			0xdd, 0x06, 0xbd, 0xb4, 0x6a, 0xa7, 0x40, 0x39,
			0xf2, 0x04, 0x87, 0x84, 0xec, 0xcb, 0x5d, 0xcb,
			0x02, 0x07, 0x67, 0xa7, 0xba, 0x3d, 0xf2, 0xc7,
			0x55, 0xb4, 0xf0, 0xe6, 0xf8, 0x14, 0x3c, 0xfa,
			0x09, 0x33, 0x26, 0xaf, 0xdc, 0x2b, 0x2b, 0x13,
			0x8f, 0xb0, 0x04, 0x93, 0x32, 0xa0, 0xe3, 0x26,
			0x2b, 0xdc, 0xf9, 0xc8, 0xd9, 0x57, 0x3b, 0x2a,
		},
		/* S5 : 256 byte */
		{
			0x01, 0x90, 0x93, 0x28, 0xc2, 0x4d, 0xd0, 0xef,
			0x91, 0x20, 0x40, 0xf6, 0x14, 0x92, 0xe3, 0x71,
			0x12, 0x43, 0xf8, 0xca, 0x12, 0x62, 0x06, 0x7c,
			0xca, 0x6b, 0xda, 0xb1, 0x65, 0xef, 0xe4, 0x15,
			0x79, 0x82, 0x32, 0x3f, 0x13, 0x15, 0x29, 0x99,
			0xe9, 0xf2, 0x1e, 0x68, 0x52, 0xd8, 0xc2, 0xef,
			0xc4, 0x13, 0x0e, 0x2c, 0x46, 0xa3, 0x84, 0x46,
			0xaa, 0xcf, 0xc5, 0x9f, 0xbc, 0xa5, 0xd1, 0xa3,
			0x89, 0x46, 0x92, 0x3b, 0x7e, 0x08, 0xbe, 0x39,
			0x7f, 0xb7, 0x87, 0xbc, 0x79, 0xa7, 0x1b, 0xa0,
			0x8f, 0xc2, 0xb6, 0x93, 0xd1, 0xbc, 0xbe, 0x89,
			0x7d, 0x1d, 0xfa, 0xce, 0x28, 0x58, 0xba, 0x80,
			0xa0, 0x86, 0xa0, 0xe0, 0xa4, 0x5e, 0xfe, 0x66,
			0xfd, 0x53, 0x50, 0xad, 0xd8, 0x19, 0xfd, 0x0d,
			0xc1, 0x93, 0x1d, 0x3e, 0xba, 0x27, 0x65, 0xf8,
			0x4f, 0x14, 0x74, 0x22, 0xf5, 0x33, 0x0d, 0x0e,
			0xfa, 0x0c, 0xd8, 0x27, 0x19, 0x7a, 0x5d, 0x89,
			0xe2, 0xdd, 0x62, 0xdb, 0x90, 0x51, 0xd5, 0xdf,
			0x8b, 0x96, 0x80, 0x16, 0x9f, 0x34, 0x90, 0x86,
			0xdd, 0x03, 0x8a, 0x9a, 0xc6, 0x2f, 0x99, 0x41,
			0x56, 0x5b, 0x3f, 0x74, 0x7d, 0x52, 0x8e, 0xc4,
			0xc3, 0x6e, 0x9c, 0x94, 0x8a, 0xd3, 0xa7, 0x32,
			0x40, 0xd0, 0x7e, 0xf1, 0x4b, 0x35, 0x4f, 0xfe,
			0xf1, 0xb1, 0x96, 0x5a, 0x9a, 0xaf, 0xb1, 0x3d,
			0x0f, 0xc8, 0x8a, 0x09, 0x70, 0x7c, 0x6a, 0x0a,
			0xd3, 0x02, 0x8d, 0x5a, 0x5c, 0x6e, 0xfa, 0xab,
			0x50, 0xaa, 0xd0, 0x53, 0x04, 0xb1, 0xd5, 0xb2,
			0x93, 0x0a, 0xbb, 0x8f, 0x58, 0xc0, 0x18, 0x8b,
			0x6a, 0x94, 0x23, 0x1f, 0x86, 0x98, 0xc9, 0x6d,
			0xdd, 0x61, 0x43, 0x43, 0xa0, 0x21, 0x84, 0x94,
			0xdf, 0xff, 0x9a, 0x29, 0x3d, 0xfc, 0x7d, 0x5c,
			0x3b, 0x5a, 0xfb, 0xed, 0x8f, 0x07, 0x94, 0x58,
		},
		15, /* salt length */
		/* V5 : 15 byte */
		{
			0x46, 0x37, 0x29, 0xb3, 0xea, 0xf4, 0x35, 0x02,
			0xd9, 0xcf, 0xf1, 0x29, 0x92, 0x56, 0x81, 
		},
	},
	/* SHA224 [6] */
	{
		/* Msg6 : 128 byte */
		{
			0xd6, 0x67, 0x47, 0x63, 0x8d, 0x82, 0x76, 0x92,
			0x03, 0x52, 0xb2, 0x15, 0x15, 0x8c, 0xef, 0xe0,
			0x72, 0x7a, 0x5e, 0x2b, 0x07, 0x9d, 0x89, 0x2c,
			0xbb, 0x96, 0x9f, 0x26, 0x5d, 0x47, 0x0c, 0xa2,
			0xda, 0x35, 0x4d, 0xfc, 0xb4, 0x30, 0x03, 0x22,
			0xaf, 0x37, 0x46, 0x99, 0xce, 0x96, 0x3b, 0xc1,
			0x7d, 0x51, 0xe9, 0x59, 0x10, 0xc5, 0x48, 0x45,
			0x6c, 0x8d, 0x9b, 0x8f, 0x04, 0xa3, 0x00, 0xad,
			0x08, 0xc7, 0x46, 0x02, 0xd8, 0x25, 0xfe, 0xa7,
			0xbf, 0x32, 0xd5, 0x6a, 0xde, 0xd7, 0x21, 0x17,
			0x66, 0xd1, 0xb9, 0xf7, 0x0b, 0x58, 0x0a, 0x97,
			0xb5, 0xfe, 0x67, 0xca, 0x78, 0xdb, 0xa1, 0xf1,
			0xc6, 0xe7, 0xd8, 0x7a, 0xe3, 0xa7, 0x90, 0xa7,
			0x9a, 0x0c, 0x07, 0x91, 0x2f, 0x98, 0xc7, 0x6c,
			0x94, 0xc2, 0x77, 0x0c, 0xdf, 0x9c, 0xf6, 0xa8,
			0xfc, 0xb3, 0xab, 0xdf, 0x9f, 0x36, 0x16, 0xf8,
		},
		/* S6 : 256 byte */
		{
			0x85, 0xf2, 0x96, 0x08, 0x4b, 0xda, 0x82, 0x35,
			0x56, 0xaa, 0x36, 0x9e, 0x5c, 0xb1, 0x9e, 0x10,
			0xce, 0x6e, 0x98, 0x2a, 0x6d, 0x10, 0xa8, 0x5b,
			0xa6, 0xaf, 0x6d, 0x3f, 0xed, 0x8f, 0x2c, 0x05,
			0x59, 0x9f, 0xae, 0xd0, 0x69, 0x21, 0x5c, 0xc9,
			0xee, 0xd9, 0xe7, 0x2a, 0x4f, 0xe5, 0x10, 0xa6,
			0xc0, 0x9f, 0xf7, 0x21, 0xcf, 0x1a, 0x86, 0x0e,
			0x48, 0xcf, 0x64, 0x54, 0x38, 0xc9, 0x2c, 0x5c,
			0x86, 0xd0, 0x88, 0x5e, 0x7d, 0x24, 0x6c, 0xcf,
			0x9d, 0x0c, 0xfd, 0x8c, 0x56, 0xca, 0x8d, 0x67,
			0x3b, 0x70, 0x94, 0xa3, 0xda, 0xa7, 0x7d, 0xb2,
			0x72, 0xd7, 0x16, 0xf3, 0x1b, 0x13, 0x80, 0xf7,
			0x2b, 0x50, 0x37, 0x8f, 0x59, 0x54, 0x71, 0xe4,
			0xe4, 0x81, 0x85, 0x1c, 0x57, 0xa6, 0xb5, 0x74,
			0xbf, 0xb3, 0xfc, 0x7a, 0xa0, 0x36, 0x36, 0x63,
			0x20, 0x45, 0xfc, 0xc8, 0xe9, 0xcc, 0x54, 0x59,
			0x47, 0x59, 0xf6, 0x01, 0x4b, 0x52, 0x78, 0x77,
			0xe6, 0x05, 0xef, 0x60, 0xcf, 0x10, 0x9b, 0x4c,
			0xa7, 0x1e, 0x77, 0x2a, 0x99, 0xac, 0xfc, 0x72,
			0x43, 0x31, 0x86, 0x55, 0xec, 0x50, 0xf7, 0x4e,
			0x48, 0x48, 0x56, 0x68, 0xed, 0x42, 0x85, 0x9f,
			0xf2, 0xc5, 0x93, 0x45, 0x81, 0xba, 0x18, 0x4d,
			0x92, 0x6c, 0x84, 0x67, 0xd7, 0xc3, 0x52, 0x57,
			0xdc, 0xe9, 0x96, 0x40, 0x49, 0x56, 0x8a, 0x99,
			0x0f, 0x65, 0xd5, 0x91, 0xc2, 0xdb, 0x86, 0xb4,
			0x8a, 0x72, 0x56, 0xda, 0x94, 0x7f, 0xd7, 0xd9,
			0x78, 0xdd, 0x67, 0x34, 0xbd, 0x86, 0x85, 0x02,
			0x5d, 0x1a, 0x87, 0xe3, 0x2f, 0x52, 0xa0, 0x29,
			0x93, 0x94, 0xc9, 0x3e, 0x6d, 0x51, 0x8b, 0x18,
			0xe0, 0xb8, 0xdb, 0x1d, 0x76, 0x3f, 0x46, 0x90,
			0x5f, 0x40, 0x5d, 0xf0, 0xcb, 0xc8, 0x45, 0x5e,
			0x03, 0x9f, 0x17, 0x3e, 0x2b, 0x68, 0xc9, 0xde,
		},
		15, /* salt length */
		/* V6 : 15 byte */
		{
			0x46, 0x37, 0x29, 0xb3, 0xea, 0xf4, 0x35, 0x02,
			0xd9, 0xcf, 0xf1, 0x29, 0x92, 0x56, 0x81, 
		},
	},
	/* SHA224 [7] */
	{
		/* Msg7 : 128 byte */
		{
			0x23, 0xd9, 0x26, 0x65, 0xe8, 0x8a, 0x4f, 0x6f,
			0x73, 0x2d, 0xe3, 0x84, 0x03, 0x4d, 0x49, 0x3d,
			0x5d, 0xf3, 0x7b, 0x76, 0x7a, 0x82, 0x60, 0x55,
			0x7d, 0xe0, 0x56, 0x88, 0xe8, 0xd6, 0x0d, 0xcd,
			0x0e, 0xba, 0x9c, 0xb8, 0xcc, 0x4b, 0xce, 0xb1,
			0x74, 0xdc, 0xbd, 0x3c, 0x0a, 0xb5, 0xa3, 0x7d,
			0xb3, 0xb6, 0xec, 0xfb, 0x6a, 0x3d, 0x90, 0xa4,
			0xf5, 0x4a, 0x9f, 0x11, 0x17, 0xe1, 0x1e, 0x0c,
			0x08, 0xb0, 0x11, 0x4f, 0x22, 0xf2, 0xd9, 0x8f,
			0xdd, 0x93, 0xc0, 0xb9, 0xfd, 0x95, 0xd3, 0x7c,
			0x0a, 0xb2, 0xf0, 0x07, 0x01, 0x43, 0x1f, 0x14,
			0x49, 0x60, 0x25, 0x25, 0xe8, 0x49, 0x57, 0x0d,
			0xf7, 0x04, 0xad, 0xb3, 0x53, 0x48, 0x17, 0x13,
			0x96, 0x9a, 0x14, 0x85, 0x46, 0xb6, 0x80, 0x42,
			0x4c, 0x30, 0xad, 0x24, 0xa7, 0x5b, 0xb6, 0xad,
			0x61, 0x6a, 0x10, 0x4b, 0xc2, 0xd5, 0x62, 0xda,
		},
		/* S7 : 256 byte */
		{
			0x8b, 0xee, 0xb2, 0x01, 0xae, 0xdb, 0x9f, 0xe7,
			0xd5, 0x35, 0xfc, 0x79, 0x89, 0x71, 0x30, 0x62,
			0x49, 0x7a, 0x03, 0xe1, 0x8e, 0xf9, 0x97, 0x7b,
			0x98, 0xa9, 0x3f, 0x18, 0xf3, 0x75, 0x45, 0xc3,
			0x8f, 0x5e, 0x52, 0x06, 0xe2, 0xb5, 0xdf, 0x7f,
			0x4a, 0x41, 0xab, 0x9e, 0x06, 0x75, 0xf7, 0xd4,
			0x6d, 0x17, 0x2d, 0xc3, 0xaf, 0x90, 0xfb, 0x7b,
			0x1a, 0x6f, 0xa6, 0xc9, 0x86, 0xb8, 0x03, 0xa7,
			0xf2, 0xea, 0x4e, 0xd2, 0x17, 0x87, 0x2c, 0xc6,
			0x86, 0x16, 0x5b, 0x12, 0x78, 0x45, 0x0c, 0x23,
			0xc3, 0x29, 0xee, 0x28, 0x55, 0xf6, 0x5e, 0x65,
			0x1c, 0x3d, 0xb0, 0x85, 0xe4, 0x07, 0xbf, 0x3e,
			0x3a, 0x96, 0xea, 0xa8, 0x33, 0xba, 0x20, 0x56,
			0xa0, 0x84, 0x03, 0x15, 0x46, 0xce, 0xa2, 0xf4,
			0x54, 0xf7, 0xac, 0xf8, 0x4c, 0x3b, 0x90, 0xfd,
			0x7b, 0x62, 0x10, 0xef, 0x6d, 0x1a, 0xd7, 0x1e,
			0xd1, 0xb0, 0x04, 0x92, 0x62, 0xf5, 0xb4, 0xe3,
			0xca, 0x99, 0xd1, 0x0a, 0x33, 0x07, 0x75, 0x2b,
			0x2a, 0xd8, 0xe8, 0xfb, 0xba, 0x3a, 0x3e, 0x84,
			0x32, 0xbc, 0x96, 0x65, 0x53, 0x90, 0x1e, 0x87,
			0x15, 0x07, 0x38, 0xaa, 0xc9, 0x17, 0x0f, 0xab,
			0x1d, 0x27, 0x21, 0x92, 0x74, 0xec, 0x52, 0x82,
			0x99, 0xf8, 0xaf, 0xbb, 0xd8, 0x61, 0xee, 0x83,
			0x7f, 0x2c, 0x86, 0xec, 0xce, 0x7e, 0x73, 0xc9,
			0xb7, 0xbd, 0x6f, 0x66, 0x61, 0xd1, 0xef, 0xe3,
			0xfd, 0x2f, 0xf7, 0xb3, 0xef, 0xa0, 0xd1, 0xfc,
			0x7b, 0x84, 0xfe, 0xff, 0xfa, 0x14, 0xb5, 0x5a,
			0x2c, 0x5f, 0xe3, 0x25, 0x2c, 0xae, 0x0c, 0xf0,
			0xda, 0x6e, 0x50, 0xe3, 0xd6, 0x15, 0xf8, 0x6a,
			0xe6, 0x72, 0x1a, 0xa5, 0xe2, 0x9e, 0xd3, 0xa1,
			0xc7, 0x1c, 0x24, 0x3c, 0x25, 0x29, 0xee, 0xf4,
			0x83, 0xc5, 0x6b, 0x90, 0x2e, 0x93, 0x71, 0x8c,
		},
		15, /* salt length */
		/* V7 : 15 byte */
		{
			0x46, 0x37, 0x29, 0xb3, 0xea, 0xf4, 0x35, 0x02,
			0xd9, 0xcf, 0xf1, 0x29, 0x92, 0x56, 0x81, 
		},
	},
	/* SHA224 [8] */
	{
		/* Msg8 : 128 byte */
		{
			0x40, 0xab, 0xb4, 0x2d, 0xb3, 0x40, 0x67, 0xfa,
			0xdb, 0x5a, 0xac, 0xbb, 0x2f, 0xde, 0xdd, 0x2d,
			0x03, 0x24, 0x03, 0x0b, 0xb7, 0x5c, 0xa5, 0x8f,
			0x2e, 0x2a, 0xde, 0x37, 0x81, 0x94, 0xb2, 0xc5,
			0xf5, 0x1e, 0xa2, 0x89, 0x2b, 0x33, 0x7e, 0xe2,
			0x97, 0xc7, 0x7b, 0x03, 0x33, 0x3b, 0x86, 0xf3,
			0x75, 0x81, 0xd7, 0xd7, 0x7e, 0x80, 0xc8, 0x74,
			0x94, 0xba, 0xe8, 0xf0, 0xd2, 0x2c, 0x4b, 0xd8,
			0x1e, 0x75, 0x25, 0x68, 0x5c, 0x3b, 0x97, 0x06,
			0xe1, 0xcb, 0xc9, 0x0f, 0x2b, 0xff, 0x39, 0xd6,
			0xcf, 0x65, 0x53, 0xea, 0xb2, 0x9d, 0x41, 0x98,
			0x7c, 0x03, 0x04, 0xb1, 0x4a, 0x8f, 0xc4, 0x8e,
			0xa4, 0xf9, 0x64, 0x50, 0xae, 0x20, 0x5a, 0x6c,
			0xa2, 0xac, 0xbe, 0x68, 0x7d, 0xf2, 0xa0, 0xdf,
			0xf9, 0x19, 0x9f, 0xcb, 0xbc, 0x7b, 0xb7, 0x04,
			0xcf, 0x4e, 0x5b, 0x03, 0x51, 0x84, 0xc4, 0xec,
		},
		/* S8 : 256 byte */
		{
			0x54, 0xbe, 0xc6, 0x62, 0x41, 0xdc, 0x19, 0x7a,
			0xd9, 0x2e, 0x69, 0x55, 0x26, 0xb3, 0xb6, 0xa0,
			0x30, 0x21, 0x6b, 0x48, 0xaf, 0x90, 0xd9, 0x3c,
			0x36, 0xb2, 0xd7, 0x06, 0x44, 0xe4, 0x0c, 0xda,
			0x2c, 0xb2, 0x59, 0xf2, 0x7c, 0xa9, 0xd1, 0x41,
			0xe5, 0x75, 0x3f, 0x93, 0x84, 0x97, 0xe8, 0x42,
			0x08, 0xb3, 0x80, 0xff, 0xe1, 0x78, 0x87, 0x01,
			0xc7, 0x1d, 0x89, 0xbb, 0xea, 0x3e, 0xdd, 0x35,
			0x2d, 0xab, 0xd3, 0x2d, 0x94, 0x25, 0xed, 0xcf,
			0x9a, 0x33, 0xe1, 0x85, 0xcb, 0xc4, 0x03, 0x1a,
			0xa6, 0x06, 0x98, 0x63, 0xfe, 0x47, 0xd4, 0x99,
			0x53, 0x6a, 0x59, 0xda, 0x12, 0xa8, 0xbd, 0xbb,
			0xf2, 0xa3, 0xa9, 0xf0, 0x03, 0x93, 0x18, 0xd0,
			0x66, 0xf5, 0x11, 0x7b, 0xbf, 0x6f, 0xce, 0x4f,
			0x67, 0x52, 0x08, 0x8c, 0xcc, 0x3a, 0x08, 0x1d,
			0x85, 0xda, 0x46, 0x1a, 0x8b, 0xdc, 0xaf, 0x34,
			0x9f, 0xd4, 0x05, 0x4f, 0x76, 0x38, 0x4e, 0x66,
			0x8d, 0x00, 0xa6, 0xf7, 0x47, 0x68, 0x8c, 0x84,
			0x20, 0xc7, 0xe4, 0x52, 0xb0, 0x73, 0x6a, 0xd6,
			0x2e, 0x17, 0x38, 0xa3, 0xf1, 0x0c, 0xb6, 0x2b,
			0xc7, 0xdd, 0xc1, 0x2f, 0xa6, 0x70, 0xf8, 0x58,
			0xb2, 0xd5, 0xde, 0xf9, 0xa4, 0x2a, 0xc8, 0xf2,
			0xfc, 0x91, 0xd4, 0x88, 0x73, 0x8a, 0x7c, 0x23,
			0x16, 0x8f, 0x51, 0xdd, 0xfb, 0xda, 0xe6, 0xa5,
			0xd8, 0xee, 0x1f, 0xc5, 0x61, 0xcc, 0x3a, 0xdd,
			0x4a, 0x7e, 0x14, 0xeb, 0x10, 0x3b, 0xf9, 0x59,
			0x3c, 0xeb, 0xf3, 0x91, 0xc1, 0xf7, 0xa0, 0x7d,
			0x26, 0x2f, 0xaf, 0x03, 0xd4, 0x7d, 0x07, 0x42,
			0x4f, 0xfb, 0x3a, 0x91, 0x6a, 0x95, 0x64, 0x65,
			0x2a, 0x1b, 0xe0, 0x20, 0xa0, 0xe9, 0x22, 0xe9,
			0x9a, 0x57, 0xda, 0x1a, 0xbf, 0x93, 0x1f, 0x74,
			0xcf, 0xbd, 0xd4, 0x84, 0xc0, 0xa9, 0x56, 0x8f,
		},
		15, /* salt length */
		/* V8 : 15 byte */
		{
			0x46, 0x37, 0x29, 0xb3, 0xea, 0xf4, 0x35, 0x02,
			0xd9, 0xcf, 0xf1, 0x29, 0x92, 0x56, 0x81, 
		},
	},
	/* SHA224 [9] */
	{
		/* Msg9 : 128 byte */
		{
			0xef, 0x10, 0xb0, 0x3c, 0x04, 0x57, 0x8b, 0xd5,
			0xf7, 0x83, 0x35, 0x8d, 0xf3, 0x67, 0x45, 0x6a,
			0x73, 0xde, 0x38, 0xc6, 0xfa, 0xb2, 0xc3, 0x54,
			0x05, 0xbc, 0x68, 0x5e, 0x3d, 0x4c, 0x48, 0x50,
			0xf2, 0xcb, 0x38, 0x7a, 0xc5, 0x9e, 0x16, 0x12,
			0xa4, 0x4e, 0x5e, 0x78, 0xfc, 0xe6, 0xf8, 0xbe,
			0x29, 0x9d, 0x54, 0x68, 0x32, 0xb5, 0xb9, 0x70,
			0xb3, 0xa3, 0xda, 0x8e, 0x1a, 0x70, 0xab, 0xb6,
			0x16, 0x5f, 0x72, 0xe1, 0x4d, 0xd0, 0x21, 0x10,
			0x4e, 0x64, 0xe3, 0x8e, 0xc6, 0x62, 0xf5, 0x76,
			0xf6, 0x5a, 0xb7, 0x76, 0x64, 0x08, 0x03, 0xd2,
			0xd1, 0x7a, 0xbd, 0xac, 0x6c, 0x75, 0xab, 0x82,
			0x45, 0x16, 0x87, 0xf8, 0x04, 0xb5, 0x53, 0xd8,
			0xdb, 0x0e, 0xed, 0x57, 0xb9, 0xa3, 0xe3, 0x9a,
			0xc1, 0x5c, 0x88, 0x78, 0xfa, 0x71, 0x48, 0x82,
			0x48, 0x89, 0x38, 0x40, 0x9b, 0x24, 0xf1, 0xbe,
		},
		/* S9 : 256 byte */
		{
			0x4a, 0x18, 0x3b, 0x82, 0x61, 0x6f, 0x3b, 0xbc,
			0x27, 0xa1, 0x46, 0x71, 0x0b, 0x28, 0x72, 0x91,
			0x61, 0xfe, 0xb1, 0x79, 0x00, 0xbe, 0x62, 0xe6,
			0x9e, 0xed, 0x5d, 0x25, 0x4d, 0x15, 0xf3, 0x4b,
			0xce, 0x52, 0xd6, 0xf3, 0xde, 0xba, 0x89, 0xa7,
			0x87, 0xeb, 0xeb, 0x06, 0x11, 0xe2, 0x40, 0xcc,
			0x23, 0xe1, 0x6a, 0xdd, 0x37, 0x96, 0xd4, 0xa2,
			0x97, 0x83, 0xe2, 0xcb, 0xe8, 0x79, 0x7e, 0x06,
			0x6c, 0xec, 0xbd, 0x66, 0x05, 0x9c, 0x39, 0x4f,
			0x0e, 0x2f, 0x9e, 0x37, 0x7f, 0x1f, 0xfa, 0x19,
			0x4f, 0xcb, 0x89, 0x5e, 0x1c, 0x48, 0x87, 0x4b,
			0x9b, 0x64, 0x30, 0xa1, 0x3c, 0x77, 0x9f, 0x5c,
			0xa2, 0x9e, 0x3f, 0x42, 0xbc, 0xa4, 0xb9, 0x16,
			0x71, 0x05, 0x90, 0xab, 0x65, 0x01, 0x80, 0x9d,
			0x64, 0x5a, 0x48, 0x85, 0xb0, 0x58, 0xdb, 0xa0,
			0x64, 0x79, 0x71, 0xf0, 0x4f, 0x6f, 0x2f, 0x4a,
			0x29, 0x6c, 0x45, 0xd8, 0x9d, 0xd8, 0x48, 0xb7,
			0xc2, 0xf8, 0x77, 0x7e, 0xc5, 0x08, 0x46, 0xc9,
			0x7d, 0x35, 0xc1, 0x2d, 0x54, 0xeb, 0xb6, 0xff,
			0x16, 0x73, 0x27, 0xb1, 0xd4, 0xda, 0xed, 0xf4,
			0x46, 0x80, 0x31, 0xb5, 0x90, 0x57, 0xd5, 0x7c,
			0xed, 0xdb, 0x79, 0xfd, 0xd0, 0x13, 0x16, 0x7e,
			0xe6, 0xe4, 0x6d, 0x91, 0x30, 0x69, 0x33, 0x22,
			0xc3, 0xae, 0x67, 0x02, 0x90, 0x1a, 0x1e, 0x90,
			0xbd, 0x4b, 0x62, 0x1d, 0x14, 0x19, 0x77, 0xd0,
			0x68, 0x0a, 0xcd, 0x52, 0x49, 0x21, 0xbc, 0x54,
			0x0e, 0x34, 0xac, 0x64, 0x0a, 0xce, 0x02, 0xf8,
			0x9d, 0x54, 0x36, 0x80, 0x82, 0x83, 0xe0, 0x26,
			0xe1, 0x38, 0xba, 0x3a, 0x5a, 0x43, 0x10, 0xfe,
			0x1e, 0x04, 0x88, 0x33, 0xf9, 0xb5, 0x81, 0xba,
			0xef, 0x5f, 0x89, 0x1f, 0x9c, 0xdb, 0x2f, 0x06,
			0x73, 0xba, 0xfa, 0x11, 0xce, 0xab, 0xc7, 0xd7,
		},
		15, /* salt length */
		/* V9 : 15 byte */
		{
			0x46, 0x37, 0x29, 0xb3, 0xea, 0xf4, 0x35, 0x02,
			0xd9, 0xcf, 0xf1, 0x29, 0x92, 0x56, 0x81, 
		},
	},
};

/* 10 elements */
static mod2048_t SHA256[] = {
	/* SHA256 [0] */
	{
		/* Msg0 : 128 byte */
		{
			0xdf, 0xc2, 0x26, 0x04, 0xb9, 0x5d, 0x15, 0x32,
			0x80, 0x59, 0x74, 0x5c, 0x6c, 0x98, 0xeb, 0x9d,
			0xfb, 0x34, 0x7c, 0xf9, 0xf1, 0x70, 0xaf, 0xf1,
			0x9d, 0xee, 0xec, 0x55, 0x5f, 0x22, 0x28, 0x5a,
			0x67, 0x06, 0xc4, 0xec, 0xbf, 0x0f, 0xb1, 0x45,
			0x8c, 0x60, 0xd9, 0xbf, 0x91, 0x3f, 0xba, 0xe6,
			0xf4, 0xc5, 0x54, 0xd2, 0x45, 0xd9, 0x46, 0xb4,
			0xbc, 0x5f, 0x34, 0xae, 0xc2, 0xac, 0x6b, 0xe8,
			0xb3, 0x3d, 0xc8, 0xe0, 0xe3, 0xa9, 0xd6, 0x01,
			0xdf, 0xd5, 0x36, 0x78, 0xf5, 0x67, 0x44, 0x43,
			0xf6, 0x7d, 0xf7, 0x8a, 0x3a, 0x9e, 0x09, 0x33,
			0xe5, 0xf1, 0x58, 0xb1, 0x69, 0xac, 0x8d, 0x1c,
			0x4c, 0xd0, 0xfb, 0x87, 0x2c, 0x14, 0xca, 0x8e,
			0x00, 0x1e, 0x54, 0x2e, 0xa0, 0xf9, 0xcf, 0xda,
			0x88, 0xc4, 0x2d, 0xca, 0xd8, 0xa7, 0x40, 0x97,
			0xa0, 0x0c, 0x22, 0x05, 0x5b, 0x0b, 0xd4, 0x1f,
		},
		/* S0 : 256 byte */
		{
			0x8b, 0x46, 0xf2, 0xc8, 0x89, 0xd8, 0x19, 0xf8,
			0x60, 0xaf, 0x0a, 0x6c, 0x4c, 0x88, 0x9e, 0x4d,
			0x14, 0x36, 0xc6, 0xca, 0x17, 0x44, 0x64, 0xd2,
			0x2a, 0xe1, 0x1b, 0x9c, 0xcc, 0x26, 0x5d, 0x74,
			0x3c, 0x67, 0xe5, 0x69, 0xac, 0xcb, 0xc5, 0xa8,
			0x0d, 0x4d, 0xd5, 0xf1, 0xbf, 0x40, 0x39, 0xe2,
			0x3d, 0xe5, 0x2a, 0xec, 0xe4, 0x02, 0x91, 0xc7,
			0x5f, 0x89, 0x36, 0xc5, 0x8c, 0x9a, 0x2f, 0x77,
			0xa7, 0x80, 0xbb, 0xe7, 0xad, 0x31, 0xeb, 0x76,
			0x74, 0x2f, 0x7b, 0x2b, 0x8b, 0x14, 0xca, 0x1a,
			0x71, 0x96, 0xaf, 0x7e, 0x67, 0x3a, 0x3c, 0xfc,
			0x23, 0x7d, 0x50, 0xf6, 0x15, 0xb7, 0x5c, 0xf4,
			0xa7, 0xea, 0x78, 0xa9, 0x48, 0xbe, 0xda, 0xf9,
			0x24, 0x24, 0x94, 0xb4, 0x1e, 0x1d, 0xb5, 0x1f,
			0x43, 0x7f, 0x15, 0xfd, 0x25, 0x51, 0xbb, 0x5d,
			0x24, 0xee, 0xfb, 0x1c, 0x3e, 0x60, 0xf0, 0x36,
			0x94, 0xd0, 0x03, 0x3a, 0x1e, 0x0a, 0x9b, 0x9f,
			0x5e, 0x4a, 0xb9, 0x7d, 0x45, 0x7d, 0xff, 0x9b,
			0x9d, 0xa5, 0x16, 0xdc, 0x22, 0x6d, 0x6d, 0x65,
			0x29, 0x50, 0x03, 0x08, 0xed, 0x74, 0xa2, 0xe6,
			0xd9, 0xf3, 0xc1, 0x05, 0x95, 0x78, 0x8a, 0x52,
			0xa1, 0xbc, 0x06, 0x64, 0xae, 0xdf, 0x33, 0xef,
			0xc8, 0xba, 0xdd, 0x03, 0x7e, 0xb7, 0xb8, 0x80,
			0x77, 0x2b, 0xdb, 0x04, 0xa6, 0x04, 0x6e, 0x9e,
			0xde, 0xee, 0x41, 0x97, 0xc2, 0x55, 0x07, 0xfb,
			0x0f, 0x11, 0xab, 0x1c, 0x9f, 0x63, 0xf5, 0x3c,
			0x88, 0x20, 0xea, 0x84, 0x05, 0xcf, 0xd7, 0x72,
			0x16, 0x92, 0x47, 0x5b, 0x4d, 0x72, 0x35, 0x5f,
			0xa9, 0xa3, 0x80, 0x4f, 0x29, 0xe6, 0xb6, 0xa7,
			0xb0, 0x59, 0xc4, 0x44, 0x1d, 0x54, 0xb2, 0x8e,
			0x4e, 0xed, 0x25, 0x29, 0xc6, 0x10, 0x3b, 0x54,
			0x32, 0xc7, 0x13, 0x32, 0xce, 0x74, 0x2b, 0xcc,
		},
		20, /* salt length */
		/* V0 : 20 byte */
		{
			0xe1, 0x25, 0x6f, 0xc1, 0xee, 0xef, 0x81, 0x77,
			0x3f, 0xdd, 0x54, 0x65, 0x7e, 0x40, 0x07, 0xfd,
			0xe6, 0xbc, 0xb9, 0xb1, 
		},
	},
	/* SHA256 [1] */
	{
		/* Msg1 : 128 byte */
		{
			0xfd, 0x6a, 0x06, 0x3e, 0x61, 0xc2, 0xb3, 0x54,
			0xfe, 0x8c, 0xb3, 0x7a, 0x5f, 0x37, 0x88, 0xb5,
			0xc0, 0x1f, 0xf1, 0x5a, 0x72, 0x5f, 0x6b, 0x81,
			0x81, 0xe6, 0xf6, 0xb7, 0x95, 0xce, 0x1c, 0xf3,
			0x16, 0xe9, 0x30, 0xcc, 0x93, 0x9c, 0xd4, 0xe8,
			0x65, 0xf0, 0xbd, 0xb8, 0x8f, 0xe6, 0xbb, 0x62,
			0xe9, 0x0b, 0xf3, 0xff, 0x7e, 0x4d, 0x6f, 0x07,
			0x32, 0x0d, 0xda, 0x09, 0xa8, 0x75, 0x84, 0xa0,
			0x62, 0x0c, 0xad, 0xa2, 0x2a, 0x87, 0xff, 0x9a,
			0xb1, 0xe3, 0x5c, 0x79, 0x77, 0xb0, 0xda, 0x88,
			0xea, 0xb0, 0x0c, 0xa1, 0xd2, 0xa0, 0x84, 0x9f,
			0xec, 0x56, 0x95, 0x13, 0xd5, 0x0c, 0x5e, 0x39,
			0x2a, 0xfc, 0x03, 0x2a, 0xee, 0x2d, 0x3e, 0x52,
			0x2c, 0x8c, 0x17, 0x25, 0xdd, 0x3e, 0xef, 0x0e,
			0x0b, 0x35, 0xc3, 0xa8, 0x37, 0x01, 0xaf, 0x31,
			0xf9, 0xe9, 0xb1, 0x3c, 0xe6, 0x3b, 0xb0, 0xa5,
		},
		/* S1 : 256 byte */
		{
			0x49, 0x2b, 0x6f, 0x68, 0x84, 0xdf, 0x46, 0x1f,
			0xe1, 0x05, 0x16, 0xb6, 0xb8, 0xcc, 0x20, 0x53,
			0x85, 0xc2, 0x01, 0x08, 0xec, 0x47, 0xd5, 0xdb,
			0x69, 0x28, 0x3f, 0x4a, 0x76, 0x88, 0xe3, 0x18,
			0xcf, 0xdc, 0x3c, 0x49, 0x1f, 0xb2, 0x92, 0x25,
			0x32, 0x5a, 0xeb, 0x46, 0xef, 0xc7, 0x5e, 0x85,
			0x58, 0x40, 0x91, 0x0b, 0xba, 0xf0, 0xd1, 0xc8,
			0xd4, 0x78, 0x45, 0x42, 0xb9, 0x70, 0x75, 0x4a,
			0xaa, 0x84, 0xbf, 0xe4, 0x7c, 0x77, 0xb3, 0xa1,
			0xb5, 0x03, 0x7d, 0x4d, 0x79, 0x75, 0x94, 0x71,
			0xe9, 0x6c, 0xc7, 0xa5, 0x27, 0xa0, 0xed, 0x06,
			0x7e, 0x21, 0x70, 0x9e, 0xf7, 0xf4, 0xc4, 0x11,
			0x1b, 0x60, 0xb8, 0xc0, 0x80, 0x82, 0xc8, 0x18,
			0x0c, 0x7c, 0x96, 0xb6, 0x1c, 0x0f, 0x71, 0x02,
			0xed, 0x9b, 0x90, 0xe2, 0x4d, 0xe1, 0x1e, 0x62,
			0x98, 0xbb, 0x24, 0x45, 0x18, 0xf9, 0xb4, 0x46,
			0xce, 0x64, 0x1f, 0xe9, 0x95, 0xe9, 0xcc, 0x29,
			0x9e, 0xd4, 0x11, 0xb6, 0x5e, 0xb2, 0x5e, 0xaa,
			0xe9, 0xe5, 0x53, 0x48, 0x4a, 0x0a, 0x7e, 0x95,
			0x6e, 0xad, 0xf0, 0x84, 0x08, 0x88, 0xc7, 0x0e,
			0x5c, 0xa6, 0xeb, 0xc3, 0xe4, 0x79, 0xf8, 0xc6,
			0x9c, 0x53, 0xcf, 0x31, 0x37, 0x0a, 0xb3, 0x85,
			0xe8, 0xb6, 0x73, 0xdc, 0x45, 0xa0, 0xc1, 0x96,
			0x4e, 0xc4, 0x94, 0x68, 0xd1, 0x82, 0x46, 0x21,
			0x3a, 0x8f, 0x93, 0xa2, 0xa9, 0x6a, 0xad, 0x5a,
			0x27, 0x01, 0xc1, 0x91, 0xa1, 0x4a, 0x31, 0x51,
			0x9e, 0x4f, 0x36, 0x54, 0x4d, 0x66, 0x87, 0x08,
			0xff, 0x37, 0xbe, 0x54, 0x81, 0xcb, 0x0f, 0xfa,
			0x2b, 0x0e, 0x1f, 0x14, 0x5e, 0x29, 0xf8, 0x57,
			0x5d, 0xfa, 0x9e, 0xc3, 0x0c, 0x6c, 0xb4, 0x1c,
			0x39, 0x34, 0x39, 0x29, 0x22, 0x10, 0xea, 0x80,
			0x6a, 0x50, 0x55, 0x98, 0xeb, 0xdf, 0x08, 0x33,
		},
		20, /* salt length */
		/* V1 : 20 byte */
		{
			0xe1, 0x25, 0x6f, 0xc1, 0xee, 0xef, 0x81, 0x77,
			0x3f, 0xdd, 0x54, 0x65, 0x7e, 0x40, 0x07, 0xfd,
			0xe6, 0xbc, 0xb9, 0xb1, 
		},
	},
	/* SHA256 [2] */
	{
		/* Msg2 : 128 byte */
		{
			0x7e, 0x66, 0x90, 0x20, 0x3c, 0xb0, 0x68, 0xb8,
			0x53, 0x0c, 0xb1, 0xff, 0x4e, 0xea, 0xf0, 0xfc,
			0x69, 0xa4, 0xe3, 0x04, 0xf5, 0x56, 0x07, 0x2d,
			0xfe, 0xef, 0x5c, 0x05, 0x2c, 0x88, 0x6c, 0x83,
			0xe7, 0xf5, 0x8a, 0x3d, 0xbe, 0x9a, 0x58, 0xdc,
			0x0a, 0x80, 0x8c, 0xcd, 0xce, 0xa9, 0xf3, 0x3a,
			0xe2, 0xa0, 0xb6, 0x39, 0x51, 0x53, 0xdc, 0x43,
			0xff, 0x25, 0x10, 0xe7, 0x8f, 0x40, 0xa4, 0xbf,
			0x83, 0x28, 0xd7, 0xa4, 0xa5, 0x96, 0x53, 0x1e,
			0xa6, 0x83, 0xfa, 0x1e, 0x06, 0x83, 0xe2, 0xf0,
			0x33, 0x54, 0x9e, 0x6b, 0xf5, 0xb7, 0xc0, 0x6b,
			0x09, 0x7e, 0x9b, 0x81, 0x0d, 0xe7, 0x4e, 0xe8,
			0x9c, 0x28, 0xfe, 0xbb, 0xb9, 0x4b, 0x62, 0x66,
			0x71, 0x3c, 0x85, 0x5b, 0xbc, 0x21, 0xc7, 0x06,
			0xa5, 0xe9, 0x25, 0x02, 0xaa, 0x28, 0xbb, 0x8d,
			0x66, 0x22, 0x87, 0x39, 0x6d, 0x25, 0x70, 0xe5,
		},
		/* S2 : 256 byte */
		{
			0x50, 0x9a, 0x01, 0xbb, 0x03, 0x60, 0xd1, 0x16,
			0x0e, 0xd3, 0xff, 0x33, 0x43, 0x22, 0x91, 0xcf,
			0xbb, 0x63, 0xda, 0xa2, 0x93, 0x38, 0x19, 0x60,
			0x0d, 0xb7, 0xdd, 0x82, 0x5a, 0xef, 0x13, 0xdd,
			0x1e, 0x9a, 0x88, 0x8a, 0x9f, 0xb6, 0xfe, 0xa9,
			0x3d, 0xeb, 0xd4, 0xcf, 0x4b, 0xc7, 0x71, 0x29,
			0xb0, 0x6d, 0xd4, 0x72, 0x71, 0x93, 0xd7, 0xe8,
			0xa2, 0xe5, 0xaa, 0x5a, 0x60, 0x20, 0xb6, 0x45,
			0x24, 0xe9, 0x3a, 0xbb, 0x04, 0x06, 0xf5, 0xa1,
			0x8f, 0x74, 0xff, 0x0a, 0xa8, 0x04, 0x91, 0x9d,
			0xf4, 0x07, 0x2e, 0x31, 0x9c, 0xe8, 0x23, 0x44,
			0x31, 0xc9, 0x4e, 0x8e, 0xef, 0x8c, 0x5c, 0xe8,
			0x13, 0xa0, 0x7b, 0x2f, 0x66, 0xdd, 0x6a, 0x03,
			0x2c, 0x3e, 0x69, 0xa3, 0xc5, 0x8c, 0x6b, 0x54,
			0xac, 0xf0, 0x8b, 0xbb, 0xb0, 0x19, 0xdf, 0x15,
			0xf3, 0xab, 0xd2, 0x2c, 0x67, 0xf3, 0xe2, 0xcb,
			0xff, 0xe9, 0x98, 0x87, 0xad, 0xee, 0x58, 0xa3,
			0x9c, 0xc3, 0x0a, 0xc4, 0x5a, 0x6e, 0x6e, 0x59,
			0x28, 0x3e, 0xe0, 0x89, 0x0a, 0xa8, 0x70, 0x72,
			0xa8, 0x57, 0x84, 0x5f, 0x5c, 0xf3, 0xdd, 0xac,
			0xdc, 0x77, 0x6e, 0x58, 0xe5, 0x0b, 0x66, 0xe9,
			0x5e, 0xb1, 0x3d, 0xec, 0x49, 0xce, 0x45, 0x50,
			0x5c, 0x37, 0x87, 0x34, 0xe9, 0x64, 0xe8, 0x09,
			0x5d, 0x34, 0xa0, 0x13, 0x17, 0x76, 0x8b, 0x7b,
			0x9f, 0xbe, 0xf6, 0xeb, 0x24, 0xb0, 0x8b, 0x1b,
			0xf0, 0x31, 0x2a, 0xb5, 0x1e, 0x0a, 0xce, 0xa4,
			0xa3, 0xdf, 0xdf, 0xa6, 0xfa, 0x7b, 0xb1, 0x15,
			0xb8, 0xb6, 0x85, 0xd3, 0x54, 0x84, 0x1d, 0x19,
			0x01, 0xbc, 0x73, 0xcc, 0x65, 0x5a, 0xe2, 0x46,
			0xa5, 0x45, 0x3e, 0xa8, 0xd1, 0x60, 0x61, 0x04,
			0x25, 0xc2, 0xc1, 0x49, 0x69, 0xbf, 0x22, 0xa7,
			0xe1, 0x1e, 0x66, 0x3c, 0xff, 0x15, 0x01, 0xf1,
		},
		20, /* salt length */
		/* V2 : 20 byte */
		{
			0xe1, 0x25, 0x6f, 0xc1, 0xee, 0xef, 0x81, 0x77,
			0x3f, 0xdd, 0x54, 0x65, 0x7e, 0x40, 0x07, 0xfd,
			0xe6, 0xbc, 0xb9, 0xb1, 
		},
	},
	/* SHA256 [3] */
	{
		/* Msg3 : 128 byte */
		{
			0x1d, 0xce, 0x34, 0xc6, 0x2e, 0x4a, 0xef, 0x45,
			0xe1, 0xe7, 0x38, 0x49, 0x7b, 0x60, 0x2e, 0x82,
			0xc1, 0xfe, 0x46, 0x9f, 0x73, 0x0c, 0xf1, 0x64,
			0x17, 0x8b, 0x79, 0xfd, 0xf7, 0x27, 0x2c, 0x92,
			0x6d, 0x69, 0xbd, 0x1b, 0x5e, 0x2d, 0xe7, 0x76,
			0x05, 0x57, 0x53, 0xb6, 0xf2, 0xc2, 0xbc, 0xbf,
			0x52, 0x79, 0x51, 0x10, 0x70, 0x2a, 0x5b, 0xdf,
			0x7c, 0xd7, 0x1f, 0x6b, 0x8c, 0xcf, 0x06, 0x8e,
			0xe0, 0xdd, 0xfb, 0x91, 0x6a, 0xbf, 0x15, 0x45,
			0x8d, 0xd9, 0x76, 0x4f, 0x26, 0x2b, 0x73, 0xc4,
			0xc9, 0x81, 0xf5, 0xf6, 0x4d, 0xe9, 0x1e, 0x8d,
			0x8a, 0x6a, 0x30, 0xd9, 0x61, 0xf3, 0xab, 0x66,
			0xfd, 0x92, 0xb6, 0xd1, 0x59, 0xe6, 0xc0, 0xdb,
			0x02, 0xd7, 0x67, 0xbc, 0x1f, 0x84, 0x99, 0xba,
			0xae, 0x7d, 0xf9, 0xf9, 0x10, 0x33, 0x84, 0x95,
			0xc8, 0xad, 0x74, 0xee, 0x80, 0x7c, 0x64, 0x43,
		},
		/* S3 : 256 byte */
		{
			0x1b, 0xd7, 0x9d, 0x25, 0xac, 0x6b, 0x0f, 0x24,
			0x2f, 0x39, 0x55, 0x5c, 0x85, 0xd8, 0x58, 0xc2,
			0x36, 0x80, 0xe1, 0xeb, 0xf9, 0x59, 0x0d, 0x05,
			0x46, 0x3e, 0xbc, 0x58, 0x45, 0x4a, 0x78, 0x22,
			0xcf, 0x0e, 0x0c, 0x2a, 0xb9, 0x87, 0x2b, 0x6e,
			0xac, 0x5a, 0xe8, 0xce, 0x3d, 0xa7, 0x73, 0xd6,
			0xb2, 0x03, 0x9e, 0x9b, 0x26, 0xce, 0x75, 0x1d,
			0xad, 0xc4, 0x85, 0x79, 0x32, 0x0e, 0xa6, 0x3b,
			0x97, 0x8b, 0x0d, 0xf0, 0x38, 0x19, 0x1d, 0x91,
			0x28, 0x10, 0x21, 0x28, 0xa3, 0x65, 0xc0, 0x1d,
			0x9e, 0x2b, 0x43, 0xfe, 0x2b, 0x5e, 0xf1, 0xce,
			0x9e, 0xe8, 0xf4, 0xa1, 0xe1, 0x2c, 0xae, 0xf1,
			0xbb, 0xe7, 0xf3, 0xa8, 0xd1, 0xa9, 0x3c, 0x9f,
			0x39, 0x97, 0x53, 0xbb, 0xfd, 0x60, 0xd2, 0x2d,
			0x8f, 0x39, 0x20, 0x6a, 0x51, 0x1e, 0xa4, 0x48,
			0xdc, 0x23, 0xcc, 0x0e, 0x4f, 0xcf, 0x0b, 0x77,
			0xd3, 0xf3, 0xfb, 0xd9, 0x18, 0x8b, 0x74, 0x0d,
			0xe3, 0xf8, 0x50, 0x09, 0xde, 0x94, 0xee, 0x15,
			0x7d, 0xbf, 0x7e, 0xdc, 0x31, 0x65, 0xe9, 0xf6,
			0x9b, 0x59, 0xdb, 0x37, 0xf7, 0xfd, 0xc5, 0x07,
			0x49, 0x6d, 0xe8, 0x94, 0x1a, 0x2a, 0x26, 0x28,
			0x77, 0x4b, 0x06, 0xc8, 0xca, 0xb0, 0x34, 0xbb,
			0xe3, 0xd2, 0xc0, 0x4d, 0x25, 0x3b, 0x59, 0x48,
			0xd6, 0xe5, 0x71, 0x23, 0x73, 0xad, 0xa9, 0x9b,
			0x7f, 0x86, 0x06, 0x12, 0x44, 0x0c, 0x5e, 0xed,
			0x81, 0xef, 0xee, 0xa1, 0x8d, 0x76, 0x32, 0x9d,
			0xc3, 0x0b, 0xd9, 0xfc, 0xc5, 0x00, 0xe9, 0x23,
			0x15, 0x67, 0x71, 0x42, 0xd5, 0xe1, 0xb6, 0xb4,
			0x5a, 0xe0, 0xe6, 0xe7, 0x25, 0x12, 0x2f, 0x04,
			0x6c, 0x9a, 0x54, 0x4a, 0xd1, 0xef, 0x1d, 0xdc,
			0x7c, 0x6b, 0x2a, 0x78, 0x09, 0x71, 0x5a, 0xb7,
			0x5e, 0xf8, 0x70, 0xee, 0x66, 0x70, 0x62, 0x7a,
		},
		20, /* salt length */
		/* V3 : 20 byte */
		{
			0xe1, 0x25, 0x6f, 0xc1, 0xee, 0xef, 0x81, 0x77,
			0x3f, 0xdd, 0x54, 0x65, 0x7e, 0x40, 0x07, 0xfd,
			0xe6, 0xbc, 0xb9, 0xb1, 
		},
	},
	/* SHA256 [4] */
	{
		/* Msg4 : 128 byte */
		{
			0xc3, 0x29, 0x76, 0x43, 0x2e, 0x24, 0x0d, 0x23,
			0xdf, 0x65, 0x94, 0xf2, 0x88, 0x5f, 0x00, 0xdb,
			0x7f, 0xa7, 0xe5, 0x3b, 0x7a, 0xa8, 0x4e, 0xf8,
			0x97, 0x98, 0xec, 0x14, 0x9f, 0xab, 0x74, 0x82,
			0x8b, 0x86, 0x42, 0x38, 0x47, 0xf6, 0x42, 0x85,
			0xb7, 0xe2, 0x10, 0xa5, 0xf8, 0x7e, 0x5e, 0x93,
			0xe8, 0xc2, 0x97, 0x1e, 0xe8, 0x1b, 0xc1, 0x3f,
			0xe0, 0x60, 0xa8, 0xaa, 0x84, 0x07, 0x39, 0xa3,
			0xd6, 0x99, 0x2c, 0x13, 0xec, 0x63, 0xe6, 0xdb,
			0xf4, 0x6f, 0x9d, 0x68, 0x75, 0xb2, 0xbd, 0x87,
			0xd8, 0x87, 0x8a, 0x7b, 0x26, 0x5c, 0x07, 0x4e,
			0x13, 0xab, 0x17, 0x64, 0x3c, 0x2d, 0xe3, 0x56,
			0xad, 0x4a, 0x7b, 0xfd, 0xa6, 0xd3, 0xc0, 0xcc,
			0x9f, 0xf3, 0x81, 0x63, 0x89, 0x63, 0xe4, 0x62,
			0x57, 0xde, 0x08, 0x7b, 0xbd, 0xd5, 0xe8, 0xcc,
			0x37, 0x63, 0x83, 0x6b, 0x4e, 0x83, 0x3a, 0x42,
		},
		/* S4 : 256 byte */
		{
			0xbe, 0x69, 0xc5, 0x4d, 0xad, 0x9d, 0x8b, 0x6d,
			0xb7, 0x67, 0x6f, 0xe7, 0x43, 0x21, 0xa0, 0xae,
			0xb0, 0x8d, 0x1c, 0xc1, 0x7f, 0x66, 0x07, 0xe8,
			0x79, 0x82, 0xf9, 0x94, 0x89, 0x34, 0x4e, 0x99,
			0x37, 0x8c, 0x38, 0x34, 0x1e, 0x0e, 0x60, 0x5b,
			0x8f, 0xf9, 0x03, 0xc7, 0x4a, 0x97, 0x38, 0x72,
			0xa9, 0x88, 0x0e, 0x05, 0xa8, 0xef, 0x0b, 0xd3,
			0xe6, 0x04, 0x99, 0x31, 0xac, 0xf1, 0x52, 0xdd,
			0x54, 0xfe, 0xc9, 0x10, 0x5a, 0x57, 0xb7, 0x3f,
			0x77, 0x63, 0x1d, 0xb7, 0x36, 0xb4, 0x27, 0xf1,
			0xbd, 0x83, 0x27, 0x5e, 0x01, 0x73, 0xd4, 0xe0,
			0x9c, 0xd4, 0xf8, 0xc3, 0x82, 0xe8, 0xb5, 0x02,
			0xa3, 0xb0, 0xad, 0xbd, 0x0c, 0x68, 0x91, 0x1d,
			0x02, 0xde, 0x17, 0xff, 0xf3, 0xd9, 0x27, 0xe2,
			0x50, 0xe1, 0x82, 0x67, 0x62, 0xef, 0xc0, 0xb8,
			0x95, 0xdf, 0xa5, 0x02, 0xf1, 0x8d, 0xc3, 0x34,
			0xb4, 0xc5, 0x73, 0xf9, 0x9b, 0x51, 0xb7, 0x4f,
			0xdd, 0x23, 0x00, 0x98, 0x61, 0x02, 0x8f, 0x1e,
			0xed, 0x68, 0x75, 0xbf, 0x31, 0xd5, 0x57, 0xac,
			0xd6, 0xde, 0x8f, 0x63, 0xfa, 0x12, 0x74, 0xf7,
			0xbe, 0xd7, 0xa1, 0xb4, 0xc0, 0x79, 0xf5, 0xa9,
			0xb8, 0x5b, 0xfa, 0xb2, 0x9f, 0x55, 0x2c, 0x7f,
			0x64, 0x7d, 0x6c, 0x92, 0x41, 0x56, 0x3f, 0xac,
			0x12, 0x3a, 0x73, 0x96, 0x74, 0xb0, 0xad, 0x09,
			0xc3, 0xf9, 0x42, 0x08, 0x79, 0x5d, 0x9a, 0x50,
			0x52, 0x9d, 0x79, 0x9a, 0xfc, 0x59, 0x7e, 0x02,
			0x5f, 0x12, 0x54, 0x99, 0x5f, 0x04, 0x32, 0x34,
			0x89, 0x16, 0x20, 0xb1, 0x0d, 0x5c, 0x55, 0x69,
			0xbe, 0x14, 0xb0, 0xf4, 0x63, 0xa4, 0x95, 0xf4,
			0x16, 0x02, 0x46, 0x18, 0x48, 0x6c, 0x7f, 0xf5,
			0xec, 0x77, 0x5c, 0xfb, 0x46, 0xfb, 0xdf, 0xf5,
			0x37, 0x9c, 0x5e, 0x09, 0x15, 0x0b, 0x81, 0xa3,
		},
		20, /* salt length */
		/* V4 : 20 byte */
		{
			0xe1, 0x25, 0x6f, 0xc1, 0xee, 0xef, 0x81, 0x77,
			0x3f, 0xdd, 0x54, 0x65, 0x7e, 0x40, 0x07, 0xfd,
			0xe6, 0xbc, 0xb9, 0xb1, 
		},
	},
	/* SHA256 [5] */
	{
		/* Msg5 : 128 byte */
		{
			0x21, 0x85, 0x51, 0xf4, 0x25, 0xb3, 0x55, 0x7d,
			0x09, 0xcc, 0xfd, 0xec, 0xc9, 0xab, 0x49, 0x90,
			0x85, 0xbd, 0x7f, 0xe7, 0xd6, 0x08, 0x20, 0xbe,
			0x62, 0x6c, 0x1a, 0x9a, 0xae, 0x29, 0x3f, 0x57,
			0x34, 0xa2, 0xf6, 0x0f, 0xb6, 0x61, 0x31, 0x3d,
			0xd1, 0x5a, 0x9f, 0x22, 0xd5, 0x74, 0x22, 0x68,
			0xd4, 0x45, 0x83, 0x06, 0xf9, 0x1d, 0x65, 0x63,
			0x1b, 0x47, 0x77, 0xbe, 0x92, 0x8b, 0xee, 0xcd,
			0x4a, 0xf7, 0x33, 0xa4, 0x16, 0xe0, 0xd8, 0xd9,
			0x46, 0x23, 0xd1, 0xe6, 0x7b, 0xb0, 0xe1, 0xce,
			0xba, 0x4a, 0x52, 0x04, 0xc0, 0x88, 0xe9, 0x88,
			0x95, 0x20, 0x19, 0x53, 0x64, 0x64, 0x77, 0xf5,
			0x8a, 0x0d, 0x6e, 0x7d, 0xed, 0x38, 0x34, 0x99,
			0x8f, 0xae, 0xfc, 0xfe, 0x63, 0x68, 0x6e, 0x0a,
			0x5f, 0x53, 0x54, 0xa8, 0xd2, 0x50, 0x96, 0x75,
			0xf8, 0x7f, 0x68, 0x21, 0xcb, 0xbd, 0xc2, 0x17,
		},
		/* S5 : 256 byte */
		{
			0x96, 0xa2, 0x69, 0xe0, 0xca, 0x4a, 0xf6, 0x26,
			0xaa, 0x8b, 0x7f, 0x45, 0xac, 0xda, 0xa7, 0x6d,
			0x5d, 0xab, 0xfe, 0xa5, 0xa7, 0xd7, 0x62, 0xab,
			0x39, 0xb1, 0x38, 0xdc, 0x75, 0x75, 0xfe, 0x19,
			0x6a, 0xeb, 0x18, 0x2b, 0xee, 0x5b, 0x18, 0x50,
			0x39, 0x69, 0xb5, 0xba, 0x11, 0x1f, 0x05, 0x7c,
			0xcd, 0xbf, 0x29, 0x2d, 0x74, 0x88, 0x17, 0x3a,
			0x4a, 0x4d, 0xd0, 0x4e, 0x62, 0xc2, 0x54, 0xd5,
			0x02, 0x67, 0x3d, 0x5a, 0x07, 0x6d, 0x32, 0x6c,
			0x66, 0xc9, 0xa7, 0x1a, 0x3b, 0x83, 0xb1, 0x00,
			0x5c, 0x63, 0x66, 0xf8, 0xa0, 0x90, 0x29, 0x87,
			0xdb, 0xf0, 0x8c, 0xee, 0x75, 0x62, 0xd0, 0xab,
			0xff, 0xbd, 0xd6, 0x61, 0xc3, 0x52, 0x5b, 0xe8,
			0xe1, 0x2d, 0xfd, 0x73, 0xed, 0x31, 0xef, 0xaa,
			0x81, 0x7f, 0x61, 0xe7, 0xfe, 0xf7, 0x00, 0xa3,
			0x21, 0x5e, 0x77, 0xb6, 0x23, 0x1d, 0x59, 0xc0,
			0x98, 0xfa, 0x45, 0x5b, 0x69, 0xec, 0x6e, 0x65,
			0x8a, 0x66, 0xcc, 0xa2, 0xe8, 0xf2, 0xe0, 0x90,
			0xef, 0x70, 0x42, 0x70, 0x99, 0x51, 0x70, 0xba,
			0x9a, 0x1f, 0x56, 0x1b, 0x84, 0x86, 0x76, 0x80,
			0x44, 0x13, 0x64, 0x5a, 0x94, 0x3d, 0x88, 0x31,
			0x91, 0xd9, 0x5b, 0x02, 0x4d, 0x6f, 0xfc, 0x9c,
			0xb6, 0x11, 0xc6, 0x8f, 0x33, 0x19, 0x40, 0x3b,
			0xd7, 0xc0, 0x7a, 0xc6, 0x69, 0x45, 0x01, 0x36,
			0x8e, 0x81, 0x47, 0xa2, 0x56, 0xe9, 0x28, 0x60,
			0x4b, 0x63, 0xd5, 0x0e, 0x2c, 0x65, 0xf3, 0xb2,
			0xc3, 0x0d, 0xf1, 0xeb, 0x03, 0x63, 0xe2, 0x9f,
			0xe4, 0x48, 0xf9, 0x4b, 0x69, 0x07, 0xcd, 0xf4,
			0x2f, 0xbc, 0x9c, 0x27, 0xb3, 0x1a, 0x43, 0xa8,
			0xf5, 0xc1, 0x5c, 0xe8, 0x13, 0xf9, 0xb2, 0x0d,
			0x16, 0xda, 0x6c, 0x29, 0x88, 0x43, 0xf0, 0x52,
			0xed, 0x37, 0x67, 0x8b, 0x4e, 0xf1, 0xd7, 0x8e,
		},
		20, /* salt length */
		/* V5 : 20 byte */
		{
			0xe1, 0x25, 0x6f, 0xc1, 0xee, 0xef, 0x81, 0x77,
			0x3f, 0xdd, 0x54, 0x65, 0x7e, 0x40, 0x07, 0xfd,
			0xe6, 0xbc, 0xb9, 0xb1, 
		},
	},
	/* SHA256 [6] */
	{
		/* Msg6 : 128 byte */
		{
			0x06, 0xb7, 0x6a, 0xae, 0xb9, 0x46, 0xfe, 0x68,
			0x67, 0xe4, 0x71, 0x6a, 0x8f, 0x1e, 0xe8, 0xd6,
			0x1c, 0x48, 0x3a, 0xb3, 0x45, 0xcb, 0xf8, 0xe5,
			0xb2, 0xbf, 0xab, 0x5c, 0xe0, 0xbd, 0x5c, 0x8b,
			0xc6, 0xee, 0x5a, 0x1c, 0xb9, 0x68, 0x37, 0xe2,
			0x8d, 0xbb, 0x14, 0x0f, 0xfd, 0xc6, 0x1e, 0xa7,
			0x4c, 0xd0, 0x59, 0x34, 0x2d, 0xd4, 0x9d, 0xbc,
			0xe1, 0x1b, 0xde, 0xf0, 0x9f, 0x10, 0xb0, 0xa6,
			0x38, 0x51, 0x09, 0x89, 0xfb, 0x02, 0x49, 0x0f,
			0xd6, 0x66, 0x79, 0xac, 0xbf, 0xb0, 0xd0, 0x46,
			0x52, 0x16, 0x7c, 0xe8, 0xbc, 0x28, 0x9f, 0xba,
			0xd7, 0x60, 0x97, 0x31, 0x96, 0xfa, 0x82, 0x83,
			0xa4, 0x05, 0x01, 0x5e, 0x48, 0xbb, 0x3d, 0xd9,
			0x8c, 0x0e, 0x28, 0xab, 0x9e, 0x83, 0x06, 0x9a,
			0x76, 0x43, 0x2b, 0x37, 0xb9, 0x70, 0x06, 0xc9,
			0xde, 0xb5, 0x5e, 0x87, 0x8f, 0x21, 0xdc, 0x0a,
		},
		/* S6 : 256 byte */
		{
			0x65, 0xe2, 0x35, 0x8b, 0xaf, 0xc9, 0xfc, 0xb6,
			0x55, 0x36, 0xa1, 0x9d, 0x27, 0xf7, 0x10, 0x59,
			0x6c, 0xc3, 0x1f, 0x9a, 0x83, 0x28, 0xcf, 0x9d,
			0xe2, 0x12, 0x57, 0x50, 0x60, 0x47, 0xab, 0x13,
			0x40, 0xa7, 0x45, 0x05, 0x58, 0x1a, 0x54, 0xf2,
			0x58, 0xbc, 0xbe, 0x0c, 0x15, 0x20, 0xf8, 0x4e,
			0xbd, 0x2e, 0x36, 0x91, 0x35, 0x60, 0xdb, 0xd7,
			0x15, 0x74, 0xe3, 0x73, 0x84, 0x28, 0x09, 0x7d,
			0x6b, 0x81, 0x9e, 0x69, 0x00, 0xf2, 0x7d, 0xf1,
			0x59, 0xdc, 0xaf, 0x08, 0xc6, 0xe1, 0x59, 0x1b,
			0x07, 0x3b, 0xfe, 0xfe, 0x3d, 0xa6, 0xbc, 0x82,
			0x7a, 0x64, 0x9e, 0x0b, 0xae, 0x9c, 0x52, 0xfe,
			0x9a, 0xe1, 0x80, 0xd1, 0xef, 0xc0, 0x1e, 0x5a,
			0x38, 0xad, 0xef, 0x10, 0x2c, 0x6d, 0x10, 0x6a,
			0xf1, 0x21, 0x63, 0xb1, 0xa0, 0xf6, 0xd1, 0x54,
			0x3f, 0xfc, 0xe3, 0x98, 0x0c, 0xa0, 0xf8, 0xb7,
			0x0d, 0x38, 0x00, 0x72, 0x88, 0xd4, 0x7b, 0xc5,
			0x65, 0xe9, 0x95, 0xb8, 0xc2, 0x1d, 0xa2, 0xf9,
			0x59, 0xc9, 0x28, 0xaa, 0x2f, 0x85, 0x74, 0xa6,
			0x60, 0x22, 0x60, 0x48, 0xdc, 0x9d, 0xba, 0x59,
			0x52, 0x6a, 0x30, 0xe3, 0x27, 0x48, 0x08, 0x68,
			0x3b, 0x41, 0xc0, 0xcf, 0x08, 0x6e, 0xa5, 0xaf,
			0xc4, 0x8e, 0xb2, 0x94, 0xa8, 0x8c, 0x4b, 0x8b,
			0x73, 0x83, 0xda, 0xe6, 0x46, 0x9e, 0x84, 0x83,
			0x34, 0x5b, 0x1d, 0xaf, 0x1d, 0x28, 0x01, 0xbd,
			0xa9, 0x3f, 0xf9, 0x1c, 0xa7, 0x5d, 0xfa, 0xa8,
			0xdd, 0x5d, 0x47, 0xe7, 0x3c, 0xec, 0xf0, 0xef,
			0xb0, 0x62, 0x9f, 0xda, 0x16, 0xc6, 0x01, 0x07,
			0x0b, 0xee, 0x2e, 0x8c, 0xc0, 0x69, 0x51, 0x50,
			0x73, 0x92, 0x02, 0xe3, 0xbe, 0x27, 0x0b, 0x98,
			0x01, 0xd0, 0x85, 0xe1, 0x1e, 0x1d, 0xf0, 0x7f,
			0x9a, 0x4c, 0xab, 0x54, 0xfd, 0xa2, 0x3d, 0xa6,
		},
		20, /* salt length */
		/* V6 : 20 byte */
		{
			0xe1, 0x25, 0x6f, 0xc1, 0xee, 0xef, 0x81, 0x77,
			0x3f, 0xdd, 0x54, 0x65, 0x7e, 0x40, 0x07, 0xfd,
			0xe6, 0xbc, 0xb9, 0xb1, 
		},
	},
	/* SHA256 [7] */
	{
		/* Msg7 : 128 byte */
		{
			0xf9, 0x16, 0x70, 0xbf, 0x6b, 0x8b, 0xf5, 0xc8,
			0xc7, 0x50, 0x56, 0xd8, 0x44, 0x16, 0x8f, 0xc6,
			0xec, 0x0c, 0x28, 0xd0, 0x94, 0x00, 0xc1, 0xdf,
			0x11, 0xc7, 0xef, 0x0d, 0xa9, 0xe0, 0x46, 0x64,
			0xc8, 0x54, 0xb7, 0xe8, 0xf4, 0xe0, 0x1d, 0xd8,
			0x03, 0x56, 0x12, 0x32, 0x8c, 0x41, 0x07, 0x75,
			0x9b, 0xc8, 0x94, 0xaa, 0xa9, 0xd5, 0x0c, 0xa5,
			0xcb, 0x76, 0x55, 0x89, 0x29, 0x83, 0xf6, 0x8a,
			0xb2, 0x81, 0x72, 0xf7, 0x0e, 0xc6, 0xd5, 0x77,
			0xd4, 0xde, 0x8c, 0x93, 0xfe, 0x2e, 0x79, 0x74,
			0x9a, 0xd7, 0x47, 0xee, 0xc2, 0xdd, 0xfb, 0xbe,
			0xcd, 0x89, 0xcc, 0x10, 0xc7, 0x0b, 0x35, 0x45,
			0x1f, 0x64, 0x48, 0xf2, 0xa0, 0x83, 0x45, 0x2c,
			0xa2, 0xae, 0x6b, 0x03, 0x82, 0x24, 0x0e, 0x4c,
			0x4f, 0x01, 0xea, 0xa4, 0xc6, 0x61, 0xb7, 0xb1,
			0x81, 0xc8, 0xfe, 0xab, 0x6b, 0xc2, 0x2a, 0x1b,
		},
		/* S7 : 256 byte */
		{
			0x2e, 0xac, 0x03, 0x23, 0x3c, 0x4e, 0x24, 0xb3,
			0x32, 0x84, 0x47, 0xcc, 0x09, 0x66, 0x1c, 0x25,
			0x96, 0x76, 0xb5, 0x69, 0xe6, 0xa0, 0x84, 0x8b,
			0x5a, 0x19, 0x30, 0x65, 0x29, 0x6a, 0x59, 0xe3,
			0xb6, 0xd3, 0x5a, 0x2e, 0xcd, 0x91, 0xc6, 0xce,
			0xfd, 0xa4, 0xf2, 0xbf, 0x9f, 0x22, 0x52, 0xa2,
			0x73, 0x34, 0xfb, 0xbc, 0x2d, 0x79, 0xe4, 0x50,
			0xd4, 0x4b, 0xc2, 0x82, 0xf7, 0xd7, 0x32, 0x1b,
			0x46, 0xf8, 0x20, 0x28, 0xc1, 0x54, 0xf3, 0x0f,
			0x6d, 0x62, 0xed, 0xf3, 0x67, 0x2a, 0x10, 0x19,
			0xd9, 0x14, 0xec, 0x61, 0x7a, 0xab, 0x2d, 0x00,
			0x7f, 0x84, 0x4e, 0x63, 0xe2, 0x95, 0xbb, 0xd8,
			0xf6, 0x61, 0x63, 0xde, 0xb2, 0x78, 0xd9, 0x9d,
			0x66, 0xfd, 0xdc, 0x58, 0xcc, 0xa2, 0xb9, 0x11,
			0xce, 0x0a, 0xf9, 0x52, 0x65, 0x13, 0x4a, 0xf5,
			0x5a, 0x4b, 0x78, 0x6c, 0xc2, 0x14, 0xfa, 0x11,
			0xff, 0xa2, 0x9b, 0xcd, 0xfb, 0xed, 0x12, 0xc5,
			0xce, 0x64, 0x38, 0xe9, 0xb6, 0xbe, 0xae, 0xff,
			0xa3, 0x58, 0x79, 0x78, 0xa8, 0x34, 0x09, 0xc2,
			0x9f, 0x11, 0x54, 0x23, 0x17, 0x4c, 0x05, 0xcb,
			0x8c, 0x30, 0x19, 0x8d, 0xa8, 0xb1, 0x93, 0xf9,
			0x44, 0x6b, 0x9b, 0x49, 0xf7, 0xe3, 0xe2, 0x86,
			0x2e, 0xc9, 0xa3, 0x50, 0xe8, 0x44, 0x1b, 0xa4,
			0xe5, 0x55, 0x0e, 0x87, 0xdb, 0x54, 0x71, 0x28,
			0x65, 0xfc, 0x26, 0x90, 0xa5, 0x93, 0x8a, 0xeb,
			0xb2, 0x84, 0x09, 0xb8, 0x8c, 0xf0, 0xd1, 0x72,
			0x11, 0x1a, 0x74, 0xf6, 0x78, 0xee, 0x08, 0x19,
			0xff, 0x8b, 0xdc, 0x22, 0xb0, 0x8f, 0xc6, 0xfe,
			0xd3, 0x7b, 0x67, 0x6d, 0x07, 0x05, 0x39, 0x6f,
			0x32, 0x47, 0xa2, 0x67, 0xc6, 0x0f, 0x7c, 0xcf,
			0x1f, 0xb2, 0x60, 0xc0, 0xc2, 0xe9, 0x24, 0xc1,
			0xef, 0x55, 0x40, 0xeb, 0x61, 0x25, 0xf3, 0xb1,
		},
		20, /* salt length */
		/* V7 : 20 byte */
		{
			0xe1, 0x25, 0x6f, 0xc1, 0xee, 0xef, 0x81, 0x77,
			0x3f, 0xdd, 0x54, 0x65, 0x7e, 0x40, 0x07, 0xfd,
			0xe6, 0xbc, 0xb9, 0xb1, 
		},
	},
	/* SHA256 [8] */
	{
		/* Msg8 : 128 byte */
		{
			0x64, 0xe3, 0xf5, 0x41, 0x45, 0x31, 0x70, 0xdb,
			0x95, 0x2c, 0x09, 0xb9, 0x3f, 0x98, 0xbc, 0xf5,
			0xcb, 0x77, 0xd8, 0xb4, 0x98, 0x38, 0x61, 0xfa,
			0x65, 0x2c, 0xb2, 0xc3, 0x16, 0x39, 0x66, 0x4f,
			0xb5, 0xd2, 0x79, 0xbd, 0xb8, 0x26, 0xab, 0xdb,
			0x82, 0x98, 0x25, 0x3d, 0x2c, 0x70, 0x5f, 0x8c,
			0x84, 0xd0, 0x41, 0x21, 0x56, 0xe9, 0x89, 0xd2,
			0xeb, 0x6e, 0x6c, 0x0c, 0xd0, 0x49, 0x80, 0x23,
			0xd8, 0x8e, 0xd9, 0xe5, 0x64, 0xad, 0x72, 0x75,
			0xe2, 0xeb, 0xcf, 0x57, 0x94, 0x13, 0xe1, 0xc7,
			0x93, 0x68, 0x2a, 0x4f, 0x13, 0xdf, 0x22, 0x98,
			0xe8, 0x8b, 0xd8, 0x81, 0x4a, 0x59, 0xdc, 0x6e,
			0xd5, 0xfd, 0x5d, 0xe2, 0xd3, 0x2c, 0x8f, 0x51,
			0xbe, 0x0c, 0x4f, 0x2f, 0x01, 0xe9, 0x0a, 0x4d,
			0xff, 0x29, 0xdb, 0x65, 0x56, 0x82, 0xf3, 0xf4,
			0x65, 0x6a, 0x3e, 0x47, 0x0c, 0xcf, 0x44, 0xd9,
		},
		/* S8 : 256 byte */
		{
			0x76, 0xc2, 0x97, 0xfb, 0xe3, 0x02, 0xf6, 0x86,
			0x37, 0x7c, 0xb1, 0x55, 0xae, 0x8a, 0x2b, 0x65,
			0xa6, 0xc5, 0x77, 0xaf, 0x30, 0x30, 0x35, 0xc4,
			0xa7, 0x55, 0xfe, 0x67, 0x01, 0x4c, 0x56, 0x04,
			0x76, 0xe7, 0xa7, 0x89, 0xb8, 0xf2, 0x19, 0x5b,
			0x0f, 0x80, 0x41, 0x6f, 0x5f, 0x33, 0xb7, 0xfd,
			0xcc, 0xc3, 0x80, 0xf9, 0x88, 0xce, 0xba, 0xdb,
			0x64, 0x0e, 0x35, 0x4b, 0xf5, 0x67, 0x9e, 0xe9,
			0x73, 0xa1, 0xe1, 0x48, 0x5b, 0x68, 0xbe, 0x43,
			0x2b, 0x44, 0x6f, 0xf5, 0x94, 0x95, 0x04, 0x51,
			0x5a, 0x65, 0xcd, 0xdb, 0x0f, 0xaf, 0x6d, 0xcd,
			0x1e, 0x11, 0x88, 0x65, 0x6c, 0xe9, 0x41, 0xaf,
			0x3d, 0xdc, 0x86, 0x00, 0xcf, 0x0e, 0x40, 0x87,
			0xac, 0x83, 0x82, 0xf0, 0xd5, 0x06, 0x1d, 0x3d,
			0x05, 0xf5, 0x8c, 0x93, 0x62, 0xeb, 0x88, 0xf3,
			0x0a, 0x72, 0x4d, 0x18, 0xa1, 0x5e, 0xe6, 0x8a,
			0x60, 0xc5, 0xe4, 0xde, 0xdb, 0x40, 0x84, 0xc9,
			0xd0, 0x15, 0x22, 0x99, 0x90, 0x92, 0x09, 0x4c,
			0x85, 0x62, 0x2e, 0x67, 0xa6, 0x6e, 0xd0, 0x34,
			0x56, 0x4a, 0xc2, 0x86, 0xb0, 0xff, 0x87, 0x91,
			0xe9, 0x93, 0x3a, 0x23, 0xf8, 0x3b, 0x4a, 0x88,
			0xd2, 0xe7, 0x9e, 0x3a, 0x29, 0xd6, 0xa3, 0xf8,
			0x7e, 0x63, 0xbb, 0x1a, 0x96, 0xa6, 0xbf, 0xd6,
			0x89, 0x8e, 0xda, 0xa9, 0x38, 0xf7, 0x4c, 0x72,
			0xd6, 0xc1, 0x0c, 0xb9, 0x4d, 0x05, 0x5e, 0xf3,
			0xfd, 0xa9, 0xe6, 0xdd, 0x09, 0x7d, 0x52, 0x73,
			0x87, 0x54, 0x80, 0x0e, 0xd4, 0x03, 0xb1, 0x44,
			0x41, 0x95, 0xa3, 0x11, 0xfd, 0x69, 0x62, 0x00,
			0x79, 0x99, 0xe3, 0x1e, 0xdc, 0xf2, 0x87, 0x0d,
			0x1c, 0x3a, 0xe3, 0xb3, 0x64, 0x6b, 0xc7, 0xda,
			0x55, 0xe5, 0xf1, 0xe6, 0x62, 0x7e, 0x62, 0x48,
			0x83, 0x9e, 0x8f, 0x70, 0xb9, 0x97, 0xfc, 0x1e,
		},
		20, /* salt length */
		/* V8 : 20 byte */
		{
			0xe1, 0x25, 0x6f, 0xc1, 0xee, 0xef, 0x81, 0x77,
			0x3f, 0xdd, 0x54, 0x65, 0x7e, 0x40, 0x07, 0xfd,
			0xe6, 0xbc, 0xb9, 0xb1, 
		},
	},
	/* SHA256 [9] */
	{
		/* Msg9 : 128 byte */
		{
			0x33, 0xba, 0x93, 0x2a, 0xaf, 0x38, 0x84, 0x58,
			0x63, 0x9f, 0x06, 0xeb, 0x9d, 0x52, 0x01, 0xfc,
			0xa5, 0xd1, 0x06, 0xaa, 0xa8, 0xde, 0xdf, 0x61,
			0xf5, 0xde, 0x6b, 0x5d, 0x6c, 0x81, 0xa9, 0x69,
			0x32, 0xa5, 0x12, 0xed, 0xaa, 0x78, 0x2c, 0x27,
			0xa1, 0xdd, 0x5c, 0xb9, 0xc9, 0x12, 0xfb, 0x64,
			0x69, 0x8f, 0xad, 0x13, 0x52, 0x31, 0xee, 0x1b,
			0x15, 0x97, 0xee, 0xc1, 0x73, 0xcd, 0x9f, 0xfd,
			0x15, 0x27, 0x0c, 0x7d, 0x7e, 0x70, 0xec, 0xed,
			0x3d, 0x44, 0x77, 0x76, 0x67, 0xbb, 0x78, 0x84,
			0x44, 0x48, 0xa4, 0xcd, 0x49, 0xe0, 0x2a, 0x8f,
			0x46, 0x5e, 0x8b, 0x18, 0xe1, 0x26, 0xac, 0x8c,
			0x43, 0x08, 0x2a, 0xe3, 0x11, 0x68, 0xed, 0x31,
			0x9e, 0x9c, 0x00, 0x2a, 0x5f, 0x96, 0x9f, 0xe5,
			0x9f, 0xc3, 0x92, 0xe0, 0x73, 0x32, 0xba, 0x45,
			0xf1, 0xf9, 0xea, 0x6b, 0x9d, 0xd5, 0xf8, 0xa0,
		},
		/* S9 : 256 byte */
		{
			0x28, 0x91, 0xcb, 0xe2, 0x3c, 0xcf, 0x10, 0xc3,
			0x96, 0xef, 0x76, 0xa5, 0x84, 0x0a, 0xda, 0xad,
			0x64, 0x98, 0xb6, 0xfc, 0x8c, 0x6a, 0x2f, 0x6c,
			0x26, 0x49, 0x6c, 0xb4, 0x28, 0xa9, 0x22, 0x1e,
			0xd5, 0x9b, 0x36, 0x45, 0xf9, 0xa2, 0x5f, 0x57,
			0x47, 0xfe, 0xda, 0x0f, 0x51, 0xb4, 0x53, 0x19,
			0xe0, 0x97, 0x8f, 0x22, 0xac, 0x4f, 0xac, 0xbc,
			0x15, 0xdb, 0x9a, 0x4e, 0x58, 0x49, 0xac, 0x2a,
			0x14, 0x04, 0xae, 0xb6, 0xc0, 0x0e, 0x5e, 0xed,
			0x3c, 0x07, 0xee, 0xee, 0xe2, 0x43, 0x56, 0x68,
			0xfd, 0x17, 0xf1, 0x6a, 0xb2, 0x44, 0xc9, 0xd3,
			0x8f, 0x9b, 0xa0, 0xde, 0x9d, 0x3f, 0x3e, 0xf0,
			0xd9, 0x94, 0x09, 0x4e, 0x92, 0xe3, 0x27, 0x94,
			0x8f, 0x14, 0x09, 0xef, 0x82, 0x77, 0x52, 0x34,
			0x4a, 0x13, 0x75, 0xf6, 0x08, 0xdc, 0x3c, 0xaf,
			0xe7, 0x49, 0x70, 0x74, 0x5a, 0x02, 0x3b, 0x32,
			0x0b, 0x3b, 0xd3, 0x17, 0x1b, 0x62, 0xa6, 0x8a,
			0x5c, 0xca, 0xad, 0xbc, 0x64, 0xb8, 0x2c, 0xee,
			0x4b, 0x8a, 0x81, 0x84, 0x0e, 0xd8, 0xb7, 0x51,
			0xac, 0x66, 0xa2, 0x9e, 0xb8, 0x1f, 0xb8, 0x19,
			0xec, 0x54, 0xc7, 0x6b, 0x01, 0xc7, 0xb4, 0x12,
			0xa4, 0x3e, 0xa0, 0x57, 0xa8, 0x02, 0x02, 0xf1,
			0xc3, 0xc0, 0x6a, 0x4e, 0xe6, 0x05, 0x47, 0xc1,
			0x3c, 0x6c, 0x2f, 0xac, 0x34, 0xa5, 0xd5, 0xaa,
			0xe9, 0x82, 0xb9, 0xda, 0xbd, 0x11, 0x9b, 0x47,
			0x08, 0x29, 0xbd, 0x77, 0xa5, 0x60, 0xe0, 0x97,
			0x34, 0x09, 0x11, 0x5b, 0xd1, 0xab, 0x5b, 0xdc,
			0x6b, 0xb4, 0x6f, 0xe4, 0x04, 0x80, 0x22, 0xb0,
			0xcf, 0x4f, 0xc6, 0xaa, 0xd4, 0x18, 0x4c, 0x28,
			0x62, 0x1e, 0xc6, 0xf8, 0x2e, 0xdb, 0x54, 0x73,
			0x3c, 0x90, 0x26, 0x20, 0xbf, 0x45, 0xf2, 0x51,
			0x7f, 0x24, 0x90, 0x2e, 0x56, 0xd5, 0x80, 0x38,
		},
		20, /* salt length */
		/* V9 : 20 byte */
		{
			0xe1, 0x25, 0x6f, 0xc1, 0xee, 0xef, 0x81, 0x77,
			0x3f, 0xdd, 0x54, 0x65, 0x7e, 0x40, 0x07, 0xfd,
			0xe6, 0xbc, 0xb9, 0xb1, 
		},
	},
};

/* 10 elements */
static mod2048_t SHA384[] = {
	/* SHA384 [0] */
	{
		/* Msg0 : 128 byte */
		{
			0x83, 0x3a, 0xa2, 0xb1, 0xdc, 0xc7, 0x76, 0x07,
			0xa4, 0x4e, 0x80, 0x4e, 0xe7, 0x7d, 0x45, 0x40,
			0x85, 0x86, 0xc5, 0x36, 0x86, 0x1f, 0x66, 0x48,
			0xad, 0xcd, 0x2f, 0xb6, 0x50, 0x63, 0x36, 0x87,
			0x67, 0xc5, 0x5c, 0x6f, 0xe2, 0xf2, 0x37, 0xf6,
			0x40, 0x42, 0x50, 0xd7, 0x5d, 0xec, 0x8f, 0xa6,
			0x8b, 0xca, 0xf3, 0xb6, 0xe5, 0x61, 0x86, 0x3a,
			0xe0, 0x1c, 0x91, 0xaa, 0x23, 0xd8, 0x0c, 0x69,
			0x99, 0xa5, 0x58, 0xa4, 0xc4, 0xcb, 0x31, 0x7d,
			0x54, 0x0c, 0xde, 0x69, 0xf8, 0x29, 0xaa, 0xd6,
			0x74, 0xa8, 0x98, 0x12, 0xf4, 0xd3, 0x53, 0x68,
			0x9f, 0x04, 0x64, 0x8c, 0x70, 0x20, 0xa7, 0x39,
			0x41, 0x62, 0x00, 0x18, 0x29, 0x5a, 0x4a, 0xe4,
			0x08, 0x35, 0x90, 0xcc, 0x60, 0x3e, 0x80, 0x18,
			0x67, 0xa5, 0x1c, 0x10, 0x5a, 0x7f, 0xb3, 0x19,
			0x13, 0x0f, 0x10, 0x22, 0xde, 0x44, 0xf1, 0x3e,
		},
		/* S0 : 256 byte */
		{
			0x2c, 0xa3, 0x7a, 0x3d, 0x6a, 0xbd, 0x28, 0xc1,
			0xea, 0xf9, 0xbd, 0xe5, 0xe7, 0xac, 0x17, 0xf1,
			0xfa, 0x79, 0x9c, 0xe1, 0xb4, 0xb8, 0x99, 0xd1,
			0x99, 0x85, 0xc2, 0xff, 0x7c, 0x8b, 0xa9, 0x59,
			0xfe, 0x54, 0xe5, 0xaf, 0xb8, 0xbc, 0x40, 0x21,
			0xa1, 0xf1, 0xc6, 0x87, 0xee, 0xbb, 0x8c, 0xba,
			0x80, 0x0d, 0x1c, 0x51, 0x63, 0x6b, 0x1f, 0x68,
			0xdc, 0x3e, 0x48, 0xf6, 0x3e, 0x2d, 0xa6, 0xbc,
			0x6d, 0x09, 0xc6, 0x66, 0x8f, 0x68, 0xe5, 0x08,
			0xc5, 0xd8, 0xc1, 0x9b, 0xef, 0x15, 0x47, 0x59,
			0xe2, 0xf8, 0x9a, 0xde, 0x15, 0x27, 0x17, 0x37,
			0x0a, 0x89, 0x44, 0xf5, 0x37, 0x57, 0x82, 0x96,
			0x38, 0x0d, 0x1f, 0xe6, 0xbe, 0x80, 0x9e, 0x8b,
			0x11, 0x3d, 0x2b, 0x9d, 0x89, 0xe6, 0xa4, 0x6f,
			0x5c, 0x33, 0x3d, 0x4f, 0xd4, 0x87, 0x70, 0xfc,
			0x1e, 0xa1, 0xc5, 0x48, 0x10, 0x45, 0x75, 0xb8,
			0x4c, 0xf0, 0x71, 0x04, 0x2b, 0xfe, 0x5a, 0xcf,
			0x49, 0x63, 0x92, 0xbe, 0x83, 0x51, 0xa4, 0x1c,
			0x46, 0xa2, 0xca, 0xb0, 0x86, 0x4c, 0x4c, 0x1c,
			0x5b, 0x5e, 0x0c, 0x7b, 0x27, 0xe7, 0xb8, 0x8c,
			0x69, 0xf3, 0x7f, 0xfa, 0x7e, 0x1a, 0x8c, 0xd9,
			0x8f, 0x34, 0x3a, 0xc8, 0x4a, 0x4a, 0xd6, 0x70,
			0x25, 0xa4, 0x0e, 0xd8, 0xf6, 0x64, 0xe9, 0xd6,
			0x30, 0x33, 0x7d, 0xe6, 0xe4, 0x8b, 0xb2, 0x12,
			0x5e, 0x25, 0x52, 0x12, 0x36, 0x09, 0x49, 0x1f,
			0x18, 0x3a, 0xfd, 0x92, 0x63, 0x44, 0x87, 0xf0,
			0xb2, 0xcf, 0x97, 0x1f, 0x26, 0x26, 0xe8, 0x88,
			0x58, 0x87, 0x9d, 0x45, 0xa2, 0x9b, 0x0f, 0xef,
			0xb6, 0x6c, 0xd4, 0x1b, 0x2e, 0x4e, 0x96, 0x83,
			0x85, 0xbd, 0x9f, 0xc8, 0xc7, 0x21, 0x19, 0x76,
			0xbc, 0x6b, 0xd3, 0xe1, 0xad, 0x6d, 0xf6, 0x08,
			0x56, 0x98, 0x5a, 0x82, 0x5f, 0x47, 0x26, 0xd2,
		},
		25, /* salt length */
		/* V0 : 25 byte */
		{
			0xb7, 0x50, 0x58, 0x76, 0x71, 0xaf, 0xd7, 0x68,
			0x86, 0xe8, 0xff, 0xb7, 0x86, 0x5e, 0x78, 0xf7,
			0x06, 0x64, 0x1b, 0x2e, 0x42, 0x51, 0xb4, 0x87,
			0x06, 
		},
	},
	/* SHA384 [1] */
	{
		/* Msg1 : 128 byte */
		{
			0x89, 0x25, 0xb8, 0x7e, 0x9d, 0x1d, 0x73, 0x9d,
			0x8f, 0x97, 0x54, 0x50, 0xb7, 0x9d, 0x09, 0x19,
			0xdd, 0xe6, 0x3e, 0x8a, 0x9e, 0xaa, 0x1c, 0xb5,
			0x11, 0xb4, 0x0f, 0xe3, 0xab, 0xb9, 0xcd, 0x89,
			0x60, 0xe8, 0x94, 0x77, 0x0b, 0xc2, 0xb2, 0x53,
			0x10, 0x2c, 0x4b, 0x46, 0x40, 0xc3, 0x57, 0xf5,
			0xfd, 0x6f, 0xea, 0xb3, 0x9e, 0x3b, 0xb8, 0xf4,
			0x15, 0x64, 0xd8, 0x05, 0xce, 0xaf, 0xc8, 0xfb,
			0xdb, 0x00, 0xb2, 0xea, 0x4f, 0x29, 0xed, 0x57,
			0xe7, 0x00, 0xc7, 0xef, 0xf0, 0xb4, 0x82, 0x79,
			0x64, 0x61, 0x9c, 0x09, 0x57, 0xe1, 0x54, 0x76,
			0x91, 0xe6, 0x69, 0x0f, 0x7d, 0x45, 0x25, 0x8a,
			0x42, 0x95, 0x9a, 0x3d, 0x2f, 0xf9, 0x2c, 0x91,
			0x5c, 0x3a, 0x4f, 0xb3, 0x8e, 0x19, 0x92, 0x8c,
			0x5c, 0xe3, 0xdd, 0xf4, 0x90, 0x45, 0xf6, 0x22,
			0xd0, 0x62, 0x4a, 0x67, 0x7e, 0x23, 0xeb, 0x1d,
		},
		/* S1 : 256 byte */
		{
			0x43, 0xef, 0x93, 0xd1, 0x4e, 0x89, 0xb0, 0x5d,
			0x5e, 0x0d, 0xb2, 0xdb, 0xd5, 0x7a, 0x12, 0x40,
			0x39, 0x10, 0x64, 0x6b, 0x4b, 0x0a, 0x24, 0xd9,
			0xb8, 0x0d, 0x94, 0x79, 0x54, 0x59, 0x1a, 0xfa,
			0x6e, 0x98, 0x09, 0xe9, 0x6d, 0x7d, 0x3e, 0x71,
			0x10, 0x03, 0xee, 0x0a, 0x91, 0x86, 0xab, 0x3d,
			0x8e, 0x0b, 0x4d, 0x34, 0x25, 0xc6, 0xda, 0x4b,
			0x5f, 0x78, 0x99, 0x53, 0x7e, 0x73, 0x7b, 0x71,
			0xdf, 0x9e, 0xd6, 0x35, 0x55, 0x29, 0xaa, 0xce,
			0x77, 0xa7, 0xcb, 0xa9, 0x6b, 0x5b, 0x0a, 0x86,
			0x39, 0x92, 0x52, 0xf1, 0x28, 0x6a, 0x6f, 0xca,
			0xb1, 0x80, 0xb5, 0x98, 0x45, 0x5d, 0xfe, 0x1d,
			0xe4, 0xb8, 0x04, 0x70, 0xd0, 0x63, 0x18, 0xd5,
			0xf7, 0xa5, 0x2e, 0x45, 0xb6, 0xd0, 0xbc, 0xc0,
			0x0b, 0xd3, 0x65, 0x81, 0x9a, 0x4a, 0x14, 0x2b,
			0x83, 0x07, 0x27, 0x75, 0xf4, 0x85, 0xf6, 0x3c,
			0x80, 0x04, 0xf5, 0x33, 0x78, 0xa9, 0xa0, 0xd2,
			0x34, 0x5d, 0x07, 0xb1, 0xb3, 0x26, 0x23, 0x8e,
			0xd0, 0x70, 0xd1, 0xe6, 0x9f, 0xc0, 0xb5, 0xcf,
			0x85, 0x3a, 0x80, 0x7c, 0xfb, 0x72, 0x35, 0x62,
			0xd1, 0xf5, 0x68, 0x24, 0x82, 0xe8, 0xa4, 0x84,
			0x05, 0x88, 0xbc, 0xc7, 0x15, 0x4c, 0xe0, 0x74,
			0x0c, 0x76, 0x86, 0x16, 0xcf, 0x04, 0xd7, 0xaa,
			0x10, 0x36, 0x42, 0x91, 0x7e, 0xc5, 0xb4, 0xb5,
			0x14, 0xa3, 0x73, 0x4d, 0x9e, 0x0c, 0x58, 0x42,
			0x7c, 0xff, 0x42, 0xf2, 0x7f, 0x43, 0xfd, 0xfc,
			0x85, 0x99, 0x1e, 0x04, 0x5a, 0xcd, 0x17, 0xaf,
			0x6f, 0xba, 0x7b, 0xda, 0xb8, 0x18, 0xe9, 0x0e,
			0xb4, 0x11, 0x76, 0x84, 0xe8, 0x9f, 0x91, 0x63,
			0xdf, 0xf7, 0xb9, 0x8b, 0x82, 0xa0, 0x8b, 0xaa,
			0x2b, 0x49, 0xac, 0xde, 0x48, 0x0c, 0x57, 0x02,
			0xc3, 0x35, 0x23, 0x7d, 0x1b, 0xe7, 0x71, 0xb7,
		},
		25, /* salt length */
		/* V1 : 25 byte */
		{
			0xb7, 0x50, 0x58, 0x76, 0x71, 0xaf, 0xd7, 0x68,
			0x86, 0xe8, 0xff, 0xb7, 0x86, 0x5e, 0x78, 0xf7,
			0x06, 0x64, 0x1b, 0x2e, 0x42, 0x51, 0xb4, 0x87,
			0x06, 
		},
	},
	/* SHA384 [2] */
	{
		/* Msg2 : 128 byte */
		{
			0xd0, 0xeb, 0x46, 0x23, 0xee, 0xdb, 0xd9, 0x7e,
			0xe0, 0x36, 0x72, 0xf8, 0xe4, 0x17, 0x4d, 0x2e,
			0x30, 0xa6, 0x83, 0x23, 0xce, 0x99, 0x80, 0xe2,
			0xaa, 0xfb, 0xb8, 0x64, 0xea, 0x2c, 0x96, 0xb3,
			0x7d, 0x2a, 0xb5, 0x50, 0xf7, 0x0e, 0x53, 0xd2,
			0x9c, 0xda, 0x03, 0xd1, 0xba, 0x71, 0xa1, 0x02,
			0x3d, 0xe7, 0x8b, 0xa3, 0x7d, 0xfb, 0x0e, 0x1a,
			0x5a, 0xe2, 0x1f, 0xd9, 0x8b, 0x47, 0x4c, 0x84,
			0x33, 0x8f, 0xf2, 0x56, 0xb5, 0x61, 0xaf, 0xc1,
			0xca, 0x66, 0x1a, 0x54, 0xd1, 0x4d, 0xb2, 0xe2,
			0x66, 0x13, 0x15, 0xe1, 0x35, 0x81, 0x73, 0x10,
			0x10, 0xf6, 0x41, 0x5d, 0x40, 0x66, 0x32, 0x05,
			0x19, 0xa3, 0x63, 0xfd, 0xd2, 0xdb, 0xd5, 0x91,
			0x93, 0x62, 0x21, 0x4b, 0xce, 0xb2, 0x67, 0x16,
			0xd3, 0xb1, 0x88, 0xa3, 0x9f, 0x32, 0x95, 0x0c,
			0xf5, 0xbd, 0x87, 0xb7, 0xb1, 0x93, 0x30, 0x7e,
		},
		/* S2 : 256 byte */
		{
			0x21, 0x3e, 0xa3, 0xfb, 0x11, 0xcd, 0xd7, 0x1b,
			0xd5, 0xb8, 0x39, 0xde, 0x8a, 0x59, 0x8b, 0x6a,
			0x14, 0x20, 0x23, 0x82, 0x5e, 0x24, 0xdb, 0x7c,
			0xb1, 0xa4, 0x45, 0x9e, 0x78, 0x09, 0x2b, 0x32,
			0xb0, 0x76, 0x43, 0xc7, 0x27, 0x08, 0x39, 0xf2,
			0x47, 0x87, 0x0e, 0xfb, 0xd3, 0x20, 0xb4, 0x19,
			0xff, 0x3b, 0x19, 0x14, 0xc4, 0x1b, 0x6c, 0xa4,
			0xbc, 0x3c, 0xf1, 0x70, 0x17, 0xd9, 0xa9, 0x4d,
			0x86, 0xf0, 0xf0, 0x22, 0xf4, 0x49, 0x56, 0x66,
			0xc4, 0xa8, 0x9f, 0x08, 0xe2, 0x16, 0xa1, 0x61,
			0xd4, 0x66, 0x4f, 0x2d, 0x61, 0x6f, 0xa4, 0xbb,
			0x2a, 0x17, 0xcc, 0xb8, 0x50, 0x04, 0xe6, 0x3f,
			0x48, 0x8b, 0xa2, 0x95, 0x64, 0xca, 0x13, 0x6a,
			0xa3, 0xa6, 0xf9, 0x56, 0x1f, 0x85, 0xcb, 0x55,
			0x0b, 0x8c, 0xf8, 0xb0, 0xa8, 0x5a, 0xfb, 0xc8,
			0xae, 0xe2, 0xc7, 0x68, 0x91, 0xa5, 0x3e, 0x7c,
			0xb6, 0x6e, 0x36, 0xf8, 0x70, 0x9e, 0x79, 0x90,
			0xd8, 0xde, 0x8d, 0x0c, 0x73, 0x86, 0x5c, 0x1c,
			0xb4, 0x47, 0x27, 0xf1, 0x8c, 0x0f, 0xaf, 0x25,
			0xc5, 0x3f, 0x15, 0xe0, 0x70, 0xc4, 0x30, 0xe7,
			0x3f, 0x77, 0xb1, 0xe9, 0xc8, 0xf8, 0xec, 0x13,
			0x11, 0x4d, 0x7e, 0x7a, 0xc7, 0x90, 0xad, 0xe4,
			0xec, 0x6f, 0x1d, 0xe0, 0xce, 0xc1, 0x3f, 0x25,
			0xa4, 0x8d, 0x53, 0x49, 0x65, 0xa8, 0xed, 0xe1,
			0x20, 0x90, 0xa9, 0x28, 0xa9, 0x1d, 0x5a, 0x1f,
			0x21, 0x4a, 0xef, 0xe6, 0xce, 0xe5, 0x76, 0xad,
			0x43, 0xea, 0xec, 0xcf, 0x63, 0x54, 0x09, 0xa8,
			0x64, 0x68, 0x53, 0xd9, 0xce, 0xf9, 0x3c, 0x9c,
			0x04, 0xa8, 0x84, 0x25, 0x33, 0x80, 0xa4, 0x9e,
			0x68, 0x2b, 0xff, 0x07, 0x50, 0x57, 0x7c, 0x5a,
			0x80, 0xbe, 0xcd, 0xef, 0x21, 0xa4, 0xa9, 0x79,
			0x3f, 0xab, 0xb5, 0x79, 0xeb, 0x50, 0xe3, 0xfa,
		},
		25, /* salt length */
		/* V2 : 25 byte */
		{
			0xb7, 0x50, 0x58, 0x76, 0x71, 0xaf, 0xd7, 0x68,
			0x86, 0xe8, 0xff, 0xb7, 0x86, 0x5e, 0x78, 0xf7,
			0x06, 0x64, 0x1b, 0x2e, 0x42, 0x51, 0xb4, 0x87,
			0x06, 
		},
	},
	/* SHA384 [3] */
	{
		/* Msg3 : 128 byte */
		{
			0xd5, 0x8e, 0x09, 0x97, 0x22, 0x4d, 0x12, 0xe6,
			0x35, 0x58, 0x6e, 0x9c, 0xed, 0xd8, 0x2d, 0xdd,
			0xf6, 0xa2, 0x68, 0xaa, 0x55, 0x70, 0x77, 0x4c,
			0x41, 0x71, 0x63, 0xf6, 0x35, 0x05, 0x9e, 0xa6,
			0x43, 0xc1, 0xf2, 0x4c, 0xab, 0xba, 0xb8, 0x2e,
			0xac, 0x00, 0x4a, 0x8b, 0x9a, 0x68, 0xbb, 0x7e,
			0x31, 0x8f, 0xc5, 0x26, 0x29, 0x1b, 0x02, 0x04,
			0x0a, 0x44, 0x5f, 0xa4, 0x42, 0x94, 0xcf, 0x80,
			0x75, 0xea, 0x3c, 0x21, 0x14, 0xc5, 0xc3, 0x87,
			0x31, 0xbf, 0x20, 0xcb, 0x92, 0x58, 0x67, 0x03,
			0x04, 0xf5, 0xf6, 0x66, 0xf1, 0x29, 0xa7, 0xb1,
			0x35, 0x32, 0x4a, 0xc9, 0x2e, 0xc7, 0x52, 0xa1,
			0x12, 0x11, 0xce, 0x5e, 0x86, 0xf7, 0x9b, 0xb9,
			0x6c, 0x9e, 0xd8, 0xa5, 0xfc, 0x30, 0x9b, 0x32,
			0x16, 0xdd, 0xe2, 0xb2, 0xd6, 0x20, 0xcd, 0x1a,
			0x6a, 0x44, 0x0a, 0xab, 0x20, 0x26, 0x90, 0xd1,
		},
		/* S3 : 256 byte */
		{
			0x43, 0x85, 0xe6, 0x78, 0x19, 0x28, 0x3d, 0x81,
			0xea, 0xb2, 0xb5, 0x93, 0x57, 0xc5, 0x1c, 0xe3,
			0x7b, 0x5e, 0xa3, 0x2b, 0x76, 0xaf, 0x34, 0x5a,
			0x45, 0x7e, 0x5a, 0xa2, 0xdd, 0x61, 0x11, 0x38,
			0x65, 0xa5, 0x87, 0xd2, 0xc8, 0xa8, 0xf1, 0xc8,
			0x82, 0x52, 0x81, 0xc0, 0x52, 0xa8, 0x8f, 0xc6,
			0x77, 0x97, 0xad, 0xb6, 0x25, 0x1d, 0x28, 0xef,
			0xb9, 0x11, 0x56, 0x46, 0x71, 0xaf, 0xfc, 0xbf,
			0xc7, 0xe1, 0xa3, 0xc0, 0x55, 0xdc, 0xe8, 0xd9,
			0x34, 0x97, 0xfe, 0x80, 0xda, 0x45, 0x96, 0x47,
			0xac, 0x71, 0xf1, 0x7e, 0x9a, 0xa0, 0x7d, 0x1a,
			0xaf, 0xd5, 0x26, 0x0a, 0xc2, 0x84, 0xd6, 0x22,
			0xa0, 0x3b, 0x66, 0x70, 0xc5, 0x5b, 0x0d, 0x40,
			0x69, 0x6d, 0x43, 0x6c, 0x63, 0x8f, 0x9b, 0x48,
			0xbd, 0x08, 0xf3, 0x7d, 0xb4, 0xea, 0xf1, 0xd9,
			0x74, 0x6d, 0x2c, 0x24, 0xde, 0x34, 0x7d, 0xcc,
			0xa0, 0xa6, 0x2d, 0xf2, 0x44, 0xbd, 0x2a, 0x55,
			0x4b, 0xd0, 0x8d, 0x04, 0x7e, 0xfe, 0x52, 0xcb,
			0x12, 0x66, 0xee, 0x59, 0x88, 0x44, 0x7e, 0x1b,
			0x27, 0x40, 0xf9, 0x60, 0xd2, 0x2e, 0x9e, 0xd3,
			0xf2, 0x57, 0x3e, 0xa8, 0x75, 0x3a, 0x60, 0xd3,
			0x06, 0xd6, 0x54, 0xa2, 0x65, 0x03, 0xa5, 0x41,
			0x6a, 0x44, 0x39, 0xee, 0x44, 0xae, 0xfe, 0x08,
			0xcf, 0xeb, 0xbe, 0xd5, 0x65, 0x85, 0xea, 0xa0,
			0x1a, 0x64, 0xbc, 0x81, 0x2f, 0x58, 0x9d, 0xa9,
			0xe9, 0xd5, 0x18, 0x49, 0xb4, 0xd4, 0xfe, 0xea,
			0x04, 0xe2, 0xb0, 0x3c, 0x4d, 0x4f, 0xe5, 0x16,
			0xde, 0xce, 0xa1, 0xe3, 0xd9, 0xe7, 0xe3, 0x5b,
			0xfe, 0xc1, 0x7d, 0x7b, 0x2c, 0x21, 0x8d, 0x85,
			0x53, 0xba, 0xb9, 0x21, 0xea, 0xb6, 0x41, 0x0a,
			0xd3, 0x0c, 0xc1, 0x31, 0x57, 0x94, 0x97, 0xd1,
			0x86, 0xfa, 0x25, 0xcf, 0x62, 0x52, 0x1f, 0xe9,
		},
		25, /* salt length */
		/* V3 : 25 byte */
		{
			0xb7, 0x50, 0x58, 0x76, 0x71, 0xaf, 0xd7, 0x68,
			0x86, 0xe8, 0xff, 0xb7, 0x86, 0x5e, 0x78, 0xf7,
			0x06, 0x64, 0x1b, 0x2e, 0x42, 0x51, 0xb4, 0x87,
			0x06, 
		},
	},
	/* SHA384 [4] */
	{
		/* Msg4 : 128 byte */
		{
			0x3b, 0x9d, 0xc9, 0x7a, 0x36, 0x49, 0x2a, 0x68,
			0x81, 0x6a, 0xff, 0x83, 0x9c, 0x13, 0x5d, 0xa2,
			0xd7, 0xde, 0xc5, 0x50, 0x5d, 0xdf, 0x49, 0x66,
			0x70, 0xdb, 0xf0, 0xe0, 0xf6, 0xb6, 0x5c, 0xe9,
			0x35, 0x2b, 0xaa, 0x38, 0xdb, 0xc0, 0x9a, 0x9f,
			0x41, 0xf8, 0xf0, 0xe1, 0xf0, 0xca, 0x1a, 0xc5,
			0x65, 0x52, 0x12, 0x68, 0x11, 0xc7, 0x86, 0xd7,
			0xa4, 0xad, 0x37, 0xdd, 0x8b, 0x4b, 0x9f, 0x1a,
			0xb7, 0x60, 0xd6, 0x55, 0xa1, 0x12, 0xb6, 0x14,
			0x8b, 0x27, 0x3e, 0x69, 0x08, 0x77, 0x34, 0x0e,
			0xbe, 0xa1, 0x0e, 0xb4, 0x6b, 0xfe, 0x13, 0x99,
			0x26, 0xd3, 0xbe, 0x59, 0xe8, 0xcb, 0x63, 0x06,
			0x4a, 0xa4, 0x14, 0x7a, 0x90, 0x28, 0xc6, 0xec,
			0xe7, 0x5f, 0xb0, 0xc2, 0xeb, 0x03, 0xf4, 0xa6,
			0x6c, 0x34, 0x81, 0xdc, 0x72, 0x6d, 0x38, 0xd3,
			0x7e, 0xb7, 0x4e, 0xfa, 0x13, 0x1c, 0xf1, 0xd4,
		},
		/* S4 : 256 byte */
		{
			0x3f, 0xc0, 0xe7, 0x99, 0x13, 0xfc, 0x23, 0x4e,
			0x4f, 0x27, 0x1c, 0xd6, 0xf5, 0xaa, 0x63, 0xbc,
			0xd0, 0x0e, 0x0c, 0x4f, 0xe2, 0x24, 0x28, 0x15,
			0x64, 0x5d, 0x38, 0x47, 0x81, 0xd5, 0xa0, 0x04,
			0x85, 0x07, 0x6b, 0xc0, 0x11, 0xf4, 0x41, 0x24,
			0x57, 0xbb, 0x7a, 0x2c, 0xb2, 0x69, 0x5a, 0xbf,
			0xa1, 0x84, 0x71, 0xff, 0x60, 0x87, 0x03, 0x8d,
			0x58, 0x5f, 0x80, 0x29, 0x95, 0x15, 0x9c, 0x8b,
			0xee, 0xe7, 0x60, 0x73, 0x30, 0x75, 0x9f, 0x31,
			0x01, 0x07, 0xc3, 0x5b, 0x4a, 0x6a, 0x9a, 0x48,
			0xfc, 0x91, 0x0f, 0x45, 0xf7, 0x0b, 0xff, 0xed,
			0x12, 0x81, 0xf2, 0x21, 0x5a, 0xf3, 0x47, 0x59,
			0xab, 0x08, 0xb6, 0x8a, 0xcd, 0x53, 0x9d, 0xdd,
			0x37, 0xf9, 0x8a, 0x52, 0x84, 0x34, 0xcf, 0x11,
			0xae, 0x0e, 0x85, 0xef, 0x22, 0x1f, 0x71, 0x17,
			0xc7, 0x57, 0xd9, 0x70, 0xf3, 0x18, 0x1e, 0x9c,
			0xcd, 0xa9, 0x27, 0x46, 0x9a, 0xa8, 0x8d, 0xe5,
			0x9c, 0xea, 0xe9, 0x1c, 0x27, 0x08, 0x18, 0x13,
			0x77, 0x61, 0xe5, 0x6d, 0x75, 0xa3, 0xc0, 0x1a,
			0xc1, 0x28, 0xb6, 0x58, 0x18, 0xf2, 0x8d, 0xbf,
			0x7d, 0xd2, 0x68, 0x33, 0x73, 0x56, 0xe9, 0x7b,
			0xd1, 0x04, 0xdf, 0x62, 0x18, 0xdb, 0x3b, 0x12,
			0x92, 0xec, 0x26, 0x52, 0xb6, 0x2e, 0x5a, 0xea,
			0xaf, 0xd9, 0x05, 0xec, 0x8f, 0xe6, 0x7d, 0x6e,
			0xd4, 0x2e, 0x80, 0x50, 0x48, 0xde, 0xb5, 0x5c,
			0xd9, 0xd7, 0x5f, 0x81, 0x82, 0x36, 0x68, 0x7b,
			0xc5, 0xb2, 0xcf, 0x33, 0xe1, 0x76, 0x78, 0xc4,
			0x5a, 0x9b, 0x21, 0x44, 0xd5, 0x8a, 0x4c, 0x77,
			0xc1, 0x63, 0xe5, 0x7c, 0x1e, 0xe4, 0x2c, 0xbd,
			0x92, 0xba, 0xb4, 0x66, 0x78, 0x09, 0x2a, 0xef,
			0x86, 0x79, 0x68, 0xd8, 0xe6, 0xa3, 0x87, 0xf7,
			0xce, 0xf3, 0x92, 0x0e, 0x4e, 0xe0, 0x46, 0xeb,
		},
		25, /* salt length */
		/* V4 : 25 byte */
		{
			0xb7, 0x50, 0x58, 0x76, 0x71, 0xaf, 0xd7, 0x68,
			0x86, 0xe8, 0xff, 0xb7, 0x86, 0x5e, 0x78, 0xf7,
			0x06, 0x64, 0x1b, 0x2e, 0x42, 0x51, 0xb4, 0x87,
			0x06, 
		},
	},
	/* SHA384 [5] */
	{
		/* Msg5 : 128 byte */
		{
			0x93, 0xeb, 0xc0, 0x58, 0x37, 0xd0, 0xd5, 0x08,
			0x97, 0xa1, 0xd1, 0x0b, 0xf1, 0xb0, 0x8a, 0x6a,
			0x76, 0x7e, 0x52, 0xbf, 0xaa, 0x88, 0x7d, 0xa4,
			0x0d, 0x63, 0x1d, 0x6c, 0xfb, 0x0b, 0x10, 0x11,
			0xd1, 0x79, 0x3d, 0x6e, 0x51, 0x73, 0x1a, 0xae,
			0x48, 0xa8, 0x72, 0x05, 0x6d, 0xfc, 0x65, 0x9e,
			0x8d, 0x21, 0xb0, 0xd4, 0xe5, 0x67, 0x2e, 0xa4,
			0xd0, 0xd5, 0x9f, 0x62, 0xa2, 0x78, 0xa9, 0xac,
			0xd3, 0xfb, 0x1c, 0x9d, 0x60, 0x78, 0x7a, 0x42,
			0x6e, 0x8e, 0xb7, 0x52, 0x30, 0xb4, 0x3d, 0x19,
			0x0c, 0xcc, 0x33, 0xb6, 0xf9, 0xfc, 0xff, 0x86,
			0x2c, 0xb9, 0x09, 0xe0, 0xf3, 0x24, 0xc2, 0x03,
			0xe1, 0x9a, 0xe6, 0x4c, 0x2b, 0x86, 0xfe, 0xad,
			0x52, 0x7a, 0x28, 0x5a, 0x02, 0x7f, 0x1a, 0xc5,
			0x3b, 0xa9, 0x65, 0xcd, 0xae, 0xee, 0xf7, 0x32,
			0x6a, 0x37, 0xe4, 0x4d, 0xb7, 0xb8, 0x66, 0xfe,
		},
		/* S5 : 256 byte */
		{
			0x19, 0xb1, 0xbb, 0xc3, 0xe4, 0xa2, 0x3b, 0x44,
			0xec, 0x42, 0x9d, 0xc4, 0x47, 0x9f, 0x3f, 0xa4,
			0x5d, 0xa8, 0x70, 0x37, 0x13, 0x6a, 0xda, 0x53,
			0x5b, 0xb3, 0x25, 0xc0, 0xc0, 0x31, 0x93, 0xa2,
			0xed, 0x82, 0x16, 0xa9, 0x62, 0x1e, 0x9f, 0x48,
			0xad, 0x2c, 0x53, 0xaf, 0x33, 0x05, 0x70, 0xfd,
			0xfc, 0x85, 0xfc, 0x1d, 0xbb, 0x07, 0x71, 0x05,
			0xaf, 0x39, 0xe8, 0xe3, 0xa9, 0xfa, 0xba, 0x4a,
			0x79, 0xff, 0xe9, 0x87, 0xe1, 0xa3, 0x7e, 0x5a,
			0x49, 0xc6, 0x03, 0x20, 0xd0, 0x86, 0xe9, 0x29,
			0x20, 0x60, 0xe9, 0xfe, 0x67, 0x1f, 0x1b, 0xfa,
			0x18, 0xad, 0x79, 0xf1, 0xae, 0x55, 0x95, 0x51,
			0xa1, 0xd5, 0x52, 0x0f, 0x81, 0x64, 0xa8, 0x77,
			0xb3, 0xfe, 0x19, 0x38, 0xfa, 0x51, 0xcb, 0xe8,
			0xb5, 0x11, 0x0a, 0x33, 0x2c, 0x50, 0x05, 0x85,
			0xd2, 0x88, 0xd8, 0xb3, 0x08, 0x55, 0xaf, 0xdd,
			0xdd, 0x23, 0x32, 0x54, 0xf6, 0x2e, 0x56, 0xed,
			0xa7, 0x5e, 0xa6, 0x85, 0x4b, 0x84, 0xbb, 0x05,
			0xe5, 0xb4, 0x49, 0x7a, 0xca, 0x3d, 0x20, 0xba,
			0xaf, 0x2d, 0x6d, 0x22, 0x8a, 0x40, 0x01, 0x35,
			0xec, 0xc4, 0x51, 0x61, 0xc3, 0xf2, 0xe7, 0x25,
			0x8f, 0x8e, 0x47, 0x42, 0xaa, 0x68, 0x7b, 0xd9,
			0xf7, 0xa4, 0x46, 0x8a, 0x61, 0x55, 0x8f, 0xa0,
			0xdd, 0xf7, 0x9e, 0x5e, 0x0c, 0xa5, 0x1f, 0xfa,
			0xf0, 0x15, 0x1b, 0xb2, 0x55, 0x15, 0x22, 0x19,
			0xc7, 0x6a, 0x08, 0xc3, 0xe4, 0x65, 0x57, 0xed,
			0x6b, 0x14, 0x15, 0x62, 0x2b, 0xdf, 0xd9, 0x4f,
			0x73, 0x3a, 0xc1, 0x0d, 0x8f, 0x38, 0x8c, 0x0e,
			0xf6, 0x46, 0xd8, 0xf5, 0xd7, 0x1a, 0x32, 0x05,
			0x30, 0x7d, 0xb7, 0x03, 0xd6, 0x27, 0x28, 0x7e,
			0x2b, 0x7b, 0xe1, 0x5c, 0x33, 0xff, 0xf1, 0x91,
			0x47, 0xe5, 0xda, 0xa3, 0x6d, 0x42, 0x52, 0xb1,
		},
		25, /* salt length */
		/* V5 : 25 byte */
		{
			0xb7, 0x50, 0x58, 0x76, 0x71, 0xaf, 0xd7, 0x68,
			0x86, 0xe8, 0xff, 0xb7, 0x86, 0x5e, 0x78, 0xf7,
			0x06, 0x64, 0x1b, 0x2e, 0x42, 0x51, 0xb4, 0x87,
			0x06, 
		},
	},
	/* SHA384 [6] */
	{
		/* Msg6 : 128 byte */
		{
			0x8b, 0xb5, 0x64, 0x04, 0x89, 0x7a, 0x19, 0x14,
			0x0d, 0x11, 0x2d, 0x93, 0x9f, 0x73, 0xfd, 0x7d,
			0x18, 0xa5, 0xd1, 0x07, 0xaa, 0xa2, 0x03, 0x32,
			0x20, 0x96, 0x64, 0xa0, 0x67, 0x4c, 0xdb, 0xa6,
			0x4e, 0xea, 0x4f, 0xa4, 0x8a, 0xdc, 0xc7, 0x91,
			0xfd, 0x0e, 0xd0, 0xda, 0x38, 0x5e, 0x20, 0x6d,
			0x3e, 0x51, 0x78, 0x10, 0x8a, 0x04, 0xcf, 0xf8,
			0x54, 0x66, 0xac, 0x97, 0x11, 0xa5, 0xd4, 0xb5,
			0x39, 0xe6, 0x25, 0xc2, 0x4c, 0x39, 0xc2, 0x6b,
			0x17, 0xcc, 0x70, 0x6b, 0x34, 0x5f, 0x40, 0xa4,
			0xd0, 0xf7, 0x6f, 0x6e, 0xb0, 0xd7, 0x8a, 0x2f,
			0x76, 0xac, 0xd5, 0x2c, 0x21, 0x08, 0xee, 0x9e,
			0xd4, 0x11, 0xae, 0x09, 0xd8, 0x7b, 0x50, 0xc9,
			0xe3, 0xb3, 0xd5, 0xed, 0x9b, 0x5d, 0xa6, 0x49,
			0x56, 0x01, 0x7c, 0xc7, 0x24, 0x01, 0x7d, 0xfe,
			0x0f, 0xcf, 0xa8, 0x06, 0xa1, 0x5c, 0x72, 0x8a,
		},
		/* S6 : 256 byte */
		{
			0x12, 0xf0, 0x3c, 0x6f, 0x02, 0xb3, 0x4f, 0x92,
			0x18, 0x31, 0xdf, 0x38, 0x4c, 0xc6, 0xe3, 0x0d,
			0x0b, 0x64, 0xf8, 0xed, 0x13, 0x31, 0x33, 0xff,
			0x19, 0x0c, 0xac, 0xa2, 0x50, 0x3f, 0x1a, 0x4f,
			0x4f, 0x72, 0x1d, 0xe6, 0x82, 0x4f, 0xfd, 0xe1,
			0x25, 0xbf, 0x41, 0xae, 0x21, 0x6e, 0x5f, 0xeb,
			0x85, 0x10, 0xe4, 0xd6, 0x33, 0x7c, 0xec, 0x56,
			0xf1, 0x85, 0x50, 0xe7, 0x8c, 0x69, 0xb1, 0x61,
			0x84, 0x57, 0xbc, 0x1b, 0x60, 0x4d, 0x10, 0x9e,
			0x52, 0x6c, 0x78, 0x86, 0x28, 0x39, 0x1a, 0xd8,
			0xc2, 0x9a, 0xd6, 0xc5, 0xda, 0x26, 0x89, 0x22,
			0xa5, 0x5e, 0x4e, 0xb3, 0x05, 0x34, 0x15, 0xa9,
			0xde, 0x10, 0x91, 0x12, 0xb5, 0xfa, 0xc1, 0xf9,
			0x96, 0x23, 0x6f, 0x46, 0xed, 0x3a, 0x6c, 0x2f,
			0x84, 0x5c, 0x36, 0xba, 0xb0, 0x9a, 0x4c, 0x21,
			0xda, 0x20, 0xb1, 0x7d, 0x25, 0x90, 0xc7, 0xb0,
			0x58, 0xfe, 0xc1, 0x30, 0xfb, 0xec, 0x48, 0x56,
			0xad, 0xe3, 0x73, 0xb6, 0xb0, 0x77, 0x39, 0x94,
			0xbe, 0xd5, 0xac, 0x7a, 0x42, 0x0a, 0x09, 0xdf,
			0x8c, 0x1d, 0xe2, 0x46, 0xad, 0x45, 0x3d, 0xc8,
			0xa6, 0x23, 0x10, 0xac, 0xcc, 0x9f, 0x0b, 0xdf,
			0xf1, 0x61, 0x04, 0xdf, 0xd7, 0x4c, 0x77, 0x52,
			0xc3, 0x3d, 0xf2, 0x0e, 0xf0, 0x8c, 0x52, 0xd0,
			0xbc, 0xde, 0xac, 0xdf, 0x2a, 0x31, 0x29, 0x8a,
			0x3c, 0x72, 0xbb, 0x73, 0x97, 0xc3, 0xf9, 0x30,
			0x6f, 0xdb, 0xec, 0x45, 0x28, 0x76, 0x88, 0x87,
			0x7f, 0xd6, 0xc9, 0x65, 0xb8, 0xdc, 0xc5, 0x13,
			0xc9, 0xbd, 0xef, 0xc2, 0xf9, 0xee, 0x7e, 0x92,
			0xba, 0xc6, 0x24, 0x38, 0xe4, 0xd8, 0x0b, 0xd3,
			0xee, 0x2c, 0xa5, 0x0a, 0x02, 0x4d, 0x6f, 0xde,
			0xdf, 0x39, 0x26, 0x64, 0x80, 0xb2, 0xec, 0x77,
			0xee, 0xde, 0xa6, 0xb6, 0x4a, 0x9c, 0x58, 0xad,
		},
		25, /* salt length */
		/* V6 : 25 byte */
		{
			0xb7, 0x50, 0x58, 0x76, 0x71, 0xaf, 0xd7, 0x68,
			0x86, 0xe8, 0xff, 0xb7, 0x86, 0x5e, 0x78, 0xf7,
			0x06, 0x64, 0x1b, 0x2e, 0x42, 0x51, 0xb4, 0x87,
			0x06, 
		},
	},
	/* SHA384 [7] */
	{
		/* Msg7 : 128 byte */
		{
			0x35, 0xef, 0x7f, 0x03, 0x8e, 0x9b, 0x98, 0xa4,
			0x21, 0xb9, 0xf6, 0xa1, 0x29, 0xeb, 0xc6, 0x41,
			0x59, 0x63, 0x80, 0xea, 0x16, 0x48, 0xbf, 0x9f,
			0xe3, 0x5c, 0x50, 0xc7, 0x1d, 0xdd, 0x89, 0x30,
			0xe8, 0xa9, 0xdc, 0x53, 0x69, 0xa5, 0xac, 0xda,
			0x36, 0x5e, 0x5e, 0x5f, 0x0a, 0xf1, 0xb4, 0x77,
			0xbe, 0x29, 0x56, 0xef, 0x74, 0xe8, 0xb2, 0x55,
			0x16, 0xc8, 0x06, 0xba, 0xff, 0x01, 0xbb, 0xb7,
			0xf7, 0x8e, 0xf5, 0xae, 0x65, 0x8b, 0x68, 0x52,
			0xc0, 0xe2, 0x6d, 0x6a, 0x47, 0x26, 0x55, 0xd2,
			0xf2, 0xbf, 0xfd, 0xc2, 0xa8, 0x48, 0xa2, 0x52,
			0xb2, 0x35, 0xf7, 0x3e, 0x70, 0xb9, 0x75, 0xe7,
			0x4a, 0xe7, 0xf3, 0x9b, 0xea, 0x17, 0x76, 0x16,
			0xa8, 0x8b, 0x4a, 0x49, 0x46, 0x52, 0x52, 0x5a,
			0xde, 0x6d, 0x9c, 0xeb, 0x18, 0x31, 0x38, 0x9f,
			0xa0, 0xec, 0x4b, 0xda, 0xd8, 0xcb, 0x5f, 0xc9,
		},
		/* S7 : 256 byte */
		{
			0xaf, 0x80, 0x9f, 0x10, 0xfd, 0x16, 0x0a, 0x88,
			0xd4, 0x2d, 0xc9, 0xd9, 0x22, 0x85, 0xe2, 0xb2,
			0xaf, 0xd8, 0x16, 0x2c, 0x38, 0xeb, 0x91, 0xa6,
			0xb6, 0x27, 0x3a, 0x66, 0xc3, 0x0c, 0x79, 0xd7,
			0xca, 0xec, 0x94, 0xa0, 0x0f, 0xa7, 0x32, 0x71,
			0x0d, 0x9f, 0x75, 0x12, 0x19, 0x76, 0x71, 0x85,
			0xda, 0x50, 0x64, 0xce, 0x26, 0xfe, 0xc0, 0x64,
			0x7c, 0xb0, 0x67, 0x0e, 0xcc, 0x68, 0xf2, 0xa6,
			0x01, 0x39, 0x0d, 0xff, 0x07, 0xff, 0x02, 0x37,
			0xf2, 0x84, 0xdd, 0x4f, 0xcb, 0x0b, 0x11, 0x14,
			0x88, 0x35, 0xc8, 0x11, 0x4c, 0x5a, 0x15, 0xc5,
			0x13, 0x71, 0x3d, 0xbc, 0x16, 0x28, 0x67, 0x07,
			0xee, 0xca, 0xf2, 0xc4, 0x50, 0xf5, 0x88, 0xfc,
			0x96, 0x21, 0x7d, 0x34, 0xf5, 0x9e, 0x0c, 0x71,
			0x6c, 0x73, 0x48, 0x27, 0x00, 0x41, 0xb2, 0xc4,
			0x38, 0x6f, 0x5a, 0x58, 0x77, 0xf7, 0xfa, 0x48,
			0x51, 0x0c, 0xca, 0x8b, 0x07, 0xb7, 0x04, 0x90,
			0xf9, 0xee, 0xe9, 0x57, 0xec, 0x0a, 0x52, 0xab,
			0x95, 0x5a, 0x3f, 0x10, 0x54, 0x69, 0x5a, 0x7f,
			0x58, 0x06, 0xf7, 0x05, 0xfe, 0x3e, 0x98, 0x02,
			0x77, 0x0d, 0x59, 0x1e, 0xdd, 0xf2, 0xa8, 0x3f,
			0xe0, 0x3d, 0x8a, 0xdb, 0xf5, 0x53, 0xae, 0x59,
			0x52, 0x80, 0x51, 0x21, 0x8d, 0xb1, 0xf3, 0xfd,
			0x07, 0x0f, 0x8e, 0x1d, 0x3d, 0x4b, 0x40, 0x83,
			0x58, 0x8c, 0xf2, 0x71, 0x02, 0x71, 0xec, 0xca,
			0x5d, 0x93, 0x69, 0x46, 0x8d, 0x04, 0x5b, 0x0f,
			0x2e, 0x0e, 0xf2, 0x85, 0xf9, 0xcf, 0xa6, 0x5a,
			0x04, 0xcd, 0x22, 0x3f, 0xd8, 0x4c, 0x01, 0xb8,
			0xc7, 0x40, 0xa4, 0xe9, 0x5b, 0x9f, 0xb6, 0x75,
			0xc0, 0xd7, 0xc4, 0x70, 0xb3, 0x59, 0x8d, 0x06,
			0x48, 0x9b, 0xb7, 0xd6, 0x72, 0x2e, 0xb7, 0x2a,
			0xb8, 0x12, 0x0d, 0x7f, 0x0a, 0xe2, 0x9a, 0x06,
		},
		25, /* salt length */
		/* V7 : 25 byte */
		{
			0xb7, 0x50, 0x58, 0x76, 0x71, 0xaf, 0xd7, 0x68,
			0x86, 0xe8, 0xff, 0xb7, 0x86, 0x5e, 0x78, 0xf7,
			0x06, 0x64, 0x1b, 0x2e, 0x42, 0x51, 0xb4, 0x87,
			0x06, 
		},
	},
	/* SHA384 [8] */
	{
		/* Msg8 : 128 byte */
		{
			0xb4, 0x42, 0x22, 0x16, 0xf1, 0xe7, 0x5f, 0x1c,
			0xea, 0x1e, 0x97, 0x1e, 0x29, 0xd9, 0x45, 0xb9,
			0xa2, 0xc7, 0xaa, 0x3d, 0x3c, 0xca, 0x70, 0xbc,
			0x8d, 0xab, 0x8e, 0x61, 0xe5, 0x0d, 0x6b, 0x03,
			0x8f, 0x9f, 0x46, 0xfa, 0x53, 0x96, 0xd5, 0x32,
			0x3f, 0x5b, 0x2c, 0x7e, 0xa8, 0x80, 0xe1, 0x2e,
			0x6b, 0xf9, 0x6e, 0xe3, 0x78, 0x89, 0xd6, 0xa2,
			0x92, 0x7a, 0x8c, 0x28, 0x50, 0x91, 0x90, 0x7d,
			0x68, 0x41, 0xdb, 0xcc, 0x2c, 0x1f, 0xfd, 0x72,
			0x55, 0x96, 0x05, 0x55, 0x00, 0xdc, 0xa1, 0x77,
			0xf6, 0x24, 0x86, 0xcb, 0x30, 0x16, 0x12, 0x47,
			0x9b, 0x7c, 0x30, 0x3a, 0x18, 0x3e, 0x7d, 0xe0,
			0xc7, 0x90, 0xa9, 0x33, 0x85, 0x6a, 0x1f, 0x05,
			0xb3, 0x38, 0xe8, 0x4c, 0x3a, 0xd4, 0xcc, 0xbd,
			0xcb, 0xb1, 0xbb, 0x9c, 0x6c, 0x59, 0x6c, 0xd2,
			0x30, 0x19, 0x44, 0x40, 0x45, 0xfa, 0x79, 0x53,
		},
		/* S8 : 256 byte */
		{
			0x0f, 0x31, 0xc8, 0xfb, 0x4c, 0xef, 0x72, 0x33,
			0xcc, 0x20, 0xbc, 0xa2, 0x0e, 0xaa, 0x5b, 0x42,
			0xa9, 0xae, 0xd4, 0xa4, 0xf4, 0x08, 0x55, 0xe2,
			0xc5, 0x18, 0x50, 0x1a, 0xe1, 0xcf, 0xd7, 0x1f,
			0x98, 0xbf, 0x9f, 0xfd, 0xec, 0x1a, 0x74, 0xbe,
			0xa7, 0x5b, 0xdf, 0x90, 0xb9, 0xc6, 0x7c, 0x58,
			0x24, 0xa7, 0x05, 0x4a, 0xe5, 0x7e, 0xf4, 0x98,
			0x06, 0x35, 0x9e, 0xd6, 0x4b, 0x2c, 0x5e, 0xfd,
			0xaf, 0x52, 0x82, 0x93, 0x95, 0xfe, 0x42, 0x6c,
			0x80, 0x26, 0x65, 0xbd, 0x75, 0x30, 0xca, 0x3c,
			0xbb, 0x40, 0xd5, 0xf2, 0x93, 0x67, 0xea, 0x55,
			0xeb, 0xa2, 0x99, 0x03, 0xe8, 0xeb, 0xa5, 0xdf,
			0x75, 0x56, 0xb5, 0x52, 0x73, 0x35, 0xac, 0x06,
			0xa2, 0x11, 0xc5, 0x97, 0xe9, 0x16, 0xfd, 0x69,
			0x78, 0xea, 0x5b, 0xc6, 0xda, 0xad, 0xcc, 0xd4,
			0xfc, 0xbc, 0x61, 0xee, 0x64, 0xaa, 0xcc, 0x90,
			0x2f, 0x65, 0x2e, 0x54, 0x5e, 0xf4, 0x85, 0x79,
			0xcd, 0x52, 0x39, 0x44, 0x46, 0x1d, 0x91, 0x61,
			0xa5, 0x42, 0xe2, 0xe7, 0xbd, 0x2a, 0x1d, 0xa7,
			0x2e, 0xc9, 0xa7, 0x51, 0x65, 0x1d, 0x18, 0x4f,
			0xb7, 0x5b, 0x16, 0x95, 0x1e, 0x1b, 0x5a, 0x98,
			0x10, 0x7a, 0xb3, 0xba, 0x68, 0x0d, 0xf0, 0xdd,
			0x06, 0x13, 0x1a, 0x93, 0x18, 0xe4, 0x7e, 0x15,
			0x32, 0x6f, 0x27, 0xfc, 0x34, 0xdd, 0xde, 0xea,
			0xc8, 0x9b, 0x11, 0x23, 0x6f, 0xdc, 0x9b, 0x8f,
			0x79, 0x98, 0x28, 0xdf, 0xa9, 0x71, 0x4e, 0x6c,
			0xa3, 0x98, 0x2d, 0x8f, 0x79, 0xef, 0xa2, 0xa4,
			0x55, 0xe6, 0xd7, 0x34, 0x21, 0xa1, 0xc9, 0x33,
			0xc9, 0x29, 0x02, 0x79, 0x0e, 0xb7, 0x9a, 0xdf,
			0x0e, 0x4f, 0xb6, 0x20, 0x2b, 0x6a, 0x08, 0x68,
			0xae, 0xca, 0xc2, 0x20, 0x8a, 0xb6, 0x73, 0xb2,
			0x49, 0xa8, 0x26, 0x64, 0x65, 0x18, 0xaa, 0xbc,
		},
		25, /* salt length */
		/* V8 : 25 byte */
		{
			0xb7, 0x50, 0x58, 0x76, 0x71, 0xaf, 0xd7, 0x68,
			0x86, 0xe8, 0xff, 0xb7, 0x86, 0x5e, 0x78, 0xf7,
			0x06, 0x64, 0x1b, 0x2e, 0x42, 0x51, 0xb4, 0x87,
			0x06, 
		},
	},
	/* SHA384 [9] */
	{
		/* Msg9 : 128 byte */
		{
			0x88, 0x2c, 0x97, 0xfa, 0xd7, 0x63, 0xca, 0x23,
			0x5b, 0x16, 0x2f, 0xba, 0x88, 0xfd, 0x71, 0x4d,
			0x02, 0x3b, 0xf7, 0x38, 0x01, 0x33, 0x68, 0x1c,
			0xfa, 0x9e, 0x6a, 0x8d, 0x7c, 0xda, 0xb0, 0x0b,
			0x58, 0x85, 0x33, 0x34, 0x04, 0x4b, 0xbf, 0x37,
			0x41, 0xfc, 0xb2, 0x8c, 0xfc, 0xe2, 0x01, 0xe3,
			0x72, 0x51, 0x7b, 0x5a, 0x98, 0x7f, 0x52, 0xf2,
			0xba, 0x96, 0xd7, 0x44, 0x62, 0x08, 0x85, 0x70,
			0x7b, 0x23, 0x41, 0x57, 0xb6, 0xe5, 0xe0, 0x0a,
			0x2d, 0x11, 0xea, 0x81, 0x47, 0x82, 0x9d, 0x91,
			0xdb, 0xc0, 0x35, 0x18, 0x98, 0xd1, 0x6b, 0x7b,
			0xa4, 0x52, 0x3c, 0x52, 0x83, 0xc6, 0xeb, 0x61,
			0x3b, 0x2d, 0x49, 0xcb, 0xb5, 0xd9, 0x34, 0x82,
			0x67, 0x7d, 0x5e, 0x02, 0x30, 0x87, 0x50, 0x3f,
			0x83, 0xaf, 0xae, 0xdb, 0xc8, 0xd0, 0xbc, 0x9d,
			0xff, 0xf7, 0x21, 0x1f, 0xa7, 0xba, 0xeb, 0xc6,
		},
		/* S9 : 256 byte */
		{
			0x0c, 0x48, 0x50, 0xb8, 0x15, 0x16, 0x9c, 0xda,
			0x5c, 0x11, 0xf7, 0x7b, 0xee, 0x14, 0xff, 0x2f,
			0xa1, 0x39, 0x9a, 0xf8, 0xdb, 0xa0, 0x9f, 0xb9,
			0x48, 0x52, 0x11, 0xdd, 0xd4, 0x58, 0xe4, 0x15,
			0x2f, 0x96, 0x6b, 0x21, 0x62, 0xcc, 0xed, 0x29,
			0x9e, 0x49, 0x6c, 0xa0, 0xc6, 0xcc, 0x89, 0x1f,
			0xce, 0x52, 0xfd, 0xe9, 0xbe, 0x55, 0x4a, 0xa2,
			0x13, 0xc9, 0xf9, 0xdc, 0xce, 0x05, 0x34, 0x52,
			0xfe, 0x07, 0x02, 0xbf, 0x2e, 0x95, 0x3a, 0xc6,
			0x49, 0x0c, 0x97, 0x66, 0x0d, 0x8d, 0xae, 0x7a,
			0xe5, 0x57, 0xd9, 0x4e, 0x4d, 0xe4, 0x09, 0x10,
			0x09, 0x51, 0xbd, 0x3f, 0x8b, 0xe7, 0x7a, 0xd5,
			0xe6, 0xa7, 0xf8, 0x55, 0x11, 0x90, 0xa1, 0xf2,
			0xed, 0xe4, 0x0f, 0xa5, 0xa1, 0x2e, 0x5d, 0x99,
			0x5c, 0x77, 0x39, 0x22, 0x1f, 0xd9, 0xbe, 0x39,
			0x70, 0xc0, 0x5d, 0xfc, 0x99, 0x0a, 0x10, 0x3d,
			0xb1, 0xe9, 0xdf, 0xf2, 0x5e, 0x37, 0x23, 0x4b,
			0xe4, 0xf7, 0x0b, 0x37, 0x2a, 0x40, 0x71, 0xa9,
			0xc9, 0x21, 0xa3, 0x4d, 0xe8, 0xf6, 0xc5, 0x6f,
			0x11, 0x06, 0xa2, 0x43, 0x1b, 0x2f, 0xc2, 0xd6,
			0x00, 0x26, 0xc7, 0xf2, 0xcf, 0xab, 0x11, 0xee,
			0x75, 0xaf, 0xaa, 0xb9, 0x0d, 0x72, 0xdc, 0x8e,
			0x15, 0xc6, 0xd6, 0xdd, 0xee, 0x0d, 0x43, 0x02,
			0x34, 0x1f, 0x10, 0x7c, 0x54, 0x1b, 0x23, 0x36,
			0x89, 0x95, 0xb6, 0xe9, 0x5a, 0x0e, 0xfb, 0x36,
			0x24, 0xe7, 0x0e, 0x79, 0x80, 0x53, 0x3a, 0x4d,
			0x6c, 0xd8, 0x23, 0xe2, 0x60, 0x72, 0xa4, 0xbc,
			0x88, 0xf2, 0xc0, 0x13, 0x49, 0x22, 0x24, 0x72,
			0xee, 0x39, 0x4b, 0x86, 0xec, 0x83, 0xf4, 0xfb,
			0x9d, 0xf8, 0xfd, 0x10, 0x5f, 0xed, 0xc7, 0x7d,
			0x28, 0xb7, 0xa7, 0xe9, 0xd7, 0x14, 0x51, 0x21,
			0x9e, 0xb4, 0x2c, 0x25, 0x76, 0x4b, 0xfe, 0xc6,
		},
		25, /* salt length */
		/* V9 : 25 byte */
		{
			0xb7, 0x50, 0x58, 0x76, 0x71, 0xaf, 0xd7, 0x68,
			0x86, 0xe8, 0xff, 0xb7, 0x86, 0x5e, 0x78, 0xf7,
			0x06, 0x64, 0x1b, 0x2e, 0x42, 0x51, 0xb4, 0x87,
			0x06, 
		},
	},
};

/* 10 elements */
static mod2048_t SHA512[] = {
	/* SHA512 [0] */
	{
		/* Msg0 : 128 byte */
		{
			0x5f, 0x0f, 0xe2, 0xaf, 0xa6, 0x1b, 0x62, 0x8c,
			0x43, 0xea, 0x3b, 0x6b, 0xa6, 0x05, 0x67, 0xb1,
			0xae, 0x95, 0xf6, 0x82, 0x07, 0x6f, 0x01, 0xdf,
			0xb6, 0x4d, 0xe0, 0x11, 0xf2, 0x5e, 0x9c, 0x4b,
			0x36, 0x02, 0xa7, 0x8b, 0x94, 0xce, 0xcb, 0xc1,
			0x4c, 0xd7, 0x61, 0x33, 0x9d, 0x2d, 0xc3, 0x20,
			0xdb, 0xa5, 0x04, 0xa3, 0xc2, 0xdc, 0xde, 0xdb,
			0x0a, 0x78, 0xeb, 0x49, 0x3b, 0xb1, 0x18, 0x79,
			0xc3, 0x11, 0x58, 0xe5, 0x46, 0x77, 0x95, 0x16,
			0x35, 0x62, 0xec, 0x0c, 0xa2, 0x6c, 0x19, 0xe0,
			0x53, 0x15, 0x30, 0xa8, 0x15, 0xc2, 0x8f, 0x9b,
			0x52, 0x06, 0x10, 0x76, 0xe6, 0x1f, 0x83, 0x1e,
			0x2f, 0xc4, 0x5b, 0x86, 0x63, 0x1e, 0xa7, 0xd3,
			0x27, 0x14, 0x44, 0xbe, 0x5d, 0xcb, 0x51, 0x3a,
			0x3d, 0x6d, 0xe4, 0x57, 0xa7, 0x2a, 0xfb, 0x67,
			0xb7, 0x7d, 0xb6, 0x5f, 0x9b, 0xb1, 0xc3, 0x80,
		},
		/* S0 : 256 byte */
		{
			0x5e, 0x07, 0x12, 0xbb, 0x36, 0x3e, 0x50, 0x34,
			0xef, 0x6b, 0x23, 0xc1, 0x19, 0xe3, 0xb4, 0x98,
			0x64, 0x44, 0x45, 0xfa, 0xab, 0x5a, 0x4c, 0x0b,
			0x4e, 0x21, 0x7e, 0x4c, 0x83, 0x2a, 0xb3, 0x4c,
			0x14, 0x2d, 0x7f, 0x81, 0xdb, 0xf8, 0xaf, 0xfd,
			0xb2, 0xda, 0xce, 0xfa, 0xbb, 0x2f, 0x83, 0x52,
			0x4c, 0x5a, 0xa8, 0x83, 0xfc, 0x5f, 0x06, 0xe5,
			0x28, 0xb2, 0x32, 0xd9, 0x0f, 0xbe, 0xa9, 0xca,
			0x08, 0xae, 0x5a, 0xc1, 0x80, 0xd4, 0x77, 0xea,
			0xed, 0x27, 0xd1, 0x37, 0xe2, 0xb5, 0x1b, 0xd6,
			0x13, 0xb6, 0x9c, 0x54, 0x3d, 0x55, 0x5b, 0xfc,
			0x7c, 0xd8, 0x1a, 0x4f, 0x79, 0x57, 0x53, 0xc8,
			0xc6, 0x4c, 0x6b, 0x5d, 0x2a, 0xcd, 0x9e, 0x26,
			0xd6, 0x22, 0x5f, 0x5b, 0x26, 0xe4, 0xe6, 0x6a,
			0x94, 0x5f, 0xd6, 0x47, 0x7a, 0x27, 0x7b, 0x58,
			0x0d, 0xbe, 0xaa, 0x46, 0xd0, 0xbe, 0x49, 0x8d,
			0xf9, 0xa0, 0x93, 0x39, 0x29, 0x26, 0xc9, 0x05,
			0x64, 0x19, 0x45, 0xec, 0x5b, 0x95, 0x97, 0x52,
			0x5e, 0x44, 0x9a, 0xf3, 0x74, 0x3f, 0x80, 0x55,
			0x47, 0x88, 0xfc, 0x35, 0x8b, 0xc0, 0x40, 0x1a,
			0x96, 0x8f, 0xf9, 0x8a, 0xaf, 0x34, 0xe5, 0x0b,
			0x35, 0x27, 0x51, 0xf3, 0x22, 0x74, 0x75, 0x0f,
			0xf5, 0xc1, 0xfb, 0xa5, 0x03, 0x05, 0x02, 0x04,
			0xce, 0xc9, 0xc7, 0x7d, 0xee, 0xde, 0x7f, 0x8f,
			0xa2, 0x08, 0x45, 0xd9, 0x5f, 0x51, 0x77, 0x03,
			0x0b, 0xc9, 0x1d, 0x51, 0xf2, 0x6f, 0x29, 0xd2,
			0xa6, 0x5b, 0x87, 0x0d, 0xc7, 0x2b, 0x81, 0xe5,
			0xef, 0x9e, 0xee, 0xf9, 0x90, 0xd7, 0xc7, 0x14,
			0x5b, 0xbf, 0x1a, 0x3b, 0xc7, 0xae, 0xdd, 0x19,
			0xfa, 0x7c, 0xbb, 0x02, 0x07, 0x56, 0x52, 0x5f,
			0x18, 0x02, 0x21, 0x6c, 0x13, 0x29, 0x6f, 0xd6,
			0xaa, 0xc1, 0x1b, 0xf2, 0xd2, 0xd9, 0x04, 0x94,
		},
		30, /* salt length */
		/* V0 : 30 byte */
		{
			0xaa, 0x10, 0xfe, 0xc3, 0xf8, 0x3b, 0x7a, 0x97,
			0xe0, 0x92, 0x87, 0x7a, 0x5b, 0xf9, 0x08, 0x12,
			0x83, 0xf5, 0x02, 0xa0, 0xa4, 0x6b, 0x50, 0xe3,
			0x95, 0xab, 0x98, 0x3a, 0x49, 0xac, 
		},
	},
	/* SHA512 [1] */
	{
		/* Msg1 : 128 byte */
		{
			0x9e, 0x88, 0x0c, 0xe5, 0x9f, 0x54, 0x7d, 0x59,
			0x2c, 0x30, 0x9c, 0x22, 0xa2, 0x97, 0x4b, 0xa5,
			0xa5, 0x2c, 0xf1, 0xc1, 0x64, 0xf2, 0xd8, 0xa8,
			0x1e, 0xbb, 0xd4, 0xed, 0xe6, 0xe3, 0x26, 0xde,
			0xa3, 0x3d, 0x9f, 0x13, 0x5a, 0x4e, 0x09, 0x47,
			0xb0, 0xb9, 0xc2, 0x67, 0xaa, 0xfb, 0xaa, 0xe9,
			0xb8, 0x58, 0x3f, 0x5f, 0xf2, 0x15, 0x07, 0x4c,
			0xa1, 0xe8, 0x2f, 0x36, 0x01, 0xad, 0x71, 0xfc,
			0x45, 0x5a, 0x3b, 0x6a, 0xdc, 0x35, 0x0d, 0x0b,
			0xf3, 0x45, 0x22, 0x3e, 0x3b, 0x06, 0x54, 0x8c,
			0xec, 0x61, 0x3a, 0x39, 0x0a, 0xda, 0x93, 0x19,
			0xe7, 0x0c, 0xe7, 0xa5, 0xe9, 0x52, 0x6b, 0x4e,
			0x8d, 0xc8, 0x26, 0x12, 0xac, 0x72, 0x52, 0x4c,
			0xfd, 0xba, 0x05, 0xd0, 0xdc, 0x20, 0x10, 0x37,
			0x49, 0x2d, 0x27, 0x78, 0x34, 0xa8, 0x43, 0xb9,
			0xf8, 0x0d, 0x45, 0x64, 0x25, 0x3b, 0xdc, 0x7c,
		},
		/* S1 : 256 byte */
		{
			0x8c, 0x4f, 0x81, 0x9e, 0x68, 0x20, 0x81, 0xbb,
			0x16, 0xdd, 0xd4, 0x59, 0x66, 0x2a, 0x80, 0x78,
			0xbc, 0xa4, 0x79, 0x3e, 0x18, 0x11, 0x00, 0x33,
			0x53, 0x94, 0x60, 0xb4, 0x08, 0xc0, 0xaf, 0x74,
			0x7e, 0xa5, 0xd9, 0x41, 0xf7, 0x12, 0x69, 0x1f,
			0x5d, 0x9d, 0xdb, 0x64, 0x31, 0x66, 0xfd, 0x96,
			0x5f, 0x5b, 0x51, 0xb8, 0x19, 0xd5, 0x51, 0x41,
			0xd6, 0x7c, 0x15, 0x53, 0xb2, 0x7a, 0x46, 0x82,
			0xe6, 0x7d, 0x55, 0x55, 0xb6, 0x4d, 0x7c, 0xd3,
			0xdb, 0x7f, 0xc5, 0xc2, 0xe7, 0x01, 0xdd, 0x26,
			0xe4, 0x22, 0xaf, 0x8a, 0x1f, 0xb5, 0x2c, 0xd5,
			0xf5, 0xa0, 0x9e, 0x0d, 0x6d, 0xb9, 0x00, 0xa9,
			0x92, 0xf3, 0x18, 0xde, 0xeb, 0x6f, 0x6e, 0x39,
			0xdf, 0xd6, 0xaf, 0x44, 0xcb, 0x21, 0x7c, 0x68,
			0x54, 0x08, 0x9c, 0xea, 0xa1, 0x6e, 0x3f, 0x9b,
			0x10, 0x0e, 0xf8, 0xe7, 0x8f, 0x6b, 0x45, 0x34,
			0x58, 0xb8, 0xef, 0x6d, 0x71, 0x49, 0x3e, 0x7c,
			0x6e, 0x45, 0x28, 0x2c, 0x61, 0x7f, 0xa8, 0x7c,
			0xcd, 0xd4, 0xa0, 0xf2, 0xf9, 0xf7, 0x16, 0x62,
			0x81, 0x80, 0x6f, 0xb4, 0x1d, 0x0f, 0xe1, 0x88,
			0xe0, 0x0c, 0x40, 0xaf, 0xea, 0xa0, 0x7d, 0x2d,
			0xa0, 0x9a, 0x2c, 0xd7, 0x80, 0x52, 0xf8, 0xd5,
			0x6b, 0x7a, 0xf4, 0x0d, 0x4c, 0x73, 0x14, 0xcc,
			0xf0, 0x2e, 0x49, 0x0d, 0x5e, 0x21, 0x23, 0xbf,
			0x67, 0x6f, 0x2b, 0xcb, 0xda, 0xbe, 0xff, 0xcf,
			0x58, 0x79, 0x29, 0x98, 0xdd, 0x0f, 0x67, 0xed,
			0x24, 0xe4, 0x83, 0xd8, 0x97, 0x6b, 0x00, 0xd6,
			0x15, 0x1a, 0x6e, 0x0b, 0xa7, 0x40, 0xbd, 0xb5,
			0x7c, 0x9b, 0xc2, 0x7f, 0xe5, 0xdf, 0x91, 0x26,
			0xa4, 0x70, 0x20, 0x07, 0x5e, 0xb2, 0x22, 0xd5,
			0xca, 0x24, 0x70, 0x72, 0x44, 0x60, 0xc5, 0xad,
			0xf0, 0x67, 0xb5, 0x75, 0x02, 0x87, 0xcd, 0x00,
		},
		30, /* salt length */
		/* V1 : 30 byte */
		{
			0xaa, 0x10, 0xfe, 0xc3, 0xf8, 0x3b, 0x7a, 0x97,
			0xe0, 0x92, 0x87, 0x7a, 0x5b, 0xf9, 0x08, 0x12,
			0x83, 0xf5, 0x02, 0xa0, 0xa4, 0x6b, 0x50, 0xe3,
			0x95, 0xab, 0x98, 0x3a, 0x49, 0xac, 
		},
	},
	/* SHA512 [2] */
	{
		/* Msg2 : 128 byte */
		{
			0xa6, 0x13, 0x3c, 0xa4, 0x36, 0xd3, 0xf2, 0xe0,
			0xa6, 0x56, 0x2f, 0x13, 0x89, 0x75, 0xbc, 0xf7,
			0x85, 0xcd, 0x0c, 0x3b, 0x58, 0xb7, 0x67, 0x1d,
			0x19, 0x7b, 0x48, 0x3b, 0xc0, 0xc0, 0x03, 0xa6,
			0xe9, 0x47, 0xaa, 0x39, 0xd5, 0xd9, 0x32, 0x29,
			0xb2, 0x7e, 0xd2, 0xdc, 0x1c, 0xf0, 0xac, 0xff,
			0xe3, 0x4f, 0xaf, 0xd3, 0x0f, 0x16, 0xbc, 0xc7,
			0x21, 0x4e, 0x07, 0x4c, 0x9c, 0x02, 0xc1, 0xe5,
			0xc4, 0xf2, 0xf4, 0x7d, 0xa6, 0x8b, 0xae, 0xfe,
			0x58, 0x17, 0x61, 0x1f, 0x82, 0x32, 0x8a, 0x7e,
			0x1d, 0x7d, 0x91, 0xee, 0x7b, 0x96, 0xf0, 0x12,
			0x88, 0x47, 0x98, 0x2b, 0x4f, 0xfd, 0x90, 0x2e,
			0xc0, 0x7c, 0xe0, 0x1a, 0xb0, 0xd2, 0xad, 0x88,
			0x21, 0x89, 0xa5, 0x83, 0xc4, 0x21, 0x9e, 0x9b,
			0xbc, 0xbe, 0x79, 0x35, 0xa5, 0x1d, 0x4d, 0x25,
			0xd5, 0xcc, 0xc2, 0x7f, 0xe1, 0x9b, 0xba, 0xa9,
		},
		/* S2 : 256 byte */
		{
			0x20, 0xce, 0xee, 0x0f, 0xd6, 0x20, 0x16, 0x0e,
			0xf6, 0xa4, 0x09, 0x66, 0xfa, 0x4e, 0xf3, 0xd8,
			0xf6, 0x8c, 0x00, 0x2a, 0x66, 0xd0, 0x10, 0x3e,
			0xb6, 0x2a, 0x86, 0x8a, 0x7a, 0xd7, 0xdc, 0xe9,
			0x52, 0x3a, 0x5b, 0x83, 0x60, 0x7b, 0x8c, 0xd0,
			0xca, 0x54, 0xf8, 0x33, 0xf3, 0xa6, 0x8c, 0x9f,
			0xaf, 0xa1, 0xde, 0x7f, 0xd7, 0x23, 0xe2, 0x2a,
			0x0f, 0x72, 0x4d, 0xfc, 0xa1, 0xfb, 0x6b, 0xd1,
			0xa8, 0x8a, 0x7d, 0xbd, 0x17, 0x25, 0x5b, 0xa1,
			0xe0, 0x61, 0x02, 0xc2, 0xcd, 0xdf, 0x58, 0x4f,
			0x51, 0x1b, 0xdd, 0x09, 0xe1, 0x32, 0xb0, 0x16,
			0xf8, 0x67, 0x89, 0x6a, 0x59, 0x2a, 0x28, 0xc5,
			0x3c, 0x70, 0x75, 0x2a, 0x0b, 0x10, 0xd8, 0x6b,
			0xdb, 0xae, 0x95, 0x03, 0x92, 0x8d, 0x2e, 0x02,
			0x03, 0xab, 0x8f, 0x84, 0x5c, 0x1f, 0x77, 0xad,
			0xef, 0x2b, 0xd2, 0xf4, 0xe1, 0x26, 0x06, 0x6f,
			0xe1, 0x5a, 0xf4, 0xa5, 0x28, 0x2d, 0x5d, 0x9f,
			0xa7, 0x3b, 0xec, 0x18, 0xd2, 0xe6, 0xa5, 0x96,
			0x9d, 0x76, 0x6e, 0xba, 0x55, 0xc0, 0xbb, 0x95,
			0xe1, 0x36, 0x71, 0xf8, 0x26, 0x46, 0xc3, 0x5b,
			0x31, 0xd8, 0x94, 0xe7, 0xf9, 0x5f, 0x2f, 0xd3,
			0x5f, 0x60, 0xd8, 0x8c, 0x3e, 0x70, 0xb2, 0x0f,
			0x6f, 0x38, 0x73, 0x26, 0x40, 0x0f, 0x0a, 0x82,
			0x5b, 0xb9, 0x51, 0x7d, 0xf8, 0x8b, 0xbc, 0xc4,
			0x79, 0x88, 0x61, 0x14, 0x47, 0x82, 0xdd, 0x92,
			0xcc, 0xae, 0xd3, 0x6a, 0xec, 0x47, 0xd5, 0x36,
			0x5d, 0x3b, 0x61, 0xa4, 0x95, 0x33, 0x9e, 0xd5,
			0x8e, 0x25, 0x53, 0xb7, 0x4f, 0x06, 0xa2, 0x95,
			0xae, 0x47, 0xa3, 0x09, 0xd8, 0x47, 0x7b, 0x9c,
			0xa8, 0x38, 0xe7, 0x70, 0x94, 0x71, 0x85, 0x65,
			0x90, 0x34, 0x32, 0xce, 0x24, 0x3c, 0x9d, 0xff,
			0xe6, 0xda, 0xd4, 0x64, 0xcd, 0x5e, 0xe2, 0x79,
		},
		30, /* salt length */
		/* V2 : 30 byte */
		{
			0xaa, 0x10, 0xfe, 0xc3, 0xf8, 0x3b, 0x7a, 0x97,
			0xe0, 0x92, 0x87, 0x7a, 0x5b, 0xf9, 0x08, 0x12,
			0x83, 0xf5, 0x02, 0xa0, 0xa4, 0x6b, 0x50, 0xe3,
			0x95, 0xab, 0x98, 0x3a, 0x49, 0xac, 
		},
	},
	/* SHA512 [3] */
	{
		/* Msg3 : 128 byte */
		{
			0x6d, 0x60, 0xa4, 0xee, 0x80, 0x6b, 0xf0, 0xfd,
			0xb5, 0xe3, 0x84, 0x8f, 0x58, 0x34, 0x2c, 0x0d,
			0xba, 0xb5, 0xee, 0x39, 0x29, 0xd2, 0x99, 0x6e,
			0x1f, 0x6a, 0xa0, 0x29, 0xba, 0x76, 0x29, 0xc9,
			0x6c, 0xec, 0x62, 0x93, 0xf4, 0xe3, 0x14, 0xf9,
			0x8d, 0xf7, 0x7a, 0x1c, 0x65, 0xef, 0x53, 0x8f,
			0x50, 0x9d, 0x36, 0x5e, 0xbe, 0x06, 0x26, 0x4f,
			0xeb, 0xc3, 0x66, 0x67, 0x55, 0xa7, 0x8e, 0xb0,
			0x73, 0xa2, 0xdf, 0x3a, 0xa4, 0xe5, 0xd4, 0x60,
			0x66, 0x47, 0xf9, 0x4c, 0xc8, 0xe8, 0x00, 0xbe,
			0x22, 0x14, 0x12, 0x08, 0x03, 0x6a, 0x63, 0x5e,
			0x6b, 0x3d, 0x09, 0x4c, 0x3a, 0x3a, 0x0e, 0x88,
			0xe9, 0x4b, 0xc4, 0xea, 0x78, 0xbc, 0x58, 0xb9,
			0xa7, 0x9d, 0xaa, 0x28, 0x69, 0x67, 0x5c, 0x20,
			0x96, 0xe2, 0x2a, 0x40, 0xe0, 0x45, 0x79, 0x23,
			0x08, 0x9f, 0x32, 0xe1, 0x52, 0x77, 0xd0, 0xd8,
		},
		/* S3 : 256 byte */
		{
			0x91, 0x2f, 0xdc, 0xc5, 0x71, 0x9a, 0x8a, 0xf7,
			0x38, 0x9d, 0xb8, 0x75, 0x6b, 0xb0, 0xf6, 0x30,
			0xa4, 0xc7, 0x8a, 0x1b, 0xd1, 0xfe, 0xc7, 0xc4,
			0xa6, 0xf3, 0xe5, 0x09, 0x24, 0xa9, 0x81, 0x8c,
			0x9e, 0xca, 0x4a, 0x4e, 0xfb, 0xaf, 0x9e, 0x8b,
			0xad, 0x55, 0xd6, 0x46, 0x8d, 0x83, 0xc5, 0x4d,
			0x04, 0x50, 0xb5, 0x3a, 0x26, 0x7a, 0x50, 0x68,
			0x5e, 0x7f, 0xb9, 0x35, 0x50, 0xc2, 0xef, 0x35,
			0x54, 0xf6, 0x9b, 0x4e, 0x49, 0xd3, 0xbe, 0x35,
			0x9b, 0xc0, 0xb8, 0x8f, 0x3e, 0x75, 0x37, 0x14,
			0x68, 0x4a, 0xc0, 0x47, 0xb4, 0xdf, 0xb4, 0x36,
			0x14, 0x0b, 0x13, 0x12, 0x9f, 0xc4, 0xbb, 0xfe,
			0xed, 0x86, 0x54, 0x85, 0x00, 0xd4, 0x87, 0x09,
			0x4d, 0x22, 0x2e, 0xd4, 0xe2, 0x49, 0xdb, 0x0a,
			0x46, 0xb3, 0x4b, 0xa5, 0x24, 0x7c, 0x1b, 0x86,
			0xe8, 0x65, 0x0a, 0x70, 0x3c, 0x9d, 0x3e, 0x03,
			0x74, 0x43, 0x3d, 0x3a, 0xf5, 0x25, 0x78, 0xd3,
			0x5f, 0x0f, 0x91, 0x08, 0x43, 0x9d, 0xf0, 0x70,
			0x11, 0x88, 0xda, 0x20, 0x6b, 0x57, 0x9e, 0x17,
			0x12, 0x81, 0x1c, 0x1e, 0x33, 0xb3, 0xda, 0x32,
			0xf3, 0x3a, 0xcc, 0x9c, 0xd0, 0xbe, 0xd6, 0x0c,
			0xfe, 0x97, 0x7a, 0x4a, 0x6c, 0x6a, 0xa6, 0x49,
			0x8e, 0xce, 0xba, 0xb9, 0xbe, 0x86, 0xc2, 0x16,
			0xa7, 0x21, 0x4e, 0xec, 0xb1, 0x3c, 0x2b, 0x7d,
			0x4d, 0x30, 0x9f, 0x54, 0x88, 0x01, 0x20, 0x56,
			0x90, 0x50, 0x60, 0xc3, 0xea, 0xbe, 0x90, 0xf3,
			0x6b, 0x01, 0x58, 0x8a, 0xcb, 0x32, 0x88, 0x69,
			0x03, 0x4e, 0x00, 0xbd, 0x19, 0xbf, 0x5c, 0x1a,
			0x44, 0xd8, 0xea, 0x2a, 0x89, 0xb7, 0x47, 0xb2,
			0x87, 0x5d, 0x97, 0x04, 0x7c, 0x53, 0xf2, 0x90,
			0x3f, 0x67, 0xb5, 0xa6, 0x0a, 0xa8, 0x7a, 0xa7,
			0x0a, 0x94, 0x79, 0x73, 0x51, 0x98, 0xa5, 0x08,
		},
		30, /* salt length */
		/* V3 : 30 byte */
		{
			0xaa, 0x10, 0xfe, 0xc3, 0xf8, 0x3b, 0x7a, 0x97,
			0xe0, 0x92, 0x87, 0x7a, 0x5b, 0xf9, 0x08, 0x12,
			0x83, 0xf5, 0x02, 0xa0, 0xa4, 0x6b, 0x50, 0xe3,
			0x95, 0xab, 0x98, 0x3a, 0x49, 0xac, 
		},
	},
	/* SHA512 [4] */
	{
		/* Msg4 : 128 byte */
		{
			0x1a, 0xa2, 0x15, 0xc9, 0xf1, 0x60, 0x50, 0xf3,
			0x1f, 0x0c, 0xe5, 0xad, 0xc8, 0xcf, 0xa5, 0x94,
			0xe4, 0x4e, 0xf2, 0x90, 0x87, 0xdc, 0x23, 0xac,
			0x65, 0xed, 0x2a, 0x25, 0x95, 0xce, 0x73, 0xc0,
			0x95, 0x94, 0x10, 0x61, 0x8f, 0x53, 0x14, 0xda,
			0xda, 0x90, 0x3c, 0x01, 0xc4, 0xf8, 0xd5, 0x05,
			0x8f, 0x52, 0xd9, 0x02, 0xb9, 0xb2, 0x5c, 0xd2,
			0x81, 0xef, 0x26, 0x27, 0xa6, 0x58, 0xa2, 0xd6,
			0x72, 0xa3, 0xf7, 0x76, 0xf7, 0x26, 0x74, 0x2a,
			0x99, 0x4a, 0x31, 0xbb, 0xcc, 0x3c, 0xf3, 0xea,
			0x1f, 0xe5, 0x51, 0x04, 0x7a, 0x1d, 0x15, 0xb6,
			0xa3, 0x1b, 0xe5, 0x23, 0x07, 0x30, 0x23, 0x34,
			0xb8, 0xb6, 0x11, 0x2f, 0xb2, 0x43, 0x39, 0x8c,
			0x62, 0x22, 0x0c, 0x04, 0x69, 0x03, 0xc9, 0xea,
			0x9d, 0xf1, 0xa0, 0xbe, 0x50, 0x85, 0x18, 0x00,
			0xd6, 0x59, 0xae, 0x42, 0x41, 0xc0, 0xbe, 0x81,
		},
		/* S4 : 256 byte */
		{
			0x6b, 0xa8, 0x00, 0xb8, 0x69, 0x2a, 0xe5, 0x68,
			0x34, 0x4c, 0x44, 0x80, 0x94, 0xe3, 0xe1, 0x6f,
			0x50, 0xdc, 0x2c, 0x53, 0xed, 0xcf, 0xbb, 0xc9,
			0xc7, 0xbe, 0x9c, 0x07, 0x46, 0x1c, 0x0e, 0x06,
			0x86, 0xfc, 0xfe, 0xd6, 0x07, 0xaf, 0x2a, 0x66,
			0x29, 0x1f, 0xcf, 0x8e, 0x96, 0x53, 0xfb, 0x3e,
			0x98, 0x57, 0xb2, 0x08, 0xba, 0x21, 0x01, 0x00,
			0xdf, 0x9e, 0x6c, 0x04, 0x95, 0xab, 0x4d, 0x13,
			0xf1, 0x02, 0x90, 0x89, 0xcf, 0xea, 0x49, 0xa6,
			0xbe, 0x8b, 0x62, 0x03, 0x6f, 0x30, 0xe0, 0xd4,
			0xe4, 0xc1, 0xd9, 0x5a, 0x5e, 0xb9, 0x58, 0x03,
			0x97, 0xd3, 0xbc, 0xf6, 0x5a, 0x93, 0x11, 0xc2,
			0xd8, 0xde, 0x24, 0x9c, 0x2d, 0x1d, 0x74, 0x72,
			0x36, 0x95, 0x37, 0xcc, 0xce, 0xdf, 0x8a, 0x7f,
			0xeb, 0x0c, 0x17, 0x0e, 0xef, 0x41, 0x34, 0x1f,
			0x05, 0xe7, 0xd1, 0x7c, 0xaa, 0xc4, 0x26, 0x1b,
			0x62, 0x49, 0x87, 0x76, 0xa5, 0xeb, 0x1d, 0x9c,
			0xe7, 0xe4, 0x74, 0x6b, 0x48, 0x49, 0xf9, 0x02,
			0x1f, 0x0a, 0xff, 0x91, 0x71, 0x79, 0x75, 0x02,
			0x53, 0xc7, 0x19, 0x01, 0x7f, 0xb5, 0xdd, 0x68,
			0x55, 0x67, 0x2e, 0xeb, 0x08, 0x47, 0xca, 0x07,
			0x5e, 0x58, 0x9e, 0x32, 0x0f, 0x35, 0x6f, 0x49,
			0x87, 0x24, 0x55, 0xb3, 0x0f, 0x8c, 0xc1, 0xa3,
			0xa7, 0xe1, 0xa4, 0x27, 0x6e, 0xd6, 0xa9, 0x09,
			0xbe, 0x06, 0xbd, 0x9f, 0x89, 0xc3, 0x49, 0x4f,
			0xf7, 0xdb, 0x43, 0x2d, 0x0d, 0x4d, 0x3f, 0x3c,
			0xcb, 0x0b, 0xe7, 0x1b, 0x0b, 0xda, 0x4f, 0x66,
			0xff, 0x79, 0x77, 0x30, 0x04, 0x90, 0x5c, 0x61,
			0x02, 0xd9, 0x64, 0xb3, 0xb5, 0xa5, 0xe2, 0x8e,
			0x45, 0x78, 0x84, 0x0c, 0x0e, 0x48, 0x8b, 0x7f,
			0x2b, 0x4f, 0x31, 0x06, 0x6b, 0x61, 0xe1, 0x38,
			0x21, 0xe8, 0x8a, 0x0d, 0xdd, 0x2b, 0x1c, 0x2e,
		},
		30, /* salt length */
		/* V4 : 30 byte */
		{
			0xaa, 0x10, 0xfe, 0xc3, 0xf8, 0x3b, 0x7a, 0x97,
			0xe0, 0x92, 0x87, 0x7a, 0x5b, 0xf9, 0x08, 0x12,
			0x83, 0xf5, 0x02, 0xa0, 0xa4, 0x6b, 0x50, 0xe3,
			0x95, 0xab, 0x98, 0x3a, 0x49, 0xac, 
		},
	},
	/* SHA512 [5] */
	{
		/* Msg5 : 128 byte */
		{
			0xcc, 0xe6, 0xea, 0x5a, 0x46, 0xbd, 0xd6, 0x80,
			0x51, 0x60, 0xdc, 0xe4, 0x09, 0xd1, 0x02, 0x3c,
			0xd7, 0x1d, 0x38, 0x93, 0x30, 0x3c, 0xa0, 0x49,
			0x7f, 0x39, 0x2d, 0x5c, 0x5f, 0x93, 0x6f, 0xe5,
			0x0e, 0xe2, 0xad, 0xe6, 0x1e, 0xbd, 0x35, 0x42,
			0x6e, 0xdc, 0xf0, 0x0d, 0x59, 0x7a, 0x39, 0x06,
			0x2d, 0xfd, 0xef, 0x62, 0xdf, 0xd9, 0xc9, 0xcc,
			0xfd, 0xb2, 0xea, 0xa9, 0xe3, 0xc1, 0xb6, 0xa0,
			0x32, 0x78, 0xe3, 0x5a, 0x7e, 0x69, 0xd3, 0x86,
			0x47, 0x64, 0x21, 0x21, 0x2b, 0xdf, 0x7a, 0xf4,
			0x59, 0x9b, 0xae, 0x5e, 0x49, 0x85, 0x06, 0x53,
			0xab, 0xdb, 0xd9, 0xa5, 0x9d, 0x8f, 0x5a, 0x82,
			0x20, 0xf0, 0xb4, 0x3f, 0xcd, 0x87, 0x59, 0x53,
			0xc4, 0x3f, 0x96, 0xa7, 0xe6, 0xca, 0x6c, 0x0d,
			0x44, 0x3f, 0x9b, 0x0d, 0xd6, 0x08, 0xff, 0xe8,
			0x71, 0xfb, 0x1f, 0xd7, 0xf3, 0xc7, 0x04, 0x94,
		},
		/* S5 : 256 byte */
		{
			0x9a, 0x46, 0x54, 0x79, 0xc1, 0x47, 0x4c, 0x1a,
			0x54, 0xf1, 0x6f, 0x30, 0x9b, 0xd8, 0x7b, 0x0c,
			0x64, 0x1a, 0x45, 0x8d, 0x86, 0x17, 0x3a, 0x4f,
			0x29, 0xc2, 0x82, 0x9f, 0xea, 0x04, 0x10, 0x78,
			0x7a, 0x81, 0xb3, 0xc1, 0x36, 0x0c, 0xfc, 0x52,
			0x5d, 0x13, 0x3d, 0xfd, 0xec, 0xc1, 0x3a, 0xcd,
			0xd5, 0x19, 0x99, 0x54, 0xdd, 0x84, 0x40, 0x73,
			0x96, 0x08, 0x54, 0x57, 0x24, 0xcf, 0x12, 0x70,
			0xca, 0xa3, 0x9a, 0x22, 0x1e, 0x9c, 0x6b, 0xfb,
			0xa3, 0x99, 0xb9, 0xb0, 0x5e, 0x55, 0x70, 0x88,
			0x75, 0xba, 0xc1, 0x57, 0x86, 0x42, 0xba, 0x72,
			0x11, 0x26, 0x06, 0x62, 0x29, 0x9b, 0xf5, 0xef,
			0x68, 0xa3, 0x95, 0x94, 0xe3, 0x8f, 0xae, 0xe1,
			0x49, 0x89, 0xac, 0x5b, 0x2d, 0xaa, 0x13, 0x21,
			0x1e, 0xce, 0x39, 0x4c, 0xde, 0x46, 0xaf, 0xa1,
			0xb1, 0x10, 0xbb, 0x55, 0xf6, 0x31, 0xbd, 0xae,
			0x5b, 0x84, 0x8d, 0xfd, 0xb8, 0x92, 0x0d, 0x7c,
			0x74, 0xef, 0xf8, 0x2e, 0xcd, 0xf5, 0x9f, 0x2c,
			0x6e, 0xd9, 0xb8, 0x18, 0xc2, 0x33, 0x63, 0x64,
			0xb2, 0xa5, 0x6d, 0x34, 0xa2, 0x2a, 0xc4, 0x20,
			0x89, 0xdc, 0x57, 0x30, 0xe8, 0xe5, 0x7b, 0x35,
			0x6c, 0xc4, 0x82, 0x2c, 0x1e, 0x64, 0x62, 0x68,
			0xdc, 0x6a, 0x42, 0x3e, 0x03, 0x4b, 0x8b, 0x15,
			0x12, 0xd4, 0x1b, 0x88, 0xc7, 0x0b, 0x27, 0xe4,
			0x31, 0xd6, 0x81, 0x51, 0xe6, 0x1a, 0x4f, 0xa5,
			0xc8, 0x9f, 0x1e, 0x90, 0xd6, 0x21, 0xe0, 0x72,
			0x28, 0xc0, 0x34, 0x6c, 0xa4, 0x6f, 0x76, 0x7a,
			0x98, 0x9f, 0x1b, 0x0d, 0x00, 0x72, 0x37, 0x64,
			0x5d, 0x44, 0x80, 0x30, 0xa7, 0xfe, 0x45, 0xee,
			0x0f, 0x46, 0x52, 0x12, 0x72, 0xa8, 0xcc, 0x45,
			0x3a, 0x83, 0x59, 0x84, 0xf8, 0x26, 0x87, 0x52,
			0xbe, 0xf8, 0x01, 0xb6, 0x22, 0x61, 0x40, 0xb5,
		},
		30, /* salt length */
		/* V5 : 30 byte */
		{
			0xaa, 0x10, 0xfe, 0xc3, 0xf8, 0x3b, 0x7a, 0x97,
			0xe0, 0x92, 0x87, 0x7a, 0x5b, 0xf9, 0x08, 0x12,
			0x83, 0xf5, 0x02, 0xa0, 0xa4, 0x6b, 0x50, 0xe3,
			0x95, 0xab, 0x98, 0x3a, 0x49, 0xac, 
		},
	},
	/* SHA512 [6] */
	{
		/* Msg6 : 128 byte */
		{
			0xcb, 0x79, 0xce, 0xe1, 0xe7, 0xc3, 0x54, 0x67,
			0x50, 0xdd, 0x49, 0xfb, 0x76, 0x05, 0x46, 0xe6,
			0x51, 0xe2, 0xa4, 0x2b, 0xa4, 0xbb, 0xe1, 0x60,
			0x83, 0xe7, 0x44, 0xbd, 0x13, 0x85, 0xc4, 0x73,
			0x91, 0x6d, 0x27, 0x3e, 0x95, 0x66, 0x67, 0x3e,
			0x98, 0x99, 0x59, 0x03, 0xb4, 0x45, 0x90, 0xe7,
			0xac, 0xb5, 0x80, 0xa0, 0x2c, 0x6f, 0xdf, 0x15,
			0x52, 0xaf, 0x51, 0x71, 0x6c, 0x13, 0x43, 0x76,
			0x04, 0x98, 0x17, 0x15, 0x1a, 0xc5, 0x82, 0x3b,
			0xb0, 0x26, 0x33, 0xed, 0x8c, 0xfc, 0xb6, 0x97,
			0x39, 0x33, 0x97, 0xa1, 0x4f, 0x94, 0xca, 0x44,
			0xf4, 0x3c, 0x4a, 0x9c, 0xa3, 0x4d, 0x01, 0xfe,
			0x2c, 0xe3, 0xe8, 0x8b, 0xfc, 0x4a, 0x6f, 0x05,
			0x9f, 0x6e, 0x1f, 0xe2, 0x83, 0x92, 0x7e, 0x9f,
			0xff, 0x45, 0x33, 0x57, 0x93, 0x92, 0x6a, 0x94,
			0x72, 0x78, 0x7a, 0x65, 0x3d, 0x9a, 0xc5, 0xb1,
		},
		/* S6 : 256 byte */
		{
			0x7c, 0xfc, 0xc2, 0x35, 0x18, 0xbc, 0x13, 0x7b,
			0x94, 0xdb, 0xc8, 0x7e, 0x83, 0xe5, 0xc9, 0x42,
			0xa5, 0x29, 0x7a, 0xb4, 0xf7, 0x0a, 0x4a, 0xd7,
			0x97, 0xb1, 0xdf, 0xa9, 0x31, 0xc9, 0xcf, 0xcb,
			0x30, 0x44, 0x9b, 0xa3, 0xb4, 0x43, 0xfd, 0x3a,
			0xbf, 0x4d, 0x35, 0x0b, 0x80, 0xfe, 0xaa, 0x96,
			0x87, 0xb3, 0x9e, 0x7b, 0x5b, 0x52, 0x4f, 0xfa,
			0x35, 0x06, 0x3a, 0xe6, 0xb4, 0xe1, 0x2a, 0x41,
			0xfd, 0x73, 0x4a, 0x24, 0xf8, 0x9c, 0x36, 0x52,
			0xb4, 0x49, 0xc2, 0x15, 0x40, 0x99, 0xa1, 0xc7,
			0x73, 0x9d, 0x5d, 0xb7, 0x7b, 0xa9, 0xde, 0x03,
			0x58, 0xa6, 0x9e, 0xc9, 0x9b, 0xcc, 0x62, 0x6f,
			0x65, 0x72, 0x13, 0xa2, 0x56, 0x73, 0x26, 0x31,
			0x46, 0x18, 0x51, 0xc9, 0x19, 0xa9, 0x3b, 0x04,
			0xad, 0x39, 0x80, 0x0f, 0x02, 0xd0, 0xe6, 0x27,
			0xcd, 0x01, 0xd4, 0xb8, 0x06, 0x97, 0xa9, 0xa1,
			0xfb, 0x0d, 0x71, 0xdf, 0x4f, 0x32, 0xec, 0xaa,
			0xd3, 0xf1, 0xd5, 0xc8, 0x0c, 0xac, 0x67, 0xa5,
			0x8c, 0x71, 0xce, 0x81, 0xe2, 0x3f, 0xc8, 0xa0,
			0x5e, 0xc8, 0x40, 0x01, 0x9c, 0x83, 0x4d, 0x78,
			0xee, 0x19, 0x55, 0xc5, 0xe4, 0x10, 0x65, 0xb3,
			0x23, 0xd0, 0x1f, 0xdb, 0xe8, 0x1b, 0x76, 0x84,
			0x48, 0xb4, 0xa7, 0x38, 0x88, 0x86, 0xc9, 0x74,
			0x0b, 0x15, 0x41, 0xec, 0xd8, 0x45, 0x4f, 0x73,
			0xab, 0x64, 0xf9, 0x0d, 0xd4, 0x6c, 0xce, 0x6a,
			0x23, 0x29, 0xbe, 0xae, 0x9f, 0x3e, 0xe0, 0xbf,
			0x56, 0x7b, 0x50, 0x74, 0x40, 0xab, 0x3c, 0xa9,
			0xde, 0x2e, 0x85, 0x53, 0x74, 0xdd, 0xf6, 0xe1,
			0x05, 0xb3, 0xd0, 0xb3, 0x3a, 0x13, 0x8d, 0x71,
			0x6d, 0x13, 0x8c, 0xe9, 0xf9, 0x57, 0x07, 0x97,
			0xa8, 0x2e, 0xae, 0x55, 0x7c, 0xf3, 0x21, 0xfa,
			0x09, 0xb8, 0x62, 0xe3, 0x1e, 0xe8, 0xd8, 0x5b,
		},
		30, /* salt length */
		/* V6 : 30 byte */
		{
			0xaa, 0x10, 0xfe, 0xc3, 0xf8, 0x3b, 0x7a, 0x97,
			0xe0, 0x92, 0x87, 0x7a, 0x5b, 0xf9, 0x08, 0x12,
			0x83, 0xf5, 0x02, 0xa0, 0xa4, 0x6b, 0x50, 0xe3,
			0x95, 0xab, 0x98, 0x3a, 0x49, 0xac, 
		},
	},
	/* SHA512 [7] */
	{
		/* Msg7 : 128 byte */
		{
			0x3d, 0xdc, 0x49, 0x17, 0x98, 0xc6, 0xd8, 0xc2,
			0xd6, 0x93, 0x25, 0x02, 0xe1, 0x4c, 0xa0, 0xd6,
			0xcd, 0x90, 0x01, 0x6c, 0x21, 0x94, 0x38, 0x42,
			0x72, 0x68, 0xa3, 0x8b, 0x37, 0x7c, 0x84, 0xd4,
			0xd8, 0x62, 0xb2, 0xe7, 0x08, 0xd5, 0x8f, 0xf0,
			0x55, 0xfb, 0x39, 0xde, 0xfd, 0xe7, 0x05, 0x0c,
			0x04, 0x62, 0x29, 0x21, 0x83, 0xeb, 0xb8, 0x35,
			0x43, 0xfc, 0xd4, 0x35, 0x8a, 0x8f, 0x1f, 0x88,
			0x35, 0xe1, 0x72, 0xf2, 0x07, 0x76, 0xd2, 0xb9,
			0x41, 0x5d, 0x9f, 0x07, 0x73, 0xb5, 0x0f, 0x90,
			0x91, 0x70, 0xdb, 0x74, 0x49, 0x57, 0x38, 0x67,
			0x94, 0x4e, 0x09, 0x0f, 0x8c, 0xda, 0x53, 0xad,
			0x7d, 0xe0, 0xf1, 0x00, 0x3e, 0xb0, 0x89, 0x67,
			0xc2, 0x41, 0xbe, 0x45, 0xea, 0xbe, 0xa7, 0xa9,
			0x9d, 0x42, 0x80, 0x2f, 0x1b, 0xe1, 0xa0, 0x21,
			0x8e, 0xe7, 0xab, 0xe2, 0xe3, 0x64, 0x09, 0x8d,
		},
		/* S7 : 256 byte */
		{
			0x68, 0xa4, 0x61, 0x40, 0x38, 0x2d, 0xbf, 0x84,
			0xb1, 0x79, 0x4c, 0xe8, 0x69, 0x37, 0x81, 0x2d,
			0x82, 0x20, 0xfc, 0x59, 0xe8, 0x3d, 0xd1, 0xaf,
			0xa0, 0x87, 0xef, 0xc4, 0x18, 0x83, 0x61, 0x6b,
			0xff, 0xfb, 0x82, 0x83, 0xbd, 0x6d, 0xd5, 0xee,
			0x19, 0x30, 0x33, 0x79, 0x51, 0xde, 0xd3, 0xbe,
			0x23, 0xfd, 0xc6, 0x57, 0xe1, 0xbc, 0x07, 0xf4,
			0x1b, 0x53, 0x9e, 0xb7, 0x79, 0xec, 0x98, 0xf4,
			0x36, 0xb3, 0x67, 0x25, 0x9b, 0x68, 0x41, 0xe4,
			0x95, 0xbf, 0x84, 0x55, 0x5a, 0xff, 0x07, 0x67,
			0x4c, 0x9f, 0xb7, 0x05, 0xc8, 0x5a, 0x9c, 0xc1,
			0xfd, 0xe4, 0xba, 0xd4, 0x05, 0x06, 0xe3, 0x37,
			0x3c, 0xc3, 0xa4, 0x90, 0xda, 0xad, 0xa1, 0xc1,
			0x07, 0x05, 0x17, 0x7c, 0x16, 0x57, 0x19, 0x10,
			0x4d, 0xaa, 0x8a, 0xb6, 0x75, 0x66, 0x66, 0x25,
			0x33, 0x5e, 0x09, 0xa2, 0x4f, 0x7a, 0x23, 0x63,
			0xd7, 0xb3, 0xb8, 0x78, 0xf3, 0x4f, 0xe6, 0x8f,
			0xe0, 0x14, 0x25, 0x27, 0x58, 0x81, 0xc3, 0x4b,
			0x60, 0xee, 0x78, 0xfc, 0xc0, 0xa5, 0x4d, 0x56,
			0xac, 0x83, 0x04, 0xfc, 0x7a, 0x4b, 0xc0, 0xd5,
			0xa4, 0x47, 0xab, 0x89, 0xb9, 0x20, 0x64, 0x01,
			0xe3, 0xc4, 0x45, 0xbb, 0x1c, 0xc8, 0xe0, 0xc2,
			0x54, 0x1f, 0xe0, 0xf3, 0x63, 0x4b, 0xb4, 0x9d,
			0x5a, 0xf3, 0xa1, 0xb7, 0xc2, 0xe7, 0x65, 0x1d,
			0x20, 0x83, 0x92, 0x71, 0x83, 0x11, 0x24, 0x7f,
			0x0f, 0x15, 0xe4, 0x04, 0x1a, 0x46, 0x30, 0x1b,
			0x93, 0xda, 0x2c, 0xda, 0x7a, 0xf8, 0x33, 0xd8,
			0x01, 0x91, 0x56, 0x58, 0x33, 0x92, 0x6a, 0x78,
			0x46, 0x8a, 0xba, 0xc9, 0xeb, 0x4b, 0x02, 0xc5,
			0xf0, 0x47, 0xed, 0x38, 0x85, 0x1c, 0x3e, 0xd7,
			0xad, 0xd4, 0xed, 0xc0, 0x5e, 0x84, 0x07, 0x48,
			0x1b, 0x8b, 0x94, 0x2a, 0xb6, 0x27, 0xe0, 0x3d,
		},
		30, /* salt length */
		/* V7 : 30 byte */
		{
			0xaa, 0x10, 0xfe, 0xc3, 0xf8, 0x3b, 0x7a, 0x97,
			0xe0, 0x92, 0x87, 0x7a, 0x5b, 0xf9, 0x08, 0x12,
			0x83, 0xf5, 0x02, 0xa0, 0xa4, 0x6b, 0x50, 0xe3,
			0x95, 0xab, 0x98, 0x3a, 0x49, 0xac, 
		},
	},
	/* SHA512 [8] */
	{
		/* Msg8 : 128 byte */
		{
			0xd4, 0x22, 0xe6, 0x3e, 0x3c, 0x65, 0xef, 0xf3,
			0xee, 0x15, 0xc7, 0xee, 0xb2, 0xef, 0x0d, 0xe7,
			0xab, 0x96, 0xa3, 0xc3, 0x7e, 0x2a, 0xf9, 0xc2,
			0xb7, 0x1d, 0x8f, 0xfa, 0x68, 0x42, 0xb5, 0x04,
			0x12, 0x27, 0x96, 0xf5, 0xc9, 0xa5, 0x74, 0x8f,
			0x94, 0xb5, 0x35, 0xb9, 0x13, 0x85, 0x1f, 0x2d,
			0x64, 0xcc, 0xe0, 0x71, 0x46, 0x5a, 0xd1, 0x08,
			0x7f, 0xf3, 0x7b, 0xe9, 0x7c, 0x5d, 0x5b, 0x30,
			0x38, 0xb8, 0xe2, 0x14, 0x5f, 0x0e, 0xc0, 0x19,
			0xb2, 0x2b, 0x62, 0x86, 0xad, 0xaf, 0xb9, 0x1a,
			0x67, 0x61, 0x3e, 0xfb, 0xbb, 0xc6, 0x33, 0xef,
			0xa5, 0xf3, 0x2b, 0xce, 0xee, 0x9f, 0xcc, 0x38,
			0x0c, 0x7c, 0xd4, 0x83, 0x44, 0xc8, 0x5a, 0xf7,
			0x11, 0x1e, 0x57, 0x3e, 0xc9, 0x93, 0x64, 0x16,
			0x7e, 0xfe, 0xc5, 0x49, 0x22, 0x97, 0xa7, 0xdf,
			0xef, 0xc4, 0xa6, 0x92, 0x06, 0x2f, 0x92, 0x82,
		},
		/* S8 : 256 byte */
		{
			0x2b, 0xc6, 0x33, 0x17, 0x15, 0xb6, 0x29, 0x72,
			0xa0, 0xa5, 0xda, 0xb2, 0x13, 0x8c, 0x56, 0x63,
			0xb0, 0xe3, 0x39, 0x61, 0x06, 0x3c, 0xe9, 0x73,
			0xe6, 0x8e, 0x1a, 0xd1, 0x72, 0x72, 0x3b, 0xce,
			0xa2, 0x93, 0xf7, 0xba, 0x35, 0xaf, 0x24, 0x50,
			0x4c, 0xb2, 0xe3, 0x73, 0xb1, 0x1f, 0x80, 0xb4,
			0x9f, 0x79, 0xd3, 0x90, 0x5e, 0x0a, 0xae, 0xf8,
			0x38, 0xfc, 0x7c, 0x7f, 0xb5, 0xdf, 0x49, 0xa3,
			0x22, 0xd7, 0xc3, 0xda, 0xa2, 0x94, 0xa1, 0xa0,
			0xa8, 0xb7, 0x1a, 0x52, 0xe2, 0xc5, 0xdd, 0x94,
			0x57, 0x5f, 0x31, 0x9c, 0x64, 0xef, 0x9f, 0x6f,
			0xc6, 0xbb, 0xb7, 0x0c, 0x0c, 0x97, 0xfa, 0x12,
			0xae, 0x78, 0xf7, 0x32, 0x34, 0xaa, 0xeb, 0x93,
			0xdf, 0x29, 0x9f, 0x81, 0x51, 0x34, 0x58, 0xec,
			0xd2, 0x43, 0xfc, 0xa5, 0x28, 0x4f, 0x44, 0xa1,
			0xaf, 0xcd, 0x05, 0x75, 0xdb, 0xf5, 0xf8, 0x1d,
			0x40, 0x62, 0x36, 0xce, 0x31, 0x5e, 0x98, 0xba,
			0x4c, 0x9e, 0xf7, 0xc1, 0xd4, 0x38, 0x96, 0xaf,
			0x3b, 0x5d, 0x17, 0x2e, 0x7a, 0x78, 0x6f, 0xc5,
			0x8c, 0x42, 0x20, 0xc2, 0x7b, 0x56, 0xe5, 0xc7,
			0xa9, 0xbe, 0x49, 0xa4, 0x0b, 0x49, 0x15, 0x83,
			0x05, 0x03, 0x4a, 0x29, 0x5a, 0x6c, 0x57, 0x43,
			0xcd, 0xa6, 0xc2, 0xc6, 0x9f, 0x7a, 0xc0, 0x2f,
			0x87, 0xed, 0x6c, 0xf7, 0xb4, 0xe9, 0x89, 0xce,
			0x82, 0x18, 0xe5, 0xe7, 0xcb, 0xda, 0xc1, 0x2f,
			0xe7, 0xde, 0x3a, 0x54, 0x37, 0x17, 0x00, 0x84,
			0xef, 0x8c, 0xe3, 0x3e, 0x35, 0x30, 0x39, 0x2c,
			0x25, 0xa5, 0x8e, 0xbe, 0xdd, 0xc0, 0x86, 0x68,
			0x5a, 0x4d, 0xfb, 0x9c, 0x0c, 0x5b, 0x91, 0xd9,
			0x46, 0xdf, 0x65, 0x16, 0x1f, 0xfb, 0xf8, 0x2a,
			0xa3, 0xd6, 0xa8, 0x0c, 0x7c, 0x07, 0x99, 0x5a,
			0xa3, 0xee, 0x06, 0xb1, 0x80, 0x0a, 0x54, 0xee,
		},
		30, /* salt length */
		/* V8 : 30 byte */
		{
			0xaa, 0x10, 0xfe, 0xc3, 0xf8, 0x3b, 0x7a, 0x97,
			0xe0, 0x92, 0x87, 0x7a, 0x5b, 0xf9, 0x08, 0x12,
			0x83, 0xf5, 0x02, 0xa0, 0xa4, 0x6b, 0x50, 0xe3,
			0x95, 0xab, 0x98, 0x3a, 0x49, 0xac, 
		},
	},
	/* SHA512 [9] */
	{
		/* Msg9 : 128 byte */
		{
			0x6e, 0x87, 0x21, 0x4f, 0xc1, 0xa8, 0xb0, 0x11,
			0x6f, 0x04, 0xa4, 0x5a, 0x67, 0xe1, 0x01, 0xac,
			0x75, 0xe9, 0x93, 0x33, 0x66, 0xc5, 0x32, 0xf9,
			0x6c, 0xee, 0x45, 0x59, 0xc4, 0xc0, 0x85, 0xb6,
			0x95, 0xd1, 0x04, 0x6d, 0x1c, 0x80, 0x6d, 0x07,
			0x06, 0xd1, 0x8d, 0xb4, 0x1d, 0x78, 0x12, 0xf5,
			0x27, 0x33, 0x93, 0x98, 0x0b, 0x5d, 0xd1, 0xe9,
			0x36, 0xc1, 0x3d, 0x27, 0x3d, 0xac, 0xba, 0x35,
			0xc4, 0x46, 0xa3, 0x92, 0x9e, 0x21, 0x10, 0x8b,
			0x36, 0x13, 0x55, 0xaf, 0x2d, 0x41, 0xcc, 0x84,
			0x44, 0x7d, 0xd5, 0x78, 0x7d, 0xd2, 0x1a, 0x1a,
			0x7d, 0x5c, 0x18, 0x8a, 0x35, 0x5d, 0xdb, 0x2e,
			0xc1, 0x8e, 0x08, 0xa7, 0x90, 0xb3, 0x21, 0x04,
			0xc6, 0x72, 0x05, 0x35, 0xde, 0x65, 0xb6, 0xc2,
			0x94, 0x6e, 0x5f, 0xbd, 0x02, 0x4b, 0x96, 0xf5,
			0x09, 0x6a, 0xde, 0x6c, 0xf2, 0xfe, 0x70, 0x0b,
		},
		/* S9 : 256 byte */
		{
			0x80, 0x2d, 0xb0, 0x67, 0xa8, 0xd9, 0x09, 0x67,
			0xc2, 0x86, 0x0c, 0x90, 0x76, 0xc1, 0xa0, 0x22,
			0x75, 0x60, 0xb5, 0x9b, 0x66, 0x35, 0x04, 0x90,
			0xaf, 0x11, 0x53, 0xd2, 0x0b, 0x31, 0x84, 0x09,
			0x18, 0xe7, 0xd7, 0x26, 0x2f, 0x63, 0x3d, 0x37,
			0x88, 0x0a, 0x15, 0x3b, 0x1a, 0x23, 0xe4, 0x0d,
			0x3c, 0xf9, 0xfc, 0xbd, 0x9c, 0x16, 0x10, 0x87,
			0x8b, 0x63, 0x17, 0xd9, 0xd1, 0x18, 0x7f, 0x80,
			0x07, 0x45, 0x12, 0x52, 0x45, 0x61, 0xf1, 0xc0,
			0xf9, 0x9f, 0x1b, 0x2b, 0xa1, 0x68, 0xa1, 0x5e,
			0xac, 0x09, 0x8b, 0x2b, 0x20, 0x67, 0x3a, 0xc6,
			0x3f, 0x9b, 0x00, 0x2e, 0x60, 0x88, 0x7f, 0xf2,
			0x96, 0xd1, 0x21, 0x2d, 0xc6, 0x96, 0x45, 0x0e,
			0x7b, 0xb1, 0x4a, 0x3e, 0xfb, 0xdc, 0xdb, 0xc7,
			0xf4, 0xae, 0x22, 0x10, 0xed, 0x35, 0xa3, 0xbf,
			0x02, 0x8d, 0x3e, 0xb9, 0x9a, 0xb6, 0x96, 0xf6,
			0x3a, 0x2f, 0xc6, 0x9d, 0x8c, 0xce, 0x4b, 0x45,
			0x84, 0x6a, 0xb8, 0x89, 0x43, 0xf8, 0x9d, 0x58,
			0x8a, 0x72, 0xf0, 0x0f, 0x15, 0xe1, 0xea, 0x16,
			0xd9, 0x99, 0x61, 0x08, 0x45, 0x42, 0x46, 0x7b,
			0x8f, 0x99, 0x8c, 0x11, 0x8f, 0xe7, 0x6a, 0x2a,
			0x32, 0x6c, 0xb1, 0xca, 0x3f, 0x99, 0x59, 0xc0,
			0x6c, 0x81, 0x0a, 0x00, 0x4a, 0x67, 0xcb, 0x06,
			0x55, 0xf8, 0xc6, 0x20, 0x2f, 0xf5, 0xe4, 0xce,
			0xd4, 0x3c, 0x4d, 0x8e, 0x0c, 0x36, 0x83, 0xd5,
			0x56, 0x07, 0xd4, 0xdd, 0xbc, 0xc0, 0xd9, 0xdd,
			0x4e, 0x17, 0x83, 0xb5, 0x8f, 0x51, 0xf9, 0x5e,
			0x15, 0x9f, 0xe5, 0x93, 0x06, 0x6c, 0xec, 0x53,
			0xb5, 0x44, 0xf2, 0x39, 0x1c, 0xbf, 0x0e, 0x3d,
			0xc4, 0x17, 0x2a, 0xfd, 0x5f, 0xf6, 0xde, 0x23,
			0x08, 0x84, 0x04, 0xf7, 0xa4, 0x96, 0xbb, 0xc6,
			0xa4, 0xce, 0x22, 0x82, 0x62, 0x04, 0xb6, 0xaa,
		},
		30, /* salt length */
		/* V9 : 30 byte */
		{
			0xaa, 0x10, 0xfe, 0xc3, 0xf8, 0x3b, 0x7a, 0x97,
			0xe0, 0x92, 0x87, 0x7a, 0x5b, 0xf9, 0x08, 0x12,
			0x83, 0xf5, 0x02, 0xa0, 0xa4, 0x6b, 0x50, 0xe3,
			0x95, 0xab, 0x98, 0x3a, 0x49, 0xac, 
		},
	},
};

typedef mod2048_t tv_t;


#include "siggenPSStest.c"
