/* siggenPSS_2_2048_testfc.c */
/*
 * Copyright (c) 2017 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/index.html.
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */

/*
 * This test vector was created based on SigGen15_186-2.txt from
 * https://csrc.nist.gov/CSRC/media/Projects/Cryptographic-Algorithm-Validation-Program/documents/dss/186-2rsatestvectors.zip
 *
 * The link to the archive file exists in the following URL:
 * https://csrc.nist.gov/projects/cryptographic-algorithm-validation-program/digital-signatures/
 */
/*
 * https://csrc.nist.gov/projects/cryptographic-algorithm-validation-program/digital-signatures/
 * https://csrc.nist.gov/CSRC/media/Projects/Cryptographic-Algorithm-Validation-Program/documents/dss/186-2rsatestvectors.zip
 * SigGenPSS_186-2.txt
 */
#include "siggenPSStest.h"

static const unsigned short sn1[] = {
	0xd95b, 0x71c9, 0xdfee, 0x453b, 0xa1b1, 0xa7de, 0x2c1f, 0x0b0a,
	0x6757, 0x9ee9, 0x1d1d, 0x3ad9, 0x7e48, 0x1829, 0xb86e, 0xdac7,
	0x50c4, 0x8e12, 0xa8cd, 0xb026, 0xc82f, 0x273d, 0xafc2, 0x2200,
	0x9f0d, 0xb3b0, 0x8b2d, 0xb10a, 0x69c4, 0xb2dd, 0xdaae, 0xceac,
	0x1b0c, 0x8626, 0x82ee, 0xf294, 0xe579, 0xf55a, 0xab87, 0x1bc0,
	0xa7ee, 0xabc9, 0x23c9, 0xe80d, 0xddc2, 0x2ec0, 0xa270, 0x02ae,
	0xe6a5, 0xba66, 0x397f, 0x412b, 0xbaf5, 0xfb4e, 0xaf66, 0xa1a0,
	0xf82e, 0xaf68, 0x2719, 0x8caf, 0x49b3, 0x4725, 0x8b12, 0x83e8,
	0xcbb1, 0x0da2, 0x837f, 0x6ecc, 0x3490, 0xc728, 0xfe92, 0x7f44,
	0x455a, 0x6f19, 0x4f37, 0x76bf, 0x7915, 0x1d9a, 0xd7e2, 0xdaf7,
	0x70b3, 0x7d12, 0x627c, 0xc0c5, 0xfb62, 0x484f, 0x4625, 0x8d9c,
	0xe2c1, 0x1b26, 0x256d, 0x09cb, 0x412f, 0x8d8f, 0x8f1f, 0xe91b,
	0xb94a, 0xc27d, 0xe6d2, 0x6a83, 0xa843, 0x9e51, 0xb35d, 0xbee4,
	0x6b3b, 0x8ff9, 0x91d6, 0x67bb, 0x53ee, 0xee85, 0xff16, 0x52c8,
	0x981f, 0x141d, 0x47c8, 0x2057, 0x91ce, 0xf5b3, 0x2d71, 0x8ddc,
	0x082e, 0xd0dd, 0x5428, 0x2641, 0x6b22, 0x7106, 0x4ef4, 0x37a9,
};

static const unsigned short se1[] = {
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001,
};

static const unsigned short sd1[] = {
	0x2f21, 0xb01b, 0xe94d, 0xde7f, 0x5ec1, 0x8a38, 0x17f3, 0x274e,
	0xbb37, 0xf9c2, 0x6cc8, 0xc0d1, 0x169c, 0x0579, 0x4e7f, 0xe33a,
	0xe31d, 0xabfd, 0x09d3, 0x8845, 0xf094, 0xa0fa, 0xb458, 0xf14c,
	0x9730, 0xbe6d, 0x22d0, 0xe699, 0xee73, 0x73a1, 0xbde0, 0xb7fa,
	0x03e7, 0x8453, 0x6782, 0xeee1, 0x309d, 0x7081, 0x97be, 0x355b,
	0x624e, 0xd3bb, 0x4ae2, 0x664a, 0x5372, 0xdef6, 0x7082, 0xbf62,
	0x33ab, 0x6e2e, 0xea7a, 0xd8a3, 0xe5e7, 0x9ef5, 0xe1fc, 0xec41,
	0x5e6f, 0xa923, 0x798f, 0x05bd, 0xa0ca, 0x9a3b, 0xdedb, 0x45f4,
	0xd781, 0xef1a, 0x4f50, 0x75cd, 0x9bb3, 0x9963, 0x5da3, 0xe9a6,
	0x880e, 0xd021, 0xa750, 0xbc98, 0x06af, 0x81fb, 0xffcd, 0x4ace,
	0xaf80, 0x4ec7, 0x6808, 0xae18, 0x6715, 0xc772, 0xcaa9, 0x61a8,
	0x6299, 0x1c67, 0xca8b, 0xffef, 0x6b34, 0x087b, 0x44db, 0x5b59,
	0xabce, 0x0931, 0x7747, 0xfc75, 0x252f, 0x1705, 0x260b, 0x13dd,
	0x62cc, 0xbc74, 0x5091, 0xf3c1, 0xb64f, 0x5903, 0x1d34, 0x0c73,
	0x62a0, 0xe106, 0x6ab0, 0x554d, 0x466f, 0x209a, 0x3cf5, 0x1bc6,
	0x4b3c, 0x70c3, 0xce52, 0xf413, 0xd81b, 0x228f, 0xa31d, 0x9efd,
};

#define HAS_SHA1_TESTVECTOR

#define HAS_SHA224_TESTVECTOR

#define HAS_SHA256_TESTVECTOR

#define HAS_SHA384_TESTVECTOR

#define HAS_SHA512_TESTVECTOR

/* 10 elements */
static mod2048_t SHA1[] = {
	/* SHA1 [0] */
	{
		/* Msg0 : 128 byte */
		{
			0xfc, 0x6a, 0x11, 0xf9, 0x97, 0xf1, 0xb3, 0xa8,
			0x0e, 0x41, 0xe7, 0xe5, 0x09, 0x70, 0x35, 0xaa,
			0xf2, 0x53, 0xf0, 0x8a, 0x58, 0x4e, 0xbc, 0x2f,
			0x91, 0x6a, 0x4e, 0x06, 0xa4, 0xa8, 0x73, 0x39,
			0x66, 0x96, 0x54, 0xde, 0xe2, 0x1f, 0xf8, 0x6e,
			0xfe, 0xa7, 0x0a, 0x78, 0x5c, 0x58, 0xdd, 0x96,
			0x7f, 0xb6, 0xad, 0xa1, 0x2f, 0x7a, 0x28, 0x21,
			0x1e, 0x9d, 0x2c, 0x07, 0xcb, 0xb3, 0xd3, 0x9f,
			0xa7, 0x7a, 0xad, 0xc0, 0x77, 0xb3, 0x4c, 0x46,
			0xf9, 0x30, 0x06, 0xc1, 0xca, 0x2f, 0xf6, 0x6f,
			0x87, 0xe6, 0x44, 0x68, 0x32, 0x5f, 0xa6, 0x19,
			0xd8, 0x86, 0x27, 0xf3, 0x71, 0x81, 0x28, 0x64,
			0x08, 0x3f, 0xa4, 0x07, 0x1c, 0x54, 0xb8, 0x18,
			0x45, 0x04, 0x62, 0x2a, 0x1b, 0x9d, 0x89, 0x1c,
			0x53, 0x0b, 0x3d, 0x49, 0x2b, 0xa6, 0x41, 0xff,
			0x09, 0x4e, 0xc6, 0x33, 0x5e, 0xba, 0x7a, 0x72,
		},
		/* S0 : 256 byte */
		{
			0x2c, 0x05, 0x0a, 0x7c, 0xb3, 0x8e, 0xd1, 0x22,
			0x59, 0x2a, 0x8f, 0x5c, 0x9c, 0x7e, 0x7a, 0xf7,
			0xf6, 0xb9, 0x9f, 0x7e, 0x4d, 0x52, 0xe3, 0x05,
			0x8c, 0x93, 0xb9, 0x16, 0x87, 0x71, 0x96, 0x32,
			0x58, 0xd7, 0xc2, 0x33, 0xd2, 0xfa, 0xd4, 0x9b,
			0x31, 0x4c, 0x8a, 0x30, 0x39, 0xd9, 0xe4, 0x46,
			0xbc, 0x14, 0x8c, 0xfa, 0x4b, 0x08, 0x46, 0xb7,
			0xed, 0x23, 0xf0, 0x5c, 0x39, 0xbe, 0x5c, 0x22,
			0xaa, 0xdf, 0x71, 0x38, 0xff, 0x8e, 0x29, 0x41,
			0x84, 0xcc, 0x27, 0xba, 0x98, 0xfa, 0xc1, 0x03,
			0xf1, 0x28, 0x3d, 0x74, 0xd2, 0x88, 0x30, 0x5f,
			0x93, 0x68, 0x4d, 0xde, 0xbc, 0x85, 0x1b, 0x7a,
			0x2f, 0x30, 0xee, 0x10, 0xc8, 0x00, 0x22, 0x1c,
			0x2a, 0xe3, 0xe7, 0xd7, 0x30, 0xec, 0x4c, 0xf3,
			0xe6, 0xce, 0x8b, 0x2c, 0xde, 0x85, 0xf3, 0xa3,
			0x91, 0x3c, 0xd0, 0x83, 0x75, 0x3e, 0x1e, 0x39,
			0x5b, 0x71, 0xdf, 0xea, 0x96, 0xbb, 0x23, 0xd9,
			0xbd, 0xfc, 0x6e, 0x01, 0xcc, 0x96, 0xae, 0xde,
			0x35, 0x01, 0xea, 0xa7, 0xf6, 0xe8, 0xcd, 0x7e,
			0x64, 0x8a, 0xa8, 0x9c, 0xcd, 0x8a, 0xc9, 0xe2,
			0x4f, 0x6a, 0x1b, 0x43, 0x2f, 0xc7, 0x42, 0xf6,
			0xc1, 0x16, 0x16, 0xf4, 0xf8, 0x68, 0x81, 0xa8,
			0x77, 0x5b, 0xdd, 0x8b, 0x99, 0xf1, 0xd6, 0x6c,
			0x2e, 0x35, 0xa0, 0xdb, 0xcb, 0x89, 0xf3, 0x68,
			0xf8, 0x25, 0xdc, 0xff, 0xcd, 0xc1, 0xee, 0xf3,
			0x79, 0x01, 0x45, 0xf6, 0x25, 0x2b, 0xc7, 0x22,
			0xd6, 0xcb, 0x4c, 0xe8, 0xc2, 0x82, 0xd8, 0xc5,
			0x0a, 0x0c, 0xb4, 0xbe, 0xaf, 0x19, 0x6d, 0x2b,
			0x0b, 0xe5, 0x73, 0xf9, 0xea, 0x06, 0x88, 0xf0,
			0x5a, 0x3b, 0x84, 0x41, 0xf4, 0x67, 0x7b, 0xfd,
			0xd6, 0x55, 0x3d, 0x4e, 0x1c, 0xfa, 0xa3, 0xfa,
			0x64, 0x50, 0x02, 0xf5, 0xb0, 0x8c, 0x89, 0xab,
		},
		20, /* salt length */
		/* V0 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA1 [1] */
	{
		/* Msg1 : 128 byte */
		{
			0xd3, 0xb2, 0xe3, 0x51, 0xb2, 0x81, 0x70, 0xfd,
			0xf4, 0x28, 0x71, 0x59, 0x0d, 0x9d, 0x17, 0x9c,
			0xe2, 0x7c, 0x99, 0xf4, 0x81, 0xf2, 0x87, 0x82,
			0x0f, 0xd9, 0x5b, 0xa6, 0x01, 0x24, 0x51, 0x7e,
			0x90, 0x7e, 0x78, 0xa9, 0x66, 0x2e, 0x09, 0x51,
			0x9e, 0x3e, 0xf8, 0x68, 0xeb, 0xdc, 0xca, 0x31,
			0x17, 0x00, 0xa6, 0x03, 0xb0, 0x4f, 0xae, 0x4a,
			0xfe, 0x40, 0x90, 0xce, 0x37, 0x7d, 0x57, 0x38,
			0xf6, 0x8c, 0x88, 0xd2, 0xea, 0xae, 0x6a, 0x8e,
			0xcb, 0x07, 0xa5, 0x4a, 0x93, 0x00, 0x0e, 0x52,
			0xea, 0xea, 0xc2, 0x26, 0xe2, 0xe4, 0x72, 0x7e,
			0xe4, 0xfe, 0xfd, 0x8c, 0xeb, 0x9e, 0x44, 0x81,
			0xef, 0x23, 0x3a, 0x52, 0xa5, 0xc9, 0x3a, 0xbc,
			0x65, 0xcc, 0x9e, 0x86, 0x6b, 0xd1, 0x8d, 0x06,
			0x43, 0x81, 0x14, 0xe6, 0x7f, 0x77, 0x78, 0x28,
			0xab, 0x5c, 0xcb, 0x68, 0x83, 0x50, 0xbe, 0x61,
		},
		/* S1 : 256 byte */
		{
			0x1a, 0x7a, 0x00, 0x5e, 0x75, 0x67, 0x13, 0x2e,
			0x9b, 0xbd, 0xbf, 0x09, 0x5d, 0x8d, 0x43, 0xdf,
			0xb4, 0xbb, 0x88, 0x91, 0x3f, 0xc3, 0x33, 0xff,
			0x20, 0xfb, 0x7b, 0x53, 0x4a, 0x3f, 0xf2, 0x9f,
			0xcf, 0x75, 0x6b, 0xd4, 0x45, 0xe6, 0x84, 0xfc,
			0x4d, 0x00, 0xf5, 0xbd, 0xd5, 0x42, 0x25, 0xf2,
			0x0c, 0xa4, 0x05, 0x86, 0x2f, 0x2a, 0xb9, 0xb7,
			0x9c, 0x50, 0x21, 0x83, 0xc6, 0x75, 0x4a, 0xa8,
			0x2d, 0xa6, 0x2e, 0x24, 0xf6, 0x3c, 0x0a, 0xee,
			0xe8, 0x8c, 0xc3, 0xd6, 0x15, 0xc6, 0x2c, 0x63,
			0x01, 0x4c, 0xba, 0xf4, 0x5f, 0xc9, 0x7e, 0x27,
			0x39, 0xb6, 0x06, 0xb4, 0x5b, 0x6f, 0xa5, 0x5e,
			0x0c, 0x96, 0x9a, 0x8d, 0x86, 0xb6, 0xfe, 0x7c,
			0xf9, 0xb3, 0xf8, 0xf8, 0xcc, 0x83, 0x29, 0x54,
			0xae, 0xda, 0xfe, 0x39, 0x56, 0x38, 0x18, 0xba,
			0x56, 0xef, 0x29, 0x1a, 0xcb, 0x29, 0xdb, 0x6e,
			0x71, 0x4d, 0xb2, 0xa7, 0x81, 0xf0, 0x46, 0xa7,
			0x38, 0xc2, 0x68, 0x89, 0x98, 0xfd, 0x1c, 0x3c,
			0xa0, 0x7b, 0x9c, 0x93, 0xc5, 0x79, 0x9d, 0xe3,
			0xea, 0xfe, 0x8a, 0x96, 0x9f, 0x58, 0x81, 0x7f,
			0x82, 0x97, 0x85, 0x5c, 0x80, 0xc2, 0x49, 0x51,
			0x1d, 0x66, 0xaa, 0x3a, 0x87, 0x06, 0xa3, 0x75,
			0xe3, 0xdd, 0x7e, 0x6d, 0xfe, 0xdf, 0xdd, 0xcd,
			0xcc, 0xbf, 0xa9, 0xb7, 0xcd, 0xed, 0xe7, 0xd0,
			0xe4, 0x2c, 0x20, 0x27, 0x14, 0x5f, 0xd4, 0x30,
			0x1f, 0x8e, 0x14, 0xa8, 0x3b, 0x96, 0x88, 0x78,
			0x31, 0xf5, 0xdc, 0x7f, 0x1c, 0x31, 0x73, 0x79,
			0x36, 0x34, 0x4a, 0x2e, 0xaf, 0xa1, 0x78, 0x12,
			0x38, 0xb2, 0x97, 0xfa, 0xb4, 0x1d, 0xdd, 0x13,
			0x5c, 0xe5, 0x60, 0x09, 0x22, 0x37, 0x5d, 0xb4,
			0x2a, 0xcd, 0xbf, 0x15, 0x82, 0xbe, 0x37, 0x90,
			0x8c, 0x93, 0xef, 0x97, 0xbd, 0x1c, 0xbd, 0x64,
		},
		20, /* salt length */
		/* V1 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA1 [2] */
	{
		/* Msg2 : 128 byte */
		{
			0x5a, 0xa5, 0x10, 0xd8, 0x94, 0x96, 0x98, 0x6d,
			0x91, 0xac, 0x79, 0xa6, 0x91, 0xef, 0x26, 0x7c,
			0xb3, 0xd5, 0xcf, 0xb2, 0xc5, 0xc3, 0xd5, 0x71,
			0x5b, 0xd1, 0x80, 0x2f, 0x1e, 0xce, 0xf4, 0xd5,
			0x67, 0x84, 0x61, 0x20, 0x0d, 0x3c, 0x7b, 0x47,
			0x7b, 0x85, 0x2a, 0xdf, 0x05, 0x32, 0x82, 0xfc,
			0x7c, 0xa2, 0xf5, 0x9a, 0xff, 0x44, 0xc7, 0x3b,
			0x15, 0x59, 0xc3, 0xd1, 0xf9, 0xfc, 0x2d, 0xdd,
			0x35, 0x60, 0xf7, 0xd9, 0x72, 0x5a, 0x37, 0xd4,
			0x8f, 0x1f, 0xd9, 0x5c, 0xf0, 0x4e, 0x91, 0xa0,
			0x19, 0x31, 0x14, 0xd6, 0x7b, 0x40, 0x88, 0xdb,
			0x8d, 0xe6, 0x39, 0x19, 0x1f, 0x88, 0x8d, 0xae,
			0xec, 0xc4, 0x3a, 0xcb, 0x6e, 0xf6, 0xb6, 0x59,
			0xf6, 0x01, 0xf0, 0xe3, 0xfb, 0x4c, 0x3d, 0xb0,
			0xb2, 0x0a, 0x95, 0x2f, 0xe0, 0xbf, 0xff, 0x99,
			0xed, 0xff, 0x4a, 0xd1, 0x39, 0x79, 0xfe, 0x8f,
		},
		/* S2 : 256 byte */
		{
			0x56, 0x95, 0xa9, 0x11, 0xed, 0x82, 0x74, 0xc0,
			0x61, 0x84, 0xf4, 0x66, 0x6a, 0x42, 0xb6, 0xad,
			0xf9, 0x9e, 0x2b, 0x3e, 0x29, 0xd5, 0x4d, 0x3e,
			0xaa, 0xf1, 0xba, 0x3a, 0xab, 0xe0, 0x8c, 0xbb,
			0x94, 0x28, 0xa0, 0xe0, 0xef, 0x51, 0x38, 0xce,
			0xd8, 0x83, 0xaa, 0x91, 0x9f, 0xef, 0x2b, 0x99,
			0xf7, 0x92, 0x79, 0xaf, 0x1e, 0x42, 0x7c, 0x3b,
			0xfc, 0xc5, 0x92, 0x4f, 0xec, 0x6a, 0x76, 0x34,
			0xbc, 0x7f, 0x1f, 0x18, 0x6b, 0x41, 0xc3, 0x5a,
			0xba, 0xd8, 0x24, 0xb6, 0x7b, 0x0b, 0x27, 0x87,
			0x68, 0x06, 0x72, 0xc8, 0xd1, 0xc8, 0x16, 0x5b,
			0xd0, 0x5f, 0x14, 0xe8, 0x56, 0x73, 0xb0, 0x9d,
			0x04, 0xac, 0x8f, 0xcc, 0xb5, 0x25, 0xfe, 0x10,
			0x50, 0xa3, 0x84, 0x2a, 0x33, 0x42, 0xa1, 0x38,
			0xb0, 0x28, 0xbf, 0x6d, 0x30, 0xa8, 0x9c, 0xdd,
			0xbf, 0xed, 0xb7, 0x2b, 0x72, 0x7d, 0x0a, 0x51,
			0x01, 0xfc, 0xb0, 0x71, 0xfb, 0x26, 0x87, 0xe6,
			0x36, 0x62, 0x37, 0x7a, 0x4e, 0xcf, 0x65, 0xc6,
			0x92, 0x7a, 0xd8, 0x43, 0x70, 0x28, 0x21, 0xf8,
			0xae, 0x57, 0xfb, 0x4f, 0xd0, 0x47, 0x35, 0xcc,
			0x38, 0xb2, 0x11, 0x1b, 0x11, 0x0a, 0x39, 0x91,
			0xa7, 0xb7, 0xf2, 0x16, 0x62, 0xf4, 0x6e, 0x21,
			0xdb, 0x97, 0x9e, 0xc9, 0xce, 0x7b, 0xa5, 0x5d,
			0xc8, 0xd5, 0x7b, 0xc6, 0x42, 0x9f, 0x09, 0x06,
			0x62, 0x0a, 0xa7, 0xf5, 0x63, 0x3f, 0xca, 0xca,
			0xcb, 0xf9, 0x40, 0x36, 0x3a, 0xcc, 0xfa, 0xad,
			0x69, 0x7a, 0x24, 0xe2, 0xdf, 0xcf, 0xb1, 0x2e,
			0x23, 0x26, 0xb4, 0x68, 0x70, 0x32, 0x13, 0xf2,
			0x9e, 0xc4, 0x52, 0x5e, 0xf9, 0x31, 0x86, 0x92,
			0x1a, 0xa6, 0x46, 0x4f, 0x8b, 0xc3, 0xae, 0xa6,
			0x35, 0xb0, 0xb6, 0xe2, 0xd4, 0xf5, 0xe2, 0xe7,
			0xc1, 0x6b, 0xae, 0x20, 0xda, 0x67, 0xd5, 0x43,
		},
		20, /* salt length */
		/* V2 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA1 [3] */
	{
		/* Msg3 : 128 byte */
		{
			0x6e, 0x2f, 0x21, 0x9e, 0x59, 0x04, 0x20, 0x62,
			0x0f, 0x20, 0x53, 0x78, 0xf8, 0x1b, 0x7a, 0xf7,
			0xe7, 0x4e, 0x20, 0x86, 0xf0, 0x4e, 0x15, 0x0a,
			0x7a, 0xb3, 0x1f, 0x82, 0x94, 0x1e, 0xed, 0x2e,
			0x8d, 0x7a, 0x4c, 0xf7, 0xbe, 0x81, 0x9e, 0x0b,
			0xab, 0x82, 0x87, 0xc8, 0x4b, 0x62, 0xe9, 0xdb,
			0xa3, 0xe2, 0x13, 0xa9, 0x9a, 0x1f, 0x35, 0xee,
			0x08, 0x5f, 0x17, 0xa3, 0x10, 0x0a, 0x0b, 0x26,
			0xb0, 0xf7, 0x21, 0x95, 0x96, 0xe9, 0x99, 0x7a,
			0x35, 0x5a, 0x9e, 0xae, 0x19, 0x77, 0x31, 0x77,
			0x77, 0x6b, 0x63, 0xf4, 0x09, 0xe0, 0xc7, 0xbb,
			0x18, 0xc3, 0x27, 0xc0, 0xdb, 0x48, 0x76, 0x79,
			0xff, 0x2f, 0x06, 0x3f, 0x87, 0x45, 0xfb, 0xf8,
			0xd6, 0x2d, 0x00, 0xf3, 0x0a, 0x60, 0x38, 0x13,
			0x8c, 0x73, 0x77, 0x30, 0xe5, 0x99, 0xb3, 0xba,
			0xd4, 0x68, 0xb5, 0x9f, 0x9d, 0xe0, 0x14, 0x6f,
		},
		/* S3 : 256 byte */
		{
			0xc9, 0x64, 0x1d, 0x72, 0x64, 0x29, 0x4c, 0x70,
			0xd2, 0x72, 0x0c, 0x1c, 0x67, 0x9e, 0x9c, 0x55,
			0xf7, 0x0e, 0x36, 0xc7, 0xa3, 0x50, 0x1c, 0x2f,
			0xfa, 0xf0, 0x14, 0x8c, 0x9b, 0xa9, 0x4f, 0x36,
			0xe2, 0x6d, 0xde, 0xe2, 0xc3, 0x8e, 0xef, 0x0e,
			0xa1, 0xaa, 0xb9, 0x06, 0xf9, 0x79, 0xb5, 0x78,
			0xc5, 0xbc, 0x57, 0xbd, 0x70, 0x64, 0xa3, 0x15,
			0x61, 0x83, 0x20, 0x31, 0x38, 0x1a, 0x4c, 0x77,
			0x33, 0x23, 0xaa, 0x30, 0xb4, 0xc0, 0x7b, 0x6a,
			0x5d, 0x13, 0x60, 0x57, 0x38, 0xbd, 0xae, 0x68,
			0x60, 0x93, 0xe0, 0x1b, 0xed, 0x7a, 0x86, 0x86,
			0x68, 0x5e, 0xd4, 0xee, 0xa5, 0xb4, 0x50, 0x31,
			0x7e, 0xa5, 0x9e, 0x20, 0x01, 0x97, 0x43, 0xc9,
			0xc0, 0x38, 0xb7, 0x19, 0xb9, 0xb8, 0xd9, 0xfa,
			0x90, 0xb2, 0x6e, 0x8e, 0xf1, 0xa7, 0xa8, 0xa1,
			0x55, 0x5d, 0xc3, 0x78, 0x63, 0xaf, 0xd1, 0xeb,
			0x8b, 0x0c, 0x80, 0x2f, 0xbd, 0xb5, 0x3a, 0x57,
			0x59, 0x73, 0xee, 0x28, 0xaa, 0x95, 0x6c, 0x18,
			0x90, 0x5a, 0xfe, 0xf3, 0x52, 0x0c, 0x6d, 0xf5,
			0x42, 0x00, 0x70, 0x9d, 0xd6, 0xba, 0x4a, 0xeb,
			0xa0, 0x0d, 0x46, 0xf1, 0x82, 0x6b, 0x54, 0xf2,
			0x09, 0xd6, 0x2d, 0xa5, 0x23, 0x0f, 0x39, 0x5d,
			0xaa, 0xa4, 0x34, 0x45, 0x37, 0x1a, 0x7d, 0x25,
			0x0d, 0x38, 0x21, 0x6e, 0xd1, 0x8f, 0xb9, 0x15,
			0xea, 0x15, 0x84, 0xf5, 0xff, 0x58, 0x9b, 0x3a,
			0xef, 0x4d, 0x66, 0x4d, 0x29, 0x57, 0x6e, 0xfe,
			0x78, 0x05, 0xca, 0xe3, 0xbb, 0x14, 0x8e, 0xa2,
			0x6b, 0x01, 0x34, 0xa4, 0xd5, 0x47, 0xe9, 0x5d,
			0xed, 0x9e, 0x08, 0x40, 0xe5, 0xa6, 0x28, 0x75,
			0xfc, 0x45, 0xf2, 0xd5, 0x9e, 0xb0, 0xe3, 0x71,
			0xd3, 0xbb, 0x52, 0xfa, 0x94, 0xd7, 0xf8, 0x1e,
			0x2e, 0x0f, 0x45, 0x8a, 0xcd, 0xbc, 0x2c, 0xc7,
		},
		20, /* salt length */
		/* V3 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA1 [4] */
	{
		/* Msg4 : 128 byte */
		{
			0x3e, 0x4f, 0x0c, 0xf4, 0x12, 0xa6, 0xd5, 0x75,
			0x3b, 0x65, 0x29, 0x04, 0x28, 0x12, 0x07, 0xf9,
			0xe2, 0x5f, 0xea, 0x2e, 0xe4, 0xad, 0x41, 0xab,
			0x2e, 0xd0, 0x1e, 0x83, 0x95, 0x12, 0x32, 0xf9,
			0x5d, 0x7a, 0xf9, 0xe7, 0x09, 0x4e, 0x32, 0x61,
			0x72, 0xd6, 0x92, 0x95, 0x17, 0x63, 0xb9, 0xf5,
			0xb4, 0x90, 0x65, 0x99, 0x16, 0xc8, 0xe6, 0xde,
			0x2d, 0x08, 0xd2, 0x54, 0x63, 0xe6, 0xf9, 0xd7,
			0x2c, 0xd3, 0x9b, 0xfb, 0xde, 0x9d, 0xd9, 0xae,
			0xc4, 0x38, 0x6a, 0x18, 0x6d, 0xbd, 0x8f, 0xc6,
			0x4a, 0xb3, 0x49, 0x08, 0x79, 0x8e, 0xc9, 0x97,
			0xdb, 0x75, 0x28, 0x7b, 0x6c, 0x48, 0x58, 0x2c,
			0xd4, 0xe2, 0x5b, 0xf8, 0x39, 0x9b, 0xb2, 0xa4,
			0x58, 0x11, 0x19, 0x56, 0xd4, 0x29, 0x71, 0xb3,
			0xcd, 0x50, 0xfe, 0x44, 0xb5, 0x07, 0xd2, 0x1e,
			0x5f, 0x9e, 0x89, 0xc2, 0x59, 0x3f, 0x37, 0x42,
		},
		/* S4 : 256 byte */
		{
			0x36, 0xb3, 0xc7, 0xd7, 0xf4, 0x7d, 0xe9, 0xdc,
			0x81, 0x18, 0xd6, 0xee, 0x9d, 0x14, 0xe2, 0xd2,
			0x84, 0x61, 0xc0, 0x99, 0xab, 0x4a, 0xda, 0x99,
			0x9e, 0x82, 0x34, 0x13, 0x95, 0xe0, 0x88, 0xe2,
			0xd0, 0x9b, 0xed, 0x11, 0x88, 0x41, 0xff, 0x2c,
			0x60, 0xb1, 0x80, 0xa8, 0x5d, 0x6a, 0xbf, 0xb3,
			0xb9, 0x90, 0x3c, 0x12, 0xce, 0x20, 0x13, 0x37,
			0x90, 0x86, 0x59, 0xf8, 0xdc, 0x23, 0x8a, 0xaf,
			0x3b, 0x08, 0xc0, 0x02, 0x8c, 0xea, 0x81, 0x96,
			0x16, 0x53, 0x5a, 0x78, 0xfd, 0xdf, 0x2e, 0x69,
			0xe6, 0x3d, 0xb6, 0x70, 0xea, 0xde, 0x04, 0x60,
			0xde, 0xc9, 0x2a, 0x9e, 0x54, 0xfb, 0x7a, 0xc9,
			0x9b, 0x7a, 0x23, 0x72, 0x0b, 0xf4, 0x65, 0x9d,
			0x2e, 0x45, 0xd1, 0x64, 0x9d, 0x76, 0xe0, 0x79,
			0xa2, 0x11, 0x29, 0x1b, 0x1a, 0x9c, 0x13, 0xfa,
			0x13, 0x1b, 0xe2, 0xb7, 0xe3, 0x7d, 0xec, 0xcb,
			0xff, 0x19, 0x4c, 0x52, 0x95, 0x1b, 0x3c, 0x36,
			0xaf, 0x5d, 0xc6, 0xf7, 0xf5, 0xf9, 0xb2, 0x53,
			0x4c, 0xa4, 0x27, 0x91, 0xc6, 0x10, 0xba, 0x58,
			0x2b, 0xdd, 0x4b, 0x34, 0xc5, 0xce, 0x1c, 0xf7,
			0x11, 0xb5, 0x65, 0xbc, 0x2c, 0x0e, 0x63, 0xbb,
			0x29, 0x35, 0x65, 0x93, 0x4d, 0x2a, 0x89, 0x0c,
			0x83, 0xdc, 0xa7, 0x42, 0x4d, 0x6a, 0x28, 0x78,
			0x9d, 0x20, 0x54, 0x64, 0xec, 0x44, 0xd4, 0xbf,
			0x43, 0x1c, 0x7c, 0x9a, 0x63, 0x1c, 0x1f, 0x49,
			0x17, 0xb6, 0xe2, 0x3f, 0xff, 0x2a, 0xb4, 0xb4,
			0x3d, 0x29, 0x83, 0x47, 0x44, 0x5c, 0xc0, 0x4f,
			0x77, 0x3e, 0xe8, 0x6a, 0x0b, 0x78, 0xe6, 0x3c,
			0x59, 0xc0, 0xd5, 0x4b, 0xfe, 0xfc, 0xcf, 0xeb,
			0x19, 0xcd, 0xd3, 0x8e, 0xe4, 0x8b, 0x6d, 0x55,
			0x7d, 0x69, 0xef, 0xdc, 0x92, 0x3d, 0x04, 0xda,
			0x7b, 0x1b, 0x6f, 0xdf, 0x4f, 0x0b, 0x84, 0xe3,
		},
		20, /* salt length */
		/* V4 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA1 [5] */
	{
		/* Msg5 : 128 byte */
		{
			0xf4, 0x38, 0xa2, 0xf3, 0xc1, 0xc7, 0x52, 0x0a,
			0x47, 0x10, 0x27, 0xc0, 0xcb, 0xd4, 0x2a, 0x07,
			0x45, 0xbc, 0xb3, 0xea, 0x63, 0x4a, 0x8a, 0x20,
			0xd1, 0x10, 0x4c, 0xe1, 0xb8, 0x20, 0x10, 0xf8,
			0x85, 0xc3, 0x4b, 0x1a, 0xeb, 0x6e, 0xf1, 0x76,
			0x2b, 0xf1, 0xdd, 0x8d, 0x93, 0xf2, 0x73, 0x44,
			0x44, 0x9a, 0x84, 0x37, 0x39, 0x8e, 0x71, 0x51,
			0x85, 0x21, 0x94, 0x9a, 0xdc, 0xc8, 0xdb, 0x4f,
			0x55, 0xce, 0xb6, 0x38, 0x6e, 0x48, 0x34, 0x36,
			0x51, 0x4c, 0x69, 0x1c, 0x56, 0x5e, 0x12, 0xbf,
			0xc8, 0x2b, 0x7c, 0x51, 0xec, 0x7a, 0xa1, 0xea,
			0x3f, 0x5f, 0x94, 0x68, 0x00, 0xb1, 0x20, 0x79,
			0xee, 0xbf, 0xac, 0xf6, 0x53, 0x3f, 0x62, 0x73,
			0x41, 0x87, 0x91, 0x14, 0x1c, 0x00, 0x4f, 0xa2,
			0x58, 0xd7, 0x62, 0xdd, 0x84, 0xf5, 0x61, 0x14,
			0x88, 0x32, 0x16, 0xf4, 0x2b, 0xc5, 0x27, 0x9e,
		},
		/* S5 : 256 byte */
		{
			0x5e, 0x21, 0xfd, 0x11, 0xc3, 0xf2, 0x06, 0x20,
			0x04, 0xd2, 0x22, 0xa6, 0xdf, 0xc4, 0x52, 0xb8,
			0x00, 0xeb, 0x27, 0xca, 0xf1, 0x8c, 0x05, 0x57,
			0x17, 0xf8, 0x2f, 0xe2, 0x7e, 0x51, 0x6d, 0xa3,
			0x0a, 0xd7, 0xc4, 0x3b, 0x1a, 0xf4, 0x58, 0x58,
			0x5e, 0x78, 0x1b, 0xcc, 0x3b, 0xe4, 0x0b, 0x50,
			0x39, 0xc6, 0xa4, 0xd0, 0x3b, 0x2a, 0xbe, 0xb6,
			0xab, 0x16, 0x1d, 0x1d, 0x3b, 0xfb, 0x84, 0xd9,
			0xa5, 0x8a, 0xda, 0x26, 0xd6, 0xd1, 0x60, 0x15,
			0x11, 0xe4, 0xd2, 0x36, 0x73, 0x2d, 0x6c, 0xf8,
			0xa3, 0x4e, 0x5a, 0x3f, 0xe6, 0x06, 0xcc, 0xa0,
			0xfb, 0xf4, 0xcf, 0x03, 0x51, 0x64, 0x29, 0x39,
			0x16, 0x74, 0xbd, 0xc8, 0x88, 0xc0, 0xb6, 0x61,
			0xdc, 0x19, 0xd0, 0x09, 0xf5, 0x5b, 0x10, 0x53,
			0xe0, 0x6d, 0x84, 0xf7, 0x5f, 0xed, 0x14, 0xb7,
			0xf5, 0xfb, 0x08, 0x33, 0x7d, 0x81, 0x61, 0xdd,
			0x8b, 0x2d, 0x54, 0x13, 0x91, 0x64, 0x3d, 0x07,
			0xf3, 0x01, 0xcd, 0xb9, 0x5b, 0x19, 0xbb, 0x30,
			0x65, 0x5f, 0x7b, 0x13, 0xd9, 0x51, 0xd5, 0x2b,
			0x7f, 0xd3, 0x41, 0x51, 0x82, 0x7a, 0x3a, 0x16,
			0x04, 0xac, 0xf4, 0x47, 0x75, 0xe8, 0xdb, 0xbf,
			0x62, 0x2d, 0xaf, 0x9f, 0x43, 0x52, 0xa2, 0xc6,
			0xa9, 0x9f, 0x5e, 0x3d, 0xd0, 0xb4, 0x4d, 0x7e,
			0x2a, 0x70, 0x3e, 0x1c, 0x22, 0xa0, 0x26, 0x54,
			0xa5, 0xcb, 0x34, 0xde, 0xb2, 0xec, 0x11, 0xd9,
			0x54, 0x22, 0xea, 0x90, 0x0e, 0x5c, 0xe3, 0x26,
			0x31, 0xb0, 0x28, 0xe0, 0x0c, 0xcf, 0xc3, 0xfe,
			0x41, 0xec, 0x90, 0xc1, 0xb3, 0x5c, 0x43, 0x48,
			0x55, 0xa6, 0xe2, 0x47, 0x75, 0x20, 0xd8, 0x49,
			0x5c, 0x23, 0xd7, 0xec, 0xda, 0xf1, 0x12, 0x83,
			0x06, 0x7e, 0xed, 0xba, 0x61, 0x95, 0xd7, 0xd4,
			0xae, 0xf0, 0x7f, 0x77, 0x91, 0x35, 0xdf, 0x71,
		},
		20, /* salt length */
		/* V5 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA1 [6] */
	{
		/* Msg6 : 128 byte */
		{
			0x90, 0xd3, 0xc9, 0xd8, 0x4b, 0xbf, 0xe7, 0x15,
			0x0d, 0x4e, 0xfe, 0xc3, 0x66, 0x5d, 0xc7, 0xc9,
			0x6e, 0x33, 0xbb, 0xcc, 0x08, 0xb6, 0x78, 0x01,
			0x68, 0xde, 0x66, 0x3f, 0xd3, 0x6b, 0x9a, 0x59,
			0xa6, 0xd3, 0xfb, 0xaa, 0x9a, 0x7f, 0xa3, 0xf1,
			0x46, 0x36, 0x88, 0x60, 0xe6, 0xda, 0x5b, 0xef,
			0x5a, 0x52, 0xb0, 0xf6, 0x72, 0xc7, 0x60, 0xfb,
			0x68, 0x13, 0x2b, 0xc8, 0xae, 0x76, 0xa2, 0xc1,
			0xea, 0x8b, 0x45, 0x75, 0x40, 0x7b, 0xe8, 0x73,
			0xcf, 0x71, 0x5b, 0x5f, 0x7e, 0x4e, 0x49, 0x45,
			0xf8, 0x9d, 0x61, 0x2c, 0xf5, 0xc9, 0xb4, 0xef,
			0xbc, 0x8d, 0x5e, 0x48, 0xe5, 0xad, 0x69, 0x2e,
			0x64, 0xe4, 0xee, 0x61, 0xc3, 0x1d, 0x7d, 0x43,
			0xaf, 0xe6, 0xbf, 0xe9, 0xb6, 0x21, 0x5a, 0x72,
			0x4f, 0xfc, 0x15, 0x97, 0x1b, 0x24, 0x3d, 0x84,
			0x6a, 0x36, 0x47, 0xe6, 0x01, 0x77, 0xb6, 0x46,
		},
		/* S6 : 256 byte */
		{
			0xc3, 0x7b, 0xd1, 0x7d, 0x8d, 0x70, 0xf3, 0x60,
			0x86, 0x36, 0x01, 0xae, 0x8a, 0xff, 0x19, 0x79,
			0x9f, 0xa5, 0x09, 0x5b, 0x78, 0x8e, 0xfd, 0x6d,
			0x98, 0x98, 0x5e, 0xe1, 0xd5, 0xcc, 0x28, 0x24,
			0x20, 0x83, 0x3f, 0xd9, 0xdb, 0x82, 0x36, 0x35,
			0xe3, 0x6a, 0xb7, 0xeb, 0xfb, 0xcc, 0xde, 0x5b,
			0x39, 0x97, 0x19, 0x99, 0x8d, 0xcd, 0x34, 0x1b,
			0x8f, 0x67, 0x28, 0x2f, 0x4b, 0x53, 0xb8, 0x71,
			0x28, 0x63, 0xee, 0xc5, 0xd3, 0x94, 0x31, 0xf3,
			0xb1, 0x57, 0x37, 0x6f, 0x5e, 0xf6, 0xc6, 0x30,
			0x23, 0x92, 0xb1, 0xff, 0x65, 0x4e, 0xbb, 0x85,
			0x25, 0x2b, 0xb8, 0x5f, 0x3a, 0x4b, 0xfc, 0x23,
			0xc0, 0x20, 0x50, 0x38, 0x70, 0x7b, 0x09, 0x00,
			0xc3, 0x34, 0x30, 0x45, 0x06, 0x36, 0x40, 0x71,
			0x62, 0x07, 0xe2, 0x20, 0x3a, 0x04, 0x77, 0x93,
			0xb9, 0x15, 0xcc, 0x45, 0x45, 0xcd, 0x00, 0x49,
			0x13, 0xc9, 0x92, 0x79, 0x88, 0x4c, 0x20, 0x32,
			0xa6, 0x52, 0xdd, 0x06, 0xe2, 0xe7, 0x24, 0xfc,
			0xa9, 0xe3, 0x8b, 0x04, 0x22, 0x04, 0x3d, 0x94,
			0x4d, 0x1d, 0x89, 0xef, 0xd5, 0xb4, 0x65, 0xba,
			0x6e, 0x7a, 0xdf, 0x4a, 0xfc, 0xa7, 0x48, 0x14,
			0xa3, 0x3d, 0xa4, 0x6b, 0x8c, 0xb3, 0xfd, 0x8d,
			0x57, 0x4f, 0x94, 0xe1, 0xe2, 0x81, 0x81, 0x09,
			0xc1, 0x50, 0xfe, 0xbe, 0x85, 0x2a, 0xc8, 0xef,
			0x48, 0x26, 0xbc, 0x03, 0x92, 0x1a, 0xca, 0x33,
			0xe7, 0x7b, 0x90, 0x52, 0xec, 0xf5, 0x84, 0x0b,
			0xf6, 0x48, 0x7a, 0x87, 0x9a, 0xc6, 0xad, 0x7f,
			0x2f, 0x60, 0xab, 0x85, 0x23, 0x18, 0xad, 0x66,
			0x83, 0xa8, 0xfa, 0x77, 0xac, 0x5b, 0x46, 0x34,
			0x02, 0x7f, 0x9b, 0x96, 0x87, 0xfe, 0xe7, 0xa7,
			0xc8, 0x54, 0x0d, 0x63, 0x3b, 0x09, 0xe0, 0x10,
			0xc1, 0x1f, 0x8a, 0x46, 0x39, 0x02, 0x46, 0x40,
		},
		20, /* salt length */
		/* V6 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA1 [7] */
	{
		/* Msg7 : 128 byte */
		{
			0xeb, 0xc2, 0xc7, 0x08, 0x8b, 0xa2, 0x29, 0x1b,
			0xe3, 0x22, 0x53, 0xe9, 0xda, 0x5f, 0x75, 0x2e,
			0x48, 0x9f, 0x57, 0xe3, 0x50, 0x4a, 0x4b, 0x66,
			0xf0, 0x37, 0x61, 0xd5, 0xd6, 0x29, 0xd9, 0xba,
			0x75, 0x9a, 0xde, 0xee, 0x59, 0xb7, 0x71, 0xb7,
			0xb7, 0xab, 0xa3, 0x34, 0x49, 0x20, 0x07, 0xfb,
			0x58, 0x03, 0x67, 0x00, 0x1b, 0x88, 0xb6, 0xb9,
			0x3f, 0x6f, 0x46, 0x7f, 0xc7, 0x85, 0x3b, 0x38,
			0x16, 0x6d, 0x40, 0x33, 0x4a, 0xa0, 0x78, 0x53,
			0xcc, 0xb3, 0xb7, 0x70, 0x25, 0xd9, 0xf3, 0xfa,
			0x14, 0xa8, 0xf5, 0xdf, 0xdd, 0x20, 0x54, 0xaf,
			0xe3, 0xe9, 0xa4, 0xff, 0x79, 0xdc, 0xeb, 0x0b,
			0xf6, 0xc5, 0x54, 0x9f, 0x07, 0x67, 0x28, 0x37,
			0x4a, 0xc1, 0xf9, 0x65, 0x18, 0x90, 0x21, 0x73,
			0xa2, 0x15, 0x6b, 0x49, 0x3f, 0x18, 0x0f, 0x92,
			0x04, 0x2d, 0xe4, 0x1b, 0x96, 0x36, 0xd1, 0x7b,
		},
		/* S7 : 256 byte */
		{
			0x98, 0x46, 0xc4, 0xd2, 0xcc, 0x7f, 0xa9, 0xb2,
			0x3a, 0xcd, 0xb3, 0x28, 0x05, 0x2c, 0x1d, 0xe8,
			0x35, 0xd0, 0x13, 0x5a, 0x4b, 0x64, 0xe9, 0xb2,
			0x5f, 0xbe, 0x1a, 0x31, 0xd7, 0xb7, 0xf6, 0x4b,
			0xde, 0xd3, 0x8c, 0x77, 0xed, 0x6e, 0x55, 0xfe,
			0xaa, 0xf3, 0x42, 0x9f, 0x82, 0x31, 0xed, 0xba,
			0x1f, 0x11, 0x1e, 0xcd, 0xfc, 0x9d, 0xfc, 0x91,
			0xe0, 0x06, 0x79, 0xcf, 0x0c, 0xab, 0x12, 0xd9,
			0x0e, 0xae, 0x0d, 0xd3, 0xb4, 0x0c, 0xc9, 0xa6,
			0x49, 0xc3, 0x7e, 0xad, 0xbe, 0xb5, 0xaf, 0x19,
			0xd8, 0x7c, 0xc9, 0x3b, 0xb8, 0x10, 0x73, 0x26,
			0x7a, 0x3f, 0x58, 0x56, 0x22, 0x62, 0xf4, 0xab,
			0x55, 0x88, 0x74, 0x53, 0x18, 0x97, 0xf9, 0xda,
			0x9c, 0x97, 0xf2, 0xe9, 0x2e, 0x48, 0xef, 0x08,
			0x23, 0x14, 0x56, 0x0b, 0xfd, 0x65, 0xfb, 0x4f,
			0x56, 0x55, 0xe2, 0x40, 0x8d, 0x84, 0xeb, 0x00,
			0x12, 0x2a, 0xdf, 0x19, 0x1a, 0x7c, 0x5b, 0x7b,
			0xdb, 0x69, 0x24, 0xbd, 0x14, 0xc7, 0x07, 0xd4,
			0x89, 0x37, 0xba, 0x49, 0x2c, 0x36, 0x08, 0x5e,
			0xb7, 0x10, 0x5b, 0xb3, 0x69, 0xb9, 0xcb, 0x54,
			0x06, 0xb1, 0xbe, 0xf9, 0x8b, 0x04, 0x6d, 0xa9,
			0x28, 0x71, 0x99, 0xa1, 0x62, 0xec, 0xfc, 0x16,
			0x90, 0x3f, 0xb2, 0x9c, 0x10, 0xf7, 0xdf, 0xb4,
			0x88, 0x90, 0xd4, 0x0a, 0xb3, 0x19, 0xe4, 0x03,
			0x7f, 0xcd, 0xca, 0x4f, 0x99, 0x31, 0x0a, 0x68,
			0xed, 0x1b, 0xa3, 0x9b, 0xc8, 0x53, 0x91, 0x60,
			0x77, 0x81, 0xd5, 0xcf, 0x66, 0xe9, 0x17, 0x60,
			0x7b, 0x82, 0xea, 0x3a, 0x04, 0x32, 0x2f, 0xcc,
			0x86, 0x7f, 0x27, 0xea, 0x40, 0xd7, 0x25, 0xc8,
			0x38, 0x61, 0xfd, 0x5a, 0x73, 0x77, 0x48, 0xc6,
			0x5e, 0x1a, 0x3f, 0xa2, 0xb3, 0xcd, 0x9f, 0xf3,
			0xab, 0xf7, 0x05, 0xc1, 0x72, 0xf6, 0x4e, 0x8e,
		},
		20, /* salt length */
		/* V7 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA1 [8] */
	{
		/* Msg8 : 128 byte */
		{
			0xa2, 0x28, 0xe7, 0xe5, 0xa8, 0xdc, 0xba, 0xe4,
			0x88, 0xe8, 0xd4, 0x1a, 0x99, 0xd3, 0xf2, 0x5f,
			0x29, 0x49, 0x61, 0xe1, 0x7a, 0x11, 0x1b, 0xbc,
			0x0a, 0x3f, 0x34, 0xcb, 0x17, 0xab, 0x74, 0xbd,
			0x63, 0xa1, 0x46, 0x6b, 0x35, 0xda, 0xd0, 0x68,
			0xa0, 0xab, 0x64, 0xda, 0x07, 0x7d, 0x17, 0x89,
			0xe1, 0x7d, 0xaf, 0x36, 0xba, 0x95, 0xc3, 0x2e,
			0x7a, 0x9a, 0x1d, 0x1f, 0xea, 0xc7, 0x63, 0x29,
			0x74, 0x6a, 0xf7, 0x38, 0x2b, 0xdd, 0x1b, 0x92,
			0x0b, 0xb8, 0x59, 0xac, 0x81, 0x45, 0x22, 0x42,
			0x2e, 0x34, 0xb5, 0xa6, 0xe8, 0x90, 0x42, 0x59,
			0x01, 0xf2, 0x4f, 0xd8, 0xcc, 0xf5, 0x5c, 0xb8,
			0x5e, 0xe9, 0xc2, 0xf5, 0x92, 0xcc, 0xe1, 0x88,
			0x50, 0x76, 0x7a, 0x37, 0x0e, 0x13, 0x5a, 0xb1,
			0x96, 0xd6, 0x39, 0xda, 0x0a, 0xec, 0xe1, 0x64,
			0x26, 0xaf, 0x93, 0x9f, 0xc6, 0x1d, 0xa6, 0x92,
		},
		/* S8 : 256 byte */
		{
			0x17, 0x5a, 0x8a, 0xcb, 0xa4, 0xdb, 0xcf, 0x9e,
			0xb7, 0x12, 0x75, 0x09, 0x41, 0x07, 0x9b, 0x89,
			0x32, 0x6c, 0xae, 0x2c, 0xa3, 0xe2, 0xdb, 0x75,
			0xc0, 0xff, 0xd0, 0xbb, 0x77, 0xea, 0xbb, 0x85,
			0x93, 0x1a, 0xc6, 0x33, 0xf6, 0x67, 0x58, 0x14,
			0x2e, 0xbc, 0xb1, 0xda, 0x34, 0xfc, 0x46, 0xae,
			0xbd, 0x26, 0x5e, 0x01, 0x2a, 0x6b, 0xab, 0x94,
			0xd3, 0x89, 0x78, 0xeb, 0xc0, 0xc6, 0x28, 0x2d,
			0xbd, 0x31, 0x80, 0xf6, 0x81, 0xd1, 0xc9, 0x39,
			0x82, 0x7e, 0x59, 0x67, 0xde, 0x76, 0x96, 0x70,
			0xe1, 0x95, 0xcc, 0x57, 0x26, 0xc5, 0x7a, 0x8c,
			0x1f, 0x6e, 0x6e, 0x9f, 0x59, 0x48, 0xf5, 0x3b,
			0x48, 0x8c, 0xd9, 0xb9, 0x10, 0x94, 0x73, 0xab,
			0x87, 0x29, 0x4b, 0x36, 0xaa, 0xb3, 0x59, 0x8e,
			0x2a, 0x66, 0x7f, 0x7c, 0xa7, 0x3f, 0x90, 0x9e,
			0x41, 0x3a, 0xcd, 0x24, 0xab, 0xba, 0x76, 0xc2,
			0xb7, 0x50, 0x74, 0xd5, 0xa5, 0x1f, 0x54, 0x06,
			0x17, 0xbf, 0x11, 0xd2, 0x16, 0xd5, 0x8f, 0xa7,
			0x6a, 0xc6, 0x56, 0xd6, 0xc6, 0x72, 0x16, 0xe1,
			0xd2, 0xd1, 0xf0, 0xab, 0x1e, 0x06, 0xb2, 0x06,
			0x99, 0xb6, 0xb6, 0xd3, 0xed, 0x03, 0x0a, 0x57,
			0x4e, 0x8c, 0x34, 0x9d, 0xfc, 0xde, 0x78, 0x8f,
			0x1c, 0x69, 0x73, 0x11, 0xeb, 0x8b, 0x05, 0x8f,
			0xe6, 0x1b, 0xc1, 0x0c, 0xb6, 0xea, 0x7d, 0xa1,
			0x01, 0xda, 0xde, 0xb0, 0xa0, 0x26, 0xac, 0x2f,
			0xf0, 0x2d, 0x76, 0xdc, 0xd2, 0xd2, 0x9f, 0xbe,
			0x4e, 0x48, 0x09, 0xff, 0xbc, 0xae, 0x9c, 0x8f,
			0xa4, 0xda, 0x39, 0x5b, 0x97, 0xf7, 0x03, 0xa3,
			0xcb, 0x22, 0xb1, 0x48, 0x0e, 0x8c, 0xe6, 0xf2,
			0xce, 0x16, 0xd5, 0x14, 0x57, 0x09, 0xb3, 0x89,
			0xcf, 0xe4, 0x9a, 0x14, 0xb8, 0x25, 0x6b, 0xe1,
			0x98, 0x80, 0x8e, 0x2a, 0xb6, 0x51, 0x58, 0x21,
		},
		20, /* salt length */
		/* V8 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA1 [9] */
	{
		/* Msg9 : 128 byte */
		{
			0x4f, 0x66, 0x6b, 0x6d, 0x65, 0xf7, 0x7d, 0x24,
			0xb4, 0xe6, 0x5c, 0xc7, 0x4f, 0xcb, 0xcd, 0x53,
			0x4c, 0x32, 0xbe, 0x53, 0x1b, 0x9e, 0x34, 0x03,
			0x16, 0xce, 0x84, 0xb4, 0x58, 0x3e, 0xc6, 0x72,
			0xd3, 0xf1, 0x87, 0xe5, 0x9d, 0x6e, 0xbe, 0x75,
			0x8b, 0x09, 0x01, 0xb1, 0x01, 0x63, 0xf9, 0xf2,
			0x08, 0x34, 0x14, 0x3b, 0xa1, 0x48, 0x79, 0x64,
			0x5a, 0xc8, 0x41, 0x78, 0x1e, 0xbb, 0xe4, 0x5b,
			0x51, 0xcc, 0xf1, 0xb0, 0x1d, 0x4e, 0x03, 0xf9,
			0x06, 0x7d, 0xf0, 0x00, 0xc5, 0x07, 0x43, 0x77,
			0x53, 0xcb, 0xed, 0xdb, 0x44, 0xe0, 0x37, 0x9e,
			0x56, 0xd9, 0xfb, 0x84, 0x4a, 0x47, 0x14, 0x4e,
			0xf2, 0x80, 0x13, 0x96, 0x8c, 0x9f, 0x33, 0xfa,
			0x4e, 0xcc, 0x90, 0x7c, 0x42, 0xbe, 0x93, 0x29,
			0x54, 0x7d, 0xb1, 0xf9, 0xaa, 0x6d, 0x55, 0xf7,
			0x33, 0x88, 0x1a, 0xa1, 0x83, 0xeb, 0x3e, 0x92,
		},
		/* S9 : 256 byte */
		{
			0x02, 0x91, 0xd5, 0x51, 0x51, 0x3d, 0x3b, 0xbe,
			0x6b, 0x08, 0x8d, 0xec, 0x07, 0xb2, 0x4c, 0xfb,
			0xaf, 0xd7, 0x7f, 0x52, 0x1d, 0xcb, 0xf6, 0x1a,
			0x6e, 0x8a, 0xd7, 0xb7, 0x71, 0x43, 0xb5, 0xda,
			0x39, 0x8f, 0xd9, 0xa3, 0x25, 0x80, 0x0c, 0xfa,
			0xa7, 0xa9, 0x1b, 0xee, 0x4f, 0x27, 0x81, 0x1b,
			0x3d, 0xc2, 0x86, 0xe3, 0x7b, 0x84, 0x02, 0xae,
			0xe7, 0x10, 0x3f, 0x8b, 0xdb, 0xdf, 0x3e, 0xbf,
			0x0d, 0x19, 0xd3, 0xd2, 0x0f, 0x63, 0x70, 0xb5,
			0x8a, 0x19, 0x12, 0x80, 0x53, 0x94, 0xc3, 0xca,
			0x40, 0xd0, 0x75, 0xa1, 0x94, 0x57, 0x2b, 0xea,
			0x98, 0xed, 0xbe, 0x93, 0x63, 0x16, 0xc8, 0x5a,
			0x8e, 0xdf, 0x07, 0x14, 0xaa, 0x26, 0x28, 0x1c,
			0xea, 0x6c, 0xb3, 0xfc, 0x25, 0x4b, 0x91, 0xbc,
			0x47, 0xdf, 0xd3, 0x4d, 0xcb, 0xde, 0xd9, 0xe7,
			0x81, 0x8b, 0x20, 0x12, 0xcb, 0x5a, 0xa0, 0xca,
			0x0b, 0xc2, 0xf4, 0x41, 0x44, 0xf6, 0x22, 0x57,
			0xe5, 0xfa, 0xd0, 0x84, 0x71, 0x7f, 0xa4, 0xbc,
			0x74, 0xe3, 0x78, 0x20, 0x85, 0x91, 0x39, 0x9e,
			0xc0, 0xa8, 0xf5, 0x77, 0x23, 0x18, 0x07, 0x0c,
			0xa8, 0x36, 0x30, 0x6d, 0x25, 0x82, 0xb3, 0x61,
			0x66, 0xf8, 0xf1, 0x52, 0xc3, 0xe6, 0x04, 0x66,
			0xe9, 0x47, 0x77, 0xcc, 0x60, 0x2a, 0xee, 0xbb,
			0xce, 0x82, 0x4c, 0xe8, 0x6a, 0x26, 0xf0, 0x52,
			0x17, 0xac, 0x18, 0x80, 0x74, 0xc5, 0xbb, 0x82,
			0xd1, 0x18, 0x78, 0xd1, 0x4b, 0xaa, 0x31, 0x6e,
			0x26, 0x94, 0x9b, 0xd4, 0xe4, 0xd9, 0x41, 0x8a,
			0xcd, 0x1b, 0x74, 0x2a, 0x18, 0xad, 0x0e, 0x7b,
			0xac, 0xb5, 0xa3, 0xf7, 0xa1, 0xd1, 0xf0, 0xeb,
			0x6f, 0x03, 0x42, 0xc8, 0xe1, 0xd8, 0x7a, 0xc7,
			0x54, 0x43, 0x13, 0x47, 0x1b, 0xfd, 0x80, 0xce,
			0x4b, 0x5d, 0xdc, 0x67, 0x78, 0xfb, 0xae, 0x60,
		},
		20, /* salt length */
		/* V9 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
};

/* 10 elements */
static mod2048_t SHA224[] = {
	/* SHA224 [0] */
	{
		/* Msg0 : 128 byte */
		{
			0xe2, 0xb8, 0x14, 0x56, 0xc3, 0x55, 0xc3, 0xf8,
			0x0a, 0x36, 0x3a, 0x85, 0xcb, 0xf2, 0x45, 0xe8,
			0x5a, 0x5f, 0xf2, 0x43, 0x5e, 0x55, 0x48, 0xd6,
			0x27, 0xb5, 0x36, 0x22, 0x42, 0xaa, 0xca, 0x4e,
			0x4a, 0x2f, 0xa4, 0xc9, 0x00, 0xd2, 0xa9, 0x31,
			0x9e, 0xb7, 0xfc, 0x74, 0x69, 0xdf, 0x2a, 0x35,
			0x86, 0xaa, 0xa4, 0x71, 0x0e, 0x9b, 0x73, 0x62,
			0x65, 0x5c, 0x27, 0xa3, 0xc7, 0x02, 0x10, 0x96,
			0x23, 0x91, 0xb1, 0x03, 0x2d, 0xc3, 0x72, 0x01,
			0xaf, 0x05, 0x95, 0x1a, 0x1f, 0xc3, 0x6b, 0xaa,
			0x77, 0xe5, 0xc8, 0x88, 0x41, 0x9a, 0xb4, 0xe8,
			0xf1, 0x54, 0x63, 0x80, 0x78, 0x14, 0x68, 0xea,
			0x16, 0xe7, 0x25, 0x4a, 0x70, 0xb0, 0x86, 0x30,
			0xe2, 0x29, 0xef, 0xc0, 0x16, 0x25, 0x72, 0x10,
			0xd6, 0x18, 0x46, 0xd1, 0x1e, 0xd8, 0x74, 0x32,
			0x76, 0xa5, 0xd4, 0x01, 0x7e, 0x68, 0x38, 0x13,
		},
		/* S0 : 256 byte */
		{
			0xcd, 0x1f, 0xe0, 0xac, 0xb8, 0x99, 0x69, 0xae,
			0x13, 0x9c, 0x17, 0x8b, 0xfe, 0xf1, 0xcc, 0x98,
			0x29, 0x93, 0x52, 0x1b, 0x3a, 0x02, 0x0e, 0xc8,
			0x47, 0xc8, 0x9c, 0x0c, 0xc6, 0xc8, 0x69, 0xd9,
			0x70, 0xf4, 0x3f, 0x01, 0x8d, 0x49, 0x5b, 0x9e,
			0x99, 0x14, 0x57, 0xe7, 0x50, 0x1a, 0x34, 0x4c,
			0x33, 0xc3, 0x76, 0xfd, 0x2e, 0xfc, 0xf0, 0x5a,
			0xd6, 0xeb, 0x2b, 0xd0, 0xb3, 0xc0, 0xe7, 0xcc,
			0x3c, 0x88, 0xa4, 0x12, 0x43, 0x98, 0xca, 0x16,
			0x58, 0x54, 0x90, 0xa0, 0x81, 0x7a, 0x36, 0x14,
			0x9c, 0xc8, 0x2c, 0xdc, 0x01, 0xb2, 0x0e, 0x90,
			0x26, 0x26, 0x12, 0x15, 0xdd, 0x06, 0xf9, 0xdb,
			0x4e, 0x13, 0x61, 0x3c, 0x6a, 0x56, 0x9c, 0x21,
			0x87, 0xa0, 0xe0, 0x0b, 0xc6, 0x3c, 0x28, 0x11,
			0x49, 0x43, 0x3a, 0xc7, 0xf0, 0x61, 0xbd, 0x21,
			0x8e, 0x79, 0xf8, 0xec, 0xa9, 0xdd, 0x9c, 0x93,
			0xeb, 0xc3, 0xcc, 0x01, 0x3b, 0xf2, 0x7a, 0xa0,
			0xbf, 0x28, 0x6e, 0x12, 0x45, 0x93, 0xe7, 0x6d,
			0x3c, 0x70, 0x12, 0xf9, 0x7a, 0xe1, 0xd0, 0xc4,
			0xbf, 0x58, 0x23, 0xcf, 0x17, 0xfe, 0x76, 0xd5,
			0x05, 0xa5, 0x4c, 0xef, 0x17, 0x4a, 0xdd, 0x58,
			0xae, 0x61, 0x6f, 0x47, 0xde, 0x82, 0x50, 0x49,
			0xe9, 0x91, 0x6b, 0xf2, 0xab, 0x7d, 0xe4, 0xd4,
			0x43, 0x74, 0x57, 0x63, 0xb0, 0xc3, 0x14, 0xcf,
			0xae, 0x3a, 0x6e, 0x57, 0xad, 0x47, 0x5c, 0xc5,
			0xfa, 0xe4, 0x7c, 0xdd, 0xca, 0xd7, 0xb5, 0x26,
			0xc2, 0x15, 0x4a, 0x15, 0xf9, 0xee, 0x8e, 0xab,
			0x02, 0xf4, 0xc3, 0x6f, 0x7a, 0x41, 0xd7, 0xa1,
			0x9b, 0x23, 0xc5, 0x99, 0x6b, 0x62, 0x72, 0x70,
			0xce, 0xb2, 0xc0, 0xdb, 0xed, 0x1a, 0x6b, 0x6d,
			0xd2, 0xff, 0x94, 0x86, 0x8e, 0x07, 0x3c, 0xb7,
			0xb1, 0xa1, 0xfa, 0x34, 0x29, 0xe4, 0x87, 0xae,
		},
		20, /* salt length */
		/* V0 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA224 [1] */
	{
		/* Msg1 : 128 byte */
		{
			0x8c, 0xeb, 0x5b, 0x92, 0xc3, 0x60, 0xec, 0x55,
			0x62, 0x15, 0x5c, 0x95, 0x2f, 0x43, 0x53, 0x6e,
			0xaa, 0xfc, 0xe8, 0xa8, 0x4d, 0x62, 0x0a, 0x8a,
			0x12, 0x17, 0x1f, 0xee, 0x36, 0xf4, 0xec, 0x9b,
			0x3c, 0xfe, 0xb5, 0xce, 0x36, 0x95, 0xa5, 0x1a,
			0x40, 0xef, 0x70, 0x72, 0x4d, 0xc5, 0x36, 0x85,
			0x26, 0x4c, 0xab, 0x4a, 0xaf, 0x67, 0x75, 0xdb,
			0x6c, 0x1b, 0xd5, 0x86, 0x45, 0x43, 0x8a, 0x21,
			0x86, 0x85, 0xf2, 0x9f, 0x2a, 0x84, 0x73, 0xe1,
			0x59, 0x57, 0x19, 0xce, 0x2f, 0x3b, 0x80, 0xa6,
			0xbf, 0x84, 0xf5, 0x93, 0x58, 0xda, 0xd8, 0x82,
			0x07, 0xa1, 0x44, 0x30, 0x5c, 0xb9, 0xf3, 0x88,
			0x71, 0x68, 0x5b, 0x2c, 0x29, 0x94, 0x1d, 0x52,
			0xb6, 0x36, 0xa0, 0xd1, 0x5e, 0x0b, 0xf9, 0x7b,
			0x7e, 0x8d, 0x0f, 0xae, 0xcf, 0x21, 0xfc, 0x26,
			0xe8, 0x92, 0xb6, 0x15, 0x04, 0xbe, 0xee, 0x76,
		},
		/* S1 : 256 byte */
		{
			0x51, 0x09, 0xfc, 0xc7, 0x9f, 0x50, 0x98, 0xb8,
			0xb8, 0x3e, 0x59, 0xc6, 0xe0, 0xab, 0xc0, 0xfa,
			0x85, 0x17, 0xad, 0xbc, 0x1e, 0x9e, 0xe0, 0x30,
			0x23, 0x2b, 0xbb, 0x9e, 0x08, 0xf1, 0xa9, 0x3f,
			0x14, 0x35, 0xd8, 0xd4, 0x38, 0x93, 0xf8, 0xd1,
			0x07, 0xdc, 0x8a, 0x63, 0xc3, 0x23, 0x0f, 0xe2,
			0x41, 0x94, 0x35, 0x17, 0x82, 0x5c, 0x71, 0x0b,
			0xa0, 0x00, 0x64, 0x9a, 0x3e, 0x5e, 0xed, 0x74,
			0xd0, 0x29, 0x5a, 0x19, 0x59, 0x87, 0xe0, 0xa4,
			0x7c, 0xe1, 0x39, 0x88, 0xa8, 0xc9, 0xa1, 0xbb,
			0xe7, 0xa5, 0x59, 0x2e, 0x4f, 0xf2, 0x9e, 0xce,
			0xef, 0xc6, 0x96, 0x2d, 0xa1, 0x83, 0x48, 0x14,
			0x78, 0x00, 0x20, 0x63, 0x87, 0x0c, 0x64, 0xa0,
			0xa4, 0xd8, 0x2d, 0x8d, 0xe7, 0xcf, 0x2c, 0x7e,
			0x58, 0x2c, 0xf7, 0x94, 0x9c, 0x05, 0xae, 0xe3,
			0xad, 0xd5, 0xf0, 0x71, 0x9f, 0x00, 0x8a, 0x1e,
			0x6b, 0xd6, 0x75, 0xad, 0x9b, 0xf7, 0xac, 0xd4,
			0x84, 0x3a, 0x5e, 0xd2, 0xc2, 0x7f, 0x48, 0x9c,
			0xce, 0xbb, 0xa5, 0x96, 0x71, 0x15, 0xde, 0x46,
			0x86, 0xe3, 0xe0, 0x58, 0x11, 0xc6, 0x05, 0xf9,
			0x57, 0x59, 0xac, 0x97, 0xbe, 0xd9, 0xff, 0xd6,
			0x20, 0x04, 0x11, 0x59, 0x9d, 0x04, 0xf6, 0x4b,
			0x5d, 0xac, 0x39, 0x3d, 0x42, 0x8b, 0x70, 0x21,
			0x69, 0xa0, 0xe7, 0xd1, 0xc5, 0x04, 0xec, 0xe2,
			0xf1, 0xf4, 0x33, 0xbb, 0x7e, 0xeb, 0xba, 0x7a,
			0x72, 0x11, 0x25, 0xf3, 0xf2, 0x81, 0x87, 0x77,
			0xc8, 0x51, 0x43, 0xec, 0x43, 0x87, 0x88, 0x40,
			0xd1, 0x07, 0x1a, 0xba, 0x18, 0x5b, 0x4a, 0xa0,
			0x1f, 0xfa, 0x3a, 0x40, 0xc5, 0xaa, 0xcd, 0x33,
			0x98, 0x4c, 0xc3, 0x5e, 0x55, 0x19, 0x4e, 0x0c,
			0x5b, 0x48, 0x34, 0x12, 0xb7, 0x42, 0x54, 0x16,
			0xee, 0xaa, 0x09, 0xd5, 0xeb, 0x51, 0xdf, 0xad,
		},
		20, /* salt length */
		/* V1 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA224 [2] */
	{
		/* Msg2 : 128 byte */
		{
			0x24, 0x88, 0xc0, 0x5e, 0x65, 0x9d, 0x3a, 0x07,
			0x67, 0xe2, 0xd1, 0x50, 0x9d, 0x49, 0xbf, 0x5e,
			0x2b, 0xb9, 0x5e, 0xf3, 0x56, 0xb4, 0x3a, 0x38,
			0x39, 0x37, 0x6b, 0xba, 0xba, 0xe1, 0x22, 0xb2,
			0xbd, 0x58, 0x81, 0x89, 0x98, 0xe9, 0xb0, 0x9b,
			0xc6, 0x6e, 0x2d, 0x3c, 0xdf, 0x75, 0x63, 0xf8,
			0xc7, 0x9e, 0x7f, 0x1f, 0x26, 0x45, 0x7f, 0x82,
			0x19, 0x61, 0x8b, 0x77, 0x28, 0xac, 0x89, 0x23,
			0x77, 0x05, 0xec, 0xf8, 0x40, 0x12, 0xcc, 0x7c,
			0x80, 0x29, 0x3c, 0x4c, 0xf1, 0x71, 0xd8, 0x61,
			0x39, 0x44, 0x9d, 0x93, 0x61, 0xd8, 0xfe, 0x5b,
			0x88, 0x1f, 0x33, 0xdd, 0xd9, 0xeb, 0xd5, 0x26,
			0xba, 0x56, 0xa8, 0xb2, 0x46, 0x61, 0xb8, 0x31,
			0xfe, 0xdb, 0xa7, 0x8a, 0xbb, 0x85, 0x45, 0x21,
			0xe8, 0x73, 0x61, 0x56, 0xed, 0xb5, 0xdf, 0x4e,
			0xee, 0x37, 0x0b, 0xf5, 0xb6, 0xe6, 0x2d, 0x43,
		},
		/* S2 : 256 byte */
		{
			0x6a, 0x86, 0xf8, 0x52, 0x9d, 0xac, 0x97, 0xe0,
			0xfa, 0x65, 0xb0, 0xad, 0xa5, 0x83, 0xcf, 0xbe,
			0xef, 0x68, 0x90, 0x57, 0xe9, 0x59, 0x63, 0x89,
			0xad, 0x18, 0x20, 0x1a, 0x48, 0x3e, 0xb0, 0xe8,
			0xb2, 0x3e, 0x6f, 0x3d, 0x2e, 0x9f, 0x92, 0x8b,
			0x5f, 0xfc, 0x19, 0x1b, 0x56, 0xe0, 0x85, 0x1a,
			0x19, 0xc4, 0x8d, 0x71, 0x9b, 0x6b, 0x76, 0x37,
			0x70, 0x0f, 0x76, 0x2b, 0x68, 0x0f, 0xcf, 0xf4,
			0x13, 0x68, 0xed, 0x4b, 0x41, 0x8a, 0x2a, 0x30,
			0xe5, 0xd6, 0x8e, 0xe0, 0x56, 0x2c, 0x40, 0x77,
			0x44, 0x81, 0x4d, 0x53, 0x42, 0x80, 0xa4, 0xaa,
			0x41, 0xdf, 0x57, 0x3f, 0x01, 0x28, 0x9d, 0x49,
			0x18, 0x25, 0x61, 0x0b, 0x79, 0xdd, 0x3a, 0x57,
			0x2f, 0x67, 0x0e, 0xb4, 0x15, 0xe5, 0x16, 0x78,
			0x85, 0x9f, 0xd0, 0x71, 0x8a, 0x39, 0xf4, 0xf6,
			0x5a, 0x14, 0x3f, 0x46, 0xac, 0x08, 0x9a, 0x00,
			0x79, 0x5e, 0xcd, 0xc0, 0x39, 0xc2, 0x50, 0x9e,
			0xd2, 0xf8, 0x7f, 0x60, 0x34, 0x23, 0x80, 0xe6,
			0x74, 0x42, 0xed, 0x43, 0x44, 0x1d, 0x59, 0x66,
			0xec, 0x5b, 0x7c, 0xb9, 0x06, 0x5c, 0x1d, 0x30,
			0xfd, 0xd6, 0x5b, 0xfe, 0xe8, 0x40, 0xd4, 0xb2,
			0x59, 0x1e, 0x40, 0x92, 0xd5, 0x91, 0x23, 0x2a,
			0x3e, 0xca, 0xcb, 0xd1, 0x4a, 0xf4, 0x2c, 0x19,
			0xf4, 0x62, 0x7a, 0x30, 0xe5, 0x06, 0x4a, 0x44,
			0x93, 0xb7, 0x5f, 0xf1, 0x57, 0x57, 0x47, 0xcf,
			0x6f, 0x5d, 0x11, 0xf2, 0x7c, 0xd5, 0x30, 0xdb,
			0x1b, 0xaa, 0x81, 0x7c, 0x47, 0x8a, 0xd3, 0x2a,
			0xcc, 0xd2, 0x61, 0xca, 0xe8, 0x94, 0x5c, 0x22,
			0x3d, 0x4e, 0xe0, 0x5e, 0x0f, 0x34, 0x60, 0x26,
			0x02, 0xf4, 0xfb, 0x37, 0xfa, 0x56, 0x18, 0x07,
			0x37, 0xd6, 0x8f, 0x94, 0x31, 0x98, 0x80, 0x5c,
			0xe1, 0xa0, 0xc7, 0x04, 0xed, 0x42, 0x18, 0xcf,
		},
		20, /* salt length */
		/* V2 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA224 [3] */
	{
		/* Msg3 : 128 byte */
		{
			0x83, 0xd1, 0x3a, 0x74, 0x12, 0x46, 0xb4, 0xb7,
			0x78, 0xc6, 0x5d, 0x86, 0xf1, 0xee, 0x69, 0x14,
			0x6e, 0x3b, 0x74, 0x5f, 0x8b, 0x2a, 0x15, 0x6e,
			0xc2, 0x9d, 0xb7, 0xd7, 0xde, 0x81, 0xa4, 0x85,
			0xb2, 0xae, 0x63, 0xb8, 0x0a, 0x0e, 0x44, 0x4d,
			0xe2, 0x02, 0x39, 0x40, 0xd6, 0x01, 0xe7, 0x6f,
			0xda, 0x83, 0xfd, 0xa1, 0x2b, 0x1d, 0xc5, 0xc6,
			0x86, 0xed, 0xf9, 0x81, 0x97, 0x38, 0xd7, 0xe3,
			0xb4, 0x52, 0x77, 0x7a, 0xcb, 0xbe, 0x5d, 0x8a,
			0x99, 0x97, 0x4b, 0x9a, 0x1d, 0x2e, 0x58, 0x32,
			0x4d, 0xf5, 0x46, 0xe4, 0x07, 0x9c, 0x11, 0x89,
			0x4a, 0x79, 0xc4, 0xcd, 0xa6, 0x2d, 0x90, 0xee,
			0xf1, 0x85, 0x1f, 0xc0, 0x3c, 0x9e, 0x26, 0xf5,
			0x05, 0x4d, 0x3a, 0x9b, 0xaf, 0xbd, 0xe4, 0xe6,
			0x2f, 0x5a, 0xf7, 0x30, 0x07, 0xee, 0x21, 0x3e,
			0x78, 0x0a, 0xc1, 0xc5, 0xf3, 0xa8, 0xf8, 0x2c,
		},
		/* S3 : 256 byte */
		{
			0xb9, 0xca, 0xc4, 0x73, 0x90, 0x29, 0x30, 0xc7,
			0x0c, 0xc4, 0xd9, 0x57, 0xcd, 0xe1, 0x8c, 0x02,
			0xf7, 0x42, 0xea, 0xf9, 0xbc, 0xca, 0x6f, 0xf6,
			0x66, 0x6c, 0xb3, 0xb6, 0xa1, 0x0b, 0x5b, 0x11,
			0xf6, 0x67, 0xfe, 0x15, 0xa5, 0xe0, 0xb8, 0x99,
			0xb2, 0x9a, 0x78, 0x61, 0xcf, 0xc6, 0x82, 0x85,
			0x82, 0x8a, 0x3c, 0xca, 0xc9, 0xff, 0xab, 0xf3,
			0xdc, 0xb7, 0x1d, 0x92, 0x0e, 0xd2, 0x48, 0xe3,
			0x99, 0x1c, 0xc8, 0x72, 0x63, 0x76, 0xbf, 0x47,
			0xf3, 0x9c, 0xda, 0xd3, 0xd6, 0xb3, 0x43, 0x6b,
			0xe6, 0x66, 0xa7, 0x63, 0x3d, 0xc2, 0x02, 0x2b,
			0x89, 0xfc, 0x60, 0x17, 0xf8, 0x2f, 0x24, 0xaa,
			0xc7, 0x76, 0x80, 0x5a, 0xd0, 0x82, 0xab, 0x53,
			0x2b, 0x66, 0x9f, 0xdc, 0x7e, 0xc4, 0xb0, 0x5d,
			0xaa, 0x17, 0x59, 0x54, 0xd9, 0xda, 0x53, 0x57,
			0xb1, 0xc4, 0x47, 0x8e, 0x2a, 0x2d, 0x28, 0x9a,
			0xe4, 0x7d, 0xf1, 0x36, 0x53, 0x59, 0x3e, 0x42,
			0x2b, 0x17, 0xa6, 0x5d, 0x54, 0xc2, 0x2d, 0x2c,
			0x88, 0xfb, 0xf6, 0xcc, 0xe5, 0x88, 0xc3, 0x4e,
			0xe3, 0x0e, 0xeb, 0x20, 0xe6, 0x6f, 0x86, 0x40,
			0xb4, 0x37, 0x48, 0xdf, 0xe6, 0x1c, 0xb2, 0xd8,
			0xa6, 0x89, 0xc7, 0x19, 0x6a, 0x96, 0x8f, 0xd7,
			0x2b, 0xc1, 0xf7, 0x7f, 0x29, 0xd9, 0x8a, 0x2b,
			0x10, 0x6c, 0xcc, 0x5d, 0xd0, 0xe6, 0x49, 0xf9,
			0x98, 0x53, 0xcc, 0xfc, 0x00, 0xaa, 0xd0, 0x1d,
			0x32, 0x69, 0x47, 0xce, 0x28, 0xb3, 0xc8, 0x56,
			0x9a, 0x2e, 0x0e, 0x3f, 0x23, 0xb2, 0x31, 0x0b,
			0x6f, 0xcc, 0xd7, 0xad, 0x80, 0x0a, 0x4a, 0xac,
			0x7e, 0xe6, 0x8d, 0xb8, 0xf7, 0x75, 0x4a, 0xa8,
			0x9d, 0xc7, 0xc7, 0x3a, 0xbe, 0x75, 0x4d, 0x70,
			0x6f, 0x91, 0xf6, 0xe2, 0x2a, 0x8a, 0xe7, 0xd8,
			0xa4, 0xb7, 0xff, 0x17, 0x86, 0x34, 0xcf, 0xf7,
		},
		20, /* salt length */
		/* V3 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA224 [4] */
	{
		/* Msg4 : 128 byte */
		{
			0xb3, 0x72, 0x84, 0xcf, 0x1a, 0xaa, 0xd5, 0x30,
			0x3b, 0xb3, 0xb1, 0xf9, 0x0b, 0x01, 0xca, 0xe2,
			0xf0, 0xb2, 0xd8, 0x97, 0x76, 0x71, 0xe9, 0xbb,
			0x44, 0x9a, 0xf8, 0x2d, 0x4e, 0x9e, 0xc2, 0x8a,
			0x4c, 0xaa, 0xd5, 0xf3, 0x6a, 0x83, 0xea, 0x10,
			0x41, 0xb5, 0x74, 0x54, 0x06, 0xec, 0x79, 0x83,
			0x01, 0xa2, 0xa1, 0x72, 0x41, 0xfa, 0x8d, 0x0f,
			0x8f, 0xec, 0x69, 0xa0, 0xa0, 0xa3, 0xc5, 0x50,
			0x8f, 0x23, 0xa0, 0xe7, 0x8a, 0x2f, 0xc6, 0xd9,
			0xcb, 0x6a, 0x5d, 0x82, 0xc9, 0xbc, 0xba, 0xb0,
			0xb0, 0xf7, 0x79, 0x62, 0x0f, 0xbb, 0xcc, 0xcf,
			0xd1, 0x97, 0x13, 0xaa, 0x6f, 0x70, 0xad, 0xa5,
			0x64, 0x27, 0x0e, 0x34, 0xe0, 0x76, 0x12, 0x93,
			0xc0, 0x1b, 0x91, 0x0a, 0xbe, 0x39, 0x34, 0x70,
			0xe5, 0xfb, 0x87, 0xee, 0x49, 0x7a, 0x4f, 0x05,
			0xf4, 0xe1, 0x1d, 0xd2, 0x23, 0xcf, 0x23, 0x91,
		},
		/* S4 : 256 byte */
		{
			0x60, 0xf2, 0x07, 0x1a, 0x20, 0x1e, 0x8a, 0xa8,
			0xc3, 0xe6, 0x36, 0xd6, 0x03, 0xb6, 0xa6, 0x21,
			0x83, 0xe7, 0x4f, 0xcc, 0xc3, 0xb5, 0xf6, 0x0b,
			0xd5, 0x0f, 0xf8, 0xcb, 0x93, 0xef, 0xfe, 0xcc,
			0x40, 0xf4, 0x1f, 0x69, 0xfd, 0x4f, 0xbb, 0xb2,
			0x64, 0x68, 0xbd, 0xc5, 0x04, 0xa2, 0xd2, 0xb7,
			0x49, 0xc8, 0x9c, 0xd7, 0x95, 0x45, 0x2d, 0xb1,
			0xd4, 0x9f, 0x08, 0x0d, 0x0b, 0xac, 0xf0, 0x3b,
			0x45, 0x64, 0x88, 0x5a, 0xd0, 0xce, 0x8b, 0x3b,
			0xf4, 0x19, 0xb2, 0xca, 0x30, 0x88, 0x5a, 0x17,
			0xfd, 0xd4, 0x27, 0xb8, 0x0d, 0x8d, 0xb8, 0xa0,
			0xf3, 0xd7, 0x2e, 0xda, 0x51, 0x87, 0xd1, 0x11,
			0x5d, 0x3d, 0xc2, 0x66, 0x93, 0x4d, 0xa1, 0x80,
			0xb2, 0xe5, 0x15, 0x48, 0xdd, 0x67, 0xf4, 0xfa,
			0xd3, 0x99, 0xa6, 0x7f, 0xbb, 0xf5, 0x69, 0xbc,
			0x15, 0xdc, 0x6b, 0x90, 0x0a, 0x15, 0x73, 0x10,
			0xac, 0xd6, 0xda, 0x81, 0x6c, 0x14, 0x3a, 0xbc,
			0x3f, 0xab, 0xa2, 0x63, 0x55, 0x82, 0xaf, 0x9c,
			0x99, 0x63, 0x5b, 0x45, 0x3d, 0xbe, 0xf9, 0x76,
			0x29, 0x27, 0xd6, 0x19, 0x1c, 0xae, 0xe5, 0x93,
			0x84, 0x34, 0x7f, 0x3e, 0x37, 0x26, 0x8c, 0x7f,
			0x3a, 0x90, 0xfc, 0xde, 0x7e, 0x69, 0x89, 0xb3,
			0x8e, 0x9f, 0x15, 0x56, 0x05, 0x37, 0x32, 0x60,
			0xde, 0xdd, 0x58, 0x9a, 0x58, 0xde, 0xa3, 0xb0,
			0x99, 0x68, 0xaa, 0xf2, 0x73, 0xf7, 0x5f, 0xa5,
			0xd1, 0x3d, 0xfd, 0x75, 0x55, 0xbe, 0xe4, 0x85,
			0x24, 0x46, 0xc8, 0xc1, 0xfe, 0xd6, 0x89, 0x5f,
			0x3a, 0xcc, 0xe1, 0x6e, 0xa9, 0xea, 0x2a, 0x5a,
			0xd9, 0xee, 0x8d, 0xa3, 0x1c, 0x47, 0xee, 0x1f,
			0x2b, 0xd0, 0x51, 0x3a, 0x53, 0xcd, 0xa0, 0x74,
			0x58, 0x2d, 0x0e, 0x33, 0x8e, 0x96, 0x90, 0x55,
			0xd5, 0x82, 0x39, 0xc3, 0x64, 0x40, 0x25, 0x9e,
		},
		20, /* salt length */
		/* V4 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA224 [5] */
	{
		/* Msg5 : 128 byte */
		{
			0x7b, 0xd2, 0x09, 0xe0, 0x5a, 0x99, 0xc5, 0xb7,
			0xec, 0xde, 0x47, 0x7c, 0xfe, 0xc7, 0x70, 0x9a,
			0x1e, 0x3a, 0xda, 0x50, 0x5e, 0x95, 0xbd, 0x07,
			0x54, 0xa0, 0x14, 0xe3, 0x65, 0xc0, 0xfb, 0x98,
			0x44, 0x6d, 0x5c, 0x7f, 0xb5, 0xe5, 0xca, 0xe9,
			0x97, 0x22, 0xad, 0xb3, 0x21, 0x0a, 0xa0, 0x1a,
			0x6c, 0xe7, 0x17, 0xd1, 0x31, 0x16, 0x45, 0x51,
			0xd5, 0x03, 0x3d, 0x71, 0xa2, 0x55, 0x57, 0x36,
			0x58, 0x65, 0xd5, 0xec, 0xe4, 0xf5, 0xc6, 0x75,
			0x6f, 0x1f, 0x2b, 0xe2, 0x9a, 0x8b, 0x59, 0x40,
			0x08, 0xe5, 0x9e, 0xb4, 0x1e, 0x8e, 0x27, 0xcb,
			0x06, 0x92, 0x21, 0x0b, 0xfa, 0xdb, 0x1f, 0xce,
			0xbf, 0xa4, 0xbc, 0x50, 0x6f, 0x30, 0x81, 0x06,
			0x7c, 0xbb, 0x09, 0x31, 0xf2, 0xb1, 0x62, 0xb4,
			0xfc, 0x1e, 0xb7, 0x22, 0xaa, 0x65, 0x2c, 0x1c,
			0xf1, 0x36, 0x0a, 0xda, 0xf4, 0xba, 0x1c, 0x07,
		},
		/* S5 : 256 byte */
		{
			0xbb, 0x66, 0x88, 0xeb, 0x60, 0x71, 0x30, 0x62,
			0x0b, 0x27, 0x4e, 0x08, 0xad, 0x9a, 0x3a, 0xbc,
			0xd6, 0x5e, 0xc1, 0xe8, 0x7d, 0xf4, 0x99, 0x3f,
			0x5f, 0xec, 0xb8, 0xdd, 0x2f, 0xb7, 0x59, 0x53,
			0x82, 0x28, 0xa6, 0xea, 0x5c, 0x75, 0x53, 0x82,
			0xe1, 0x39, 0x58, 0xaa, 0x17, 0x56, 0xf4, 0x2a,
			0x3d, 0x9d, 0x68, 0xe2, 0x43, 0xbe, 0xeb, 0xec,
			0xb1, 0x81, 0xd6, 0x4a, 0xf3, 0xed, 0xe5, 0x36,
			0x22, 0xc4, 0x46, 0x9a, 0x49, 0x11, 0x7d, 0xb4,
			0xe2, 0x70, 0x91, 0x9d, 0x36, 0x2f, 0x47, 0x90,
			0x54, 0xb9, 0xb6, 0x60, 0xaf, 0xdd, 0x62, 0x15,
			0x76, 0x40, 0x32, 0xa8, 0x7a, 0x5d, 0xf0, 0xa2,
			0xc4, 0x87, 0xdb, 0xfe, 0x9b, 0xe6, 0x60, 0x56,
			0x27, 0xeb, 0x91, 0xeb, 0x95, 0x5c, 0xff, 0xa7,
			0x0a, 0xc4, 0xcb, 0x76, 0x79, 0xee, 0xdb, 0xb7,
			0x19, 0x09, 0xdd, 0xac, 0xc8, 0xdb, 0x1d, 0x38,
			0x8a, 0x36, 0x13, 0xf0, 0x20, 0x9a, 0x4e, 0xea,
			0x60, 0x65, 0x3e, 0x83, 0x87, 0xa5, 0x7c, 0x35,
			0xe5, 0xda, 0x14, 0xe2, 0x47, 0x53, 0x84, 0x20,
			0x27, 0x40, 0xe2, 0xf6, 0xc7, 0xa4, 0x9d, 0x0e,
			0x35, 0x98, 0xfb, 0x7e, 0x9a, 0x4c, 0x7d, 0xb0,
			0x8c, 0x4b, 0x23, 0x6c, 0x38, 0x44, 0x75, 0x54,
			0xf3, 0x27, 0x40, 0xcc, 0x5d, 0x03, 0x92, 0xa2,
			0x89, 0x94, 0x44, 0x2c, 0x3a, 0x7c, 0x98, 0x67,
			0x63, 0x03, 0xbb, 0x16, 0x3c, 0x1d, 0x3d, 0x48,
			0xcf, 0xc8, 0x5c, 0x8d, 0x4c, 0x00, 0x9b, 0x99,
			0x99, 0xe0, 0xc7, 0xbf, 0x94, 0x5c, 0xd0, 0x18,
			0x34, 0x93, 0x25, 0x89, 0xb7, 0x1c, 0x9f, 0xef,
			0xf8, 0x48, 0x79, 0xf2, 0x56, 0xbd, 0x71, 0xec,
			0x2c, 0xf5, 0xf9, 0x21, 0x14, 0x75, 0xec, 0x0d,
			0x28, 0x8a, 0xe3, 0xb8, 0x67, 0xad, 0xc0, 0x4d,
			0xaa, 0xde, 0xc0, 0x93, 0x4e, 0x15, 0xd4, 0x3a,
		},
		20, /* salt length */
		/* V5 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA224 [6] */
	{
		/* Msg6 : 128 byte */
		{
			0x4d, 0x04, 0x1c, 0xca, 0xce, 0xc9, 0x2f, 0xa6,
			0x36, 0xd7, 0x72, 0xd9, 0xee, 0x04, 0x32, 0x0b,
			0x47, 0x6a, 0xed, 0x4e, 0x60, 0xbd, 0x5c, 0x0b,
			0x49, 0xdc, 0xb0, 0x3c, 0x68, 0xa5, 0x1d, 0xdc,
			0x1c, 0x0e, 0x95, 0x9c, 0xa1, 0x71, 0xd6, 0xd8,
			0x34, 0x28, 0xa6, 0xc9, 0x77, 0x5a, 0x5d, 0xfc,
			0x16, 0x14, 0xa5, 0x03, 0xab, 0x9c, 0x7e, 0x6a,
			0xdf, 0x02, 0x85, 0xed, 0xd2, 0xf7, 0x75, 0xe7,
			0xbe, 0xe2, 0xee, 0x0e, 0xd7, 0x31, 0x75, 0x5e,
			0x75, 0xed, 0xbd, 0x53, 0x74, 0x92, 0x24, 0x5b,
			0xdb, 0x1d, 0x81, 0x8b, 0xbd, 0x66, 0x1d, 0x91,
			0x5d, 0xb0, 0xff, 0xea, 0x95, 0x7f, 0x6d, 0x55,
			0x79, 0xaa, 0xaf, 0x87, 0x37, 0xb0, 0x16, 0x20,
			0x42, 0x4f, 0x3d, 0xde, 0xaf, 0x53, 0x8f, 0x10,
			0xdf, 0xad, 0x09, 0x4e, 0x5e, 0xc4, 0x41, 0x68,
			0x0b, 0x10, 0xa8, 0x9c, 0x79, 0xe4, 0x0c, 0x0c,
		},
		/* S6 : 256 byte */
		{
			0x95, 0x92, 0x5a, 0x53, 0x76, 0xfe, 0x15, 0x25,
			0x18, 0xd8, 0x5d, 0xb1, 0x7b, 0xcb, 0x2f, 0x4d,
			0x09, 0x59, 0x13, 0x9f, 0xf2, 0xed, 0x0e, 0xa3,
			0x86, 0x10, 0x0e, 0x52, 0x45, 0xaa, 0x17, 0xef,
			0x1d, 0xc0, 0xe2, 0xa0, 0xdc, 0x46, 0x3b, 0xad,
			0x28, 0x27, 0x97, 0xa1, 0xf6, 0x67, 0xd1, 0xb6,
			0x17, 0x65, 0xe9, 0xb2, 0x55, 0xfb, 0xce, 0xbb,
			0x21, 0x91, 0xf8, 0x55, 0x9f, 0xc9, 0x66, 0xdb,
			0x7b, 0xfb, 0xd5, 0x5d, 0x1f, 0x58, 0x7b, 0x20,
			0xc0, 0x0e, 0x87, 0x45, 0x19, 0xfe, 0x54, 0x04,
			0xc2, 0x35, 0x34, 0x82, 0x6e, 0xe9, 0xf3, 0x77,
			0xee, 0x4f, 0x10, 0x3b, 0x6e, 0xaf, 0x5a, 0xe6,
			0x57, 0xe1, 0x32, 0x33, 0xfe, 0x9b, 0x36, 0x5e,
			0x6b, 0x19, 0xdc, 0x44, 0xa4, 0x2d, 0x72, 0x8a,
			0x81, 0x03, 0xa7, 0xe9, 0xf7, 0xd8, 0x09, 0xe4,
			0xd1, 0x86, 0x7e, 0xef, 0x3b, 0x3e, 0xb9, 0xf7,
			0x8d, 0x15, 0x1b, 0xbd, 0x35, 0xd6, 0x5d, 0xc8,
			0xa2, 0xef, 0xc9, 0xed, 0xa0, 0x5a, 0x29, 0x1c,
			0xce, 0xbd, 0x26, 0xa9, 0x9a, 0xdb, 0x5d, 0x3c,
			0x77, 0x13, 0x23, 0x90, 0xc3, 0x87, 0x98, 0xb4,
			0x0a, 0xa4, 0xec, 0x75, 0x46, 0xa8, 0xb5, 0x3a,
			0xf1, 0x67, 0xe0, 0xbf, 0x49, 0x5e, 0x8f, 0x2e,
			0x22, 0x49, 0x5b, 0x5a, 0x12, 0xe7, 0xc4, 0xf5,
			0x73, 0xc9, 0x57, 0xbf, 0x77, 0x1c, 0x2a, 0xe7,
			0xd9, 0xb7, 0x8b, 0xf9, 0x6c, 0xff, 0x81, 0x2a,
			0x97, 0x28, 0x61, 0x19, 0x48, 0x8d, 0x50, 0xbe,
			0x98, 0x1a, 0xd3, 0x1e, 0x89, 0x25, 0x9a, 0x06,
			0x28, 0x59, 0x6a, 0xeb, 0xbf, 0x1c, 0x97, 0x37,
			0x42, 0x12, 0xfc, 0x21, 0x02, 0x92, 0x3a, 0xe0,
			0x7a, 0x5f, 0x1f, 0x9b, 0x6f, 0x67, 0xf6, 0x88,
			0x07, 0x1d, 0x15, 0x4f, 0x0e, 0x50, 0xc8, 0x29,
			0x24, 0xb0, 0x71, 0x1e, 0x6a, 0x4e, 0x9b, 0xa3,
		},
		20, /* salt length */
		/* V6 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA224 [7] */
	{
		/* Msg7 : 128 byte */
		{
			0x06, 0x3b, 0x9b, 0xf1, 0x42, 0x44, 0x8c, 0x36,
			0x63, 0x4f, 0x67, 0xfa, 0x5e, 0xca, 0xed, 0xc5,
			0x29, 0x2a, 0xd0, 0x50, 0x28, 0x8d, 0xc8, 0x47,
			0xe8, 0x9d, 0xe3, 0x4d, 0x0f, 0xb8, 0x1d, 0x41,
			0x93, 0x4f, 0x30, 0xbf, 0x2b, 0x8c, 0xad, 0xea,
			0x03, 0x38, 0x4c, 0x69, 0xb4, 0xdb, 0x80, 0xb0,
			0x73, 0x25, 0x4f, 0x81, 0x88, 0x8c, 0x61, 0xb2,
			0x03, 0x37, 0x57, 0x30, 0xaa, 0x1b, 0x5e, 0x44,
			0x35, 0x64, 0x03, 0x15, 0xbe, 0x16, 0x49, 0x6f,
			0x73, 0xf4, 0xf8, 0xc2, 0x8e, 0xa1, 0x39, 0x6e,
			0x87, 0x05, 0x60, 0x3d, 0x87, 0xf2, 0x09, 0x31,
			0x21, 0x07, 0x66, 0x81, 0x3d, 0xd5, 0xd7, 0xde,
			0x54, 0x41, 0xbb, 0xfa, 0xe3, 0x29, 0x87, 0x4b,
			0x19, 0x4b, 0x15, 0x0d, 0xd3, 0x62, 0x3e, 0x86,
			0xcb, 0x91, 0xaa, 0x8d, 0x0c, 0x05, 0xe7, 0x4d,
			0xaa, 0xd7, 0xb9, 0x47, 0xaf, 0x2f, 0xb1, 0x96,
		},
		/* S7 : 256 byte */
		{
			0x62, 0x02, 0xa4, 0x56, 0xe3, 0x62, 0xa2, 0x8a,
			0x35, 0x6c, 0xef, 0xb5, 0xcb, 0x81, 0xa8, 0x90,
			0xf8, 0xae, 0x14, 0x6f, 0x54, 0x8f, 0xe2, 0x2a,
			0x3f, 0xe9, 0x90, 0xa0, 0x0e, 0xeb, 0x08, 0x1b,
			0x25, 0x01, 0x9a, 0x92, 0x1a, 0x75, 0xd8, 0x79,
			0xaa, 0x1d, 0x62, 0x88, 0xb3, 0x83, 0x85, 0xb4,
			0x03, 0xf2, 0x92, 0xd6, 0x4f, 0x3b, 0x7c, 0x98,
			0x76, 0x5c, 0xc1, 0x2a, 0x75, 0x86, 0xc3, 0x13,
			0x9d, 0x9a, 0x24, 0x58, 0x98, 0x79, 0xf0, 0xff,
			0x29, 0x9f, 0xaf, 0x41, 0xf4, 0x20, 0xf9, 0x0b,
			0xd8, 0x70, 0x4f, 0x76, 0xdd, 0x7d, 0x45, 0xfc,
			0xd5, 0xde, 0xa9, 0x43, 0x90, 0x33, 0x24, 0x42,
			0x84, 0x89, 0xe4, 0x31, 0x81, 0x0b, 0x09, 0x1a,
			0x46, 0x40, 0xdb, 0x92, 0xbc, 0xae, 0xed, 0x7f,
			0xea, 0x7a, 0xdf, 0x6f, 0xf3, 0xb4, 0x35, 0xe0,
			0xf3, 0xde, 0xa6, 0xaa, 0xa8, 0x1d, 0x8d, 0x44,
			0x64, 0xa1, 0x67, 0x22, 0xe6, 0x98, 0x49, 0x43,
			0x24, 0xc6, 0x12, 0x41, 0x47, 0xbd, 0x8c, 0x94,
			0xb0, 0xd9, 0x7c, 0x30, 0xc2, 0x2e, 0xd7, 0x5a,
			0xaa, 0x41, 0x87, 0x37, 0xfc, 0xb9, 0x96, 0x3c,
			0xe3, 0xaa, 0x77, 0x79, 0xe6, 0x17, 0xc3, 0xcf,
			0x9f, 0xac, 0xb7, 0x43, 0x6e, 0x04, 0x40, 0xce,
			0x46, 0xd1, 0x07, 0xbf, 0x08, 0x28, 0xc5, 0x7c,
			0xcf, 0x35, 0xe4, 0xac, 0x82, 0xdd, 0xaa, 0xb0,
			0xec, 0xde, 0x37, 0xee, 0x27, 0xde, 0xe1, 0x7b,
			0xdd, 0xab, 0xca, 0x09, 0xbc, 0x06, 0xd7, 0xde,
			0xe8, 0x7d, 0xc5, 0x9b, 0xfc, 0x1a, 0xb9, 0x85,
			0x3d, 0xf6, 0x29, 0x16, 0xe5, 0xeb, 0xd2, 0xe6,
			0xac, 0xd0, 0x87, 0xd2, 0xaf, 0x26, 0xea, 0x3a,
			0x59, 0x6d, 0x91, 0x57, 0x7e, 0x7b, 0xf5, 0xe5,
			0xfc, 0x15, 0x27, 0x84, 0x24, 0x71, 0x9d, 0x23,
			0x11, 0xf5, 0xec, 0x54, 0x0f, 0xf8, 0x2f, 0x79,
		},
		20, /* salt length */
		/* V7 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA224 [8] */
	{
		/* Msg8 : 128 byte */
		{
			0xd5, 0x55, 0xeb, 0x97, 0x3b, 0x82, 0x85, 0xa4,
			0xc0, 0x2f, 0x09, 0xb9, 0xdf, 0xfe, 0x61, 0xa7,
			0x72, 0x6c, 0xe2, 0xff, 0x19, 0xa9, 0xd1, 0x82,
			0xdf, 0xa7, 0x26, 0xd9, 0x1b, 0x70, 0x8f, 0x87,
			0x95, 0xbe, 0xb8, 0x1b, 0xea, 0xc5, 0xca, 0xaa,
			0x32, 0x54, 0x32, 0x7c, 0xdf, 0x1c, 0xa3, 0x06,
			0xe8, 0x4f, 0x5e, 0x18, 0x28, 0x6e, 0xb1, 0x58,
			0x01, 0x5c, 0xbd, 0xef, 0x44, 0xb6, 0x7d, 0x82,
			0x55, 0x67, 0x04, 0x64, 0x8a, 0x76, 0x06, 0x0a,
			0xd5, 0x23, 0x9a, 0xbf, 0xa3, 0x33, 0x3e, 0x98,
			0x03, 0x88, 0x1c, 0xab, 0x0b, 0xf4, 0x8c, 0x7c,
			0x77, 0x4f, 0xd9, 0xb8, 0x94, 0xc7, 0x48, 0x26,
			0x5d, 0x78, 0x56, 0xda, 0xe3, 0x3d, 0x42, 0xac,
			0xf2, 0xc5, 0xcb, 0xe8, 0xf1, 0xe9, 0x3b, 0x47,
			0x0a, 0x3c, 0xa4, 0x1e, 0x8b, 0xe4, 0x6a, 0xd6,
			0x8c, 0xa9, 0x01, 0x9c, 0xd3, 0x4c, 0xf8, 0x59,
		},
		/* S8 : 256 byte */
		{
			0x6e, 0xf7, 0x69, 0x9b, 0xce, 0xc4, 0xe7, 0x1c,
			0x6f, 0x65, 0x2e, 0x64, 0x5e, 0xa8, 0xa6, 0x30,
			0xc5, 0xc6, 0x85, 0xa4, 0x1e, 0xa2, 0x3e, 0x24,
			0x54, 0xf0, 0x0e, 0xaa, 0x0b, 0x0f, 0xac, 0xc4,
			0x21, 0x8c, 0xc1, 0x8b, 0x4a, 0x7b, 0xde, 0x42,
			0x31, 0x9f, 0x5a, 0xc0, 0xdb, 0xb6, 0xdc, 0xe8,
			0x58, 0x20, 0x0e, 0xca, 0x73, 0x9d, 0x46, 0x93,
			0x9c, 0xb6, 0xc4, 0x29, 0x67, 0x6e, 0x6e, 0xb4,
			0xf5, 0x7a, 0x2d, 0xe3, 0x43, 0x87, 0xf7, 0x07,
			0xc0, 0xa9, 0x42, 0xb4, 0xd0, 0xf2, 0x1c, 0x1b,
			0x75, 0x0a, 0x44, 0xb1, 0x1d, 0x78, 0xcc, 0x3a,
			0x4f, 0xea, 0x11, 0x65, 0x98, 0xae, 0x1b, 0xe6,
			0x09, 0x75, 0x0a, 0xa3, 0x00, 0xf7, 0xbd, 0x0e,
			0xf8, 0xe0, 0x6d, 0xb2, 0xa4, 0x60, 0xe6, 0xa6,
			0x99, 0x58, 0xb0, 0x71, 0x1c, 0xba, 0xab, 0x73,
			0x4e, 0x59, 0xb9, 0x70, 0x01, 0x62, 0x85, 0x7a,
			0x7a, 0xdd, 0x41, 0xd8, 0xbd, 0x43, 0x8d, 0x32,
			0xde, 0x49, 0x40, 0xb8, 0x45, 0x93, 0xe9, 0x0b,
			0x7d, 0x34, 0x0c, 0xe3, 0x2b, 0xab, 0xfe, 0x90,
			0x98, 0x67, 0x0e, 0x85, 0xf2, 0xe6, 0x84, 0x8f,
			0x3b, 0x70, 0x74, 0xb0, 0xa8, 0x98, 0x03, 0xa5,
			0xf6, 0x43, 0x93, 0xd1, 0x65, 0xd2, 0x6a, 0xcb,
			0x47, 0x71, 0xd0, 0xf3, 0x02, 0xa4, 0x31, 0x6a,
			0x38, 0xd0, 0x69, 0xa3, 0xbd, 0x52, 0x7f, 0x8e,
			0xa9, 0xec, 0x90, 0x5e, 0x90, 0x47, 0x56, 0x77,
			0x06, 0x4a, 0x3d, 0x3f, 0xdd, 0x8f, 0x02, 0x5d,
			0xcf, 0x6e, 0x10, 0xaa, 0x68, 0x8c, 0x02, 0x81,
			0x4b, 0xbb, 0xde, 0x1d, 0xae, 0x7e, 0xce, 0xe9,
			0x2f, 0x33, 0xdd, 0x88, 0xab, 0xe2, 0x7a, 0x87,
			0xbb, 0xb3, 0xda, 0x68, 0x0f, 0x68, 0xdf, 0x30,
			0x3e, 0xb4, 0x63, 0x3d, 0xaf, 0x0e, 0x7e, 0x2a,
			0x0f, 0x2e, 0xe2, 0xdd, 0x84, 0xb2, 0x20, 0xb1,
		},
		20, /* salt length */
		/* V8 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA224 [9] */
	{
		/* Msg9 : 128 byte */
		{
			0xf3, 0xe0, 0xdb, 0x54, 0x9d, 0xd6, 0x5d, 0xe8,
			0xd5, 0x90, 0x49, 0x10, 0xd4, 0x73, 0x45, 0x71,
			0xf7, 0x73, 0x41, 0xc3, 0x68, 0x29, 0x45, 0x85,
			0xfb, 0x26, 0x6d, 0xef, 0x56, 0x88, 0x32, 0x29,
			0x55, 0xcb, 0xea, 0xba, 0xad, 0xe1, 0x92, 0x43,
			0xcf, 0x84, 0xcc, 0x6d, 0x0f, 0xcb, 0x24, 0x20,
			0x05, 0xfb, 0x97, 0xf6, 0x33, 0xa0, 0x56, 0xef,
			0xe9, 0xdd, 0xc7, 0x66, 0x66, 0x01, 0xcd, 0x43,
			0x40, 0x5a, 0x49, 0x73, 0x06, 0x4e, 0xe1, 0x95,
			0x23, 0xa7, 0x00, 0xf6, 0x05, 0x2f, 0x1d, 0xc0,
			0x7f, 0x7d, 0x41, 0x6e, 0x6c, 0x0e, 0xc3, 0x83,
			0x96, 0x98, 0x56, 0x7c, 0xd6, 0x9a, 0x47, 0x03,
			0x7c, 0x38, 0xff, 0x65, 0xf0, 0x46, 0xcf, 0x46,
			0x9a, 0xa3, 0xed, 0x94, 0x00, 0xc8, 0xb9, 0xb9,
			0x2e, 0xa0, 0x45, 0x15, 0x5b, 0x9b, 0x15, 0xab,
			0xc9, 0xfe, 0x23, 0x1a, 0xed, 0x7d, 0x26, 0xd0,
		},
		/* S9 : 256 byte */
		{
			0x24, 0xf4, 0xc8, 0x1a, 0x63, 0x78, 0xe3, 0x6d,
			0xc5, 0xfe, 0x2a, 0x94, 0x0f, 0x97, 0x5f, 0xb2,
			0x43, 0xce, 0x30, 0x44, 0x11, 0xf9, 0x19, 0xb2,
			0x95, 0xd1, 0x6d, 0x3a, 0x4a, 0x87, 0x02, 0x8d,
			0x2d, 0x98, 0xae, 0x98, 0x9d, 0x47, 0x97, 0x88,
			0x2b, 0x31, 0xd6, 0x06, 0x91, 0x8a, 0x5e, 0x3e,
			0xdd, 0x13, 0x18, 0x4b, 0x83, 0x30, 0x48, 0x2a,
			0x16, 0x62, 0x9b, 0xf3, 0x11, 0x63, 0xef, 0x4f,
			0xdf, 0x12, 0xb0, 0xc0, 0x51, 0xbf, 0x4d, 0x17,
			0x8c, 0x92, 0x25, 0x0d, 0x38, 0x5a, 0xd4, 0x8a,
			0xaa, 0x60, 0xc0, 0xd1, 0xdd, 0x5b, 0x79, 0x92,
			0xe7, 0x5b, 0x4a, 0xc4, 0x18, 0xb2, 0xa7, 0x89,
			0x7e, 0x27, 0x9b, 0x03, 0xa0, 0x20, 0xe1, 0xd2,
			0xdf, 0x8b, 0x1a, 0x53, 0x7c, 0x18, 0x83, 0xd2,
			0x3b, 0xc6, 0x0b, 0xb5, 0xa1, 0x29, 0x0b, 0xab,
			0x2a, 0x72, 0x20, 0x79, 0x68, 0x8a, 0xd7, 0x7e,
			0xb6, 0x4a, 0xc5, 0x14, 0xc3, 0x3c, 0xe2, 0xd6,
			0x58, 0xe8, 0x8b, 0x14, 0xfc, 0xb9, 0x55, 0x81,
			0xd8, 0xd2, 0xf2, 0xe4, 0x0b, 0x2e, 0x68, 0x41,
			0x75, 0xee, 0xdf, 0x59, 0x09, 0x15, 0xcf, 0x6c,
			0x1d, 0x9f, 0xe1, 0x9f, 0x47, 0xbd, 0x8f, 0x97,
			0x20, 0x8c, 0xf9, 0xc4, 0x4d, 0x2b, 0xf6, 0xbe,
			0x3a, 0xd5, 0x65, 0xd2, 0xb7, 0x44, 0x6e, 0x94,
			0x82, 0xdc, 0x9d, 0xcd, 0xa1, 0x1b, 0x14, 0x10,
			0x65, 0x03, 0xc1, 0x7d, 0x55, 0xa4, 0xfa, 0xa7,
			0x27, 0xf7, 0xb6, 0x3b, 0x43, 0x81, 0x5b, 0x96,
			0xcd, 0x28, 0xe9, 0x46, 0xcc, 0xe1, 0x78, 0x26,
			0xf6, 0x2a, 0x6a, 0x5e, 0x70, 0x1e, 0xb9, 0x7b,
			0x24, 0x80, 0x52, 0xe8, 0xc0, 0x8e, 0xf8, 0x18,
			0x57, 0xca, 0xa4, 0x5e, 0xe4, 0x86, 0xc3, 0xf2,
			0xa5, 0x3b, 0xd8, 0xdd, 0x13, 0xc5, 0xff, 0xfd,
			0x62, 0x8e, 0x90, 0x18, 0x16, 0x8f, 0xa8, 0xb2,
		},
		20, /* salt length */
		/* V9 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
};

/* 10 elements */
static mod2048_t SHA256[] = {
	/* SHA256 [0] */
	{
		/* Msg0 : 128 byte */
		{
			0xcd, 0x74, 0xae, 0x61, 0x52, 0xd5, 0xfe, 0x5c,
			0xe3, 0xd9, 0x07, 0x3c, 0x92, 0x1e, 0x86, 0x1a,
			0x24, 0x20, 0x8f, 0x0c, 0x68, 0x47, 0x7f, 0x49,
			0xc8, 0x25, 0x33, 0x8e, 0x1e, 0xf8, 0x77, 0xc0,
			0xc9, 0x77, 0xc1, 0xd2, 0xff, 0xcb, 0x20, 0xe9,
			0x64, 0xdb, 0x6f, 0xbe, 0xdc, 0xcc, 0xce, 0x44,
			0x9e, 0xc8, 0x53, 0x8c, 0x8b, 0xff, 0xfc, 0xe5,
			0xbd, 0xec, 0xe8, 0x47, 0x62, 0xda, 0xc7, 0xf2,
			0xcb, 0xa6, 0x90, 0x52, 0xc0, 0xc6, 0x72, 0x26,
			0x17, 0x8a, 0x0c, 0xe1, 0x85, 0xa2, 0xe0, 0x50,
			0xb3, 0xe1, 0x05, 0x7e, 0x94, 0x41, 0x1d, 0xd5,
			0xf7, 0x26, 0x87, 0x85, 0x58, 0xe7, 0xd6, 0x2a,
			0xfc, 0x8a, 0x81, 0xa9, 0x3d, 0xcf, 0xdb, 0x5a,
			0x22, 0x71, 0x46, 0x6d, 0x32, 0xa8, 0xa4, 0x86,
			0x8a, 0xf2, 0x0f, 0xab, 0x2e, 0x13, 0xca, 0x60,
			0x9d, 0x5a, 0x77, 0x10, 0xa8, 0x27, 0x8a, 0xaf,
		},
		/* S0 : 256 byte */
		{
			0x63, 0x75, 0x75, 0x5e, 0xff, 0x8d, 0x48, 0xaf,
			0xb3, 0x26, 0x3b, 0x3b, 0x96, 0x98, 0x8a, 0x2a,
			0xfd, 0x18, 0x1b, 0xa0, 0x61, 0x79, 0x3e, 0xa0,
			0x09, 0x78, 0x3b, 0xb1, 0x59, 0x9d, 0x03, 0x94,
			0x4d, 0x98, 0x76, 0x20, 0xa2, 0x66, 0x8a, 0xc9,
			0x71, 0x4d, 0x6f, 0x2a, 0x21, 0xf7, 0xe5, 0x20,
			0x0d, 0x63, 0x92, 0x3f, 0x42, 0xcb, 0x32, 0xe6,
			0x33, 0x01, 0xc8, 0xde, 0x58, 0xc7, 0x0a, 0x20,
			0x39, 0x10, 0x64, 0x0d, 0xa9, 0x67, 0xd0, 0x3f,
			0x4f, 0x62, 0x92, 0xf6, 0xcb, 0x19, 0x97, 0x59,
			0x82, 0x27, 0x90, 0xc0, 0xc5, 0xbc, 0xfb, 0x1d,
			0x4f, 0xaa, 0x59, 0x46, 0x5c, 0x3d, 0xb2, 0xea,
			0x1f, 0xff, 0xd5, 0xe5, 0x43, 0x33, 0x56, 0x32,
			0xb7, 0x47, 0x45, 0xbf, 0x1e, 0x18, 0x47, 0x3c,
			0x0a, 0x8b, 0x4a, 0x89, 0xde, 0xf6, 0xb2, 0x7e,
			0xdf, 0x0d, 0x7d, 0x73, 0x5e, 0xe1, 0x3f, 0x88,
			0x70, 0x41, 0xc9, 0xd8, 0xa9, 0x1e, 0x62, 0x18,
			0x6a, 0x9a, 0x1e, 0x0b, 0x1a, 0xfb, 0x48, 0xe5,
			0x77, 0xf6, 0x88, 0x7c, 0xa6, 0x1b, 0x7c, 0x1b,
			0xb2, 0x6b, 0x4a, 0x8e, 0x2c, 0xc4, 0x64, 0xa9,
			0xaf, 0x03, 0x44, 0x4b, 0x3d, 0xa5, 0xbe, 0xd0,
			0x8b, 0x73, 0xf1, 0x26, 0x2b, 0xd3, 0xd6, 0x1f,
			0x4c, 0x78, 0xf4, 0x9f, 0xac, 0x6a, 0x3b, 0xfc,
			0x9e, 0x85, 0x48, 0xb4, 0xbb, 0xe6, 0x4c, 0xce,
			0x6a, 0x60, 0x90, 0xfc, 0x48, 0x0e, 0xfd, 0x1f,
			0x36, 0xc1, 0x8c, 0x10, 0xbc, 0x09, 0xbe, 0x9d,
			0x95, 0x7a, 0x79, 0xf7, 0x07, 0xa1, 0x05, 0x77,
			0xa1, 0xbf, 0x6e, 0x9e, 0x2d, 0x48, 0x49, 0x69,
			0x3f, 0xa5, 0x8d, 0x88, 0x77, 0xc8, 0xf1, 0xe5,
			0x51, 0x81, 0x95, 0x5d, 0x6c, 0x2b, 0x94, 0xb1,
			0xd6, 0xd9, 0x40, 0x1b, 0x5f, 0xb8, 0x0c, 0xc3,
			0x2b, 0x35, 0x89, 0x34, 0xfe, 0xc2, 0xae, 0xdb,
		},
		20, /* salt length */
		/* V0 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA256 [1] */
	{
		/* Msg1 : 128 byte */
		{
			0xd7, 0x95, 0x64, 0x4e, 0x3b, 0x63, 0x51, 0xc6,
			0x56, 0xcd, 0x25, 0x53, 0xd6, 0x18, 0x25, 0xf5,
			0x4d, 0xdf, 0x8b, 0xce, 0xe1, 0xfe, 0xd8, 0x2a,
			0x46, 0xaf, 0x6b, 0xbc, 0xe9, 0xf3, 0x53, 0x2a,
			0x6e, 0x34, 0x62, 0xcd, 0x5d, 0x28, 0x82, 0xb2,
			0x18, 0xf8, 0x4c, 0xe4, 0x11, 0xa2, 0xd7, 0xed,
			0x39, 0x9c, 0xce, 0x9a, 0xbc, 0xba, 0xc6, 0xff,
			0xeb, 0x51, 0xce, 0xbb, 0x79, 0x9d, 0x47, 0x7d,
			0xeb, 0x60, 0xf6, 0xc7, 0x4a, 0xcc, 0x57, 0xf2,
			0x1b, 0xa3, 0x34, 0x73, 0x91, 0x9d, 0x77, 0x5c,
			0x00, 0x0a, 0x3d, 0x26, 0x95, 0xb8, 0x2b, 0xad,
			0x45, 0x17, 0x05, 0x7c, 0x03, 0x9b, 0x7c, 0x4b,
			0x36, 0x62, 0x48, 0xc6, 0x6a, 0x17, 0x77, 0x90,
			0x45, 0x16, 0x05, 0x88, 0xbd, 0xd0, 0xac, 0x4b,
			0x89, 0x71, 0xfd, 0xfa, 0xd5, 0xc1, 0xb0, 0x3d,
			0x3a, 0x48, 0x39, 0x87, 0xed, 0xb6, 0x9c, 0x9c,
		},
		/* S1 : 256 byte */
		{
			0x49, 0x2d, 0xfc, 0x5e, 0xb5, 0x34, 0x33, 0x5a,
			0x9d, 0x73, 0xef, 0xd9, 0xaa, 0x80, 0xa9, 0x24,
			0x3a, 0xfa, 0xfb, 0x5c, 0x11, 0x0c, 0x24, 0x36,
			0x36, 0xd2, 0x21, 0xdc, 0xcd, 0xe0, 0x96, 0xda,
			0xb6, 0x77, 0x55, 0x65, 0x66, 0x7b, 0x9d, 0x36,
			0xb0, 0xa3, 0x9f, 0x16, 0x9c, 0xa7, 0x31, 0x5d,
			0xe3, 0xbf, 0x98, 0xcb, 0x73, 0x5e, 0x3d, 0xba,
			0x43, 0x81, 0x3e, 0x5a, 0xf2, 0x6d, 0xb8, 0x90,
			0x4a, 0x9d, 0xf8, 0x01, 0xe1, 0x38, 0xea, 0x17,
			0xf8, 0x0e, 0x92, 0x21, 0xbe, 0xd1, 0x9d, 0xcd,
			0xdc, 0x96, 0x39, 0xc6, 0x8e, 0xcb, 0x60, 0x6b,
			0xd2, 0xb2, 0x1f, 0x2d, 0x40, 0xf7, 0x2a, 0x4d,
			0xf3, 0x6c, 0x2a, 0x15, 0x61, 0xc5, 0xec, 0xb7,
			0xe3, 0xea, 0x27, 0x8c, 0x0d, 0x1c, 0xd7, 0xcd,
			0x12, 0x74, 0x27, 0x0e, 0xe7, 0x29, 0xb6, 0x64,
			0xeb, 0xbb, 0x4a, 0xd5, 0x10, 0x3b, 0xae, 0x4a,
			0xd0, 0x03, 0xbb, 0x7f, 0xb0, 0xff, 0x22, 0xce,
			0x80, 0x12, 0x0d, 0xd8, 0xfc, 0xd2, 0x84, 0x63,
			0x61, 0x69, 0x6e, 0x5f, 0xd9, 0xee, 0x92, 0x83,
			0x56, 0x54, 0xc6, 0xcc, 0x13, 0x0e, 0x7b, 0x94,
			0x76, 0x03, 0x3b, 0x8a, 0x83, 0x12, 0x5e, 0x81,
			0x98, 0xfd, 0x9d, 0x61, 0x78, 0x21, 0xbf, 0x5c,
			0x21, 0xba, 0xbc, 0x25, 0x2a, 0x15, 0x04, 0x60,
			0x73, 0x20, 0x5a, 0xa5, 0x29, 0x1e, 0x04, 0x29,
			0x8e, 0x68, 0x2f, 0x7c, 0xe9, 0x53, 0x37, 0xe3,
			0x30, 0x07, 0xb5, 0xaa, 0x46, 0x97, 0xb8, 0xa3,
			0xba, 0xe9, 0x37, 0xe1, 0xb3, 0xbc, 0x47, 0x3f,
			0xa7, 0x13, 0xcc, 0xad, 0x1d, 0x0e, 0x90, 0xc4,
			0x77, 0xe0, 0x23, 0x23, 0xa6, 0x28, 0xe1, 0x1c,
			0xe8, 0x4d, 0x8c, 0x70, 0x4e, 0xe6, 0x44, 0x65,
			0x1c, 0x66, 0x83, 0xcc, 0xd3, 0x2e, 0x2b, 0xf3,
			0x7f, 0x1e, 0x5c, 0xb8, 0x97, 0x25, 0x32, 0x14,
		},
		20, /* salt length */
		/* V1 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA256 [2] */
	{
		/* Msg2 : 128 byte */
		{
			0x5c, 0x39, 0xa3, 0xd2, 0xac, 0xde, 0x3a, 0xc1,
			0x08, 0x8f, 0x17, 0x95, 0x8b, 0x4a, 0x53, 0xd4,
			0x30, 0x72, 0xd7, 0x96, 0x43, 0x73, 0x6f, 0x44,
			0x15, 0xa4, 0x21, 0xa0, 0xf4, 0x71, 0xbc, 0x05,
			0x5a, 0xb9, 0xb3, 0xf0, 0x65, 0x75, 0x2c, 0xc0,
			0x87, 0x9b, 0x55, 0xba, 0x7f, 0x42, 0xf7, 0x50,
			0x88, 0x06, 0x4d, 0xa3, 0xd0, 0xae, 0x16, 0x46,
			0x2b, 0x0c, 0xe9, 0x45, 0x09, 0x25, 0xc9, 0x66,
			0xa6, 0x92, 0xf9, 0xae, 0x80, 0x26, 0x11, 0x27,
			0x0e, 0xd1, 0x52, 0xe1, 0xaf, 0xc4, 0x37, 0x37,
			0xe1, 0xd6, 0x4c, 0x53, 0xb3, 0x27, 0x43, 0xf5,
			0x7d, 0x03, 0x45, 0x6f, 0xce, 0x09, 0x86, 0xf5,
			0xa6, 0x8c, 0x1c, 0x13, 0xe5, 0x39, 0x11, 0x7f,
			0x04, 0xfa, 0xb7, 0x11, 0x03, 0x1b, 0x3b, 0x10,
			0xa2, 0xac, 0x7d, 0xaf, 0xd4, 0x26, 0x1f, 0xd7,
			0x71, 0x51, 0xdd, 0x27, 0x2b, 0x64, 0x1c, 0x3a,
		},
		/* S2 : 256 byte */
		{
			0x1a, 0xe0, 0x07, 0x36, 0x92, 0x4c, 0x34, 0xad,
			0x08, 0x8b, 0xe6, 0x82, 0x76, 0xec, 0x7f, 0xb5,
			0x58, 0xb0, 0xb5, 0x1d, 0x0c, 0x3d, 0xfc, 0xd1,
			0xf4, 0x59, 0x17, 0xac, 0x99, 0x8a, 0x30, 0x29,
			0x0c, 0x7a, 0x3e, 0x51, 0xf3, 0x6a, 0x67, 0xfa,
			0x89, 0xd9, 0x3a, 0xf8, 0x75, 0x18, 0x1d, 0x2b,
			0xa3, 0xd2, 0xbd, 0x90, 0x6b, 0x5d, 0xc6, 0xf3,
			0x75, 0xa2, 0xb3, 0xeb, 0x56, 0x98, 0x75, 0xce,
			0x34, 0x92, 0xf8, 0x1a, 0x39, 0x76, 0x22, 0xcb,
			0x16, 0xee, 0x76, 0x3d, 0xf9, 0xb8, 0x1d, 0x43,
			0x67, 0x95, 0x18, 0x0d, 0xab, 0xd0, 0x3d, 0x50,
			0x6c, 0xa4, 0x64, 0x79, 0x8a, 0x10, 0xb0, 0x70,
			0x4e, 0x01, 0x6c, 0x1b, 0x5e, 0xe3, 0xfd, 0x0b,
			0x6f, 0x46, 0x3f, 0xfe, 0x75, 0x55, 0x3b, 0x83,
			0x9e, 0x86, 0x9b, 0x34, 0x92, 0xed, 0xf6, 0x89,
			0x7c, 0x76, 0x14, 0xeb, 0x31, 0x0f, 0xc4, 0xde,
			0xf3, 0x10, 0x77, 0x16, 0xed, 0x0b, 0xcf, 0xaf,
			0x66, 0x96, 0xbb, 0x6e, 0xcc, 0x3e, 0x02, 0x2d,
			0x41, 0x98, 0x61, 0xdc, 0x1b, 0xed, 0xd1, 0x42,
			0x87, 0x61, 0x3a, 0xfc, 0x72, 0xb5, 0x55, 0x0b,
			0x04, 0x7f, 0x64, 0xf2, 0xa3, 0x5e, 0xdb, 0x24,
			0xda, 0xf8, 0x28, 0x8b, 0x7c, 0x30, 0x6f, 0x0d,
			0x38, 0xea, 0xbe, 0xfc, 0xf1, 0xd6, 0xcb, 0x03,
			0xf6, 0x63, 0x8a, 0xda, 0xe6, 0x8c, 0x23, 0x1d,
			0x1c, 0x8c, 0xf7, 0xf0, 0xcb, 0x9f, 0xcf, 0x96,
			0x7e, 0x7d, 0x79, 0xc6, 0xd8, 0x2c, 0x49, 0x99,
			0x81, 0xe2, 0xa0, 0xdc, 0xad, 0xb2, 0x12, 0x0b,
			0x67, 0x3a, 0xb9, 0xae, 0xde, 0xec, 0xc1, 0x3a,
			0xc2, 0xcf, 0x9c, 0xbd, 0x5c, 0x10, 0x69, 0xdf,
			0xc2, 0x00, 0x8a, 0xbf, 0x23, 0x21, 0x4b, 0xea,
			0x08, 0x50, 0x04, 0xd6, 0x48, 0xe4, 0xe6, 0xe5,
			0x84, 0x40, 0x1d, 0x33, 0x3d, 0x6e, 0xfb, 0x2e,
		},
		20, /* salt length */
		/* V2 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA256 [3] */
	{
		/* Msg3 : 128 byte */
		{
			0x76, 0xdc, 0x26, 0x43, 0xac, 0x24, 0xd5, 0xe5,
			0xf7, 0xec, 0xc0, 0x9f, 0xa3, 0xa4, 0xa7, 0xfa,
			0x9c, 0xd5, 0x01, 0x67, 0x25, 0x05, 0x4b, 0x3c,
			0xcd, 0xdb, 0xa0, 0xfa, 0x9f, 0x83, 0x8a, 0xd1,
			0x9a, 0x54, 0x18, 0x66, 0x61, 0xb0, 0x30, 0xd3,
			0x33, 0x2c, 0x27, 0xef, 0x1c, 0xf1, 0x8f, 0xd1,
			0x6d, 0x63, 0x50, 0x8f, 0x6b, 0x00, 0xfb, 0x4b,
			0x44, 0x8a, 0x5a, 0x71, 0x47, 0x68, 0x4c, 0x3a,
			0x53, 0x4a, 0xcf, 0x75, 0x90, 0x0c, 0x5f, 0x86,
			0x5e, 0xdd, 0x7f, 0xaf, 0x8b, 0xa0, 0x95, 0x8e,
			0xc9, 0x92, 0xfa, 0xe7, 0x5f, 0x2d, 0x52, 0xa4,
			0x1e, 0x4d, 0x19, 0x1a, 0x97, 0x92, 0x7f, 0x8e,
			0x8b, 0x05, 0x76, 0xf8, 0xa3, 0xfe, 0x09, 0x06,
			0x61, 0x45, 0xef, 0x64, 0x57, 0x77, 0x60, 0x3b,
			0x97, 0xab, 0x27, 0xf8, 0x6a, 0x56, 0xf9, 0x4e,
			0x45, 0x6c, 0x05, 0x7e, 0xf8, 0xc8, 0xcc, 0xd6,
		},
		/* S3 : 256 byte */
		{
			0x94, 0x8d, 0xac, 0x52, 0x68, 0x8d, 0x4c, 0xfa,
			0x3f, 0xbe, 0x16, 0x10, 0x9f, 0x5a, 0x79, 0x36,
			0xfa, 0x67, 0x53, 0x02, 0xf4, 0xa6, 0xa2, 0x8e,
			0x0c, 0x83, 0xed, 0x7b, 0xd1, 0x56, 0x15, 0x4f,
			0x4b, 0x5d, 0x2a, 0xde, 0xe5, 0xc3, 0x96, 0xde,
			0xbf, 0x1a, 0x3e, 0x11, 0x6d, 0x42, 0xf9, 0x26,
			0xf0, 0x11, 0x51, 0x93, 0x88, 0xe0, 0xeb, 0x24,
			0xaa, 0x2d, 0x2b, 0x5a, 0x49, 0x83, 0x2d, 0x3a,
			0x4e, 0x64, 0x24, 0x8a, 0x31, 0x1c, 0x60, 0x46,
			0x37, 0x85, 0x47, 0xaa, 0xd2, 0x71, 0x08, 0x74,
			0x2c, 0x44, 0xdd, 0x2a, 0x29, 0x73, 0x3a, 0xbe,
			0x8c, 0x5c, 0x1c, 0x97, 0x4a, 0x23, 0xec, 0xed,
			0xda, 0xd7, 0x94, 0x3d, 0xbf, 0xb0, 0xb3, 0xf0,
			0x76, 0xac, 0xb7, 0x3a, 0x3d, 0x2d, 0x8e, 0x76,
			0x2f, 0x48, 0xa3, 0x65, 0xd7, 0x33, 0x62, 0xf3,
			0xea, 0x73, 0xce, 0x12, 0x02, 0x2b, 0xc2, 0x55,
			0xd8, 0x25, 0xe6, 0xf2, 0xae, 0x02, 0xd5, 0xca,
			0xcb, 0x7f, 0xb0, 0x28, 0x39, 0x2f, 0x4e, 0x90,
			0x72, 0x9a, 0x15, 0x8c, 0x4c, 0x2c, 0xb8, 0x7e,
			0xeb, 0xca, 0x4e, 0xef, 0x06, 0x81, 0x57, 0x86,
			0x98, 0x3f, 0x13, 0x80, 0x03, 0xb4, 0x5e, 0x44,
			0x89, 0x4f, 0x5c, 0xdd, 0x74, 0x93, 0x8e, 0x58,
			0x3a, 0x4c, 0xc4, 0xb5, 0xac, 0xd1, 0x52, 0xa2,
			0xc7, 0xbd, 0x83, 0x82, 0x9b, 0x81, 0xcd, 0xb1,
			0x10, 0xd9, 0x9b, 0x90, 0xeb, 0xd8, 0x05, 0xe4,
			0x5e, 0xbe, 0xbd, 0xab, 0xcd, 0x38, 0xb1, 0x9f,
			0x37, 0x7d, 0xbd, 0x68, 0xa6, 0xab, 0xba, 0xb1,
			0x6a, 0xad, 0x0a, 0xfd, 0x88, 0x0d, 0xbe, 0x15,
			0xfe, 0xa0, 0x23, 0xf9, 0x76, 0xff, 0x19, 0x5f,
			0x6f, 0xfa, 0xc7, 0xf5, 0xd7, 0x14, 0xc4, 0x26,
			0x54, 0x7a, 0xe3, 0x6d, 0x4e, 0xfc, 0x92, 0xd7,
			0x84, 0xc0, 0x78, 0x40, 0x2b, 0x62, 0x0c, 0xc5,
		},
		20, /* salt length */
		/* V3 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA256 [4] */
	{
		/* Msg4 : 128 byte */
		{
			0xc1, 0xba, 0x73, 0x51, 0xca, 0x93, 0x4e, 0xce,
			0x6a, 0xae, 0x48, 0x3e, 0x3d, 0x0b, 0xef, 0x48,
			0x60, 0x1f, 0x78, 0x9e, 0xcc, 0xd5, 0xb1, 0x25,
			0xe2, 0xd3, 0x37, 0x56, 0x46, 0xfe, 0xe9, 0xe4,
			0xf1, 0x40, 0x9c, 0x9e, 0x82, 0x89, 0x11, 0x98,
			0xd5, 0x13, 0x24, 0x85, 0xd7, 0xeb, 0x45, 0x68,
			0x99, 0xad, 0x2c, 0x6c, 0xa3, 0x8e, 0xc9, 0x0f,
			0x8a, 0xa0, 0x7a, 0x86, 0xc5, 0x52, 0x81, 0x5d,
			0xbc, 0x36, 0xb5, 0x5f, 0x22, 0x08, 0x77, 0xb5,
			0x85, 0xeb, 0xe8, 0x52, 0x23, 0xf5, 0x5a, 0x8e,
			0x00, 0xee, 0x04, 0x10, 0x35, 0x55, 0xf9, 0xf2,
			0x8b, 0xa4, 0x5b, 0x20, 0x48, 0xd6, 0xcb, 0x01,
			0x49, 0x25, 0x25, 0x5a, 0x51, 0x18, 0x6a, 0x6f,
			0xa1, 0xbd, 0xfe, 0x6b, 0xc9, 0x33, 0x14, 0x01,
			0xbd, 0x6c, 0x66, 0x54, 0x2b, 0x31, 0x29, 0x14,
			0x0c, 0x67, 0x40, 0xea, 0x7a, 0x90, 0xb0, 0x17,
		},
		/* S4 : 256 byte */
		{
			0xd4, 0x6a, 0x08, 0x77, 0x81, 0xb8, 0xd8, 0xfe,
			0x77, 0x4b, 0x49, 0x4d, 0x0e, 0xd3, 0xfa, 0x9c,
			0x12, 0x14, 0xf3, 0xb9, 0x9d, 0x03, 0xcc, 0xb4,
			0x67, 0x0d, 0xd6, 0x4e, 0x1f, 0x62, 0xf7, 0xcb,
			0x69, 0xbc, 0x63, 0x12, 0x92, 0x61, 0x2e, 0xbc,
			0x54, 0xd8, 0xb4, 0x9a, 0xc4, 0xa1, 0x92, 0x63,
			0x20, 0xa2, 0x26, 0x46, 0xeb, 0x41, 0x4e, 0xbb,
			0x35, 0xc7, 0x73, 0x0d, 0x06, 0xa7, 0x17, 0xf4,
			0x55, 0x6a, 0x8b, 0x81, 0x59, 0x46, 0xd7, 0xcb,
			0x31, 0x17, 0x6a, 0x0c, 0xd1, 0x8c, 0x54, 0xda,
			0xef, 0xc4, 0x6c, 0xe1, 0x6f, 0x35, 0x8a, 0x86,
			0xf6, 0xfe, 0x16, 0x9c, 0x18, 0x9f, 0x02, 0xfd,
			0x60, 0x60, 0xa5, 0x22, 0x0b, 0xf9, 0xc0, 0xb4,
			0x0a, 0xee, 0xa1, 0x2b, 0xbd, 0x49, 0xca, 0xe1,
			0xc2, 0xfa, 0x27, 0x02, 0x9a, 0xac, 0xe6, 0x05,
			0xeb, 0xf1, 0x89, 0xe1, 0x98, 0x9b, 0x90, 0x3b,
			0x96, 0x74, 0x92, 0x8a, 0xb8, 0x6e, 0x0f, 0x09,
			0xe5, 0x0f, 0xc5, 0x2e, 0xa5, 0x20, 0x95, 0x3a,
			0x4a, 0x47, 0x95, 0xd3, 0xc4, 0x70, 0xbe, 0x30,
			0x90, 0x84, 0xa0, 0x46, 0xa8, 0x4a, 0x68, 0xc9,
			0xd3, 0xaa, 0x77, 0x6d, 0xec, 0x26, 0x3f, 0xff,
			0x92, 0x08, 0x46, 0x33, 0x01, 0x21, 0xf3, 0xac,
			0x66, 0xd9, 0xa7, 0x18, 0xdc, 0xe1, 0x82, 0xbc,
			0x41, 0x4a, 0x10, 0xdd, 0xe2, 0x7e, 0xd3, 0x3b,
			0xac, 0x20, 0x2d, 0x69, 0xd4, 0x9d, 0xb0, 0x0c,
			0x73, 0x3f, 0x55, 0xde, 0x3d, 0x13, 0xe0, 0x72,
			0x8e, 0xe2, 0xdf, 0x94, 0x8d, 0xb1, 0x7a, 0x2d,
			0xfd, 0x33, 0xbb, 0x8d, 0x53, 0xba, 0xe4, 0xcb,
			0x78, 0x4d, 0xa6, 0xb5, 0xa7, 0xa8, 0xd8, 0xb9,
			0x8d, 0x5b, 0xd1, 0x53, 0xd7, 0x6b, 0xf4, 0xf5,
			0x56, 0x3e, 0x31, 0x58, 0xb3, 0x41, 0xae, 0x05,
			0x6d, 0xdb, 0x9f, 0x3f, 0x5e, 0xd0, 0x1a, 0x75,
		},
		20, /* salt length */
		/* V4 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA256 [5] */
	{
		/* Msg5 : 128 byte */
		{
			0x25, 0xe3, 0x74, 0x51, 0x3c, 0x67, 0xcc, 0xdf,
			0x16, 0x8c, 0x87, 0x72, 0x4f, 0x4d, 0x42, 0x87,
			0x7f, 0xb2, 0x76, 0x00, 0x0e, 0x51, 0xf0, 0xca,
			0x4a, 0x15, 0x82, 0xbd, 0xb6, 0x3e, 0xf9, 0xc3,
			0xa5, 0xa9, 0x4e, 0x3d, 0x08, 0x52, 0x21, 0xa2,
			0x85, 0x17, 0x62, 0x69, 0xc9, 0xbf, 0x52, 0x2a,
			0x1e, 0x3a, 0xaa, 0x00, 0x40, 0x2a, 0x19, 0x31,
			0x6c, 0xa3, 0xf4, 0x11, 0xbb, 0x2f, 0x2a, 0x23,
			0xae, 0x16, 0x76, 0x82, 0x0a, 0xdc, 0xd8, 0x7f,
			0xe6, 0x0a, 0x45, 0x8c, 0x02, 0x32, 0x9e, 0x59,
			0x5a, 0x2d, 0xdf, 0x3c, 0xfb, 0xa7, 0x99, 0xd6,
			0x16, 0xde, 0xa2, 0xf4, 0x53, 0xa6, 0x0a, 0xb3,
			0x67, 0xb1, 0x52, 0xe8, 0xe9, 0x0d, 0xd9, 0xbe,
			0x61, 0xee, 0x97, 0xa1, 0xa3, 0xae, 0x0d, 0x5b,
			0x5b, 0x12, 0x7c, 0x7d, 0xe8, 0xcf, 0x56, 0x01,
			0x6e, 0x4c, 0xf2, 0x2d, 0x26, 0xaa, 0x83, 0xbb,
		},
		/* S5 : 256 byte */
		{
			0xd8, 0xb6, 0xb2, 0x50, 0x2d, 0xea, 0x02, 0xc1,
			0x15, 0xcf, 0x2f, 0xdb, 0x4c, 0x66, 0x68, 0xcc,
			0xd7, 0x55, 0x93, 0x59, 0x35, 0xb6, 0x1e, 0x50,
			0xa0, 0xe3, 0x06, 0x6e, 0x37, 0x01, 0x41, 0x52,
			0x06, 0x2c, 0x2a, 0x2a, 0xfe, 0xb4, 0xbf, 0x9a,
			0x57, 0xd9, 0xff, 0x68, 0x38, 0x43, 0x6d, 0x36,
			0x0b, 0xce, 0x75, 0x78, 0x7a, 0x0d, 0x35, 0x75,
			0x18, 0xf3, 0xa6, 0x2e, 0xb3, 0x30, 0x0f, 0x73,
			0x38, 0xc4, 0x72, 0xea, 0xa6, 0xd2, 0x31, 0x47,
			0x65, 0xba, 0x3a, 0x78, 0x95, 0x6c, 0xcb, 0x8c,
			0x29, 0xb4, 0xf4, 0xc7, 0x53, 0xb8, 0x26, 0x18,
			0x01, 0x5c, 0x77, 0xb4, 0xd4, 0x38, 0xdb, 0x3c,
			0x54, 0x8a, 0x51, 0x7d, 0xb2, 0x14, 0x68, 0x32,
			0xcb, 0x51, 0x1e, 0xdd, 0xc4, 0xb5, 0x1c, 0x9a,
			0x33, 0x1b, 0x3c, 0xd1, 0x79, 0x47, 0x81, 0xb4,
			0x30, 0xf8, 0x43, 0xae, 0xa5, 0x10, 0x68, 0x9b,
			0xb9, 0x40, 0x21, 0xd1, 0x8b, 0x82, 0x21, 0xd8,
			0x3f, 0x09, 0x66, 0xb8, 0xe4, 0x14, 0x56, 0xcd,
			0xa2, 0xa6, 0x6c, 0x8b, 0xf5, 0x33, 0x59, 0xbc,
			0xab, 0xd7, 0x7d, 0x3e, 0xe8, 0x48, 0xd4, 0xe4,
			0x73, 0xab, 0x2b, 0x82, 0xa8, 0x91, 0x53, 0x3d,
			0x78, 0x8c, 0xce, 0xeb, 0x0a, 0x44, 0xb7, 0x9c,
			0x72, 0x7a, 0xa4, 0x19, 0x28, 0x71, 0x56, 0xdd,
			0xc2, 0x9b, 0xd0, 0x54, 0x36, 0x8e, 0xf0, 0x3f,
			0xb6, 0xa5, 0xaf, 0xb0, 0x8e, 0xd8, 0xeb, 0x52,
			0x51, 0x30, 0x61, 0xd9, 0x8a, 0xfc, 0x57, 0xcb,
			0xd1, 0x18, 0xe0, 0x00, 0xf1, 0xa1, 0x14, 0x2e,
			0xc3, 0xb3, 0x50, 0x63, 0xed, 0x50, 0x4a, 0x0a,
			0x7d, 0xb2, 0x1e, 0xd6, 0x39, 0xbe, 0x3b, 0xde,
			0x45, 0xf8, 0x59, 0xae, 0x03, 0x27, 0x18, 0x78,
			0xe7, 0xaa, 0x12, 0x8a, 0x52, 0x09, 0xe9, 0xbd,
			0x67, 0x1b, 0x98, 0x99, 0x5a, 0x50, 0xe4, 0x08,
		},
		20, /* salt length */
		/* V5 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA256 [6] */
	{
		/* Msg6 : 128 byte */
		{
			0x53, 0x52, 0xc6, 0x06, 0xa0, 0x30, 0x15, 0x9b,
			0x9d, 0x4a, 0xd7, 0x66, 0x41, 0x88, 0xe0, 0x41,
			0x17, 0x18, 0x38, 0x5d, 0x93, 0x6f, 0x13, 0x71,
			0xa6, 0x8a, 0x03, 0x17, 0x90, 0x7a, 0x6d, 0x72,
			0xf6, 0x1f, 0x3a, 0x15, 0x34, 0x34, 0xce, 0x20,
			0xf4, 0x8b, 0x3e, 0xac, 0x00, 0x9a, 0xbd, 0x6a,
			0x54, 0x37, 0x58, 0x86, 0x78, 0xa0, 0xe4, 0xd2,
			0x0c, 0xbe, 0x34, 0x20, 0xa4, 0xab, 0x8f, 0xef,
			0xd7, 0x71, 0x60, 0x4b, 0x93, 0x15, 0x30, 0xee,
			0xb3, 0xd4, 0xd2, 0xab, 0xd4, 0xac, 0xdd, 0x0d,
			0x64, 0x1e, 0x60, 0x3b, 0xfb, 0x33, 0xd0, 0x1e,
			0xef, 0xbd, 0x45, 0xc6, 0x23, 0xdf, 0xe6, 0x0a,
			0x1f, 0xcf, 0xa2, 0x6f, 0x66, 0xdb, 0x22, 0x4c,
			0x03, 0xaa, 0xfb, 0x2b, 0x66, 0xc5, 0x27, 0x71,
			0x6e, 0x55, 0xb6, 0x42, 0xc7, 0x2f, 0xc1, 0x9f,
			0x76, 0x0d, 0xa0, 0xd1, 0xb2, 0x1e, 0x5c, 0x0b,
		},
		/* S6 : 256 byte */
		{
			0x0d, 0x9b, 0x27, 0xce, 0x9e, 0x1c, 0xdc, 0xff,
			0x6e, 0x44, 0xdf, 0x37, 0x75, 0x18, 0x45, 0xe4,
			0x84, 0x0b, 0x63, 0x04, 0xf8, 0x9d, 0xc3, 0x6e,
			0x76, 0x73, 0xfa, 0x15, 0x81, 0x46, 0xfa, 0xfa,
			0x7b, 0x56, 0x32, 0xb4, 0x46, 0x8d, 0x60, 0xe6,
			0x40, 0x0d, 0x15, 0x11, 0xb3, 0x9b, 0x4d, 0xf0,
			0xe1, 0xf5, 0x88, 0xd0, 0x9c, 0x55, 0xd2, 0xd7,
			0xe1, 0x03, 0x8f, 0xb3, 0x1b, 0xe0, 0xa0, 0x0f,
			0x41, 0xa7, 0x36, 0x1b, 0x39, 0xdf, 0x92, 0xc0,
			0xa2, 0x3d, 0xa7, 0x86, 0x9f, 0x99, 0x2d, 0x1b,
			0x54, 0xc1, 0xc3, 0xc7, 0x24, 0xb4, 0x4f, 0xec,
			0x10, 0x82, 0x05, 0xa7, 0x8c, 0x3f, 0x41, 0xa8,
			0xd3, 0x50, 0xd1, 0x31, 0xbd, 0xa1, 0xb8, 0xbe,
			0xcf, 0x27, 0x55, 0xcd, 0xb2, 0x69, 0x99, 0x41,
			0x32, 0x2b, 0x5d, 0x53, 0xd8, 0x78, 0xca, 0x02,
			0xc6, 0x67, 0x5a, 0xe1, 0x5c, 0x34, 0xc1, 0x4d,
			0xfb, 0xc5, 0x97, 0x0f, 0xc2, 0x16, 0x19, 0x24,
			0x69, 0x4c, 0xf5, 0xbc, 0x43, 0xef, 0xa2, 0x26,
			0x3f, 0x66, 0x3f, 0x58, 0x20, 0x3f, 0xfd, 0x5f,
			0x0f, 0x0e, 0x19, 0x5d, 0xef, 0xe0, 0x5e, 0x20,
			0x32, 0xdd, 0x2f, 0x2f, 0xd4, 0xec, 0x6a, 0xdd,
			0xe3, 0x08, 0xd3, 0xae, 0x62, 0x18, 0x04, 0x32,
			0x8c, 0x6a, 0x24, 0x3f, 0x56, 0x76, 0xd4, 0xfa,
			0xbe, 0x00, 0xa6, 0x74, 0x14, 0x90, 0x10, 0x28,
			0xce, 0xbf, 0xad, 0xdc, 0xdd, 0xd6, 0x3a, 0x60,
			0xd4, 0x5f, 0xe6, 0x28, 0x8c, 0x92, 0x26, 0x28,
			0x96, 0x79, 0xc9, 0x6f, 0x4d, 0x74, 0x90, 0x56,
			0x04, 0xc8, 0x7f, 0xf3, 0x9a, 0xd5, 0x10, 0xf1,
			0xbc, 0xc0, 0xae, 0x0b, 0x5c, 0x2e, 0x42, 0xea,
			0xe3, 0xe4, 0x48, 0x87, 0xac, 0x84, 0x27, 0x35,
			0x94, 0x97, 0xd2, 0x1f, 0x72, 0x8b, 0x25, 0x2f,
			0x05, 0xfe, 0x5c, 0x75, 0x58, 0x9d, 0x72, 0xc6,
		},
		20, /* salt length */
		/* V6 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA256 [7] */
	{
		/* Msg7 : 128 byte */
		{
			0x49, 0xbe, 0x01, 0x7d, 0xac, 0xe9, 0xc5, 0xa6,
			0x14, 0x4a, 0x19, 0x8d, 0xfa, 0x07, 0xd5, 0xb7,
			0xa0, 0xe9, 0xf8, 0x39, 0x99, 0xc5, 0x4b, 0xca,
			0x8b, 0x3b, 0x41, 0x1c, 0x34, 0xa3, 0x22, 0x6d,
			0xab, 0x45, 0x68, 0x59, 0xe8, 0xc8, 0x6a, 0xf2,
			0x87, 0xee, 0x37, 0x12, 0xc9, 0x7e, 0xc5, 0xf0,
			0xdc, 0x81, 0x4b, 0xf2, 0x5c, 0xb0, 0xeb, 0xc2,
			0x19, 0x2e, 0x94, 0xa4, 0x1b, 0x73, 0x27, 0x07,
			0xe3, 0x88, 0xd8, 0x59, 0xf4, 0x7a, 0xd8, 0x20,
			0x92, 0x09, 0x31, 0x47, 0xca, 0xa0, 0xf1, 0xb5,
			0xb2, 0x8a, 0x8a, 0x25, 0xf2, 0x62, 0x79, 0x31,
			0x83, 0xcb, 0x26, 0xaf, 0xb7, 0x62, 0x0b, 0x41,
			0x7a, 0xf1, 0x19, 0x28, 0xd7, 0xe6, 0x57, 0x59,
			0xbe, 0x03, 0xcd, 0xd3, 0x04, 0x56, 0xa0, 0x2f,
			0xab, 0x6c, 0x7e, 0x79, 0x64, 0xc2, 0x3c, 0x3e,
			0x52, 0x7c, 0xbe, 0xe6, 0x11, 0x59, 0x18, 0x44,
		},
		/* S7 : 256 byte */
		{
			0x29, 0x5b, 0x17, 0xc6, 0x27, 0xb5, 0xac, 0x8a,
			0x86, 0x03, 0x0e, 0x75, 0xd4, 0x0c, 0x9f, 0x1f,
			0x52, 0xcf, 0x5a, 0xbe, 0x81, 0x8c, 0x85, 0x7f,
			0x31, 0x4e, 0x6f, 0x8b, 0xa8, 0x75, 0x3c, 0x29,
			0x54, 0xea, 0x73, 0xe2, 0xbd, 0x0f, 0x01, 0x9e,
			0xdc, 0x98, 0x74, 0x32, 0x38, 0xb2, 0x73, 0x99,
			0x13, 0x29, 0x8a, 0xf3, 0xaf, 0x03, 0x0d, 0x30,
			0x08, 0xfe, 0x61, 0x01, 0x89, 0xd3, 0x5d, 0xbb,
			0x9c, 0x1c, 0x71, 0x1e, 0xd6, 0x3c, 0x64, 0xca,
			0xfa, 0x82, 0xc7, 0xe5, 0x98, 0xd8, 0xee, 0x96,
			0x88, 0x0e, 0xed, 0x11, 0x6e, 0x11, 0x34, 0xaa,
			0xe3, 0x9b, 0xf0, 0x83, 0x2a, 0x1d, 0x21, 0x42,
			0x07, 0x6d, 0x7e, 0x9a, 0x9a, 0xf8, 0x90, 0xdc,
			0x6e, 0x3a, 0x31, 0xf1, 0x42, 0xec, 0x28, 0x46,
			0x24, 0x5e, 0xaf, 0xb0, 0x88, 0xda, 0xb9, 0xae,
			0xef, 0x08, 0x08, 0x50, 0x2a, 0xc1, 0x3b, 0x40,
			0xda, 0x1d, 0x83, 0x60, 0x00, 0x4e, 0xb4, 0xbb,
			0xa9, 0x6b, 0xeb, 0x95, 0xb3, 0x03, 0x0c, 0xa1,
			0x60, 0xd1, 0x81, 0xcd, 0xe7, 0x8c, 0x80, 0xc9,
			0x98, 0xc2, 0x66, 0x75, 0x39, 0xb4, 0xa0, 0xb5,
			0x37, 0x98, 0x0b, 0xc4, 0x33, 0x86, 0x8d, 0x8b,
			0x19, 0xdc, 0x79, 0xbb, 0x96, 0x1a, 0xa9, 0xe9,
			0x68, 0x57, 0x05, 0xac, 0x5d, 0x9e, 0xc5, 0x4e,
			0xb2, 0x31, 0xfa, 0xff, 0x14, 0x76, 0x54, 0x88,
			0xe6, 0xac, 0xb7, 0xaf, 0xaa, 0x06, 0x8b, 0xb6,
			0xdb, 0x3b, 0xd1, 0xe1, 0x34, 0xc5, 0x07, 0xa5,
			0xaf, 0x29, 0xc3, 0x2e, 0x70, 0x89, 0x5f, 0x4e,
			0x61, 0x27, 0x9a, 0x9f, 0xaf, 0xb8, 0x22, 0xb8,
			0x0f, 0x07, 0x20, 0x4f, 0x9e, 0x4d, 0x9b, 0x25,
			0x10, 0xa1, 0x35, 0x31, 0x96, 0x8e, 0x62, 0x92,
			0xb4, 0x22, 0xeb, 0x50, 0x52, 0x14, 0x64, 0x1d,
			0xba, 0xeb, 0x7c, 0x26, 0x5f, 0x8d, 0xec, 0xda,
		},
		20, /* salt length */
		/* V7 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA256 [8] */
	{
		/* Msg8 : 128 byte */
		{
			0xab, 0x54, 0x70, 0x83, 0x07, 0x77, 0xa1, 0x63,
			0x49, 0x45, 0xba, 0xd2, 0x11, 0xee, 0xfa, 0x9f,
			0x41, 0xde, 0xee, 0xb7, 0x5e, 0x92, 0xef, 0x9c,
			0x39, 0xaa, 0xec, 0x12, 0xce, 0x40, 0x6a, 0x1c,
			0x6c, 0x79, 0xc8, 0x26, 0x16, 0x59, 0xc8, 0x84,
			0x2a, 0xdc, 0x4b, 0x1b, 0x40, 0x42, 0x5c, 0x5e,
			0x55, 0xaa, 0x70, 0x7d, 0x29, 0xe2, 0xec, 0xd8,
			0xe5, 0x7e, 0xe8, 0xba, 0x01, 0x27, 0x33, 0x44,
			0x65, 0x36, 0x97, 0xa7, 0xce, 0x82, 0x5e, 0x97,
			0x74, 0x75, 0x14, 0xfc, 0xea, 0x66, 0x8f, 0xea,
			0x45, 0x22, 0x2d, 0xd3, 0x80, 0xcc, 0x5d, 0xfb,
			0x1f, 0xe8, 0x61, 0x2d, 0x13, 0xb2, 0x52, 0xad,
			0xde, 0xb4, 0x64, 0x6d, 0xf7, 0x97, 0x6b, 0x83,
			0x70, 0x3a, 0x9e, 0xdb, 0xd6, 0x01, 0x9b, 0x29,
			0x59, 0x70, 0xac, 0x22, 0x2c, 0xf8, 0x49, 0xec,
			0x2f, 0x10, 0xde, 0xd3, 0xcc, 0x88, 0xce, 0x3d,
		},
		/* S8 : 256 byte */
		{
			0x4c, 0x1f, 0xb3, 0xbc, 0x97, 0x37, 0xde, 0xac,
			0x2e, 0x88, 0x0e, 0x16, 0x3d, 0x42, 0xd8, 0x3f,
			0x55, 0x1d, 0xe6, 0x78, 0x0a, 0x0b, 0x22, 0x8b,
			0x33, 0xc5, 0x98, 0x76, 0xb9, 0x81, 0xe9, 0x9b,
			0xdd, 0xca, 0xea, 0x9f, 0xf8, 0xba, 0x08, 0x52,
			0xf7, 0x1d, 0xec, 0x0f, 0x24, 0xc7, 0xe8, 0x4f,
			0x00, 0x7e, 0x08, 0xca, 0x9d, 0xd9, 0x8c, 0xfa,
			0x42, 0xeb, 0x59, 0x92, 0x6b, 0xd2, 0xa5, 0x55,
			0x7e, 0x44, 0xd0, 0x54, 0x6a, 0x36, 0x19, 0xe5,
			0xf6, 0x68, 0xb4, 0x56, 0x07, 0x9c, 0xe4, 0x0a,
			0xd0, 0x76, 0x7a, 0xc2, 0x1b, 0x31, 0xca, 0xa0,
			0x76, 0x5e, 0xbf, 0x53, 0x09, 0x7d, 0xf6, 0x1d,
			0x49, 0x22, 0x43, 0x56, 0xf6, 0x71, 0x23, 0x44,
			0x55, 0xa0, 0xb2, 0x0f, 0x01, 0xcd, 0x9b, 0xc8,
			0xd9, 0xa2, 0x5f, 0xcd, 0x5a, 0x8d, 0xd5, 0x1c,
			0x87, 0xa6, 0x31, 0x59, 0x08, 0x84, 0x56, 0x1e,
			0xc1, 0x2b, 0x58, 0xc2, 0x41, 0xab, 0xa1, 0x5a,
			0x4a, 0x45, 0xd3, 0xb2, 0xe9, 0xe6, 0x90, 0xaa,
			0xa6, 0xeb, 0x6d, 0xdf, 0xb9, 0x04, 0xbe, 0xd2,
			0x58, 0xaa, 0xf4, 0x54, 0xc8, 0x56, 0xad, 0x67,
			0xa8, 0x2d, 0x95, 0x3e, 0xc4, 0xb2, 0x0c, 0x06,
			0xa7, 0x0f, 0x4b, 0x17, 0x34, 0x67, 0x51, 0x8c,
			0xeb, 0x85, 0x9e, 0xdd, 0xf8, 0x22, 0x38, 0x8e,
			0xaa, 0xc9, 0xaf, 0x40, 0x3c, 0x7b, 0x7b, 0x9d,
			0x1e, 0xd7, 0x86, 0xa8, 0xfa, 0xda, 0x57, 0xaf,
			0xf0, 0x43, 0xfa, 0xd1, 0x63, 0x59, 0xeb, 0x28,
			0x94, 0xca, 0x53, 0x86, 0x70, 0x9d, 0x7b, 0x97,
			0xcc, 0x69, 0x2c, 0xca, 0xdf, 0x1d, 0x3f, 0x3f,
			0xb0, 0x4d, 0x6f, 0x8c, 0x09, 0xb3, 0xf4, 0x27,
			0x81, 0x3b, 0xb6, 0xba, 0x6e, 0xa2, 0x28, 0xbc,
			0x45, 0xfb, 0x13, 0xd7, 0x80, 0xee, 0xc7, 0x7b,
			0xee, 0x66, 0xb3, 0x00, 0xff, 0xdd, 0x0b, 0x34,
		},
		20, /* salt length */
		/* V8 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA256 [9] */
	{
		/* Msg9 : 128 byte */
		{
			0xbd, 0x58, 0x68, 0x81, 0x88, 0xf4, 0xdc, 0x8f,
			0x65, 0x83, 0xfa, 0x0c, 0xa4, 0xe3, 0xbd, 0x5d,
			0x24, 0x4b, 0x0b, 0x1d, 0x22, 0xd4, 0x2d, 0xc3,
			0x4f, 0x38, 0x83, 0x7e, 0x25, 0xd9, 0x76, 0x64,
			0x7a, 0x05, 0xad, 0xcc, 0x56, 0x78, 0x84, 0xf8,
			0x02, 0x22, 0xba, 0xf8, 0x61, 0x2b, 0x69, 0xca,
			0x83, 0x35, 0x3c, 0xc6, 0x78, 0xe1, 0xdc, 0x3a,
			0x62, 0x94, 0xab, 0x51, 0xce, 0x7b, 0xb5, 0x39,
			0x45, 0xcc, 0xe4, 0x84, 0x1d, 0x4f, 0x73, 0xcf,
			0x95, 0x1e, 0xa4, 0xa2, 0x22, 0xa9, 0xb6, 0x98,
			0x03, 0xfc, 0x11, 0xc0, 0x1b, 0x45, 0xc5, 0x42,
			0x00, 0x90, 0x32, 0x46, 0x50, 0xd6, 0x08, 0x11,
			0x44, 0x36, 0x73, 0x71, 0x87, 0x82, 0x8f, 0x5c,
			0x48, 0xfd, 0x22, 0xd4, 0x8e, 0x63, 0x8a, 0x0d,
			0xcb, 0x2a, 0xf4, 0xd2, 0xb5, 0x08, 0xcf, 0x25,
			0x51, 0xb5, 0x81, 0x26, 0x50, 0xf2, 0x58, 0x36,
		},
		/* S9 : 256 byte */
		{
			0xa8, 0x38, 0x13, 0xc8, 0x12, 0x0c, 0x53, 0xd7,
			0x9b, 0x98, 0x1f, 0x8a, 0xfb, 0xe3, 0xe0, 0x7e,
			0x62, 0x30, 0xd5, 0x95, 0xc7, 0x7c, 0x2e, 0xc1,
			0xbd, 0xb6, 0x7a, 0x06, 0xb0, 0x61, 0xe9, 0x2d,
			0x4b, 0x4c, 0x5b, 0x69, 0xfe, 0xf3, 0xbe, 0xb3,
			0xf1, 0xf3, 0x64, 0x2f, 0x59, 0xad, 0x73, 0x70,
			0x2d, 0x6d, 0x33, 0x1b, 0xdc, 0xf5, 0x5b, 0x75,
			0x18, 0x30, 0xaa, 0x94, 0xd4, 0x54, 0xbd, 0x8a,
			0x9c, 0x7b, 0x3b, 0xb7, 0x17, 0xa5, 0x93, 0x94,
			0xf5, 0x50, 0xbf, 0x70, 0xcd, 0x10, 0x76, 0xaf,
			0x6f, 0x27, 0xab, 0x6c, 0x4b, 0x70, 0xc2, 0xa0,
			0x34, 0xcd, 0x87, 0xc5, 0x55, 0x14, 0x06, 0x70,
			0x1c, 0xff, 0xdc, 0xd9, 0xc6, 0x0d, 0x0a, 0x2e,
			0x39, 0x0c, 0x5f, 0x4b, 0x71, 0x37, 0x21, 0x3a,
			0xc1, 0x92, 0x41, 0x44, 0x4e, 0x91, 0x31, 0x9b,
			0xae, 0x81, 0x7d, 0x27, 0x20, 0x1c, 0xf0, 0x83,
			0xa9, 0xc0, 0xfd, 0xde, 0xd3, 0xae, 0x10, 0xb3,
			0x42, 0x3d, 0x96, 0x4b, 0xd0, 0xa3, 0xe2, 0x50,
			0x72, 0x4d, 0x19, 0xff, 0x3d, 0xca, 0xca, 0x20,
			0x8e, 0xb6, 0x0a, 0x9c, 0xa3, 0xbc, 0xfd, 0x38,
			0xaa, 0xef, 0x01, 0x11, 0x6b, 0x9c, 0x48, 0x95,
			0xaf, 0x8b, 0xc9, 0x07, 0xd0, 0x24, 0xac, 0xd4,
			0x6f, 0x04, 0x07, 0x8d, 0xbe, 0x55, 0x73, 0x80,
			0x7e, 0xae, 0x98, 0xb9, 0x73, 0xab, 0xa8, 0xb5,
			0x6d, 0xf8, 0x66, 0x84, 0x52, 0xfd, 0xf7, 0x37,
			0x5d, 0xd2, 0x7f, 0x58, 0xa9, 0xe6, 0x42, 0x9a,
			0x0f, 0x2a, 0x01, 0xfa, 0xa5, 0x4f, 0x95, 0xff,
			0x16, 0xbf, 0xda, 0xee, 0x42, 0x91, 0x71, 0x5e,
			0xf1, 0x21, 0xdc, 0x59, 0x4b, 0x83, 0x28, 0x9c,
			0x3a, 0x99, 0xc6, 0x75, 0x75, 0xc7, 0xc0, 0x42,
			0xa7, 0x77, 0x1f, 0x87, 0xc3, 0xe7, 0xd8, 0xaf,
			0x8a, 0x0b, 0x46, 0x69, 0x7d, 0xd2, 0x8a, 0xf6,
		},
		20, /* salt length */
		/* V9 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
};

/* 10 elements */
static mod2048_t SHA384[] = {
	/* SHA384 [0] */
	{
		/* Msg0 : 128 byte */
		{
			0x4d, 0x41, 0xe8, 0x1f, 0xe7, 0x72, 0x9b, 0x79,
			0xc1, 0x70, 0x3e, 0xf8, 0x4b, 0xfc, 0x5e, 0x84,
			0x20, 0x50, 0x21, 0x3c, 0x31, 0xb1, 0x88, 0xb0,
			0x20, 0x44, 0xf1, 0x51, 0xea, 0x22, 0xe0, 0x26,
			0xc9, 0xae, 0xfe, 0xc0, 0x59, 0x27, 0x62, 0x6f,
			0xf9, 0x79, 0x10, 0xb6, 0x74, 0x59, 0xbf, 0xfd,
			0xe1, 0x90, 0xe0, 0x86, 0xc7, 0x97, 0xdb, 0xa2,
			0x85, 0x65, 0x9c, 0x25, 0xf1, 0x85, 0x4e, 0x17,
			0x40, 0x6b, 0x66, 0xac, 0x26, 0x08, 0xe4, 0x76,
			0x3d, 0x9c, 0xd5, 0xda, 0xab, 0xcc, 0x1d, 0xc1,
			0x00, 0xf4, 0x73, 0x8f, 0x5d, 0xbe, 0xad, 0x59,
			0xdb, 0xf4, 0x3e, 0x53, 0x2a, 0x92, 0xfd, 0x87,
			0x79, 0x20, 0x28, 0xcd, 0x96, 0x3e, 0xa8, 0xf7,
			0x57, 0x81, 0x96, 0x4c, 0x38, 0x7d, 0xff, 0x38,
			0x45, 0x23, 0xe4, 0x41, 0x3b, 0x4e, 0x85, 0x3d,
			0xea, 0x98, 0xe0, 0xc2, 0xdd, 0x72, 0x74, 0xdf,
		},
		/* S0 : 256 byte */
		{
			0xb4, 0x3d, 0x87, 0xde, 0xef, 0xa7, 0xdf, 0x12,
			0x7a, 0x71, 0x7f, 0x40, 0x65, 0xf8, 0x31, 0xc5,
			0x8c, 0xd8, 0x4b, 0xf7, 0x8c, 0x91, 0x6b, 0xa5,
			0x2e, 0xd3, 0x27, 0x69, 0xab, 0xd5, 0x41, 0xdf,
			0x52, 0x23, 0x3b, 0x85, 0x83, 0x50, 0x7c, 0x53,
			0x9b, 0x1d, 0x51, 0xe0, 0x43, 0x7a, 0xb1, 0xa4,
			0x1e, 0x17, 0xfc, 0x15, 0x99, 0xb9, 0x2a, 0xab,
			0xdb, 0x5b, 0x04, 0x0d, 0xc7, 0x90, 0x27, 0xc6,
			0x0c, 0x9c, 0xc3, 0xed, 0x3d, 0xe3, 0x6a, 0xee,
			0xa2, 0x8f, 0x20, 0x36, 0x06, 0x35, 0xbe, 0x5b,
			0xf6, 0x54, 0xd6, 0xc1, 0xb7, 0xfe, 0x6d, 0xa7,
			0x7d, 0x0c, 0x45, 0xb9, 0xea, 0x28, 0x02, 0xad,
			0x22, 0xeb, 0xa1, 0x82, 0xcb, 0xed, 0x95, 0xd3,
			0x3d, 0xa7, 0xf7, 0x8a, 0xc8, 0x44, 0xf4, 0x89,
			0x1c, 0xeb, 0xc0, 0x39, 0x6c, 0xaa, 0x2f, 0x8d,
			0xaa, 0xf5, 0x52, 0x54, 0xfd, 0xaf, 0xe9, 0x8b,
			0x5f, 0xe6, 0xc4, 0xdd, 0x39, 0x67, 0xd2, 0x3e,
			0xa9, 0x94, 0x97, 0x06, 0x08, 0x20, 0xe1, 0x08,
			0xe8, 0x18, 0xcd, 0x0a, 0xa9, 0x4e, 0x65, 0x77,
			0x0b, 0xde, 0x89, 0x2c, 0x62, 0x23, 0x3b, 0x96,
			0xd8, 0x7f, 0xe5, 0x45, 0x16, 0x2d, 0x6b, 0xa0,
			0x77, 0xf1, 0x10, 0x27, 0x4b, 0xdd, 0xac, 0xb2,
			0xa7, 0xcb, 0xf1, 0x7d, 0x43, 0x7b, 0xfe, 0x00,
			0x4b, 0x34, 0xc3, 0xea, 0x24, 0xfb, 0x46, 0xe5,
			0xed, 0x9c, 0xce, 0x4d, 0xe9, 0x6b, 0x06, 0x94,
			0xef, 0xd7, 0x38, 0x32, 0xec, 0x76, 0xe1, 0x9e,
			0x5a, 0x25, 0xc4, 0x9c, 0x58, 0x43, 0x39, 0x3c,
			0xe6, 0xb9, 0x19, 0xea, 0x35, 0xe4, 0xd2, 0x64,
			0xe0, 0xa0, 0x85, 0x5f, 0x51, 0x8a, 0x63, 0xc0,
			0x08, 0xc1, 0x83, 0x79, 0x8c, 0xa6, 0x12, 0xcd,
			0x8f, 0x75, 0x68, 0x8a, 0x09, 0x21, 0x04, 0x13,
			0xe0, 0xa2, 0x3c, 0xaf, 0xcf, 0x2d, 0x41, 0x58,
		},
		20, /* salt length */
		/* V0 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA384 [1] */
	{
		/* Msg1 : 128 byte */
		{
			0x6d, 0x27, 0x8c, 0xcf, 0x21, 0x8f, 0x04, 0x95,
			0x86, 0x7b, 0x34, 0x71, 0xf2, 0x76, 0xc4, 0x76,
			0xfa, 0x51, 0x99, 0x0d, 0x38, 0xcf, 0xb1, 0x45,
			0x4c, 0xa2, 0x4f, 0x6a, 0x21, 0x96, 0x59, 0xd9,
			0x72, 0x0d, 0xfe, 0x12, 0x8c, 0xab, 0x9b, 0x0f,
			0x55, 0x52, 0xe0, 0xd5, 0x8d, 0x51, 0x2f, 0x48,
			0x54, 0xd8, 0x44, 0x43, 0xec, 0xb0, 0x1b, 0xe8,
			0xc1, 0x28, 0x0e, 0x35, 0xa6, 0x53, 0x3f, 0xd8,
			0x62, 0x70, 0x35, 0x45, 0x6b, 0xaa, 0xca, 0x05,
			0xf1, 0x02, 0x44, 0x51, 0x1e, 0x89, 0xc2, 0xdf,
			0x9d, 0xd2, 0xda, 0xfc, 0x59, 0xa7, 0x80, 0xdb,
			0x87, 0xfb, 0x29, 0x2d, 0xe6, 0x20, 0x31, 0xf1,
			0x45, 0x3a, 0x7a, 0x8e, 0x47, 0xf4, 0x57, 0x1f,
			0x63, 0x71, 0xa8, 0x0e, 0x2e, 0x86, 0x46, 0xe4,
			0xdd, 0x26, 0xa1, 0x5f, 0x05, 0x1d, 0xa7, 0xc6,
			0xa6, 0x01, 0xe8, 0x79, 0x68, 0x66, 0xf8, 0xcc,
		},
		/* S1 : 256 byte */
		{
			0x91, 0x0d, 0x02, 0x35, 0xa9, 0x5a, 0xeb, 0xf8,
			0x42, 0x52, 0xfb, 0xc0, 0xd8, 0x32, 0x1b, 0xc5,
			0xd0, 0x72, 0x39, 0xf6, 0x25, 0x9b, 0x4d, 0xd0,
			0x82, 0x10, 0x28, 0x39, 0x40, 0x49, 0xa9, 0xb9,
			0x46, 0xf8, 0xbd, 0x1d, 0x78, 0xa4, 0xfd, 0x4c,
			0x93, 0xf3, 0xe1, 0x9c, 0x0c, 0x8d, 0x72, 0x27,
			0x67, 0x46, 0x4e, 0xb4, 0xa9, 0x57, 0x86, 0xec,
			0x74, 0x92, 0x39, 0x9f, 0x76, 0x77, 0x94, 0xb1,
			0x94, 0xea, 0x42, 0x1c, 0x0a, 0x59, 0xcb, 0x78,
			0x75, 0xb9, 0xab, 0xd5, 0x4c, 0x23, 0xa5, 0x41,
			0xb4, 0xf5, 0x46, 0x69, 0x35, 0xb7, 0xe6, 0x2f,
			0x4a, 0x78, 0x8d, 0x35, 0xd3, 0xc3, 0x6b, 0xbe,
			0x5e, 0xc6, 0x1f, 0xd0, 0x36, 0x46, 0x42, 0xd5,
			0xbb, 0x60, 0x7d, 0x1d, 0x58, 0x7e, 0xf8, 0x03,
			0x6c, 0xee, 0x83, 0x6c, 0x5c, 0x3f, 0x87, 0x6b,
			0x71, 0x36, 0x4c, 0xf2, 0xc0, 0x82, 0xee, 0x7e,
			0x34, 0xce, 0x80, 0x44, 0x25, 0xac, 0x7a, 0xc8,
			0x6f, 0x28, 0x71, 0x36, 0xe3, 0xeb, 0x54, 0xb4,
			0x6b, 0xc5, 0x77, 0x55, 0xf6, 0x34, 0xd7, 0xca,
			0xff, 0x04, 0x14, 0x35, 0x45, 0xc1, 0x92, 0x17,
			0x20, 0x1e, 0xeb, 0xcf, 0x6f, 0xdc, 0x00, 0x49,
			0x51, 0x25, 0x3c, 0x1f, 0x42, 0x14, 0x0d, 0xd8,
			0x3c, 0x44, 0x98, 0x7b, 0x99, 0xc0, 0x9b, 0xdf,
			0xa9, 0xef, 0xe3, 0x96, 0x65, 0x55, 0x3d, 0x21,
			0x8e, 0xbb, 0x87, 0xed, 0x6d, 0x4e, 0x83, 0xe0,
			0x73, 0x00, 0x7e, 0x85, 0xff, 0x92, 0x66, 0xc4,
			0x80, 0xd2, 0xb5, 0x69, 0x5c, 0xc0, 0xbd, 0x92,
			0x24, 0x5a, 0x8a, 0xc5, 0x9e, 0x67, 0x11, 0x58,
			0xf6, 0xd9, 0x27, 0x0c, 0x2d, 0xaf, 0xbc, 0x0b,
			0xc5, 0x1c, 0x54, 0x83, 0xfe, 0xa0, 0x6f, 0x77,
			0x23, 0x6a, 0x8e, 0xb6, 0xca, 0xda, 0x53, 0x64,
			0x94, 0x32, 0x61, 0xe4, 0xa4, 0xd0, 0xa5, 0x39,
		},
		20, /* salt length */
		/* V1 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA384 [2] */
	{
		/* Msg2 : 128 byte */
		{
			0xcb, 0x5f, 0x99, 0x7f, 0xbe, 0x1a, 0xed, 0x2a,
			0x00, 0xc6, 0xce, 0x19, 0xbd, 0x36, 0xd0, 0x60,
			0x46, 0xc0, 0x02, 0x9f, 0x4f, 0x9d, 0xc5, 0x83,
			0x5a, 0x92, 0xde, 0x8f, 0x73, 0xd0, 0xc9, 0x1c,
			0x1e, 0x1a, 0x50, 0x9e, 0x8e, 0x25, 0x5d, 0x2a,
			0x17, 0x44, 0x0d, 0x35, 0xe6, 0x45, 0x05, 0x9f,
			0xf0, 0x95, 0x09, 0xf0, 0x28, 0xab, 0xcb, 0xe1,
			0xf5, 0xa4, 0x00, 0x1e, 0xe3, 0x2b, 0xb9, 0x4a,
			0x99, 0x9c, 0xf1, 0x43, 0x0b, 0x69, 0x62, 0xa8,
			0xf0, 0xbc, 0x9e, 0x99, 0x77, 0x5e, 0x5a, 0xbe,
			0x35, 0xd7, 0x0d, 0x8b, 0x62, 0xd7, 0xba, 0xc2,
			0x46, 0xd4, 0x09, 0x39, 0xee, 0xf5, 0x9d, 0xdd,
			0x23, 0x2f, 0xa2, 0xf7, 0x9d, 0xae, 0xa5, 0xae,
			0x73, 0x76, 0xa9, 0xcd, 0xd6, 0x4a, 0x77, 0xc7,
			0xff, 0xcc, 0x35, 0xf9, 0x66, 0xe7, 0x3a, 0x2e,
			0x35, 0x6a, 0x21, 0x68, 0xfc, 0xf5, 0x1c, 0xde,
		},
		/* S2 : 256 byte */
		{
			0x33, 0xe5, 0xd7, 0xf8, 0x3b, 0xaf, 0x70, 0xfb,
			0x41, 0x05, 0x34, 0x97, 0x53, 0x94, 0xab, 0xe8,
			0x22, 0xd5, 0xf2, 0xaa, 0xbf, 0x7e, 0x6d, 0x55,
			0xad, 0xb3, 0x74, 0xdc, 0x67, 0x4d, 0x71, 0xbc,
			0xa1, 0x32, 0x3b, 0xe5, 0x4f, 0x30, 0xd2, 0xd8,
			0xe8, 0x38, 0x7a, 0x3e, 0xfd, 0xeb, 0xf7, 0x87,
			0xc8, 0x8b, 0x16, 0xeb, 0x67, 0x74, 0xde, 0x80,
			0xca, 0xd3, 0x8f, 0x5e, 0xd7, 0xe5, 0x65, 0x85,
			0xf4, 0x11, 0x32, 0x60, 0x6e, 0x0a, 0x8c, 0xb1,
			0x77, 0x5b, 0xc2, 0x32, 0x2f, 0x13, 0xa4, 0x1f,
			0xdf, 0xdf, 0xd2, 0xa8, 0xd2, 0x61, 0xca, 0x0f,
			0xae, 0x81, 0x1c, 0xed, 0x9c, 0x11, 0x99, 0x83,
			0x21, 0xfc, 0x24, 0xb4, 0x00, 0xb6, 0x89, 0xc2,
			0xd9, 0x37, 0x09, 0x51, 0xe8, 0x31, 0xcc, 0xc0,
			0x68, 0xf0, 0xcc, 0x00, 0x00, 0x67, 0x11, 0xb9,
			0xf1, 0xe5, 0x33, 0xa3, 0xe2, 0x7c, 0x45, 0x61,
			0xee, 0x50, 0x12, 0xdb, 0x11, 0x6a, 0x91, 0x75,
			0x6d, 0x21, 0xab, 0xed, 0xdf, 0x3f, 0x08, 0xbd,
			0xe5, 0xfd, 0xcb, 0x44, 0xf2, 0xde, 0x21, 0xbf,
			0x59, 0xed, 0xfa, 0x3c, 0x78, 0xa4, 0x40, 0x8b,
			0x1b, 0xc5, 0x5d, 0x9a, 0xcb, 0x6e, 0xd3, 0x21,
			0x0b, 0xb1, 0x5d, 0x37, 0xbb, 0xba, 0xf6, 0x4d,
			0xd2, 0x78, 0x15, 0x90, 0xb9, 0xd6, 0x1a, 0xce,
			0x52, 0x4d, 0xe4, 0x9d, 0x01, 0x50, 0xed, 0x0f,
			0x24, 0xf8, 0x8f, 0xd0, 0xb6, 0x69, 0x39, 0x12,
			0x25, 0x79, 0x64, 0xac, 0x29, 0xf1, 0x6c, 0x8f,
			0x73, 0x23, 0x09, 0x82, 0xef, 0x0d, 0x4c, 0xe3,
			0xc5, 0xaf, 0x72, 0x59, 0x47, 0x55, 0x4b, 0x02,
			0x4b, 0xa5, 0x9b, 0x85, 0xb1, 0xee, 0xdc, 0x32,
			0x5a, 0xbf, 0xa9, 0xf4, 0xfe, 0xea, 0x5a, 0x45,
			0x82, 0x9f, 0x9b, 0x24, 0xa2, 0xf0, 0xd1, 0x12,
			0x6f, 0x4c, 0x31, 0xa8, 0x1d, 0x67, 0x4f, 0xb6,
		},
		20, /* salt length */
		/* V2 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA384 [3] */
	{
		/* Msg3 : 128 byte */
		{
			0xa3, 0x6e, 0x47, 0xfe, 0x44, 0x9e, 0xbf, 0xc5,
			0xa8, 0x8f, 0xd4, 0x03, 0xb0, 0x6c, 0x9d, 0xc7,
			0x43, 0x50, 0x56, 0xad, 0xa1, 0x4f, 0x56, 0xff,
			0xf4, 0xb5, 0x41, 0x20, 0x29, 0x92, 0x7f, 0x2b,
			0xfd, 0x76, 0xed, 0xd7, 0x5b, 0x79, 0xd2, 0x9e,
			0xe5, 0x7e, 0x14, 0x1e, 0xd1, 0xb9, 0xac, 0xbf,
			0xf6, 0x6f, 0x57, 0x96, 0x26, 0xfd, 0x8e, 0x89,
			0xbf, 0x1c, 0xb9, 0xb4, 0x7d, 0x63, 0xa0, 0x0c,
			0x92, 0x0e, 0x22, 0x42, 0xf9, 0xfd, 0x29, 0xeb,
			0x07, 0x00, 0xdd, 0xdd, 0x43, 0x51, 0x18, 0xdc,
			0x77, 0x62, 0x1a, 0x76, 0x07, 0xd9, 0x7f, 0x2b,
			0x82, 0xd9, 0x6e, 0xd1, 0x77, 0x84, 0x12, 0x37,
			0x8a, 0xbe, 0x4e, 0x09, 0xc6, 0x33, 0xac, 0xf3,
			0x35, 0x9b, 0x97, 0x09, 0xae, 0x3d, 0xcb, 0x67,
			0xef, 0xb1, 0x09, 0x14, 0xec, 0xeb, 0x0f, 0x2d,
			0x66, 0x75, 0xc7, 0x3f, 0xbe, 0xfc, 0xbf, 0xf4,
		},
		/* S3 : 256 byte */
		{
			0x20, 0xa3, 0xde, 0x32, 0x04, 0xb2, 0xce, 0x25,
			0x08, 0x40, 0x77, 0x1b, 0x21, 0xfa, 0x19, 0xcf,
			0x6d, 0x42, 0xa9, 0x74, 0x72, 0x3c, 0xe9, 0x8f,
			0x9e, 0xfd, 0x9e, 0x8b, 0x3e, 0xc2, 0x26, 0x6a,
			0x85, 0xbc, 0x9f, 0x01, 0x5c, 0xec, 0xa8, 0xf7,
			0x8b, 0x34, 0x2c, 0x1e, 0xa9, 0x78, 0xc3, 0x84,
			0xdb, 0x98, 0xe5, 0x4e, 0x17, 0xbb, 0x3b, 0x6d,
			0xc5, 0x89, 0x19, 0xc7, 0x63, 0x4e, 0x53, 0x98,
			0xf1, 0xb5, 0x6f, 0xa9, 0x7e, 0x42, 0x3b, 0xf0,
			0x83, 0xf8, 0xfa, 0x41, 0x9d, 0x02, 0xcc, 0x16,
			0xe3, 0x01, 0x1e, 0xda, 0x9d, 0x81, 0xe7, 0x7b,
			0xe7, 0xbf, 0xeb, 0xbc, 0xe8, 0x40, 0x5f, 0x13,
			0xf1, 0x20, 0x43, 0x2d, 0x4f, 0xe2, 0x16, 0x1a,
			0x08, 0xb9, 0xcf, 0x7e, 0xfe, 0x60, 0xf9, 0x27,
			0xe1, 0x50, 0x35, 0xc9, 0xd6, 0xc5, 0xd7, 0xbe,
			0xa5, 0xed, 0xd3, 0xe6, 0x1f, 0x8a, 0xaf, 0xd8,
			0xe2, 0xaf, 0x58, 0xa9, 0xe1, 0x27, 0x15, 0x8e,
			0x45, 0xe5, 0x83, 0x7c, 0x36, 0x62, 0x74, 0xa7,
			0x59, 0x47, 0x24, 0xac, 0x7b, 0x7b, 0x9c, 0x31,
			0x9d, 0x3e, 0xb5, 0x22, 0x6d, 0x4c, 0x3d, 0xdf,
			0x17, 0x23, 0xef, 0xe5, 0xde, 0xc4, 0x96, 0x8b,
			0x08, 0xdd, 0x6c, 0xc4, 0x97, 0xb1, 0x61, 0x9f,
			0xca, 0x17, 0x09, 0x0a, 0x81, 0x51, 0x78, 0x6b,
			0xbe, 0x0a, 0xba, 0x58, 0x23, 0x4c, 0x54, 0x95,
			0xbd, 0xec, 0x2b, 0x0f, 0xb5, 0x3a, 0xa8, 0x4a,
			0x46, 0x4d, 0xbe, 0x39, 0x54, 0x52, 0x9e, 0x07,
			0x1b, 0x15, 0x1e, 0x15, 0x49, 0x9d, 0x05, 0x2e,
			0xf8, 0x45, 0x7b, 0x92, 0x8f, 0x1d, 0x31, 0x06,
			0xc2, 0x3d, 0x1e, 0x68, 0xaa, 0x6e, 0x79, 0x1b,
			0xfa, 0x0d, 0x5d, 0x57, 0xb5, 0x05, 0x67, 0xe1,
			0x13, 0x8b, 0x89, 0x4b, 0x15, 0x16, 0xe4, 0x23,
			0xe9, 0x5a, 0x70, 0xbf, 0x30, 0x6a, 0x5d, 0x66,
		},
		20, /* salt length */
		/* V3 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA384 [4] */
	{
		/* Msg4 : 128 byte */
		{
			0x22, 0xd7, 0x38, 0x05, 0x80, 0x56, 0x30, 0xfb,
			0x41, 0x6d, 0x20, 0xd4, 0xfc, 0xa6, 0x74, 0x19,
			0xab, 0x66, 0x0f, 0xf4, 0x5c, 0xd1, 0x9a, 0x37,
			0x29, 0xe8, 0x1b, 0x9f, 0x69, 0xf4, 0xc9, 0x5b,
			0x28, 0x28, 0x1f, 0xc8, 0xd5, 0x82, 0x2f, 0x7f,
			0x3b, 0xf2, 0x39, 0x91, 0xb3, 0xbe, 0x7c, 0x11,
			0x97, 0x25, 0x4c, 0xd3, 0xf9, 0x43, 0x65, 0x74,
			0x95, 0x34, 0x7f, 0x9a, 0x05, 0x7c, 0x22, 0x7d,
			0x34, 0xa6, 0xbc, 0xa7, 0x15, 0x2c, 0xf1, 0xf8,
			0x95, 0x97, 0x32, 0xec, 0xce, 0xe7, 0x91, 0x21,
			0x7d, 0x35, 0xd3, 0x13, 0xb6, 0x97, 0xc7, 0x2a,
			0xd6, 0x44, 0xd7, 0xf8, 0xba, 0xf9, 0xdd, 0xbb,
			0x2e, 0x9b, 0x38, 0x2a, 0xa8, 0x1d, 0x1e, 0x6e,
			0x37, 0xa4, 0x33, 0x6e, 0xb6, 0xe9, 0x5b, 0x4f,
			0x45, 0xdf, 0xcd, 0x3b, 0xfa, 0x97, 0x6a, 0x62,
			0xd3, 0x60, 0x4c, 0x3f, 0xef, 0x32, 0xa1, 0x1d,
		},
		/* S4 : 256 byte */
		{
			0x1c, 0xf3, 0x8e, 0xb4, 0x25, 0xaa, 0x5f, 0x15,
			0x0e, 0x1d, 0x13, 0x81, 0x0f, 0xa3, 0x14, 0x3e,
			0xc0, 0x11, 0x6a, 0x9b, 0x30, 0xf6, 0x5c, 0x6a,
			0xc3, 0xf1, 0xc0, 0xed, 0xe4, 0x4d, 0x26, 0xf2,
			0x32, 0xd1, 0x46, 0x80, 0x08, 0xa0, 0xb4, 0x86,
			0x74, 0x6d, 0x50, 0x6a, 0x5e, 0x8d, 0x5a, 0x9b,
			0x46, 0xbf, 0xac, 0xf4, 0xeb, 0x4d, 0x37, 0xc6,
			0x0a, 0x33, 0x04, 0x42, 0x08, 0xc3, 0x96, 0x4f,
			0xd6, 0x0f, 0x6a, 0xda, 0x19, 0x15, 0xac, 0x35,
			0xa1, 0x5b, 0x5e, 0x03, 0xa5, 0x45, 0x04, 0x83,
			0xeb, 0x98, 0xb6, 0xa7, 0x45, 0x9e, 0xde, 0xe5,
			0x8d, 0x4c, 0xec, 0x6d, 0x4c, 0xd3, 0x0e, 0xc0,
			0xda, 0x93, 0x6a, 0xa0, 0xa8, 0xc1, 0x69, 0x6c,
			0x1d, 0xc7, 0x93, 0xe9, 0x94, 0x92, 0x02, 0x9c,
			0x87, 0x20, 0x12, 0x86, 0x8c, 0xc7, 0xb8, 0x35,
			0xcf, 0xa9, 0xb7, 0x76, 0xed, 0xc0, 0x60, 0x7c,
			0xa5, 0xa6, 0xcd, 0xd8, 0xc3, 0x91, 0x83, 0x95,
			0x08, 0xf4, 0x9d, 0x7a, 0x23, 0x22, 0x3d, 0x82,
			0xd4, 0xa1, 0xc7, 0xf9, 0x0e, 0xaa, 0xf3, 0xcc,
			0x56, 0x26, 0xef, 0xd7, 0xef, 0x25, 0x4e, 0xab,
			0xd8, 0x94, 0xd4, 0x4b, 0x88, 0x9f, 0xb6, 0x76,
			0xc1, 0x73, 0xba, 0x34, 0xaa, 0xaf, 0x24, 0x37,
			0x99, 0xa0, 0x00, 0x20, 0x1d, 0x8e, 0xc2, 0x03,
			0x66, 0x50, 0x34, 0xc8, 0x3e, 0x8c, 0x65, 0x72,
			0xae, 0xfc, 0x58, 0xa4, 0x82, 0x3e, 0x1d, 0x32,
			0x1f, 0xd9, 0xad, 0x2d, 0x72, 0x93, 0xe5, 0x80,
			0x7c, 0xce, 0xea, 0x79, 0x4e, 0xc7, 0x56, 0x56,
			0xba, 0xb3, 0x32, 0x21, 0xdc, 0x12, 0x5a, 0xd0,
			0x52, 0x44, 0x61, 0xef, 0xd8, 0xa5, 0xed, 0x26,
			0x73, 0x2a, 0x00, 0x62, 0xc9, 0x15, 0xb5, 0x39,
			0x0b, 0x9b, 0x1d, 0x0b, 0xc3, 0x0a, 0x28, 0x03,
			0x99, 0xda, 0x84, 0x78, 0xb8, 0xf2, 0xbd, 0x4a,
		},
		20, /* salt length */
		/* V4 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA384 [5] */
	{
		/* Msg5 : 128 byte */
		{
			0x1d, 0x16, 0x93, 0xd4, 0x16, 0xb1, 0x72, 0x67,
			0x0d, 0xf9, 0x4e, 0xf3, 0x46, 0xf6, 0xa2, 0x59,
			0x2f, 0x29, 0x77, 0xce, 0x39, 0x15, 0xd7, 0x80,
			0xe7, 0xfe, 0x85, 0x7c, 0x24, 0xf1, 0xeb, 0xcf,
			0xda, 0x04, 0x54, 0xeb, 0xc0, 0xdf, 0x5b, 0x4d,
			0x74, 0x7b, 0xa3, 0x5d, 0xc9, 0x2a, 0xc9, 0x96,
			0x62, 0xd8, 0x97, 0xe6, 0x80, 0x90, 0x7b, 0x58,
			0x18, 0x42, 0x37, 0xf0, 0x29, 0xc3, 0xd9, 0xd6,
			0x4c, 0x15, 0xee, 0xb8, 0x8d, 0xe9, 0xf3, 0x69,
			0x79, 0x62, 0x0c, 0xce, 0x78, 0x1c, 0xf9, 0xfa,
			0x5d, 0x6d, 0x45, 0x98, 0x3c, 0xea, 0xc0, 0x89,
			0x7b, 0x2d, 0x30, 0xcf, 0x2c, 0xd6, 0x44, 0xaa,
			0x9a, 0xd0, 0xc9, 0x00, 0x22, 0xd6, 0x20, 0x02,
			0x45, 0x35, 0xf0, 0x0d, 0xfb, 0xd3, 0x18, 0xce,
			0x49, 0x70, 0xe8, 0xaa, 0x15, 0x2c, 0x90, 0x5d,
			0x3a, 0x49, 0xd8, 0xe1, 0xd8, 0x33, 0x12, 0x91,
		},
		/* S5 : 256 byte */
		{
			0x3c, 0x5a, 0x23, 0x90, 0xcb, 0x0e, 0xaa, 0xe6,
			0x1a, 0x97, 0x64, 0x7f, 0xf3, 0xe3, 0x4b, 0x9e,
			0x10, 0x3d, 0x9d, 0x80, 0x5f, 0x68, 0xb6, 0xda,
			0x0d, 0xfa, 0xe2, 0xc0, 0xe4, 0xca, 0x84, 0x66,
			0xb2, 0x96, 0x76, 0xe0, 0x9c, 0x65, 0x62, 0xf5,
			0x66, 0x7e, 0x69, 0xcd, 0x2f, 0x4a, 0x60, 0x36,
			0x65, 0xb6, 0x71, 0x2d, 0xdc, 0xa2, 0x4e, 0x24,
			0x59, 0x3c, 0xde, 0x60, 0x0e, 0x92, 0x53, 0x43,
			0x3b, 0x31, 0xcf, 0x10, 0xac, 0x43, 0x54, 0x0c,
			0x12, 0x1a, 0xed, 0x76, 0x35, 0x63, 0x7e, 0xb1,
			0x01, 0xc4, 0xd5, 0xd1, 0x89, 0xaa, 0xcf, 0x71,
			0xeb, 0xf4, 0xd4, 0xe8, 0x0a, 0xbc, 0x21, 0xd9,
			0x0a, 0xef, 0x2a, 0x6c, 0x7e, 0x0c, 0x3e, 0xac,
			0xd4, 0x5c, 0x65, 0xc0, 0x75, 0xab, 0xfb, 0x77,
			0xcc, 0xdf, 0x3b, 0x48, 0x87, 0x12, 0xe1, 0xb3,
			0x9e, 0x97, 0x36, 0x45, 0x73, 0xe0, 0x69, 0x18,
			0x18, 0x52, 0x2d, 0x54, 0xa2, 0x7c, 0x9f, 0x8e,
			0x7a, 0x1d, 0x06, 0xb1, 0xe6, 0xe7, 0x8e, 0x1d,
			0xee, 0x7c, 0x38, 0xcf, 0x4f, 0xac, 0xaf, 0x15,
			0x0f, 0x35, 0xcc, 0x23, 0xdb, 0xb9, 0x04, 0x54,
			0x52, 0x95, 0xa4, 0xa1, 0x81, 0xc4, 0xf9, 0xbe,
			0x24, 0x7d, 0x32, 0xe9, 0x0e, 0x48, 0x71, 0x6f,
			0x1a, 0x18, 0xc9, 0x71, 0x81, 0xb7, 0x79, 0x72,
			0x04, 0x53, 0x08, 0x7b, 0xe7, 0xc5, 0xb6, 0x55,
			0xbb, 0xf4, 0xae, 0xb0, 0x83, 0xf7, 0x06, 0x55,
			0x65, 0xc4, 0x50, 0x95, 0x97, 0xfc, 0x15, 0x20,
			0xb1, 0xef, 0x96, 0x40, 0x85, 0x41, 0x7f, 0x5d,
			0x2f, 0xa1, 0x77, 0xee, 0x1c, 0xfb, 0x82, 0x96,
			0xdc, 0x2e, 0xf9, 0xe0, 0xf9, 0xb0, 0x75, 0xa0,
			0x50, 0x78, 0xb5, 0x14, 0x30, 0xf5, 0xc3, 0x23,
			0x6f, 0x7f, 0x8c, 0xec, 0x72, 0x2a, 0xc7, 0xc1,
			0x93, 0x2b, 0x35, 0xe0, 0x3a, 0x6c, 0xe6, 0xf3,
		},
		20, /* salt length */
		/* V5 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA384 [6] */
	{
		/* Msg6 : 128 byte */
		{
			0xba, 0x5a, 0xa7, 0x67, 0x9f, 0x39, 0x95, 0x37,
			0xa4, 0x12, 0x98, 0xc4, 0x78, 0x60, 0x8c, 0x8a,
			0x7d, 0x92, 0x79, 0x86, 0x86, 0xba, 0x6f, 0x90,
			0xe0, 0x89, 0xb4, 0xeb, 0x8f, 0x7b, 0x22, 0x1b,
			0xd9, 0x4f, 0xca, 0xf6, 0x09, 0xba, 0xdd, 0xfe,
			0x6d, 0x5c, 0xcd, 0xee, 0xa1, 0xf3, 0xaf, 0x93,
			0x0f, 0xcf, 0xe4, 0xdd, 0xb7, 0x86, 0xf8, 0x36,
			0x2c, 0xe8, 0xca, 0x12, 0xdf, 0x35, 0xed, 0xc8,
			0xa0, 0x8e, 0x4f, 0xa0, 0x62, 0xaa, 0x18, 0x2d,
			0x3f, 0xca, 0xd5, 0xdd, 0xbc, 0xef, 0xd6, 0xce,
			0x4d, 0x4a, 0xd4, 0xe3, 0x1c, 0xf4, 0xd8, 0x18,
			0x06, 0xdf, 0x57, 0x12, 0xe6, 0x0d, 0xa2, 0xfb,
			0x17, 0xff, 0x7e, 0x8c, 0x34, 0x71, 0x0e, 0x6b,
			0x22, 0x44, 0xfa, 0xb8, 0x51, 0xbc, 0xca, 0xe2,
			0x3e, 0xeb, 0x93, 0xc0, 0x3d, 0x6d, 0xd6, 0xdd,
			0x75, 0x56, 0xa5, 0x13, 0x2c, 0x69, 0x07, 0x5b,
		},
		/* S6 : 256 byte */
		{
			0x37, 0xb1, 0x9f, 0x66, 0xf4, 0x64, 0xa7, 0xeb,
			0x5a, 0x68, 0x9c, 0xda, 0xe1, 0xb5, 0x56, 0x8c,
			0xbf, 0xa1, 0x62, 0x13, 0xc6, 0xa1, 0x02, 0xb4,
			0xb7, 0xfe, 0x54, 0x8d, 0x5b, 0x1d, 0x12, 0x0e,
			0x62, 0x86, 0xf2, 0x6e, 0xaf, 0x3d, 0x65, 0xca,
			0xcf, 0xcd, 0xbd, 0x39, 0xcb, 0xb4, 0x30, 0x7d,
			0x9b, 0x9e, 0x91, 0xe2, 0x91, 0x7a, 0xcb, 0xb1,
			0x45, 0x4e, 0xfc, 0x0e, 0x85, 0xb5, 0x90, 0xfa,
			0x33, 0xa6, 0xa6, 0x6a, 0x4b, 0x2e, 0x6c, 0x59,
			0x1a, 0x63, 0xc9, 0x56, 0x69, 0x06, 0xc9, 0x5d,
			0x18, 0xd2, 0x84, 0x52, 0x04, 0x84, 0xb2, 0xea,
			0x58, 0x39, 0x70, 0x7c, 0x72, 0xab, 0x6a, 0xb3,
			0x95, 0xe2, 0x5a, 0x74, 0x1b, 0xf4, 0x36, 0x27,
			0xa8, 0x63, 0xa6, 0xec, 0x90, 0x20, 0x80, 0x77,
			0xac, 0xb4, 0xa2, 0x7b, 0x25, 0xf3, 0x74, 0x52,
			0x68, 0xa1, 0x48, 0xfd, 0xfa, 0x96, 0xd7, 0x58,
			0x80, 0xa1, 0x65, 0x24, 0x18, 0x0c, 0x34, 0x2d,
			0x99, 0x98, 0x93, 0x1d, 0x06, 0x20, 0xa2, 0xda,
			0x76, 0x8d, 0x36, 0xf6, 0x29, 0x09, 0xc8, 0x13,
			0x52, 0xbe, 0x4f, 0x90, 0x6d, 0x55, 0x38, 0x4c,
			0xc1, 0x9a, 0x6f, 0xd9, 0x4e, 0xd0, 0xa3, 0x80,
			0x6f, 0x5a, 0x69, 0x73, 0xe1, 0x27, 0x8a, 0x48,
			0x6d, 0x14, 0xf8, 0x7a, 0x6d, 0xf6, 0xa5, 0xc3,
			0x03, 0xab, 0xd4, 0xf3, 0x41, 0x20, 0xcd, 0x07,
			0x18, 0x30, 0x4c, 0x0b, 0xf7, 0x75, 0x6a, 0x31,
			0x40, 0x24, 0x31, 0x3f, 0xe7, 0xf8, 0x44, 0x91,
			0xa0, 0x6c, 0xf8, 0x93, 0x80, 0x5c, 0x8a, 0x06,
			0xde, 0xd9, 0x58, 0xb2, 0x9e, 0x6d, 0xdd, 0xf1,
			0x3c, 0x8b, 0x8b, 0x2a, 0x95, 0xfa, 0x0d, 0x0f,
			0x88, 0x35, 0x12, 0x83, 0x34, 0x69, 0xa8, 0xbe,
			0x62, 0x39, 0x5b, 0x01, 0x12, 0x41, 0xc3, 0x4b,
			0x3d, 0x19, 0x6c, 0x75, 0x23, 0x78, 0x03, 0x19,
		},
		20, /* salt length */
		/* V6 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA384 [7] */
	{
		/* Msg7 : 128 byte */
		{
			0x1b, 0x82, 0xfa, 0xfa, 0x76, 0x7b, 0x2f, 0x3a,
			0x51, 0x56, 0x9c, 0x3f, 0xa3, 0x7c, 0x11, 0x63,
			0xee, 0xbb, 0x3d, 0x6b, 0x71, 0xa1, 0x7e, 0x0c,
			0x9e, 0x28, 0xf8, 0xae, 0xce, 0x99, 0xe5, 0x6f,
			0x34, 0xaa, 0x2b, 0x6b, 0x0f, 0xe9, 0x34, 0x3b,
			0x24, 0x5e, 0xfa, 0xbb, 0x6c, 0x6c, 0x61, 0x10,
			0x0a, 0xf9, 0xca, 0xea, 0x7f, 0xcf, 0xe5, 0x07,
			0x21, 0x41, 0xc6, 0xf9, 0xca, 0x11, 0x3c, 0x28,
			0xcd, 0x91, 0x5e, 0x1a, 0x2e, 0x09, 0x66, 0xf2,
			0x12, 0x59, 0xc3, 0x37, 0x74, 0xdf, 0x69, 0xd7,
			0x1a, 0x9b, 0x6c, 0x6c, 0xc7, 0x91, 0xcd, 0xbd,
			0xb3, 0x6f, 0x94, 0x88, 0x38, 0x70, 0x1e, 0x7f,
			0xce, 0x80, 0xb9, 0x90, 0x39, 0xa1, 0x6e, 0x69,
			0x01, 0x8d, 0x1e, 0x3c, 0x23, 0x9d, 0xd1, 0xbf,
			0x06, 0xe9, 0x4a, 0x78, 0xb0, 0xb1, 0xdf, 0x37,
			0x3a, 0xfc, 0x87, 0xe4, 0x81, 0x7e, 0x35, 0x7a,
		},
		/* S7 : 256 byte */
		{
			0x36, 0xcd, 0x86, 0x63, 0x86, 0x9a, 0x5d, 0x06,
			0x25, 0x76, 0x5a, 0x3f, 0xa7, 0xf2, 0xc6, 0x8d,
			0x06, 0xc5, 0x2b, 0x1b, 0x63, 0x28, 0xb1, 0x84,
			0xe9, 0xe4, 0x17, 0xbb, 0x4a, 0xd0, 0xbd, 0x38,
			0x11, 0x12, 0xf9, 0xb5, 0x9d, 0x39, 0x10, 0xdc,
			0x08, 0x90, 0x6e, 0x6c, 0xea, 0xa6, 0x52, 0x2b,
			0xcb, 0x58, 0xda, 0xf5, 0x9d, 0x4e, 0x07, 0xc4,
			0x3d, 0xc0, 0xa7, 0xba, 0xec, 0xb8, 0x7e, 0xce,
			0x3e, 0x78, 0x98, 0x30, 0x5f, 0x9f, 0xeb, 0x4b,
			0xca, 0x10, 0x7c, 0x03, 0x87, 0x70, 0x9f, 0x7f,
			0xb9, 0x54, 0x5a, 0x6d, 0xaa, 0xec, 0x89, 0x38,
			0x95, 0xbd, 0x12, 0x7c, 0x12, 0x8f, 0x94, 0x49,
			0xab, 0x50, 0x8b, 0xfb, 0x3c, 0xe7, 0x8c, 0xc0,
			0x07, 0xfa, 0xbf, 0x11, 0xd9, 0xc4, 0xfc, 0x07,
			0x7c, 0xa5, 0xe0, 0x63, 0xf3, 0x06, 0xcd, 0xc0,
			0xd2, 0x29, 0xf6, 0x86, 0xee, 0x07, 0xe3, 0xc4,
			0x51, 0x37, 0x98, 0x7b, 0xfb, 0x78, 0xd2, 0xd6,
			0x2c, 0x92, 0x23, 0x8b, 0x9f, 0x3c, 0x60, 0xcf,
			0xe1, 0x6d, 0xdd, 0xdd, 0x85, 0x0e, 0x92, 0x95,
			0xe4, 0xdf, 0xa8, 0x12, 0xbd, 0x47, 0x10, 0x1b,
			0x9f, 0x3b, 0x30, 0x1c, 0x27, 0xb5, 0xef, 0x15,
			0x55, 0x45, 0x01, 0xfd, 0x61, 0xf8, 0xe7, 0x7e,
			0xf2, 0x89, 0x13, 0x52, 0x53, 0x9d, 0x4d, 0x4b,
			0x21, 0x34, 0x51, 0x0c, 0x2e, 0xb0, 0x9b, 0xec,
			0x25, 0x60, 0xc1, 0xda, 0x1f, 0x42, 0x0b, 0xaa,
			0x69, 0x9b, 0xb7, 0xb3, 0x5d, 0xe6, 0xfc, 0x7a,
			0xba, 0x55, 0x39, 0xd7, 0x43, 0x8c, 0x6b, 0xb2,
			0xc8, 0xaa, 0xe8, 0xdd, 0x6d, 0x90, 0x1f, 0x4e,
			0x86, 0x65, 0x43, 0x56, 0x81, 0x7e, 0x3c, 0xd9,
			0xff, 0xef, 0x2c, 0xc2, 0x55, 0x35, 0xd9, 0x7f,
			0x28, 0x3f, 0xdc, 0x15, 0x74, 0x1e, 0x88, 0xbe,
			0xfb, 0x54, 0x3b, 0x1b, 0xa9, 0x02, 0x80, 0xbf,
		},
		20, /* salt length */
		/* V7 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA384 [8] */
	{
		/* Msg8 : 128 byte */
		{
			0x59, 0xaf, 0xdd, 0xae, 0x5c, 0x62, 0xcc, 0x09,
			0x15, 0x1f, 0x22, 0xa0, 0xc3, 0xf4, 0x47, 0x8b,
			0x34, 0x48, 0x92, 0x15, 0x96, 0x63, 0xbc, 0x63,
			0x8b, 0x31, 0x95, 0x56, 0x7b, 0x42, 0xf5, 0xb1,
			0x2e, 0x16, 0xf6, 0x7f, 0x9a, 0x98, 0x60, 0xaf,
			0xf9, 0xe8, 0x65, 0x02, 0x1f, 0x5d, 0x8f, 0x27,
			0x0b, 0xcb, 0xf6, 0x24, 0xbc, 0x01, 0xb6, 0xf7,
			0x46, 0x96, 0xa0, 0x7d, 0x24, 0xe6, 0x30, 0x94,
			0xd0, 0x57, 0xbf, 0x7c, 0x91, 0xe1, 0xfa, 0x84,
			0x94, 0xcd, 0x93, 0xe2, 0x3f, 0xbc, 0x37, 0xe2,
			0xc2, 0xec, 0xbf, 0x43, 0xef, 0xb7, 0xaa, 0xdd,
			0x4b, 0x5c, 0xcb, 0x88, 0x65, 0x02, 0x3f, 0x3a,
			0x66, 0xfa, 0xa2, 0x6f, 0xea, 0x45, 0x82, 0xce,
			0x0e, 0x56, 0x14, 0x09, 0xca, 0x18, 0x26, 0x05,
			0x82, 0x33, 0x55, 0x3b, 0xd7, 0x8c, 0x80, 0x5e,
			0xc3, 0x0a, 0x7d, 0x3d, 0xe5, 0xa0, 0x0a, 0xec,
		},
		/* S8 : 256 byte */
		{
			0x23, 0x53, 0xa8, 0x70, 0x52, 0x1c, 0x1c, 0x22,
			0xd4, 0xf5, 0xda, 0x58, 0xf3, 0x6f, 0xc3, 0x34,
			0x88, 0xe4, 0x84, 0x08, 0xf1, 0x62, 0x4b, 0xe3,
			0xf3, 0x6f, 0x53, 0x6c, 0xa7, 0x7a, 0xb7, 0x92,
			0x35, 0x1f, 0x90, 0x46, 0x11, 0xfb, 0xcf, 0x0d,
			0x8d, 0x39, 0xd2, 0xfa, 0x7d, 0x16, 0x6b, 0x46,
			0xc9, 0xc1, 0x99, 0xc2, 0x4c, 0x72, 0x35, 0xcb,
			0x74, 0xe9, 0x97, 0x4f, 0x49, 0x40, 0x53, 0x4e,
			0x2d, 0x4e, 0x7d, 0x95, 0xa1, 0xa5, 0x19, 0x24,
			0x08, 0x9e, 0x78, 0x8a, 0x63, 0x1c, 0xdc, 0xd1,
			0x70, 0xc8, 0x2f, 0x11, 0xf4, 0xdc, 0x15, 0x5f,
			0x64, 0x21, 0x4b, 0x4a, 0x8e, 0x76, 0xb5, 0xea,
			0x31, 0x3f, 0x0c, 0x61, 0x0a, 0x52, 0xd2, 0x7e,
			0x13, 0x9a, 0x69, 0xbc, 0x49, 0x99, 0x56, 0x41,
			0x86, 0xbd, 0x47, 0xe6, 0xe7, 0x92, 0xe8, 0x43,
			0x71, 0x03, 0xee, 0x28, 0x58, 0x7f, 0x9f, 0x94,
			0x4f, 0xb7, 0x06, 0xb9, 0xc9, 0x09, 0xde, 0xc4,
			0xd6, 0x3a, 0xe6, 0x6b, 0x3e, 0xd9, 0x18, 0x1a,
			0x50, 0x50, 0xeb, 0x00, 0xca, 0xb0, 0x65, 0x76,
			0xb9, 0x6d, 0x49, 0x43, 0xa2, 0x51, 0xfa, 0xb4,
			0x3c, 0x71, 0x9b, 0xf7, 0x57, 0x78, 0xff, 0xc3,
			0x92, 0x2f, 0xa1, 0x57, 0x09, 0xca, 0xd2, 0xcd,
			0xca, 0x2c, 0xee, 0x58, 0x23, 0x7c, 0x60, 0x2a,
			0x57, 0xca, 0xc1, 0x43, 0xea, 0xc7, 0x3c, 0x26,
			0x4d, 0x1c, 0xe0, 0x7e, 0xd8, 0x82, 0x19, 0x40,
			0x0a, 0x8e, 0x02, 0x34, 0x6e, 0x02, 0x91, 0xc2,
			0xf3, 0xc1, 0xfc, 0x1b, 0x96, 0xae, 0x3a, 0x17,
			0x3d, 0xbe, 0x72, 0xd8, 0xe2, 0xd3, 0xba, 0xd4,
			0x9b, 0xfe, 0x6a, 0x45, 0x44, 0x00, 0xd9, 0x6d,
			0x00, 0x9a, 0xf0, 0x6a, 0x27, 0x9c, 0x56, 0xbf,
			0xd2, 0xa7, 0x1d, 0x34, 0x19, 0x12, 0xf9, 0x7b,
			0xb0, 0xd4, 0xc2, 0xa0, 0x6b, 0x17, 0x51, 0x8f,
		},
		20, /* salt length */
		/* V8 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA384 [9] */
	{
		/* Msg9 : 128 byte */
		{
			0xad, 0x55, 0x25, 0xd0, 0x2a, 0xf9, 0x25, 0x4a,
			0x8c, 0xa0, 0x09, 0x50, 0xa1, 0x31, 0x2d, 0xa3,
			0xb3, 0x19, 0x59, 0xb4, 0x01, 0xed, 0xdd, 0x66,
			0x71, 0x50, 0xe0, 0x14, 0x7f, 0x18, 0xf5, 0xd6,
			0x79, 0xac, 0xef, 0x00, 0xee, 0xb0, 0xf7, 0xec,
			0x64, 0xe5, 0xdb, 0xfa, 0x49, 0x4a, 0xa9, 0xd4,
			0x2c, 0x88, 0x7d, 0xf7, 0x2d, 0x8c, 0x97, 0x6f,
			0xb2, 0x76, 0xb0, 0xe1, 0x5c, 0xb2, 0x8e, 0xcf,
			0x3a, 0x64, 0xd7, 0x18, 0x3c, 0x0a, 0x23, 0xbe,
			0xea, 0x5d, 0x54, 0xec, 0x55, 0x77, 0x2a, 0x38,
			0x4e, 0x3b, 0x12, 0x25, 0xd7, 0xf2, 0x3f, 0xec,
			0xd7, 0x32, 0xfc, 0x7c, 0x12, 0x04, 0x41, 0xbf,
			0x57, 0x45, 0x84, 0x1f, 0xfb, 0x4d, 0xd1, 0x49,
			0x87, 0xcf, 0x1d, 0x30, 0xae, 0x00, 0xd8, 0x55,
			0x82, 0xfc, 0xc1, 0x47, 0xe7, 0x65, 0xfe, 0x65,
			0x47, 0x4d, 0x6c, 0xeb, 0x87, 0x56, 0x34, 0x2d,
		},
		/* S9 : 256 byte */
		{
			0x9b, 0x15, 0xd2, 0xb1, 0x0a, 0xc9, 0x27, 0x41,
			0xcf, 0xb4, 0x3f, 0x9c, 0x5d, 0x02, 0x75, 0xf9,
			0x05, 0x2b, 0xec, 0xbe, 0xa8, 0x56, 0xe6, 0xa3,
			0x92, 0x7e, 0xe7, 0xa8, 0x13, 0xd0, 0x55, 0x58,
			0x1b, 0xf5, 0xfe, 0x05, 0x77, 0x66, 0x10, 0xf9,
			0xda, 0x1b, 0x78, 0xdd, 0x7e, 0x68, 0x6a, 0x23,
			0x74, 0x98, 0x67, 0x2f, 0xad, 0xbb, 0x98, 0x9d,
			0xc6, 0x71, 0xc9, 0x44, 0x9c, 0x91, 0x9a, 0x85,
			0x0a, 0x05, 0x43, 0xe1, 0x08, 0x42, 0x84, 0xee,
			0x27, 0x7d, 0xd5, 0xa4, 0x40, 0x74, 0xfd, 0x7f,
			0xb5, 0x88, 0x12, 0x5b, 0x25, 0x9f, 0xa6, 0x7a,
			0x04, 0x06, 0x0d, 0x7d, 0x7e, 0xd9, 0x46, 0x9a,
			0xc1, 0x1a, 0x54, 0xd3, 0x69, 0x27, 0xc5, 0x2f,
			0xdc, 0x21, 0xd3, 0xa6, 0xeb, 0x54, 0x3e, 0xb3,
			0x81, 0x1a, 0x13, 0xc4, 0x3f, 0x77, 0xfd, 0x96,
			0xea, 0xe6, 0xf2, 0x7e, 0x71, 0x99, 0x11, 0x52,
			0x73, 0xeb, 0x47, 0x72, 0x3d, 0x19, 0xe2, 0x33,
			0xce, 0xc8, 0x9f, 0x3d, 0x02, 0xda, 0xfd, 0xa4,
			0x8f, 0x42, 0xba, 0x2e, 0xa2, 0x93, 0xe2, 0x09,
			0x47, 0x40, 0xf4, 0x16, 0x07, 0xc2, 0x9d, 0xf4,
			0x2f, 0xa4, 0x6d, 0xd7, 0xcc, 0x72, 0x7c, 0xea,
			0xfb, 0xb2, 0x5a, 0x85, 0x42, 0x43, 0x0c, 0xdb,
			0x52, 0xef, 0x62, 0x59, 0x34, 0x14, 0xd8, 0x18,
			0xcc, 0x29, 0x83, 0x56, 0x5d, 0x1c, 0xf4, 0x72,
			0x7d, 0x68, 0x13, 0x6d, 0x42, 0x01, 0x8b, 0x8a,
			0x70, 0x59, 0x7d, 0x99, 0x3f, 0xc4, 0x3e, 0x6b,
			0xfd, 0x88, 0x84, 0x22, 0xd9, 0x49, 0x0f, 0xcb,
			0x38, 0x05, 0x07, 0xf2, 0x2f, 0xdc, 0xde, 0x96,
			0xcf, 0x8f, 0xed, 0xd8, 0x87, 0x91, 0xcb, 0x99,
			0xd3, 0xdd, 0x29, 0x7f, 0xb9, 0xe7, 0xc0, 0xdb,
			0x37, 0xe8, 0x7b, 0x76, 0x00, 0x32, 0x4b, 0x90,
			0x05, 0x31, 0x39, 0x8d, 0x58, 0x4e, 0xf9, 0x94,
		},
		20, /* salt length */
		/* V9 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
};

/* 10 elements */
static mod2048_t SHA512[] = {
	/* SHA512 [0] */
	{
		/* Msg0 : 128 byte */
		{
			0x25, 0x24, 0x33, 0xd4, 0xb7, 0x2a, 0x33, 0xe1,
			0xaa, 0x44, 0x4a, 0xa9, 0x68, 0x04, 0x54, 0xe9,
			0xcd, 0xab, 0x20, 0x86, 0x37, 0xec, 0x21, 0x73,
			0xdc, 0xf3, 0x66, 0xd5, 0x61, 0xa6, 0xcc, 0x65,
			0xa8, 0x2b, 0x73, 0x16, 0xe9, 0xaa, 0x6e, 0xf9,
			0x04, 0x54, 0xbf, 0x5d, 0x15, 0xa4, 0x82, 0x3a,
			0x49, 0xe4, 0x68, 0xd0, 0xf1, 0xf4, 0x67, 0x8b,
			0xd5, 0x47, 0xb0, 0x2a, 0xcb, 0x2e, 0xe2, 0x20,
			0x88, 0x59, 0x7d, 0x3a, 0xb5, 0x9a, 0x99, 0x83,
			0x46, 0xed, 0xd8, 0x65, 0x07, 0xb6, 0x99, 0x10,
			0x77, 0x49, 0x6e, 0x20, 0xda, 0xaf, 0xd1, 0x79,
			0x8a, 0xa8, 0x12, 0x76, 0x8e, 0xec, 0x94, 0x44,
			0x6d, 0xb6, 0x39, 0x88, 0x44, 0x83, 0x1b, 0x48,
			0x17, 0x17, 0x7d, 0x08, 0x65, 0xc2, 0x01, 0x33,
			0xff, 0xe1, 0x1b, 0xbd, 0x1a, 0xa7, 0xc5, 0x07,
			0xa2, 0x1e, 0x74, 0x03, 0xd1, 0x68, 0x4b, 0x98,
		},
		/* S0 : 256 byte */
		{
			0x2c, 0xdb, 0x0d, 0x5e, 0xa5, 0xf0, 0xaa, 0xd1,
			0xf7, 0xaf, 0x81, 0x08, 0xbf, 0xf5, 0x6e, 0xec,
			0x5c, 0x0d, 0xcd, 0x05, 0x22, 0xc5, 0xdc, 0x6a,
			0xe4, 0xc6, 0xe0, 0xf6, 0x68, 0x21, 0xcd, 0xf6,
			0x98, 0xcc, 0xfe, 0xac, 0xe6, 0x5f, 0xd6, 0xe4,
			0x7f, 0x95, 0xfe, 0xbd, 0x87, 0x9e, 0x58, 0x0e,
			0x5e, 0xe6, 0x48, 0x97, 0x2c, 0xc2, 0x65, 0xf9,
			0xa1, 0x17, 0xfc, 0x72, 0x0d, 0xb4, 0xf2, 0x54,
			0x5a, 0x43, 0x2e, 0xae, 0x24, 0xa3, 0x67, 0xb0,
			0xaa, 0xa7, 0x0a, 0x01, 0x1a, 0xc8, 0xfd, 0xec,
			0x94, 0xa9, 0x5c, 0x3c, 0xd4, 0x8c, 0xfa, 0x71,
			0x02, 0xde, 0x8d, 0xc2, 0x6c, 0x87, 0x7e, 0x97,
			0x46, 0x88, 0xb3, 0x91, 0x9d, 0xe6, 0xcf, 0x06,
			0xe2, 0x70, 0x28, 0x99, 0x5a, 0xc8, 0x5d, 0xa8,
			0x8c, 0xb3, 0x85, 0x1a, 0x57, 0x61, 0xe1, 0x7f,
			0x21, 0x5e, 0x5c, 0x59, 0x3e, 0x13, 0xe4, 0x81,
			0x08, 0x8c, 0x7d, 0x74, 0x7e, 0xcb, 0x34, 0xd3,
			0xce, 0x61, 0xa5, 0xb5, 0x6e, 0xb2, 0xa6, 0x5b,
			0xe5, 0x36, 0x33, 0x63, 0x29, 0x4e, 0xb3, 0x65,
			0xf8, 0x3c, 0x4c, 0x70, 0x96, 0x44, 0xd8, 0x57,
			0xe2, 0xcc, 0xb1, 0x4a, 0x58, 0x51, 0x72, 0x44,
			0x20, 0xfc, 0x81, 0x17, 0x81, 0x44, 0xef, 0x3f,
			0x9e, 0x11, 0x38, 0xb5, 0x75, 0x0e, 0xb7, 0x19,
			0x6e, 0xba, 0x33, 0x19, 0xd7, 0x99, 0xc3, 0x49,
			0x4a, 0x7e, 0x39, 0x91, 0x15, 0xa6, 0x2b, 0x1c,
			0xa4, 0xf1, 0xd5, 0xda, 0x07, 0x9b, 0x49, 0x5d,
			0x35, 0xfd, 0x65, 0x1a, 0x1d, 0xe7, 0x8d, 0x54,
			0x00, 0x0b, 0x06, 0xbd, 0xd3, 0x12, 0x2d, 0x74,
			0x04, 0x01, 0x3f, 0x2e, 0xd8, 0xfd, 0xf8, 0xa7,
			0xd0, 0x12, 0xf9, 0x81, 0x2b, 0x8e, 0x4c, 0x2e,
			0x0b, 0x24, 0x19, 0x2d, 0x5f, 0x89, 0x9d, 0x70,
			0xa3, 0xcc, 0x5c, 0x7e, 0x08, 0xc8, 0x1b, 0xe7,
		},
		20, /* salt length */
		/* V0 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA512 [1] */
	{
		/* Msg1 : 128 byte */
		{
			0xbf, 0x6a, 0x85, 0x4e, 0x58, 0xf8, 0x0f, 0x59,
			0x80, 0xec, 0x31, 0x32, 0x6e, 0xec, 0x0e, 0x46,
			0x73, 0x5a, 0x8f, 0xa7, 0xe9, 0x78, 0xfa, 0x51,
			0x66, 0xd0, 0xc7, 0xb1, 0x35, 0xd3, 0xaf, 0x68,
			0x06, 0xc0, 0x05, 0x4c, 0xe4, 0xc7, 0x49, 0xaf,
			0x68, 0x6f, 0xfb, 0xe5, 0x2c, 0x35, 0xad, 0x00,
			0x83, 0x75, 0x5c, 0xde, 0x67, 0x8e, 0x00, 0x66,
			0xb3, 0x42, 0x62, 0x0e, 0x93, 0x5b, 0x2e, 0xa0,
			0x38, 0x94, 0x49, 0x3f, 0xd0, 0xb6, 0x64, 0xa5,
			0xb5, 0x02, 0xd2, 0xae, 0xe4, 0xcf, 0x96, 0x1a,
			0xb2, 0x74, 0xc1, 0x8e, 0xba, 0x68, 0xfb, 0xdd,
			0x1a, 0xa8, 0x5f, 0x86, 0xdf, 0x59, 0x8c, 0x7e,
			0xbd, 0xaf, 0xf8, 0x2f, 0x04, 0x0d, 0x88, 0xc0,
			0xcf, 0x6e, 0x5e, 0x97, 0x7e, 0x03, 0xf3, 0x1c,
			0x67, 0x1d, 0x65, 0xc0, 0xc9, 0x4e, 0x12, 0x3f,
			0x01, 0xcb, 0x65, 0x21, 0x01, 0x15, 0xf0, 0x87,
		},
		/* S1 : 256 byte */
		{
			0x1e, 0x57, 0x38, 0x12, 0x7c, 0x90, 0x77, 0xe1,
			0x6b, 0xae, 0xd9, 0x7b, 0x37, 0xa2, 0x92, 0x69,
			0x5a, 0x96, 0x31, 0x65, 0x2d, 0x76, 0x1d, 0x42,
			0xb3, 0x45, 0x2e, 0x42, 0x0e, 0xbc, 0x86, 0xa1,
			0x1a, 0xa5, 0x94, 0x94, 0x49, 0x01, 0x56, 0xf1,
			0x85, 0xf1, 0xd0, 0x9a, 0xea, 0x30, 0xb1, 0xc9,
			0xf7, 0xa1, 0x9e, 0xe0, 0x67, 0x36, 0x7e, 0x02,
			0xb0, 0x19, 0x8c, 0xb2, 0x8c, 0xf7, 0x9c, 0xea,
			0xc2, 0x0c, 0x8f, 0x66, 0x7a, 0xc0, 0xbf, 0x99,
			0x35, 0x9d, 0x96, 0xd3, 0xa4, 0xd2, 0xd4, 0x5e,
			0x8b, 0x72, 0x5d, 0x0f, 0x8b, 0xae, 0xfd, 0x94,
			0x03, 0x01, 0xe7, 0xaa, 0xd4, 0x20, 0x20, 0x38,
			0xb9, 0xf7, 0x1c, 0xfd, 0xdf, 0xb0, 0x18, 0x83,
			0x4e, 0x8b, 0xa6, 0xdf, 0x19, 0x6e, 0xd4, 0xb3,
			0x2f, 0x01, 0x08, 0x2c, 0xaa, 0xba, 0xa1, 0x09,
			0x12, 0xbe, 0x5d, 0xfb, 0x1d, 0x05, 0xe7, 0x98,
			0x9f, 0xbc, 0xa3, 0x12, 0xf0, 0x5c, 0x32, 0x49,
			0x94, 0x2d, 0x9d, 0x49, 0x04, 0xfe, 0xf8, 0x48,
			0x1d, 0x99, 0x41, 0x78, 0xc1, 0x20, 0x3d, 0xb4,
			0xdc, 0xf8, 0x1d, 0x34, 0x6f, 0xbd, 0xf0, 0x51,
			0x6c, 0x1f, 0x2e, 0x45, 0xea, 0x53, 0xdd, 0xea,
			0x0b, 0x65, 0xba, 0x62, 0x29, 0x14, 0xce, 0xb0,
			0xc5, 0x29, 0xd0, 0xb1, 0x11, 0x8d, 0x28, 0xc9,
			0x1c, 0xf8, 0xda, 0xc3, 0x87, 0x4f, 0x28, 0xa7,
			0x1a, 0x4c, 0x5e, 0xc5, 0xfb, 0xa2, 0x78, 0x02,
			0xd6, 0x33, 0x26, 0x23, 0x92, 0x4e, 0x3e, 0x44,
			0x2d, 0x1a, 0x10, 0x20, 0x5c, 0x3e, 0x41, 0x5b,
			0x21, 0xc0, 0xe0, 0x26, 0x57, 0xb4, 0x47, 0x06,
			0xf8, 0x3a, 0xe1, 0x17, 0xcc, 0x2c, 0x3c, 0x53,
			0x31, 0x24, 0x72, 0x14, 0x1d, 0x4c, 0xd0, 0x9e,
			0xef, 0x75, 0x0d, 0xd6, 0x87, 0x08, 0x3c, 0x8b,
			0xb6, 0xce, 0xbc, 0xd0, 0xca, 0x32, 0x74, 0xd4,
		},
		20, /* salt length */
		/* V1 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA512 [2] */
	{
		/* Msg2 : 128 byte */
		{
			0x87, 0x7c, 0xd6, 0x8a, 0xd3, 0xbd, 0xe4, 0x2b,
			0xce, 0x71, 0x15, 0xed, 0xca, 0xf4, 0x69, 0xa0,
			0xeb, 0x28, 0x44, 0xe4, 0xdb, 0x60, 0xc4, 0x33,
			0xc0, 0x7c, 0x52, 0x22, 0x6b, 0x55, 0x77, 0xe3,
			0xd2, 0x5b, 0xf1, 0x0f, 0xc1, 0x7c, 0x07, 0xa2,
			0xcc, 0x48, 0x19, 0x48, 0x88, 0x53, 0x7b, 0xd7,
			0xfb, 0xdb, 0x84, 0x1c, 0x50, 0xab, 0xe1, 0xda,
			0xcf, 0x3f, 0x2f, 0x10, 0x0d, 0x29, 0xca, 0x7b,
			0x60, 0xb4, 0xdf, 0x5c, 0x96, 0xc6, 0xc9, 0x7b,
			0xe7, 0x0b, 0x9a, 0x6c, 0x27, 0x4f, 0xf7, 0x11,
			0x41, 0x2c, 0x2a, 0x60, 0xe0, 0xe6, 0x72, 0x66,
			0x6f, 0x93, 0x9d, 0x8c, 0x44, 0x7f, 0xd9, 0x1a,
			0x18, 0xce, 0xc8, 0xf9, 0xbb, 0x63, 0xd2, 0xbd,
			0x05, 0x01, 0xbf, 0xe3, 0x10, 0xb0, 0x85, 0x56,
			0xa4, 0x63, 0x5e, 0x38, 0xf3, 0xd7, 0x1e, 0xe0,
			0x87, 0xbe, 0xc4, 0x1f, 0x78, 0x1d, 0x4f, 0xc8,
		},
		/* S2 : 256 byte */
		{
			0x99, 0xd6, 0x85, 0x03, 0xef, 0x2e, 0xb8, 0x44,
			0xe3, 0x4b, 0xdc, 0x74, 0x6f, 0xff, 0xce, 0xd9,
			0x40, 0x47, 0x1c, 0x9f, 0x9e, 0x87, 0xfe, 0xef,
			0x2d, 0x87, 0xb7, 0x94, 0xf1, 0x16, 0x2e, 0x1d,
			0xcd, 0xd3, 0xbf, 0x0b, 0x49, 0x69, 0x6e, 0x9a,
			0xd8, 0x3f, 0x4d, 0x85, 0x43, 0x2d, 0x78, 0x61,
			0xb2, 0x6b, 0x83, 0x10, 0x99, 0x70, 0xf6, 0xf2,
			0x7b, 0x89, 0x07, 0x0c, 0x81, 0xe8, 0xa9, 0x77,
			0xdd, 0xe5, 0x8d, 0xfc, 0x9c, 0x23, 0xde, 0xef,
			0x5e, 0xe1, 0x9f, 0x91, 0x88, 0x1c, 0xf5, 0xca,
			0x70, 0xff, 0xda, 0x01, 0x9b, 0x71, 0xfa, 0x9b,
			0x32, 0x0f, 0xe2, 0x4d, 0x0c, 0x0b, 0x3b, 0xf1,
			0xc7, 0x91, 0x67, 0xf4, 0xaa, 0x95, 0x7d, 0xc4,
			0x33, 0x97, 0xc2, 0xc5, 0x10, 0xf0, 0xaf, 0x89,
			0x65, 0xa4, 0xbe, 0x6b, 0x1e, 0x30, 0xa1, 0x46,
			0xeb, 0x4f, 0xa4, 0x95, 0xa0, 0xa6, 0xd8, 0xa8,
			0x46, 0x6c, 0xec, 0x41, 0xc1, 0x8e, 0xa8, 0x84,
			0x00, 0xeb, 0x9d, 0xcb, 0x99, 0xc7, 0x2d, 0x6f,
			0x41, 0x90, 0xf6, 0xee, 0x82, 0x52, 0xf8, 0x12,
			0xe9, 0xdb, 0xf2, 0x0c, 0x65, 0x11, 0xa1, 0xb2,
			0x4b, 0x97, 0x65, 0x85, 0x71, 0x6e, 0x26, 0x59,
			0xd4, 0xbd, 0xef, 0x2c, 0x38, 0xce, 0x5c, 0xab,
			0x02, 0xd5, 0xf2, 0x1b, 0x71, 0xd3, 0x93, 0xae,
			0x52, 0x28, 0x6f, 0x60, 0x62, 0xa4, 0xfd, 0xde,
			0xbf, 0x34, 0x5d, 0x95, 0x51, 0xa0, 0x4a, 0xe3,
			0x0e, 0xc7, 0xf7, 0x43, 0x95, 0x25, 0x7a, 0x2c,
			0x88, 0x81, 0xd7, 0xea, 0x19, 0x0c, 0x9c, 0x79,
			0xd9, 0xf4, 0x6f, 0xea, 0x04, 0x41, 0xd8, 0x68,
			0xda, 0x84, 0x2d, 0xcf, 0xda, 0x84, 0x97, 0x95,
			0x2b, 0xfa, 0x91, 0xeb, 0xfb, 0x8e, 0x9c, 0x6d,
			0x2a, 0x3e, 0xd9, 0xc1, 0xb5, 0x5b, 0x7e, 0xb6,
			0x71, 0x14, 0xc3, 0x87, 0xc8, 0x0d, 0x2b, 0x31,
		},
		20, /* salt length */
		/* V2 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA512 [3] */
	{
		/* Msg3 : 128 byte */
		{
			0x98, 0x7f, 0xd5, 0x68, 0xdb, 0x29, 0xbf, 0x30,
			0x2e, 0x70, 0x6a, 0xed, 0x05, 0x07, 0x8f, 0xfc,
			0x93, 0x67, 0x93, 0xc9, 0xeb, 0x67, 0xc0, 0xfb,
			0x65, 0x0c, 0xd6, 0xeb, 0x43, 0xa2, 0xc2, 0x5b,
			0x94, 0x0b, 0xad, 0x65, 0x59, 0x58, 0x38, 0xb1,
			0xe7, 0x96, 0x06, 0xeb, 0x8c, 0xea, 0x7c, 0x74,
			0x75, 0xe1, 0xc4, 0x58, 0xcf, 0x01, 0x18, 0x81,
			0x2d, 0xa4, 0x3d, 0x2a, 0x2a, 0x06, 0x4d, 0x96,
			0x4f, 0x9c, 0xba, 0x01, 0x37, 0xa7, 0x90, 0xd7,
			0xf0, 0x0a, 0xfa, 0x24, 0xa5, 0x58, 0x08, 0x4b,
			0x7a, 0x32, 0xaf, 0xfc, 0xb8, 0xd0, 0x12, 0x60,
			0x2a, 0xdd, 0xff, 0x96, 0xc7, 0x88, 0xbd, 0x63,
			0x90, 0xd8, 0x05, 0x25, 0xbc, 0x3f, 0x4e, 0x09,
			0x13, 0x73, 0x4e, 0x7e, 0x98, 0x79, 0xbd, 0xea,
			0x6a, 0x02, 0x5c, 0x9b, 0xec, 0xfb, 0x36, 0x00,
			0x24, 0x60, 0x25, 0x19, 0x61, 0x51, 0x99, 0x2c,
		},
		/* S3 : 256 byte */
		{
			0x65, 0xda, 0xe5, 0x7f, 0x88, 0xc3, 0x60, 0x5a,
			0x5e, 0xda, 0x93, 0x58, 0xce, 0x0d, 0x76, 0x69,
			0x70, 0xbd, 0x74, 0x76, 0x93, 0xb8, 0xcd, 0x6e,
			0xe8, 0x6f, 0xce, 0x07, 0xdb, 0x4b, 0x98, 0x2e,
			0x25, 0xde, 0x0c, 0x4d, 0x59, 0xb1, 0xd3, 0x32,
			0x70, 0x38, 0xf3, 0x55, 0x8e, 0xc3, 0x3b, 0xe6,
			0x50, 0xdf, 0x11, 0x31, 0x9f, 0x8b, 0x15, 0x3f,
			0x01, 0xf4, 0x06, 0x3e, 0x01, 0xa8, 0xca, 0xa5,
			0x5f, 0x96, 0x35, 0xdb, 0x8c, 0xe9, 0x58, 0x85,
			0xce, 0xc4, 0xf2, 0x02, 0x86, 0x4b, 0xf4, 0x71,
			0xf6, 0xd6, 0x65, 0x17, 0x82, 0x1f, 0x1d, 0x7a,
			0x12, 0x56, 0x80, 0x8b, 0xe5, 0x07, 0x4d, 0x25,
			0x86, 0x88, 0xdc, 0x1b, 0xb1, 0x60, 0xf8, 0x90,
			0x36, 0xea, 0x77, 0xcf, 0xfc, 0x15, 0x49, 0xcd,
			0x92, 0x45, 0xd7, 0x8f, 0x0e, 0xb8, 0x40, 0x59,
			0x0c, 0x1e, 0xf3, 0xe8, 0x2d, 0x7f, 0xd3, 0x28,
			0xa4, 0xc0, 0x05, 0xa4, 0x07, 0x0d, 0x1b, 0xf9,
			0x05, 0x0d, 0xbc, 0xff, 0x51, 0xe6, 0x9b, 0x88,
			0x5c, 0xe9, 0x78, 0x2b, 0x2b, 0x5d, 0x27, 0xa6,
			0x63, 0x4f, 0xb7, 0x07, 0xb6, 0x0d, 0x4a, 0xca,
			0x7f, 0x7d, 0xf9, 0x52, 0x60, 0x47, 0x56, 0xbb,
			0xb8, 0xb9, 0x75, 0x37, 0x70, 0xab, 0x75, 0x99,
			0x9c, 0x67, 0xb5, 0x35, 0xc8, 0xc0, 0xec, 0x3a,
			0xff, 0x6e, 0xf5, 0xe9, 0xc7, 0x7d, 0x9b, 0xf2,
			0x3a, 0xaf, 0x67, 0x08, 0x64, 0x3c, 0xf9, 0xb2,
			0x9e, 0x06, 0x1e, 0xa2, 0xcc, 0xc1, 0x47, 0x4d,
			0x7b, 0xa4, 0x97, 0x33, 0xe4, 0x00, 0xbe, 0x21,
			0x63, 0x62, 0xd9, 0xe7, 0x4d, 0x7c, 0xe4, 0xf7,
			0xd3, 0x29, 0x55, 0x26, 0x30, 0xb2, 0x7b, 0xd9,
			0x47, 0x36, 0x54, 0x88, 0xf8, 0xc0, 0xe5, 0xa8,
			0x19, 0x5f, 0x03, 0xe0, 0x71, 0xfd, 0x89, 0x51,
			0xe8, 0x23, 0xac, 0x2e, 0x1e, 0xb1, 0x86, 0xce,
		},
		20, /* salt length */
		/* V3 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA512 [4] */
	{
		/* Msg4 : 128 byte */
		{
			0x1d, 0x30, 0x8f, 0x1e, 0x20, 0xfa, 0xfc, 0xb7,
			0xf4, 0xe0, 0x60, 0x84, 0xe1, 0x5e, 0x5a, 0x76,
			0xa3, 0x8c, 0xb4, 0x06, 0x63, 0x42, 0xf0, 0x76,
			0xe6, 0x7f, 0x23, 0x59, 0x05, 0x0c, 0x07, 0x55,
			0x5d, 0x5c, 0x4b, 0x28, 0x47, 0xb7, 0x2d, 0xe9,
			0x0b, 0x98, 0x4b, 0x90, 0x50, 0x53, 0xb6, 0xb9,
			0xd7, 0xfa, 0x49, 0xa5, 0x69, 0x82, 0x39, 0x82,
			0x0e, 0x22, 0xec, 0xec, 0x80, 0xfc, 0x0f, 0xb3,
			0xdf, 0xff, 0xe3, 0xdf, 0xa6, 0x0c, 0xd7, 0xf1,
			0xde, 0x57, 0x5c, 0x6c, 0x92, 0x11, 0xf5, 0x94,
			0x82, 0x44, 0x8d, 0x76, 0x1b, 0xfe, 0x0e, 0x28,
			0xa7, 0xb1, 0x2f, 0x52, 0xc2, 0xda, 0x8e, 0xed,
			0x0d, 0xe1, 0xfe, 0x4b, 0x26, 0x40, 0x22, 0x58,
			0xd7, 0xe8, 0x3b, 0x1f, 0x8d, 0xe0, 0x3e, 0x90,
			0x0c, 0x30, 0x2a, 0x80, 0x62, 0xfd, 0x98, 0xf1,
			0x19, 0xf5, 0x93, 0x94, 0xb1, 0xee, 0xab, 0x8c,
		},
		/* S4 : 256 byte */
		{
			0xc5, 0x43, 0x44, 0x9a, 0x58, 0x08, 0x74, 0x51,
			0xd6, 0x91, 0x04, 0x84, 0xc7, 0x29, 0xa9, 0x86,
			0xe5, 0x4d, 0x9b, 0x90, 0xc1, 0xc8, 0x7a, 0xa5,
			0x2c, 0x60, 0xed, 0xf1, 0xe0, 0x2e, 0x59, 0x75,
			0x19, 0xc2, 0x5a, 0x8f, 0xd0, 0xff, 0xd2, 0x34,
			0xc6, 0xd0, 0x1b, 0xaf, 0x1a, 0xc6, 0xd3, 0x8c,
			0x5a, 0x17, 0x7d, 0x88, 0x12, 0xd2, 0x5a, 0x08,
			0x48, 0x92, 0xde, 0x0a, 0x4f, 0xb6, 0xed, 0xaf,
			0x20, 0xcc, 0x27, 0x79, 0x67, 0x95, 0xb5, 0xa6,
			0x28, 0x85, 0x22, 0xb7, 0xc1, 0xb3, 0xc4, 0x20,
			0x85, 0x6b, 0xf1, 0xc4, 0xeb, 0xc3, 0x1c, 0x29,
			0xd8, 0x7c, 0xa9, 0xd1, 0x9c, 0x54, 0x8e, 0x69,
			0x32, 0xe3, 0xf1, 0x34, 0x54, 0xc2, 0x28, 0x9d,
			0xf9, 0x51, 0x2f, 0x1e, 0x15, 0xc9, 0xba, 0x0c,
			0x00, 0xe4, 0x9f, 0xa0, 0x47, 0x8d, 0x4c, 0x98,
			0xcf, 0x0b, 0x88, 0x1b, 0xcd, 0xd1, 0x3e, 0x6c,
			0xb7, 0x00, 0xbe, 0xe3, 0x48, 0xb5, 0xf6, 0x44,
			0x18, 0x91, 0xcc, 0x7b, 0x54, 0xc3, 0x2e, 0xfc,
			0xeb, 0x4c, 0x3b, 0x80, 0xc1, 0x38, 0xcf, 0x76,
			0x49, 0xc9, 0xa9, 0x74, 0x48, 0x04, 0x3d, 0x2c,
			0xbd, 0x0a, 0xf5, 0x83, 0x7b, 0xf3, 0x0f, 0xfc,
			0xc5, 0x47, 0x1f, 0xf2, 0x63, 0x1e, 0xe7, 0xc4,
			0x95, 0xaa, 0x16, 0xe9, 0x19, 0x57, 0xec, 0x05,
			0x66, 0x97, 0x4c, 0xf8, 0x69, 0x16, 0x19, 0xc9,
			0xed, 0x4a, 0x6c, 0x57, 0x3e, 0x26, 0x0b, 0x05,
			0xc3, 0xff, 0x35, 0x9c, 0xcd, 0xa7, 0xd0, 0xe7,
			0x52, 0x2d, 0x6f, 0x94, 0x88, 0xbc, 0xe2, 0xf3,
			0x9a, 0x7d, 0x3b, 0x50, 0xcc, 0x70, 0x55, 0xdf,
			0x74, 0xaf, 0x9f, 0xc3, 0x76, 0x93, 0x91, 0xc4,
			0xbc, 0xb1, 0xed, 0x54, 0xd4, 0xbd, 0x3a, 0xe9,
			0x2d, 0x0d, 0x75, 0x13, 0xe8, 0x3e, 0x6a, 0xd6,
			0x87, 0x1f, 0xe9, 0x5f, 0xd6, 0xfa, 0xc1, 0xba,
		},
		20, /* salt length */
		/* V4 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA512 [5] */
	{
		/* Msg5 : 128 byte */
		{
			0x03, 0xc3, 0x3c, 0x52, 0x7a, 0xf8, 0x0f, 0xbf,
			0xc1, 0xb7, 0x4f, 0xcd, 0x77, 0x3b, 0x1a, 0xaa,
			0x60, 0x41, 0x06, 0x2a, 0x4f, 0x61, 0x1e, 0xbd,
			0x49, 0x9d, 0x28, 0x9f, 0xe7, 0x3b, 0x2a, 0x4e,
			0xfc, 0xd0, 0x2c, 0x41, 0x78, 0x9e, 0x3e, 0xd7,
			0x8c, 0x1f, 0xbd, 0x8e, 0x0f, 0xe2, 0xd3, 0x75,
			0x21, 0x96, 0x3d, 0xe4, 0x0e, 0x65, 0x51, 0x6a,
			0x75, 0x83, 0x3f, 0x07, 0xa9, 0x06, 0x97, 0x9b,
			0x57, 0xf8, 0x0b, 0x9f, 0x69, 0xaa, 0x77, 0x13,
			0x2b, 0x4c, 0x1e, 0xb7, 0xac, 0xbb, 0x36, 0x7e,
			0x68, 0x9a, 0xa8, 0x40, 0x23, 0xa4, 0x11, 0xaf,
			0x18, 0x40, 0x0c, 0x8c, 0x53, 0x56, 0xb3, 0x1b,
			0x5c, 0x62, 0x63, 0xd4, 0x15, 0xc7, 0xc0, 0x5b,
			0xe5, 0x65, 0xf9, 0xb2, 0x16, 0x6d, 0x4e, 0xae,
			0x7c, 0x74, 0xcf, 0xa7, 0x58, 0xc7, 0x66, 0x74,
			0x7b, 0xff, 0x17, 0x96, 0xaf, 0xd5, 0x87, 0xb4,
		},
		/* S5 : 256 byte */
		{
			0x17, 0x10, 0x24, 0xe6, 0x94, 0x76, 0xd7, 0xf9,
			0x44, 0x52, 0x44, 0xd4, 0xf0, 0xe7, 0x89, 0xe6,
			0xe8, 0xf1, 0x1d, 0x44, 0xd7, 0x03, 0xd6, 0x70,
			0xca, 0x5f, 0xcf, 0x0a, 0x1a, 0x49, 0x8b, 0x42,
			0x01, 0xaa, 0x72, 0xa7, 0xdb, 0xf8, 0x5c, 0xbd,
			0x9f, 0x52, 0x3e, 0x6b, 0x9c, 0x3d, 0x63, 0x43,
			0x27, 0xca, 0x85, 0x11, 0x91, 0xc8, 0x17, 0x2c,
			0x98, 0xea, 0x92, 0xcb, 0xa2, 0x68, 0x2a, 0x74,
			0xa2, 0x30, 0xec, 0x72, 0xb0, 0x5d, 0xfd, 0xcd,
			0xa4, 0x8b, 0x54, 0xf1, 0x21, 0xf3, 0xb0, 0xb9,
			0x61, 0x1c, 0x34, 0x28, 0x4b, 0x9e, 0x57, 0xab,
			0xbe, 0x7a, 0x95, 0xbb, 0x39, 0x46, 0xc8, 0xc4,
			0x26, 0x36, 0xb3, 0x95, 0xce, 0xa2, 0x95, 0x43,
			0xe3, 0xdb, 0xc3, 0xa0, 0xb7, 0xd0, 0x29, 0x83,
			0xf2, 0x15, 0xde, 0xb5, 0xcd, 0x7a, 0x4c, 0x83,
			0xe8, 0xc9, 0x5a, 0x88, 0xe7, 0x7e, 0x5e, 0xdf,
			0x34, 0x24, 0xa7, 0x7e, 0xda, 0xe3, 0x26, 0xfc,
			0x73, 0x77, 0x46, 0xf3, 0xe4, 0x40, 0x85, 0x5d,
			0xde, 0xbc, 0x80, 0x1e, 0x97, 0xbd, 0x0f, 0xa4,
			0x11, 0xc8, 0xb0, 0x4e, 0xf8, 0x1b, 0x02, 0x89,
			0x31, 0xaf, 0x89, 0x91, 0xe2, 0xa5, 0x33, 0xc2,
			0xc2, 0x45, 0x0c, 0x97, 0xad, 0xa6, 0x1c, 0xea,
			0xfb, 0xa0, 0xd5, 0x07, 0x9d, 0x8d, 0x73, 0xf6,
			0xaf, 0x47, 0xd4, 0xa9, 0xf4, 0x51, 0x74, 0x47,
			0x5f, 0x38, 0x03, 0xf7, 0x9c, 0x26, 0x81, 0x8e,
			0x7a, 0x9b, 0xc4, 0x0a, 0x1c, 0xde, 0x20, 0x77,
			0x01, 0xa2, 0x95, 0x54, 0x22, 0xc0, 0x32, 0xd6,
			0x3a, 0x0f, 0xee, 0x3c, 0xf9, 0x2f, 0xc5, 0x73,
			0x6a, 0x4a, 0xa8, 0x41, 0x22, 0xaa, 0x5b, 0x53,
			0xdd, 0x38, 0xff, 0x0d, 0x34, 0xc9, 0xd6, 0xa0,
			0x52, 0xab, 0x0a, 0xa8, 0xef, 0x77, 0x77, 0xa2,
			0x5d, 0x60, 0x79, 0xc6, 0x6b, 0xea, 0x4b, 0xd8,
		},
		20, /* salt length */
		/* V5 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA512 [6] */
	{
		/* Msg6 : 128 byte */
		{
			0xd2, 0xf6, 0x8f, 0x29, 0xe0, 0x1c, 0x74, 0xb5,
			0xc5, 0x0a, 0x0c, 0x01, 0xe1, 0xf7, 0xc7, 0x91,
			0x37, 0x25, 0xea, 0x5f, 0x66, 0x09, 0x29, 0x22,
			0xdc, 0xac, 0x77, 0xd0, 0x46, 0x51, 0x1d, 0x62,
			0x4a, 0x58, 0x09, 0xd7, 0x79, 0x62, 0x69, 0x7b,
			0x7f, 0xb6, 0x79, 0x69, 0x9d, 0xe4, 0x99, 0x4f,
			0x5a, 0xa8, 0xa3, 0x71, 0x75, 0x10, 0x7b, 0xf1,
			0x1d, 0xe1, 0xe8, 0x4d, 0x64, 0x38, 0xa2, 0x29,
			0xf2, 0x6d, 0xac, 0x4f, 0xf6, 0x3c, 0xe3, 0xf4,
			0x63, 0x27, 0xd8, 0x3d, 0x58, 0x16, 0xdb, 0x01,
			0xdf, 0x41, 0x58, 0xd1, 0xdb, 0x4f, 0x67, 0x35,
			0x3c, 0xbf, 0x9e, 0x39, 0x75, 0x88, 0x29, 0x28,
			0x30, 0xfc, 0x1d, 0x98, 0x40, 0xf2, 0x0a, 0xa6,
			0xd7, 0x24, 0xd0, 0x83, 0xf9, 0xd6, 0xb3, 0x30,
			0x30, 0xb9, 0xb1, 0x85, 0x82, 0x0e, 0x12, 0x78,
			0xa0, 0x0e, 0x42, 0x9c, 0x60, 0x8a, 0xdc, 0xe8,
		},
		/* S6 : 256 byte */
		{
			0x77, 0x06, 0x87, 0x03, 0x72, 0x4d, 0x23, 0xa6,
			0xe7, 0xad, 0x10, 0x8c, 0x56, 0xff, 0x1b, 0x0d,
			0x11, 0x84, 0x49, 0x1b, 0x1c, 0x5d, 0x65, 0xfb,
			0xce, 0x59, 0x06, 0xdb, 0xf8, 0x12, 0x27, 0x1b,
			0xdf, 0x18, 0x75, 0x87, 0xfd, 0x93, 0x30, 0x47,
			0xf6, 0x56, 0xae, 0xcc, 0x8d, 0x3e, 0x71, 0x35,
			0x18, 0x32, 0x6b, 0xfa, 0x41, 0x3b, 0xd6, 0xa2,
			0x37, 0x51, 0xb3, 0x77, 0x1a, 0xef, 0x9b, 0x15,
			0x54, 0x19, 0xef, 0xe0, 0xe1, 0x33, 0xdb, 0x3e,
			0x50, 0xb5, 0xd6, 0x2d, 0x9c, 0x77, 0x23, 0xc9,
			0x90, 0xae, 0x23, 0x51, 0x13, 0x97, 0x4c, 0x64,
			0x08, 0x49, 0x9a, 0xfc, 0x2a, 0x46, 0x92, 0xbf,
			0x2c, 0xc4, 0xbc, 0x10, 0xdf, 0xf5, 0xa6, 0x7c,
			0x38, 0xfe, 0xd7, 0xc8, 0xe0, 0x2a, 0xc5, 0xe5,
			0x22, 0x8d, 0x23, 0xfa, 0x8d, 0x78, 0xd6, 0x31,
			0xff, 0x57, 0xdc, 0x5f, 0xac, 0x1b, 0x44, 0x2c,
			0x9b, 0xbb, 0xde, 0xa2, 0xc0, 0xc6, 0x3c, 0xac,
			0x1d, 0xa6, 0x35, 0x91, 0x4d, 0xfd, 0x45, 0xe7,
			0x45, 0xff, 0x68, 0x4c, 0x3f, 0x7a, 0x23, 0x45,
			0xfa, 0xe7, 0xd9, 0x1b, 0xa0, 0x45, 0x3c, 0x35,
			0x9a, 0x9d, 0xae, 0x48, 0x7b, 0xa0, 0x56, 0x58,
			0x7b, 0x49, 0x37, 0x41, 0xe5, 0xf7, 0x58, 0xaa,
			0x76, 0xa4, 0x71, 0xc7, 0x84, 0x74, 0xff, 0xc4,
			0x43, 0xd9, 0xa5, 0x9b, 0xd3, 0xfa, 0x77, 0x8c,
			0x59, 0xd3, 0xc8, 0xc5, 0x89, 0x24, 0xb9, 0x6f,
			0x9b, 0xf1, 0x36, 0x4c, 0xbc, 0xad, 0x7b, 0x59,
			0x50, 0x29, 0xa7, 0x7e, 0xe8, 0x9e, 0x70, 0x04,
			0xf8, 0x6e, 0xb4, 0x1b, 0xee, 0xff, 0xba, 0xd6,
			0x4d, 0x06, 0xe1, 0xd0, 0x23, 0xcb, 0x0f, 0x74,
			0x0e, 0x44, 0xf2, 0x27, 0xf8, 0x21, 0x54, 0x1a,
			0x54, 0x62, 0xb1, 0x69, 0x10, 0xfb, 0x4f, 0xa5,
			0x3c, 0x05, 0x49, 0x8a, 0x5b, 0xc6, 0x77, 0xf5,
		},
		20, /* salt length */
		/* V6 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA512 [7] */
	{
		/* Msg7 : 128 byte */
		{
			0x26, 0xee, 0xfc, 0x54, 0xaf, 0xa4, 0x24, 0x3b,
			0x22, 0x1b, 0x93, 0xb0, 0xb8, 0xb3, 0xf9, 0x39,
			0x37, 0x31, 0xd6, 0xdf, 0xce, 0x11, 0x84, 0x26,
			0x40, 0x1e, 0x77, 0x43, 0x45, 0x3f, 0xc4, 0x8a,
			0x2d, 0x94, 0xe0, 0x26, 0xc6, 0xc1, 0xaa, 0x0c,
			0x80, 0x8a, 0xac, 0x32, 0xcf, 0xa1, 0x9e, 0xfb,
			0xd1, 0xbb, 0x2c, 0xf6, 0x31, 0xe9, 0xfa, 0xc9,
			0x4b, 0x26, 0xe4, 0x68, 0x90, 0x2c, 0x8a, 0x8b,
			0x2c, 0x8d, 0x0c, 0x5e, 0xe7, 0xfe, 0x12, 0x7a,
			0x49, 0xf6, 0x10, 0x14, 0x02, 0x78, 0xc8, 0x74,
			0x89, 0x2c, 0x10, 0xa9, 0x02, 0xb5, 0xd5, 0x7c,
			0x65, 0x3f, 0x60, 0xa2, 0xdd, 0x57, 0xd8, 0x36,
			0x6e, 0x00, 0x08, 0x66, 0xdb, 0x03, 0x63, 0x6c,
			0xc7, 0x86, 0x45, 0xc0, 0x1a, 0xe0, 0x7c, 0x8b,
			0xa6, 0xac, 0x07, 0x5f, 0x0b, 0x1c, 0x1d, 0x26,
			0xd7, 0x91, 0x72, 0x59, 0xf2, 0x68, 0xb5, 0x73,
		},
		/* S7 : 256 byte */
		{
			0x1a, 0xa1, 0x22, 0xbb, 0x47, 0x47, 0xf5, 0x00,
			0x90, 0xe5, 0x01, 0xd3, 0xc3, 0xe7, 0x95, 0x4f,
			0xc2, 0x20, 0xb6, 0xd7, 0x34, 0x34, 0x18, 0xcc,
			0x0d, 0xbb, 0xb1, 0x7a, 0xe9, 0x25, 0xdb, 0x32,
			0x68, 0xa6, 0x01, 0xec, 0xee, 0x6c, 0xcd, 0x8e,
			0x50, 0x28, 0xbb, 0x43, 0x96, 0x4b, 0x84, 0x5c,
			0x74, 0xf5, 0x05, 0x2f, 0xbe, 0x77, 0xff, 0x63,
			0x58, 0xd4, 0x3d, 0xb5, 0x23, 0x3a, 0xdf, 0x1f,
			0x2c, 0x9b, 0xad, 0x4f, 0xcf, 0x25, 0xd1, 0x1c,
			0x69, 0x39, 0x3f, 0x8e, 0x1a, 0x23, 0x43, 0xaf,
			0x1a, 0xd4, 0xc4, 0x8f, 0xcd, 0xb3, 0x66, 0xdc,
			0xe7, 0xba, 0xa6, 0x29, 0xcd, 0xa6, 0x28, 0x65,
			0xa5, 0x28, 0x79, 0x22, 0xda, 0x71, 0xbf, 0xc1,
			0x1c, 0xad, 0xc7, 0x9c, 0x2f, 0x02, 0x7d, 0x06,
			0x12, 0xd6, 0xc0, 0x2f, 0x57, 0x16, 0x34, 0xb7,
			0xbc, 0x63, 0x8b, 0x41, 0x79, 0xa6, 0xaa, 0x1e,
			0xa7, 0xd9, 0x90, 0xd3, 0x1b, 0x35, 0x5f, 0x32,
			0x6e, 0x0c, 0xf5, 0x3e, 0x54, 0xb0, 0x23, 0xba,
			0x27, 0xe2, 0xe8, 0xeb, 0x1e, 0x94, 0x10, 0x39,
			0x28, 0x8e, 0x08, 0xe0, 0x14, 0x07, 0xa3, 0x7a,
			0xcd, 0x6f, 0xe7, 0x32, 0x9e, 0x8e, 0x70, 0xdc,
			0xef, 0xc5, 0xe3, 0x30, 0x52, 0x5e, 0x62, 0x7d,
			0x1d, 0x07, 0x8d, 0x2d, 0x5a, 0x1c, 0xa1, 0xa0,
			0xa0, 0x05, 0x95, 0x1d, 0x1f, 0xc9, 0xc9, 0x82,
			0xbe, 0xca, 0x32, 0x05, 0x0b, 0x35, 0x67, 0x14,
			0xe7, 0x9d, 0x7b, 0xe3, 0x62, 0xbf, 0x22, 0xb8,
			0x2e, 0x00, 0x1a, 0xb5, 0x3d, 0x3e, 0xf7, 0x66,
			0xa1, 0x76, 0xf7, 0x02, 0x91, 0xc8, 0x30, 0x5b,
			0xb3, 0x08, 0x70, 0xff, 0x76, 0x04, 0xc2, 0x6b,
			0x85, 0xa4, 0x97, 0xbd, 0xb4, 0xdb, 0x35, 0x62,
			0x4a, 0xf6, 0x25, 0xc3, 0xdb, 0x8a, 0x9c, 0xc0,
			0xc0, 0x2b, 0x91, 0x13, 0x1a, 0xb4, 0x7e, 0xf6,
		},
		20, /* salt length */
		/* V7 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA512 [8] */
	{
		/* Msg8 : 128 byte */
		{
			0xdc, 0x3a, 0x20, 0xdc, 0x0e, 0x39, 0xa9, 0xf5,
			0xeb, 0x64, 0x18, 0x13, 0x91, 0xba, 0x86, 0xbc,
			0xf8, 0x9c, 0xdc, 0x08, 0x6c, 0x76, 0xe6, 0x60,
			0x41, 0xa1, 0xa9, 0x86, 0xc2, 0x88, 0xf7, 0xd5,
			0x6a, 0x0a, 0x40, 0xcb, 0x57, 0x20, 0xab, 0xc4,
			0xfb, 0xc0, 0x65, 0x08, 0x15, 0x01, 0x39, 0x08,
			0xdf, 0x7f, 0x62, 0xe5, 0x89, 0x01, 0x9d, 0x32,
			0xe7, 0x59, 0x82, 0xfb, 0x67, 0x8c, 0x13, 0x06,
			0x45, 0x33, 0x96, 0x58, 0x02, 0x21, 0xa0, 0xfb,
			0x12, 0x46, 0x73, 0xff, 0xd5, 0xd3, 0x89, 0xbf,
			0xc8, 0x9f, 0x71, 0x66, 0xfd, 0xca, 0xda, 0xb1,
			0xc8, 0xa0, 0xee, 0xf6, 0xbc, 0xc0, 0xe1, 0x65,
			0xd5, 0x7d, 0xc9, 0x8e, 0xf7, 0x84, 0xb0, 0x23,
			0x97, 0xbf, 0xe7, 0xff, 0xb8, 0x7a, 0x9e, 0x68,
			0x1a, 0xc5, 0xb2, 0x91, 0xae, 0x19, 0xc6, 0x63,
			0x4c, 0x3e, 0x95, 0x7d, 0xa8, 0x6b, 0x86, 0x7a,
		},
		/* S8 : 256 byte */
		{
			0x59, 0xc6, 0x4a, 0x5c, 0xe0, 0x72, 0x58, 0x31,
			0x97, 0x97, 0xe3, 0xf3, 0xd5, 0x1e, 0xe2, 0x29,
			0xac, 0x42, 0xfb, 0x6f, 0x9e, 0x1a, 0x2e, 0xc6,
			0x08, 0x3a, 0x15, 0x79, 0xef, 0x6b, 0x45, 0xef,
			0xb1, 0xf7, 0x56, 0xca, 0x97, 0xdc, 0x27, 0xba,
			0x83, 0xdd, 0x94, 0x03, 0xbb, 0x17, 0x8c, 0x8f,
			0xb3, 0x68, 0x94, 0x87, 0xbe, 0x40, 0x45, 0x7f,
			0xa0, 0x92, 0xbd, 0xd8, 0xa2, 0x1c, 0xdd, 0x34,
			0x31, 0xb8, 0xd6, 0x63, 0x2c, 0x30, 0x71, 0xc0,
			0x09, 0x2e, 0xb1, 0x5a, 0x7f, 0x8c, 0x3a, 0x17,
			0x0c, 0xb6, 0x54, 0x5c, 0x2c, 0x1b, 0x75, 0xba,
			0xf3, 0x53, 0xd1, 0x21, 0x29, 0xe9, 0x5e, 0x68,
			0xdb, 0x73, 0x1a, 0xcf, 0x69, 0x49, 0xaa, 0x33,
			0xdb, 0x1f, 0x1c, 0xa8, 0x03, 0x05, 0x17, 0xc5,
			0x66, 0x02, 0x11, 0x00, 0x2b, 0x0e, 0x8a, 0x99,
			0x11, 0x18, 0x73, 0xd2, 0xc7, 0x1a, 0x21, 0x41,
			0x28, 0x4e, 0x58, 0xd3, 0x21, 0x94, 0xe8, 0xbc,
			0xf8, 0x70, 0x4d, 0x9c, 0xac, 0x2a, 0x61, 0xd7,
			0x17, 0xd0, 0x4e, 0x18, 0x0d, 0x69, 0xc8, 0xd0,
			0xd8, 0x05, 0xad, 0x90, 0x6b, 0xb1, 0x83, 0x95,
			0xf2, 0x3b, 0xe6, 0x53, 0x59, 0x67, 0x83, 0x21,
			0x8d, 0xf3, 0x0a, 0x77, 0xfb, 0x4a, 0x22, 0xa0,
			0x3b, 0x8d, 0xde, 0x55, 0xb3, 0x8e, 0x26, 0x9d,
			0xcf, 0xb8, 0xd3, 0xf5, 0x43, 0x58, 0x5c, 0xa8,
			0x7d, 0x0c, 0x64, 0x0f, 0xcb, 0x4f, 0x10, 0x06,
			0xed, 0x08, 0x57, 0x37, 0xbb, 0x69, 0xd7, 0xc8,
			0xde, 0x83, 0x2b, 0xb8, 0x4c, 0xa4, 0x27, 0x4a,
			0x18, 0xd9, 0xa1, 0x32, 0x88, 0xc3, 0x3c, 0xd8,
			0xb7, 0x91, 0x64, 0xb9, 0x22, 0xe8, 0x4d, 0xf1,
			0x2a, 0x31, 0x53, 0xf0, 0xca, 0xad, 0xca, 0x23,
			0xc6, 0x9d, 0x6d, 0x23, 0xc4, 0x68, 0x58, 0x6d,
			0xb5, 0xb5, 0x02, 0xf3, 0x16, 0x4b, 0x6d, 0x6f,
		},
		20, /* salt length */
		/* V8 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA512 [9] */
	{
		/* Msg9 : 128 byte */
		{
			0x6c, 0x6a, 0x3e, 0x8c, 0xb1, 0xc7, 0xe9, 0x85,
			0x15, 0xe8, 0xd9, 0xfe, 0x14, 0xf0, 0xf3, 0x52,
			0x69, 0x39, 0x7d, 0xc6, 0x1a, 0x46, 0x3c, 0x19,
			0xb4, 0xf9, 0xd9, 0x5d, 0xd8, 0x06, 0x8a, 0x05,
			0xf6, 0xa8, 0xee, 0x3e, 0x59, 0x93, 0x38, 0x83,
			0x64, 0x29, 0x8f, 0x6b, 0x1b, 0xf0, 0xb5, 0xc6,
			0xe5, 0x44, 0xe7, 0xe9, 0x8f, 0x49, 0x05, 0x46,
			0x95, 0x24, 0xf3, 0x40, 0x9d, 0x6b, 0x3f, 0x3d,
			0x45, 0xd9, 0x04, 0xfc, 0x1e, 0x47, 0x0e, 0x29,
			0xf8, 0xd7, 0x3e, 0x2e, 0x61, 0x73, 0x30, 0x4d,
			0x68, 0x76, 0x1c, 0xeb, 0xa7, 0xa8, 0xfa, 0x2f,
			0x80, 0x70, 0xea, 0xcc, 0xa6, 0x45, 0xd2, 0x1b,
			0xdf, 0x66, 0x49, 0x6d, 0x09, 0xcb, 0xb4, 0x9f,
			0x5b, 0x5b, 0xae, 0xef, 0xee, 0x5f, 0xae, 0x0d,
			0x7c, 0x37, 0xe3, 0x76, 0x67, 0x4b, 0x63, 0xfd,
			0xfd, 0x45, 0x85, 0xaa, 0xfa, 0x7e, 0x8b, 0xc8,
		},
		/* S9 : 256 byte */
		{
			0xca, 0x83, 0x4e, 0xd7, 0x58, 0xd9, 0x83, 0x50,
			0x51, 0x08, 0x41, 0x65, 0x51, 0x11, 0x49, 0x38,
			0xd0, 0xf6, 0x7e, 0x82, 0x54, 0x99, 0x37, 0xa8,
			0x6c, 0x0b, 0x3a, 0xd9, 0xd6, 0x35, 0xf7, 0x2d,
			0xd2, 0xa4, 0xb0, 0x6f, 0x36, 0xa1, 0x4e, 0xfa,
			0x66, 0x10, 0x02, 0x66, 0x9d, 0x03, 0x93, 0x94,
			0x93, 0xff, 0x96, 0x7f, 0x0e, 0xd3, 0xbe, 0x52,
			0x6e, 0x70, 0x5c, 0x6d, 0x39, 0xc0, 0xa6, 0xb1,
			0xde, 0x2a, 0x42, 0x01, 0x68, 0x78, 0x64, 0x77,
			0x95, 0xce, 0x48, 0xcb, 0xe2, 0x69, 0x76, 0xa0,
			0x7b, 0xdf, 0x92, 0x7b, 0x14, 0xd0, 0x68, 0xbe,
			0x8d, 0x2e, 0x15, 0x78, 0x39, 0x95, 0xe0, 0x27,
			0xfb, 0xb3, 0xd9, 0x60, 0xb1, 0x9d, 0x88, 0x50,
			0x6a, 0x2d, 0x41, 0xe6, 0x3f, 0xc2, 0x01, 0x25,
			0x97, 0xc9, 0x6f, 0x81, 0x16, 0x32, 0x82, 0xfa,
			0x33, 0xbc, 0xa2, 0x4a, 0x31, 0x4e, 0x91, 0xd8,
			0x54, 0x9b, 0xee, 0x8d, 0x72, 0x63, 0xfd, 0x8a,
			0x3c, 0x12, 0x41, 0xb6, 0xc5, 0x8e, 0xb3, 0x56,
			0x63, 0x96, 0xe0, 0xc0, 0x06, 0xbe, 0x57, 0x02,
			0x1e, 0x86, 0xba, 0x43, 0x64, 0x8e, 0x0a, 0xd0,
			0x20, 0x8d, 0xff, 0xf1, 0x59, 0x6d, 0x78, 0xaf,
			0x89, 0xe5, 0x03, 0x52, 0x41, 0x3d, 0xf9, 0x10,
			0x9c, 0x92, 0x43, 0x61, 0xae, 0xde, 0x3a, 0x84,
			0x6e, 0x12, 0xa7, 0x23, 0xb3, 0x81, 0xaf, 0x29,
			0x68, 0x24, 0xc1, 0x7e, 0x04, 0x60, 0xc9, 0x29,
			0xef, 0xe2, 0xa9, 0x3b, 0x6f, 0x14, 0x57, 0xa4,
			0x7c, 0x68, 0x35, 0xab, 0x18, 0x19, 0x09, 0x84,
			0xf6, 0x2f, 0x00, 0x8f, 0xeb, 0x2b, 0xb4, 0x29,
			0xed, 0x76, 0xe6, 0x47, 0x07, 0x7d, 0xb2, 0x15,
			0x15, 0xad, 0x13, 0xfc, 0x7f, 0xb6, 0x61, 0x84,
			0xce, 0xc0, 0xdd, 0x11, 0xd5, 0x03, 0x08, 0xcb,
			0x26, 0x06, 0xe0, 0x76, 0x9d, 0xc3, 0x35, 0x82,
		},
		20, /* salt length */
		/* V9 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
};

typedef mod2048_t tv_t;


#include "siggenPSStest.c"
