/* siggenPSS_2_1536_testfc.c */
/*
 * Copyright (c) 2017 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/index.html.
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */

/*
 * This test vector was created based on SigGen15_186-2.txt from
 * https://csrc.nist.gov/CSRC/media/Projects/Cryptographic-Algorithm-Validation-Program/documents/dss/186-2rsatestvectors.zip
 *
 * The link to the archive file exists in the following URL:
 * https://csrc.nist.gov/projects/cryptographic-algorithm-validation-program/digital-signatures/
 */
/*
 * https://csrc.nist.gov/projects/cryptographic-algorithm-validation-program/digital-signatures/
 * https://csrc.nist.gov/CSRC/media/Projects/Cryptographic-Algorithm-Validation-Program/documents/dss/186-2rsatestvectors.zip
 * SigGenPSS_186-2.txt
 */
#include "siggenPSStest.h"

static const unsigned short sn1[] = {
	0xa180, 0xac4b, 0x5186, 0xdf0b, 0x7b1c, 0xb7a9, 0x5746, 0xa5af,
	0x411e, 0xfa16, 0xd1ae, 0xd124, 0x68de, 0x15b7, 0x47a0, 0xff32,
	0xc215, 0xdd08, 0xa992, 0x87b7, 0x788e, 0x9154, 0x2d90, 0x5994,
	0x0e4b, 0x610f, 0x741c, 0xb9c7, 0xa86b, 0x4aa0, 0xb45a, 0x7b38,
	0x450b, 0x6ea2, 0x5070, 0xf98e, 0x70bb, 0x7833, 0xaecd, 0x1834,
	0xa8e5, 0x91be, 0xa207, 0xec55, 0xd403, 0xc762, 0x13bd, 0x9f70,
	0x0ce2, 0x5adb, 0x265a, 0xd383, 0xc443, 0xed7a, 0x87a5, 0x7d7e,
	0x5c64, 0x95c3, 0x2f51, 0xae0c, 0xc878, 0x4352, 0xcfc5, 0x6f20,
	0x29cd, 0xd323, 0x393a, 0x1531, 0x93f4, 0x1f04, 0x08cd, 0xcd5b,
	0x344d, 0x2094, 0x2413, 0xbd97, 0xc3b0, 0xc04a, 0xb584, 0xf685,
	0xb0e7, 0x96ce, 0x9b5a, 0x0cf6, 0x4441, 0xf00e, 0xe758, 0x6c62,
	0xfe84, 0x42d5, 0x22f7, 0xc6e3, 0xf314, 0xf84d, 0x5570, 0x39b9,
};

static const unsigned short se1[] = {
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001,
};

static const unsigned short sd1[] = {
	0x1e51, 0x7886, 0xbf2c, 0x518c, 0xe734, 0xb1e9, 0xd15f, 0x8ad5,
	0x06a5, 0x990f, 0x5597, 0xbadd, 0x59ee, 0x6f27, 0x3404, 0x2e44,
	0x4a19, 0x2ea0, 0x64ad, 0x045b, 0x55ff, 0x759a, 0xd6de, 0xe562,
	0x1cf8, 0xdba4, 0xba08, 0x767b, 0xdbcb, 0x207c, 0x60bf, 0x27a8,
	0x9d95, 0x92d4, 0x57c3, 0x8da5, 0xc6d5, 0xfaaf, 0xc11d, 0xf170,
	0x5950, 0x9776, 0xb116, 0x49b0, 0xa717, 0x7a83, 0x97ef, 0x1e11,
	0xef81, 0x556a, 0x07b7, 0xc0ff, 0x8bc5, 0xb4d4, 0xd58b, 0x78e2,
	0x19ba, 0x231c, 0xcf1f, 0x4ffd, 0x28ad, 0x1f67, 0xade7, 0xd246,
	0x80e5, 0xc804, 0x37fa, 0x562b, 0x8ae9, 0xf036, 0x5db5, 0xf18e,
	0xcba8, 0x1e3b, 0xc4e6, 0x6c29, 0x6b48, 0x6a93, 0xb71a, 0x5d85,
	0x098c, 0x0036, 0x8e91, 0x0580, 0x3064, 0x4223, 0x6613, 0xf130,
	0x9287, 0xefef, 0x8a40, 0xdfa7, 0xb731, 0x8521, 0x7b2b, 0x6cb1,
};

#define HAS_SHA1_TESTVECTOR

#define HAS_SHA224_TESTVECTOR

#define HAS_SHA256_TESTVECTOR

#define HAS_SHA384_TESTVECTOR

#define HAS_SHA512_TESTVECTOR

/* 10 elements */
static mod1536_t SHA1[] = {
	/* SHA1 [0] */
	{
		/* Msg0 : 128 byte */
		{
			0x11, 0xd9, 0xe7, 0x7d, 0xa9, 0xc8, 0x34, 0x87,
			0xf7, 0xde, 0x32, 0x11, 0x0f, 0xb0, 0xae, 0x00,
			0x58, 0xd8, 0x6f, 0x53, 0xe2, 0xf6, 0x24, 0x4a,
			0xf9, 0xf5, 0x9a, 0xce, 0xfa, 0x90, 0x32, 0x0d,
			0x65, 0x14, 0x93, 0x65, 0x34, 0x67, 0x9c, 0x83,
			0x6b, 0x49, 0x9c, 0xcc, 0xf1, 0xda, 0xc6, 0xfb,
			0x9e, 0x5c, 0xdf, 0x0c, 0x95, 0x3b, 0x3a, 0x5a,
			0xd4, 0x4a, 0xe6, 0x04, 0x09, 0x50, 0x26, 0x94,
			0xa7, 0xc3, 0x21, 0xe3, 0x3a, 0xd3, 0xdb, 0x37,
			0xf8, 0xab, 0x64, 0xaf, 0x98, 0xf3, 0x50, 0xe1,
			0x67, 0x99, 0x66, 0xc1, 0x98, 0xd1, 0x9d, 0xc5,
			0xdb, 0x5a, 0x44, 0x46, 0x32, 0x03, 0x80, 0x2a,
			0x00, 0x6f, 0xfb, 0xc0, 0x63, 0x15, 0xdb, 0xeb,
			0xc4, 0x8a, 0xf1, 0x83, 0xad, 0x03, 0x33, 0xf8,
			0xda, 0x16, 0x6d, 0x38, 0x92, 0xc0, 0x33, 0xd3,
			0x38, 0xac, 0x1a, 0x5d, 0x1d, 0xb2, 0x28, 0x15,
		},
		/* S0 : 192 byte */
		{
			0x67, 0x02, 0x04, 0xea, 0xde, 0x93, 0x9c, 0xa8,
			0x5d, 0x3c, 0xc7, 0x95, 0x7d, 0x81, 0xca, 0xd8,
			0xd8, 0x09, 0xc3, 0xc5, 0x6e, 0x88, 0xe9, 0xe7,
			0x9d, 0x42, 0xd7, 0x4c, 0x09, 0x9f, 0x95, 0xb9,
			0x23, 0x5b, 0x37, 0xad, 0xf1, 0xe3, 0x21, 0x22,
			0xeb, 0x6d, 0x22, 0x4a, 0x78, 0x5f, 0x2d, 0xc5,
			0xb8, 0xb8, 0xbd, 0x4d, 0x5e, 0x8b, 0x5e, 0xd6,
			0x1f, 0xfe, 0xef, 0x4f, 0x3c, 0x35, 0xa8, 0xba,
			0x85, 0x84, 0x4e, 0xfe, 0x42, 0xdf, 0x78, 0x0f,
			0x6e, 0x4a, 0x0b, 0x94, 0x93, 0x67, 0x1a, 0x4e,
			0xe2, 0xf4, 0x08, 0xa2, 0x29, 0x7b, 0x9d, 0xcf,
			0x12, 0xf7, 0xc3, 0x0a, 0x8f, 0x5c, 0x8f, 0xd6,
			0x13, 0x7e, 0x18, 0xb6, 0x74, 0x31, 0x40, 0xa9,
			0x30, 0xfd, 0x64, 0xc4, 0x49, 0x26, 0x55, 0x5b,
			0x22, 0xf4, 0xf1, 0x57, 0x9c, 0x1b, 0xb7, 0x7f,
			0xfe, 0x17, 0xd2, 0xae, 0x17, 0x5a, 0x64, 0xfd,
			0x14, 0x67, 0xa3, 0x2e, 0xdc, 0xe1, 0xd9, 0x62,
			0x53, 0x2e, 0xaf, 0x3b, 0x6c, 0x3e, 0xa7, 0xea,
			0x9d, 0x44, 0xc7, 0x69, 0x32, 0xd8, 0x4e, 0xc4,
			0x62, 0x9d, 0xe9, 0xe7, 0x05, 0x17, 0xf2, 0xd2,
			0x1e, 0xa1, 0x2c, 0x56, 0xe8, 0xdb, 0x06, 0xc4,
			0x5d, 0x87, 0x6b, 0xcc, 0x55, 0xf2, 0xf9, 0x8e,
			0xd6, 0x8e, 0x15, 0x2c, 0x81, 0x90, 0xc4, 0xbf,
			0x88, 0x74, 0xda, 0xe7, 0xc1, 0x97, 0x9a, 0x34,
		},
		20, /* salt length */
		/* V0 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA1 [1] */
	{
		/* Msg1 : 128 byte */
		{
			0x46, 0xbc, 0x53, 0x16, 0xeb, 0x03, 0x23, 0xf7,
			0x90, 0x79, 0xd3, 0xf3, 0xb9, 0xe4, 0x22, 0x9a,
			0x48, 0xed, 0x21, 0x8a, 0xf1, 0xc9, 0x45, 0x34,
			0xef, 0x19, 0xbb, 0xe3, 0xf5, 0x0f, 0xfb, 0xfa,
			0x68, 0xd3, 0xa0, 0x7c, 0xcb, 0x25, 0x77, 0xd2,
			0x7b, 0x43, 0xd6, 0xc9, 0x9c, 0x0d, 0x2f, 0xdb,
			0x53, 0x67, 0xe4, 0xaf, 0x35, 0xdf, 0x5d, 0xe3,
			0x00, 0x90, 0x59, 0x08, 0x89, 0x45, 0x81, 0xee,
			0xf6, 0xe2, 0x43, 0x22, 0x2d, 0x00, 0xdd, 0xb6,
			0x8d, 0xd8, 0xb8, 0x40, 0xdb, 0x62, 0xf8, 0x25,
			0x7f, 0xbe, 0x51, 0x18, 0xf0, 0xd2, 0x1c, 0xdd,
			0x6d, 0x35, 0xaa, 0x53, 0xee, 0x4b, 0xd8, 0xb1,
			0x5a, 0xb2, 0xe3, 0x10, 0xfa, 0xdd, 0x7e, 0x2a,
			0x2e, 0xff, 0x22, 0x61, 0x5e, 0x2b, 0xa6, 0x03,
			0x34, 0xb9, 0x0f, 0xcc, 0x08, 0xeb, 0xa9, 0xac,
			0x9c, 0xd1, 0x57, 0xcb, 0x0a, 0x69, 0x27, 0xcb,
		},
		/* S1 : 192 byte */
		{
			0x82, 0xe5, 0x1d, 0x66, 0xb8, 0x9a, 0xf7, 0x07,
			0xd4, 0x35, 0x08, 0xdd, 0x48, 0xe3, 0x31, 0xe5,
			0xad, 0x38, 0x4a, 0x5c, 0xfc, 0x12, 0x71, 0x4a,
			0x3f, 0x8d, 0x9e, 0x0a, 0x43, 0xe5, 0x05, 0x0f,
			0x27, 0x60, 0xa2, 0x24, 0x58, 0xa6, 0x8a, 0x88,
			0xa8, 0x90, 0x4a, 0x35, 0xce, 0xcd, 0x85, 0x2e,
			0xbb, 0x0c, 0x44, 0x1a, 0x9e, 0x73, 0xc1, 0xa9,
			0x35, 0xb2, 0x4e, 0x02, 0x11, 0x09, 0x8f, 0xe9,
			0xe7, 0xbf, 0xc7, 0x11, 0x68, 0x9a, 0x30, 0x96,
			0xcb, 0x2e, 0xdc, 0xc7, 0xe0, 0xab, 0xa9, 0xd2,
			0x4f, 0x94, 0x4f, 0x62, 0x78, 0x5c, 0x89, 0xc1,
			0xf6, 0x8f, 0x9d, 0xd7, 0x05, 0x90, 0xc2, 0x95,
			0x1c, 0x36, 0xe1, 0x5f, 0x4d, 0x93, 0x16, 0x28,
			0xe1, 0xf5, 0x46, 0x69, 0x2a, 0xd2, 0xcf, 0xc3,
			0x0d, 0x1d, 0x55, 0xe1, 0x9c, 0xc6, 0x8c, 0x4e,
			0x11, 0x45, 0x4c, 0xdc, 0x51, 0xfc, 0x62, 0x36,
			0x61, 0x12, 0x74, 0xaf, 0xbe, 0xca, 0xc7, 0x33,
			0x4e, 0xc6, 0xe0, 0xf1, 0xbe, 0x54, 0xec, 0x05,
			0xd7, 0x96, 0xf8, 0x8d, 0x91, 0x51, 0xcd, 0x92,
			0xe9, 0x21, 0x30, 0xd3, 0x14, 0x91, 0x45, 0x30,
			0xde, 0xf3, 0x79, 0x5f, 0x11, 0x31, 0x7c, 0x0a,
			0xcd, 0x56, 0xd3, 0x47, 0xf9, 0x6c, 0xa0, 0xa0,
			0x6b, 0x70, 0x3f, 0xbc, 0xc9, 0x98, 0xb6, 0x3a,
			0xe8, 0x9f, 0x8d, 0x4e, 0x5f, 0x8e, 0xbd, 0xbc,
		},
		20, /* salt length */
		/* V1 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA1 [2] */
	{
		/* Msg2 : 128 byte */
		{
			0x18, 0xf2, 0x53, 0x4e, 0x38, 0x5f, 0xe9, 0x3d,
			0x9e, 0xd1, 0xe1, 0xa2, 0xbd, 0xc2, 0x66, 0x56,
			0x21, 0x5f, 0x79, 0x9f, 0xff, 0xd3, 0x2b, 0x9c,
			0x11, 0xc8, 0x0f, 0xe3, 0xa0, 0x2b, 0xef, 0x68,
			0xe3, 0x30, 0xbe, 0xa1, 0x87, 0x97, 0xce, 0xe7,
			0x8f, 0x2d, 0x43, 0x20, 0x5e, 0x95, 0xc8, 0x9b,
			0x12, 0x48, 0x80, 0x3b, 0x14, 0xdb, 0x3f, 0xd8,
			0xed, 0x81, 0xfb, 0xe2, 0x5c, 0xd0, 0x7d, 0x47,
			0xa5, 0xc8, 0x5c, 0x97, 0x2b, 0x11, 0x2c, 0x67,
			0x41, 0x84, 0xf3, 0xf3, 0x3e, 0xed, 0xdc, 0x07,
			0xcf, 0x0f, 0x30, 0x1f, 0x92, 0xe9, 0x81, 0xcd,
			0xe0, 0x38, 0x29, 0x5b, 0xea, 0x3d, 0xf3, 0xb1,
			0x07, 0xc0, 0x17, 0x7a, 0x4c, 0x55, 0x6c, 0x83,
			0x5e, 0xde, 0xd9, 0x63, 0x84, 0x51, 0x0c, 0x61,
			0x00, 0xbc, 0x6f, 0x92, 0xa0, 0x86, 0x58, 0x42,
			0x90, 0xf7, 0x81, 0x95, 0x72, 0xfa, 0xb7, 0x6e,
		},
		/* S2 : 192 byte */
		{
			0x72, 0x60, 0x89, 0x98, 0xaf, 0xf7, 0xc5, 0xde,
			0xec, 0x38, 0x3b, 0x23, 0x9d, 0xe8, 0x24, 0xe5,
			0x06, 0x9c, 0x8c, 0x18, 0xaf, 0xa8, 0x73, 0x2c,
			0x1a, 0x1c, 0x91, 0xab, 0xe9, 0xf6, 0xb6, 0x1e,
			0xe7, 0x1d, 0x94, 0x67, 0x62, 0xb8, 0xd0, 0xe7,
			0x6f, 0xc9, 0xe4, 0x81, 0xfc, 0x4f, 0x92, 0x63,
			0x0c, 0xe7, 0x46, 0x17, 0x06, 0xee, 0x93, 0x29,
			0xbb, 0x36, 0x45, 0x2c, 0x80, 0x77, 0xdb, 0x51,
			0x4a, 0xfe, 0xe2, 0xc1, 0xbe, 0x1f, 0x36, 0xec,
			0x8d, 0xba, 0x50, 0x4f, 0x44, 0xee, 0xab, 0x75,
			0x87, 0xdb, 0x8c, 0x71, 0x97, 0x10, 0xb0, 0xfe,
			0xa4, 0x59, 0xdc, 0x34, 0x0c, 0x4b, 0x8e, 0x68,
			0xcc, 0x12, 0x38, 0xee, 0xc2, 0x4c, 0xf5, 0x73,
			0xc8, 0x5d, 0xb1, 0x9e, 0x21, 0x01, 0x46, 0x04,
			0x93, 0x83, 0xc2, 0x3e, 0x18, 0x67, 0x08, 0xc6,
			0x8d, 0xe0, 0xd5, 0xff, 0x00, 0x4c, 0xbf, 0x74,
			0x77, 0x0a, 0xb1, 0xfd, 0x71, 0xc6, 0xb1, 0x99,
			0xb9, 0xb4, 0xaf, 0x91, 0xd6, 0x65, 0x04, 0xcb,
			0x5f, 0xdd, 0x32, 0x2a, 0x75, 0xe3, 0x09, 0x00,
			0x86, 0x90, 0x28, 0x8d, 0x26, 0x0d, 0xf4, 0x42,
			0x0e, 0x5d, 0xa2, 0x11, 0xc3, 0xdc, 0x55, 0x53,
			0x11, 0x1d, 0x0e, 0xc1, 0x87, 0xb3, 0x74, 0xd4,
			0x2e, 0x2a, 0xb3, 0xaa, 0x0b, 0x96, 0x01, 0xe9,
			0x73, 0xc6, 0x3c, 0x0e, 0x0d, 0x22, 0x16, 0xb6,
		},
		20, /* salt length */
		/* V2 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA1 [3] */
	{
		/* Msg3 : 128 byte */
		{
			0xd4, 0xe8, 0xd5, 0x05, 0x3f, 0x25, 0xe4, 0xc3,
			0x7e, 0x37, 0x80, 0xb4, 0x9a, 0x51, 0x24, 0x38,
			0x05, 0x71, 0xe2, 0xe4, 0x89, 0x87, 0xfa, 0xcd,
			0x7f, 0xd9, 0xab, 0x03, 0x41, 0xa6, 0x49, 0x5b,
			0xe2, 0x09, 0x90, 0x72, 0x1c, 0x21, 0x38, 0xee,
			0x89, 0x6f, 0xc9, 0x07, 0x16, 0x7f, 0xb1, 0x47,
			0xb6, 0xcb, 0x94, 0x8d, 0x53, 0xdc, 0xe3, 0x58,
			0x0a, 0xb2, 0xb0, 0x42, 0x97, 0x66, 0xc1, 0xcb,
			0x0e, 0x0e, 0xe3, 0x58, 0xcd, 0xe1, 0x80, 0x7c,
			0xae, 0x9c, 0x74, 0x75, 0x81, 0x24, 0x1d, 0xfa,
			0xb9, 0x6c, 0xb1, 0x34, 0x65, 0x99, 0xd5, 0x0a,
			0x62, 0x64, 0x6b, 0xa1, 0xcf, 0xc0, 0xab, 0x23,
			0xc2, 0xbd, 0x75, 0xc0, 0x39, 0xad, 0xe5, 0xf3,
			0x54, 0x85, 0x29, 0x07, 0xc1, 0x86, 0x8f, 0xd9,
			0x77, 0x1c, 0xe2, 0xdf, 0xa7, 0x06, 0xf7, 0x69,
			0xef, 0xb7, 0x83, 0x27, 0xd2, 0xfc, 0x2f, 0xec,
		},
		/* S3 : 192 byte */
		{
			0x77, 0x2d, 0x96, 0x8c, 0xc7, 0x25, 0xdb, 0x07,
			0xda, 0x11, 0xbd, 0xb1, 0x8f, 0xfd, 0x29, 0x7d,
			0x6f, 0x32, 0x90, 0x98, 0xec, 0xb0, 0xc7, 0x2e,
			0xe0, 0x09, 0x52, 0xd1, 0x3e, 0x66, 0x0b, 0xc5,
			0x92, 0xfc, 0x00, 0xa9, 0xf8, 0x87, 0xa3, 0xd9,
			0x54, 0xe4, 0x57, 0x59, 0x29, 0x98, 0xdd, 0xa6,
			0x7c, 0x5f, 0x7b, 0xf0, 0x8b, 0xd8, 0xc3, 0x82,
			0xef, 0x30, 0x9a, 0x5b, 0x51, 0x2a, 0xd5, 0x69,
			0x5a, 0x69, 0x1b, 0x2e, 0x94, 0x2e, 0xec, 0x13,
			0xa5, 0x1f, 0x1c, 0x8e, 0x05, 0x15, 0x98, 0x3e,
			0xd4, 0x76, 0x95, 0xbe, 0xf5, 0x13, 0x4a, 0x42,
			0x81, 0x07, 0xb8, 0x2c, 0x63, 0xe7, 0x76, 0xe3,
			0x60, 0x1a, 0x8b, 0x47, 0xbe, 0xc9, 0x87, 0x24,
			0xda, 0xea, 0xcc, 0x86, 0xf4, 0xed, 0xc5, 0x28,
			0xe9, 0x0d, 0x78, 0x3a, 0x36, 0xe7, 0x39, 0x9a,
			0xec, 0xab, 0xd0, 0x3b, 0x5a, 0xaa, 0x39, 0x0f,
			0xe3, 0x7f, 0x5a, 0x08, 0x7c, 0x01, 0xf7, 0xef,
			0xb0, 0x11, 0x43, 0x5c, 0x59, 0xdd, 0xaa, 0x92,
			0xb3, 0x3b, 0x44, 0xee, 0xf9, 0xe1, 0xd4, 0xf4,
			0x5f, 0xe2, 0xff, 0xf8, 0x79, 0x6b, 0x15, 0x18,
			0xc4, 0x19, 0x3e, 0x5c, 0xe0, 0xc2, 0x84, 0x1a,
			0xa6, 0xb1, 0x67, 0xa6, 0x48, 0x31, 0xcb, 0x79,
			0x81, 0x34, 0x90, 0xd9, 0xb6, 0x14, 0xf4, 0x52,
			0xcb, 0xdf, 0x97, 0x71, 0x32, 0xf7, 0x00, 0x48,
		},
		20, /* salt length */
		/* V3 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA1 [4] */
	{
		/* Msg4 : 128 byte */
		{
			0x95, 0xb1, 0x63, 0x6d, 0x5e, 0x12, 0x4e, 0xc0,
			0x6a, 0x1e, 0xd9, 0x50, 0x69, 0x56, 0xd3, 0xbf,
			0x42, 0x93, 0xfd, 0xdd, 0x59, 0x40, 0x6b, 0x79,
			0x0e, 0xc5, 0x2d, 0x77, 0x86, 0x46, 0x2f, 0x23,
			0xad, 0x8e, 0x5e, 0xc5, 0x7b, 0x46, 0x0c, 0x76,
			0x77, 0x6b, 0x96, 0x31, 0x7a, 0xff, 0x44, 0x2d,
			0xb6, 0xfe, 0x70, 0x6a, 0xf6, 0x93, 0xeb, 0x8a,
			0x27, 0x8c, 0x9c, 0xe3, 0x18, 0x0c, 0x6a, 0xd2,
			0x7e, 0x7f, 0x5d, 0x52, 0x3b, 0xd3, 0xff, 0xcd,
			0xe0, 0xe6, 0x09, 0x32, 0x70, 0x3a, 0x3b, 0x47,
			0x67, 0xf0, 0x8c, 0x41, 0xfa, 0xf4, 0x83, 0x92,
			0xa1, 0x75, 0xe5, 0x02, 0xd3, 0x98, 0x90, 0x01,
			0x10, 0x6d, 0xa7, 0x3b, 0x25, 0x22, 0xef, 0x6e,
			0xac, 0x76, 0x79, 0x78, 0xd2, 0x71, 0x82, 0xb5,
			0x5d, 0x52, 0x97, 0x87, 0xed, 0xca, 0xfd, 0x36,
			0x81, 0x67, 0x4f, 0xfb, 0x3e, 0x53, 0x69, 0x57,
		},
		/* S4 : 192 byte */
		{
			0x80, 0x05, 0xe1, 0x7a, 0x8e, 0x89, 0x52, 0xc5,
			0xea, 0xdc, 0x8a, 0xa8, 0xad, 0x69, 0x22, 0xb5,
			0x7d, 0xc0, 0xb1, 0x44, 0x0b, 0x06, 0x5a, 0xd5,
			0x5f, 0x19, 0xa6, 0xeb, 0xc7, 0x68, 0xc5, 0x37,
			0x4b, 0x43, 0x20, 0xa9, 0x7c, 0x11, 0x25, 0x74,
			0x84, 0x64, 0xb8, 0x20, 0xa1, 0x2e, 0x44, 0xdb,
			0x8c, 0x64, 0x82, 0xf9, 0xc2, 0x19, 0xb6, 0x71,
			0x2b, 0x5c, 0xc3, 0x03, 0xcb, 0x5a, 0x32, 0x87,
			0x34, 0x15, 0xab, 0x66, 0xed, 0xb0, 0x1a, 0x61,
			0x0a, 0xd9, 0xd1, 0x39, 0xb9, 0x3c, 0x82, 0xa1,
			0x62, 0x11, 0x50, 0x37, 0x0e, 0x21, 0x3a, 0xf4,
			0x60, 0xc2, 0x25, 0xa5, 0x31, 0x4c, 0xad, 0x49,
			0xd1, 0xdc, 0x49, 0x89, 0x9d, 0x1e, 0xa5, 0xe3,
			0xc8, 0xa0, 0xab, 0x9e, 0x5b, 0x32, 0x0b, 0xd8,
			0xd3, 0x6e, 0x3b, 0x8f, 0x81, 0x16, 0xfd, 0x89,
			0x20, 0x96, 0x4e, 0x96, 0xa4, 0x14, 0x5e, 0xcc,
			0xbe, 0x00, 0x06, 0x9e, 0x57, 0x5a, 0xb1, 0x1e,
			0x2e, 0xfb, 0x67, 0xff, 0x25, 0xe0, 0x58, 0x30,
			0xe3, 0xe3, 0xbe, 0x82, 0x81, 0x9f, 0x8e, 0x22,
			0x89, 0x27, 0xfd, 0x9d, 0x38, 0xa7, 0x53, 0xc2,
			0x5e, 0x2e, 0xa0, 0x4b, 0x7a, 0x65, 0xa3, 0x54,
			0x4a, 0x84, 0x55, 0x4e, 0xc3, 0xe6, 0x39, 0x16,
			0x48, 0x48, 0x7a, 0x87, 0xc3, 0x85, 0x7c, 0xce,
			0xe7, 0xf5, 0xe9, 0xdf, 0x54, 0xd8, 0x60, 0xba,
		},
		20, /* salt length */
		/* V4 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA1 [5] */
	{
		/* Msg5 : 128 byte */
		{
			0x05, 0x86, 0x26, 0x4a, 0x84, 0xd2, 0x28, 0xd4,
			0x7a, 0x7a, 0xd3, 0x2c, 0xaa, 0x86, 0x20, 0x35,
			0xf8, 0x95, 0x3d, 0x38, 0x21, 0xc8, 0xe0, 0xe2,
			0xaa, 0xdb, 0xdc, 0x8c, 0x16, 0x95, 0xf2, 0xc0,
			0x5c, 0x63, 0xe9, 0xf8, 0x98, 0x40, 0xe0, 0xa8,
			0x01, 0xd7, 0xe4, 0x7f, 0x1b, 0xec, 0xbe, 0xea,
			0x2e, 0xf8, 0x0e, 0xdb, 0xf6, 0x13, 0x9e, 0xc8,
			0x9c, 0x17, 0xf0, 0xf6, 0xe5, 0x03, 0x19, 0xf7,
			0xaa, 0x9d, 0xd2, 0x72, 0x88, 0x5c, 0xcd, 0x22,
			0xd8, 0x84, 0x45, 0x21, 0xe1, 0x93, 0xd9, 0x67,
			0x4d, 0xdc, 0x9a, 0x8d, 0xda, 0x72, 0x63, 0xd7,
			0x52, 0x47, 0x69, 0x72, 0xbd, 0x95, 0x12, 0xfa,
			0xd5, 0x7d, 0x0b, 0x40, 0xba, 0xef, 0x95, 0x49,
			0xe7, 0xc9, 0x1f, 0x9a, 0x65, 0x43, 0x1a, 0xb2,
			0x3e, 0x8a, 0x09, 0xd9, 0x35, 0xab, 0xd7, 0x18,
			0xb4, 0xb3, 0x6e, 0x89, 0x06, 0x14, 0x85, 0xd1,
		},
		/* S5 : 192 byte */
		{
			0xa1, 0x3e, 0x25, 0x7a, 0x82, 0x28, 0x8a, 0x0c,
			0x58, 0x6f, 0x99, 0x60, 0x8a, 0xa8, 0x10, 0x79,
			0x4d, 0xee, 0x3e, 0x6d, 0x1c, 0x67, 0x9c, 0x29,
			0x85, 0x0e, 0xfc, 0x05, 0x37, 0x19, 0xf1, 0xd9,
			0x2b, 0xcd, 0x0b, 0x49, 0x09, 0xfe, 0x1f, 0x3c,
			0x95, 0x7f, 0xf4, 0x6a, 0x71, 0x54, 0x43, 0x54,
			0xa1, 0x08, 0xd8, 0x62, 0xc6, 0x38, 0x38, 0x0d,
			0x0a, 0x71, 0x7e, 0x3f, 0xa1, 0xcb, 0xb5, 0xdc,
			0x89, 0x3d, 0x36, 0x22, 0xca, 0x59, 0xb0, 0x6a,
			0x46, 0x80, 0x44, 0xb9, 0xe2, 0xaa, 0x50, 0x67,
			0x40, 0x5d, 0x23, 0x97, 0x14, 0x1d, 0xb5, 0xd0,
			0x5b, 0xd4, 0xb3, 0xa4, 0x6d, 0xff, 0xf0, 0x1a,
			0x4c, 0x99, 0xa2, 0x84, 0x9f, 0x14, 0x40, 0x8e,
			0x56, 0xa3, 0x3a, 0x5e, 0x3f, 0x7d, 0xac, 0x18,
			0xe9, 0x6d, 0xab, 0x2d, 0xbe, 0x23, 0xe1, 0x9b,
			0xcc, 0xce, 0x14, 0xc1, 0x6c, 0xeb, 0x9a, 0x46,
			0x34, 0x24, 0xd1, 0x8c, 0xef, 0x72, 0xfd, 0xab,
			0x04, 0x86, 0x09, 0x60, 0xa0, 0x9c, 0xd8, 0xa4,
			0xf6, 0xde, 0xfc, 0xe3, 0x4f, 0xc2, 0x9a, 0x3b,
			0x0d, 0xa7, 0x51, 0x62, 0x23, 0x27, 0xc1, 0xe1,
			0x72, 0xed, 0xba, 0x48, 0x86, 0xff, 0x4e, 0x25,
			0x0b, 0x8f, 0xbb, 0x17, 0x76, 0x66, 0xe9, 0x3d,
			0x69, 0x4e, 0xf4, 0xf8, 0xa0, 0x0a, 0x0a, 0xe2,
			0xdc, 0x58, 0x37, 0xa0, 0xc8, 0x97, 0xa2, 0x04,
		},
		20, /* salt length */
		/* V5 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA1 [6] */
	{
		/* Msg6 : 128 byte */
		{
			0x06, 0x1c, 0xb8, 0x39, 0xe6, 0xbe, 0x47, 0x69,
			0xfd, 0xc8, 0x86, 0xdc, 0x57, 0xdd, 0x16, 0xfc,
			0xc9, 0x56, 0x80, 0x7f, 0x3d, 0x42, 0x26, 0x8e,
			0x4a, 0xab, 0x7a, 0x27, 0x08, 0x1c, 0x6d, 0xc0,
			0x22, 0x5f, 0x2b, 0x2d, 0x2c, 0x8b, 0x05, 0xc3,
			0x37, 0x3f, 0xae, 0xbe, 0xa3, 0x28, 0xab, 0xe0,
			0x35, 0xc9, 0x05, 0x5b, 0x69, 0x7b, 0x41, 0xf1,
			0x0a, 0xb2, 0x91, 0x5a, 0xff, 0x83, 0x4c, 0xe6,
			0x68, 0x63, 0x9c, 0x63, 0xea, 0x32, 0x77, 0x41,
			0x46, 0x78, 0xd0, 0xf4, 0x31, 0xee, 0x0e, 0x9a,
			0x60, 0x40, 0xbd, 0xde, 0xe2, 0x11, 0x83, 0x1c,
			0xb2, 0x3f, 0x56, 0xc6, 0x8d, 0x69, 0xed, 0x06,
			0x01, 0xaf, 0x74, 0xa4, 0xc7, 0xb9, 0x84, 0x2b,
			0x52, 0xfb, 0x52, 0x47, 0xa8, 0x37, 0x27, 0x72,
			0x71, 0x43, 0x10, 0xcf, 0x4d, 0x0c, 0xd6, 0x56,
			0x6b, 0xdb, 0x30, 0x32, 0x58, 0xd7, 0x38, 0x67,
		},
		/* S6 : 192 byte */
		{
			0x94, 0x16, 0x14, 0xe0, 0xc5, 0x11, 0x8e, 0xc6,
			0x15, 0x40, 0xd5, 0x52, 0x0a, 0x55, 0x84, 0x1a,
			0xd1, 0xa6, 0x79, 0xef, 0x58, 0x2c, 0x07, 0xaa,
			0x55, 0x64, 0x27, 0xe1, 0xe5, 0xb7, 0xfa, 0xe5,
			0x7b, 0x6b, 0x82, 0x0f, 0x26, 0x5d, 0xd9, 0xc6,
			0xc8, 0x2b, 0xb8, 0x3a, 0xf4, 0x85, 0x0b, 0xaf,
			0x56, 0x22, 0xe7, 0x5d, 0xcd, 0x24, 0x71, 0x1a,
			0x94, 0x1c, 0x54, 0xbd, 0x4e, 0xc7, 0x24, 0x36,
			0xbc, 0x88, 0x45, 0x08, 0xfe, 0x90, 0xae, 0x13,
			0x92, 0x75, 0x5c, 0x34, 0x96, 0x5c, 0x0d, 0xe6,
			0xf9, 0x5a, 0xd7, 0xea, 0x48, 0xfb, 0x02, 0xce,
			0xc1, 0xb4, 0x0c, 0xd6, 0x1f, 0x8a, 0x9d, 0x9c,
			0x34, 0x81, 0xe2, 0x43, 0x95, 0x99, 0xf5, 0x1e,
			0x26, 0x90, 0x54, 0x8b, 0x9c, 0xe8, 0x0a, 0xd2,
			0xca, 0x53, 0xb5, 0x43, 0xc2, 0x48, 0x6d, 0x24,
			0xd8, 0x12, 0x11, 0x14, 0x2d, 0x1d, 0x18, 0xf6,
			0x0f, 0x06, 0x2c, 0xb8, 0xc0, 0x87, 0xa7, 0x70,
			0xea, 0x95, 0xb8, 0xdc, 0x0d, 0x25, 0x36, 0xb9,
			0xdf, 0x5b, 0xfe, 0x5e, 0xb1, 0x7a, 0x71, 0xee,
			0xc8, 0x34, 0x27, 0x44, 0xa5, 0x8d, 0xf5, 0x4d,
			0x7c, 0x30, 0x31, 0xb0, 0xb6, 0xaa, 0xd4, 0x39,
			0xfb, 0xbb, 0xfd, 0x47, 0xeb, 0x85, 0xe2, 0x32,
			0xab, 0xc0, 0x95, 0x40, 0x1d, 0x19, 0x52, 0x1d,
			0x62, 0x0e, 0x6e, 0x92, 0x4e, 0xce, 0x4c, 0x94,
		},
		20, /* salt length */
		/* V6 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA1 [7] */
	{
		/* Msg7 : 128 byte */
		{
			0xb7, 0xd8, 0x7b, 0xed, 0x35, 0x74, 0xa2, 0xc5,
			0x05, 0x3d, 0xe1, 0x7e, 0xb8, 0xca, 0x7e, 0x18,
			0xdd, 0xc7, 0x89, 0x2f, 0x2c, 0x54, 0xb3, 0x81,
			0x04, 0xa8, 0x64, 0xab, 0x18, 0xfa, 0x07, 0x33,
			0x65, 0xa1, 0xa9, 0xcb, 0x67, 0x7a, 0xc2, 0xd4,
			0x8c, 0x8a, 0x52, 0x22, 0xe9, 0xe4, 0x30, 0xff,
			0x2b, 0xcd, 0x9f, 0x72, 0xd1, 0x1f, 0x23, 0xc1,
			0x99, 0xeb, 0x93, 0x34, 0x38, 0x62, 0x6e, 0x1c,
			0x4e, 0xf6, 0x72, 0x14, 0x99, 0xbc, 0x6b, 0x87,
			0x69, 0x15, 0x4a, 0x72, 0x54, 0x8d, 0x76, 0x6b,
			0x2a, 0x03, 0x67, 0xe3, 0x2c, 0x0b, 0x70, 0xa8,
			0x78, 0x90, 0xdc, 0xad, 0xc8, 0xbe, 0x3d, 0x0e,
			0x5c, 0x1e, 0x01, 0x4f, 0x35, 0x03, 0x46, 0xe5,
			0x84, 0x26, 0xf0, 0xf7, 0x62, 0x8d, 0xf8, 0x65,
			0xc1, 0xb1, 0x06, 0x0a, 0xa3, 0xdf, 0x43, 0x3e,
			0x8a, 0xdf, 0x68, 0x9f, 0x2f, 0xd4, 0x1c, 0x12,
		},
		/* S7 : 192 byte */
		{
			0x13, 0x78, 0x3f, 0x1f, 0x4a, 0x4e, 0xb2, 0xcb,
			0x6d, 0xc3, 0x2d, 0xf8, 0x7f, 0x53, 0x43, 0x36,
			0x36, 0xe1, 0x40, 0x8a, 0x97, 0xfc, 0x0f, 0xcd,
			0xe9, 0xac, 0x13, 0x97, 0x59, 0xcc, 0x38, 0x7e,
			0x3e, 0x83, 0x61, 0xc0, 0x02, 0xa4, 0x00, 0x6e,
			0xb2, 0x8c, 0x71, 0x89, 0x31, 0xba, 0x12, 0xfd,
			0x36, 0xb1, 0xd4, 0xda, 0x9f, 0xf7, 0x0e, 0xbc,
			0xa9, 0xc0, 0x14, 0xa6, 0x6c, 0xc2, 0xc9, 0x97,
			0x93, 0xc2, 0xab, 0x87, 0x3c, 0x17, 0x50, 0x3f,
			0x58, 0xb5, 0xee, 0x27, 0x0d, 0x56, 0x09, 0x0f,
			0x55, 0xe7, 0x28, 0xe2, 0x25, 0x67, 0xd2, 0x77,
			0x23, 0xf7, 0x9e, 0xfd, 0x2b, 0xef, 0x72, 0xbd,
			0xe5, 0x3f, 0xf5, 0xef, 0x9d, 0xaa, 0x43, 0x1c,
			0x19, 0x2f, 0xbc, 0xbb, 0x02, 0xa4, 0x73, 0x3f,
			0xa6, 0x78, 0xa5, 0x0b, 0x69, 0xb1, 0x71, 0xd1,
			0x4e, 0x0a, 0xbd, 0xab, 0x10, 0xa5, 0x20, 0xa1,
			0xcc, 0xb1, 0x40, 0xa1, 0xb9, 0x12, 0xa3, 0xca,
			0xca, 0x4b, 0x75, 0x2b, 0x55, 0xba, 0xa0, 0xd5,
			0x54, 0xac, 0xde, 0xb0, 0x9a, 0x38, 0x6c, 0xa4,
			0x19, 0x89, 0xba, 0x26, 0x50, 0xa0, 0x5e, 0xf4,
			0x97, 0xfa, 0xf2, 0xd4, 0x90, 0xe9, 0x0e, 0xab,
			0xda, 0xed, 0xae, 0xfd, 0x94, 0x45, 0x05, 0x10,
			0x93, 0xf2, 0xb6, 0x79, 0xb4, 0x72, 0x64, 0x66,
			0x25, 0xd2, 0x95, 0x27, 0x56, 0x33, 0x7c, 0xb1,
		},
		20, /* salt length */
		/* V7 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA1 [8] */
	{
		/* Msg8 : 128 byte */
		{
			0xb2, 0x19, 0xc3, 0x15, 0x58, 0x55, 0xc1, 0x46,
			0x88, 0xbe, 0xdd, 0x2d, 0x63, 0xbf, 0x64, 0x33,
			0xbe, 0xa8, 0xfa, 0xbe, 0x77, 0xaf, 0x8d, 0x55,
			0x09, 0x35, 0x87, 0x04, 0x5f, 0x4a, 0x48, 0x02,
			0xe6, 0x72, 0xd3, 0x91, 0xe6, 0xa9, 0xc7, 0x26,
			0x12, 0xa6, 0x92, 0xca, 0x5e, 0x5d, 0xe1, 0xc0,
			0x10, 0xc7, 0x5a, 0x68, 0x1a, 0xe5, 0x8e, 0x63,
			0xa7, 0x03, 0x29, 0xf8, 0xf4, 0x3a, 0x6c, 0xb6,
			0x61, 0x38, 0xde, 0x5b, 0xc8, 0x44, 0x3e, 0xf5,
			0x0d, 0x7c, 0xbb, 0x47, 0xf6, 0x61, 0x68, 0x6e,
			0x3d, 0x96, 0xea, 0xc5, 0xe4, 0xe5, 0x73, 0x05,
			0xc9, 0x83, 0xf5, 0xb1, 0x7a, 0x95, 0x8f, 0xb1,
			0x4a, 0xf2, 0x4c, 0x3c, 0xa5, 0x2b, 0x0c, 0xfc,
			0xa0, 0xc9, 0xc2, 0x6d, 0xd4, 0xd5, 0xe0, 0x87,
			0x6d, 0x9e, 0x10, 0x9c, 0x7e, 0xb6, 0x25, 0x83,
			0x98, 0x3e, 0x51, 0xf6, 0x9a, 0x63, 0x98, 0x39,
		},
		/* S8 : 192 byte */
		{
			0x1d, 0x29, 0x05, 0xc4, 0x2f, 0x63, 0xa0, 0x20,
			0xa5, 0x3c, 0xcf, 0xad, 0x35, 0x5d, 0x08, 0x27,
			0xdc, 0x7b, 0xf3, 0x35, 0x51, 0xc4, 0x72, 0xc2,
			0x85, 0x02, 0xac, 0x0a, 0xc1, 0xc9, 0x05, 0xf3,
			0xd5, 0x79, 0xdb, 0x97, 0x9d, 0x81, 0x53, 0x77,
			0xfe, 0x07, 0xbb, 0xd1, 0x83, 0x06, 0xda, 0x5c,
			0x93, 0x80, 0x03, 0xf3, 0xe4, 0x66, 0x13, 0xc2,
			0x8a, 0xdb, 0x4c, 0xed, 0x2c, 0xf4, 0x3f, 0x1b,
			0xf9, 0xa3, 0x2f, 0xef, 0xfe, 0x5b, 0x1c, 0x0a,
			0x0f, 0x3a, 0x1f, 0x88, 0x75, 0x79, 0x09, 0x67,
			0xdf, 0x12, 0xb6, 0xb1, 0x36, 0x6a, 0x58, 0x0d,
			0x71, 0x3e, 0x44, 0xd0, 0x49, 0x14, 0xcc, 0x32,
			0x4e, 0x35, 0xda, 0x43, 0x72, 0x73, 0x06, 0x82,
			0x5e, 0x63, 0x73, 0xcb, 0x85, 0x78, 0x94, 0xe3,
			0x49, 0x10, 0xd6, 0x0d, 0xa7, 0x6f, 0x89, 0x96,
			0x4a, 0xd0, 0x15, 0xb0, 0x27, 0x04, 0xd6, 0x87,
			0x65, 0x43, 0xe2, 0xf8, 0x45, 0x17, 0x5e, 0x50,
			0xe0, 0x0f, 0xce, 0x5f, 0x38, 0x94, 0x36, 0xdb,
			0xaf, 0xdb, 0xe7, 0x4a, 0x5a, 0x90, 0xf8, 0x07,
			0xf0, 0x7b, 0xaf, 0x9b, 0xc1, 0xf8, 0xb3, 0x68,
			0xf5, 0x23, 0x07, 0x58, 0x7d, 0xb4, 0x39, 0x4f,
			0x13, 0x99, 0x4b, 0x6b, 0x7c, 0x57, 0x78, 0x88,
			0xa8, 0x0b, 0xf7, 0x9e, 0x8f, 0x9c, 0x1b, 0x62,
			0x9c, 0xfa, 0x70, 0xe9, 0xe5, 0x88, 0x9d, 0xbd,
		},
		20, /* salt length */
		/* V8 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA1 [9] */
	{
		/* Msg9 : 128 byte */
		{
			0xf7, 0xb6, 0xe1, 0x19, 0x78, 0xb4, 0xa8, 0xc6,
			0xa9, 0xbc, 0x04, 0x95, 0xd0, 0xc7, 0x9b, 0xe6,
			0xdf, 0xd6, 0xfc, 0x5a, 0x01, 0x34, 0xd4, 0x38,
			0x73, 0xfc, 0x64, 0x10, 0x95, 0xdc, 0x32, 0x9e,
			0x41, 0x18, 0xff, 0xf0, 0x5b, 0xd2, 0xfa, 0xcb,
			0xa9, 0x88, 0x33, 0x4c, 0xe5, 0xde, 0x52, 0xcb,
			0x11, 0x9e, 0x89, 0x04, 0x0b, 0xfd, 0xc7, 0x79,
			0x61, 0x20, 0x2f, 0x12, 0x66, 0xde, 0xc8, 0x07,
			0x86, 0xc8, 0x76, 0xff, 0xd6, 0x66, 0x29, 0x7a,
			0xef, 0xc4, 0x54, 0x6c, 0xfd, 0x2d, 0xa1, 0x2a,
			0x13, 0x37, 0xe3, 0x8a, 0xc2, 0x00, 0x4b, 0x46,
			0xe9, 0xb6, 0xe0, 0xa2, 0xce, 0x5d, 0x29, 0x4f,
			0x6e, 0xcc, 0x2c, 0x8e, 0x12, 0xf9, 0x9d, 0x99,
			0x23, 0x77, 0x4f, 0x3e, 0x3f, 0x3d, 0xee, 0xcd,
			0x8c, 0xa9, 0xf0, 0x34, 0x4d, 0xc5, 0xc9, 0x69,
			0xb3, 0xc8, 0x5e, 0x08, 0xf5, 0xe0, 0xbd, 0x3e,
		},
		/* S9 : 192 byte */
		{
			0x84, 0x88, 0xf1, 0xf2, 0x3e, 0x56, 0xcf, 0x52,
			0xf4, 0x37, 0xb5, 0x7b, 0x28, 0x24, 0x7a, 0xd6,
			0x5a, 0x8b, 0xd6, 0xe6, 0x9b, 0xe2, 0xfe, 0x70,
			0x53, 0x4e, 0x55, 0x34, 0xb0, 0xa8, 0x1d, 0x78,
			0xb3, 0x8a, 0x09, 0x46, 0x3a, 0x21, 0x10, 0xd5,
			0x0b, 0x69, 0x55, 0xcd, 0xe4, 0x52, 0x05, 0x8c,
			0x46, 0xdc, 0xd3, 0x2a, 0x00, 0xce, 0x70, 0x57,
			0x66, 0x44, 0x23, 0x93, 0x13, 0xfa, 0x16, 0xc6,
			0x5b, 0xed, 0x63, 0x2a, 0x34, 0x23, 0x37, 0xeb,
			0x09, 0x9e, 0xef, 0x22, 0xb8, 0x2b, 0x41, 0x2a,
			0x64, 0x97, 0x32, 0x6c, 0x21, 0xdf, 0xea, 0xd4,
			0x65, 0x1a, 0x64, 0x71, 0x07, 0xb7, 0x4d, 0x8a,
			0x92, 0x57, 0xc2, 0xe3, 0x1e, 0xf9, 0xe3, 0xc8,
			0x1d, 0xc7, 0xd7, 0x36, 0x5c, 0xcf, 0x23, 0x5c,
			0x87, 0x0f, 0xc0, 0xf5, 0xd0, 0x03, 0x6a, 0x37,
			0x56, 0x07, 0x60, 0x99, 0x8f, 0x68, 0x44, 0xf0,
			0x33, 0x5f, 0x60, 0x36, 0x60, 0xd0, 0x2a, 0xd5,
			0xd1, 0xdd, 0x05, 0x24, 0x41, 0x1d, 0x3d, 0xe5,
			0x5e, 0xc0, 0x08, 0x61, 0x1b, 0xfa, 0x63, 0x38,
			0xca, 0x17, 0x1f, 0x4a, 0xd4, 0x20, 0xb3, 0xea,
			0xab, 0x1e, 0x0b, 0x9e, 0x2d, 0xf4, 0x17, 0x35,
			0x1d, 0xe8, 0x6e, 0x5e, 0xa8, 0x74, 0x8b, 0xb9,
			0x79, 0x90, 0xae, 0x13, 0x7f, 0xcd, 0x52, 0xad,
			0x3a, 0x36, 0x2c, 0x8a, 0xec, 0x01, 0x66, 0x09,
		},
		20, /* salt length */
		/* V9 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
};

/* 10 elements */
static mod1536_t SHA224[] = {
	/* SHA224 [0] */
	{
		/* Msg0 : 128 byte */
		{
			0x11, 0xd9, 0xe7, 0x7d, 0xa9, 0xc8, 0x34, 0x87,
			0xf7, 0xde, 0x32, 0x11, 0x0f, 0xb0, 0xae, 0x00,
			0x58, 0xd8, 0x6f, 0x53, 0xe2, 0xf6, 0x24, 0x4a,
			0xf9, 0xf5, 0x9a, 0xce, 0xfa, 0x90, 0x32, 0x0d,
			0x65, 0x14, 0x93, 0x65, 0x34, 0x67, 0x9c, 0x83,
			0x6b, 0x49, 0x9c, 0xcc, 0xf1, 0xda, 0xc6, 0xfb,
			0x9e, 0x5c, 0xdf, 0x0c, 0x95, 0x3b, 0x3a, 0x5a,
			0xd4, 0x4a, 0xe6, 0x04, 0x09, 0x50, 0x26, 0x94,
			0xa7, 0xc3, 0x21, 0xe3, 0x3a, 0xd3, 0xdb, 0x37,
			0xf8, 0xab, 0x64, 0xaf, 0x98, 0xf3, 0x50, 0xe1,
			0x67, 0x99, 0x66, 0xc1, 0x98, 0xd1, 0x9d, 0xc5,
			0xdb, 0x5a, 0x44, 0x46, 0x32, 0x03, 0x80, 0x2a,
			0x00, 0x6f, 0xfb, 0xc0, 0x63, 0x15, 0xdb, 0xeb,
			0xc4, 0x8a, 0xf1, 0x83, 0xad, 0x03, 0x33, 0xf8,
			0xda, 0x16, 0x6d, 0x38, 0x92, 0xc0, 0x33, 0xd3,
			0x38, 0xac, 0x1a, 0x5d, 0x1d, 0xb2, 0x28, 0x15,
		},
		/* S0 : 192 byte */
		{
			0x1d, 0x85, 0xce, 0xc0, 0xda, 0x1a, 0x74, 0x82,
			0x5a, 0xb7, 0x96, 0x48, 0x0c, 0x6e, 0x12, 0x35,
			0x80, 0x83, 0x87, 0x10, 0x6a, 0xc1, 0x41, 0x1d,
			0x68, 0xf3, 0x13, 0x24, 0x6c, 0x65, 0x04, 0x01,
			0x11, 0xd7, 0x4a, 0x9a, 0x45, 0xeb, 0xae, 0x10,
			0xac, 0x76, 0x86, 0xfd, 0xdf, 0x4a, 0x34, 0x0c,
			0x4f, 0x9d, 0x24, 0x68, 0x5d, 0x70, 0x8b, 0xbf,
			0x7b, 0x0a, 0xb4, 0x56, 0x37, 0x94, 0xf5, 0xf9,
			0x0e, 0x04, 0x05, 0xb5, 0xd7, 0xd5, 0x6c, 0x99,
			0x8e, 0x99, 0x6b, 0x8b, 0xde, 0x2b, 0x02, 0x2a,
			0xe4, 0x5f, 0xec, 0xf2, 0x9a, 0x21, 0x83, 0x6f,
			0xcf, 0x36, 0x20, 0x42, 0xe7, 0x7e, 0x13, 0xcb,
			0xf6, 0x7b, 0x8a, 0x4d, 0xa3, 0xf1, 0xe3, 0x78,
			0xdf, 0xca, 0xb2, 0x14, 0x3a, 0xa8, 0xb9, 0xa1,
			0x45, 0xc2, 0xee, 0x7d, 0x59, 0x3e, 0x31, 0x62,
			0x6b, 0xaa, 0x47, 0xfe, 0x62, 0x3a, 0x3c, 0x3f,
			0x85, 0x9b, 0xb6, 0x3e, 0x93, 0x36, 0xe1, 0x1c,
			0x5f, 0xf3, 0x98, 0xa6, 0x59, 0x76, 0x23, 0x31,
			0x8e, 0x09, 0x82, 0x30, 0xb0, 0x9e, 0x55, 0x3b,
			0xa0, 0xa4, 0x25, 0x76, 0x92, 0xa0, 0xbc, 0x0a,
			0x1c, 0xe1, 0xc1, 0x7b, 0x2d, 0x54, 0x1b, 0x52,
			0xd1, 0x34, 0x62, 0x72, 0x29, 0xc1, 0x41, 0xd3,
			0x51, 0xc1, 0x6f, 0x1b, 0xdf, 0xe3, 0x33, 0x84,
			0xa9, 0xe1, 0x63, 0xec, 0xaa, 0x13, 0xe2, 0xfa,
		},
		20, /* salt length */
		/* V0 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA224 [1] */
	{
		/* Msg1 : 128 byte */
		{
			0x46, 0xbc, 0x53, 0x16, 0xeb, 0x03, 0x23, 0xf7,
			0x90, 0x79, 0xd3, 0xf3, 0xb9, 0xe4, 0x22, 0x9a,
			0x48, 0xed, 0x21, 0x8a, 0xf1, 0xc9, 0x45, 0x34,
			0xef, 0x19, 0xbb, 0xe3, 0xf5, 0x0f, 0xfb, 0xfa,
			0x68, 0xd3, 0xa0, 0x7c, 0xcb, 0x25, 0x77, 0xd2,
			0x7b, 0x43, 0xd6, 0xc9, 0x9c, 0x0d, 0x2f, 0xdb,
			0x53, 0x67, 0xe4, 0xaf, 0x35, 0xdf, 0x5d, 0xe3,
			0x00, 0x90, 0x59, 0x08, 0x89, 0x45, 0x81, 0xee,
			0xf6, 0xe2, 0x43, 0x22, 0x2d, 0x00, 0xdd, 0xb6,
			0x8d, 0xd8, 0xb8, 0x40, 0xdb, 0x62, 0xf8, 0x25,
			0x7f, 0xbe, 0x51, 0x18, 0xf0, 0xd2, 0x1c, 0xdd,
			0x6d, 0x35, 0xaa, 0x53, 0xee, 0x4b, 0xd8, 0xb1,
			0x5a, 0xb2, 0xe3, 0x10, 0xfa, 0xdd, 0x7e, 0x2a,
			0x2e, 0xff, 0x22, 0x61, 0x5e, 0x2b, 0xa6, 0x03,
			0x34, 0xb9, 0x0f, 0xcc, 0x08, 0xeb, 0xa9, 0xac,
			0x9c, 0xd1, 0x57, 0xcb, 0x0a, 0x69, 0x27, 0xcb,
		},
		/* S1 : 192 byte */
		{
			0x09, 0x83, 0xf3, 0x3e, 0xe3, 0x36, 0x43, 0x32,
			0x41, 0x32, 0xd1, 0xca, 0xab, 0x58, 0xad, 0xb4,
			0x5f, 0x44, 0x28, 0x69, 0x2e, 0x62, 0xf9, 0x9e,
			0x85, 0xd9, 0xef, 0x30, 0xba, 0x2b, 0xf8, 0x78,
			0x17, 0x6c, 0x54, 0xdb, 0xf2, 0xef, 0x22, 0x6a,
			0x22, 0xff, 0x6e, 0x8e, 0xc3, 0x17, 0x93, 0x33,
			0x53, 0x15, 0x85, 0x2a, 0x4f, 0x3b, 0x52, 0x80,
			0x54, 0x84, 0xab, 0x69, 0x00, 0x8f, 0x80, 0x50,
			0xb3, 0xd4, 0x49, 0x27, 0x44, 0x74, 0x59, 0xb3,
			0x22, 0x2a, 0x10, 0x0e, 0x23, 0x2f, 0x5d, 0x21,
			0x75, 0xfe, 0x25, 0x27, 0x60, 0xb7, 0x8f, 0x75,
			0x24, 0xb0, 0x1a, 0xc6, 0xac, 0x22, 0xfe, 0x10,
			0xd5, 0xa3, 0xb5, 0x2d, 0x5b, 0xd4, 0xbe, 0x7e,
			0xb9, 0xe7, 0x15, 0xfb, 0xb9, 0xe2, 0x3b, 0x34,
			0x91, 0xfc, 0x7d, 0x58, 0x80, 0xbd, 0x78, 0x16,
			0xb6, 0x63, 0x8d, 0x2d, 0x0d, 0xc7, 0xca, 0xe1,
			0xf3, 0x02, 0x0b, 0xaf, 0x7c, 0xc7, 0xc1, 0x42,
			0xa8, 0x1c, 0x37, 0x37, 0x76, 0xbf, 0x2c, 0x11,
			0xcb, 0xa7, 0x14, 0x05, 0x92, 0x7c, 0x1b, 0x9f,
			0x43, 0x33, 0x22, 0xfa, 0x3e, 0x1f, 0x26, 0xbd,
			0xb0, 0x58, 0xec, 0x06, 0xc6, 0x97, 0x51, 0x8c,
			0x2e, 0x69, 0x9f, 0x2f, 0x2c, 0x16, 0x3d, 0x11,
			0xd0, 0x56, 0x56, 0x0d, 0xf3, 0x5b, 0x2e, 0x1c,
			0x8d, 0x28, 0x65, 0x97, 0xa1, 0x8a, 0xc6, 0xc8,
		},
		20, /* salt length */
		/* V1 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA224 [2] */
	{
		/* Msg2 : 128 byte */
		{
			0x18, 0xf2, 0x53, 0x4e, 0x38, 0x5f, 0xe9, 0x3d,
			0x9e, 0xd1, 0xe1, 0xa2, 0xbd, 0xc2, 0x66, 0x56,
			0x21, 0x5f, 0x79, 0x9f, 0xff, 0xd3, 0x2b, 0x9c,
			0x11, 0xc8, 0x0f, 0xe3, 0xa0, 0x2b, 0xef, 0x68,
			0xe3, 0x30, 0xbe, 0xa1, 0x87, 0x97, 0xce, 0xe7,
			0x8f, 0x2d, 0x43, 0x20, 0x5e, 0x95, 0xc8, 0x9b,
			0x12, 0x48, 0x80, 0x3b, 0x14, 0xdb, 0x3f, 0xd8,
			0xed, 0x81, 0xfb, 0xe2, 0x5c, 0xd0, 0x7d, 0x47,
			0xa5, 0xc8, 0x5c, 0x97, 0x2b, 0x11, 0x2c, 0x67,
			0x41, 0x84, 0xf3, 0xf3, 0x3e, 0xed, 0xdc, 0x07,
			0xcf, 0x0f, 0x30, 0x1f, 0x92, 0xe9, 0x81, 0xcd,
			0xe0, 0x38, 0x29, 0x5b, 0xea, 0x3d, 0xf3, 0xb1,
			0x07, 0xc0, 0x17, 0x7a, 0x4c, 0x55, 0x6c, 0x83,
			0x5e, 0xde, 0xd9, 0x63, 0x84, 0x51, 0x0c, 0x61,
			0x00, 0xbc, 0x6f, 0x92, 0xa0, 0x86, 0x58, 0x42,
			0x90, 0xf7, 0x81, 0x95, 0x72, 0xfa, 0xb7, 0x6e,
		},
		/* S2 : 192 byte */
		{
			0x87, 0x30, 0x45, 0xc1, 0x9a, 0x55, 0x23, 0x98,
			0x64, 0x16, 0x9e, 0x96, 0x98, 0xf5, 0x06, 0xec,
			0x78, 0x64, 0x7d, 0xf2, 0xbe, 0x47, 0xac, 0x98,
			0x6e, 0xe5, 0x82, 0xe9, 0xea, 0x11, 0xa4, 0x5c,
			0xff, 0x22, 0x54, 0xb3, 0x5b, 0x11, 0xd3, 0x78,
			0xb7, 0xd6, 0x51, 0xd8, 0xe1, 0xa4, 0xa0, 0xa1,
			0x22, 0xb5, 0x00, 0xae, 0xc4, 0x20, 0x56, 0xc1,
			0x28, 0x87, 0x8d, 0x57, 0x2a, 0x4f, 0xb4, 0xd7,
			0xcc, 0x76, 0x47, 0xa1, 0x46, 0x8a, 0x45, 0x8e,
			0xd0, 0xa8, 0x45, 0x1b, 0x53, 0x38, 0x2e, 0x52,
			0xdf, 0x83, 0xf3, 0x23, 0xd8, 0x27, 0xab, 0xf9,
			0xdf, 0xce, 0x5f, 0x57, 0x76, 0xf2, 0x06, 0xf2,
			0x48, 0x93, 0xa0, 0x85, 0xc9, 0x2e, 0xf9, 0x1c,
			0x57, 0x49, 0x69, 0x61, 0x0f, 0xaa, 0xe1, 0x19,
			0xdd, 0xeb, 0xbe, 0x96, 0x96, 0xb7, 0xe2, 0x0f,
			0xbe, 0xae, 0xa6, 0x6f, 0x39, 0xd2, 0xbb, 0x8b,
			0x09, 0xc2, 0x8d, 0x8e, 0x6b, 0x1c, 0x9d, 0xaa,
			0x4e, 0x81, 0xa6, 0x93, 0xb6, 0x80, 0x71, 0x96,
			0x66, 0x67, 0xa9, 0x99, 0xd0, 0x8b, 0x27, 0x22,
			0x07, 0xcb, 0x35, 0x16, 0x1a, 0x3d, 0x96, 0x26,
			0x24, 0xac, 0xc4, 0x03, 0x7a, 0x47, 0xf8, 0x61,
			0xfd, 0xaf, 0x05, 0xb5, 0xfb, 0x63, 0xde, 0xd9,
			0x57, 0x79, 0x82, 0x73, 0x41, 0x12, 0xe1, 0x14,
			0x1b, 0x07, 0xbb, 0x54, 0xaa, 0xc1, 0x7b, 0xb8,
		},
		20, /* salt length */
		/* V2 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA224 [3] */
	{
		/* Msg3 : 128 byte */
		{
			0xd4, 0xe8, 0xd5, 0x05, 0x3f, 0x25, 0xe4, 0xc3,
			0x7e, 0x37, 0x80, 0xb4, 0x9a, 0x51, 0x24, 0x38,
			0x05, 0x71, 0xe2, 0xe4, 0x89, 0x87, 0xfa, 0xcd,
			0x7f, 0xd9, 0xab, 0x03, 0x41, 0xa6, 0x49, 0x5b,
			0xe2, 0x09, 0x90, 0x72, 0x1c, 0x21, 0x38, 0xee,
			0x89, 0x6f, 0xc9, 0x07, 0x16, 0x7f, 0xb1, 0x47,
			0xb6, 0xcb, 0x94, 0x8d, 0x53, 0xdc, 0xe3, 0x58,
			0x0a, 0xb2, 0xb0, 0x42, 0x97, 0x66, 0xc1, 0xcb,
			0x0e, 0x0e, 0xe3, 0x58, 0xcd, 0xe1, 0x80, 0x7c,
			0xae, 0x9c, 0x74, 0x75, 0x81, 0x24, 0x1d, 0xfa,
			0xb9, 0x6c, 0xb1, 0x34, 0x65, 0x99, 0xd5, 0x0a,
			0x62, 0x64, 0x6b, 0xa1, 0xcf, 0xc0, 0xab, 0x23,
			0xc2, 0xbd, 0x75, 0xc0, 0x39, 0xad, 0xe5, 0xf3,
			0x54, 0x85, 0x29, 0x07, 0xc1, 0x86, 0x8f, 0xd9,
			0x77, 0x1c, 0xe2, 0xdf, 0xa7, 0x06, 0xf7, 0x69,
			0xef, 0xb7, 0x83, 0x27, 0xd2, 0xfc, 0x2f, 0xec,
		},
		/* S3 : 192 byte */
		{
			0x6a, 0xa3, 0xdb, 0xdd, 0xea, 0x5e, 0xd1, 0xb4,
			0xca, 0x6c, 0x87, 0x0b, 0x26, 0x3e, 0x44, 0xb1,
			0x74, 0xd0, 0xab, 0xed, 0x21, 0x9e, 0xf5, 0xbc,
			0xb1, 0x60, 0xe3, 0xa9, 0x86, 0x5b, 0x3a, 0xe7,
			0xe0, 0x88, 0x19, 0x7c, 0xf6, 0xd3, 0xc5, 0xa7,
			0x7a, 0x94, 0x7c, 0xfc, 0x05, 0xa9, 0xfb, 0x78,
			0xaf, 0x7c, 0xd6, 0x74, 0xbe, 0xed, 0x01, 0xe1,
			0x17, 0x5a, 0x76, 0xc8, 0x01, 0xb3, 0x72, 0xa3,
			0x52, 0xf4, 0x66, 0xb3, 0x6a, 0xcf, 0xad, 0xba,
			0x7f, 0x89, 0xa3, 0xc7, 0x18, 0xa4, 0x8c, 0xa8,
			0x11, 0xce, 0x11, 0x11, 0x07, 0x9f, 0x3a, 0xb3,
			0xbe, 0xf4, 0x2e, 0x69, 0x13, 0x66, 0x2f, 0x94,
			0xa1, 0x82, 0xc6, 0x3f, 0x4c, 0x66, 0x68, 0x5a,
			0xb7, 0x64, 0x1b, 0x77, 0x8d, 0xd5, 0x08, 0x0e,
			0x20, 0x47, 0xa5, 0x8d, 0xa0, 0xfd, 0x9a, 0x74,
			0xf2, 0x64, 0x3a, 0x12, 0x73, 0xe0, 0xe9, 0xb0,
			0xc6, 0x25, 0x0c, 0x83, 0xfc, 0xb2, 0x4c, 0xa0,
			0x3d, 0x60, 0xe0, 0x6a, 0xfa, 0x83, 0xc7, 0x80,
			0x75, 0x6e, 0x60, 0x1c, 0x42, 0x40, 0xa0, 0x31,
			0xb8, 0x91, 0xcd, 0x84, 0xa5, 0xe3, 0x75, 0x15,
			0x3e, 0xa9, 0x6a, 0x19, 0x5a, 0x04, 0x5f, 0x9d,
			0x2f, 0x6e, 0x9c, 0x16, 0x46, 0x69, 0x65, 0xb0,
			0x3c, 0xf1, 0xcc, 0x7c, 0xbe, 0x5e, 0xef, 0x5c,
			0xf2, 0xf3, 0xb3, 0x48, 0x72, 0xa9, 0xe0, 0xc1,
		},
		20, /* salt length */
		/* V3 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA224 [4] */
	{
		/* Msg4 : 128 byte */
		{
			0x92, 0xb4, 0x9b, 0x6d, 0x13, 0xbb, 0x26, 0x2f,
			0xea, 0x22, 0x6d, 0x23, 0xee, 0xb4, 0x23, 0x05,
			0x80, 0x9a, 0xd6, 0xf8, 0xc1, 0xc7, 0xc4, 0x12,
			0x03, 0x93, 0xf1, 0x1b, 0x7d, 0xa5, 0x76, 0x92,
			0x42, 0x17, 0x1c, 0xf1, 0x74, 0xd5, 0x29, 0x33,
			0xb4, 0x46, 0x7a, 0x92, 0xde, 0x2f, 0xd2, 0x95,
			0xf3, 0xd4, 0x72, 0x4a, 0x57, 0x60, 0xea, 0xd0,
			0x3d, 0x86, 0x2e, 0x19, 0x5f, 0x69, 0xec, 0xee,
			0xf2, 0xb9, 0x1d, 0x34, 0xd9, 0x1f, 0xdb, 0x6d,
			0x19, 0xdc, 0x72, 0x82, 0x8d, 0xad, 0xb9, 0xbf,
			0xdb, 0xf1, 0xa3, 0x1f, 0xa6, 0x0d, 0x11, 0xca,
			0x05, 0x10, 0xea, 0xdc, 0x34, 0x93, 0x6e, 0x68,
			0x8a, 0xe4, 0xc7, 0xbd, 0xab, 0x63, 0xe1, 0xe7,
			0xff, 0x2b, 0x7c, 0x79, 0x63, 0xf5, 0x80, 0x8a,
			0x1e, 0x3a, 0x90, 0xfe, 0x16, 0x98, 0xe1, 0x07,
			0x44, 0x77, 0x4d, 0xea, 0x65, 0xec, 0xa3, 0x07,
		},
		/* S4 : 192 byte */
		{
			0x50, 0x61, 0xe2, 0xce, 0x0d, 0x28, 0x98, 0x0e,
			0x6b, 0x5b, 0x59, 0x89, 0x8d, 0x66, 0xaf, 0xcc,
			0xee, 0x4b, 0x94, 0xec, 0x38, 0x0e, 0x01, 0xda,
			0x4c, 0x2a, 0x91, 0x4f, 0x9e, 0x29, 0x20, 0x26,
			0x8b, 0xfb, 0xdc, 0x80, 0xeb, 0x3e, 0xa3, 0x51,
			0xfd, 0x91, 0xf8, 0xa5, 0xe6, 0x83, 0x1f, 0x53,
			0x49, 0x61, 0x0b, 0x8e, 0x44, 0x59, 0x78, 0x94,
			0xd2, 0x03, 0x43, 0xb6, 0x79, 0x7c, 0xa4, 0x1f,
			0xe7, 0x79, 0x2e, 0x4a, 0xe8, 0xf2, 0x1b, 0x3b,
			0xff, 0x2f, 0xab, 0x52, 0x76, 0xc6, 0xa9, 0x6e,
			0x50, 0xae, 0xad, 0x06, 0x11, 0x40, 0x68, 0xbe,
			0x82, 0x5f, 0xc1, 0xeb, 0xee, 0xee, 0xe8, 0x15,
			0xbf, 0x83, 0xec, 0x08, 0x53, 0x90, 0x06, 0x7e,
			0x0d, 0x55, 0xfe, 0x92, 0x9c, 0x17, 0xf3, 0x32,
			0xe9, 0x57, 0x3b, 0x63, 0x4b, 0x93, 0xb9, 0x82,
			0x5f, 0x7a, 0x3e, 0x89, 0x16, 0x99, 0xa2, 0xab,
			0x93, 0xe4, 0x3b, 0x5d, 0xe3, 0x48, 0x19, 0xa1,
			0x79, 0xc0, 0x97, 0x5f, 0x15, 0x96, 0x6e, 0xc9,
			0x3e, 0x30, 0x73, 0xd1, 0x29, 0xf9, 0x63, 0xb7,
			0x63, 0x0c, 0x7c, 0x09, 0x57, 0x9e, 0xa9, 0x20,
			0x6b, 0x15, 0xd8, 0x98, 0x18, 0x3b, 0xba, 0x36,
			0x22, 0x37, 0x50, 0x8b, 0xa2, 0x4c, 0x45, 0xd0,
			0xca, 0xb8, 0xaa, 0xae, 0x7d, 0x27, 0x02, 0x96,
			0xd9, 0x02, 0xd2, 0x24, 0x3c, 0x98, 0x4f, 0xbb,
		},
		20, /* salt length */
		/* V4 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA224 [5] */
	{
		/* Msg5 : 128 byte */
		{
			0xf6, 0x4f, 0xa5, 0x2e, 0xe3, 0x08, 0x40, 0x51,
			0xe1, 0x18, 0x2d, 0x74, 0x01, 0x61, 0x99, 0x9c,
			0x80, 0x3b, 0x49, 0x0c, 0xeb, 0x0c, 0xdf, 0x71,
			0x86, 0x19, 0x5a, 0x5d, 0xef, 0x9b, 0xdd, 0xf6,
			0xff, 0x16, 0xb1, 0xf0, 0xf1, 0xe6, 0x8c, 0xb8,
			0xc6, 0x1a, 0x14, 0xf2, 0xe7, 0x86, 0x9f, 0x26,
			0x0d, 0x14, 0x3d, 0xb6, 0x5e, 0x5b, 0xf8, 0x14,
			0xd9, 0x73, 0x5a, 0x31, 0xf3, 0x07, 0x30, 0x39,
			0x82, 0xab, 0x8e, 0x7d, 0xdb, 0x70, 0x13, 0xb1,
			0x37, 0xb6, 0x6e, 0x57, 0x5c, 0x42, 0x21, 0x7b,
			0x79, 0x91, 0x85, 0xa1, 0x51, 0x6b, 0x0f, 0xfc,
			0x9b, 0xbb, 0xd1, 0xe0, 0xa9, 0x9d, 0x44, 0x7a,
			0x49, 0xb9, 0x44, 0xbf, 0xe9, 0xd0, 0x5c, 0xa2,
			0xfe, 0x94, 0x44, 0x8a, 0xa6, 0xbd, 0xa8, 0x03,
			0x8b, 0x59, 0x2b, 0xb3, 0x0b, 0x63, 0xac, 0x91,
			0x97, 0x98, 0xc8, 0x51, 0x59, 0x86, 0xa0, 0x22,
		},
		/* S5 : 192 byte */
		{
			0x3a, 0xed, 0xa6, 0x50, 0xa0, 0xdc, 0x5f, 0x86,
			0x78, 0x01, 0xa6, 0xe4, 0xb3, 0xe9, 0x54, 0xc0,
			0x5b, 0x30, 0x28, 0x28, 0x94, 0xcc, 0x66, 0x6f,
			0xe8, 0x79, 0xde, 0xd7, 0xab, 0x5e, 0xc0, 0x9a,
			0xb5, 0xb0, 0x12, 0xf6, 0x48, 0x33, 0xe4, 0x9f,
			0x6d, 0xdb, 0x2c, 0xea, 0xde, 0x98, 0xad, 0x0a,
			0x53, 0x8e, 0x79, 0x93, 0xbc, 0x24, 0x66, 0x9d,
			0xf7, 0x4b, 0x94, 0xf4, 0x2f, 0xc9, 0x15, 0xfe,
			0x79, 0x51, 0xc4, 0x97, 0xd4, 0x9c, 0xc3, 0x0e,
			0x75, 0xb3, 0x5e, 0x7f, 0x62, 0x65, 0x79, 0xe2,
			0x3d, 0xdf, 0xea, 0x55, 0x45, 0x66, 0x73, 0x45,
			0x66, 0xd4, 0x5f, 0xe7, 0x4b, 0xb5, 0xc5, 0x1a,
			0x4f, 0x7d, 0x73, 0xea, 0x00, 0xb6, 0x46, 0xc2,
			0xb9, 0x71, 0xbd, 0x24, 0xa8, 0xa9, 0xc2, 0xae,
			0x39, 0x20, 0x33, 0x12, 0x9b, 0xf9, 0xc8, 0x07,
			0x03, 0x14, 0xe5, 0x7b, 0x0c, 0x94, 0x1b, 0x2d,
			0x4e, 0xff, 0x23, 0xe2, 0x74, 0xd3, 0xc5, 0x5d,
			0xbd, 0x75, 0x21, 0x40, 0x79, 0x99, 0x4a, 0x2c,
			0x5b, 0x57, 0x25, 0x8a, 0x68, 0xc5, 0x5b, 0xd4,
			0x9a, 0x44, 0x62, 0xe4, 0xf6, 0xcb, 0x1e, 0xb8,
			0x25, 0xae, 0x6e, 0x4f, 0x3e, 0xdf, 0x96, 0x60,
			0xcb, 0x33, 0xaa, 0x52, 0xbf, 0x45, 0x22, 0xdc,
			0x24, 0xb8, 0xac, 0x6c, 0x32, 0x6f, 0xe9, 0xe6,
			0x20, 0x6b, 0xf2, 0x73, 0x49, 0xd1, 0x55, 0xc9,
		},
		20, /* salt length */
		/* V5 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA224 [6] */
	{
		/* Msg6 : 128 byte */
		{
			0x31, 0x69, 0x79, 0xd5, 0x08, 0xc9, 0xeb, 0x08,
			0x13, 0xf9, 0xa5, 0x39, 0xa8, 0x0a, 0x46, 0x18,
			0x00, 0x5c, 0x7d, 0x2b, 0xe0, 0xb4, 0xcc, 0x7b,
			0x79, 0x8e, 0x8c, 0x8d, 0x8e, 0xb5, 0x32, 0x93,
			0xd4, 0x10, 0xd0, 0xe4, 0x9e, 0xbf, 0xdf, 0xaa,
			0xb9, 0x67, 0x3b, 0xda, 0x95, 0xc9, 0x6f, 0x6a,
			0xa6, 0x9a, 0x33, 0xbe, 0x0a, 0x8e, 0x33, 0x63,
			0x6c, 0xb7, 0x12, 0xff, 0x28, 0x0d, 0xaf, 0x88,
			0xb0, 0x4e, 0xa7, 0xb5, 0x2e, 0x08, 0x1b, 0xb2,
			0x6b, 0xf3, 0xb3, 0x18, 0xef, 0x85, 0xe2, 0x1c,
			0x6a, 0xc1, 0x6c, 0x07, 0x52, 0x50, 0x26, 0xe6,
			0xce, 0xd2, 0xfd, 0x82, 0xd3, 0x76, 0x3a, 0x92,
			0x8c, 0xc8, 0x05, 0x30, 0x00, 0xcb, 0x27, 0x8a,
			0xef, 0x48, 0x14, 0xda, 0xfc, 0x65, 0x28, 0x98,
			0x12, 0x79, 0x31, 0xed, 0x00, 0x1f, 0x2e, 0x6c,
			0x66, 0x8a, 0x56, 0xfd, 0xd5, 0x18, 0x5c, 0x19,
		},
		/* S6 : 192 byte */
		{
			0x54, 0x7c, 0x0e, 0x18, 0x9e, 0x38, 0xc2, 0xec,
			0xfe, 0xbc, 0x4e, 0x52, 0x23, 0x27, 0x1e, 0x70,
			0xc0, 0x33, 0x6e, 0x98, 0x0c, 0x9b, 0x61, 0x1a,
			0xf4, 0x40, 0xb6, 0x8c, 0x9d, 0x4f, 0xa0, 0x05,
			0x2a, 0x42, 0x96, 0xbe, 0x04, 0x2c, 0x44, 0x77,
			0x18, 0x79, 0xab, 0xe7, 0x1f, 0xf5, 0x61, 0x00,
			0x5d, 0x7b, 0x50, 0xb2, 0xd3, 0x44, 0x57, 0xa1,
			0xba, 0x30, 0xa7, 0x89, 0x00, 0x7f, 0x51, 0x54,
			0x99, 0xe9, 0xf1, 0xd6, 0x1a, 0x82, 0xc4, 0xcb,
			0xbe, 0xb4, 0xce, 0x82, 0x51, 0xb7, 0x64, 0xb3,
			0x77, 0xad, 0xaf, 0xa2, 0xa2, 0x76, 0x8b, 0x34,
			0xbe, 0x1e, 0xb9, 0x48, 0x90, 0x20, 0x71, 0x0c,
			0x61, 0x9a, 0xbc, 0x33, 0x76, 0x9d, 0xdb, 0x3f,
			0xf4, 0xd5, 0xe6, 0x0d, 0xf8, 0xed, 0xd0, 0xcb,
			0x28, 0x8c, 0xcf, 0x5c, 0x73, 0x20, 0x10, 0x66,
			0xbd, 0x70, 0xba, 0x09, 0xbb, 0x76, 0x56, 0x74,
			0xe6, 0x1b, 0xf5, 0xb0, 0x4e, 0xd7, 0x36, 0x0a,
			0xc5, 0x0b, 0x34, 0xba, 0xb9, 0xf7, 0x3e, 0xa1,
			0x76, 0x52, 0x39, 0x8f, 0x80, 0x0b, 0x81, 0x45,
			0xd7, 0x54, 0x46, 0x88, 0x85, 0x8d, 0x7c, 0x55,
			0xa0, 0x1c, 0xcf, 0xbd, 0xb4, 0x0d, 0xb2, 0xad,
			0xd7, 0x29, 0x80, 0x0e, 0xc5, 0xca, 0xf7, 0x39,
			0xf5, 0x42, 0x01, 0x62, 0xcd, 0xd0, 0xfc, 0x98,
			0xeb, 0xe5, 0xad, 0x00, 0x4e, 0x4f, 0xf5, 0x89,
		},
		20, /* salt length */
		/* V6 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA224 [7] */
	{
		/* Msg7 : 128 byte */
		{
			0xdc, 0xe8, 0xfa, 0xd3, 0x0c, 0x47, 0x51, 0xb2,
			0x06, 0xd4, 0x78, 0x14, 0x97, 0x3b, 0x3a, 0x2c,
			0x77, 0x61, 0xb7, 0x27, 0x70, 0xf7, 0xac, 0x5f,
			0xc2, 0x50, 0xf4, 0xd2, 0xc7, 0x6f, 0x4f, 0xd2,
			0xd3, 0x65, 0x63, 0xfe, 0x5e, 0xda, 0x00, 0x70,
			0x65, 0xe9, 0xa8, 0x38, 0x0d, 0x31, 0x4f, 0x09,
			0x8a, 0x28, 0x5f, 0x33, 0x3f, 0xb3, 0xff, 0xd1,
			0x26, 0xf4, 0x95, 0x44, 0x73, 0x63, 0x89, 0xe0,
			0x74, 0x21, 0x4d, 0xe4, 0xbc, 0x89, 0x9a, 0xb0,
			0x80, 0x07, 0xfc, 0x32, 0x41, 0x2d, 0x90, 0xa2,
			0xab, 0x03, 0x0c, 0x6f, 0xbe, 0x9f, 0x01, 0x79,
			0x2b, 0xf6, 0x5d, 0x80, 0x01, 0xf2, 0x34, 0xdc,
			0x88, 0xc5, 0xc0, 0x6f, 0x6d, 0x7c, 0xa6, 0xd9,
			0x20, 0xd7, 0x7a, 0xea, 0x7b, 0x58, 0x86, 0x5d,
			0xa4, 0x9a, 0xc7, 0xc3, 0x34, 0xe4, 0x39, 0xbd,
			0x99, 0xfe, 0x55, 0x6e, 0xb9, 0x43, 0xd7, 0x30,
		},
		/* S7 : 192 byte */
		{
			0x80, 0x6b, 0x69, 0x17, 0x6e, 0x24, 0xfe, 0xc5,
			0x4f, 0xca, 0x47, 0xea, 0xc5, 0xf3, 0x56, 0x01,
			0x96, 0x01, 0x7d, 0xce, 0x35, 0x1f, 0x65, 0x44,
			0x5b, 0xa0, 0x07, 0x75, 0xa4, 0x65, 0xe5, 0x9c,
			0x6b, 0x87, 0xfc, 0xa4, 0x57, 0xd6, 0x79, 0x7d,
			0x97, 0xcc, 0xc9, 0xd9, 0x40, 0xc5, 0xa5, 0x31,
			0xb8, 0x01, 0x7f, 0xaa, 0x12, 0xff, 0x5a, 0x5e,
			0xc1, 0xc1, 0x4b, 0x5f, 0x81, 0x31, 0x67, 0xa7,
			0x83, 0x29, 0xd5, 0x67, 0x4e, 0xe8, 0x94, 0x2d,
			0xc2, 0xb2, 0x11, 0x09, 0x69, 0x3d, 0xfd, 0x69,
			0xdf, 0xbd, 0x49, 0x35, 0x9f, 0xe0, 0x9e, 0xa3,
			0x8b, 0xdc, 0x4c, 0x30, 0x8b, 0xd4, 0xda, 0xae,
			0xc5, 0xf9, 0x52, 0x73, 0x4b, 0xc0, 0xe6, 0x66,
			0x0a, 0x1c, 0xed, 0x76, 0x3b, 0x70, 0xde, 0xd3,
			0x80, 0xd7, 0x84, 0xf2, 0x39, 0xaa, 0x17, 0xe6,
			0x0f, 0xb6, 0x36, 0x57, 0x5f, 0x59, 0xaa, 0x61,
			0x5d, 0x81, 0x1d, 0x87, 0xdf, 0xe6, 0x71, 0xdf,
			0x8b, 0x36, 0x06, 0x48, 0x75, 0x68, 0xab, 0x82,
			0xf5, 0xe9, 0x5e, 0x50, 0x38, 0x1a, 0xe9, 0xe5,
			0x06, 0x8d, 0x3f, 0xb7, 0xe1, 0x26, 0xf7, 0x4a,
			0x24, 0xd2, 0xa3, 0x16, 0x96, 0xa8, 0x70, 0x2d,
			0x1a, 0xbb, 0xa1, 0xe7, 0x36, 0xd6, 0xad, 0xc0,
			0x7d, 0xcb, 0xc3, 0xb9, 0x2f, 0x77, 0x82, 0x11,
			0x18, 0x45, 0x6c, 0xb4, 0x27, 0x02, 0xc5, 0x16,
		},
		20, /* salt length */
		/* V7 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA224 [8] */
	{
		/* Msg8 : 128 byte */
		{
			0x26, 0x5b, 0x1e, 0xa2, 0xe1, 0x31, 0xc5, 0x6f,
			0x74, 0xc8, 0x50, 0x20, 0xa7, 0x99, 0xe2, 0x9d,
			0xd6, 0x60, 0xd5, 0x29, 0x43, 0x22, 0xac, 0x89,
			0xb0, 0x6f, 0x49, 0x69, 0x2e, 0xe5, 0x61, 0xfb,
			0x30, 0xf5, 0x2c, 0xe1, 0xe3, 0xea, 0x61, 0x4d,
			0xc2, 0x26, 0x61, 0x67, 0x65, 0xaf, 0xb2, 0xef,
			0x99, 0xeb, 0xb0, 0x23, 0xb6, 0xa8, 0x7f, 0xe3,
			0x2d, 0x5f, 0x44, 0x13, 0x61, 0xba, 0x95, 0x41,
			0xb8, 0x53, 0x2e, 0x87, 0xf1, 0xbf, 0xe5, 0xb3,
			0xb8, 0xcb, 0xe0, 0xa6, 0x77, 0x05, 0x05, 0xfa,
			0x70, 0x7f, 0xb2, 0xe8, 0x09, 0xcf, 0xae, 0x68,
			0x66, 0x5a, 0x60, 0x99, 0x3d, 0xd3, 0x3f, 0x64,
			0xe6, 0xfe, 0x8a, 0x5c, 0xb2, 0xba, 0x39, 0xe9,
			0x7e, 0x3e, 0x33, 0xa6, 0x88, 0xa3, 0xc1, 0x07,
			0x81, 0xa3, 0x43, 0x3f, 0xe3, 0xa0, 0x22, 0x61,
			0x84, 0xe7, 0x05, 0xc5, 0x6c, 0x37, 0x48, 0xad,
		},
		/* S8 : 192 byte */
		{
			0x66, 0x47, 0x22, 0x5a, 0x90, 0x2b, 0x41, 0x08,
			0x3b, 0xcc, 0xb8, 0x93, 0x47, 0x56, 0x20, 0x13,
			0xc7, 0xfe, 0xfd, 0x8c, 0x0f, 0xa3, 0xcc, 0xea,
			0x39, 0x41, 0x7d, 0x6e, 0xe1, 0x2b, 0x96, 0xb8,
			0x8b, 0x45, 0xa5, 0x62, 0xd6, 0xe7, 0x5c, 0x42,
			0xbb, 0xe2, 0xc7, 0xf5, 0xb4, 0x19, 0x35, 0xf8,
			0xc9, 0x8d, 0xae, 0xd1, 0x19, 0x19, 0xe1, 0x9a,
			0xda, 0xb2, 0x16, 0x48, 0x12, 0xfa, 0xbc, 0x53,
			0x30, 0xc8, 0x81, 0x0b, 0x18, 0x77, 0x51, 0xa5,
			0xd1, 0x27, 0x49, 0xd5, 0x61, 0x51, 0x37, 0xb1,
			0xf3, 0x83, 0xbb, 0xac, 0xc0, 0x6f, 0x01, 0x59,
			0x3f, 0x66, 0xd8, 0x04, 0x5f, 0x93, 0x55, 0x70,
			0x6b, 0xae, 0x57, 0xcd, 0xcf, 0x24, 0x3d, 0x11,
			0x3d, 0xce, 0xd9, 0x55, 0x63, 0x01, 0x04, 0x7a,
			0x25, 0xaf, 0xa6, 0x64, 0x95, 0x06, 0x5c, 0xbe,
			0x4a, 0xa0, 0x66, 0xb2, 0xe6, 0x7b, 0x7d, 0x7b,
			0xc1, 0x8e, 0x68, 0x42, 0x0b, 0x64, 0x45, 0xaf,
			0xd9, 0x21, 0x06, 0x48, 0xb3, 0xc1, 0x09, 0x06,
			0xa5, 0xf0, 0xfd, 0x97, 0x2c, 0x38, 0x9e, 0x56,
			0x15, 0x90, 0x60, 0xc3, 0xda, 0x23, 0x78, 0x83,
			0xc7, 0x52, 0xc0, 0x8c, 0x75, 0xd4, 0xe8, 0x0e,
			0x2d, 0x38, 0xd4, 0x12, 0x8b, 0x07, 0xb6, 0x8f,
			0x57, 0xc9, 0x0e, 0xdb, 0x01, 0x4f, 0x6d, 0xa1,
			0xa3, 0xab, 0x0b, 0x46, 0x6c, 0xa8, 0x96, 0x92,
		},
		20, /* salt length */
		/* V8 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA224 [9] */
	{
		/* Msg9 : 128 byte */
		{
			0x2a, 0x06, 0xba, 0xb7, 0xa2, 0xa8, 0xf5, 0xe3,
			0xca, 0x74, 0x08, 0x88, 0x80, 0x9f, 0xe2, 0x29,
			0x52, 0x4d, 0xa5, 0xae, 0x93, 0x58, 0x5b, 0x4f,
			0xae, 0x4d, 0xe5, 0xb3, 0xbb, 0xb8, 0x33, 0x59,
			0x50, 0xa2, 0xbb, 0x38, 0x9a, 0x57, 0x23, 0xa2,
			0xac, 0x6d, 0x41, 0x6e, 0x16, 0x01, 0x46, 0x56,
			0xba, 0x44, 0x36, 0x9e, 0xdb, 0x37, 0x9c, 0xf7,
			0x77, 0xb2, 0x7b, 0xa2, 0xd7, 0xab, 0x87, 0xd8,
			0x64, 0xb5, 0x95, 0x6a, 0xbc, 0xc7, 0x51, 0xa5,
			0x05, 0x3f, 0x2f, 0x78, 0x82, 0x26, 0xa4, 0xd9,
			0x63, 0xb6, 0x95, 0x64, 0xe2, 0x19, 0x10, 0x45,
			0x8b, 0x74, 0x3a, 0x59, 0xdb, 0x24, 0x88, 0x90,
			0x0d, 0x48, 0x32, 0x96, 0x31, 0x7f, 0xe5, 0xb2,
			0x7e, 0xf3, 0xb9, 0xee, 0xe9, 0x96, 0x62, 0x78,
			0xf7, 0xab, 0xaa, 0x48, 0xcf, 0x89, 0x1f, 0x03,
			0x93, 0x9b, 0x08, 0x1f, 0xf0, 0xac, 0x9e, 0x49,
		},
		/* S9 : 192 byte */
		{
			0x27, 0x3a, 0xf9, 0x3d, 0x9d, 0x96, 0xce, 0x40,
			0x0e, 0xd1, 0x54, 0x37, 0x4c, 0x8c, 0xc6, 0x0c,
			0xc9, 0xa4, 0xc2, 0x94, 0x4d, 0xa6, 0x58, 0x7d,
			0xf8, 0xd7, 0xf9, 0x34, 0x78, 0x8e, 0x9a, 0x11,
			0xc0, 0xe0, 0x94, 0x80, 0x8a, 0xc7, 0x59, 0x59,
			0x9b, 0x74, 0x0a, 0xfd, 0x27, 0xd8, 0xe3, 0xfe,
			0x3a, 0xe6, 0xd6, 0x86, 0xb1, 0xd8, 0x5a, 0x29,
			0xc2, 0x64, 0xfb, 0xc1, 0x5c, 0xc6, 0x1b, 0x23,
			0x10, 0xc5, 0xd4, 0xcc, 0x1e, 0x80, 0xae, 0x59,
			0x9f, 0x68, 0xcf, 0xed, 0xd8, 0x53, 0xe5, 0xaf,
			0x81, 0xca, 0x48, 0x68, 0x13, 0x80, 0xc1, 0x43,
			0x1f, 0x2a, 0xad, 0xf5, 0x91, 0xc4, 0xed, 0x08,
			0x2a, 0xad, 0xc1, 0xff, 0x2e, 0x38, 0x92, 0x0b,
			0x81, 0x34, 0x4c, 0xfe, 0xc8, 0x17, 0x0d, 0x16,
			0x03, 0xc5, 0xf7, 0x0c, 0xe1, 0x6a, 0x93, 0xe3,
			0x71, 0xb6, 0xc8, 0xab, 0xf8, 0x53, 0xd5, 0x6d,
			0x86, 0x51, 0x91, 0x6c, 0xe8, 0xdb, 0x18, 0x75,
			0x38, 0xdc, 0x2a, 0xff, 0x47, 0x12, 0x3a, 0x48,
			0xc3, 0xe1, 0x56, 0x1b, 0x47, 0x7d, 0x37, 0xa0,
			0x8e, 0x05, 0xa8, 0x23, 0x92, 0x49, 0x29, 0x89,
			0x3e, 0x16, 0xe8, 0xb8, 0xbb, 0x4c, 0xbe, 0x8d,
			0x35, 0xfb, 0x9c, 0x00, 0xa7, 0xe2, 0x79, 0xfb,
			0x60, 0xcf, 0x2c, 0xba, 0x06, 0xbe, 0x34, 0x63,
			0x0d, 0xfc, 0x66, 0x26, 0xe9, 0xc2, 0xd5, 0xa6,
		},
		20, /* salt length */
		/* V9 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
};

/* 10 elements */
static mod1536_t SHA256[] = {
	/* SHA256 [0] */
	{
		/* Msg0 : 128 byte */
		{
			0xb1, 0xe9, 0x73, 0xf2, 0x13, 0x03, 0xaa, 0x00,
			0x11, 0xd4, 0x16, 0x64, 0x2c, 0xec, 0xd4, 0x55,
			0x11, 0x54, 0x9b, 0x45, 0xbd, 0x22, 0xf9, 0x10,
			0xe4, 0x4b, 0xdf, 0x7a, 0x94, 0xb9, 0x60, 0xd8,
			0x16, 0x9d, 0xb6, 0x0d, 0x15, 0x07, 0x86, 0xb8,
			0x01, 0xb4, 0x65, 0xac, 0xb6, 0x26, 0x9a, 0xa1,
			0x59, 0xfa, 0x25, 0x29, 0x83, 0x77, 0x01, 0xe5,
			0xa2, 0x63, 0xa7, 0xf8, 0x9c, 0x1a, 0xd3, 0xbc,
			0xb5, 0xe1, 0x8a, 0xb4, 0xb2, 0x77, 0x5c, 0xc2,
			0x3e, 0xed, 0xe7, 0x9a, 0x8e, 0xb8, 0x9c, 0x77,
			0x41, 0x05, 0xc6, 0x0d, 0x8a, 0x4c, 0xc7, 0xbe,
			0x90, 0x28, 0xa5, 0x10, 0x15, 0x66, 0xc6, 0x5f,
			0x56, 0x5b, 0xf8, 0xcf, 0x33, 0x7b, 0xb5, 0x85,
			0x90, 0x28, 0xa4, 0x17, 0xfb, 0xc8, 0x62, 0x40,
			0x8f, 0x1a, 0x83, 0xd9, 0x18, 0xca, 0xd4, 0x04,
			0x78, 0x43, 0xe3, 0xab, 0x49, 0xc4, 0xc2, 0x29,
		},
		/* S0 : 192 byte */
		{
			0x8e, 0xb2, 0xba, 0x23, 0x67, 0xb8, 0xf0, 0xb3,
			0x6b, 0x56, 0x6c, 0x93, 0x8b, 0x4d, 0x99, 0x48,
			0xb4, 0xa0, 0xa8, 0x7d, 0xd1, 0xc8, 0x30, 0x0a,
			0x16, 0x0e, 0xc0, 0x24, 0xad, 0x0f, 0xa3, 0x71,
			0x74, 0xd1, 0xbb, 0xa2, 0xae, 0x6e, 0xe8, 0xc7,
			0xfd, 0xbb, 0x4d, 0x17, 0x2a, 0xc9, 0x61, 0x5f,
			0x14, 0x28, 0x59, 0x90, 0x30, 0xa3, 0x35, 0x15,
			0xe2, 0x92, 0x5a, 0x26, 0x8b, 0x87, 0xc8, 0x67,
			0x24, 0x2c, 0xcd, 0xdc, 0xce, 0x6c, 0x9c, 0x03,
			0x04, 0x5e, 0xcc, 0xbf, 0xee, 0x5e, 0xeb, 0x6e,
			0x0c, 0xe2, 0xd8, 0x9a, 0x9c, 0x51, 0xf4, 0x0c,
			0x17, 0x32, 0x92, 0x7a, 0x6c, 0x7d, 0x28, 0x36,
			0x27, 0xdd, 0x87, 0xec, 0xa2, 0x72, 0x70, 0xb1,
			0x17, 0xe6, 0x58, 0xa3, 0xcc, 0x9d, 0x2c, 0xa7,
			0xda, 0x46, 0xa7, 0x60, 0x97, 0x21, 0x3a, 0x7f,
			0x3e, 0x2a, 0x58, 0xd7, 0xc9, 0xd3, 0x06, 0xe7,
			0x96, 0xee, 0xe9, 0x48, 0x09, 0x04, 0x2b, 0xc6,
			0x76, 0x8d, 0x6c, 0xca, 0x4e, 0x00, 0x3a, 0x40,
			0x52, 0x9b, 0xff, 0xa2, 0x67, 0x91, 0x4a, 0x23,
			0x2f, 0x31, 0x5d, 0xde, 0xdd, 0x27, 0x68, 0xc6,
			0x08, 0x77, 0xbd, 0xcb, 0x05, 0xc8, 0xf2, 0x02,
			0x61, 0x79, 0x71, 0x30, 0x84, 0xa0, 0xda, 0xf8,
			0xb4, 0x94, 0x95, 0x9c, 0x34, 0x7f, 0xb6, 0x5a,
			0x44, 0x14, 0x03, 0x4d, 0x21, 0xc7, 0xa7, 0x50,
		},
		20, /* salt length */
		/* V0 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA256 [1] */
	{
		/* Msg1 : 128 byte */
		{
			0x39, 0xab, 0x56, 0x41, 0xed, 0x11, 0xdd, 0xc0,
			0x70, 0xc3, 0x56, 0xeb, 0x6f, 0x8b, 0xef, 0x88,
			0xa5, 0x06, 0x67, 0xa5, 0xf4, 0x60, 0xc6, 0x82,
			0xb4, 0x5f, 0x4c, 0xab, 0x4b, 0xa3, 0xa7, 0x65,
			0xfd, 0x2c, 0x69, 0x4b, 0x06, 0x1c, 0xb8, 0x39,
			0xe6, 0xbe, 0x47, 0x69, 0xfd, 0xc8, 0x86, 0xdc,
			0x57, 0xdd, 0x16, 0xfc, 0xc9, 0x56, 0x80, 0x7f,
			0x3d, 0x42, 0x26, 0x8e, 0x4a, 0xab, 0x7a, 0x27,
			0x08, 0x1c, 0x6d, 0xc0, 0x22, 0x5f, 0x2b, 0x2d,
			0x2c, 0x8b, 0x05, 0xc3, 0x37, 0x3f, 0xae, 0xbe,
			0xa3, 0x28, 0xab, 0xe0, 0x35, 0xc9, 0x05, 0x5b,
			0x69, 0x7b, 0x41, 0xf1, 0x0a, 0xb2, 0x91, 0x5a,
			0xff, 0x83, 0x4c, 0xe6, 0x68, 0x63, 0x9c, 0x63,
			0xea, 0x32, 0x77, 0x41, 0x46, 0x78, 0xd0, 0xf4,
			0x31, 0xee, 0x0e, 0x9a, 0x60, 0x40, 0xbd, 0xde,
			0xe2, 0x11, 0x83, 0x1c, 0xb2, 0x3f, 0x56, 0xc6,
		},
		/* S1 : 192 byte */
		{
			0x83, 0x82, 0x6d, 0xce, 0x62, 0xd9, 0x51, 0xec,
			0x70, 0x6a, 0x24, 0x15, 0x02, 0x2c, 0xfa, 0x25,
			0xf3, 0x98, 0x01, 0xa5, 0xa6, 0xb5, 0xe0, 0xba,
			0xe9, 0x2a, 0xc5, 0xae, 0x65, 0xf1, 0x29, 0x94,
			0x2b, 0x72, 0xed, 0xaa, 0x71, 0xf1, 0x03, 0xfc,
			0x8b, 0xaa, 0xd5, 0x89, 0x09, 0x5f, 0x04, 0x5a,
			0x36, 0xef, 0x00, 0x49, 0x04, 0x6c, 0x7d, 0x17,
			0xcb, 0xf6, 0x8e, 0xef, 0x96, 0xec, 0x1b, 0xf4,
			0xdd, 0x63, 0x8a, 0xbf, 0x58, 0xf4, 0x54, 0x63,
			0xe0, 0x96, 0xeb, 0x37, 0x8c, 0x82, 0x8d, 0x3a,
			0x90, 0xef, 0xdf, 0xe5, 0x62, 0x5c, 0xc4, 0xf9,
			0xa8, 0xb2, 0x8a, 0xa3, 0x27, 0xa8, 0x07, 0x36,
			0x86, 0x6d, 0x92, 0xfb, 0x5d, 0x7b, 0xee, 0xce,
			0x62, 0xdd, 0x24, 0x26, 0x08, 0xf2, 0xa1, 0x65,
			0x7b, 0xdc, 0x74, 0x27, 0xdf, 0xdf, 0x75, 0x4a,
			0x0a, 0x79, 0xd7, 0x7e, 0x31, 0xb0, 0xb4, 0x47,
			0xbd, 0x52, 0xd8, 0x3c, 0x54, 0xac, 0x94, 0x2a,
			0xd6, 0xb7, 0xb3, 0x35, 0xc4, 0x21, 0x33, 0x8d,
			0xac, 0x57, 0xb9, 0x21, 0x9f, 0xad, 0x5c, 0x7a,
			0x37, 0xf8, 0xff, 0xd0, 0xad, 0x64, 0x7f, 0x8a,
			0x0b, 0x6c, 0x0e, 0x08, 0xf2, 0xfa, 0xdf, 0x67,
			0x33, 0x4b, 0xf9, 0x22, 0x90, 0x04, 0xce, 0x7d,
			0x72, 0x3f, 0x3d, 0xd7, 0x24, 0x4d, 0xf4, 0x50,
			0x7d, 0x6e, 0x6b, 0x0f, 0x92, 0xca, 0x95, 0x89,
		},
		20, /* salt length */
		/* V1 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA256 [2] */
	{
		/* Msg2 : 128 byte */
		{
			0xdf, 0x69, 0x2c, 0x2d, 0xfe, 0xfb, 0xe4, 0xfd,
			0xea, 0x6a, 0x43, 0x20, 0xff, 0xee, 0xac, 0x3d,
			0xdb, 0xfc, 0xd8, 0xfd, 0x16, 0x23, 0x25, 0x0f,
			0x2d, 0x34, 0x31, 0x70, 0xbe, 0xa5, 0xa8, 0xe9,
			0xfb, 0x37, 0x5a, 0xd9, 0x59, 0xd7, 0x91, 0x34,
			0x88, 0xc2, 0xa1, 0xcc, 0xa8, 0xed, 0xc0, 0xcf,
			0xba, 0xa4, 0x18, 0x91, 0x54, 0x71, 0x1b, 0x8c,
			0x99, 0x3f, 0x17, 0xa6, 0x69, 0xbf, 0x0a, 0xb2,
			0xd5, 0x0b, 0xb7, 0x38, 0xd6, 0x8a, 0xf9, 0x79,
			0x3e, 0x13, 0x58, 0xae, 0xee, 0x55, 0xda, 0x91,
			0x4a, 0x76, 0x1b, 0x1e, 0xea, 0xfa, 0xa0, 0x9b,
			0x92, 0xe7, 0x69, 0xd6, 0x65, 0x26, 0xc5, 0xae,
			0x55, 0x2d, 0x6b, 0xd4, 0xde, 0xdb, 0xc5, 0xd3,
			0xf4, 0xa3, 0x8f, 0x4e, 0x3a, 0xed, 0xa1, 0x89,
			0x74, 0xb9, 0x09, 0x2c, 0x3f, 0x86, 0x5d, 0x43,
			0x00, 0x72, 0x50, 0x88, 0x1a, 0xa2, 0x82, 0xe5,
		},
		/* S2 : 192 byte */
		{
			0x2d, 0x85, 0x04, 0xa3, 0x22, 0xb0, 0xb2, 0xe9,
			0xbf, 0x26, 0x1c, 0xaf, 0x4d, 0x8f, 0x34, 0x31,
			0x7b, 0x38, 0xff, 0xdf, 0xc9, 0xe7, 0x67, 0x52,
			0x1e, 0xec, 0xf8, 0x6e, 0xb4, 0x30, 0x3b, 0x38,
			0x29, 0xf9, 0x4b, 0x45, 0xe2, 0x46, 0x1c, 0x0a,
			0x03, 0x07, 0x43, 0x8a, 0x1a, 0x5d, 0x04, 0x91,
			0x40, 0x24, 0x61, 0xca, 0xe5, 0x6d, 0x3f, 0xe3,
			0x8f, 0xcb, 0x23, 0xa4, 0x65, 0x81, 0x59, 0x11,
			0x43, 0x34, 0x68, 0xad, 0x89, 0x97, 0xc9, 0xdd,
			0x19, 0x83, 0x31, 0xa1, 0xe3, 0x8f, 0x27, 0xd7,
			0x08, 0xa7, 0xdd, 0x11, 0xa9, 0x8f, 0x45, 0xd9,
			0x0b, 0xee, 0x65, 0x2f, 0x2a, 0x70, 0x9e, 0xef,
			0xcc, 0xb4, 0xfa, 0xc1, 0x3f, 0x11, 0x5c, 0xca,
			0x2f, 0xb2, 0x8a, 0xe2, 0x41, 0x38, 0x56, 0xb5,
			0x97, 0x38, 0xb4, 0x90, 0x11, 0x99, 0xce, 0x28,
			0x32, 0x14, 0xd0, 0x19, 0x40, 0x14, 0x1d, 0xd5,
			0x0b, 0xf4, 0xf4, 0x31, 0x85, 0xca, 0xe8, 0x31,
			0xc2, 0xfc, 0xf2, 0xe0, 0xf3, 0x3b, 0xc9, 0x08,
			0xad, 0x32, 0x51, 0xe0, 0xea, 0xb2, 0xd4, 0x00,
			0x26, 0xc3, 0x32, 0x5f, 0xfc, 0xdd, 0xc9, 0xc8,
			0xaf, 0xbe, 0x51, 0x83, 0x86, 0xad, 0x1f, 0xcd,
			0xf2, 0xb8, 0x0c, 0xe0, 0x74, 0xea, 0xe1, 0xcd,
			0x95, 0x3d, 0x96, 0x09, 0x20, 0x03, 0x5a, 0x29,
			0x49, 0xb6, 0x9b, 0x11, 0xad, 0xf2, 0xc5, 0x5e,
		},
		20, /* salt length */
		/* V2 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA256 [3] */
	{
		/* Msg3 : 128 byte */
		{
			0xd9, 0x19, 0x8f, 0xbd, 0xf1, 0xcd, 0xc2, 0x79,
			0x01, 0x0d, 0xf1, 0x5b, 0x49, 0xa9, 0xfd, 0xd6,
			0x41, 0xcd, 0xb5, 0x88, 0xda, 0x30, 0x3f, 0x12,
			0x07, 0x8d, 0xba, 0x26, 0x7c, 0x57, 0x21, 0xe2,
			0xb5, 0xa9, 0x72, 0x5c, 0x3b, 0x7c, 0x10, 0x7e,
			0x23, 0x1c, 0x66, 0x14, 0xd7, 0xdd, 0xce, 0x23,
			0x19, 0x09, 0xb1, 0x7c, 0x44, 0x1e, 0xef, 0x92,
			0xd5, 0x36, 0x81, 0x89, 0x2b, 0xc7, 0x5d, 0x8f,
			0x8b, 0x8c, 0x99, 0x6f, 0x67, 0xc3, 0xd4, 0x63,
			0xe0, 0x99, 0xd2, 0x2a, 0x89, 0xe3, 0x66, 0x5b,
			0x6e, 0x0e, 0x95, 0xf9, 0x55, 0x59, 0xf8, 0x47,
			0x43, 0x41, 0x62, 0xde, 0x42, 0x3d, 0xc3, 0xfc,
			0x62, 0xac, 0x4c, 0x1f, 0xfe, 0x0c, 0xd4, 0xd3,
			0x40, 0x6c, 0x7b, 0xc8, 0xe7, 0x24, 0x8d, 0x27,
			0x48, 0xc3, 0xa9, 0x26, 0x93, 0x49, 0x22, 0xdb,
			0x58, 0x97, 0xa5, 0x4d, 0x4a, 0x23, 0x1c, 0xd1,
		},
		/* S3 : 192 byte */
		{
			0x3b, 0xe3, 0x06, 0x38, 0x12, 0xa2, 0x4f, 0x11,
			0x68, 0x9d, 0x66, 0x18, 0x60, 0xfa, 0x8e, 0xe0,
			0x1a, 0xcf, 0x11, 0xeb, 0x21, 0x2c, 0x39, 0xd0,
			0x9b, 0x00, 0xeb, 0x4c, 0x56, 0x84, 0xb7, 0x73,
			0xac, 0xc1, 0x6f, 0xd3, 0x8c, 0x0b, 0x27, 0xf3,
			0x83, 0x07, 0xe2, 0xe2, 0x8c, 0x2a, 0x14, 0x16,
			0x00, 0x95, 0x17, 0xc4, 0x4b, 0xc7, 0x96, 0xe7,
			0xd4, 0xd7, 0xea, 0xcb, 0xfd, 0xe4, 0x8c, 0x57,
			0x74, 0x8c, 0x76, 0xda, 0x00, 0xb2, 0x97, 0x5d,
			0xdf, 0xd9, 0xbf, 0xf1, 0xff, 0xcf, 0x7c, 0x94,
			0xc8, 0xf5, 0x85, 0x26, 0xf6, 0x03, 0xad, 0x66,
			0x90, 0xbb, 0xfa, 0xb8, 0x8e, 0xd0, 0x3f, 0xb0,
			0xc8, 0x4c, 0x2b, 0x8a, 0xc4, 0x70, 0x63, 0xad,
			0xb1, 0x47, 0x80, 0x9e, 0x51, 0x73, 0x34, 0x8e,
			0x29, 0x58, 0xaa, 0x4f, 0x37, 0x8c, 0x99, 0x2a,
			0x23, 0xbe, 0xad, 0x7a, 0x57, 0x6e, 0x71, 0x00,
			0x6d, 0x66, 0xef, 0xdf, 0xb1, 0xcb, 0x03, 0xf8,
			0xaa, 0x73, 0x7e, 0x05, 0xb3, 0xb5, 0xbd, 0x3f,
			0x04, 0x73, 0xb6, 0x97, 0x93, 0x39, 0xef, 0x89,
			0xa1, 0xed, 0x19, 0xbb, 0x14, 0xff, 0x03, 0x23,
			0x5e, 0x7c, 0x17, 0xfe, 0xce, 0x60, 0x0c, 0x41,
			0x4e, 0x28, 0x17, 0xb9, 0x0c, 0xa6, 0xf6, 0xb3,
			0xe7, 0x20, 0x77, 0xd9, 0x36, 0xd7, 0x25, 0x60,
			0x3f, 0x4c, 0x19, 0xf9, 0x4b, 0xb8, 0xe0, 0x60,
		},
		20, /* salt length */
		/* V3 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA256 [4] */
	{
		/* Msg4 : 128 byte */
		{
			0x0b, 0xd0, 0xe3, 0x38, 0x7d, 0x0e, 0xb2, 0x71,
			0x1d, 0x8d, 0x54, 0x67, 0xe8, 0x69, 0x4c, 0x21,
			0x18, 0x02, 0x44, 0x30, 0x48, 0x97, 0x50, 0xe4,
			0xda, 0x17, 0x77, 0xc0, 0x96, 0x33, 0x70, 0x2c,
			0x93, 0xb8, 0xa9, 0x6a, 0x5b, 0x1c, 0x8e, 0xcb,
			0x4a, 0x56, 0x07, 0x23, 0x37, 0xf3, 0x42, 0x7a,
			0x57, 0x67, 0xb4, 0x04, 0x5d, 0xa1, 0x5a, 0x54,
			0xe6, 0xe2, 0x45, 0xcc, 0x15, 0xce, 0x55, 0x58,
			0x7a, 0xc4, 0x45, 0x5c, 0x39, 0x6b, 0xe7, 0xea,
			0x68, 0x8d, 0xb1, 0x39, 0xb8, 0x29, 0x79, 0x52,
			0x58, 0xc3, 0x7d, 0x0d, 0x16, 0xff, 0xa6, 0x3c,
			0xc8, 0x6e, 0x0e, 0x26, 0xea, 0xa8, 0xbf, 0x37,
			0x88, 0x9b, 0xbe, 0xf5, 0x5f, 0x22, 0x48, 0x36,
			0x3f, 0xda, 0x5b, 0x90, 0xb3, 0x31, 0x78, 0x12,
			0xe4, 0xbf, 0xa8, 0x31, 0xbb, 0xda, 0xbd, 0x05,
			0x46, 0x64, 0xda, 0xb6, 0x5d, 0xe8, 0x35, 0x31,
		},
		/* S4 : 192 byte */
		{
			0x0b, 0x72, 0x1a, 0xba, 0x52, 0x03, 0x3a, 0x45,
			0x75, 0xa0, 0x71, 0xc0, 0x1b, 0xe9, 0x4d, 0xed,
			0xf8, 0xda, 0x91, 0x8f, 0x86, 0xae, 0xe0, 0x50,
			0x80, 0x35, 0x72, 0xd7, 0x97, 0xe1, 0xb9, 0xfd,
			0x7d, 0xa7, 0x40, 0xd9, 0x32, 0xbe, 0xf6, 0x5a,
			0x99, 0xad, 0x1a, 0x6d, 0xb8, 0x88, 0x65, 0xa7,
			0xb4, 0xdf, 0x9a, 0x50, 0xb9, 0xa1, 0x54, 0x1f,
			0xbd, 0x58, 0x55, 0x54, 0x55, 0xe2, 0x4d, 0x9d,
			0xdf, 0xa6, 0xdd, 0x34, 0xc1, 0x5a, 0x16, 0x4b,
			0x37, 0x40, 0x69, 0x7d, 0x23, 0xf1, 0xfa, 0x94,
			0xbe, 0x32, 0x36, 0x19, 0xdd, 0x38, 0x33, 0x69,
			0x43, 0x7a, 0xe1, 0xab, 0x30, 0x3b, 0x72, 0xb5,
			0x0e, 0x43, 0x3d, 0x97, 0xb6, 0x6b, 0x74, 0x0f,
			0x90, 0xca, 0x25, 0x9a, 0x43, 0xbf, 0x71, 0x4f,
			0xaf, 0x5c, 0x4e, 0x76, 0x5f, 0x52, 0x77, 0x3c,
			0x7a, 0xe9, 0xb4, 0xde, 0xa1, 0x91, 0x0e, 0x16,
			0xce, 0x59, 0x5d, 0xd9, 0xbe, 0xf7, 0x71, 0x89,
			0xb8, 0x9b, 0xcc, 0x0d, 0xe8, 0x80, 0x51, 0xe4,
			0x5a, 0x94, 0x81, 0x96, 0xe8, 0x98, 0xe1, 0xf5,
			0x5e, 0x75, 0x6f, 0x74, 0xa5, 0xa7, 0xb3, 0xe0,
			0xe8, 0x74, 0x15, 0xed, 0x93, 0x70, 0x73, 0xbd,
			0x94, 0x6c, 0xb7, 0x7e, 0x62, 0x61, 0xcd, 0x5f,
			0x41, 0xcf, 0xeb, 0x0e, 0xf2, 0x21, 0x84, 0xe1,
			0x6d, 0xb4, 0x2c, 0x62, 0xd3, 0x7c, 0x4a, 0x6c,
		},
		20, /* salt length */
		/* V4 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA256 [5] */
	{
		/* Msg5 : 128 byte */
		{
			0xca, 0x6a, 0x65, 0x50, 0xab, 0x39, 0xe1, 0x67,
			0x0a, 0x6f, 0x82, 0xf5, 0x48, 0x39, 0xd5, 0x27,
			0x71, 0xc4, 0x62, 0x33, 0x6f, 0xa3, 0x82, 0xe1,
			0x7d, 0x71, 0x71, 0x4b, 0xde, 0xb7, 0xa4, 0xe0,
			0xce, 0x0f, 0x5d, 0xaf, 0xb9, 0x8a, 0x7c, 0xe3,
			0xab, 0x50, 0x98, 0x89, 0x08, 0x86, 0x4e, 0x9a,
			0x7d, 0x75, 0xd9, 0x35, 0x36, 0xe8, 0xe3, 0x2c,
			0x51, 0xd5, 0x9b, 0xc2, 0x93, 0x40, 0x08, 0xb3,
			0x5a, 0x5d, 0x9d, 0x75, 0xd3, 0xf5, 0x0d, 0xbe,
			0x6d, 0x0a, 0x61, 0x46, 0x8e, 0xbe, 0x47, 0xce,
			0x84, 0x71, 0xad, 0x61, 0xbe, 0x2a, 0x8e, 0xda,
			0x3c, 0x38, 0x0c, 0xa6, 0x44, 0x19, 0xc0, 0xcb,
			0x57, 0x9a, 0x4e, 0x29, 0x63, 0x40, 0x3c, 0x00,
			0x3a, 0xe7, 0x04, 0xb3, 0x43, 0xa9, 0x67, 0xcc,
			0x6f, 0x01, 0x05, 0x3f, 0x6f, 0x30, 0x2b, 0xf3,
			0x25, 0xe0, 0xec, 0x7e, 0x58, 0x08, 0x73, 0x31,
		},
		/* S5 : 192 byte */
		{
			0x26, 0x2f, 0x0f, 0x99, 0x8c, 0x48, 0x6c, 0x51,
			0xd7, 0x71, 0x9b, 0x8b, 0x07, 0x32, 0x58, 0xee,
			0x31, 0x00, 0x84, 0x1a, 0xfa, 0x49, 0xeb, 0x36,
			0xf2, 0x61, 0x8a, 0xae, 0x60, 0x32, 0x16, 0x37,
			0xa3, 0xf9, 0x18, 0xdf, 0x39, 0x40, 0xdd, 0x87,
			0xb8, 0xaf, 0x96, 0x12, 0x61, 0x06, 0xc5, 0x72,
			0xa8, 0x31, 0xb4, 0xb1, 0xc7, 0x93, 0xda, 0xb8,
			0x6e, 0x8c, 0x3f, 0xe9, 0xf7, 0x0f, 0x1c, 0x0b,
			0xdf, 0x34, 0x45, 0x87, 0xc3, 0xb9, 0xe9, 0x15,
			0xc7, 0x6b, 0x6f, 0x84, 0xd8, 0x4e, 0x63, 0x15,
			0x19, 0x67, 0x27, 0x6e, 0xa6, 0xf8, 0xfd, 0xb9,
			0x96, 0xea, 0x02, 0xd4, 0xb3, 0x0b, 0xeb, 0x1a,
			0x8a, 0xa1, 0x52, 0x45, 0x73, 0xd9, 0x58, 0x26,
			0x80, 0x1f, 0x98, 0xcd, 0x9a, 0x10, 0x00, 0xb1,
			0x47, 0x55, 0xe3, 0x54, 0x1f, 0x88, 0xc0, 0x41,
			0x11, 0x5d, 0x9b, 0x6f, 0x10, 0x5c, 0xbb, 0x8f,
			0x41, 0xd0, 0x79, 0x63, 0xc5, 0x50, 0x66, 0x6c,
			0x1f, 0x78, 0xb8, 0x9f, 0xeb, 0x9b, 0x68, 0x91,
			0xdb, 0x0f, 0x06, 0xa1, 0xc1, 0xfc, 0x8c, 0x3b,
			0x78, 0x85, 0xf9, 0xb1, 0x73, 0xe7, 0x08, 0xce,
			0x2e, 0x2e, 0xb3, 0x22, 0x09, 0xb3, 0xe8, 0x58,
			0x11, 0x17, 0x6e, 0xe4, 0x36, 0x44, 0x44, 0x56,
			0x82, 0x0f, 0x73, 0xac, 0x69, 0xc2, 0x04, 0x55,
			0x43, 0x86, 0x4e, 0xd7, 0xff, 0x86, 0xe5, 0x2e,
		},
		20, /* salt length */
		/* V5 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA256 [6] */
	{
		/* Msg6 : 128 byte */
		{
			0x89, 0x4d, 0x3a, 0xb4, 0xb1, 0xed, 0x51, 0xcc,
			0x9a, 0xe2, 0x9d, 0xa2, 0x23, 0x64, 0x0b, 0xc6,
			0xb0, 0x0f, 0x4f, 0x67, 0xc4, 0x2d, 0x1e, 0xb9,
			0xd3, 0x38, 0x9e, 0x99, 0x51, 0x9b, 0x1b, 0x74,
			0x0f, 0xb9, 0xfb, 0x65, 0xc7, 0x30, 0xf4, 0x9d,
			0xf6, 0x5f, 0x7c, 0x08, 0xe9, 0x26, 0x81, 0x2e,
			0x1b, 0xec, 0x5b, 0x57, 0xbe, 0xe7, 0xff, 0xf2,
			0x98, 0x97, 0x75, 0x37, 0x10, 0x94, 0x8c, 0x0c,
			0x89, 0x8a, 0xcc, 0x25, 0xee, 0x82, 0xac, 0x70,
			0x8e, 0x63, 0x05, 0xb0, 0x2b, 0xb8, 0xc7, 0x67,
			0x4d, 0xb3, 0xeb, 0xfa, 0xdc, 0x72, 0xa8, 0x10,
			0xee, 0x82, 0xea, 0x3b, 0xde, 0xa2, 0x00, 0xda,
			0x9e, 0xc9, 0x94, 0x3e, 0x4e, 0x6a, 0xe1, 0x0b,
			0x0d, 0xf6, 0x20, 0xe1, 0x0f, 0xa3, 0x43, 0x3c,
			0xef, 0x6c, 0xe6, 0x99, 0x47, 0x58, 0x83, 0xdb,
			0x7f, 0x00, 0xe5, 0xec, 0xe2, 0x4b, 0xdf, 0xa7,
		},
		/* S6 : 192 byte */
		{
			0x7a, 0x7c, 0x24, 0xb6, 0x23, 0x67, 0x50, 0x1c,
			0x1b, 0xb9, 0x3d, 0x7b, 0x04, 0x63, 0x64, 0xa2,
			0xdc, 0xe1, 0x3c, 0xfd, 0x3e, 0xc2, 0x7b, 0x3a,
			0xe7, 0x67, 0x2b, 0xd8, 0xa7, 0xdd, 0x66, 0xac,
			0x0c, 0x92, 0x1c, 0xcd, 0xf2, 0xae, 0x2e, 0xfc,
			0x6a, 0x0b, 0x3a, 0x86, 0x76, 0x56, 0x5b, 0xe2,
			0x3f, 0xec, 0xbc, 0xa7, 0x95, 0x14, 0x9e, 0x86,
			0xd5, 0xdd, 0xa9, 0x4f, 0x4d, 0xfd, 0x49, 0xa2,
			0x74, 0x96, 0x21, 0xa4, 0x9b, 0xb1, 0x72, 0x0b,
			0x29, 0x01, 0xd9, 0xd3, 0x42, 0xe5, 0x19, 0xef,
			0x96, 0x3e, 0xab, 0x7a, 0x1b, 0x45, 0xa9, 0xea,
			0xd1, 0x9c, 0xa7, 0x46, 0x58, 0x3d, 0x6d, 0x3b,
			0x26, 0x38, 0x6b, 0x16, 0x1e, 0x23, 0xb2, 0x46,
			0x8c, 0xfc, 0xef, 0xe5, 0x30, 0x33, 0xff, 0xa8,
			0x3b, 0x58, 0xc7, 0x0d, 0x35, 0x08, 0x95, 0x41,
			0x41, 0xce, 0x0f, 0xca, 0x9d, 0xd2, 0xcd, 0x41,
			0x05, 0x4b, 0xf7, 0xb4, 0x87, 0x37, 0x9d, 0xa9,
			0xa1, 0x41, 0x42, 0x1c, 0xf8, 0x64, 0x5d, 0xeb,
			0x3b, 0xf9, 0xef, 0x0b, 0x5f, 0x02, 0x26, 0x2e,
			0x42, 0x2e, 0x26, 0xb1, 0x69, 0x3a, 0xfb, 0x6f,
			0x1c, 0x03, 0xa4, 0x6a, 0x11, 0xae, 0x79, 0x33,
			0x40, 0x72, 0x3a, 0xd2, 0x9c, 0x38, 0xbb, 0x0e,
			0x3c, 0x3e, 0x9c, 0xad, 0xc6, 0xe0, 0x0b, 0xcf,
			0x4f, 0xe5, 0xa5, 0x46, 0xf4, 0x1d, 0x8e, 0x53,
		},
		20, /* salt length */
		/* V6 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA256 [7] */
	{
		/* Msg7 : 128 byte */
		{
			0xe3, 0xee, 0x06, 0x09, 0x50, 0xf9, 0x37, 0xbe,
			0x94, 0x45, 0x4a, 0xe1, 0x59, 0xa6, 0x52, 0x84,
			0x7d, 0x53, 0x3c, 0x34, 0x67, 0xeb, 0xbc, 0x21,
			0x97, 0xb5, 0x87, 0x7f, 0x81, 0x2c, 0xc3, 0x2b,
			0x9c, 0xbb, 0xbb, 0x92, 0xb6, 0xc5, 0xd8, 0xcf,
			0x8a, 0xe8, 0xcd, 0x13, 0x94, 0x83, 0x11, 0x4a,
			0x24, 0x75, 0x92, 0xfb, 0xb2, 0x28, 0xa8, 0x70,
			0x71, 0xcf, 0x47, 0x18, 0x26, 0xeb, 0x7a, 0x29,
			0x3b, 0x14, 0x0c, 0x89, 0x0f, 0xf6, 0x88, 0xef,
			0x91, 0x9a, 0x65, 0x46, 0x0d, 0xe7, 0x7a, 0x52,
			0x46, 0x68, 0xb8, 0x95, 0xc4, 0x4f, 0x17, 0x74,
			0x6f, 0xba, 0xd1, 0x96, 0x5d, 0x36, 0xcf, 0x8d,
			0xe9, 0x81, 0x60, 0xb8, 0x05, 0x95, 0x31, 0x67,
			0xd1, 0xe1, 0x7a, 0x41, 0x6c, 0xda, 0x75, 0xe3,
			0x09, 0xb2, 0x14, 0xca, 0x46, 0x67, 0xf3, 0x73,
			0xba, 0x00, 0x8c, 0xc0, 0xcd, 0x14, 0xaa, 0x9e,
		},
		/* S7 : 192 byte */
		{
			0x1f, 0x31, 0x30, 0x9f, 0xc7, 0xb2, 0xe3, 0x3c,
			0x28, 0x52, 0x90, 0xd6, 0x57, 0x27, 0xbc, 0x14,
			0xd2, 0xc2, 0x65, 0x31, 0x9c, 0x35, 0x12, 0xeb,
			0xc4, 0x95, 0xaf, 0x88, 0x4a, 0x9c, 0x24, 0x55,
			0x43, 0x97, 0xd0, 0xbe, 0x03, 0x9d, 0xad, 0xaa,
			0x0a, 0xab, 0x25, 0x42, 0x00, 0xc0, 0x24, 0xa6,
			0x0e, 0x53, 0xf6, 0x76, 0x73, 0x84, 0xa8, 0xf7,
			0x31, 0xb7, 0x2c, 0xe7, 0xee, 0xc1, 0x83, 0x51,
			0xaa, 0xab, 0x36, 0x41, 0xfc, 0x03, 0x30, 0xb6,
			0x42, 0xe6, 0xbe, 0x2b, 0x21, 0x3f, 0x93, 0xb1,
			0x53, 0x01, 0xbc, 0xf9, 0x0e, 0x6e, 0x0d, 0x01,
			0xc9, 0x3f, 0xa3, 0xe0, 0xf0, 0xe0, 0x24, 0x71,
			0xb2, 0x43, 0x48, 0x48, 0x8d, 0x28, 0xf3, 0x70,
			0x95, 0x97, 0x04, 0xd6, 0xa5, 0x09, 0x2f, 0x73,
			0x04, 0xf4, 0x76, 0x0c, 0x40, 0x62, 0xeb, 0xfa,
			0x50, 0xdf, 0x46, 0x11, 0x6c, 0xd4, 0x00, 0x91,
			0xc5, 0xd2, 0x8e, 0xa2, 0x45, 0x1c, 0x27, 0x06,
			0xf8, 0x69, 0x50, 0x74, 0x59, 0x11, 0x73, 0x25,
			0xb4, 0xbe, 0x2d, 0xe6, 0x34, 0x41, 0xd8, 0x27,
			0x25, 0x1a, 0x02, 0xd9, 0x1a, 0x39, 0xcd, 0x07,
			0x97, 0x27, 0x27, 0x83, 0xfe, 0x47, 0x11, 0x98,
			0xcb, 0x58, 0xac, 0xe8, 0x8b, 0xfa, 0xb0, 0xf7,
			0xaf, 0x28, 0x89, 0x67, 0x5b, 0xbd, 0x94, 0x20,
			0x97, 0xcd, 0x4e, 0x5c, 0xe8, 0x99, 0x6c, 0x73,
		},
		20, /* salt length */
		/* V7 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA256 [8] */
	{
		/* Msg8 : 128 byte */
		{
			0xc2, 0x16, 0x21, 0x5e, 0x3f, 0xc1, 0xfe, 0x6d,
			0x5b, 0xcd, 0xf4, 0x7b, 0xa1, 0xf0, 0xf2, 0x89,
			0x9a, 0xd9, 0xfd, 0x5d, 0x88, 0x13, 0x7f, 0x82,
			0x56, 0x2d, 0xe1, 0x90, 0xd0, 0x18, 0x5b, 0xae,
			0x10, 0xd0, 0x0b, 0x54, 0x38, 0x3e, 0x45, 0x56,
			0x67, 0x5e, 0x2b, 0x1e, 0xe5, 0x9d, 0x7d, 0x38,
			0xa1, 0x85, 0xb2, 0x15, 0xde, 0x9b, 0x47, 0x08,
			0x29, 0x88, 0x57, 0x95, 0x8e, 0x78, 0x6c, 0xeb,
			0x0b, 0xc0, 0x95, 0xaf, 0x45, 0xc3, 0xb8, 0xfb,
			0x7a, 0x16, 0x2a, 0xa7, 0xb7, 0xe2, 0x7d, 0xc7,
			0x4b, 0x8a, 0x99, 0x74, 0x7b, 0x8e, 0x0e, 0xd0,
			0x77, 0xb0, 0xa9, 0x44, 0x8d, 0x55, 0x46, 0x0c,
			0x9d, 0x2d, 0xe4, 0xf6, 0xcd, 0x16, 0xff, 0x66,
			0x7d, 0x3e, 0x1a, 0x9e, 0x7e, 0x88, 0x9b, 0x3c,
			0x7e, 0x32, 0xdb, 0x04, 0xc7, 0xb4, 0x7e, 0xe0,
			0x2a, 0xeb, 0x00, 0x25, 0x35, 0x76, 0x91, 0x18,
		},
		/* S8 : 192 byte */
		{
			0x47, 0x4b, 0x58, 0xa2, 0x07, 0x8a, 0x9c, 0xbf,
			0x1f, 0x31, 0xed, 0x01, 0x56, 0xf1, 0x90, 0x13,
			0x54, 0x7c, 0xec, 0x94, 0x67, 0xbf, 0x28, 0xa2,
			0xe0, 0x92, 0xdd, 0xfc, 0xba, 0xc3, 0x2c, 0xb8,
			0xc6, 0x7d, 0xcf, 0xff, 0xc2, 0x31, 0xc9, 0x8b,
			0x09, 0x56, 0x9b, 0xb4, 0x8b, 0x13, 0x38, 0xb7,
			0xf1, 0xf5, 0x60, 0x3a, 0x2a, 0x17, 0x2e, 0x49,
			0x0e, 0x57, 0x9a, 0xe5, 0x4e, 0xb8, 0x12, 0xd1,
			0x4d, 0x61, 0x4c, 0xeb, 0xe3, 0x58, 0x9d, 0x61,
			0x84, 0x2d, 0xe8, 0x95, 0x97, 0xef, 0x42, 0x87,
			0x64, 0x92, 0x54, 0xdf, 0x83, 0x05, 0x9c, 0x91,
			0x3f, 0xc2, 0x5b, 0x24, 0x4b, 0x57, 0x09, 0x1e,
			0x1c, 0xce, 0x2a, 0xc0, 0x14, 0x9f, 0x3a, 0x3d,
			0x6d, 0x06, 0x6d, 0xda, 0x00, 0xaa, 0xcc, 0x2f,
			0x9b, 0xd8, 0x28, 0xaf, 0x23, 0xbc, 0x85, 0xcd,
			0x45, 0x4b, 0x93, 0x3c, 0x2c, 0xd1, 0x38, 0x8a,
			0x48, 0xd1, 0xa0, 0x49, 0xa2, 0x3c, 0x79, 0x0c,
			0x3e, 0xc4, 0x8a, 0xd5, 0xec, 0x51, 0x11, 0xbf,
			0xac, 0xdb, 0x51, 0x9b, 0xc1, 0x32, 0x32, 0x25,
			0x40, 0x4e, 0xcc, 0xc0, 0x12, 0x75, 0xfa, 0x5c,
			0xea, 0x09, 0xcc, 0x16, 0x1b, 0x23, 0x1f, 0x11,
			0xbd, 0x09, 0x85, 0xd5, 0x42, 0x89, 0x01, 0x28,
			0x79, 0x0a, 0x62, 0x01, 0x59, 0xde, 0xb6, 0x4b,
			0xb4, 0x3d, 0x93, 0xde, 0x55, 0x6f, 0xd3, 0xc4,
		},
		20, /* salt length */
		/* V8 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA256 [9] */
	{
		/* Msg9 : 128 byte */
		{
			0xcc, 0xdd, 0x22, 0x58, 0x51, 0x85, 0xc0, 0xff,
			0x1f, 0x16, 0x5d, 0x70, 0x33, 0xe6, 0x0f, 0x3b,
			0x6e, 0x9f, 0xe0, 0x13, 0x49, 0x2c, 0x22, 0xd1,
			0xc4, 0xd9, 0x02, 0xbc, 0x9f, 0xb5, 0x60, 0x07,
			0xcd, 0x3b, 0xde, 0x9b, 0x26, 0x32, 0x37, 0x17,
			0x5c, 0xd2, 0xd3, 0x15, 0x30, 0x28, 0x98, 0xb0,
			0xe5, 0xbc, 0x02, 0x43, 0xf5, 0x70, 0x76, 0x72,
			0x04, 0xab, 0xd3, 0x6f, 0x12, 0xb7, 0x4b, 0x76,
			0xf4, 0x68, 0x71, 0x9a, 0x05, 0xff, 0x92, 0xc4,
			0x19, 0x4d, 0x49, 0xf9, 0xb2, 0x1c, 0x4e, 0xdb,
			0x77, 0xca, 0x8f, 0x73, 0xe1, 0x37, 0x82, 0x2d,
			0x38, 0xe2, 0xb9, 0x24, 0xbe, 0x4e, 0xb7, 0xa0,
			0x2a, 0xab, 0x02, 0xdd, 0x57, 0xb2, 0x79, 0x0f,
			0x3e, 0xd1, 0xe8, 0xa2, 0x22, 0x88, 0xda, 0xc6,
			0x0a, 0x13, 0xae, 0x2b, 0x74, 0x49, 0xed, 0x09,
			0x48, 0xc4, 0xdb, 0x64, 0x0b, 0x42, 0x4c, 0x8e,
		},
		/* S9 : 192 byte */
		{
			0x80, 0x78, 0xa6, 0x07, 0xc5, 0xfa, 0x00, 0xf9,
			0x02, 0x29, 0x7e, 0x56, 0x3b, 0x5a, 0xa6, 0x4d,
			0x61, 0x4b, 0x1e, 0xfe, 0xb4, 0x02, 0xbf, 0x0b,
			0x8b, 0x23, 0xb7, 0x3e, 0xac, 0x07, 0xf7, 0xdc,
			0x30, 0x16, 0x67, 0xcb, 0x55, 0x63, 0xfb, 0xa6,
			0x84, 0x4e, 0x04, 0x61, 0xee, 0x1e, 0x35, 0x14,
			0x56, 0x86, 0x23, 0x91, 0xf8, 0x82, 0xd1, 0x35,
			0x7d, 0x75, 0x91, 0xaf, 0x70, 0xa5, 0x21, 0xdd,
			0xcd, 0xd5, 0xa3, 0xf8, 0xc2, 0x31, 0xa1, 0x58,
			0xbc, 0x8e, 0x7a, 0xbc, 0xf5, 0x61, 0x90, 0x91,
			0x22, 0x91, 0xb9, 0xee, 0x5e, 0x8d, 0xac, 0xff,
			0x23, 0xad, 0xac, 0x26, 0x85, 0xa1, 0x0a, 0x8b,
			0x0e, 0x0e, 0xec, 0x4e, 0x98, 0x4a, 0xb3, 0xb6,
			0x1d, 0x3c, 0xc0, 0x76, 0xcd, 0xe0, 0xf9, 0x6c,
			0x60, 0xa1, 0xbd, 0x7d, 0xda, 0xcd, 0xac, 0xb7,
			0xcc, 0x09, 0x6f, 0x1f, 0xb2, 0xf6, 0xcd, 0x56,
			0xd0, 0x41, 0x1b, 0x32, 0x78, 0xb6, 0xb9, 0x35,
			0xc1, 0x22, 0x87, 0x87, 0xe8, 0xed, 0x55, 0xce,
			0x67, 0xee, 0xdf, 0xe3, 0x63, 0xc3, 0x75, 0xa2,
			0xe4, 0x3a, 0xf7, 0x70, 0x36, 0x0a, 0x20, 0x3d,
			0xb3, 0x20, 0x02, 0x37, 0x2c, 0x01, 0xbe, 0x10,
			0x15, 0xc9, 0xdd, 0x4f, 0x9b, 0x9e, 0xf2, 0xc8,
			0x9f, 0x8f, 0x77, 0x5e, 0x43, 0xa2, 0x1d, 0xef,
			0x2f, 0xd9, 0x5b, 0x80, 0xd0, 0x04, 0x00, 0x4a,
		},
		20, /* salt length */
		/* V9 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
};

/* 10 elements */
static mod1536_t SHA384[] = {
	/* SHA384 [0] */
	{
		/* Msg0 : 128 byte */
		{
			0xb1, 0xe9, 0x73, 0xf2, 0x13, 0x03, 0xaa, 0x00,
			0x11, 0xd4, 0x16, 0x64, 0x2c, 0xec, 0xd4, 0x55,
			0x11, 0x54, 0x9b, 0x45, 0xbd, 0x22, 0xf9, 0x10,
			0xe4, 0x4b, 0xdf, 0x7a, 0x94, 0xb9, 0x60, 0xd8,
			0x16, 0x9d, 0xb6, 0x0d, 0x15, 0x07, 0x86, 0xb8,
			0x01, 0xb4, 0x65, 0xac, 0xb6, 0x26, 0x9a, 0xa1,
			0x59, 0xfa, 0x25, 0x29, 0x83, 0x77, 0x01, 0xe5,
			0xa2, 0x63, 0xa7, 0xf8, 0x9c, 0x1a, 0xd3, 0xbc,
			0xb5, 0xe1, 0x8a, 0xb4, 0xb2, 0x77, 0x5c, 0xc2,
			0x3e, 0xed, 0xe7, 0x9a, 0x8e, 0xb8, 0x9c, 0x77,
			0x41, 0x05, 0xc6, 0x0d, 0x8a, 0x4c, 0xc7, 0xbe,
			0x90, 0x28, 0xa5, 0x10, 0x15, 0x66, 0xc6, 0x5f,
			0x56, 0x5b, 0xf8, 0xcf, 0x33, 0x7b, 0xb5, 0x85,
			0x90, 0x28, 0xa4, 0x17, 0xfb, 0xc8, 0x62, 0x40,
			0x8f, 0x1a, 0x83, 0xd9, 0x18, 0xca, 0xd4, 0x04,
			0x78, 0x43, 0xe3, 0xab, 0x49, 0xc4, 0xc2, 0x29,
		},
		/* S0 : 192 byte */
		{
			0x9f, 0xa4, 0xe6, 0x4b, 0xab, 0x33, 0x60, 0x17,
			0xe1, 0x90, 0x15, 0xee, 0x7e, 0xa1, 0xe2, 0x67,
			0xbf, 0x42, 0x66, 0x33, 0xfb, 0x2a, 0xc5, 0xf4,
			0xd6, 0x5b, 0xc7, 0x54, 0xab, 0xa1, 0x7f, 0x7a,
			0x9f, 0x0f, 0x1e, 0xe2, 0xbf, 0x0a, 0x3b, 0x9f,
			0x2d, 0xd3, 0x54, 0xed, 0x8e, 0xba, 0x59, 0x6f,
			0x5c, 0xa3, 0xe2, 0x64, 0x95, 0xef, 0x26, 0x86,
			0x58, 0xbd, 0x24, 0x74, 0x74, 0xd3, 0x52, 0x4b,
			0x11, 0xa2, 0x95, 0x3f, 0x59, 0x1f, 0x8a, 0xbb,
			0x14, 0xef, 0x4b, 0xcd, 0x44, 0xda, 0xdc, 0x36,
			0xa4, 0x1f, 0x9d, 0xae, 0xf1, 0xbf, 0x88, 0xb7,
			0xe4, 0x41, 0x16, 0x02, 0x78, 0xc8, 0xa3, 0x99,
			0x45, 0x52, 0x45, 0x57, 0xb8, 0x4c, 0xe5, 0xcd,
			0xcb, 0x79, 0xee, 0xcb, 0xad, 0x63, 0x65, 0x8e,
			0x84, 0x70, 0xd8, 0xdc, 0x94, 0xb4, 0x4a, 0xad,
			0x1f, 0x04, 0xb0, 0x54, 0x00, 0xea, 0x04, 0xe5,
			0xf9, 0x59, 0xdd, 0x18, 0xf6, 0xf7, 0x18, 0x31,
			0x1f, 0x6d, 0xfe, 0xc9, 0x8a, 0x7e, 0x1a, 0xaa,
			0x7b, 0xa1, 0x17, 0x71, 0xf6, 0x14, 0x48, 0xb1,
			0x2d, 0x79, 0x01, 0xa2, 0x53, 0x0e, 0x83, 0x0d,
			0xcc, 0xc5, 0x31, 0xfd, 0x0d, 0xbe, 0x22, 0x22,
			0x15, 0xb3, 0xf7, 0xb9, 0xda, 0xfa, 0x5f, 0xc2,
			0x0d, 0x5a, 0xf1, 0x5a, 0xb3, 0x12, 0xb6, 0x21,
			0xd7, 0x1b, 0x21, 0x06, 0x15, 0x0a, 0x80, 0x1b,
		},
		20, /* salt length */
		/* V0 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA384 [1] */
	{
		/* Msg1 : 128 byte */
		{
			0x39, 0xab, 0x56, 0x41, 0xed, 0x11, 0xdd, 0xc0,
			0x70, 0xc3, 0x56, 0xeb, 0x6f, 0x8b, 0xef, 0x88,
			0xa5, 0x06, 0x67, 0xa5, 0xf4, 0x60, 0xc6, 0x82,
			0xb4, 0x5f, 0x4c, 0xab, 0x4b, 0xa3, 0xa7, 0x65,
			0xfd, 0x2c, 0x69, 0x4b, 0x06, 0x1c, 0xb8, 0x39,
			0xe6, 0xbe, 0x47, 0x69, 0xfd, 0xc8, 0x86, 0xdc,
			0x57, 0xdd, 0x16, 0xfc, 0xc9, 0x56, 0x80, 0x7f,
			0x3d, 0x42, 0x26, 0x8e, 0x4a, 0xab, 0x7a, 0x27,
			0x08, 0x1c, 0x6d, 0xc0, 0x22, 0x5f, 0x2b, 0x2d,
			0x2c, 0x8b, 0x05, 0xc3, 0x37, 0x3f, 0xae, 0xbe,
			0xa3, 0x28, 0xab, 0xe0, 0x35, 0xc9, 0x05, 0x5b,
			0x69, 0x7b, 0x41, 0xf1, 0x0a, 0xb2, 0x91, 0x5a,
			0xff, 0x83, 0x4c, 0xe6, 0x68, 0x63, 0x9c, 0x63,
			0xea, 0x32, 0x77, 0x41, 0x46, 0x78, 0xd0, 0xf4,
			0x31, 0xee, 0x0e, 0x9a, 0x60, 0x40, 0xbd, 0xde,
			0xe2, 0x11, 0x83, 0x1c, 0xb2, 0x3f, 0x56, 0xc6,
		},
		/* S1 : 192 byte */
		{
			0x71, 0x1e, 0xf6, 0x4f, 0x5a, 0x5d, 0xae, 0xfc,
			0xa7, 0x53, 0xa9, 0x21, 0xe9, 0x87, 0xfd, 0x51,
			0xb6, 0x79, 0x1c, 0x26, 0x0e, 0xf5, 0x95, 0x36,
			0xd6, 0xcc, 0x5d, 0x48, 0x41, 0xcc, 0xcc, 0x71,
			0x73, 0x96, 0xb9, 0xfa, 0xc0, 0x90, 0xf9, 0xef,
			0xbf, 0x97, 0x40, 0x60, 0x8c, 0xf8, 0x74, 0x9e,
			0x53, 0x10, 0x1b, 0x67, 0x3e, 0x93, 0x7f, 0xbb,
			0x42, 0x96, 0x09, 0x62, 0x28, 0x8b, 0xf5, 0x85,
			0xa3, 0x6f, 0xd4, 0xaa, 0x98, 0x02, 0xcf, 0x25,
			0x5d, 0xf3, 0x4b, 0xc7, 0x9c, 0xad, 0x75, 0x91,
			0xfe, 0xa8, 0xf1, 0xe8, 0x67, 0x2c, 0xc0, 0x6a,
			0xc7, 0xed, 0x97, 0x61, 0x5c, 0xbd, 0x43, 0x2b,
			0x19, 0xe0, 0xee, 0xc2, 0x47, 0x6b, 0x37, 0xf5,
			0x05, 0xef, 0x56, 0x08, 0xc9, 0x73, 0x81, 0xfa,
			0xc2, 0x23, 0x84, 0x2a, 0xbb, 0x93, 0xf0, 0x10,
			0x56, 0xd8, 0x95, 0x07, 0x0e, 0x27, 0x11, 0x6a,
			0x4f, 0xcf, 0x90, 0x8c, 0x07, 0x30, 0x83, 0x8c,
			0xe1, 0x1d, 0x76, 0xd2, 0x94, 0x24, 0xbf, 0x28,
			0x4e, 0x8e, 0x1d, 0x01, 0x06, 0x73, 0xab, 0x7f,
			0xa6, 0x28, 0x6b, 0x30, 0x15, 0x50, 0x46, 0x18,
			0xaf, 0x38, 0xc2, 0x2f, 0xe8, 0x64, 0x6c, 0xac,
			0x9e, 0x61, 0x21, 0xb4, 0x6d, 0xfb, 0xc8, 0x77,
			0xac, 0x4a, 0x0c, 0x1d, 0xac, 0xbb, 0x58, 0x2e,
			0x2f, 0x2e, 0x5a, 0xf8, 0x9f, 0xb3, 0x3d, 0x2e,
		},
		20, /* salt length */
		/* V1 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA384 [2] */
	{
		/* Msg2 : 128 byte */
		{
			0xdf, 0x69, 0x2c, 0x2d, 0xfe, 0xfb, 0xe4, 0xfd,
			0xea, 0x6a, 0x43, 0x20, 0xff, 0xee, 0xac, 0x3d,
			0xdb, 0xfc, 0xd8, 0xfd, 0x16, 0x23, 0x25, 0x0f,
			0x2d, 0x34, 0x31, 0x70, 0xbe, 0xa5, 0xa8, 0xe9,
			0xfb, 0x37, 0x5a, 0xd9, 0x59, 0xd7, 0x91, 0x34,
			0x88, 0xc2, 0xa1, 0xcc, 0xa8, 0xed, 0xc0, 0xcf,
			0xba, 0xa4, 0x18, 0x91, 0x54, 0x71, 0x1b, 0x8c,
			0x99, 0x3f, 0x17, 0xa6, 0x69, 0xbf, 0x0a, 0xb2,
			0xd5, 0x0b, 0xb7, 0x38, 0xd6, 0x8a, 0xf9, 0x79,
			0x3e, 0x13, 0x58, 0xae, 0xee, 0x55, 0xda, 0x91,
			0x4a, 0x76, 0x1b, 0x1e, 0xea, 0xfa, 0xa0, 0x9b,
			0x92, 0xe7, 0x69, 0xd6, 0x65, 0x26, 0xc5, 0xae,
			0x55, 0x2d, 0x6b, 0xd4, 0xde, 0xdb, 0xc5, 0xd3,
			0xf4, 0xa3, 0x8f, 0x4e, 0x3a, 0xed, 0xa1, 0x89,
			0x74, 0xb9, 0x09, 0x2c, 0x3f, 0x86, 0x5d, 0x43,
			0x00, 0x72, 0x50, 0x88, 0x1a, 0xa2, 0x82, 0xe5,
		},
		/* S2 : 192 byte */
		{
			0x33, 0xb2, 0xb2, 0x66, 0xe4, 0x8f, 0xdf, 0x38,
			0x0d, 0x60, 0x7a, 0x94, 0x72, 0xeb, 0x78, 0xa4,
			0x82, 0x8c, 0xea, 0xbd, 0xa3, 0x50, 0x2a, 0x50,
			0x59, 0xf7, 0x4a, 0xf5, 0x46, 0xdd, 0xe4, 0x49,
			0x87, 0xd0, 0x44, 0x1d, 0x31, 0x85, 0x97, 0x8b,
			0x06, 0x01, 0xfa, 0xec, 0x24, 0xcf, 0x5a, 0xbc,
			0x85, 0xcd, 0xbf, 0x9e, 0x82, 0x17, 0x95, 0x7e,
			0xf5, 0x48, 0x62, 0xda, 0xa8, 0x95, 0x6b, 0xcb,
			0x02, 0x0d, 0x0a, 0x8a, 0x2d, 0xac, 0xf8, 0xaf,
			0xf4, 0x82, 0x7d, 0x27, 0x84, 0x17, 0x38, 0x6b,
			0x9d, 0x51, 0xef, 0xfc, 0xb2, 0x9a, 0x20, 0xea,
			0x4c, 0xf5, 0x04, 0xfb, 0x52, 0xee, 0x41, 0x88,
			0xbe, 0x39, 0x3d, 0xda, 0x5c, 0x58, 0xb7, 0x66,
			0x85, 0xa0, 0x88, 0x9e, 0x9d, 0x92, 0xcc, 0x45,
			0x37, 0x13, 0x69, 0xd1, 0x7e, 0xc3, 0x54, 0x05,
			0xe1, 0x3a, 0xe8, 0xc1, 0x8c, 0x4d, 0xd9, 0xb3,
			0x6e, 0x49, 0x3b, 0xfa, 0xe7, 0x13, 0xd5, 0x81,
			0xd2, 0x2f, 0x7b, 0x41, 0x9e, 0x38, 0x6c, 0x7c,
			0xe9, 0x29, 0xfb, 0xbe, 0x3a, 0x5f, 0x71, 0xa0,
			0x7d, 0x90, 0x31, 0x35, 0x2b, 0x97, 0xb0, 0xda,
			0x21, 0xca, 0x50, 0xbb, 0xc5, 0xc1, 0xcf, 0x9d,
			0x80, 0x42, 0x11, 0x82, 0x81, 0x87, 0x24, 0x1d,
			0xbd, 0xe7, 0x2f, 0x41, 0xee, 0xf3, 0x0a, 0x86,
			0x1b, 0x34, 0xfa, 0x00, 0x77, 0x7a, 0x3a, 0x3e,
		},
		20, /* salt length */
		/* V2 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA384 [3] */
	{
		/* Msg3 : 128 byte */
		{
			0xd9, 0x19, 0x8f, 0xbd, 0xf1, 0xcd, 0xc2, 0x79,
			0x01, 0x0d, 0xf1, 0x5b, 0x49, 0xa9, 0xfd, 0xd6,
			0x41, 0xcd, 0xb5, 0x88, 0xda, 0x30, 0x3f, 0x12,
			0x07, 0x8d, 0xba, 0x26, 0x7c, 0x57, 0x21, 0xe2,
			0xb5, 0xa9, 0x72, 0x5c, 0x3b, 0x7c, 0x10, 0x7e,
			0x23, 0x1c, 0x66, 0x14, 0xd7, 0xdd, 0xce, 0x23,
			0x19, 0x09, 0xb1, 0x7c, 0x44, 0x1e, 0xef, 0x92,
			0xd5, 0x36, 0x81, 0x89, 0x2b, 0xc7, 0x5d, 0x8f,
			0x8b, 0x8c, 0x99, 0x6f, 0x67, 0xc3, 0xd4, 0x63,
			0xe0, 0x99, 0xd2, 0x2a, 0x89, 0xe3, 0x66, 0x5b,
			0x6e, 0x0e, 0x95, 0xf9, 0x55, 0x59, 0xf8, 0x47,
			0x43, 0x41, 0x62, 0xde, 0x42, 0x3d, 0xc3, 0xfc,
			0x62, 0xac, 0x4c, 0x1f, 0xfe, 0x0c, 0xd4, 0xd3,
			0x40, 0x6c, 0x7b, 0xc8, 0xe7, 0x24, 0x8d, 0x27,
			0x48, 0xc3, 0xa9, 0x26, 0x93, 0x49, 0x22, 0xdb,
			0x58, 0x97, 0xa5, 0x4d, 0x4a, 0x23, 0x1c, 0xd1,
		},
		/* S3 : 192 byte */
		{
			0x38, 0x76, 0xfc, 0x70, 0xb4, 0x02, 0xca, 0x8d,
			0x96, 0x8c, 0xdf, 0x7a, 0x2c, 0x16, 0x4f, 0x72,
			0xfa, 0x2f, 0x4b, 0x77, 0x9a, 0xf0, 0xdf, 0xd5,
			0x9f, 0x9b, 0xcf, 0x71, 0xaf, 0x38, 0x5a, 0x0b,
			0x88, 0xc9, 0x51, 0x9f, 0x2f, 0x34, 0xfb, 0x15,
			0x8b, 0xd9, 0xfb, 0x1d, 0xc0, 0x87, 0x31, 0xab,
			0x01, 0x53, 0xd7, 0x50, 0x96, 0x85, 0xcb, 0x80,
			0x48, 0x52, 0xcb, 0x20, 0x01, 0x75, 0xcd, 0xfd,
			0xbb, 0x0d, 0xea, 0xa2, 0xad, 0x1d, 0xb0, 0x82,
			0xba, 0xef, 0xe5, 0x10, 0xd9, 0xa5, 0xaf, 0x4e,
			0xa4, 0x99, 0xaa, 0xdb, 0x4c, 0xd9, 0x58, 0x23,
			0x5a, 0xf9, 0x92, 0xaf, 0x60, 0x73, 0x85, 0xf0,
			0xdb, 0x60, 0x49, 0x62, 0x08, 0x50, 0xde, 0x25,
			0xe9, 0xce, 0x80, 0x48, 0x2a, 0xd7, 0x87, 0x56,
			0x59, 0x37, 0x2c, 0x22, 0x84, 0xad, 0x75, 0x92,
			0xae, 0x46, 0xd1, 0x41, 0x93, 0x84, 0x2d, 0x33,
			0x4b, 0x4a, 0x57, 0xe6, 0x94, 0x39, 0x1c, 0xa2,
			0xa3, 0x7c, 0x7d, 0xa5, 0x7b, 0x00, 0x51, 0x2a,
			0xcc, 0x8e, 0x9a, 0xa9, 0xca, 0xeb, 0x5a, 0x55,
			0x48, 0x92, 0x63, 0x62, 0x65, 0x5f, 0x96, 0x26,
			0x67, 0x61, 0xa3, 0xfc, 0xc2, 0x0d, 0xee, 0x6a,
			0xec, 0x9a, 0xd0, 0xb8, 0x87, 0x47, 0xa6, 0x7a,
			0x25, 0x10, 0x04, 0x49, 0x43, 0x2c, 0x66, 0xa2,
			0x3b, 0x80, 0x70, 0x23, 0xfc, 0xdd, 0xed, 0x1c,
		},
		20, /* salt length */
		/* V3 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA384 [4] */
	{
		/* Msg4 : 128 byte */
		{
			0x0b, 0xd0, 0xe3, 0x38, 0x7d, 0x0e, 0xb2, 0x71,
			0x1d, 0x8d, 0x54, 0x67, 0xe8, 0x69, 0x4c, 0x21,
			0x18, 0x02, 0x44, 0x30, 0x48, 0x97, 0x50, 0xe4,
			0xda, 0x17, 0x77, 0xc0, 0x96, 0x33, 0x70, 0x2c,
			0x93, 0xb8, 0xa9, 0x6a, 0x5b, 0x1c, 0x8e, 0xcb,
			0x4a, 0x56, 0x07, 0x23, 0x37, 0xf3, 0x42, 0x7a,
			0x57, 0x67, 0xb4, 0x04, 0x5d, 0xa1, 0x5a, 0x54,
			0xe6, 0xe2, 0x45, 0xcc, 0x15, 0xce, 0x55, 0x58,
			0x7a, 0xc4, 0x45, 0x5c, 0x39, 0x6b, 0xe7, 0xea,
			0x68, 0x8d, 0xb1, 0x39, 0xb8, 0x29, 0x79, 0x52,
			0x58, 0xc3, 0x7d, 0x0d, 0x16, 0xff, 0xa6, 0x3c,
			0xc8, 0x6e, 0x0e, 0x26, 0xea, 0xa8, 0xbf, 0x37,
			0x88, 0x9b, 0xbe, 0xf5, 0x5f, 0x22, 0x48, 0x36,
			0x3f, 0xda, 0x5b, 0x90, 0xb3, 0x31, 0x78, 0x12,
			0xe4, 0xbf, 0xa8, 0x31, 0xbb, 0xda, 0xbd, 0x05,
			0x46, 0x64, 0xda, 0xb6, 0x5d, 0xe8, 0x35, 0x31,
		},
		/* S4 : 192 byte */
		{
			0x8b, 0xd7, 0xdf, 0xbf, 0x98, 0x40, 0xcb, 0x08,
			0x22, 0xe1, 0xd7, 0x24, 0xbd, 0xe7, 0x4d, 0x5f,
			0x16, 0x9a, 0x8f, 0x8f, 0xf9, 0x9f, 0x1b, 0x6e,
			0x43, 0x29, 0x48, 0x31, 0x54, 0x07, 0x2d, 0x74,
			0xc6, 0xca, 0x41, 0x55, 0x29, 0xbe, 0xb5, 0x85,
			0xc4, 0x2d, 0x2a, 0x29, 0x12, 0x98, 0xef, 0x76,
			0x1c, 0xb8, 0xb6, 0xf8, 0x0d, 0xb5, 0x37, 0xb2,
			0x55, 0xfe, 0x4e, 0x97, 0x40, 0x78, 0x90, 0x5a,
			0x18, 0x03, 0x2e, 0xed, 0x86, 0x6d, 0x82, 0x19,
			0x5d, 0x67, 0xce, 0xf6, 0x8c, 0x41, 0x93, 0x8a,
			0xc1, 0x98, 0x88, 0xfa, 0x6c, 0xb8, 0x70, 0x29,
			0x86, 0x47, 0x90, 0xd5, 0x41, 0x46, 0x8d, 0x00,
			0x6b, 0x16, 0x2b, 0x8b, 0x28, 0x52, 0x46, 0x15,
			0xdb, 0xa1, 0x3a, 0x4f, 0x66, 0xb7, 0x40, 0xca,
			0x82, 0xdc, 0xf7, 0xe9, 0x57, 0xcc, 0x4e, 0x2c,
			0xf8, 0x6a, 0x91, 0x2e, 0x3b, 0x29, 0xef, 0x5d,
			0x12, 0x00, 0x34, 0x05, 0xcc, 0x2e, 0x81, 0xfa,
			0xb5, 0xc5, 0x92, 0x23, 0x8f, 0xa3, 0xf5, 0x32,
			0xf8, 0x13, 0x15, 0xbd, 0x42, 0x1b, 0x5a, 0x35,
			0x56, 0x9d, 0xad, 0xbe, 0x3c, 0x12, 0x6a, 0xcb,
			0xdf, 0xe4, 0x5f, 0xf3, 0x47, 0xb5, 0x7c, 0xc2,
			0xbc, 0xe6, 0x89, 0x53, 0x4e, 0x6a, 0xd5, 0x46,
			0x88, 0xd9, 0x48, 0x2a, 0xe2, 0xd0, 0x3c, 0x18,
			0x9f, 0x0e, 0x3f, 0x95, 0x20, 0x94, 0xbc, 0xb7,
		},
		20, /* salt length */
		/* V4 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA384 [5] */
	{
		/* Msg5 : 128 byte */
		{
			0xca, 0x6a, 0x65, 0x50, 0xab, 0x39, 0xe1, 0x67,
			0x0a, 0x6f, 0x82, 0xf5, 0x48, 0x39, 0xd5, 0x27,
			0x71, 0xc4, 0x62, 0x33, 0x6f, 0xa3, 0x82, 0xe1,
			0x7d, 0x71, 0x71, 0x4b, 0xde, 0xb7, 0xa4, 0xe0,
			0xce, 0x0f, 0x5d, 0xaf, 0xb9, 0x8a, 0x7c, 0xe3,
			0xab, 0x50, 0x98, 0x89, 0x08, 0x86, 0x4e, 0x9a,
			0x7d, 0x75, 0xd9, 0x35, 0x36, 0xe8, 0xe3, 0x2c,
			0x51, 0xd5, 0x9b, 0xc2, 0x93, 0x40, 0x08, 0xb3,
			0x5a, 0x5d, 0x9d, 0x75, 0xd3, 0xf5, 0x0d, 0xbe,
			0x6d, 0x0a, 0x61, 0x46, 0x8e, 0xbe, 0x47, 0xce,
			0x84, 0x71, 0xad, 0x61, 0xbe, 0x2a, 0x8e, 0xda,
			0x3c, 0x38, 0x0c, 0xa6, 0x44, 0x19, 0xc0, 0xcb,
			0x57, 0x9a, 0x4e, 0x29, 0x63, 0x40, 0x3c, 0x00,
			0x3a, 0xe7, 0x04, 0xb3, 0x43, 0xa9, 0x67, 0xcc,
			0x6f, 0x01, 0x05, 0x3f, 0x6f, 0x30, 0x2b, 0xf3,
			0x25, 0xe0, 0xec, 0x7e, 0x58, 0x08, 0x73, 0x31,
		},
		/* S5 : 192 byte */
		{
			0x25, 0x29, 0x60, 0xe4, 0x3a, 0x3b, 0x53, 0x16,
			0xf1, 0x0b, 0x3a, 0x67, 0xc7, 0x20, 0xc2, 0xcf,
			0xfe, 0x49, 0x51, 0xdc, 0xd1, 0xd6, 0x90, 0x20,
			0xd5, 0xe4, 0xe5, 0x2f, 0xfb, 0xce, 0x70, 0xce,
			0xa4, 0x12, 0x9f, 0x20, 0xea, 0x64, 0xcf, 0x29,
			0x84, 0x57, 0xc0, 0xa1, 0x8c, 0x11, 0x50, 0x2a,
			0x27, 0x41, 0xe4, 0x34, 0xf5, 0xb5, 0x4a, 0x5d,
			0xb3, 0x94, 0x9c, 0x28, 0x0f, 0x36, 0x12, 0x77,
			0xe7, 0xf3, 0xd0, 0xbe, 0x31, 0x14, 0x10, 0x0e,
			0x51, 0x59, 0xbd, 0xe2, 0x52, 0xc0, 0xdb, 0xad,
			0x9a, 0x63, 0xa2, 0x4f, 0x9f, 0x6e, 0x40, 0xd4,
			0x40, 0x7d, 0x93, 0x4c, 0xb4, 0xc9, 0xf4, 0x1c,
			0x6d, 0x4f, 0x52, 0x5c, 0xea, 0x5b, 0x71, 0x69,
			0x84, 0xe9, 0xac, 0x09, 0xbc, 0xdc, 0x3c, 0x16,
			0x05, 0x07, 0x5c, 0x21, 0x64, 0x1a, 0x33, 0x1c,
			0x89, 0x1a, 0x8e, 0x18, 0xa5, 0x4f, 0x48, 0xbb,
			0x4d, 0x3a, 0xa1, 0xfb, 0x3b, 0x7c, 0x92, 0x5b,
			0xd4, 0x6d, 0x66, 0x7f, 0xde, 0x43, 0x10, 0x0f,
			0xe8, 0x39, 0x7f, 0x94, 0x3c, 0x4f, 0xe5, 0x90,
			0x2c, 0x42, 0xb4, 0x8c, 0xf5, 0x0a, 0xd5, 0xe2,
			0xad, 0x99, 0x78, 0xf8, 0x4f, 0x52, 0xec, 0x8c,
			0xd9, 0x6d, 0x2c, 0xfe, 0x3e, 0xee, 0x16, 0x13,
			0xcc, 0xcf, 0xc4, 0xf6, 0x5d, 0xb9, 0x66, 0xe0,
			0x67, 0x66, 0xe0, 0x4d, 0x0e, 0x72, 0x81, 0x83,
		},
		20, /* salt length */
		/* V5 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA384 [6] */
	{
		/* Msg6 : 128 byte */
		{
			0x86, 0x51, 0x72, 0xb5, 0x66, 0x96, 0x28, 0x3b,
			0x1b, 0xe6, 0x31, 0x76, 0xa8, 0xc1, 0x5b, 0x0c,
			0xee, 0x16, 0x28, 0x82, 0x2d, 0xb5, 0x77, 0x52,
			0xc8, 0x05, 0x61, 0x3e, 0x48, 0xfa, 0x62, 0xe3,
			0xa4, 0x42, 0xb9, 0x91, 0xc0, 0xbf, 0x11, 0x5a,
			0x33, 0x3a, 0x60, 0x69, 0x4d, 0x56, 0x10, 0x96,
			0x59, 0xc2, 0x5d, 0x37, 0x1f, 0xb3, 0xfe, 0x38,
			0xad, 0x92, 0x07, 0x6e, 0x57, 0xf1, 0x0e, 0x28,
			0xfd, 0xc4, 0x8c, 0x07, 0x8c, 0xce, 0x87, 0x10,
			0xc7, 0x59, 0x6e, 0x00, 0x48, 0x2a, 0x45, 0xdf,
			0xc1, 0xb4, 0x01, 0xd8, 0x88, 0x8c, 0x36, 0x48,
			0x53, 0x1d, 0xef, 0x15, 0x40, 0x9d, 0xdd, 0x41,
			0x18, 0x40, 0xb5, 0xbf, 0xd4, 0xab, 0xd3, 0x85,
			0x60, 0xab, 0x23, 0xe2, 0xa0, 0x27, 0x41, 0x12,
			0xb1, 0x53, 0xdf, 0x10, 0x71, 0x27, 0x68, 0xab,
			0x41, 0x10, 0xe2, 0xdc, 0x09, 0xe5, 0x19, 0x57,
		},
		/* S6 : 192 byte */
		{
			0x80, 0x06, 0xa5, 0x49, 0x32, 0x62, 0x0d, 0xf8,
			0xa1, 0xc3, 0x09, 0x0a, 0xc7, 0xb8, 0x35, 0xe5,
			0xed, 0xce, 0x73, 0xab, 0x1e, 0xef, 0xf8, 0xa4,
			0x7e, 0x08, 0x10, 0xdd, 0x1a, 0x39, 0xf1, 0x19,
			0x5b, 0x56, 0x6f, 0x41, 0x76, 0x4d, 0x28, 0x54,
			0xbd, 0xe6, 0x51, 0xfe, 0x79, 0x9e, 0xe9, 0x2d,
			0x09, 0x42, 0xcc, 0xef, 0x5c, 0xb8, 0x0d, 0x5d,
			0x19, 0xb7, 0x9d, 0xc2, 0xb4, 0xfd, 0x3d, 0x68,
			0x7c, 0xf8, 0x19, 0x3f, 0x67, 0x52, 0x68, 0xb5,
			0xa2, 0xbc, 0x87, 0xb4, 0xb4, 0xfa, 0x51, 0xdc,
			0x59, 0x2a, 0x82, 0xcb, 0x9b, 0x29, 0xa9, 0x4a,
			0xd5, 0x11, 0x0d, 0xf1, 0x09, 0xf7, 0xf3, 0x0d,
			0xdd, 0xc6, 0xfb, 0xfa, 0xbe, 0xf6, 0x32, 0x46,
			0x37, 0xb8, 0x45, 0x47, 0x51, 0xb5, 0x18, 0x27,
			0xea, 0x81, 0x30, 0x55, 0x65, 0x9a, 0x24, 0x8a,
			0xa8, 0x25, 0x2c, 0xe6, 0xd7, 0xb9, 0x55, 0x0f,
			0xd7, 0x71, 0xc1, 0x67, 0x70, 0xda, 0x14, 0xc8,
			0x3a, 0x6c, 0x05, 0x5b, 0xb8, 0xba, 0x2a, 0x7e,
			0xa1, 0x9c, 0xbf, 0x40, 0xc8, 0xf8, 0x73, 0x0a,
			0x01, 0x87, 0x18, 0xdd, 0x4c, 0x6e, 0x99, 0xac,
			0x00, 0x0f, 0x2c, 0x6a, 0x1c, 0x8e, 0x44, 0x78,
			0x70, 0xdb, 0x3d, 0xcd, 0xd6, 0x5f, 0x20, 0xc3,
			0x55, 0x28, 0xca, 0x42, 0x3e, 0x29, 0x80, 0x1b,
			0x64, 0x60, 0x3c, 0x71, 0xc0, 0xf3, 0xb3, 0x8b,
		},
		20, /* salt length */
		/* V6 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA384 [7] */
	{
		/* Msg7 : 128 byte */
		{
			0xeb, 0x52, 0xb8, 0x61, 0xcb, 0x8f, 0xab, 0xd2,
			0xd9, 0x7f, 0xc9, 0xe8, 0x8a, 0xd5, 0xd3, 0xee,
			0x4c, 0x52, 0x4e, 0xe5, 0x6d, 0x22, 0x87, 0x78,
			0x38, 0x6f, 0xd5, 0x32, 0x61, 0x31, 0x1e, 0xef,
			0xa3, 0x43, 0x9c, 0x90, 0xa7, 0xbc, 0xe1, 0xf3,
			0x28, 0x7c, 0x19, 0x23, 0x55, 0x05, 0x90, 0xcb,
			0x76, 0x8d, 0x74, 0xf1, 0xd3, 0x51, 0xdb, 0xe0,
			0xd1, 0x2b, 0x07, 0x66, 0x5f, 0x67, 0xe9, 0x40,
			0x90, 0xd3, 0xe5, 0xd3, 0x89, 0x15, 0xd5, 0x1d,
			0x9e, 0x41, 0x50, 0xea, 0xb8, 0xab, 0x2c, 0x4b,
			0xfa, 0xfa, 0x41, 0x44, 0xa4, 0x7e, 0x70, 0xc5,
			0x37, 0xc4, 0xe5, 0xdb, 0xda, 0x67, 0x98, 0x28,
			0xfc, 0x28, 0x1a, 0x91, 0x3b, 0x41, 0x8e, 0x36,
			0x84, 0xf7, 0xf5, 0xa7, 0x7c, 0x6f, 0xb0, 0x55,
			0x1f, 0xc2, 0x3f, 0x46, 0xa7, 0x53, 0x4f, 0x0d,
			0xb0, 0x61, 0xf4, 0xfa, 0x99, 0xd8, 0x33, 0x8e,
		},
		/* S7 : 192 byte */
		{
			0x34, 0xfb, 0x41, 0xf2, 0xfd, 0x1e, 0x93, 0x99,
			0x71, 0xb3, 0x36, 0x93, 0xdd, 0xb4, 0x9d, 0x67,
			0x69, 0xa0, 0x5f, 0x30, 0x74, 0xc0, 0xdf, 0xf3,
			0xd0, 0x36, 0x67, 0x4a, 0x8c, 0x9c, 0xfd, 0xa5,
			0x05, 0xf3, 0xce, 0x56, 0x73, 0x87, 0x95, 0xef,
			0x0d, 0x3e, 0x74, 0x99, 0x5e, 0xc9, 0xf5, 0x6b,
			0x9e, 0xba, 0x0f, 0x84, 0x5d, 0x98, 0x04, 0x11,
			0x70, 0x82, 0x5f, 0xd0, 0xae, 0x20, 0x75, 0x9b,
			0xdf, 0xc2, 0x27, 0x15, 0x78, 0x9b, 0x81, 0x45,
			0x3f, 0x03, 0xaf, 0xca, 0x95, 0x4e, 0x54, 0xe7,
			0xac, 0x7a, 0x09, 0xe3, 0xdb, 0x66, 0x4d, 0x78,
			0xab, 0xf7, 0x20, 0xfb, 0x4d, 0x31, 0x5a, 0xa1,
			0x51, 0x0a, 0xf8, 0x71, 0x63, 0x8c, 0x33, 0x65,
			0x1a, 0x58, 0x9e, 0xd4, 0x94, 0xfd, 0x3e, 0x3e,
			0x49, 0xc2, 0x9e, 0x49, 0xf7, 0x12, 0xd9, 0xf8,
			0xf7, 0x3c, 0xe1, 0x31, 0x2e, 0x03, 0x45, 0xf6,
			0xa4, 0x42, 0xfa, 0xfd, 0x05, 0xdc, 0x88, 0x86,
			0x9b, 0x66, 0x11, 0x0f, 0x12, 0xab, 0x6d, 0x85,
			0xbe, 0x57, 0x3f, 0x7a, 0xa8, 0x69, 0x8a, 0x38,
			0x63, 0x7b, 0x5b, 0x3a, 0x43, 0x95, 0xa7, 0xbb,
			0xc6, 0xb0, 0xb5, 0x3d, 0xdc, 0x5d, 0xf4, 0x99,
			0x4d, 0x80, 0xa1, 0xf4, 0x95, 0x05, 0x66, 0x0e,
			0x07, 0xdd, 0xe3, 0x71, 0x7b, 0x0b, 0xbc, 0x0e,
			0x26, 0x85, 0xfa, 0x38, 0x0f, 0x82, 0x5c, 0xff,
		},
		20, /* salt length */
		/* V7 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA384 [8] */
	{
		/* Msg8 : 128 byte */
		{
			0x57, 0xc8, 0x2b, 0x90, 0xa5, 0xc6, 0xb4, 0xa9,
			0x77, 0x37, 0xee, 0x97, 0x1d, 0x39, 0x4d, 0x8b,
			0x50, 0xaf, 0xf8, 0x9e, 0x19, 0x94, 0xcf, 0xc2,
			0xee, 0x90, 0xad, 0xf9, 0x1d, 0xc9, 0xea, 0xc5,
			0x6e, 0xfc, 0x25, 0xdf, 0x03, 0xcc, 0x40, 0x2b,
			0x84, 0x5a, 0xab, 0xec, 0x79, 0x15, 0xe6, 0x35,
			0xf7, 0xd4, 0x41, 0xa0, 0x7f, 0x22, 0xe7, 0x41,
			0x23, 0xd8, 0x1a, 0xdd, 0xea, 0xf2, 0xc0, 0x58,
			0x76, 0x9b, 0x1f, 0x6d, 0xe4, 0x8a, 0xe5, 0xa2,
			0xf4, 0x91, 0x6b, 0x7a, 0x6a, 0x73, 0x3a, 0xec,
			0xb4, 0xf7, 0xcf, 0x14, 0xcc, 0x3a, 0x9b, 0x29,
			0x60, 0x49, 0x4e, 0xaf, 0x31, 0xef, 0x55, 0xed,
			0xb9, 0xcc, 0xa1, 0xa2, 0x10, 0xa7, 0xab, 0xf4,
			0x10, 0x06, 0xb5, 0xa9, 0xb8, 0xfb, 0x52, 0x99,
			0xce, 0x40, 0x28, 0x63, 0xc8, 0x86, 0xf5, 0x60,
			0xed, 0x0b, 0xd0, 0xd5, 0xb8, 0x6b, 0xb2, 0x6d,
		},
		/* S8 : 192 byte */
		{
			0x56, 0xf6, 0xa8, 0x9f, 0x15, 0xb4, 0x88, 0xd2,
			0xb7, 0xf3, 0xf7, 0x9b, 0x80, 0x71, 0x8e, 0x06,
			0x8d, 0xd2, 0x08, 0xf4, 0xfc, 0xe6, 0x82, 0x59,
			0xab, 0x4e, 0xc9, 0x2d, 0xbf, 0xe6, 0xf7, 0x0f,
			0x9a, 0xfa, 0x88, 0xbc, 0xba, 0x4b, 0x0e, 0xdf,
			0xb7, 0x0e, 0x61, 0xf9, 0x62, 0x1b, 0x5c, 0xe3,
			0x1a, 0xa3, 0xc2, 0x98, 0xf2, 0xcd, 0x61, 0x66,
			0x22, 0xa3, 0xa8, 0x53, 0x21, 0xd6, 0x6b, 0x27,
			0x4f, 0x11, 0xfd, 0x16, 0xcd, 0x8f, 0x21, 0xc1,
			0x16, 0x95, 0x9b, 0x4c, 0x49, 0x8a, 0x34, 0x98,
			0x7a, 0x13, 0xca, 0x1a, 0x85, 0xc2, 0xab, 0x6f,
			0xc8, 0x61, 0xce, 0xa2, 0xb6, 0x1e, 0xd8, 0x69,
			0x3a, 0xb6, 0xad, 0xbd, 0x9e, 0x1d, 0x7d, 0x48,
			0x01, 0x8d, 0x2b, 0x3d, 0xae, 0xb8, 0xaa, 0x34,
			0xd1, 0xb5, 0x18, 0xf2, 0x9f, 0xa8, 0xf2, 0x9b,
			0x7b, 0x3b, 0x63, 0x39, 0xac, 0x1d, 0x76, 0x61,
			0x41, 0x58, 0x60, 0x22, 0xf6, 0x70, 0xd3, 0x4e,
			0x97, 0xe8, 0xef, 0xe1, 0xe5, 0xf2, 0x0b, 0x2e,
			0xc2, 0x25, 0xd6, 0x20, 0x16, 0x17, 0x52, 0x7c,
			0x25, 0xe7, 0xf6, 0x22, 0x1d, 0xa5, 0xfb, 0xfd,
			0x94, 0x7c, 0x0a, 0x3b, 0x25, 0x03, 0x79, 0xf9,
			0x28, 0xb1, 0x2f, 0x9e, 0x00, 0x28, 0xe4, 0xce,
			0x53, 0xcf, 0x63, 0x77, 0x59, 0x48, 0xcf, 0xa9,
			0xe6, 0x25, 0x5b, 0x66, 0xac, 0x19, 0x07, 0x13,
		},
		20, /* salt length */
		/* V8 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA384 [9] */
	{
		/* Msg9 : 128 byte */
		{
			0xa3, 0x03, 0x1f, 0xc5, 0xd6, 0xc6, 0xfb, 0xf9,
			0x1d, 0x8d, 0x19, 0x8f, 0xcc, 0x65, 0x19, 0x33,
			0x34, 0x74, 0x60, 0x46, 0x7f, 0x44, 0x1b, 0xd4,
			0xdb, 0x5e, 0x80, 0xc7, 0xdb, 0x1b, 0x57, 0x5a,
			0x19, 0xb7, 0xba, 0xd0, 0x21, 0xa7, 0x19, 0x65,
			0x8a, 0x2c, 0x81, 0x85, 0x66, 0x29, 0x1d, 0x3c,
			0xdd, 0x32, 0xfd, 0xee, 0x14, 0xe5, 0x16, 0x48,
			0x54, 0x7d, 0x8a, 0x76, 0x68, 0xa4, 0x2a, 0x96,
			0x46, 0x89, 0x39, 0x6d, 0xf2, 0x33, 0x73, 0x59,
			0xa0, 0x15, 0x4e, 0x87, 0x19, 0xe2, 0x80, 0x66,
			0x5f, 0xa2, 0xc1, 0x5c, 0x94, 0x06, 0xd2, 0xb7,
			0x18, 0xf8, 0xbe, 0xe6, 0xf2, 0x77, 0x60, 0xe9,
			0x71, 0xa2, 0x25, 0x06, 0x12, 0x12, 0x14, 0xbe,
			0xa5, 0x6d, 0x0b, 0xff, 0xac, 0x38, 0x4b, 0x9b,
			0x04, 0xed, 0x36, 0xf9, 0xc7, 0x4e, 0x58, 0x0b,
			0x70, 0xf8, 0xa5, 0x7f, 0x40, 0x3b, 0x01, 0x3a,
		},
		/* S9 : 192 byte */
		{
			0x81, 0x18, 0x15, 0x83, 0x05, 0xdd, 0x23, 0x3d,
			0x4c, 0x9c, 0x86, 0xde, 0xd3, 0x92, 0x28, 0x1c,
			0x61, 0x1b, 0xe2, 0xe9, 0x69, 0x48, 0x37, 0x32,
			0x96, 0x44, 0xcd, 0x77, 0xb7, 0x03, 0x54, 0x80,
			0xd5, 0x52, 0x2e, 0x14, 0xa5, 0xd5, 0x0a, 0x37,
			0x31, 0x2c, 0x65, 0x01, 0x44, 0x05, 0x5f, 0x3e,
			0x06, 0xd6, 0xa5, 0xba, 0xcf, 0x0c, 0x49, 0x65,
			0x70, 0xb3, 0x2b, 0x68, 0x22, 0x6b, 0x60, 0x5b,
			0x21, 0x45, 0x38, 0xb1, 0xc5, 0xb3, 0x8c, 0xa5,
			0x56, 0x3b, 0xa5, 0x08, 0x16, 0xd8, 0xbc, 0x2d,
			0xb3, 0xe9, 0xeb, 0x21, 0x10, 0x98, 0xec, 0x5c,
			0x5d, 0xd6, 0x57, 0x09, 0xaf, 0xdf, 0x28, 0x8e,
			0x89, 0xd1, 0x6e, 0xc7, 0x61, 0x5f, 0xa5, 0xdb,
			0x66, 0x36, 0x8e, 0x8c, 0xf0, 0x65, 0x71, 0x2f,
			0x7f, 0xdb, 0x5a, 0xde, 0x80, 0x59, 0x53, 0xc6,
			0xaf, 0xed, 0xd2, 0xd4, 0xdc, 0x6d, 0x62, 0xb0,
			0xa9, 0x1a, 0x6a, 0x1a, 0xf3, 0x9c, 0x5c, 0x8c,
			0x14, 0x97, 0xf7, 0x3d, 0x4b, 0xaf, 0xa2, 0x8b,
			0x87, 0x83, 0x2d, 0xd5, 0xb8, 0xf7, 0x90, 0xd0,
			0xb1, 0xb2, 0xef, 0x67, 0xb0, 0x28, 0xd6, 0x38,
			0xd2, 0x6b, 0x15, 0xa2, 0x80, 0x64, 0xf8, 0xca,
			0xce, 0x1c, 0xbc, 0x88, 0x1b, 0xed, 0x42, 0x33,
			0x58, 0xf0, 0x2c, 0xa2, 0x3c, 0x45, 0x74, 0xaf,
			0x49, 0x31, 0x6f, 0x8f, 0x3c, 0x95, 0x69, 0x7b,
		},
		20, /* salt length */
		/* V9 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
};

/* 10 elements */
static mod1536_t SHA512[] = {
	/* SHA512 [0] */
	{
		/* Msg0 : 128 byte */
		{
			0x72, 0x24, 0x09, 0x1b, 0x8f, 0x68, 0xb0, 0x0d,
			0x49, 0xd2, 0xef, 0x1b, 0xfc, 0x5c, 0xa7, 0x35,
			0x2e, 0x85, 0x2a, 0xee, 0x73, 0xa3, 0x46, 0x76,
			0x8f, 0x7b, 0x80, 0xc8, 0xdb, 0x0f, 0x9d, 0x24,
			0xea, 0xb7, 0x67, 0xc0, 0x6b, 0x73, 0xad, 0xbb,
			0x51, 0x80, 0x8c, 0x52, 0x32, 0x29, 0xed, 0x56,
			0xed, 0xe0, 0x4f, 0xdd, 0x90, 0x8d, 0xc7, 0x39,
			0x79, 0x26, 0x44, 0x26, 0xbb, 0x80, 0x18, 0x47,
			0xc3, 0x65, 0xb4, 0xd4, 0x3b, 0xe6, 0xb3, 0x8d,
			0x2e, 0xf2, 0x1b, 0xf2, 0x6d, 0x28, 0xdf, 0xb5,
			0x32, 0xea, 0xa8, 0x70, 0x04, 0xb3, 0xd4, 0x94,
			0xda, 0xaa, 0xbf, 0xa1, 0x83, 0x77, 0x42, 0x9d,
			0x45, 0x55, 0x7a, 0xbf, 0xc5, 0x68, 0xcb, 0x6b,
			0x26, 0x52, 0x24, 0x63, 0x75, 0x01, 0x84, 0x3b,
			0x45, 0xca, 0xbd, 0x0d, 0x96, 0xbc, 0x78, 0x6f,
			0xfc, 0x2e, 0x79, 0xa2, 0xfd, 0x9b, 0x24, 0x0c,
		},
		/* S0 : 192 byte */
		{
			0x32, 0xe6, 0x88, 0x06, 0x3e, 0xa2, 0x4c, 0xcb,
			0x2c, 0xa9, 0x98, 0xfb, 0x70, 0x91, 0x87, 0x7c,
			0x10, 0x3c, 0xe6, 0x57, 0x6b, 0x11, 0xa1, 0x75,
			0xbc, 0x89, 0x6a, 0xf4, 0x54, 0x04, 0x2a, 0x57,
			0x31, 0xb9, 0x1c, 0x1c, 0x58, 0xb4, 0xd8, 0xe3,
			0x8f, 0x06, 0x19, 0xf6, 0xdd, 0xc8, 0xce, 0xd6,
			0xb5, 0x39, 0x75, 0x45, 0xf9, 0x57, 0x1a, 0x4c,
			0x90, 0x76, 0x75, 0x93, 0xd1, 0x1c, 0x00, 0xb7,
			0x5e, 0xb5, 0x8a, 0x0a, 0xe4, 0x93, 0x22, 0x65,
			0xf0, 0xab, 0x17, 0x90, 0xbe, 0x2c, 0x83, 0xdf,
			0xf6, 0x53, 0x57, 0xa3, 0x01, 0xb3, 0xb3, 0xe2,
			0xee, 0x2e, 0x36, 0x83, 0xaf, 0xe0, 0xb4, 0xb3,
			0x5e, 0xe8, 0xb6, 0xe5, 0x8a, 0x96, 0xb4, 0x00,
			0x9c, 0x98, 0xd8, 0xfa, 0xba, 0x75, 0xf8, 0x6f,
			0xfb, 0x54, 0x8f, 0x05, 0x01, 0x88, 0x4f, 0x35,
			0x28, 0xd8, 0xea, 0xba, 0xd3, 0x53, 0xe2, 0x8d,
			0x01, 0x32, 0xc4, 0xc0, 0x1f, 0xa3, 0xaf, 0x5d,
			0xec, 0x92, 0x2f, 0x02, 0xef, 0xf2, 0x20, 0x20,
			0x48, 0x16, 0x15, 0xe4, 0xcd, 0x35, 0xb9, 0xec,
			0xcf, 0xd7, 0x11, 0xcb, 0x3b, 0x0d, 0x65, 0xaf,
			0x95, 0xc0, 0x63, 0x7d, 0x79, 0xaa, 0xa2, 0x43,
			0x3f, 0x28, 0x54, 0xde, 0x35, 0x60, 0xad, 0xb2,
			0x84, 0x24, 0x8b, 0xac, 0x8c, 0xbd, 0x47, 0x17,
			0x31, 0x70, 0x11, 0xa5, 0x15, 0x9c, 0x93, 0xed,
		},
		20, /* salt length */
		/* V0 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA512 [1] */
	{
		/* Msg1 : 128 byte */
		{
			0x9e, 0xac, 0xa2, 0xd3, 0xb4, 0xa5, 0x41, 0x90,
			0xed, 0xe7, 0xf7, 0x41, 0x9f, 0xbe, 0xe6, 0x50,
			0x1e, 0x81, 0x21, 0x55, 0x2f, 0x2d, 0xbe, 0xdc,
			0xc0, 0x4d, 0x2d, 0x68, 0xd6, 0x1d, 0xc8, 0xb8,
			0xc6, 0xee, 0xaa, 0x48, 0xa8, 0xcc, 0xc5, 0x1b,
			0x09, 0x5f, 0x2f, 0xb8, 0xe0, 0x0f, 0xbd, 0x73,
			0xc3, 0x6b, 0xd3, 0xed, 0x5b, 0xcc, 0x7a, 0xde,
			0x16, 0x35, 0xb3, 0x12, 0x1b, 0x7e, 0x0c, 0xb2,
			0x83, 0xb2, 0x70, 0xc5, 0xc6, 0xb5, 0x43, 0xf6,
			0x73, 0x2a, 0xaf, 0x98, 0x25, 0x93, 0x38, 0xe7,
			0xb2, 0xba, 0x97, 0x91, 0xa5, 0x51, 0xc5, 0x75,
			0xef, 0xd5, 0x56, 0xaa, 0xd9, 0xb8, 0x08, 0xc3,
			0x3d, 0xbe, 0x9c, 0x51, 0xf6, 0xa8, 0xe4, 0xaa,
			0x95, 0x10, 0x1e, 0xe9, 0x55, 0x94, 0x80, 0x36,
			0x52, 0x36, 0x14, 0x48, 0xf5, 0x03, 0xc6, 0x27,
			0xb3, 0xf3, 0xbc, 0x37, 0xf7, 0x11, 0xe5, 0x72,
		},
		/* S1 : 192 byte */
		{
			0x12, 0xd9, 0x85, 0xa3, 0xc2, 0x18, 0x89, 0x5a,
			0xd5, 0x30, 0xeb, 0xd1, 0x9e, 0x1b, 0x7d, 0xfe,
			0xe9, 0x0e, 0x36, 0xba, 0x38, 0x97, 0x36, 0x7d,
			0x91, 0xee, 0x3d, 0x9a, 0xdc, 0x03, 0xef, 0xf4,
			0x3d, 0x6d, 0x1c, 0x79, 0x1c, 0xf5, 0x18, 0xd5,
			0xd1, 0xf5, 0xd7, 0x41, 0x24, 0x65, 0x9a, 0xf2,
			0xf5, 0x64, 0x22, 0x36, 0x79, 0xfa, 0xc2, 0xab,
			0x04, 0xcd, 0xcd, 0xe0, 0x57, 0xf3, 0x98, 0xb6,
			0xde, 0x15, 0x58, 0x55, 0x4d, 0x96, 0xc4, 0x64,
			0xcb, 0xf5, 0x51, 0xfe, 0xbb, 0x8b, 0xa8, 0x8e,
			0x7c, 0x92, 0xc6, 0xf2, 0x1b, 0x65, 0x55, 0x55,
			0xbb, 0x79, 0x95, 0x0c, 0xb9, 0xf2, 0x45, 0x96,
			0xc2, 0xec, 0xba, 0x15, 0x77, 0x79, 0x39, 0x27,
			0xb1, 0x13, 0xc5, 0xc2, 0x60, 0x64, 0x19, 0x8c,
			0xa2, 0x90, 0x74, 0x88, 0xee, 0x16, 0xd9, 0xf9,
			0x0f, 0xe3, 0x64, 0x81, 0x28, 0xb2, 0x88, 0x9d,
			0x89, 0xc6, 0xd7, 0x05, 0xed, 0xc7, 0x7b, 0x0d,
			0xd7, 0x11, 0x7f, 0xe0, 0x7b, 0x02, 0x10, 0x97,
			0xed, 0x66, 0xfc, 0x62, 0x86, 0xd8, 0x03, 0x12,
			0x64, 0x3a, 0x13, 0xd5, 0xc1, 0xa0, 0xe3, 0x79,
			0xaf, 0x61, 0xbc, 0x04, 0x00, 0x57, 0x42, 0xff,
			0x5c, 0x0a, 0xd9, 0x96, 0x11, 0x9a, 0x84, 0xce,
			0xf8, 0x74, 0xd6, 0x32, 0xcb, 0x6c, 0xd1, 0x39,
			0xd6, 0x98, 0x88, 0x35, 0xff, 0x11, 0xad, 0x18,
		},
		20, /* salt length */
		/* V1 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA512 [2] */
	{
		/* Msg2 : 128 byte */
		{
			0x23, 0xf0, 0x3a, 0x3b, 0xc7, 0xe9, 0xdd, 0xe2,
			0x61, 0xaa, 0x31, 0x69, 0x8c, 0x30, 0xc8, 0x66,
			0x8f, 0x77, 0x43, 0x47, 0x32, 0xf8, 0xc5, 0xf4,
			0xd1, 0x6f, 0xa8, 0xb0, 0xae, 0xe1, 0x6f, 0x40,
			0x8b, 0xde, 0xfc, 0x50, 0x79, 0x04, 0x04, 0x12,
			0xeb, 0xc4, 0xbf, 0x28, 0x0e, 0x69, 0xe4, 0xc4,
			0x5d, 0x55, 0xd4, 0x0e, 0x70, 0x8e, 0x15, 0xc6,
			0x14, 0x7a, 0x03, 0x2a, 0xa1, 0xe7, 0xc2, 0x1a,
			0x88, 0x4e, 0x77, 0x7a, 0x2c, 0x59, 0xb8, 0xd8,
			0xf3, 0xa2, 0x41, 0x4e, 0x9c, 0xbe, 0xe8, 0xaa,
			0xd3, 0x7a, 0xd3, 0xcd, 0x02, 0x64, 0xe8, 0x51,
			0x6b, 0x8e, 0x85, 0x6f, 0x74, 0x8e, 0x71, 0x1f,
			0x41, 0xc9, 0x13, 0x80, 0x88, 0xf2, 0xe2, 0x7b,
			0xa1, 0xcd, 0x1d, 0xa3, 0xdd, 0x39, 0xbc, 0x60,
			0x19, 0x6d, 0xa6, 0x4d, 0x93, 0x82, 0x24, 0xde,
			0xfc, 0x32, 0x96, 0x46, 0xce, 0xdf, 0x65, 0x98,
		},
		/* S2 : 192 byte */
		{
			0x1e, 0x88, 0x9c, 0xfa, 0x7e, 0x10, 0x75, 0xe4,
			0x20, 0x16, 0x9d, 0x17, 0x51, 0x50, 0xa6, 0x81,
			0xb8, 0xed, 0x01, 0xc8, 0x80, 0x75, 0xc3, 0x16,
			0xf1, 0x9b, 0xa7, 0xc1, 0x88, 0x58, 0xd8, 0x23,
			0xe8, 0x0b, 0x3c, 0x16, 0xb8, 0x0a, 0x7c, 0x05,
			0x9d, 0x9c, 0x23, 0xf8, 0x43, 0x45, 0xdc, 0xc6,
			0x55, 0x39, 0xcd, 0xe7, 0x5b, 0xf1, 0xb5, 0x87,
			0xec, 0x57, 0xdf, 0x78, 0xe4, 0xec, 0xc9, 0xab,
			0x8a, 0x6a, 0x40, 0x68, 0xa4, 0xb3, 0x86, 0x95,
			0xef, 0xf1, 0xf4, 0x69, 0x45, 0x93, 0xb9, 0xb3,
			0x3e, 0xbe, 0xe8, 0xdf, 0xfd, 0x98, 0xec, 0x8d,
			0x32, 0xae, 0xdd, 0xd0, 0x84, 0x58, 0x4d, 0xbf,
			0xcc, 0x50, 0xfb, 0x04, 0x01, 0xb8, 0x39, 0x4c,
			0xfe, 0x25, 0x2a, 0xe9, 0x6d, 0x24, 0x31, 0xc2,
			0x4d, 0x8b, 0xbb, 0x50, 0x3f, 0xbb, 0x20, 0xde,
			0x2f, 0x89, 0xdf, 0x03, 0x76, 0x2e, 0x03, 0x3c,
			0xef, 0xd3, 0xc1, 0x10, 0x57, 0x36, 0x8e, 0xdd,
			0x5c, 0xf8, 0x1f, 0x9e, 0x33, 0x76, 0xef, 0x50,
			0x29, 0x57, 0x1d, 0xa0, 0x20, 0x48, 0x96, 0x4e,
			0x53, 0xc7, 0xc2, 0x64, 0x4d, 0x90, 0x36, 0x41,
			0x77, 0x10, 0x4b, 0x53, 0xf4, 0xce, 0xcf, 0x46,
			0x06, 0x95, 0x05, 0xfc, 0xba, 0x20, 0xa3, 0xe0,
			0x36, 0x1b, 0xfb, 0x5e, 0xf8, 0x45, 0x94, 0x3d,
			0x6e, 0x89, 0xc5, 0xd9, 0x1a, 0xa0, 0x75, 0xf2,
		},
		20, /* salt length */
		/* V2 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA512 [3] */
	{
		/* Msg3 : 128 byte */
		{
			0x2e, 0xa1, 0xe8, 0x61, 0x79, 0x53, 0x53, 0xdd,
			0x0f, 0xbc, 0xda, 0x44, 0x29, 0xbd, 0x28, 0x9f,
			0x81, 0xba, 0x66, 0x8a, 0x13, 0x4b, 0x18, 0x88,
			0x25, 0x34, 0x41, 0x99, 0x85, 0x98, 0xce, 0x0f,
			0x12, 0x69, 0x31, 0x9d, 0x7d, 0x23, 0x4d, 0xb1,
			0x51, 0xba, 0x92, 0x03, 0x31, 0xd0, 0x69, 0x6e,
			0x61, 0x2c, 0xd2, 0x00, 0x89, 0x68, 0x4b, 0x4d,
			0xb5, 0xe9, 0xf5, 0x08, 0x9f, 0x15, 0xf2, 0xd4,
			0x31, 0xbf, 0x11, 0x57, 0x46, 0xe6, 0xad, 0x90,
			0xb1, 0xa0, 0xd2, 0x6b, 0x80, 0x51, 0xa2, 0x93,
			0x82, 0x20, 0xf7, 0x88, 0x06, 0xac, 0x4a, 0xf1,
			0xe6, 0xfa, 0xd4, 0x33, 0xc4, 0xb3, 0xf2, 0x42,
			0x94, 0x8c, 0xce, 0xb8, 0x5a, 0x05, 0x3c, 0x24,
			0x35, 0x56, 0xe2, 0xa4, 0x9d, 0xa6, 0x9c, 0xb6,
			0xe9, 0x7f, 0x1f, 0x4b, 0x14, 0x7f, 0xdc, 0x1d,
			0xc0, 0x50, 0x27, 0x43, 0x7b, 0xda, 0x98, 0x02,
		},
		/* S3 : 192 byte */
		{
			0x91, 0xeb, 0x26, 0x98, 0xae, 0x04, 0x41, 0xac,
			0x23, 0xc0, 0xea, 0x6f, 0x51, 0xcf, 0xb2, 0x04,
			0xc0, 0xb5, 0x33, 0xcd, 0x62, 0x2f, 0xda, 0xad,
			0x6f, 0x9c, 0x9c, 0x5d, 0x22, 0x2f, 0xff, 0x03,
			0x16, 0xaa, 0x68, 0x5a, 0xfa, 0x84, 0x30, 0x7e,
			0xa8, 0xf3, 0xd4, 0x98, 0x7a, 0x4b, 0x5b, 0x3a,
			0x92, 0x10, 0x4f, 0x2d, 0x91, 0x68, 0xda, 0x3a,
			0x61, 0x63, 0x59, 0x52, 0x29, 0x46, 0x85, 0x79,
			0x16, 0x97, 0x14, 0x7c, 0x41, 0x10, 0xaa, 0xdb,
			0xaf, 0x87, 0x38, 0x4b, 0xff, 0xe5, 0x15, 0x86,
			0x93, 0xe0, 0x3c, 0x47, 0xf1, 0x56, 0x18, 0xfd,
			0x02, 0xd9, 0x38, 0xfb, 0x66, 0x45, 0x76, 0x2e,
			0xb0, 0x4d, 0x23, 0xed, 0x4c, 0x6f, 0x60, 0x7d,
			0xbd, 0xec, 0xbe, 0x8a, 0xba, 0x8f, 0x1e, 0xbd,
			0x22, 0x05, 0xbf, 0x7e, 0xce, 0xce, 0x33, 0x5b,
			0x00, 0x99, 0x80, 0xc3, 0x90, 0xe6, 0x4a, 0x40,
			0x4f, 0x98, 0x51, 0x94, 0xd3, 0x21, 0x4c, 0x2f,
			0x04, 0x67, 0x88, 0xc6, 0x00, 0x0a, 0xb8, 0x34,
			0x10, 0x43, 0xaf, 0xec, 0x28, 0xea, 0x29, 0x60,
			0xa2, 0x08, 0x76, 0xc9, 0x0e, 0x16, 0xa3, 0x7d,
			0x2f, 0xa2, 0x44, 0x50, 0x24, 0x83, 0xa1, 0x2d,
			0xb0, 0x31, 0xdf, 0xfc, 0x9f, 0x3f, 0x7c, 0xe5,
			0x95, 0xdd, 0x0d, 0x1d, 0x4f, 0x6a, 0xf9, 0xdd,
			0x23, 0x69, 0xa0, 0x23, 0x8d, 0x72, 0x3b, 0xee,
		},
		20, /* salt length */
		/* V3 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA512 [4] */
	{
		/* Msg4 : 128 byte */
		{
			0x11, 0x7d, 0x33, 0x90, 0xad, 0xab, 0xe4, 0x0e,
			0xc2, 0xfe, 0x71, 0x0f, 0x03, 0xae, 0x47, 0x20,
			0x5a, 0x4e, 0xb9, 0x14, 0xda, 0xf3, 0x98, 0x4c,
			0xf6, 0x98, 0x04, 0x36, 0xf0, 0xc1, 0x81, 0x14,
			0x94, 0x5f, 0x4e, 0xff, 0x25, 0xf4, 0xf2, 0x2b,
			0x98, 0xf7, 0x17, 0x6c, 0x00, 0x7a, 0x9b, 0xf9,
			0x4a, 0x0a, 0xe5, 0x71, 0x2a, 0xd7, 0x75, 0x1b,
			0x55, 0x15, 0xbf, 0x72, 0xf1, 0xa1, 0x3a, 0xe1,
			0x49, 0xe8, 0xb4, 0xcb, 0xc6, 0x05, 0xe8, 0xce,
			0x1b, 0x29, 0x52, 0x49, 0xbf, 0x40, 0x42, 0x1b,
			0xa0, 0xd1, 0x30, 0xae, 0x16, 0x26, 0x4f, 0x35,
			0x15, 0xae, 0x64, 0x31, 0xa8, 0x9f, 0xd9, 0x3a,
			0x9a, 0xdf, 0x0d, 0xfc, 0x76, 0x25, 0xef, 0x80,
			0xb3, 0x5c, 0xcb, 0xad, 0x28, 0x48, 0x64, 0x0e,
			0xc6, 0x6b, 0x42, 0xd5, 0x85, 0x2a, 0x4d, 0x20,
			0x9f, 0x2c, 0x9b, 0x7c, 0xfd, 0x03, 0x87, 0xa7,
		},
		/* S4 : 192 byte */
		{
			0x34, 0xba, 0x40, 0xbb, 0x52, 0x99, 0x16, 0xc8,
			0x2e, 0x3e, 0xb7, 0xb2, 0xaf, 0xa2, 0x29, 0x87,
			0x4d, 0x04, 0x19, 0x83, 0xf1, 0x50, 0x91, 0x2a,
			0x39, 0xb5, 0xbe, 0x69, 0x85, 0x04, 0xe2, 0x4f,
			0xc3, 0x39, 0x23, 0xc0, 0xd9, 0xa7, 0xc4, 0xda,
			0xce, 0x93, 0x32, 0x1e, 0xe3, 0x8d, 0x01, 0xbe,
			0x1e, 0xb0, 0xd5, 0xfb, 0x7a, 0x5e, 0xde, 0xc1,
			0x2d, 0x49, 0xd1, 0xef, 0xf2, 0x2b, 0x7b, 0xe0,
			0x27, 0xf7, 0xb6, 0xd6, 0xcd, 0x26, 0xbd, 0xf6,
			0x46, 0x07, 0x72, 0x77, 0xf9, 0xdd, 0x95, 0xd7,
			0x36, 0xfb, 0xa9, 0x1c, 0xe4, 0x74, 0x21, 0xc7,
			0x04, 0x9a, 0x94, 0x98, 0x6f, 0x5c, 0x1d, 0xe7,
			0x8b, 0x68, 0xbe, 0x64, 0x48, 0x96, 0x17, 0x4f,
			0x06, 0x5d, 0xdb, 0x74, 0x5b, 0xc8, 0x54, 0xfc,
			0x2a, 0xbe, 0xd5, 0x46, 0xb1, 0xa7, 0x93, 0xb7,
			0x7a, 0x95, 0xab, 0xf8, 0x1d, 0xc0, 0xd7, 0x59,
			0x85, 0x33, 0x22, 0x3e, 0x44, 0x6c, 0x87, 0xb8,
			0x22, 0x6b, 0x33, 0x2d, 0x93, 0x30, 0xe6, 0x2e,
			0x38, 0xc8, 0xb5, 0x98, 0x33, 0x6c, 0xc1, 0x24,
			0xf1, 0x4d, 0xa7, 0x37, 0xf5, 0x05, 0xb3, 0xa8,
			0x7e, 0x1c, 0x72, 0x1e, 0xf4, 0x5a, 0xb0, 0x27,
			0x2e, 0x83, 0x40, 0xfd, 0xdd, 0x46, 0xb1, 0x91,
			0xb2, 0x7b, 0xea, 0x39, 0xbf, 0x43, 0xa4, 0x01,
			0x18, 0x1f, 0x86, 0x8a, 0x75, 0xd1, 0x1e, 0x8e,
		},
		20, /* salt length */
		/* V4 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA512 [5] */
	{
		/* Msg5 : 128 byte */
		{
			0x1b, 0x03, 0x76, 0x07, 0x45, 0xad, 0x3e, 0x9e,
			0xf2, 0x90, 0x17, 0xcd, 0x7c, 0xed, 0x51, 0x6f,
			0xe0, 0x1b, 0xf3, 0x44, 0x73, 0x71, 0x0a, 0xf2,
			0xd0, 0x66, 0x41, 0x49, 0x15, 0xf7, 0xb2, 0xcb,
			0x4f, 0x49, 0xfc, 0x6c, 0x32, 0x90, 0x96, 0x96,
			0x0e, 0x2f, 0x63, 0x70, 0xfe, 0x21, 0x86, 0x60,
			0x63, 0x97, 0x77, 0xcf, 0x90, 0xe2, 0x56, 0x2c,
			0xc7, 0x94, 0x80, 0x33, 0x65, 0xe2, 0x61, 0x6f,
			0x59, 0x4d, 0x89, 0xfd, 0xda, 0x82, 0x01, 0x94,
			0x5a, 0x7e, 0xdf, 0xc2, 0xb5, 0xf5, 0x18, 0x78,
			0xaf, 0xf5, 0x96, 0xc9, 0x9d, 0xc7, 0x8a, 0xef,
			0x62, 0x16, 0x04, 0x8f, 0x9d, 0x52, 0xc1, 0x3e,
			0x21, 0x57, 0x43, 0x43, 0xa6, 0x4a, 0x27, 0x9e,
			0xbe, 0xc4, 0xb4, 0x4a, 0x0a, 0x33, 0xb0, 0xc0,
			0xad, 0x7d, 0x77, 0xbc, 0x01, 0xe6, 0x4e, 0x43,
			0x89, 0x33, 0xf4, 0xe5, 0x27, 0x0f, 0x7a, 0x40,
		},
		/* S5 : 192 byte */
		{
			0x9e, 0xc5, 0x4c, 0x58, 0x8f, 0xf3, 0x3a, 0xa4,
			0xce, 0x6c, 0x9b, 0x63, 0xca, 0x61, 0xd6, 0x1a,
			0x04, 0x72, 0x0b, 0x8e, 0x7f, 0x2d, 0x2b, 0x1d,
			0x41, 0x13, 0x1b, 0x1b, 0x14, 0xcb, 0x20, 0x0e,
			0xe9, 0x6d, 0x14, 0x45, 0x3a, 0x5f, 0x87, 0xb8,
			0xbf, 0x76, 0xfd, 0xeb, 0xb3, 0xa9, 0x7e, 0x8a,
			0x1a, 0xb9, 0x9c, 0x8e, 0x55, 0x82, 0xea, 0x64,
			0xc3, 0x3e, 0x22, 0x52, 0xce, 0x40, 0xef, 0x44,
			0xd9, 0x36, 0x6f, 0x5b, 0x50, 0xaa, 0x24, 0x9b,
			0xfb, 0xb9, 0xea, 0x46, 0xab, 0x63, 0xf7, 0xb6,
			0x75, 0x32, 0x1e, 0xb9, 0xb7, 0x37, 0x0c, 0x8e,
			0x6d, 0x5c, 0x9d, 0xc4, 0x8b, 0xfb, 0x36, 0x86,
			0x09, 0x07, 0x1d, 0x13, 0x4a, 0x5c, 0x19, 0x46,
			0x7e, 0x7c, 0x3b, 0xbb, 0x91, 0x7a, 0x50, 0x6e,
			0x68, 0x0b, 0xf7, 0xf0, 0x33, 0x61, 0x78, 0xe3,
			0xc0, 0x9f, 0xf7, 0x57, 0x93, 0xed, 0xf4, 0x97,
			0x42, 0x9b, 0x09, 0x18, 0xc5, 0xac, 0x64, 0x9e,
			0xe0, 0x3e, 0xa9, 0x5f, 0x88, 0x09, 0x1e, 0xa0,
			0x17, 0x22, 0x80, 0xe9, 0xed, 0xbe, 0x6a, 0x41,
			0x1b, 0x51, 0x78, 0xbf, 0xfd, 0xf1, 0xe7, 0x9a,
			0xde, 0xf4, 0x1c, 0x7a, 0x5c, 0x0d, 0xad, 0xcb,
			0x8e, 0x6a, 0x33, 0xf0, 0x7f, 0xaf, 0x22, 0x02,
			0x03, 0x49, 0x84, 0x80, 0xd9, 0xb9, 0x56, 0xdd,
			0xee, 0x62, 0x11, 0x92, 0x27, 0xc4, 0x39, 0x80,
		},
		20, /* salt length */
		/* V5 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA512 [6] */
	{
		/* Msg6 : 128 byte */
		{
			0x06, 0x8d, 0xc1, 0xfa, 0x44, 0x36, 0xe4, 0x7a,
			0x48, 0xdf, 0x07, 0xf8, 0x58, 0x48, 0x39, 0x54,
			0xaa, 0x64, 0xf5, 0x31, 0x24, 0x0b, 0x02, 0x48,
			0x66, 0xef, 0x98, 0x01, 0x0a, 0xd1, 0xc4, 0x44,
			0x2a, 0xf5, 0x0d, 0x8c, 0x23, 0xd3, 0x58, 0x3e,
			0x99, 0x0f, 0x09, 0x3a, 0xbc, 0xab, 0x6b, 0xaf,
			0xc9, 0x7c, 0x52, 0x33, 0xd3, 0xda, 0xff, 0x13,
			0xc3, 0x9c, 0x43, 0xe7, 0x9e, 0x44, 0xe8, 0x6a,
			0x06, 0x76, 0x4c, 0x89, 0x04, 0xaf, 0x4f, 0xba,
			0x04, 0x33, 0x6f, 0x8f, 0x21, 0x47, 0x32, 0x8b,
			0xa3, 0xa1, 0xc5, 0x34, 0xc6, 0x1d, 0xe2, 0x69,
			0xbe, 0xb1, 0xf6, 0xf6, 0xf7, 0xa3, 0x84, 0x66,
			0xa1, 0xf9, 0xc4, 0x19, 0x6c, 0x32, 0x91, 0x96,
			0x90, 0x33, 0x82, 0x21, 0x11, 0x84, 0x56, 0x91,
			0x41, 0xbc, 0x95, 0x5c, 0x86, 0x3a, 0x74, 0xf4,
			0x5d, 0x16, 0xf9, 0x56, 0x9f, 0x57, 0x61, 0xdf,
		},
		/* S6 : 192 byte */
		{
			0x23, 0x3d, 0x02, 0x2e, 0x93, 0x55, 0xfb, 0x35,
			0x24, 0x18, 0xbe, 0xbd, 0x52, 0x74, 0xbc, 0xdd,
			0xad, 0xde, 0xe2, 0xb5, 0xde, 0xc9, 0xae, 0xf9,
			0x17, 0x77, 0x97, 0xf0, 0x94, 0x13, 0xf6, 0x50,
			0xe5, 0x88, 0x7f, 0x07, 0x7c, 0x12, 0x60, 0x10,
			0x12, 0x00, 0x62, 0x9a, 0xb3, 0xa5, 0x18, 0xe6,
			0xab, 0x9b, 0xe2, 0x88, 0xec, 0x87, 0xe9, 0xca,
			0xee, 0x56, 0xbe, 0x28, 0xf2, 0x74, 0x17, 0xac,
			0x4a, 0x7d, 0x6a, 0xe9, 0xa6, 0x38, 0xcd, 0x4e,
			0xb8, 0xd4, 0xfd, 0x56, 0x63, 0x10, 0xd4, 0xa2,
			0x13, 0xaf, 0xb1, 0xcd, 0xbd, 0xdb, 0x06, 0x63,
			0x53, 0xf9, 0x74, 0xc6, 0x62, 0x50, 0xbd, 0x66,
			0x76, 0x8c, 0x3b, 0xc8, 0x2d, 0x05, 0xa2, 0xcd,
			0x1a, 0x62, 0x4b, 0x0d, 0xec, 0x84, 0x4f, 0xbd,
			0xe9, 0x86, 0x9b, 0x18, 0x6a, 0xfb, 0x5b, 0xab,
			0xf3, 0x63, 0x80, 0x66, 0x89, 0x4c, 0x4c, 0x84,
			0xd9, 0xac, 0x94, 0xfc, 0xa8, 0xa0, 0x4e, 0x8b,
			0x2f, 0xf3, 0x41, 0xba, 0x7a, 0x14, 0x23, 0x85,
			0x48, 0xa9, 0x50, 0xc0, 0xfe, 0x72, 0xce, 0xb8,
			0x77, 0xe0, 0xa3, 0xd4, 0x1f, 0x57, 0x81, 0x37,
			0x42, 0xc9, 0x3d, 0x91, 0xae, 0x89, 0x66, 0x0d,
			0xda, 0xb2, 0xff, 0xcd, 0x93, 0xeb, 0x59, 0xb5,
			0x30, 0x3f, 0xcc, 0x75, 0x4d, 0x0c, 0xb8, 0x78,
			0xec, 0xe9, 0x5c, 0x43, 0xc1, 0xef, 0xa7, 0x31,
		},
		20, /* salt length */
		/* V6 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA512 [7] */
	{
		/* Msg7 : 128 byte */
		{
			0x56, 0x40, 0x13, 0xd3, 0x17, 0x30, 0xe9, 0xa0,
			0x09, 0x97, 0x3f, 0x3d, 0x95, 0x06, 0xf3, 0x60,
			0xac, 0x80, 0x8a, 0xcc, 0x14, 0x81, 0x22, 0x77,
			0xff, 0x3e, 0xa7, 0xe8, 0xe2, 0x2f, 0x4a, 0xe4,
			0x84, 0xcb, 0x2f, 0x49, 0x56, 0x93, 0x66, 0x3a,
			0x02, 0x51, 0x1d, 0x7c, 0x46, 0xa2, 0x14, 0x20,
			0x03, 0xb2, 0x51, 0x63, 0x91, 0x47, 0x14, 0xd2,
			0x56, 0x01, 0x0d, 0xb2, 0x97, 0xe0, 0xcd, 0x9e,
			0x8d, 0x06, 0x7b, 0x72, 0xbc, 0xbe, 0xc8, 0x68,
			0x80, 0xbe, 0x24, 0x81, 0xe9, 0xa9, 0x33, 0x27,
			0xc8, 0xd8, 0x7a, 0x10, 0x0a, 0x5a, 0x5f, 0x65,
			0x45, 0x39, 0x50, 0x24, 0x91, 0xff, 0x42, 0xc3,
			0x99, 0x79, 0x5d, 0x16, 0xf2, 0xbb, 0xf5, 0x72,
			0xab, 0x64, 0xbd, 0x13, 0x25, 0x24, 0x37, 0xbb,
			0x24, 0x7b, 0x6f, 0x9c, 0x27, 0xc3, 0xe9, 0x78,
			0xf5, 0x70, 0xd8, 0x07, 0x79, 0x97, 0x90, 0x99,
		},
		/* S7 : 192 byte */
		{
			0x83, 0x9f, 0x62, 0xe1, 0x37, 0xbb, 0x53, 0x05,
			0x6f, 0x44, 0xcb, 0x4e, 0x52, 0x2d, 0x67, 0xc0,
			0x7e, 0x75, 0xdc, 0x8b, 0xc1, 0x37, 0x1a, 0xc7,
			0xb2, 0x12, 0xd2, 0x9d, 0x61, 0x52, 0x30, 0x2d,
			0x3e, 0x88, 0x03, 0x44, 0x26, 0x13, 0x6b, 0x17,
			0x26, 0x7b, 0x73, 0x15, 0xe6, 0x32, 0x52, 0xe5,
			0x54, 0xa2, 0x43, 0xf5, 0xd7, 0xb2, 0x2f, 0x89,
			0xa3, 0x15, 0xc4, 0x61, 0x54, 0x80, 0x3a, 0xf7,
			0xa2, 0xca, 0x2e, 0x99, 0xf5, 0x79, 0x58, 0xc4,
			0xe8, 0x19, 0x07, 0x5b, 0xda, 0x09, 0xc2, 0xac,
			0x6f, 0x00, 0x25, 0xc0, 0xbe, 0xec, 0x67, 0x68,
			0xf3, 0x9d, 0xcc, 0x7c, 0xf5, 0x91, 0x1e, 0x73,
			0x7c, 0x71, 0xd7, 0x3e, 0xbc, 0x10, 0x7a, 0x87,
			0xbc, 0x25, 0xd7, 0xad, 0xf2, 0xb7, 0x7e, 0x8c,
			0xa6, 0xa9, 0x4b, 0x43, 0xe8, 0x6a, 0x7e, 0xfa,
			0xfe, 0x10, 0x7d, 0x71, 0xd7, 0xe2, 0x5a, 0x40,
			0x51, 0xca, 0x09, 0x19, 0x43, 0x84, 0x43, 0xe8,
			0x23, 0x0b, 0xdb, 0x7b, 0x43, 0x1a, 0x2c, 0xf0,
			0xa8, 0x76, 0x5c, 0xd2, 0xf9, 0x77, 0x3e, 0x61,
			0x07, 0xd2, 0x90, 0x5e, 0xbd, 0xe4, 0xf7, 0x86,
			0x46, 0x6d, 0x7d, 0x49, 0x37, 0xaf, 0x03, 0xf9,
			0x4b, 0x7c, 0xc9, 0x57, 0xe6, 0x62, 0xb3, 0xba,
			0xdf, 0xad, 0xc6, 0xcf, 0xa4, 0xf5, 0xfc, 0xe7,
			0x24, 0xad, 0x73, 0x31, 0x31, 0x66, 0x5a, 0x47,
		},
		20, /* salt length */
		/* V7 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA512 [8] */
	{
		/* Msg8 : 128 byte */
		{
			0x95, 0x32, 0xda, 0x9a, 0xa5, 0x55, 0xbd, 0x4a,
			0xc6, 0x99, 0x40, 0x18, 0x99, 0xa9, 0xb0, 0x2c,
			0x71, 0x23, 0x82, 0x37, 0x10, 0x4b, 0x39, 0xbe,
			0xb1, 0x01, 0x8a, 0xb6, 0x4c, 0xf0, 0xbe, 0x50,
			0x15, 0x09, 0x59, 0x16, 0x45, 0x30, 0xf9, 0x37,
			0x1e, 0x34, 0x80, 0x1f, 0x29, 0x05, 0x75, 0x4b,
			0xc3, 0x21, 0xa8, 0x5c, 0xd7, 0x50, 0x15, 0x6a,
			0xed, 0x91, 0x0b, 0x9a, 0x64, 0x54, 0x8e, 0xf3,
			0xfb, 0xe9, 0xf9, 0x6d, 0x97, 0x39, 0xe8, 0x4b,
			0x40, 0xb4, 0x54, 0xab, 0x6c, 0x8a, 0x00, 0x5c,
			0x80, 0x1e, 0x14, 0xef, 0x94, 0xb8, 0x08, 0x11,
			0x76, 0x79, 0xc4, 0x18, 0xf2, 0x95, 0x06, 0xdb,
			0x51, 0xbc, 0x03, 0xc7, 0x20, 0xd9, 0x51, 0x2f,
			0x33, 0xff, 0x04, 0xe4, 0xe9, 0xa0, 0x18, 0x06,
			0xb0, 0x01, 0x0f, 0x19, 0xcc, 0xea, 0xda, 0x5b,
			0x55, 0xa2, 0xfd, 0x55, 0x7f, 0x1b, 0xef, 0xb1,
		},
		/* S8 : 192 byte */
		{
			0x16, 0x48, 0x9b, 0x0b, 0xc0, 0x22, 0xfe, 0x0a,
			0xc7, 0x76, 0xcb, 0xb3, 0x03, 0xfd, 0x71, 0x1b,
			0x99, 0xd8, 0x6f, 0xfd, 0x38, 0xd1, 0xde, 0xcc,
			0x36, 0x7b, 0x19, 0x49, 0x51, 0x12, 0xcf, 0x17,
			0x27, 0x90, 0xac, 0x79, 0x1f, 0xa6, 0x1b, 0xf9,
			0xb4, 0x58, 0x9e, 0x01, 0xa2, 0x56, 0x6e, 0xcd,
			0x52, 0x60, 0x90, 0x30, 0x59, 0x29, 0x09, 0xa2,
			0xd4, 0xa5, 0x16, 0xd1, 0xd2, 0x0f, 0x93, 0x70,
			0x3f, 0x67, 0xf2, 0xdd, 0x8f, 0xdc, 0x54, 0xdf,
			0x1c, 0x0e, 0x61, 0x10, 0xa7, 0x76, 0x09, 0xcf,
			0xb4, 0xf4, 0xaf, 0x4b, 0x5f, 0xf5, 0xe3, 0x47,
			0x40, 0xc3, 0x61, 0xd5, 0x6e, 0x7a, 0x7e, 0xfc,
			0xdc, 0x2a, 0x25, 0xcb, 0x06, 0xae, 0x14, 0x40,
			0x57, 0xdc, 0x6c, 0xbd, 0xd5, 0x74, 0x78, 0xd1,
			0x0e, 0xde, 0xdc, 0xe7, 0x81, 0x1b, 0xfc, 0xe0,
			0x61, 0x1c, 0x95, 0x54, 0x8b, 0x35, 0x18, 0x14,
			0x54, 0x63, 0x23, 0x61, 0xfa, 0xf2, 0xcf, 0xb9,
			0x29, 0x47, 0x66, 0x05, 0x30, 0x15, 0xb7, 0xee,
			0x27, 0xbc, 0x90, 0xd4, 0x19, 0xfe, 0xfe, 0x03,
			0x03, 0x17, 0xe2, 0x9f, 0x44, 0x27, 0x86, 0x38,
			0x06, 0xf8, 0xae, 0x6d, 0x21, 0x2d, 0x7e, 0x8e,
			0x56, 0x13, 0x6e, 0x6a, 0xe9, 0xf8, 0x11, 0xc6,
			0x40, 0x2d, 0xc9, 0x06, 0x91, 0xf1, 0x68, 0x11,
			0xcb, 0x78, 0x2e, 0xb6, 0xac, 0x87, 0x9b, 0xdb,
		},
		20, /* salt length */
		/* V8 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
	/* SHA512 [9] */
	{
		/* Msg9 : 128 byte */
		{
			0xcd, 0xe6, 0xb1, 0x42, 0x27, 0x5d, 0xfa, 0x94,
			0xe9, 0x30, 0x73, 0x93, 0xeb, 0x6b, 0x45, 0xd4,
			0x41, 0x5d, 0xd3, 0x3f, 0x04, 0x4b, 0x9d, 0x62,
			0x56, 0x66, 0x64, 0x0a, 0xa0, 0xf9, 0x90, 0x15,
			0x1e, 0xe7, 0xce, 0x82, 0x9e, 0x55, 0xfd, 0xca,
			0x84, 0xa4, 0x4b, 0x73, 0x12, 0xa2, 0x9b, 0xe2,
			0xe6, 0x01, 0x2b, 0x71, 0xc4, 0x08, 0x73, 0xc1,
			0x96, 0x88, 0x50, 0x52, 0xb1, 0x12, 0x61, 0x50,
			0x5a, 0x67, 0xb1, 0xb0, 0x89, 0x30, 0x97, 0x7c,
			0xed, 0xef, 0xdb, 0x6b, 0x2f, 0x36, 0x1a, 0xb5,
			0x7b, 0x17, 0x6c, 0x25, 0x3d, 0xdb, 0x43, 0x70,
			0x28, 0xf6, 0x97, 0xc5, 0x7d, 0x3b, 0x40, 0xa5,
			0x8a, 0x4d, 0xa3, 0xf5, 0x71, 0x56, 0x90, 0x52,
			0x2a, 0xfb, 0x6b, 0xa4, 0xcb, 0x8f, 0x8a, 0xf6,
			0x07, 0x86, 0xdf, 0x85, 0xf5, 0x2d, 0xd7, 0x16,
			0x13, 0x99, 0x81, 0x8d, 0x8b, 0xdd, 0xf3, 0xbc,
		},
		/* S9 : 192 byte */
		{
			0x04, 0xb9, 0x93, 0x3c, 0xb8, 0xde, 0x50, 0x69,
			0x09, 0x01, 0x66, 0x89, 0x1a, 0xe2, 0x08, 0xba,
			0x39, 0xd1, 0x5c, 0x84, 0x9e, 0x91, 0x0e, 0xfb,
			0xe5, 0x4c, 0x9e, 0x6c, 0x0c, 0x33, 0x52, 0x18,
			0x5e, 0x2c, 0x18, 0xf4, 0x06, 0xc1, 0x06, 0xad,
			0x4f, 0x8f, 0x07, 0x3d, 0x9c, 0xc6, 0x8c, 0x2f,
			0x1e, 0xd7, 0x2a, 0x42, 0xdd, 0xb1, 0xf4, 0x71,
			0x8a, 0xfe, 0xb5, 0x1f, 0xd8, 0x4c, 0xe3, 0xa1,
			0x24, 0x76, 0x01, 0xcc, 0x74, 0x80, 0xc9, 0x43,
			0x6c, 0x4b, 0x09, 0xa6, 0xab, 0x3b, 0xd4, 0xcb,
			0x22, 0x8b, 0xcc, 0x3a, 0xe9, 0x06, 0x3f, 0x38,
			0xe8, 0x75, 0x40, 0x9d, 0xf2, 0x95, 0x72, 0xaf,
			0xb0, 0xda, 0x0d, 0x39, 0x2f, 0xf3, 0xf0, 0x2a,
			0x21, 0x51, 0xd9, 0xbc, 0xbc, 0xcf, 0x8f, 0x51,
			0xa1, 0x47, 0x67, 0xfc, 0xe6, 0xa5, 0xc4, 0x59,
			0xcc, 0x2a, 0x7e, 0x41, 0xf5, 0xaf, 0x84, 0x92,
			0xa9, 0xe3, 0xc3, 0xf4, 0x52, 0x8f, 0x57, 0xb9,
			0xe6, 0x1c, 0x4e, 0xcf, 0xdc, 0x17, 0x55, 0xff,
			0x0a, 0x5e, 0xef, 0xf3, 0x26, 0x7e, 0xa0, 0x6b,
			0x5b, 0xc0, 0x94, 0x72, 0x50, 0x10, 0x56, 0x38,
			0xcc, 0xf2, 0xf0, 0x1a, 0x24, 0x36, 0xb6, 0x24,
			0x4a, 0x28, 0x38, 0xe6, 0x5a, 0x55, 0xbe, 0xc1,
			0x8f, 0x0b, 0x1f, 0x2c, 0x08, 0xcd, 0x95, 0x31,
			0x6a, 0xd8, 0x51, 0xf9, 0xc2, 0x90, 0x4d, 0x1c,
		},
		20, /* salt length */
		/* V9 : 20 byte */
		{
			0x6f, 0x28, 0x41, 0x16, 0x6a, 0x64, 0x47, 0x1d,
			0x4f, 0x0b, 0x8e, 0xd0, 0xdb, 0xb7, 0xdb, 0x32,
			0x16, 0x1d, 0xa1, 0x3b, 
		},
	},
};

typedef mod1536_t tv_t;


#include "siggenPSStest.c"
