/* siggen15_3_TruncatedSHAs_2048_testfc.c */
/*
 * Copyright (c) 2017 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/index.html.
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */

/*
 * This test vector was created based on SigGen15_186-3.txt from
 * https://csrc.nist.gov/CSRC/media/Projects/Cryptographic-Algorithm-Validation-Program/documents/dss/186-3rsatestvectors.zip
 *
 * The link to the archive file exists in the following URL:
 * https://csrc.nist.gov/projects/cryptographic-algorithm-validation-program/digital-signatures/
 */
/*
 * https://csrc.nist.gov/projects/cryptographic-algorithm-validation-program/digital-signatures/
 * https://csrc.nist.gov/CSRC/media/Projects/Cryptographic-Algorithm-Validation-Program/documents/dss/186-3rsatestvectors.zip
 * SigGen15_186-3_TruncatedSHAs.txt
 */ 
#include "siggen15test.h"

static const unsigned short sn1[] = {
	0xd39a, 0x426f, 0x8b81, 0xcd95, 0x4f3d, 0xf551, 0x2d6f, 0xcdb7,
	0x9645, 0x7c17, 0x2b6d, 0x5102, 0x47e4, 0x5ebe, 0xcd1e, 0x0f7e,
	0x8aa3, 0x253a, 0x6129, 0x3a7b, 0x7009, 0x4b70, 0xd65d, 0x7382,
	0x8719, 0xef6a, 0xaabb, 0xb24e, 0x083b, 0x943b, 0xe775, 0xb0bf,
	0x3b5a, 0x0dc8, 0x3884, 0x33de, 0x78e0, 0xc113, 0xef77, 0x63f7,
	0x67dd, 0xd154, 0x2bcb, 0xdd98, 0x4591, 0x9886, 0xce20, 0xe289,
	0x2275, 0x4af2, 0xa733, 0x204b, 0xce9b, 0x5bd5, 0x0140, 0xe18e,
	0x5ba9, 0x1e48, 0x00b5, 0x0ef3, 0x0ecd, 0x48b4, 0xecde, 0xd67a,
	0x2f7b, 0xe8bf, 0x7d7f, 0x1437, 0x8a8c, 0x9ba0, 0xe610, 0x3d02,
	0xf168, 0x5a33, 0x4e46, 0x7130, 0x33c8, 0x9908, 0xda2e, 0x9f8b,
	0xf72c, 0xb2a5, 0x2928, 0x1d4d, 0xc667, 0x99cc, 0x2a63, 0xc872,
	0xb6bd, 0x5ffc, 0x1fa9, 0xada2, 0x36e7, 0xf8d5, 0x796d, 0xd972,
	0x4e5e, 0x4cca, 0xdaf1, 0x60de, 0x7f2d, 0x69c8, 0x4009, 0xd31e,
	0x952a, 0xc808, 0xc89a, 0x784b, 0xe70c, 0xf60f, 0x4281, 0x1928,
	0xabde, 0xc6f8, 0x96a0, 0xfa5f, 0xb164, 0xf9f4, 0x298a, 0x5a88,
	0x31f6, 0x684d, 0xae31, 0xf2e7, 0x6146, 0xd6be, 0x14c3, 0xea7d,
};

static const unsigned short se1[] = {
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0010, 0x1957,
};

static const unsigned short sd1[] = {
	0x0570, 0x76fb, 0xab75, 0x8efb, 0xa294, 0x5f16, 0xd345, 0x6c21,
	0xdf4b, 0x7cfe, 0x1a8a, 0x762a, 0xf838, 0x9e42, 0xe0b6, 0x48f4,
	0xd452, 0xd8bd, 0xffdf, 0x2097, 0xf75b, 0xc661, 0xefe9, 0x39dd,
	0x99c1, 0x70c1, 0x672c, 0x9a0f, 0x21ad, 0x4503, 0x4733, 0x3fdc,
	0x52f3, 0x50d0, 0x2ca1, 0xe651, 0x6cdb, 0xee38, 0xd3eb, 0x56b1,
	0x5f3f, 0x062b, 0x0d4f, 0x0901, 0xed9a, 0x05a5, 0x6691, 0x7c5c,
	0x108b, 0x20e0, 0xda09, 0x1b8c, 0xa9da, 0x43b7, 0xb066, 0xd8c2,
	0x8d84, 0x9068, 0xf6eb, 0x803d, 0x8e84, 0xff24, 0x3172, 0xc258,
	0xcd7b, 0xd188, 0x58d2, 0x648d, 0xd7a5, 0x5a2c, 0xb4db, 0x3fea,
	0xf317, 0x1846, 0xe3e2, 0xc883, 0xf50a, 0x192b, 0xe5ab, 0x4c79,
	0xdd33, 0x0584, 0xadca, 0xe17f, 0x1458, 0xbcb2, 0xab43, 0xe392,
	0x9cbe, 0xf840, 0xe999, 0x9bf0, 0xeb56, 0x01e8, 0x8ff8, 0x758d,
	0xb564, 0xa756, 0x346d, 0x65d8, 0xc55f, 0x1b11, 0xb9b0, 0x92fc,
	0xa7f6, 0xb239, 0x4ebc, 0x3109, 0xb3d0, 0x2ec5, 0xa096, 0x7ea6,
	0x45d1, 0x27fe, 0x0fb9, 0xf9fa, 0x7163, 0x7ac6, 0xf0b9, 0x2671,
	0x809f, 0x4aad, 0x1278, 0xa6cb, 0x5e8a, 0x7247, 0xfe53, 0xafdf,
};

#define HAS_SHA512224_TESTVECTOR

#define HAS_SHA512256_TESTVECTOR

/* 10 elements */
static mod2048_t SHA512224[] = {
	/* SHA512224 [0] */
	{
		/* Msg0 : 128 byte */
		{
			0x2e, 0xd1, 0xa4, 0xa7, 0x18, 0x8b, 0x53, 0x46,
			0x78, 0xec, 0xe3, 0xb4, 0x0e, 0xcc, 0xa2, 0x9e,
			0x23, 0x59, 0xd2, 0xc8, 0xb5, 0xaf, 0xf1, 0x49,
			0xd4, 0xa9, 0x3e, 0xf8, 0x4c, 0xf6, 0x78, 0x22,
			0x84, 0x6f, 0xe9, 0x7e, 0xa6, 0xa7, 0xa3, 0x62,
			0x00, 0xc4, 0x0a, 0x36, 0xab, 0x8e, 0x92, 0x2a,
			0x6a, 0xc6, 0xca, 0x24, 0xd4, 0xb9, 0x9a, 0xfc,
			0xb6, 0x15, 0xc8, 0xec, 0xb3, 0xfa, 0xc1, 0x42,
			0x2d, 0x54, 0x97, 0x58, 0x69, 0x69, 0x46, 0xc6,
			0xed, 0xae, 0x3b, 0xd6, 0x2d, 0xdf, 0x17, 0x39,
			0x67, 0x4e, 0xb0, 0xf8, 0xcc, 0x7c, 0x58, 0xad,
			0xe0, 0xe6, 0x63, 0xf2, 0x23, 0x21, 0xe3, 0x1a,
			0xf1, 0x29, 0xb6, 0x1f, 0xa7, 0xf7, 0xc3, 0xdc,
			0x07, 0x51, 0x80, 0x7c, 0xde, 0xe6, 0xb8, 0x33,
			0xe3, 0x9a, 0x8b, 0x2c, 0xe3, 0x1f, 0xb6, 0xc2,
			0x1b, 0xc5, 0x14, 0xf2, 0xe6, 0x93, 0x65, 0x10,
		},
		/* S0 : 256 byte */
		{
			0xbb, 0x29, 0x69, 0xdf, 0x7e, 0xac, 0x0f, 0x17,
			0xe0, 0x79, 0x92, 0xc0, 0x0c, 0x8b, 0x56, 0x1d,
			0x1c, 0x21, 0x48, 0x2f, 0x04, 0x2a, 0x4f, 0xc9,
			0x5b, 0x73, 0x9a, 0xac, 0xe6, 0x29, 0xa1, 0x2f,
			0x60, 0x86, 0xe3, 0x99, 0xbf, 0xf9, 0xaa, 0x71,
			0x26, 0x82, 0x03, 0xc1, 0x65, 0x6d, 0xdf, 0xc8,
			0x90, 0x57, 0x0b, 0xf4, 0x9d, 0xc7, 0x5d, 0x8a,
			0x7b, 0xc5, 0x10, 0x41, 0x31, 0x35, 0xef, 0x93,
			0x14, 0x73, 0xb0, 0xba, 0x77, 0xaf, 0x4e, 0x56,
			0x91, 0x97, 0x04, 0x66, 0xbc, 0x2a, 0x5e, 0xf8,
			0x11, 0xb4, 0xeb, 0x94, 0x26, 0x91, 0x73, 0xbb,
			0x36, 0x5e, 0xd2, 0x86, 0x88, 0xc0, 0x07, 0x8a,
			0x11, 0xe0, 0x77, 0x6e, 0xd7, 0xf5, 0x39, 0x71,
			0x72, 0x09, 0x53, 0x60, 0x79, 0xdc, 0x7a, 0xf5,
			0x15, 0x38, 0x66, 0x98, 0xc1, 0xe5, 0x39, 0xdc,
			0xf0, 0xb3, 0xc0, 0x8e, 0x58, 0x4e, 0x3b, 0xef,
			0x98, 0x77, 0x02, 0xaa, 0x02, 0xe5, 0xab, 0x32,
			0x97, 0x25, 0x02, 0x6d, 0xcf, 0x3f, 0xe6, 0x41,
			0x93, 0xa4, 0xe2, 0x74, 0x51, 0xe5, 0xe7, 0x77,
			0x13, 0x90, 0x8f, 0x07, 0xc7, 0x42, 0xaf, 0x0a,
			0x25, 0x83, 0xa0, 0x4c, 0x1f, 0x1a, 0x0a, 0xc4,
			0xe9, 0xaf, 0x58, 0x78, 0xa9, 0xc8, 0xe5, 0x3a,
			0xc1, 0xeb, 0xa4, 0x69, 0xce, 0xef, 0x83, 0x6f,
			0x3f, 0x6e, 0xb9, 0xee, 0x26, 0x25, 0xfe, 0xaf,
			0x93, 0x39, 0x05, 0xc3, 0x08, 0xc2, 0x1a, 0xa7,
			0x5a, 0x76, 0xcd, 0xe1, 0xd8, 0xbc, 0x41, 0xcf,
			0x77, 0xbe, 0xee, 0xd6, 0x91, 0x9d, 0xd7, 0x5d,
			0x38, 0x34, 0xb3, 0x13, 0x5a, 0x78, 0x1c, 0xce,
			0x01, 0xa0, 0x4b, 0x46, 0x8f, 0x33, 0x9b, 0xbd,
			0x21, 0xc7, 0x4a, 0x32, 0x37, 0x93, 0xc8, 0xf4,
			0x39, 0xe6, 0xdf, 0x0f, 0x3d, 0xd4, 0x22, 0x6e,
			0x5b, 0xa8, 0xc7, 0x12, 0xb2, 0x9f, 0x7a, 0xcc,
		},
	},
	/* SHA512224 [1] */
	{
		/* Msg1 : 128 byte */
		{
			0x05, 0x53, 0x55, 0x01, 0x99, 0xe9, 0xdf, 0xb9,
			0xac, 0x42, 0x60, 0xd6, 0xb4, 0x4e, 0x13, 0x76,
			0xe7, 0xb9, 0x08, 0x3a, 0xf2, 0xca, 0x76, 0x4b,
			0xef, 0x8b, 0x52, 0x9b, 0x91, 0x2a, 0x20, 0x6e,
			0xa2, 0x9f, 0x0a, 0x18, 0xb0, 0x8f, 0x2f, 0x08,
			0x03, 0x70, 0x3d, 0x05, 0xd2, 0xef, 0x42, 0xb8,
			0xb6, 0x8e, 0xbf, 0x6b, 0x5e, 0x92, 0xff, 0x10,
			0x85, 0x1c, 0xa6, 0x85, 0x21, 0x96, 0x8d, 0x16,
			0xdd, 0x50, 0xcd, 0x44, 0xca, 0x6b, 0x1a, 0xc4,
			0x51, 0xf7, 0x53, 0xcb, 0x6d, 0x58, 0x56, 0x89,
			0x17, 0xee, 0x19, 0xf3, 0x01, 0xf5, 0xf7, 0xc6,
			0x86, 0xa9, 0x47, 0xc9, 0xe1, 0xae, 0x33, 0x52,
			0x9e, 0xb0, 0xc8, 0x0b, 0x4f, 0x47, 0x49, 0xf6,
			0x80, 0x1d, 0xc9, 0xaf, 0xed, 0x52, 0xf8, 0xf2,
			0xf2, 0x1f, 0x3e, 0x5c, 0x42, 0xba, 0x06, 0x76,
			0xdc, 0x7a, 0x5d, 0xef, 0x3b, 0x3c, 0xbb, 0x29,
		},
		/* S1 : 256 byte */
		{
			0x7c, 0xd3, 0x0a, 0x88, 0xee, 0x2d, 0xa9, 0x86,
			0xe7, 0x9b, 0x74, 0xa2, 0x3a, 0x18, 0x31, 0xe4,
			0xa9, 0x5f, 0x9c, 0xbe, 0x66, 0x5c, 0x9e, 0xe2,
			0xe8, 0x7b, 0x55, 0xdd, 0x13, 0xcc, 0x71, 0x79,
			0x13, 0x77, 0xc5, 0x32, 0xa5, 0x5a, 0x43, 0x7d,
			0xd4, 0xc4, 0x73, 0xae, 0xc3, 0x8b, 0xb0, 0x94,
			0xc8, 0x76, 0xf6, 0x7b, 0x62, 0xb0, 0x3d, 0x47,
			0x3c, 0xbf, 0x86, 0x8e, 0xb5, 0x6a, 0xdd, 0x83,
			0x98, 0x1c, 0xed, 0x4e, 0x4a, 0xac, 0x6d, 0xee,
			0xf6, 0x83, 0x53, 0x78, 0xe8, 0x91, 0x6a, 0x43,
			0x4b, 0x91, 0x19, 0xd5, 0xd8, 0x92, 0x04, 0xb8,
			0x58, 0x91, 0x38, 0x89, 0xa4, 0xa1, 0x68, 0x2c,
			0x71, 0x1b, 0xd1, 0xb9, 0x51, 0xd3, 0x54, 0x90,
			0x27, 0x58, 0xd0, 0xef, 0x78, 0xcf, 0xd6, 0x3b,
			0x6b, 0x45, 0xd7, 0xd5, 0x43, 0x3f, 0x3d, 0x4d,
			0xd5, 0x2e, 0x94, 0x5b, 0xe9, 0xd9, 0xd8, 0x6c,
			0x62, 0x05, 0x85, 0xdf, 0x35, 0x92, 0xa5, 0x1b,
			0x58, 0x55, 0xfa, 0x41, 0x2a, 0xce, 0x61, 0x31,
			0xc1, 0x4b, 0xe6, 0xec, 0xd7, 0x7f, 0x15, 0xab,
			0x7e, 0x77, 0xf5, 0x52, 0x55, 0xbd, 0x5a, 0xd2,
			0xed, 0xfd, 0xf8, 0xa1, 0x83, 0x0b, 0x4b, 0xe0,
			0x83, 0x6b, 0x21, 0xf8, 0x06, 0x92, 0x0c, 0x69,
			0x98, 0xcc, 0xc3, 0x26, 0x2b, 0x97, 0x1c, 0xd4,
			0xee, 0x0c, 0xa4, 0x8a, 0x60, 0xfb, 0x90, 0x60,
			0x6f, 0xa0, 0xc1, 0x6d, 0x71, 0x41, 0xa9, 0x2c,
			0xac, 0x3c, 0x3c, 0x56, 0x1d, 0x06, 0x73, 0xd7,
			0x00, 0xb0, 0x53, 0x9e, 0x8b, 0x51, 0x2d, 0x47,
			0x64, 0xe5, 0xbe, 0x5a, 0x9a, 0xb4, 0x1d, 0x29,
			0x5d, 0x1a, 0x1e, 0x80, 0xf3, 0x42, 0xa4, 0xae,
			0x2d, 0xf7, 0x5a, 0xc5, 0xdf, 0xc7, 0xd5, 0xf4,
			0x4d, 0x3e, 0x9b, 0xde, 0xe9, 0xcf, 0x25, 0xe7,
			0xd2, 0xf0, 0x4f, 0xc7, 0x07, 0xb9, 0x2c, 0xdf,
		},
	},
	/* SHA512224 [2] */
	{
		/* Msg2 : 128 byte */
		{
			0x63, 0xf2, 0xe1, 0x6f, 0x20, 0xaf, 0x0c, 0x03,
			0x66, 0x15, 0x6f, 0x5c, 0x16, 0x13, 0x8b, 0x07,
			0x5b, 0xb7, 0x87, 0x9f, 0x30, 0xa1, 0xd2, 0xe5,
			0x23, 0xb6, 0x0a, 0x13, 0x58, 0x19, 0x1d, 0x6e,
			0xd0, 0x57, 0xae, 0x1b, 0xeb, 0xe1, 0xba, 0x33,
			0x2c, 0xc0, 0x7b, 0x1a, 0x3d, 0x84, 0x8c, 0x0c,
			0x33, 0x7d, 0x4f, 0xf8, 0x12, 0x2e, 0x8c, 0x92,
			0x94, 0xff, 0x5a, 0xa4, 0x26, 0x32, 0x43, 0xa4,
			0x34, 0x18, 0xa3, 0x8c, 0xa6, 0x85, 0x51, 0xe6,
			0xab, 0x81, 0x81, 0x26, 0xb5, 0x40, 0xe9, 0x3d,
			0xc5, 0x55, 0x23, 0x6b, 0xe8, 0x22, 0x53, 0x55,
			0x01, 0x93, 0x09, 0x57, 0xca, 0x0c, 0x69, 0x1b,
			0x16, 0x9f, 0x89, 0x6b, 0x59, 0x83, 0x1a, 0x43,
			0x69, 0xc1, 0x4b, 0x2b, 0x86, 0x31, 0xea, 0xc3,
			0x99, 0xa5, 0xcc, 0xa0, 0xb9, 0x64, 0x70, 0x56,
			0xf3, 0xda, 0xdf, 0xd6, 0x4b, 0x8d, 0xd6, 0xfb,
		},
		/* S2 : 256 byte */
		{
			0x79, 0x6c, 0xba, 0x47, 0xcc, 0x49, 0x8f, 0x03,
			0xe7, 0x8a, 0xca, 0x4b, 0x59, 0x19, 0xb6, 0xf0,
			0xdf, 0x5e, 0xd2, 0x2e, 0x8d, 0x62, 0xb1, 0x12,
			0x4a, 0x66, 0x33, 0x03, 0x3d, 0xbc, 0xcd, 0x2a,
			0x54, 0xaa, 0x97, 0x21, 0xd0, 0x0a, 0x1e, 0x68,
			0x54, 0xc1, 0xfc, 0x34, 0x86, 0x86, 0xad, 0x5c,
			0xc8, 0x60, 0x55, 0xe0, 0x45, 0x4a, 0xb5, 0x53,
			0x65, 0xcd, 0x87, 0x1d, 0x1f, 0xb6, 0xbe, 0x55,
			0x75, 0xee, 0xec, 0xc1, 0x0f, 0x1b, 0x66, 0xe4,
			0xd4, 0xe4, 0x93, 0x0b, 0xca, 0xdc, 0xe6, 0xcd,
			0x2d, 0x8b, 0xd4, 0xaf, 0x1a, 0xbb, 0x2f, 0xf7,
			0xd9, 0x05, 0x47, 0x5e, 0x29, 0xe4, 0xe2, 0xee,
			0xfb, 0x71, 0xd6, 0xac, 0x7d, 0xa5, 0x9b, 0xa2,
			0xef, 0xdc, 0x8e, 0xa1, 0x6c, 0x2f, 0xe5, 0xd1,
			0x30, 0xfb, 0x6d, 0x00, 0x2a, 0x7e, 0xd8, 0x1e,
			0x88, 0xa2, 0x9c, 0x08, 0x01, 0x07, 0x66, 0xc7,
			0x4f, 0x19, 0x2c, 0x87, 0x41, 0xbf, 0x36, 0xf7,
			0x39, 0x19, 0x8b, 0xbc, 0xce, 0x1e, 0x44, 0xa8,
			0x6d, 0x09, 0x25, 0x1f, 0x87, 0x37, 0xb3, 0x08,
			0x9f, 0xe1, 0x45, 0xe1, 0x10, 0xbd, 0x2e, 0xd1,
			0x16, 0x63, 0x5d, 0x7a, 0x6e, 0xe0, 0x95, 0x90,
			0xa3, 0x90, 0xff, 0x45, 0x99, 0xdd, 0x08, 0xa5,
			0x09, 0x00, 0xf2, 0x83, 0xe2, 0xdd, 0x1c, 0x17,
			0x60, 0xbd, 0x9b, 0x0e, 0xb8, 0x60, 0x3f, 0xc1,
			0x7c, 0x6f, 0x8b, 0xb5, 0x8a, 0xed, 0xf9, 0x85,
			0xb5, 0xa5, 0x87, 0x84, 0xb1, 0xb0, 0x16, 0x2d,
			0x85, 0x32, 0x24, 0x48, 0x35, 0x09, 0x2a, 0xfe,
			0x4f, 0x64, 0x7c, 0xe3, 0x11, 0x0b, 0xeb, 0x93,
			0x41, 0x92, 0xc8, 0xfa, 0x80, 0xc2, 0x02, 0xe1,
			0x77, 0x75, 0x11, 0xf7, 0x47, 0x34, 0xd8, 0xac,
			0x13, 0x8c, 0x3d, 0x18, 0xa6, 0x05, 0xb4, 0xc7,
			0x25, 0x07, 0x57, 0x73, 0x8e, 0x2c, 0x86, 0xf8,
		},
	},
	/* SHA512224 [3] */
	{
		/* Msg3 : 128 byte */
		{
			0x4b, 0x94, 0xbe, 0x1d, 0x97, 0xd9, 0xb7, 0x1f,
			0x11, 0x2b, 0xbc, 0x5a, 0xbc, 0x55, 0xfe, 0x91,
			0x60, 0xca, 0xb6, 0x67, 0x26, 0xe6, 0x5c, 0xc4,
			0x62, 0x77, 0x1a, 0x7a, 0xb0, 0x7c, 0x80, 0x29,
			0x42, 0x2d, 0x79, 0x60, 0x78, 0x3b, 0x7e, 0x04,
			0xb1, 0x58, 0x09, 0xf6, 0x62, 0xfa, 0x4d, 0xf0,
			0x65, 0x5c, 0x24, 0xb0, 0x93, 0xc6, 0x49, 0x59,
			0x94, 0x0f, 0xc7, 0x16, 0xf6, 0x60, 0xb1, 0x00,
			0x7d, 0x3a, 0x14, 0x42, 0xba, 0xbb, 0x2a, 0x7a,
			0xdf, 0x1d, 0xd0, 0x63, 0xd2, 0x7f, 0x3a, 0xb2,
			0x80, 0xe8, 0xe6, 0x3d, 0x74, 0x89, 0xce, 0x62,
			0xa8, 0x42, 0xe2, 0xa7, 0x9b, 0x68, 0xb5, 0x9e,
			0xa3, 0xc6, 0x77, 0x0c, 0x85, 0xe1, 0x23, 0x49,
			0x43, 0x81, 0xf9, 0xea, 0x35, 0x6c, 0x2f, 0x9e,
			0x5b, 0x75, 0xe4, 0x56, 0xf2, 0xb5, 0x55, 0xa9,
			0x45, 0x19, 0x53, 0x76, 0xc6, 0x1d, 0xf5, 0xcb,
		},
		/* S3 : 256 byte */
		{
			0xac, 0x4d, 0xd1, 0x01, 0xf9, 0xd7, 0xaf, 0xc5,
			0x04, 0xda, 0x2d, 0x6f, 0x92, 0x0a, 0x4b, 0x00,
			0x75, 0xeb, 0x04, 0x60, 0x4b, 0xab, 0x6f, 0xb9,
			0x60, 0x2e, 0xed, 0x00, 0x6b, 0x3c, 0xb1, 0x9e,
			0xc1, 0x4f, 0xf9, 0xec, 0xd1, 0x75, 0xdf, 0x7c,
			0xed, 0x0a, 0x06, 0xf0, 0xc2, 0xb6, 0x27, 0x0b,
			0x9f, 0xb0, 0x22, 0xeb, 0x49, 0x50, 0xc5, 0x70,
			0xf6, 0x36, 0xdb, 0xe1, 0x34, 0x07, 0x0c, 0x8b,
			0x2b, 0x3b, 0x4a, 0x3f, 0x47, 0xf8, 0x43, 0xc3,
			0xa9, 0xef, 0x27, 0x80, 0x6b, 0x5c, 0xe8, 0xd8,
			0x57, 0x80, 0x74, 0x91, 0x77, 0x11, 0x34, 0xca,
			0x4d, 0xf4, 0x2b, 0x68, 0xc5, 0x1d, 0x21, 0x81,
			0xc7, 0x88, 0xab, 0x78, 0x91, 0x6b, 0x29, 0x6b,
			0x75, 0x79, 0x6b, 0x7b, 0x8e, 0x65, 0x48, 0x7e,
			0x96, 0x2f, 0xca, 0x3f, 0x1e, 0xf9, 0x41, 0x74,
			0x8c, 0xaf, 0xec, 0xb1, 0x84, 0xcd, 0x1c, 0xe5,
			0xe0, 0xa7, 0xa9, 0xaf, 0x1c, 0x4c, 0x11, 0xb0,
			0x8b, 0x0f, 0x78, 0xf2, 0x87, 0xc9, 0xe4, 0x22,
			0x76, 0x21, 0xda, 0x2d, 0x50, 0x40, 0x42, 0x46,
			0x45, 0xc9, 0x61, 0x3b, 0x06, 0x30, 0xa2, 0x39,
			0xcc, 0x46, 0x97, 0x7e, 0x9b, 0xcc, 0x92, 0x09,
			0x9d, 0x47, 0x1a, 0x69, 0x69, 0x55, 0xb9, 0x39,
			0x83, 0x14, 0x54, 0xb4, 0x89, 0x6c, 0xf0, 0xe4,
			0x53, 0xd2, 0xda, 0xaf, 0xb5, 0x67, 0x93, 0xad,
			0xda, 0x28, 0xfd, 0x56, 0x67, 0xe7, 0x44, 0x8f,
			0x59, 0x4a, 0x4c, 0x7c, 0x08, 0x0f, 0x27, 0x07,
			0xdc, 0xff, 0xce, 0xb7, 0x39, 0xe4, 0x31, 0xe0,
			0x30, 0x9f, 0xdc, 0xdc, 0x61, 0x29, 0x16, 0x7c,
			0x08, 0x3a, 0xc2, 0x23, 0xd1, 0xd5, 0x49, 0x0f,
			0xe6, 0xc9, 0xf6, 0xb4, 0x63, 0x38, 0xb6, 0x48,
			0x25, 0x89, 0x85, 0x0c, 0xc5, 0x81, 0x57, 0x77,
			0x09, 0x9d, 0x48, 0x43, 0x21, 0x55, 0xd3, 0x9c,
		},
	},
	/* SHA512224 [4] */
	{
		/* Msg4 : 128 byte */
		{
			0xed, 0xa3, 0x0c, 0xa6, 0x0e, 0x21, 0x32, 0x91,
			0x72, 0xc7, 0x0e, 0xd5, 0x5f, 0x11, 0x3a, 0x71,
			0x6b, 0x91, 0x12, 0x22, 0xec, 0x91, 0xc6, 0x29,
			0xb0, 0xfa, 0xad, 0x4e, 0xee, 0x75, 0xdc, 0x25,
			0x7d, 0xcf, 0xf8, 0x90, 0x44, 0xa2, 0x48, 0x85,
			0xf2, 0x32, 0x0e, 0x11, 0xef, 0x95, 0x18, 0x9d,
			0x92, 0x17, 0x92, 0x71, 0x94, 0xdc, 0x1e, 0x76,
			0xc4, 0xc7, 0x27, 0x40, 0xfd, 0x9b, 0x71, 0x4b,
			0x55, 0x60, 0xf5, 0x85, 0x98, 0x09, 0xed, 0x0d,
			0xf5, 0x53, 0x2b, 0x3b, 0xf6, 0xf0, 0xae, 0xe0,
			0xb6, 0xe5, 0x77, 0xcf, 0x4e, 0x31, 0x99, 0x9c,
			0x90, 0xaf, 0x90, 0xa3, 0xf8, 0x3d, 0xd3, 0x4c,
			0xdf, 0x1e, 0xad, 0x8e, 0xf2, 0x9d, 0x48, 0xb2,
			0xe3, 0xf3, 0x0b, 0x5a, 0x5e, 0x6b, 0x25, 0xc1,
			0x3f, 0xc4, 0x6a, 0x44, 0x02, 0xd7, 0x5f, 0x22,
			0x7a, 0x7a, 0x90, 0x80, 0xc6, 0xa3, 0x2a, 0xb0,
		},
		/* S4 : 256 byte */
		{
			0x5f, 0x7c, 0x83, 0x26, 0xb4, 0x3a, 0x40, 0x2c,
			0x85, 0x93, 0xc4, 0x97, 0x2a, 0x12, 0x7b, 0x65,
			0x73, 0xfe, 0x9f, 0x48, 0x2c, 0xcd, 0xa7, 0x4c,
			0x47, 0x69, 0x81, 0xba, 0x32, 0x9d, 0xa4, 0x5d,
			0x4d, 0x4c, 0x5b, 0x1b, 0x50, 0x30, 0xf6, 0xb9,
			0xbf, 0xee, 0x4f, 0x5d, 0x8b, 0xaa, 0xd7, 0xc0,
			0x9f, 0x0e, 0x25, 0xb6, 0x9b, 0x93, 0x8f, 0xb6,
			0x15, 0x19, 0xee, 0x37, 0xfe, 0x8f, 0x3b, 0x9a,
			0xc2, 0x2b, 0x8d, 0xc3, 0x4f, 0xa3, 0x0d, 0x02,
			0xd5, 0xce, 0x94, 0x2d, 0xde, 0xf0, 0xbb, 0xdc,
			0x0d, 0x1a, 0x34, 0x0c, 0xa0, 0x6d, 0x04, 0x33,
			0xff, 0x31, 0x9e, 0xed, 0x59, 0x63, 0xc0, 0xe6,
			0x47, 0xac, 0xfd, 0xb7, 0x72, 0x62, 0x3e, 0x74,
			0x33, 0x34, 0xba, 0x25, 0x14, 0xdc, 0x67, 0x09,
			0x5c, 0xb4, 0xc3, 0xde, 0xd5, 0xea, 0x02, 0x36,
			0xac, 0xe1, 0x10, 0x4c, 0xb9, 0x09, 0x2b, 0x9b,
			0xdd, 0x1d, 0xc9, 0xe7, 0x30, 0xef, 0x5d, 0x2f,
			0x8b, 0x2a, 0x34, 0x73, 0x5d, 0x33, 0xca, 0x86,
			0xb5, 0x7f, 0xff, 0x53, 0x40, 0xe0, 0xe7, 0xef,
			0x46, 0x93, 0xe6, 0xcb, 0x0c, 0x17, 0x8b, 0x26,
			0x52, 0x4e, 0x25, 0x03, 0x76, 0xf7, 0xeb, 0x0a,
			0x52, 0xc3, 0x38, 0x91, 0xf7, 0xe1, 0x9a, 0xae,
			0x2b, 0x26, 0x47, 0xf5, 0x10, 0x46, 0x06, 0xb7,
			0xf6, 0x63, 0x8c, 0x07, 0x82, 0xf6, 0xda, 0xef,
			0x81, 0x86, 0xe2, 0x2d, 0x35, 0xde, 0x93, 0x29,
			0x44, 0x7e, 0xaf, 0x4a, 0x61, 0xe8, 0x41, 0x1e,
			0xdc, 0xfa, 0xa1, 0x9c, 0x2d, 0x39, 0x33, 0x26,
			0x71, 0xba, 0x40, 0x2b, 0x96, 0xe1, 0x76, 0x90,
			0x01, 0x27, 0x8a, 0xa1, 0x21, 0x85, 0x89, 0xb1,
			0x5b, 0x6c, 0xb1, 0x54, 0xe6, 0x28, 0x3b, 0x43,
			0xe2, 0x53, 0x7d, 0xb3, 0x7a, 0x80, 0x80, 0x58,
			0x3b, 0x09, 0xa4, 0x78, 0x8a, 0x5c, 0xbb, 0x7e,
		},
	},
	/* SHA512224 [5] */
	{
		/* Msg5 : 128 byte */
		{
			0x02, 0x19, 0xc1, 0xb2, 0x0f, 0x98, 0x8c, 0xb5,
			0x1c, 0x78, 0x1e, 0xa9, 0x82, 0xb5, 0x52, 0x8c,
			0xa1, 0x48, 0x10, 0x36, 0x3a, 0xf7, 0xce, 0xd3,
			0x1a, 0x71, 0x56, 0x96, 0xf9, 0x9a, 0xca, 0xac,
			0xa1, 0x24, 0xe6, 0x6f, 0x53, 0x5f, 0x86, 0xdd,
			0x66, 0x52, 0x68, 0x48, 0x31, 0x0a, 0x32, 0x4e,
			0x2b, 0x32, 0xb7, 0x0c, 0x51, 0xe4, 0x76, 0x8f,
			0xc8, 0xbf, 0x63, 0x8b, 0xc4, 0x3a, 0xeb, 0x50,
			0xa8, 0x37, 0x32, 0xf9, 0x6f, 0xdc, 0x9f, 0xe7,
			0x4a, 0x9e, 0x9a, 0x6e, 0x8a, 0x9e, 0x94, 0xcd,
			0xc1, 0x39, 0x48, 0x64, 0x24, 0xda, 0x41, 0x21,
			0x34, 0x13, 0x9d, 0x3c, 0x9e, 0xed, 0x10, 0x24,
			0x5f, 0x7c, 0x2c, 0xb9, 0x2b, 0xb6, 0xdf, 0xbb,
			0x10, 0x85, 0x3d, 0x82, 0x57, 0x1a, 0x7f, 0xf0,
			0xab, 0x85, 0x4c, 0xa5, 0x7d, 0x82, 0x38, 0x71,
			0xa6, 0x96, 0x8b, 0x0f, 0x4e, 0x5b, 0x43, 0x10,
		},
		/* S5 : 256 byte */
		{
			0x85, 0x8b, 0x91, 0xcc, 0x53, 0x41, 0x1d, 0xbe,
			0xd6, 0x48, 0x3f, 0xd9, 0x04, 0xab, 0x75, 0x82,
			0x0f, 0x8c, 0x8c, 0x95, 0x19, 0x29, 0x7c, 0x47,
			0x24, 0x38, 0x49, 0x2a, 0x2b, 0xda, 0x44, 0x0a,
			0xa6, 0xae, 0x35, 0xdc, 0xdf, 0xdc, 0xef, 0xd2,
			0x66, 0x41, 0xa8, 0x5f, 0x33, 0x54, 0x0e, 0x08,
			0x80, 0xda, 0x32, 0x3f, 0x09, 0xaf, 0x87, 0x87,
			0xcd, 0xf5, 0xe1, 0x60, 0xe7, 0x93, 0xde, 0x12,
			0x78, 0x82, 0xed, 0xeb, 0x1e, 0xb0, 0x45, 0xf2,
			0x91, 0x46, 0x61, 0x6c, 0xda, 0xd6, 0x22, 0xab,
			0xd1, 0x83, 0xb6, 0x0c, 0x05, 0x1b, 0x54, 0xad,
			0xf8, 0xfa, 0x20, 0x72, 0x6f, 0x4e, 0x88, 0xcc,
			0x54, 0xc0, 0xbd, 0x97, 0x23, 0xd3, 0x55, 0x3e,
			0xb7, 0xd0, 0x68, 0x7c, 0xe0, 0xfb, 0xc4, 0x3e,
			0x53, 0xe2, 0xe8, 0xee, 0xba, 0x00, 0x9b, 0x75,
			0x45, 0xe9, 0x7d, 0xe3, 0xa4, 0x57, 0xa8, 0xe7,
			0x51, 0x6d, 0x3d, 0x5a, 0xc4, 0xf1, 0x8a, 0x98,
			0xcf, 0x67, 0x8e, 0x07, 0x6d, 0x3a, 0x8e, 0x36,
			0x44, 0x91, 0x9a, 0xfe, 0xbc, 0x2a, 0x78, 0x55,
			0x67, 0xab, 0xec, 0x9f, 0x8d, 0xe5, 0x4e, 0x5b,
			0xa0, 0x51, 0x62, 0x0a, 0x70, 0x9d, 0x2b, 0xfd,
			0xdf, 0x06, 0x79, 0x66, 0x6a, 0xe1, 0x7b, 0x1c,
			0xb6, 0xd7, 0xcd, 0xc5, 0x16, 0x47, 0x28, 0xd2,
			0xd7, 0x7a, 0x70, 0x13, 0x39, 0x2b, 0x41, 0x8c,
			0x0e, 0x87, 0xa4, 0xa8, 0x9d, 0x39, 0x6e, 0xa9,
			0x55, 0xcb, 0xc3, 0x47, 0x36, 0x5f, 0x67, 0xa5,
			0xe7, 0x11, 0x50, 0x4f, 0xbe, 0x49, 0x97, 0x15,
			0xff, 0x07, 0x64, 0xfe, 0xb7, 0x5d, 0xc0, 0x95,
			0x6e, 0xac, 0xd9, 0x64, 0xad, 0x41, 0xd3, 0x99,
			0xbf, 0x17, 0x82, 0x5a, 0x2f, 0x4c, 0x33, 0xb7,
			0x10, 0x78, 0x39, 0x03, 0x36, 0x7d, 0x3f, 0x50,
			0x99, 0x4e, 0x3e, 0xeb, 0xc6, 0x34, 0xca, 0xf0,
		},
	},
	/* SHA512224 [6] */
	{
		/* Msg6 : 128 byte */
		{
			0x8b, 0xf4, 0xa1, 0x51, 0xce, 0x9d, 0x8b, 0x24,
			0xdc, 0x1a, 0x65, 0xe0, 0x06, 0xc0, 0x40, 0x24,
			0xff, 0xcb, 0x7c, 0x9d, 0x4c, 0xfd, 0xde, 0xce,
			0xf6, 0x88, 0xe2, 0x10, 0x82, 0x2e, 0x53, 0xd7,
			0x22, 0xa7, 0x18, 0x38, 0x2d, 0x43, 0x51, 0xa8,
			0xcd, 0xd0, 0xa3, 0x07, 0xf8, 0xbe, 0xcf, 0xdd,
			0xa1, 0x81, 0x8a, 0xe3, 0x2f, 0x37, 0x89, 0xc5,
			0x2e, 0x8b, 0xdb, 0x26, 0x44, 0xd9, 0x7b, 0xe4,
			0x67, 0x93, 0x26, 0x9e, 0x4e, 0xe3, 0x6a, 0x74,
			0x25, 0x91, 0x00, 0x0e, 0x85, 0x28, 0x5b, 0xe0,
			0xa3, 0x54, 0x81, 0xac, 0xc8, 0x8f, 0x1a, 0x48,
			0x01, 0xfc, 0xc6, 0xa1, 0x17, 0x93, 0xb4, 0x00,
			0xc1, 0x7f, 0x71, 0x8c, 0x19, 0xc4, 0xfd, 0x11,
			0x4d, 0x25, 0x24, 0xff, 0x97, 0x45, 0x0b, 0xb6,
			0x6f, 0x0c, 0x0a, 0x00, 0xff, 0x4c, 0xb9, 0xdf,
			0xd7, 0xa5, 0x4e, 0x8a, 0xe2, 0xa6, 0x26, 0xb2,
		},
		/* S6 : 256 byte */
		{
			0x2d, 0xa9, 0x85, 0xad, 0xd2, 0x12, 0x33, 0x56,
			0xdb, 0xac, 0x7b, 0x67, 0x31, 0x98, 0xce, 0xdf,
			0x49, 0x9d, 0x7f, 0x0f, 0xd0, 0xdb, 0x13, 0xdf,
			0xd4, 0xe5, 0x6f, 0xfe, 0xe3, 0xf2, 0x67, 0xd8,
			0x2e, 0x0c, 0x4d, 0xc0, 0xe6, 0x46, 0x96, 0x81,
			0x72, 0x55, 0xb8, 0xdc, 0x6d, 0xb3, 0x36, 0xef,
			0x0b, 0xe6, 0xa1, 0x70, 0xdc, 0x30, 0xad, 0xa0,
			0x54, 0x66, 0xed, 0xef, 0xc0, 0x4f, 0x5e, 0x36,
			0xaf, 0xe1, 0x44, 0xde, 0xbc, 0xe1, 0x4b, 0xe4,
			0x50, 0x0b, 0xfb, 0xf8, 0x76, 0x19, 0xc0, 0x96,
			0x82, 0x83, 0xb2, 0xd2, 0xe4, 0xb8, 0x06, 0x8f,
			0x10, 0xdb, 0x18, 0xb6, 0x46, 0x68, 0xd1, 0xd0,
			0x34, 0x5b, 0xef, 0xac, 0x54, 0x39, 0x71, 0xa2,
			0xc2, 0xfa, 0x9f, 0x1a, 0x41, 0xfc, 0x2d, 0xbf,
			0x6a, 0x4a, 0xb0, 0xf6, 0x49, 0xb6, 0xc6, 0x39,
			0xaf, 0x54, 0xb5, 0x2a, 0x39, 0xd7, 0xd1, 0xaf,
			0x0d, 0xa1, 0x35, 0xe0, 0x41, 0x4a, 0xe8, 0x9a,
			0x1c, 0xcc, 0xb3, 0xa9, 0x44, 0xa9, 0x9a, 0x71,
			0x9e, 0x4f, 0xa6, 0x46, 0x17, 0x57, 0xe0, 0xd1,
			0xae, 0x26, 0xf5, 0x51, 0xa9, 0x33, 0x7c, 0x55,
			0x74, 0x35, 0x83, 0x2b, 0x30, 0xa3, 0xa4, 0x2d,
			0xaf, 0xdb, 0xd4, 0x32, 0x94, 0xd3, 0xae, 0xaf,
			0x52, 0xe7, 0x08, 0x6e, 0xc8, 0xe4, 0x75, 0x09,
			0xe0, 0xa2, 0x81, 0x20, 0x7a, 0x3d, 0x49, 0x80,
			0x24, 0x0d, 0x2c, 0x11, 0xa5, 0xa5, 0x77, 0xde,
			0xe6, 0xe8, 0xfd, 0x61, 0xb9, 0xb9, 0x0e, 0x91,
			0xc4, 0xbc, 0x8f, 0x51, 0x57, 0xd0, 0x04, 0xd5,
			0xe4, 0xcf, 0x6c, 0x42, 0xc2, 0xdd, 0x8b, 0xfa,
			0x25, 0x37, 0x42, 0xf2, 0x7d, 0x36, 0xd7, 0x09,
			0xcb, 0x23, 0x82, 0xe5, 0x41, 0x03, 0xd9, 0x11,
			0xba, 0x92, 0x30, 0xe4, 0xe3, 0x48, 0xc8, 0x22,
			0xf9, 0x46, 0x85, 0x25, 0xd4, 0x6a, 0xbb, 0x5a,
		},
	},
	/* SHA512224 [7] */
	{
		/* Msg7 : 128 byte */
		{
			0xf1, 0xde, 0x99, 0x14, 0x10, 0x84, 0xe4, 0xbb,
			0xbd, 0xd1, 0x3b, 0x3c, 0xe8, 0x8c, 0x97, 0xbd,
			0xec, 0x31, 0xd9, 0xa8, 0x59, 0x9f, 0xb0, 0x00,
			0xf6, 0x11, 0xbc, 0xf6, 0x06, 0x4f, 0xf4, 0xb7,
			0xcb, 0x26, 0x45, 0x89, 0x49, 0x15, 0x7b, 0x16,
			0x4c, 0x49, 0x65, 0x07, 0xac, 0xcc, 0x34, 0xd5,
			0xd0, 0xf9, 0x25, 0xdc, 0x71, 0x33, 0x60, 0xb2,
			0xa0, 0xd6, 0x1f, 0xb6, 0x0b, 0x6e, 0x12, 0xec,
			0x7c, 0x27, 0x03, 0x08, 0xa2, 0x85, 0xb6, 0xc8,
			0x14, 0x55, 0x13, 0x87, 0x93, 0xe4, 0x86, 0x10,
			0x8f, 0x6e, 0xa7, 0xb0, 0xed, 0xd9, 0x16, 0x8f,
			0x08, 0xa3, 0xa9, 0x3f, 0xf6, 0x1a, 0xca, 0x96,
			0x0c, 0xcb, 0x1a, 0xb9, 0xa4, 0x3c, 0x5b, 0x7a,
			0x1d, 0xde, 0x8c, 0xe4, 0x24, 0x3d, 0x55, 0x13,
			0x32, 0x7a, 0xa6, 0x4a, 0x56, 0xfb, 0x9c, 0x3f,
			0x35, 0x61, 0xa4, 0xb9, 0x4f, 0xba, 0xe2, 0x5d,
		},
		/* S7 : 256 byte */
		{
			0xc6, 0x20, 0x10, 0x50, 0xe6, 0x2d, 0x28, 0x50,
			0x0c, 0xce, 0x52, 0xaa, 0xeb, 0xde, 0xbf, 0x30,
			0xa0, 0x08, 0xc6, 0xf4, 0x91, 0x71, 0x5d, 0x75,
			0xcd, 0x60, 0xa3, 0xe9, 0xb5, 0x23, 0x0e, 0x88,
			0xe9, 0x02, 0x12, 0x0e, 0x53, 0x6f, 0xa2, 0x69,
			0xb3, 0x91, 0xe8, 0x24, 0xf2, 0x62, 0x45, 0x75,
			0x29, 0xe7, 0x44, 0xf1, 0x3e, 0x09, 0x8e, 0x8c,
			0x43, 0x83, 0x2d, 0xc1, 0xdb, 0x14, 0x32, 0x23,
			0x5b, 0x58, 0xd8, 0x8f, 0xc3, 0x5e, 0xdb, 0x4c,
			0x5d, 0xe8, 0x85, 0x4d, 0x21, 0x98, 0xa7, 0x08,
			0xdc, 0xdd, 0x27, 0x4f, 0x26, 0x7d, 0x40, 0x07,
			0x91, 0x69, 0xb2, 0x9b, 0x78, 0xed, 0xc9, 0x69,
			0x46, 0x2f, 0xc6, 0x23, 0xcc, 0x04, 0x26, 0x9f,
			0x6e, 0xef, 0x15, 0xb1, 0xe6, 0xff, 0xfd, 0xa0,
			0x9d, 0x61, 0x8e, 0xba, 0x04, 0x51, 0x23, 0x71,
			0xa8, 0x55, 0x22, 0x5a, 0xe5, 0xcb, 0x95, 0xb3,
			0xad, 0x45, 0x53, 0x73, 0xba, 0x27, 0x34, 0x87,
			0x9e, 0xf6, 0xe7, 0x11, 0xc3, 0xcc, 0x7c, 0xda,
			0xd9, 0xb1, 0x07, 0xbe, 0xd3, 0x85, 0xa2, 0x91,
			0x24, 0x30, 0x7e, 0x8e, 0x3b, 0x2b, 0xc5, 0x06,
			0x92, 0x3f, 0x08, 0x80, 0x24, 0x46, 0xd1, 0xc0,
			0xe6, 0xd9, 0x12, 0x08, 0xb5, 0x24, 0x2f, 0x20,
			0xed, 0x26, 0x37, 0xcd, 0x47, 0xa2, 0x0f, 0x7e,
			0x18, 0x39, 0xde, 0x8f, 0xb7, 0x71, 0x09, 0x46,
			0x7f, 0x4c, 0xfd, 0x6e, 0x04, 0x08, 0x0d, 0x5d,
			0x8f, 0xbc, 0xf2, 0xc3, 0xba, 0x7e, 0x73, 0x24,
			0xc2, 0xd2, 0x6d, 0xed, 0x80, 0xb9, 0x0b, 0x05,
			0x3d, 0x8b, 0x43, 0x18, 0x79, 0xab, 0x73, 0xfc,
			0x58, 0x7c, 0x03, 0x83, 0xf5, 0x9a, 0xd7, 0x38,
			0x2f, 0xc2, 0x05, 0x89, 0xa7, 0x40, 0xd1, 0x39,
			0xb8, 0xb6, 0x0a, 0xeb, 0xdd, 0xae, 0xd1, 0x86,
			0x6a, 0x6c, 0x47, 0x78, 0x82, 0x07, 0xb7, 0x82,
		},
	},
	/* SHA512224 [8] */
	{
		/* Msg8 : 128 byte */
		{
			0xda, 0xa7, 0xf3, 0x2a, 0xa2, 0x97, 0x90, 0x4a,
			0x9c, 0xd2, 0x9e, 0x24, 0x43, 0x7e, 0xfa, 0x2f,
			0x02, 0xe6, 0x11, 0x39, 0x3c, 0x73, 0xfe, 0xfd,
			0x8f, 0xd8, 0xf2, 0xf7, 0x5a, 0x8c, 0xd9, 0x77,
			0x7c, 0x7d, 0x3a, 0xf5, 0x5f, 0x03, 0x5f, 0xa4,
			0x36, 0x12, 0xb7, 0x49, 0x82, 0xb5, 0x78, 0x4e,
			0xdb, 0xb7, 0x88, 0x12, 0xed, 0xa3, 0x9e, 0x84,
			0xc1, 0xf0, 0xa5, 0xf0, 0x3e, 0x75, 0x61, 0x19,
			0xef, 0x23, 0x54, 0x87, 0x06, 0xf2, 0xe3, 0x22,
			0xa1, 0x1c, 0xb5, 0x00, 0x4d, 0x8a, 0x5c, 0x7c,
			0xc8, 0x8b, 0x37, 0x88, 0x0c, 0xcc, 0x96, 0x44,
			0x88, 0x85, 0x20, 0xcf, 0xb1, 0xf0, 0x72, 0x5c,
			0xb9, 0xff, 0x09, 0x89, 0x9e, 0x4e, 0x62, 0xed,
			0x67, 0x57, 0x5f, 0xf0, 0xab, 0xe5, 0xed, 0xe0,
			0x52, 0xcb, 0xe4, 0x41, 0x9f, 0xd5, 0x2f, 0x64,
			0x6f, 0xff, 0x2c, 0x3b, 0xbb, 0xe5, 0x55, 0x6b,
		},
		/* S8 : 256 byte */
		{
			0x1a, 0x38, 0xbf, 0x4f, 0xdb, 0x86, 0xd3, 0x83,
			0x8b, 0x7e, 0xc4, 0x93, 0x93, 0x0b, 0x88, 0x33,
			0xa6, 0x5a, 0xee, 0xc2, 0xcf, 0xf0, 0x22, 0xf2,
			0x4c, 0xbd, 0xce, 0xf0, 0x68, 0x7e, 0x00, 0x04,
			0x3d, 0x81, 0x5b, 0xb6, 0x80, 0xa3, 0x94, 0xbb,
			0x64, 0x92, 0x2a, 0x97, 0xf9, 0x2b, 0x90, 0x8a,
			0x02, 0x86, 0x98, 0xda, 0xc2, 0x33, 0x21, 0x98,
			0x01, 0xcb, 0x35, 0x34, 0x06, 0xb5, 0xdb, 0xe6,
			0x38, 0xd0, 0xe0, 0x38, 0x65, 0x91, 0x69, 0x05,
			0xb1, 0x24, 0xb8, 0x8c, 0x58, 0xdd, 0x34, 0x9b,
			0x7c, 0xae, 0x77, 0x96, 0x4a, 0x54, 0xce, 0x01,
			0x9e, 0x9f, 0x98, 0xcf, 0x3f, 0xc4, 0x8f, 0x9f,
			0x73, 0x5b, 0x28, 0xd4, 0xac, 0x47, 0x1a, 0x42,
			0x38, 0x51, 0xe1, 0x3c, 0xdd, 0xc3, 0x77, 0x99,
			0x7b, 0x33, 0x33, 0x7f, 0x04, 0x96, 0x72, 0x0b,
			0x3b, 0xcc, 0x62, 0x8f, 0xf3, 0x3d, 0x1f, 0x71,
			0x0b, 0x68, 0x80, 0xf1, 0x99, 0x57, 0xc1, 0x44,
			0x74, 0x8d, 0x0c, 0x18, 0x9a, 0x9c, 0x35, 0x02,
			0x69, 0x7c, 0x0f, 0x06, 0xf5, 0xe2, 0x92, 0x71,
			0xcf, 0x52, 0xc3, 0xa3, 0xf8, 0xff, 0x48, 0x9a,
			0xbb, 0x55, 0xeb, 0x26, 0xcf, 0xdd, 0xa2, 0x42,
			0xb0, 0xe7, 0xf9, 0xfe, 0x2c, 0x9e, 0x8c, 0xfb,
			0xa5, 0xfc, 0x20, 0xda, 0xb7, 0x22, 0x0a, 0x62,
			0xb3, 0x91, 0xf6, 0x1d, 0x8d, 0x95, 0xf7, 0xd4,
			0xd6, 0x23, 0xf6, 0xc3, 0x99, 0x51, 0xf0, 0x7f,
			0x07, 0x19, 0x18, 0xb4, 0x62, 0xf9, 0x71, 0xc7,
			0x09, 0x37, 0x67, 0x4a, 0xbf, 0xdd, 0x2c, 0x4e,
			0xff, 0x79, 0xe7, 0x95, 0x3d, 0x42, 0x14, 0xb2,
			0x17, 0xf9, 0x72, 0xe0, 0xa2, 0xea, 0x6f, 0xab,
			0xee, 0xa8, 0x18, 0xd8, 0x30, 0xd7, 0x23, 0xaf,
			0x1c, 0x07, 0xc2, 0x3c, 0xef, 0xd7, 0xb5, 0x5a,
			0x30, 0xc0, 0xbe, 0x2d, 0x45, 0x2d, 0x1f, 0x02,
		},
	},
	/* SHA512224 [9] */
	{
		/* Msg9 : 128 byte */
		{
			0xe4, 0x6d, 0xf5, 0x24, 0xb4, 0x5b, 0x52, 0xdc,
			0x60, 0x1c, 0x06, 0x1a, 0xd5, 0x73, 0x17, 0xe1,
			0xd6, 0xac, 0xf4, 0xee, 0xfd, 0x8c, 0xa0, 0x4c,
			0xfc, 0x84, 0x13, 0x23, 0x29, 0x29, 0xde, 0xd1,
			0x3a, 0xe9, 0x0d, 0x3b, 0x4c, 0xf6, 0x51, 0x65,
			0x2b, 0x87, 0x5f, 0x41, 0xcd, 0x40, 0x93, 0xc5,
			0x1f, 0xee, 0xd9, 0x40, 0x05, 0x78, 0xcd, 0xee,
			0x9b, 0x13, 0x21, 0xca, 0xc2, 0xb4, 0x3f, 0xa3,
			0xd8, 0xcb, 0x30, 0x72, 0xc6, 0x2e, 0xbd, 0xeb,
			0x40, 0x53, 0xd4, 0x52, 0x48, 0xc3, 0x2d, 0x90,
			0xf4, 0xcb, 0x2c, 0x86, 0x72, 0x75, 0x0a, 0xa1,
			0x49, 0xb7, 0x30, 0xaf, 0xe1, 0xe9, 0xe3, 0xf1,
			0x46, 0x7c, 0x26, 0x71, 0x29, 0xea, 0xdc, 0x95,
			0x28, 0xe9, 0x2e, 0xf5, 0x4f, 0xe4, 0x2c, 0x6a,
			0xde, 0xab, 0xb7, 0x67, 0x4c, 0x6a, 0x9e, 0x8d,
			0x8d, 0xd8, 0x07, 0x79, 0x91, 0xb0, 0x11, 0xe1,
		},
		/* S9 : 256 byte */
		{
			0xc6, 0x6d, 0x6d, 0xd7, 0x89, 0x49, 0x6c, 0xaa,
			0x62, 0xaf, 0x31, 0x8c, 0x02, 0x3b, 0x24, 0xfe,
			0x99, 0x44, 0x4c, 0x0a, 0x2f, 0x17, 0x94, 0x14,
			0xc0, 0x3c, 0x03, 0xaa, 0x3b, 0xcf, 0xd5, 0x47,
			0xd7, 0x4e, 0x56, 0xcb, 0xc2, 0xc4, 0x8a, 0x46,
			0x78, 0xff, 0xa3, 0x90, 0x49, 0x64, 0xc0, 0xb8,
			0x36, 0x71, 0x7d, 0x11, 0x55, 0x38, 0xd3, 0x86,
			0x13, 0x80, 0x96, 0xde, 0xc8, 0xe5, 0xa3, 0x29,
			0xe1, 0x61, 0x83, 0xa2, 0x09, 0x6d, 0xdd, 0xc6,
			0xa0, 0xe3, 0xc5, 0x59, 0xc3, 0xd2, 0x73, 0x56,
			0x8e, 0xef, 0xdf, 0x3d, 0x75, 0xe5, 0xaf, 0x3b,
			0xd4, 0x33, 0xe3, 0x65, 0x78, 0x92, 0x70, 0x0b,
			0x95, 0xfd, 0xb4, 0x08, 0xf8, 0xe5, 0x65, 0x3c,
			0x48, 0xcf, 0x56, 0x72, 0xcf, 0x9d, 0x83, 0x8a,
			0x9a, 0x75, 0xfb, 0xff, 0xeb, 0x5b, 0x85, 0xfa,
			0x84, 0x53, 0x19, 0x8f, 0x56, 0x61, 0x95, 0xa3,
			0xbc, 0x2e, 0x2b, 0xd9, 0x00, 0xd1, 0x5b, 0x75,
			0x2b, 0x53, 0x95, 0xb8, 0xf7, 0x92, 0x26, 0x74,
			0x8f, 0xa2, 0xe3, 0x9d, 0x6d, 0x2e, 0xfd, 0x70,
			0x1b, 0xc8, 0x6d, 0x18, 0xf6, 0xe1, 0x58, 0x2b,
			0x21, 0x29, 0xbc, 0x7b, 0x96, 0x1d, 0x8f, 0xc0,
			0xd0, 0x0f, 0x46, 0x4c, 0x79, 0x22, 0xb8, 0xab,
			0x3d, 0x86, 0x0d, 0x02, 0x1e, 0xcc, 0x40, 0xdf,
			0x63, 0xbd, 0x88, 0x44, 0xd4, 0x7a, 0x8f, 0x9d,
			0x1c, 0x4d, 0x91, 0x9f, 0x85, 0xda, 0x59, 0xc0,
			0xc0, 0x48, 0xdb, 0x5b, 0x5f, 0xb6, 0x40, 0x57,
			0xbe, 0x25, 0xfe, 0xe6, 0x69, 0x66, 0xc7, 0x48,
			0x6a, 0x79, 0x6f, 0xe9, 0x4f, 0x6c, 0x32, 0xb5,
			0x46, 0x4e, 0x87, 0xb6, 0xb5, 0x9e, 0x30, 0xcb,
			0x63, 0x25, 0x3f, 0x58, 0x96, 0xa0, 0x3b, 0xa5,
			0x58, 0x66, 0xed, 0x2e, 0x8c, 0x84, 0x14, 0xaf,
			0x28, 0x23, 0xb1, 0x1b, 0x43, 0x44, 0x6a, 0x8b,
		},
	},
};

/* 10 elements */
static mod2048_t SHA512256[] = {
	/* SHA512256 [0] */
	{
		/* Msg0 : 128 byte */
		{
			0xeb, 0xd3, 0xa7, 0x76, 0x55, 0x43, 0x84, 0x91,
			0x2b, 0x8b, 0x90, 0x01, 0x60, 0xa0, 0x7c, 0x02,
			0x4f, 0x3c, 0xa4, 0xd0, 0x52, 0x29, 0x41, 0x10,
			0x90, 0xbc, 0xe0, 0x6b, 0x16, 0xa0, 0x13, 0x7c,
			0x2a, 0xd4, 0x66, 0xec, 0xdb, 0xf7, 0x94, 0xdb,
			0xdd, 0xc4, 0xfb, 0x82, 0x94, 0xd9, 0x4e, 0x17,
			0x6f, 0xbc, 0x8a, 0xf1, 0x77, 0x1f, 0x2b, 0xed,
			0x28, 0x63, 0x9f, 0x10, 0x7f, 0x5c, 0xfb, 0x6e,
			0x54, 0x54, 0xed, 0x4a, 0xea, 0x52, 0xf1, 0x7e,
			0xc5, 0x9c, 0xc8, 0x1e, 0xbb, 0x7a, 0x27, 0x58,
			0x4e, 0x3d, 0xac, 0x9e, 0x39, 0x80, 0x15, 0x08,
			0x49, 0xae, 0xb4, 0xf3, 0x6e, 0xc4, 0x1e, 0xef,
			0x12, 0x58, 0x24, 0xd8, 0xa9, 0xdb, 0x04, 0x42,
			0x8a, 0x1b, 0xe0, 0x1a, 0xfd, 0x0b, 0x6e, 0x8b,
			0x95, 0xc7, 0xf2, 0x1f, 0xc0, 0xd3, 0x69, 0x27,
			0x9c, 0xa3, 0x07, 0x5c, 0x0c, 0x61, 0xe4, 0xc6,
		},
		/* S0 : 256 byte */
		{
			0x80, 0x2f, 0xed, 0x87, 0x5e, 0xf0, 0x6d, 0xd2,
			0xfa, 0xd2, 0xef, 0x12, 0x3f, 0x14, 0xb3, 0x60,
			0xc0, 0xed, 0x51, 0xea, 0xda, 0x42, 0xb4, 0xdb,
			0x56, 0xd8, 0xe6, 0x26, 0x27, 0xa8, 0x5a, 0x18,
			0xfc, 0x15, 0xea, 0xcd, 0x24, 0x67, 0xd7, 0x6e,
			0x84, 0xef, 0xd1, 0x24, 0x5e, 0x4e, 0x62, 0xff,
			0x9d, 0xd7, 0xc5, 0xdb, 0xcf, 0xb3, 0xc8, 0x3d,
			0x9c, 0xad, 0x6e, 0x0b, 0xe0, 0x64, 0xa3, 0xcb,
			0x01, 0x00, 0xf3, 0xff, 0xcd, 0x4c, 0x40, 0x25,
			0xd6, 0x54, 0x17, 0x4a, 0x91, 0xa0, 0xb1, 0x37,
			0x67, 0xf5, 0xf8, 0x35, 0x23, 0x05, 0xe6, 0x1d,
			0x54, 0xcf, 0xc6, 0x1b, 0x9b, 0x80, 0x1c, 0x57,
			0xe1, 0x28, 0x7e, 0x75, 0x9e, 0xa1, 0x59, 0x9b,
			0x68, 0xbf, 0xcb, 0xba, 0x04, 0x3d, 0x77, 0x6e,
			0x3f, 0x1e, 0x75, 0x88, 0x7a, 0x1c, 0xc5, 0xd1,
			0xab, 0x87, 0x84, 0x18, 0xbc, 0x15, 0xa3, 0x56,
			0xb4, 0x79, 0xe6, 0xb4, 0xd1, 0x2b, 0x7d, 0x49,
			0xde, 0x85, 0x0b, 0x29, 0x76, 0xb8, 0x11, 0x31,
			0x35, 0xc0, 0xdf, 0x09, 0x4e, 0xe4, 0x76, 0xa5,
			0xd6, 0xba, 0x3b, 0x2a, 0x3a, 0x03, 0xec, 0xf1,
			0xf6, 0xe9, 0x7f, 0x1e, 0x0c, 0x3a, 0xd1, 0x72,
			0x45, 0x22, 0x14, 0x49, 0xa1, 0xe0, 0xb6, 0x9b,
			0x94, 0x41, 0xd9, 0x7f, 0x59, 0x6c, 0xff, 0xdb,
			0xd9, 0x30, 0x41, 0xb1, 0x17, 0x57, 0xd1, 0x9d,
			0x6a, 0x3a, 0x07, 0xc7, 0xd2, 0x04, 0xeb, 0x0f,
			0x53, 0xac, 0x94, 0xa5, 0xe3, 0xbc, 0x69, 0xd8,
			0xc4, 0x9c, 0xf1, 0xbf, 0xa4, 0xee, 0x9c, 0x1e,
			0x4c, 0x07, 0x7c, 0x5a, 0x18, 0x29, 0x6b, 0xef,
			0x3a, 0x0d, 0xb4, 0x15, 0x24, 0xfe, 0xee, 0x3c,
			0xc8, 0x3c, 0x2c, 0x26, 0x42, 0xc6, 0x33, 0x43,
			0x6e, 0x63, 0x5f, 0x11, 0xb4, 0x30, 0x56, 0xc8,
			0xc5, 0x90, 0xf0, 0x2b, 0xa3, 0xd2, 0xdf, 0xae,
		},
	},
	/* SHA512256 [1] */
	{
		/* Msg1 : 128 byte */
		{
			0x26, 0x60, 0x70, 0x32, 0x8b, 0x55, 0x68, 0x0f,
			0xe6, 0xae, 0x61, 0x54, 0xc2, 0x57, 0xea, 0x69,
			0xb7, 0x1c, 0xf4, 0x87, 0xeb, 0x17, 0x7b, 0xca,
			0xd9, 0x6a, 0x69, 0x87, 0x51, 0x34, 0xb7, 0xdf,
			0xc0, 0xbd, 0xd5, 0x94, 0xb2, 0xf4, 0x4c, 0x1c,
			0x95, 0x1c, 0xa2, 0xf4, 0xc0, 0xc2, 0x7d, 0x37,
			0xb4, 0xf2, 0x0c, 0x6f, 0xa1, 0xaa, 0xa3, 0xab,
			0x2c, 0x8f, 0xa5, 0xd2, 0x6f, 0xdf, 0xa7, 0x36,
			0x41, 0xa7, 0xd2, 0x6c, 0xb8, 0x36, 0x89, 0x5c,
			0xed, 0xd1, 0x4c, 0x94, 0xff, 0xa8, 0xdd, 0xe2,
			0x5b, 0x09, 0xa1, 0x21, 0x3a, 0xd4, 0x48, 0x53,
			0x6b, 0x2f, 0xb1, 0xf0, 0x52, 0x7a, 0x07, 0x7e,
			0x31, 0x86, 0x31, 0x62, 0xa6, 0x01, 0x69, 0xf6,
			0x75, 0x35, 0x2a, 0xdb, 0x88, 0xf3, 0x50, 0x91,
			0x34, 0xc9, 0x7b, 0x44, 0xbe, 0x7b, 0xb4, 0xe9,
			0x1e, 0xb1, 0x53, 0x8a, 0x02, 0xee, 0x1f, 0xde,
		},
		/* S1 : 256 byte */
		{
			0xc0, 0xac, 0x3e, 0x5e, 0x77, 0xfe, 0xdc, 0x49,
			0x9c, 0xaa, 0x52, 0x0f, 0x18, 0x61, 0x35, 0x58,
			0x8f, 0x3e, 0x49, 0xe2, 0x03, 0x4c, 0x22, 0xca,
			0x5b, 0x74, 0x95, 0x1d, 0x41, 0xf7, 0x3b, 0xc6,
			0x56, 0xee, 0x95, 0x8b, 0xc4, 0x3e, 0x9f, 0xc4,
			0x60, 0xdb, 0x00, 0x6c, 0x94, 0xe4, 0x6b, 0x03,
			0xf0, 0x5c, 0x5a, 0x73, 0x0b, 0x16, 0xe6, 0xf0,
			0xee, 0x78, 0xae, 0x32, 0xcc, 0x6f, 0xdf, 0x40,
			0x99, 0x4f, 0xdc, 0x97, 0x85, 0x29, 0xf9, 0x74,
			0x52, 0xdb, 0x1f, 0x7a, 0xce, 0xa4, 0xb8, 0xee,
			0xd5, 0xac, 0xa0, 0xa2, 0x9d, 0x7e, 0x27, 0xe5,
			0x62, 0x5a, 0xef, 0xff, 0x25, 0x8b, 0x8f, 0x14,
			0x68, 0x59, 0x04, 0x45, 0x20, 0x2c, 0xac, 0x19,
			0xd4, 0x7f, 0xca, 0x0b, 0x0f, 0x51, 0xe1, 0xf4,
			0xd6, 0xdb, 0xe5, 0x3d, 0x9e, 0x5a, 0xbd, 0x26,
			0xf8, 0x89, 0x35, 0x4e, 0xc2, 0xab, 0x36, 0x97,
			0x82, 0xf4, 0xf1, 0x97, 0x4f, 0x6a, 0x96, 0x14,
			0x1d, 0x50, 0x9c, 0xec, 0x6e, 0x57, 0x5e, 0x83,
			0xdd, 0x71, 0x75, 0xc6, 0x19, 0x23, 0xbd, 0xe8,
			0xc0, 0x22, 0x24, 0x2c, 0x08, 0x9e, 0x08, 0x0e,
			0xb2, 0x09, 0x60, 0x4d, 0x90, 0xaa, 0xf8, 0xe7,
			0x57, 0x71, 0xb1, 0x34, 0x97, 0x23, 0x6a, 0xb1,
			0x0c, 0x37, 0xfb, 0x9e, 0xcc, 0xb1, 0x3c, 0xa8,
			0xce, 0xd8, 0xf5, 0x4e, 0xce, 0x38, 0xb0, 0xee,
			0x40, 0x93, 0x84, 0x64, 0xd9, 0xa4, 0x23, 0xbe,
			0xd7, 0xd9, 0x9a, 0x2d, 0x5b, 0xa1, 0x86, 0xbd,
			0x09, 0x50, 0xb2, 0x01, 0x51, 0x1b, 0xcd, 0x79,
			0xe3, 0x79, 0xfc, 0x3b, 0xf2, 0x54, 0xbc, 0x51,
			0x9f, 0x61, 0xbe, 0xb0, 0x6a, 0xb3, 0xbb, 0x1e,
			0x1e, 0xfa, 0xef, 0xa1, 0x85, 0xfb, 0x9d, 0xb2,
			0x86, 0x04, 0x37, 0x52, 0xcf, 0xd9, 0x59, 0x0a,
			0x29, 0x26, 0x50, 0xbc, 0x86, 0xe3, 0xf8, 0xb8,
		},
	},
	/* SHA512256 [2] */
	{
		/* Msg2 : 128 byte */
		{
			0x37, 0x9c, 0x93, 0xef, 0x03, 0x7a, 0x70, 0x2f,
			0xff, 0x95, 0x2f, 0xfc, 0xb4, 0x63, 0x41, 0x9a,
			0xa8, 0x61, 0xf9, 0x96, 0x82, 0xaa, 0xdb, 0xfc,
			0x6e, 0xc8, 0x16, 0xca, 0xc3, 0xca, 0x4f, 0xa5,
			0xe4, 0x96, 0xa0, 0xcb, 0x64, 0x81, 0xe1, 0x49,
			0x6d, 0x1d, 0x26, 0x6e, 0x62, 0x52, 0x88, 0x7f,
			0xc3, 0xb1, 0x29, 0xac, 0x51, 0x04, 0x72, 0x43,
			0x73, 0x2a, 0x9f, 0x24, 0xd9, 0x22, 0x7e, 0x75,
			0x5f, 0x65, 0x73, 0x96, 0x34, 0x79, 0xc0, 0x57,
			0x3b, 0xc3, 0x03, 0x69, 0xb1, 0x9d, 0x00, 0x13,
			0x11, 0xa8, 0xa1, 0x26, 0x34, 0x63, 0x3b, 0x33,
			0xbd, 0xfd, 0x13, 0xfb, 0xb4, 0x68, 0x21, 0x27,
			0x71, 0xaf, 0x14, 0x3a, 0xbc, 0x89, 0x96, 0xc3,
			0x32, 0x2e, 0xd0, 0xd7, 0xeb, 0x69, 0x31, 0xbe,
			0x59, 0xef, 0x6b, 0xed, 0x73, 0xef, 0xbf, 0x34,
			0x13, 0xea, 0x7b, 0x39, 0x9d, 0xc5, 0xc1, 0x25,
		},
		/* S2 : 256 byte */
		{
			0x4f, 0x11, 0xc9, 0x70, 0x6a, 0xad, 0xdd, 0xb4,
			0xe1, 0xb7, 0xeb, 0x2b, 0xb3, 0xbb, 0x10, 0x36,
			0x22, 0xe1, 0x96, 0xf1, 0x91, 0x02, 0x63, 0x05,
			0x17, 0x97, 0xeb, 0x50, 0x14, 0x4b, 0xe6, 0x4b,
			0xff, 0x13, 0xe9, 0xed, 0x98, 0xa0, 0x35, 0x90,
			0x10, 0xfb, 0xba, 0x00, 0x8b, 0x32, 0x6b, 0x2b,
			0x32, 0xb5, 0x76, 0xd0, 0x27, 0xdd, 0x27, 0xf7,
			0x2b, 0x25, 0x30, 0x9a, 0xf9, 0xf9, 0xed, 0x70,
			0x55, 0xba, 0x45, 0x0b, 0xed, 0x04, 0x2a, 0xa6,
			0x13, 0x9c, 0x72, 0x67, 0xbd, 0xb0, 0xa2, 0xe7,
			0xce, 0x42, 0x82, 0x5e, 0x85, 0xa4, 0x08, 0xc4,
			0x36, 0xcb, 0x34, 0x77, 0x72, 0x29, 0x70, 0x9d,
			0x10, 0x02, 0xe8, 0xcc, 0x67, 0x4b, 0xac, 0x71,
			0x81, 0xde, 0x21, 0x39, 0x76, 0xa2, 0x04, 0xc3,
			0x4a, 0xac, 0xb7, 0x05, 0xc0, 0x9d, 0x11, 0x3d,
			0xf2, 0x85, 0xa3, 0x03, 0x3f, 0x8d, 0x61, 0x3e,
			0xfc, 0x0a, 0x1b, 0x76, 0xc3, 0x23, 0x93, 0x1c,
			0x9a, 0xd5, 0x7e, 0xce, 0x6c, 0x92, 0xee, 0x59,
			0x43, 0xd3, 0xf2, 0x5e, 0xdc, 0xe1, 0xc9, 0x09,
			0xb2, 0xab, 0xe5, 0x34, 0x21, 0xdf, 0x96, 0x17,
			0xac, 0xf1, 0xeb, 0x95, 0x49, 0x57, 0xfe, 0xec,
			0x82, 0x27, 0x0d, 0x75, 0x81, 0x87, 0x10, 0xd0,
			0xe6, 0x90, 0x2e, 0xa9, 0x07, 0xb8, 0xec, 0x7b,
			0x7c, 0x46, 0xbb, 0xd0, 0x2d, 0x5d, 0xfc, 0xa5,
			0x3f, 0x7d, 0x76, 0x38, 0xdd, 0x60, 0x0e, 0xaa,
			0xde, 0xe5, 0x5d, 0x89, 0x7d, 0x03, 0xf3, 0xbe,
			0x13, 0x05, 0xf2, 0xb5, 0x5d, 0x75, 0xdf, 0x91,
			0x3d, 0x29, 0x54, 0xf0, 0x07, 0x6c, 0x62, 0x2d,
			0x79, 0xa1, 0xf6, 0xd6, 0x4e, 0x7a, 0x01, 0x0b,
			0x0c, 0x4c, 0xe4, 0x24, 0x38, 0x69, 0x37, 0x5b,
			0xe5, 0x34, 0x8a, 0x33, 0x0c, 0x79, 0xd6, 0xf2,
			0x3e, 0xa0, 0x22, 0xdb, 0x18, 0x48, 0xb7, 0x3e,
		},
	},
	/* SHA512256 [3] */
	{
		/* Msg3 : 128 byte */
		{
			0x56, 0x21, 0x97, 0x63, 0x67, 0x50, 0x2d, 0x7c,
			0xca, 0x62, 0x82, 0x20, 0x3b, 0x39, 0xbe, 0x61,
			0xd4, 0x95, 0x77, 0x10, 0x76, 0xe3, 0x32, 0x2f,
			0x6a, 0x56, 0x27, 0xa5, 0x48, 0x39, 0x45, 0x35,
			0x18, 0x84, 0x76, 0xb1, 0xb8, 0xad, 0x24, 0x6b,
			0x7e, 0xc0, 0xfc, 0xed, 0x1d, 0xb2, 0xf2, 0xea,
			0xcd, 0xf3, 0x85, 0x74, 0xa6, 0x42, 0x44, 0x6e,
			0x4d, 0xc5, 0x91, 0x45, 0xd3, 0x59, 0xa5, 0xdb,
			0xda, 0x27, 0xd4, 0xc4, 0xfa, 0x78, 0x12, 0xb5,
			0x63, 0xca, 0xb7, 0x39, 0xc3, 0x22, 0x7f, 0xa6,
			0x6a, 0xa5, 0xd5, 0x50, 0xac, 0x62, 0x51, 0xfc,
			0x86, 0x73, 0x7f, 0x98, 0x85, 0x44, 0xe2, 0x29,
			0xe4, 0x32, 0x38, 0x04, 0xf4, 0x58, 0x00, 0x41,
			0xc1, 0xa5, 0x3a, 0x6d, 0xf3, 0x32, 0x6e, 0x7f,
			0xf2, 0xd3, 0xef, 0x0d, 0x4e, 0xed, 0x61, 0xc0,
			0x5d, 0x87, 0x79, 0x06, 0x26, 0xa3, 0x04, 0x06,
		},
		/* S3 : 256 byte */
		{
			0xc7, 0xaf, 0x1e, 0xda, 0x25, 0x95, 0xe0, 0x01,
			0x32, 0xdd, 0xda, 0xa7, 0x0c, 0x0c, 0x66, 0x11,
			0x75, 0x44, 0x6c, 0xbd, 0x04, 0x08, 0xc2, 0x2d,
			0x63, 0xe6, 0xc3, 0xde, 0xb0, 0xbe, 0xb7, 0x78,
			0x8e, 0xa2, 0x98, 0x09, 0x96, 0xc3, 0xbf, 0x9a,
			0xc5, 0x42, 0x37, 0xe4, 0x53, 0xff, 0x0c, 0x17,
			0xe5, 0x09, 0x72, 0xb1, 0xa9, 0xed, 0x6e, 0xdb,
			0xf3, 0x6b, 0xee, 0xad, 0x7c, 0x95, 0xb4, 0x48,
			0xb6, 0xd0, 0x71, 0x59, 0x5b, 0xc7, 0x68, 0xd6,
			0x78, 0x13, 0xc9, 0x4d, 0xa0, 0xad, 0x60, 0xe0,
			0x23, 0x45, 0x20, 0xdb, 0x54, 0xe8, 0xd7, 0xc0,
			0xf1, 0x83, 0x03, 0x45, 0xd5, 0xf6, 0x9a, 0x42,
			0xfc, 0x25, 0xf0, 0xe4, 0xbf, 0xb0, 0xfc, 0x2a,
			0xb3, 0xcc, 0x16, 0xd6, 0xbc, 0x13, 0x26, 0xbe,
			0x09, 0x1f, 0x60, 0xf9, 0x4f, 0x4c, 0x53, 0x29,
			0x08, 0x0b, 0x49, 0x46, 0x90, 0x7b, 0x5e, 0x65,
			0xdb, 0xb9, 0x46, 0x9d, 0xa4, 0x7b, 0x6a, 0xcc,
			0x0e, 0x91, 0x78, 0x44, 0x91, 0xde, 0x31, 0x18,
			0x91, 0x68, 0x37, 0xd3, 0x4f, 0x20, 0xd6, 0x37,
			0x01, 0x11, 0xc3, 0x1a, 0xc9, 0x43, 0x5f, 0x31,
			0x95, 0x7c, 0x2e, 0x11, 0xaa, 0xcf, 0x0d, 0x8b,
			0xd0, 0x35, 0xa5, 0xba, 0xbc, 0xd2, 0x4b, 0x9c,
			0x86, 0xeb, 0x06, 0x3d, 0x60, 0xaa, 0xba, 0x2d,
			0x82, 0xdd, 0x2a, 0x3b, 0x0a, 0x9a, 0x9d, 0x6a,
			0xe1, 0xe0, 0x05, 0x87, 0xe1, 0x00, 0x62, 0xf9,
			0xb9, 0xe7, 0x9a, 0xbc, 0x70, 0x78, 0x6c, 0xe5,
			0xf2, 0x36, 0xf7, 0x6e, 0xdd, 0x38, 0x44, 0xe0,
			0x94, 0xae, 0xf5, 0xb5, 0x45, 0xe9, 0xa1, 0x49,
			0x16, 0x15, 0xa1, 0x59, 0x08, 0xe1, 0xdd, 0x46,
			0x2f, 0x04, 0x64, 0xc2, 0xee, 0xaf, 0x65, 0xbf,
			0xca, 0x63, 0xb1, 0x6e, 0x41, 0x63, 0x9b, 0xf6,
			0x32, 0x9f, 0xeb, 0x1a, 0x23, 0xf9, 0xd4, 0xd7,
		},
	},
	/* SHA512256 [4] */
	{
		/* Msg4 : 128 byte */
		{
			0x32, 0x08, 0x44, 0xc2, 0x66, 0x15, 0x69, 0xbb,
			0x86, 0xcc, 0x39, 0xaa, 0xdc, 0xa4, 0x62, 0x56,
			0x9e, 0x49, 0xf2, 0x68, 0x65, 0x40, 0x6a, 0x2a,
			0xe0, 0xca, 0x14, 0x8e, 0xca, 0x0c, 0x97, 0x72,
			0x19, 0x6c, 0xc9, 0x22, 0x79, 0x3e, 0xc4, 0x1f,
			0xf8, 0xa0, 0x3c, 0x1f, 0x03, 0xa2, 0x10, 0x54,
			0x91, 0xab, 0x1e, 0xf1, 0x9e, 0x18, 0x5c, 0xeb,
			0xdb, 0x25, 0x25, 0xfc, 0xa4, 0x11, 0xd0, 0xee,
			0x32, 0x7d, 0x87, 0x16, 0x12, 0x16, 0x56, 0x1f,
			0xd5, 0x73, 0x83, 0x09, 0x0a, 0x40, 0x1e, 0x70,
			0x69, 0x9d, 0xd8, 0x12, 0x51, 0xc1, 0x19, 0x8c,
			0x75, 0xe3, 0x4c, 0x64, 0xd2, 0x5a, 0x7e, 0x4c,
			0xe4, 0x03, 0x27, 0xa5, 0x19, 0xe3, 0x47, 0x43,
			0x86, 0x0d, 0xb5, 0x70, 0xd8, 0xc6, 0xb4, 0x33,
			0x8e, 0xe8, 0xc8, 0xd2, 0x66, 0x84, 0xc8, 0x95,
			0x15, 0xcb, 0x33, 0xcd, 0x3b, 0x2f, 0xc7, 0x15,
		},
		/* S4 : 256 byte */
		{
			0x98, 0x95, 0xba, 0xc5, 0xcc, 0x4c, 0x59, 0x7b,
			0x67, 0xfa, 0x64, 0xd2, 0xfd, 0xfa, 0x04, 0xa8,
			0x0f, 0x93, 0x9a, 0xea, 0xf2, 0xa7, 0x70, 0x08,
			0xee, 0x36, 0x40, 0xaa, 0xbe, 0xb7, 0xf4, 0xc9,
			0xc9, 0x98, 0x51, 0x80, 0x94, 0x3c, 0xa6, 0xb1,
			0xf5, 0xc6, 0x9c, 0x2a, 0x80, 0xb8, 0x24, 0x81,
			0x20, 0x3a, 0x27, 0x3a, 0x09, 0x7a, 0xb6, 0x95,
			0xdc, 0xb3, 0x4e, 0x51, 0x56, 0xc2, 0xdb, 0xc9,
			0x1f, 0x81, 0x30, 0xbb, 0x7a, 0xd5, 0xc4, 0x16,
			0x11, 0x89, 0x6f, 0x76, 0x5e, 0x9d, 0xc0, 0x04,
			0x03, 0x86, 0x4f, 0x1e, 0x0b, 0x35, 0x6e, 0xd0,
			0x33, 0xdc, 0x2b, 0xc1, 0xce, 0x80, 0xaf, 0x7c,
			0x5a, 0x4d, 0xb8, 0xb5, 0xad, 0xc4, 0x62, 0x91,
			0xc1, 0x29, 0x6b, 0x4b, 0xd0, 0x7b, 0x9b, 0x89,
			0x39, 0xb2, 0x51, 0xd6, 0xb1, 0x6e, 0x7c, 0x38,
			0x1b, 0xd9, 0xd1, 0x56, 0x79, 0x21, 0x6f, 0xdf,
			0x26, 0xd7, 0x0c, 0xae, 0xf8, 0x7e, 0x98, 0xd5,
			0x62, 0x60, 0x40, 0xe6, 0x33, 0x0a, 0x14, 0x03,
			0x17, 0x5f, 0xf4, 0x86, 0xfc, 0xbd, 0x19, 0x3e,
			0x49, 0x0b, 0x68, 0x87, 0x42, 0x31, 0xf2, 0x86,
			0xa4, 0x1a, 0xe8, 0xd4, 0x06, 0x47, 0x46, 0xb5,
			0x6d, 0x05, 0xdb, 0xb4, 0x46, 0x06, 0x54, 0x4b,
			0x82, 0x6c, 0x1a, 0x2a, 0x64, 0x03, 0x11, 0xfe,
			0xa0, 0xda, 0x8c, 0x33, 0x47, 0x00, 0xcd, 0x24,
			0xf2, 0x3d, 0xcf, 0x04, 0xcc, 0xa0, 0x2b, 0x1c,
			0xcc, 0x92, 0x66, 0x60, 0xa4, 0x0e, 0xee, 0x4e,
			0xf5, 0x2b, 0x49, 0x9e, 0x1e, 0x6d, 0x62, 0x1a,
			0xdc, 0x5d, 0x5f, 0xba, 0x3d, 0xd1, 0xad, 0x8e,
			0xc8, 0x21, 0xcc, 0xe5, 0xfd, 0xc4, 0xf4, 0x83,
			0xb3, 0x7d, 0x03, 0x4b, 0x1e, 0x43, 0xc7, 0x52,
			0x60, 0xb6, 0xe8, 0x27, 0x9a, 0xa1, 0x93, 0x68,
			0xed, 0x11, 0xca, 0xef, 0x97, 0x76, 0x76, 0x45,
		},
	},
	/* SHA512256 [5] */
	{
		/* Msg5 : 128 byte */
		{
			0x27, 0xca, 0x99, 0x76, 0xae, 0x87, 0xae, 0x99,
			0x65, 0x46, 0x07, 0x06, 0xf2, 0x63, 0xa5, 0x8e,
			0x73, 0xd5, 0xb0, 0x8a, 0x6f, 0x56, 0x0b, 0x1c,
			0x0c, 0xc5, 0x2c, 0xb7, 0x83, 0xc8, 0x2b, 0xe1,
			0xd2, 0xb5, 0x18, 0x37, 0xb1, 0xb3, 0x92, 0xb2,
			0xc6, 0x1c, 0x95, 0x2a, 0x1c, 0x26, 0x94, 0x18,
			0xd2, 0xc3, 0xc8, 0xa0, 0x10, 0xc5, 0xc7, 0xcf,
			0x3f, 0x46, 0x58, 0x21, 0x7a, 0x47, 0x86, 0x46,
			0x3f, 0x97, 0xf3, 0x25, 0x6b, 0xf7, 0x6f, 0x22,
			0x65, 0x7b, 0xc9, 0x9c, 0x99, 0x33, 0xe5, 0xba,
			0x28, 0x0b, 0x0f, 0x68, 0xdd, 0xf0, 0x8f, 0x9c,
			0x64, 0x34, 0x7e, 0xde, 0xb6, 0x34, 0xd8, 0x07,
			0xd8, 0x38, 0xd2, 0x49, 0xc5, 0x9a, 0x6d, 0x6f,
			0xa9, 0x2b, 0x4b, 0x66, 0x4f, 0xd2, 0xc1, 0xfd,
			0xdd, 0x76, 0x2f, 0xe9, 0xbf, 0x1e, 0x8c, 0x0c,
			0xe1, 0x57, 0x45, 0xf7, 0x21, 0xd7, 0x48, 0xad,
		},
		/* S5 : 256 byte */
		{
			0x55, 0xe9, 0x70, 0xee, 0xb2, 0xe5, 0x9d, 0x99,
			0xe8, 0xdd, 0x99, 0x62, 0x4e, 0x17, 0xdb, 0xc6,
			0xfc, 0xd1, 0x16, 0x44, 0x0a, 0x3c, 0x52, 0xf3,
			0xcc, 0xbe, 0x44, 0xa1, 0xcf, 0xf8, 0x30, 0xda,
			0x6c, 0xa6, 0x89, 0xee, 0xcf, 0xac, 0xe8, 0xd7,
			0x41, 0xf7, 0x5c, 0xaf, 0x86, 0xd3, 0x2a, 0x6c,
			0x39, 0xf4, 0x0c, 0x03, 0xfc, 0x5c, 0x13, 0x9b,
			0xac, 0x85, 0x34, 0xc5, 0x8f, 0x11, 0x08, 0x43,
			0xb7, 0xc3, 0xbe, 0x20, 0x29, 0x07, 0x7c, 0x03,
			0xc2, 0xbb, 0xa8, 0x14, 0x1f, 0x9d, 0x3c, 0x6a,
			0xb6, 0xbf, 0xbc, 0x9b, 0x50, 0xe1, 0xe9, 0xf0,
			0x1b, 0x86, 0xc0, 0x25, 0xe8, 0xe5, 0x3d, 0xfb,
			0x08, 0x94, 0x5a, 0x9b, 0xfe, 0xbe, 0x21, 0xd9,
			0x2e, 0xca, 0x4d, 0x6b, 0xa1, 0x7e, 0x92, 0x87,
			0x88, 0x78, 0x70, 0xaa, 0x61, 0x28, 0x86, 0x25,
			0x36, 0xb8, 0xed, 0xec, 0x77, 0xef, 0x67, 0xf7,
			0xa4, 0x87, 0xcf, 0x3e, 0xfe, 0x1a, 0xbe, 0xf0,
			0x5c, 0x0f, 0x91, 0xc7, 0xbc, 0x75, 0x4a, 0x9e,
			0xaa, 0x76, 0xf6, 0xc5, 0x21, 0x64, 0xf6, 0x03,
			0xdd, 0xac, 0x34, 0xfc, 0xaa, 0x48, 0xe4, 0xb1,
			0x08, 0xf1, 0x51, 0x0d, 0x0c, 0xc0, 0x78, 0x65,
			0xfc, 0xdc, 0xce, 0x91, 0x37, 0xfb, 0x6e, 0x5e,
			0x9b, 0x60, 0x56, 0x78, 0x3a, 0xe2, 0x8c, 0x85,
			0x07, 0x8c, 0xcb, 0xe7, 0x9e, 0xf1, 0x3e, 0x17,
			0xbc, 0xfb, 0x9e, 0x14, 0x48, 0x87, 0xf7, 0xf1,
			0x2e, 0x46, 0x53, 0x31, 0xec, 0x1a, 0xaa, 0xb0,
			0x17, 0x88, 0x1d, 0x7d, 0x85, 0x35, 0x85, 0x28,
			0x14, 0xa3, 0x0c, 0xe3, 0x0c, 0xc8, 0xf4, 0x3a,
			0xbd, 0x8a, 0xc1, 0x22, 0x1c, 0x3b, 0x90, 0x75,
			0xe2, 0x1a, 0x0c, 0x7b, 0x0b, 0x40, 0x3a, 0xdb,
			0xa4, 0xff, 0x4f, 0x03, 0xfd, 0xe2, 0xd4, 0x53,
			0xfb, 0x79, 0x82, 0xaa, 0x04, 0x5e, 0x10, 0xfc,
		},
	},
	/* SHA512256 [6] */
	{
		/* Msg6 : 128 byte */
		{
			0xf8, 0x07, 0x79, 0x31, 0x10, 0xd5, 0x0b, 0xc5,
			0xb9, 0xe8, 0xe6, 0x3f, 0x6e, 0xa3, 0x6c, 0xc6,
			0xc6, 0x0a, 0x23, 0x1c, 0x91, 0x84, 0x67, 0x7e,
			0x24, 0xde, 0x5c, 0xcc, 0xf1, 0x94, 0x27, 0xea,
			0x5b, 0x4c, 0x5e, 0x66, 0xc8, 0xa4, 0xbc, 0x5b,
			0xf7, 0x2d, 0x1a, 0x95, 0x94, 0xb7, 0x9a, 0xf5,
			0x09, 0xd0, 0x26, 0x17, 0x98, 0x87, 0x19, 0x33,
			0xa6, 0x76, 0x3b, 0x41, 0x5a, 0xff, 0xf3, 0x61,
			0x67, 0xd5, 0xb8, 0x79, 0x26, 0xbe, 0xc9, 0x20,
			0xe8, 0x98, 0x1e, 0xbb, 0x8a, 0x9a, 0x9e, 0xe5,
			0x4a, 0xdd, 0x92, 0x15, 0xd8, 0x1b, 0x5a, 0x7a,
			0xb1, 0xb6, 0x5e, 0x2a, 0xa8, 0xfc, 0x48, 0x7c,
			0xc5, 0xa9, 0x71, 0xb2, 0x53, 0xad, 0x98, 0xdc,
			0x35, 0x30, 0xda, 0xf9, 0x79, 0xd4, 0xde, 0x5e,
			0x30, 0x3a, 0x51, 0x5c, 0x7c, 0xc7, 0x92, 0x1d,
			0xea, 0xa8, 0xae, 0xcf, 0x02, 0x13, 0x8e, 0x04,
		},
		/* S6 : 256 byte */
		{
			0xbc, 0x1b, 0x30, 0xf0, 0x86, 0x63, 0x95, 0x9c,
			0xc9, 0x96, 0x13, 0xa7, 0x7f, 0xbd, 0x5f, 0xb4,
			0x70, 0x86, 0x01, 0xf3, 0xcc, 0xb0, 0xea, 0x60,
			0xe8, 0xe4, 0x09, 0x7d, 0x84, 0x1d, 0xbc, 0xee,
			0x0c, 0xcd, 0xe9, 0xc9, 0x81, 0x43, 0x9f, 0x7b,
			0xc5, 0x7e, 0x4e, 0x73, 0x1b, 0x82, 0x42, 0x06,
			0xc9, 0xfc, 0x11, 0x2b, 0xac, 0xbe, 0x12, 0x02,
			0xf2, 0x41, 0xe3, 0xe3, 0x04, 0x34, 0x8e, 0xbf,
			0xe4, 0xe1, 0xc5, 0xfb, 0x1c, 0xe2, 0xf7, 0xb8,
			0xca, 0x13, 0xd9, 0x51, 0xb1, 0x59, 0x63, 0x27,
			0x43, 0xc3, 0x1b, 0xce, 0xf0, 0x15, 0xf5, 0xb1,
			0x72, 0x1a, 0xde, 0xf6, 0xdc, 0xc8, 0x27, 0x23,
			0x14, 0xe0, 0x4f, 0xf6, 0x13, 0x2a, 0xec, 0x67,
			0x58, 0x99, 0x06, 0x2d, 0x22, 0x01, 0x7c, 0xeb,
			0xdf, 0x9f, 0x13, 0x7c, 0x46, 0xd8, 0xe6, 0x01,
			0x36, 0x36, 0x4a, 0xe3, 0xc1, 0xa6, 0xeb, 0xe1,
			0x62, 0xe6, 0x1e, 0x94, 0x34, 0x5b, 0x5f, 0x01,
			0xc3, 0x83, 0xa1, 0xd0, 0xd0, 0xe8, 0xb4, 0x06,
			0x38, 0xaa, 0x79, 0x9c, 0x2c, 0x92, 0x32, 0xae,
			0xc1, 0xcf, 0xf1, 0xa3, 0x35, 0xb3, 0xca, 0x81,
			0xee, 0xa4, 0x08, 0x10, 0xce, 0xae, 0x8b, 0xa0,
			0x86, 0x1c, 0xc1, 0xc5, 0x8c, 0x71, 0x67, 0xc6,
			0x2e, 0x71, 0xe2, 0x34, 0x8c, 0xbc, 0x97, 0x5c,
			0xb6, 0xd5, 0x44, 0xb1, 0x1b, 0xb1, 0x8e, 0x91,
			0x26, 0x67, 0x7f, 0xf0, 0x8e, 0xf2, 0xdd, 0xa1,
			0x91, 0xda, 0x6a, 0x6b, 0x03, 0x35, 0x83, 0x0f,
			0xcd, 0x49, 0x7c, 0xbd, 0xbc, 0x0e, 0x93, 0xf1,
			0xaf, 0x6e, 0x76, 0xa3, 0xd0, 0x4f, 0x0f, 0xdb,
			0x00, 0xcc, 0xac, 0xcf, 0x43, 0x3e, 0x39, 0x5a,
			0xcc, 0x3f, 0x46, 0xa3, 0x36, 0x56, 0xa3, 0x6b,
			0xf1, 0x97, 0x38, 0xe0, 0x55, 0xab, 0x70, 0x0a,
			0xc6, 0xbf, 0x7b, 0xf3, 0x40, 0xc3, 0xbb, 0x15,
		},
	},
	/* SHA512256 [7] */
	{
		/* Msg7 : 128 byte */
		{
			0x6d, 0xd9, 0xbf, 0x3b, 0x2c, 0x5d, 0x31, 0x2a,
			0xd1, 0x5b, 0xaf, 0x8a, 0x61, 0xd6, 0xff, 0x9a,
			0x75, 0x11, 0x26, 0xd8, 0xe0, 0xa4, 0x2f, 0xb8,
			0x92, 0xd0, 0x27, 0x9c, 0xbc, 0x10, 0x6c, 0x01,
			0x35, 0xf0, 0x28, 0xf6, 0x1d, 0x22, 0x18, 0xd3,
			0xc0, 0xcf, 0x92, 0x27, 0xbc, 0x2b, 0xc6, 0xf2,
			0x67, 0x4c, 0x44, 0x15, 0x6b, 0x3c, 0xbe, 0x06,
			0xb3, 0x4d, 0x0f, 0xc8, 0x8b, 0xac, 0x7d, 0x1b,
			0x02, 0x39, 0x3b, 0xf0, 0x93, 0x96, 0x32, 0x1f,
			0x05, 0x7e, 0x02, 0x5c, 0x90, 0x59, 0x43, 0x68,
			0x41, 0x0d, 0x10, 0x84, 0xa0, 0x16, 0xc6, 0x2b,
			0x8f, 0xd9, 0x09, 0x00, 0x75, 0x35, 0x08, 0x06,
			0x9c, 0x5c, 0x02, 0x0f, 0xd8, 0xe1, 0x0a, 0x77,
			0x6a, 0x12, 0x07, 0x11, 0x23, 0x87, 0xfe, 0x62,
			0xcd, 0xfb, 0x94, 0x0d, 0xc6, 0x5b, 0xce, 0x8f,
			0xee, 0x1d, 0x1c, 0x2c, 0xc3, 0xd3, 0x96, 0x29,
		},
		/* S7 : 256 byte */
		{
			0x0a, 0x77, 0xf1, 0xa9, 0xad, 0xbe, 0xca, 0xc0,
			0x36, 0xaf, 0x4a, 0xc6, 0xd9, 0xcb, 0xb3, 0x17,
			0x4c, 0xec, 0xe1, 0xe4, 0x9b, 0xda, 0x02, 0x9f,
			0x48, 0x82, 0x93, 0xc5, 0x60, 0x96, 0x5e, 0xe5,
			0xd4, 0xda, 0x14, 0x73, 0x9a, 0x91, 0xf5, 0x59,
			0x23, 0x63, 0xe4, 0xe4, 0x85, 0x24, 0xe4, 0xda,
			0x50, 0x9e, 0xf4, 0x2c, 0xf8, 0x9e, 0xc1, 0xdc,
			0x0a, 0xc1, 0x52, 0x28, 0xe7, 0xcf, 0xca, 0xd3,
			0x59, 0x29, 0x4e, 0xc0, 0x54, 0x55, 0x2f, 0xe8,
			0xb4, 0xf3, 0xb3, 0x26, 0xae, 0x4a, 0x42, 0x3c,
			0xfb, 0xda, 0x45, 0x03, 0x5a, 0xc6, 0x0d, 0x25,
			0x3c, 0x0f, 0xc3, 0xb8, 0xa4, 0xf9, 0x7b, 0x1e,
			0x28, 0x68, 0xd3, 0x2e, 0xd3, 0xd3, 0x28, 0xfa,
			0x37, 0x20, 0xec, 0x69, 0x30, 0x95, 0x35, 0x38,
			0xeb, 0xfd, 0xf2, 0xab, 0x15, 0x2d, 0xf1, 0xb7,
			0xa4, 0xd7, 0x59, 0xee, 0xb7, 0x5a, 0x9d, 0xad,
			0x89, 0x61, 0x28, 0x19, 0x10, 0x0d, 0x60, 0x49,
			0x1e, 0x0f, 0x5d, 0xf6, 0xdb, 0x18, 0x23, 0xf6,
			0x12, 0x90, 0x29, 0xa9, 0x7d, 0x3b, 0x1b, 0x83,
			0xd1, 0x67, 0xcb, 0x5c, 0xff, 0xde, 0x87, 0xee,
			0xde, 0x6c, 0x86, 0x6b, 0x4c, 0x15, 0x27, 0xb7,
			0x10, 0x62, 0x8c, 0x15, 0xc9, 0xd2, 0x50, 0x60,
			0x82, 0xef, 0xe7, 0xf3, 0xca, 0x29, 0xa2, 0x78,
			0x53, 0xc2, 0xb8, 0xcf, 0x3e, 0xd3, 0x8f, 0x95,
			0xc1, 0x19, 0xc5, 0x34, 0xc6, 0x9b, 0x67, 0xd4,
			0x2f, 0xc8, 0x4b, 0xfa, 0x26, 0x41, 0x0d, 0x99,
			0x54, 0xa7, 0x0a, 0x08, 0x45, 0xbc, 0x6a, 0x7a,
			0x36, 0x01, 0x26, 0x34, 0x68, 0x61, 0xeb, 0xa3,
			0xc0, 0x1a, 0x88, 0x19, 0x1c, 0x11, 0x53, 0x89,
			0x2c, 0x25, 0x3f, 0x2b, 0x9f, 0x94, 0x84, 0x87,
			0x35, 0x76, 0x7a, 0xbb, 0xa4, 0xcd, 0x61, 0xb6,
			0x06, 0xfe, 0x98, 0x20, 0x9b, 0x18, 0x39, 0xa3,
		},
	},
	/* SHA512256 [8] */
	{
		/* Msg8 : 128 byte */
		{
			0x11, 0x20, 0xeb, 0xd1, 0xbe, 0xd0, 0xfe, 0x77,
			0x73, 0xfb, 0xde, 0xf2, 0xf2, 0xeb, 0x01, 0xf1,
			0xfe, 0xeb, 0xd5, 0x38, 0x1c, 0xfc, 0xa7, 0xf2,
			0x97, 0xc9, 0xc5, 0x49, 0xc6, 0xdd, 0xdf, 0x35,
			0x91, 0x14, 0xb3, 0x91, 0x32, 0x4f, 0xea, 0x74,
			0x39, 0x6c, 0x3c, 0xbe, 0xd3, 0x76, 0xdb, 0xf1,
			0x4b, 0x18, 0x0f, 0x43, 0xd1, 0x58, 0x1d, 0xf1,
			0x7b, 0x82, 0x6e, 0xd5, 0x89, 0x61, 0xed, 0x3b,
			0xed, 0xb5, 0xb1, 0xf1, 0x0b, 0xe2, 0xdc, 0x9d,
			0xbd, 0xe6, 0xc3, 0x53, 0x9a, 0x8d, 0x4f, 0x67,
			0x78, 0xe8, 0xa3, 0x80, 0x2f, 0xfb, 0xfe, 0xee,
			0xa0, 0xb6, 0xe3, 0x3e, 0xf6, 0x27, 0x78, 0x0b,
			0x2c, 0xed, 0x2d, 0x17, 0xd0, 0xf0, 0x9d, 0x9a,
			0x06, 0x4f, 0xb9, 0xd9, 0xcf, 0x9a, 0x23, 0xfb,
			0x8b, 0x42, 0xd8, 0x18, 0xbd, 0x4d, 0x12, 0x94,
			0x0f, 0x4e, 0x6d, 0xab, 0x96, 0x95, 0x48, 0x4c,
		},
		/* S8 : 256 byte */
		{
			0xb6, 0xd8, 0x65, 0xec, 0xf7, 0xa5, 0x30, 0xf4,
			0x4d, 0xb0, 0xec, 0x48, 0xc9, 0xcb, 0xc3, 0x34,
			0x4f, 0xca, 0x90, 0xf3, 0xf9, 0x95, 0xa7, 0x97,
			0x72, 0x16, 0x90, 0x06, 0x44, 0x81, 0x43, 0x0f,
			0x70, 0xd1, 0xc4, 0x89, 0x57, 0x92, 0xfa, 0x96,
			0xcf, 0x30, 0x53, 0x83, 0x99, 0xbf, 0x0d, 0x72,
			0xfd, 0x72, 0xca, 0xd5, 0x22, 0xa0, 0xbd, 0x88,
			0x44, 0x71, 0x17, 0x67, 0xbe, 0x2e, 0xc1, 0x24,
			0xaf, 0xd6, 0x72, 0x1a, 0xc1, 0xda, 0x69, 0xb2,
			0x7a, 0xb8, 0x22, 0x99, 0xe9, 0xa0, 0x4e, 0x72,
			0x71, 0x14, 0xbc, 0x18, 0xaa, 0x79, 0x26, 0xe2,
			0xc5, 0xd0, 0x23, 0xe9, 0xdc, 0xae, 0x02, 0xae,
			0xfe, 0x0d, 0xfc, 0x65, 0x58, 0xaf, 0x44, 0xce,
			0xf4, 0xbc, 0x27, 0x43, 0x76, 0x7f, 0x88, 0x3c,
			0x61, 0x40, 0x2f, 0x63, 0x40, 0x11, 0x16, 0x10,
			0xc2, 0x2f, 0xb0, 0xba, 0xc9, 0x8b, 0xf4, 0xce,
			0x59, 0xf3, 0xa6, 0x8f, 0x7b, 0xf3, 0xb9, 0x72,
			0xab, 0x96, 0xed, 0xe3, 0x92, 0x9a, 0x0f, 0xc6,
			0xde, 0x4d, 0x1f, 0xf3, 0x45, 0xfd, 0x24, 0x05,
			0x54, 0xa4, 0xa9, 0x4b, 0x9f, 0xf1, 0xdd, 0xa1,
			0xe9, 0xf2, 0x01, 0xcc, 0x76, 0xa6, 0x8d, 0xdb,
			0xe8, 0x1a, 0x86, 0x9c, 0xbc, 0x30, 0x80, 0x51,
			0xb4, 0xd2, 0x3f, 0x43, 0x64, 0x50, 0x4c, 0x29,
			0x24, 0x2c, 0x01, 0x06, 0xa9, 0xff, 0xb8, 0x6c,
			0x18, 0x5f, 0x70, 0x75, 0x90, 0x86, 0xa1, 0x76,
			0xa0, 0xb0, 0x23, 0x87, 0xee, 0x27, 0x4a, 0xc7,
			0x66, 0x3e, 0xee, 0xb7, 0xe9, 0x01, 0x25, 0xc3,
			0xc3, 0xa9, 0x39, 0xe6, 0x3b, 0x2c, 0x6a, 0xa7,
			0x00, 0x9a, 0xf6, 0x2c, 0xea, 0xe5, 0x98, 0x5e,
			0x05, 0xe8, 0xaa, 0x9d, 0xa3, 0x3f, 0x7d, 0xda,
			0x6a, 0xfe, 0x2b, 0x2d, 0xac, 0xf7, 0xc6, 0x76,
			0x27, 0xe1, 0xfb, 0xb7, 0xf6, 0x27, 0xad, 0x0a,
		},
	},
	/* SHA512256 [9] */
	{
		/* Msg9 : 128 byte */
		{
			0x5c, 0x8c, 0x2f, 0x1d, 0x7f, 0xc7, 0xda, 0x4e,
			0x9b, 0xa6, 0xe5, 0x75, 0x8b, 0xe7, 0x26, 0xe6,
			0xe2, 0x27, 0xd7, 0xbd, 0xdb, 0x03, 0x32, 0x22,
			0x8f, 0x7e, 0x3e, 0xcb, 0x6b, 0xa2, 0xe8, 0xc3,
			0xe0, 0x6b, 0x55, 0x6a, 0x5c, 0xe0, 0x77, 0xbe,
			0x7a, 0x83, 0xde, 0xd8, 0x76, 0xeb, 0xd1, 0xb9,
			0xe3, 0xb0, 0x9e, 0x47, 0xa0, 0x87, 0x2e, 0x93,
			0x08, 0xae, 0xdc, 0x5d, 0x69, 0x8b, 0x87, 0xda,
			0xb7, 0x90, 0xe6, 0xb5, 0x82, 0x61, 0x1c, 0x53,
			0x26, 0x39, 0x8d, 0x5b, 0x42, 0x8a, 0xef, 0x76,
			0x6b, 0xe3, 0xa4, 0x53, 0x21, 0x17, 0x47, 0xef,
			0x01, 0x9c, 0x85, 0x13, 0x3d, 0x31, 0x2e, 0x1e,
			0x4a, 0xc3, 0x8b, 0x04, 0xd8, 0x92, 0xf3, 0x97,
			0x07, 0x90, 0x99, 0x05, 0xd8, 0x09, 0xa8, 0xa2,
			0xe1, 0x89, 0x92, 0xe8, 0x46, 0xfb, 0xa4, 0xbc,
			0xe4, 0x0e, 0xdf, 0xf3, 0xcf, 0xdd, 0x03, 0x15,
		},
		/* S9 : 256 byte */
		{
			0xd1, 0xc0, 0x62, 0xa5, 0xca, 0xad, 0xe5, 0x1f,
			0xfc, 0x1b, 0x5d, 0xa0, 0xf5, 0xab, 0xa1, 0xc7,
			0x37, 0xb5, 0xb7, 0xb7, 0x45, 0xc8, 0xa3, 0xaf,
			0xbf, 0x8d, 0x14, 0x80, 0x6c, 0xad, 0x6e, 0x27,
			0x07, 0xd6, 0x64, 0xaa, 0x89, 0x26, 0x6d, 0xbc,
			0x1e, 0xd6, 0x81, 0x56, 0x59, 0xd8, 0x48, 0x1f,
			0xca, 0x83, 0x0e, 0x01, 0x91, 0x11, 0x96, 0x70,
			0xf3, 0x86, 0x95, 0x14, 0x20, 0xd7, 0x34, 0x7d,
			0x40, 0xf2, 0xe9, 0x4b, 0xda, 0x8e, 0x74, 0xdb,
			0x2d, 0x16, 0x9c, 0xa4, 0xc1, 0x69, 0xfc, 0xf6,
			0x3e, 0x49, 0xd0, 0x62, 0xf9, 0x6e, 0x7f, 0xa8,
			0x43, 0xf8, 0x50, 0x42, 0xa9, 0xe2, 0x91, 0xa1,
			0xc2, 0xf1, 0x46, 0x0c, 0x61, 0x69, 0xa5, 0x29,
			0x35, 0x5d, 0xd9, 0x51, 0xfc, 0x1a, 0xd3, 0x12,
			0xd6, 0xa7, 0x4d, 0x95, 0xab, 0x38, 0xbc, 0xe7,
			0x53, 0x32, 0x8f, 0x18, 0x1b, 0xfd, 0x69, 0x73,
			0x78, 0x79, 0x10, 0xb1, 0x7b, 0x31, 0xc8, 0x19,
			0xb2, 0xfa, 0x02, 0x76, 0x5f, 0xf7, 0x56, 0x7f,
			0xb9, 0x97, 0x41, 0xe1, 0xf2, 0x6a, 0x40, 0x0e,
			0x75, 0x4a, 0xe0, 0x1f, 0xfc, 0x2b, 0x1c, 0x1c,
			0xde, 0x69, 0xb0, 0x19, 0x98, 0x26, 0x97, 0xc4,
			0x71, 0xfc, 0x30, 0x91, 0xa6, 0x7c, 0x2f, 0x08,
			0xf6, 0x72, 0x81, 0x80, 0xb2, 0x2f, 0x79, 0x3c,
			0xdd, 0xed, 0x0c, 0x5e, 0xc1, 0x5c, 0xe6, 0x11,
			0xea, 0x35, 0x38, 0x86, 0xc9, 0x7b, 0xc4, 0x57,
			0x79, 0xfc, 0xb2, 0xac, 0x07, 0xa4, 0x08, 0x77,
			0xc1, 0x77, 0x1b, 0xba, 0x6b, 0x33, 0x7c, 0x70,
			0x6f, 0x67, 0x18, 0xd4, 0x0e, 0x1e, 0x75, 0x91,
			0xd5, 0xa0, 0x37, 0x1d, 0x2e, 0xe7, 0x00, 0x3c,
			0x08, 0x7c, 0xe9, 0x24, 0x4f, 0x56, 0x38, 0x1a,
			0x94, 0x31, 0xff, 0x56, 0xba, 0x8d, 0x60, 0xb1,
			0x70, 0xc1, 0x9e, 0x02, 0xd6, 0x5c, 0xd2, 0x26,
		},
	},
};

typedef mod2048_t tv_t;


#include "siggen15test.c"
