/* siggen15_2_2048_testfc.c */
/*
 * Copyright (c) 2017 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/index.html.
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */

/*
 * This test vector was created based on SigGen15_186-2.txt from
 * https://csrc.nist.gov/CSRC/media/Projects/Cryptographic-Algorithm-Validation-Program/documents/dss/186-2rsatestvectors.zip
 *
 * The link to the archive file exists in the following URL:
 * https://csrc.nist.gov/projects/cryptographic-algorithm-validation-program/digital-signatures/
 */
/*
 * https://csrc.nist.gov/projects/cryptographic-algorithm-validation-program/digital-signatures/
 * https://csrc.nist.gov/CSRC/media/Projects/Cryptographic-Algorithm-Validation-Program/documents/dss/186-2rsatestvectors.zip
 * SigGen15_186-2.txt
 */
#include "siggen15test.h"

static const unsigned short sn1[] = {
	0xe0b1, 0x4b99, 0xcd61, 0xcd3d, 0xb9c2, 0x0766, 0x6884, 0x1324,
	0xfa31, 0x74f3, 0x3ce6, 0x6ffd, 0x5143, 0x94d3, 0x4178, 0xd29a,
	0x4949, 0x3276, 0xb677, 0x7233, 0xe7d4, 0x6a3e, 0x68bc, 0x7ca7,
	0xe899, 0xe901, 0xd54f, 0x6dee, 0x0749, 0xc3e4, 0x8ddf, 0x6868,
	0x5867, 0xee2a, 0xe66d, 0xf88e, 0xb563, 0xf6db, 0x137a, 0x9f6b,
	0x175a, 0x112e, 0x0eda, 0x8368, 0xe88e, 0x45ef, 0xe1ce, 0x14bc,
	0x6016, 0xd526, 0x3962, 0x7066, 0xaf18, 0x72c7, 0x2f60, 0xb916,
	0x1c1d, 0x237e, 0xeb34, 0xb0f8, 0x41b3, 0xf089, 0x6f9f, 0xe0e1,
	0x6b0f, 0x7435, 0x2d10, 0x1292, 0xcc46, 0x4a7e, 0x7861, 0xbbeb,
	0x86f6, 0xdf61, 0x51cb, 0x2654, 0x17c6, 0x6c56, 0x5ed8, 0x974b,
	0xd8fc, 0x984d, 0x5ddf, 0xd4eb, 0x91a3, 0xd523, 0x4ce1, 0xb546,
	0x7f3a, 0xde37, 0x5f80, 0x2ec0, 0x7293, 0xf123, 0x6efa, 0x3068,
	0xbc91, 0xb158, 0x551c, 0x875c, 0x5dc0, 0xa9d6, 0xfa32, 0x1bf9,
	0x421f, 0x08de, 0xac91, 0x0e35, 0xc1c2, 0x8549, 0xee8e, 0xed83,
	0x30cf, 0x7059, 0x5ff7, 0x0b94, 0xb499, 0x07e2, 0x7698, 0xa9d9,
	0x11f7, 0xac07, 0x06af, 0xcb1a, 0x4a39, 0xfeb3, 0x8b0a, 0x8049,
};

static const unsigned short se1[] = {
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001,
};

static const unsigned short sd1[] = {
	0x1dbc, 0xa92e, 0x4245, 0xc2d5, 0x7bfb, 0xa762, 0x10cc, 0x0602,
	0x9b50, 0x2753, 0xb7c8, 0x21a3, 0x2b79, 0x9fbd, 0x33c9, 0x8b49,
	0xdb10, 0x226b, 0x1eac, 0x0143, 0xc857, 0x4ef6, 0x5283, 0x3b96,
	0x374d, 0x034e, 0xf84d, 0xaa55, 0x59c6, 0x93f3, 0xf028, 0xd497,
	0x16b8, 0x2e87, 0xa3f6, 0x82f2, 0x5424, 0x563b, 0xd940, 0x9dcf,
	0x9d08, 0x1105, 0x00f7, 0x3f74, 0x076f, 0x28e7, 0x5e01, 0x99b1,
	0xf29f, 0xa2f7, 0x0b9a, 0x3119, 0x0dec, 0x54e8, 0x72a7, 0x40e7,
	0xa1b1, 0xe38c, 0x3d11, 0xbca8, 0x267d, 0xeb84, 0x2cef, 0x4262,
	0x237a, 0xc875, 0x7250, 0x68f3, 0x2563, 0xb478, 0xaca8, 0xd6a9,
	0x9f34, 0xcb88, 0x76b9, 0x7145, 0xb2e8, 0x529e, 0xc8ad, 0xea83,
	0xead4, 0xec63, 0xe3ff, 0x2d17, 0xa2ff, 0xefb0, 0x5c90, 0x2ca7,
	0xa921, 0x6837, 0x8c89, 0xf75c, 0x928f, 0xc4f0, 0x707e, 0x4348,
	0x7a4f, 0x47df, 0x70ca, 0xe87e, 0x2427, 0x2c13, 0x6d3e, 0x98cf,
	0x5906, 0x6d41, 0xa3d0, 0x3885, 0x7d07, 0x3d8b, 0x4d2c, 0x27b8,
	0xf0ea, 0x6bfa, 0x50d2, 0x6309, 0x1a4a, 0x18c6, 0x3f44, 0x6bc9,
	0xa61e, 0x8c4a, 0x6883, 0x47b2, 0x435e, 0xc8e7, 0x2edd, 0xaea7,
};

#define HAS_SHA1_TESTVECTOR

#define HAS_SHA224_TESTVECTOR

#define HAS_SHA256_TESTVECTOR

#define HAS_SHA384_TESTVECTOR

#define HAS_SHA512_TESTVECTOR

/* 10 elements */
static mod2048_t SHA1[] = {
	/* SHA1 [0] */
	{
		/* Msg0 : 128 byte */
		{
			0x54, 0x4b, 0xe0, 0xa4, 0x04, 0x4e, 0xdc, 0xdc,
			0x12, 0x40, 0xf2, 0x18, 0x21, 0x09, 0xf8, 0x26,
			0xd7, 0x84, 0xea, 0x61, 0x34, 0x86, 0xdf, 0xd5,
			0x22, 0x1d, 0x3b, 0xa4, 0x4d, 0x15, 0x25, 0xa9,
			0x34, 0xc1, 0x3c, 0x5a, 0x81, 0xf8, 0x85, 0xf3,
			0x95, 0x5d, 0xa8, 0xd1, 0x68, 0xe3, 0x5d, 0x1b,
			0x90, 0x91, 0x21, 0xa8, 0x9f, 0x83, 0x2d, 0x1d,
			0xb2, 0x32, 0xa8, 0x56, 0x47, 0xf5, 0x1c, 0x08,
			0x4f, 0xc7, 0x27, 0xa4, 0x85, 0x4a, 0x73, 0x7e,
			0xfd, 0x0c, 0xe7, 0x2e, 0x00, 0x09, 0x1f, 0x36,
			0x17, 0x72, 0x1a, 0xe6, 0x66, 0xad, 0x33, 0x7d,
			0x3b, 0x9d, 0x53, 0x91, 0xe7, 0x23, 0x64, 0xb1,
			0xcd, 0xe5, 0x09, 0x48, 0xb8, 0x4e, 0x8c, 0xc4,
			0x72, 0xd6, 0x18, 0xf8, 0x92, 0x83, 0x28, 0xbf,
			0x95, 0xaf, 0x3f, 0xe3, 0x30, 0x0d, 0xda, 0x3d,
			0xe5, 0xe7, 0xa2, 0x1d, 0xd5, 0xa9, 0xe7, 0xec,
		},
		/* S0 : 256 byte */
		{
			0xd0, 0xd0, 0x3c, 0xcb, 0x3b, 0x30, 0xb7, 0xc9,
			0xc4, 0xd6, 0xee, 0xee, 0x2e, 0xc2, 0x6d, 0x06,
			0x92, 0x46, 0xe0, 0x19, 0xfb, 0x8f, 0xa2, 0xf3,
			0xa9, 0xb7, 0x2c, 0x9b, 0xbe, 0x23, 0x1d, 0x93,
			0xce, 0x05, 0x3d, 0xf8, 0x05, 0xa0, 0x45, 0xe2,
			0xef, 0x6b, 0xd8, 0xd0, 0x8b, 0xfb, 0x0c, 0x36,
			0x92, 0x2e, 0x5a, 0x6f, 0x10, 0xb9, 0x47, 0xb2,
			0x60, 0x7f, 0x59, 0x6b, 0x6c, 0xbd, 0x3c, 0x9e,
			0xef, 0xef, 0x56, 0xf5, 0x39, 0x68, 0x05, 0xe8,
			0xb2, 0x8b, 0x1c, 0xa1, 0x82, 0xc7, 0x8c, 0x0b,
			0x12, 0xb9, 0x79, 0x6a, 0xa8, 0x56, 0xaf, 0x69,
			0xc3, 0x55, 0x04, 0xf8, 0xac, 0xc7, 0xaf, 0xa7,
			0x4b, 0xc0, 0xf7, 0x7a, 0x1d, 0x61, 0xda, 0x94,
			0x94, 0x40, 0x57, 0xa9, 0xee, 0x72, 0xd2, 0xf0,
			0xa9, 0x6c, 0xba, 0xa2, 0xf6, 0x46, 0x76, 0xf5,
			0x31, 0x8b, 0x71, 0xe5, 0x6f, 0x51, 0x9d, 0x0d,
			0xa1, 0xce, 0x8f, 0x42, 0xdb, 0x0e, 0xbe, 0x50,
			0x45, 0xfc, 0xc7, 0x26, 0xe3, 0x9f, 0xb0, 0x03,
			0x2f, 0x22, 0x87, 0x91, 0x8f, 0x91, 0x90, 0xf3,
			0xfb, 0x3d, 0x4d, 0xe5, 0x42, 0x03, 0x04, 0x41,
			0xf6, 0x73, 0x6c, 0x62, 0x05, 0xa2, 0xbc, 0xd2,
			0x45, 0x0e, 0xb4, 0x11, 0x08, 0x53, 0x11, 0xc7,
			0x32, 0x0b, 0xaa, 0x42, 0x68, 0xfd, 0x2f, 0xd8,
			0xbc, 0xc8, 0xeb, 0xfd, 0xdb, 0xb6, 0x07, 0x40,
			0xcf, 0xf0, 0xb3, 0xb0, 0x0f, 0x61, 0x87, 0x77,
			0xeb, 0xcf, 0xb3, 0x46, 0x8f, 0x30, 0x9d, 0x92,
			0x3c, 0x95, 0x7c, 0x81, 0x70, 0x72, 0x7a, 0x54,
			0x58, 0xac, 0x2c, 0x90, 0x70, 0xf9, 0x3c, 0xfc,
			0x37, 0xd3, 0x1c, 0xf9, 0xf1, 0xa3, 0x5d, 0x0c,
			0xc3, 0xab, 0xf2, 0x5a, 0xf8, 0xdc, 0x9e, 0x15,
			0x90, 0xce, 0x59, 0xab, 0x39, 0xd0, 0x1c, 0xf0,
			0xc1, 0x54, 0xab, 0x8d, 0x06, 0x35, 0xc5, 0xe9,
		},
	},
	/* SHA1 [1] */
	{
		/* Msg1 : 128 byte */
		{
			0x8a, 0x66, 0x37, 0x09, 0x70, 0x92, 0x5d, 0xda,
			0x75, 0x60, 0x9a, 0x71, 0x0a, 0xd1, 0xfa, 0x75,
			0xd0, 0x4e, 0x52, 0x3c, 0x50, 0x8f, 0x8c, 0xd6,
			0xec, 0xbd, 0x3f, 0x4d, 0x15, 0xd3, 0x83, 0x2b,
			0xbf, 0x4a, 0x03, 0x3d, 0x12, 0xf5, 0x53, 0x97,
			0x63, 0x2a, 0x84, 0xd8, 0x62, 0x22, 0xf6, 0xaf,
			0x95, 0xa2, 0x6e, 0x9e, 0x05, 0xdb, 0x68, 0xfe,
			0x37, 0x90, 0xaf, 0x44, 0x5d, 0x76, 0x2a, 0x82,
			0xce, 0xe0, 0xf9, 0x31, 0xb4, 0x9b, 0xc1, 0x2d,
			0x04, 0x17, 0x43, 0x01, 0xb4, 0xc8, 0x34, 0x65,
			0x28, 0xcc, 0x48, 0x05, 0xed, 0xce, 0x91, 0x84,
			0xa9, 0x2a, 0x07, 0xc1, 0x52, 0x52, 0x68, 0x59,
			0x9f, 0x70, 0x42, 0x6d, 0xbc, 0x4d, 0x4d, 0xa5,
			0x42, 0x71, 0xff, 0x74, 0x66, 0x8c, 0x5b, 0x9e,
			0x71, 0x14, 0x0a, 0xf8, 0x70, 0x30, 0xac, 0x6f,
			0x2c, 0xd5, 0x70, 0x4c, 0x5c, 0x2e, 0xe2, 0xb7,
		},
		/* S1 : 256 byte */
		{
			0x16, 0xda, 0x73, 0x0c, 0x7e, 0xe6, 0xf3, 0xf9,
			0x75, 0x0a, 0xa3, 0x12, 0x0f, 0x73, 0x4f, 0x78,
			0x00, 0xf2, 0xcb, 0xf7, 0x24, 0x7c, 0x18, 0x0f,
			0x1a, 0x49, 0x0e, 0xee, 0xf5, 0xdc, 0x63, 0x7d,
			0xd2, 0xda, 0x57, 0x7c, 0xb2, 0xf4, 0x14, 0x64,
			0xad, 0xea, 0xda, 0xbc, 0xbc, 0x73, 0x24, 0x77,
			0x9a, 0x2b, 0x11, 0x8c, 0x0c, 0x61, 0xc2, 0x82,
			0x9b, 0x55, 0x79, 0x7d, 0xe6, 0xa3, 0xb0, 0x92,
			0xae, 0xea, 0x44, 0x4d, 0x2b, 0x40, 0x80, 0xf1,
			0x56, 0x14, 0xe9, 0xda, 0x6e, 0xea, 0x17, 0x55,
			0x2a, 0x8e, 0x95, 0x5f, 0xce, 0xc1, 0x87, 0x3c,
			0xd2, 0x0b, 0xfe, 0xd8, 0xed, 0x2d, 0x63, 0xa9,
			0x50, 0xb1, 0x59, 0xa0, 0xac, 0x10, 0x9d, 0xf3,
			0x70, 0xdd, 0xea, 0x77, 0x3a, 0x71, 0x49, 0xf1,
			0x89, 0x3c, 0xda, 0x82, 0xd8, 0x4a, 0xce, 0x35,
			0xb6, 0x5b, 0x3f, 0xa9, 0xf7, 0xe4, 0xce, 0xbe,
			0xc8, 0xe2, 0x19, 0xba, 0x9a, 0x12, 0xfa, 0xc5,
			0xcf, 0x5b, 0x24, 0x49, 0xcb, 0x6d, 0x56, 0x3d,
			0x8a, 0x64, 0x6f, 0x1d, 0x64, 0x9d, 0xc9, 0xab,
			0xea, 0xc8, 0x29, 0xa3, 0xce, 0x8f, 0x98, 0x23,
			0xcb, 0x70, 0x87, 0x71, 0x93, 0x69, 0x08, 0x55,
			0x38, 0x95, 0x57, 0xad, 0xbd, 0xbe, 0xde, 0x90,
			0xdf, 0x0c, 0x27, 0x49, 0x86, 0xf0, 0x97, 0x96,
			0xab, 0xc2, 0xa2, 0xb1, 0x6f, 0x7c, 0x8c, 0x6e,
			0xb5, 0xb3, 0xa4, 0x2b, 0x09, 0x58, 0xc3, 0xda,
			0x16, 0xbc, 0x36, 0x3e, 0xd4, 0x5d, 0xe4, 0xff,
			0x43, 0x57, 0xdd, 0x8c, 0x20, 0x42, 0x1e, 0x4c,
			0x30, 0x07, 0xf9, 0xb9, 0x8c, 0x86, 0xa8, 0x0e,
			0x7a, 0xd0, 0x10, 0x6a, 0xea, 0x05, 0x9a, 0xcb,
			0x71, 0xed, 0x2d, 0x81, 0xeb, 0x6f, 0x0d, 0xd7,
			0x58, 0xbd, 0xd9, 0xd5, 0x08, 0xcc, 0x46, 0x5e,
			0x23, 0x40, 0x4a, 0xeb, 0x08, 0xe4, 0xdd, 0xc5,
		},
	},
	/* SHA1 [2] */
	{
		/* Msg2 : 128 byte */
		{
			0xa8, 0xf4, 0x1a, 0xf4, 0x33, 0xff, 0x31, 0x4d,
			0x93, 0xe0, 0xd1, 0xe0, 0xbc, 0x05, 0xc4, 0x27,
			0xcb, 0x68, 0x26, 0x97, 0xf6, 0xb7, 0x05, 0xdd,
			0xc3, 0xb3, 0x2a, 0x67, 0x79, 0xd6, 0x35, 0x26,
			0xd4, 0x38, 0xf0, 0x92, 0xfd, 0xb3, 0xdd, 0xef,
			0xb9, 0x45, 0x11, 0xcf, 0xe1, 0xb7, 0x45, 0xd9,
			0x12, 0x7c, 0x2b, 0xc8, 0xa5, 0xdc, 0xfe, 0xb7,
			0xe2, 0x52, 0x5d, 0x9b, 0x70, 0x32, 0x59, 0x11,
			0x10, 0x8e, 0xcd, 0x5a, 0x8c, 0x5b, 0xee, 0xa3,
			0xe9, 0xd0, 0x22, 0x8a, 0xe4, 0x0f, 0x16, 0xdf,
			0x9d, 0x07, 0x0a, 0xa7, 0x8d, 0x99, 0x70, 0x67,
			0xbd, 0xf9, 0xb6, 0x9f, 0x3a, 0x58, 0x60, 0x94,
			0xc4, 0xc0, 0x59, 0x52, 0xc6, 0x3f, 0x8b, 0xf2,
			0x8b, 0x47, 0xad, 0x19, 0xae, 0x55, 0x5c, 0xc1,
			0xd2, 0xd1, 0x6e, 0x3c, 0x94, 0x35, 0x83, 0x75,
			0xbe, 0x72, 0xdc, 0x7a, 0xbd, 0x90, 0x71, 0x37,
		},
		/* S2 : 256 byte */
		{
			0x2d, 0x69, 0xd0, 0x8b, 0xb9, 0xb9, 0x9a, 0x17,
			0x3a, 0x69, 0xa3, 0x22, 0x1c, 0x28, 0x95, 0x81,
			0x61, 0xf5, 0xde, 0xfd, 0x55, 0x92, 0xe3, 0xef,
			0x5c, 0xf0, 0xef, 0x21, 0xf0, 0x4e, 0xf7, 0xe1,
			0x99, 0x34, 0x44, 0x57, 0xb3, 0x63, 0x20, 0x6b,
			0xc2, 0x78, 0x51, 0x97, 0x48, 0x9a, 0xa8, 0x3d,
			0x0b, 0x33, 0x06, 0x18, 0xb5, 0xd5, 0x8e, 0xdc,
			0x9f, 0xfc, 0xa4, 0x26, 0x8a, 0x10, 0x58, 0xc4,
			0xb1, 0xd1, 0xfd, 0xb3, 0x9e, 0xa2, 0xa1, 0xaf,
			0xcf, 0x20, 0x24, 0xda, 0x3c, 0x9e, 0x1f, 0x98,
			0x20, 0xe6, 0x57, 0x21, 0xdb, 0x4a, 0x0a, 0xcc,
			0xc7, 0x72, 0x54, 0x29, 0x12, 0x39, 0xc8, 0x3b,
			0x46, 0xfd, 0x3a, 0xf6, 0xab, 0x14, 0xaa, 0x2e,
			0x8c, 0x4e, 0x14, 0x0f, 0x75, 0x17, 0x44, 0xbf,
			0xa7, 0x31, 0xd2, 0xbe, 0xbc, 0x33, 0xd3, 0x03,
			0x88, 0xf1, 0x40, 0xe8, 0x11, 0x1c, 0xe1, 0xf7,
			0xa0, 0x90, 0x00, 0x5d, 0x78, 0xb4, 0x8f, 0xea,
			0xed, 0xc0, 0x05, 0x98, 0x97, 0xe3, 0x38, 0x4a,
			0x3a, 0x31, 0x27, 0x0e, 0xec, 0xaa, 0xbf, 0x45,
			0x5f, 0x60, 0xb8, 0x37, 0x76, 0x19, 0xcd, 0xd7,
			0x94, 0x84, 0xc2, 0x92, 0x56, 0x2a, 0x46, 0x1e,
			0xa9, 0x67, 0x74, 0xe9, 0x88, 0x32, 0x53, 0xd6,
			0x11, 0xdd, 0x4e, 0x7b, 0x26, 0xaf, 0x83, 0xd1,
			0x9d, 0x74, 0x0c, 0xd4, 0x1f, 0x26, 0xd2, 0x8e,
			0xae, 0x5d, 0x20, 0xa8, 0x5d, 0x16, 0xb3, 0x74,
			0xb9, 0x91, 0xb0, 0x31, 0x41, 0xba, 0x87, 0xc7,
			0x5d, 0xa6, 0xd2, 0x38, 0x18, 0xf5, 0x09, 0xa2,
			0x54, 0x7f, 0x2c, 0x34, 0x99, 0xee, 0xb4, 0x8d,
			0xd4, 0x83, 0x63, 0xf3, 0xf8, 0x0b, 0xf1, 0x5f,
			0x2e, 0x23, 0x28, 0x11, 0x69, 0x40, 0xa0, 0xc3,
			0xf4, 0xd4, 0xca, 0x67, 0x26, 0xc9, 0x28, 0x14,
			0xbb, 0xfd, 0x94, 0xeb, 0xad, 0xe8, 0x49, 0xba,
		},
	},
	/* SHA1 [3] */
	{
		/* Msg3 : 128 byte */
		{
			0x90, 0x44, 0xd1, 0x99, 0xa8, 0x37, 0x83, 0x25,
			0x58, 0x65, 0x7f, 0xdf, 0x67, 0xc8, 0xea, 0x22,
			0x4f, 0x41, 0x31, 0x7e, 0xef, 0x7f, 0x54, 0xba,
			0x84, 0x22, 0x85, 0x19, 0xd6, 0x20, 0xf1, 0xdd,
			0xaf, 0x68, 0xde, 0x0a, 0x91, 0xc6, 0xf6, 0x6c,
			0xa8, 0x07, 0xe2, 0xdb, 0xfe, 0x5d, 0x1b, 0xbe,
			0xee, 0x05, 0xfd, 0xce, 0xdb, 0x26, 0x1e, 0x1d,
			0x22, 0xfd, 0xdd, 0x56, 0x4c, 0x37, 0x3e, 0x46,
			0x89, 0x9e, 0xf5, 0x9b, 0x5a, 0xf8, 0xc0, 0xec,
			0x8d, 0x2c, 0xfa, 0xfa, 0x6e, 0xa7, 0x6e, 0x36,
			0x3c, 0xfe, 0x69, 0x83, 0xda, 0xd5, 0x13, 0x3c,
			0xc7, 0xff, 0xfe, 0x79, 0x50, 0xe7, 0x00, 0x8e,
			0x04, 0x2e, 0x3e, 0xd5, 0x69, 0x95, 0x8a, 0xae,
			0xed, 0x1e, 0xef, 0xc3, 0x1f, 0x6e, 0x89, 0x91,
			0x1f, 0x76, 0x9a, 0x24, 0x53, 0x52, 0xdb, 0x21,
			0x5c, 0x71, 0x10, 0x0a, 0x49, 0xf7, 0xdf, 0xbe,
		},
		/* S3 : 256 byte */
		{
			0x17, 0x6f, 0xba, 0xea, 0x69, 0xc5, 0x99, 0xca,
			0xf9, 0x46, 0xfc, 0x65, 0x7b, 0x1f, 0xc9, 0x58,
			0x56, 0x5e, 0xf3, 0x19, 0x59, 0x31, 0x84, 0x3d,
			0xcf, 0xe5, 0x03, 0x1b, 0x15, 0xd4, 0xc7, 0xa9,
			0x6c, 0x00, 0x5d, 0xa1, 0x5f, 0x6f, 0x65, 0x50,
			0xe5, 0xc4, 0x26, 0xec, 0x91, 0xc8, 0x71, 0xb1,
			0xc8, 0xdd, 0x08, 0x68, 0xcf, 0xd1, 0xde, 0x3b,
			0x79, 0x01, 0xce, 0x6c, 0x16, 0xfa, 0x2d, 0x39,
			0xb1, 0xca, 0xeb, 0x3a, 0x47, 0x97, 0x41, 0x89,
			0x3e, 0x81, 0x65, 0x91, 0x0b, 0x46, 0xf0, 0x7a,
			0x9a, 0xcb, 0x29, 0xd3, 0xa7, 0xb8, 0x2e, 0xe6,
			0xa1, 0xe0, 0x6b, 0xf4, 0x41, 0x55, 0xa8, 0xfc,
			0x02, 0x54, 0x80, 0xfe, 0x49, 0x5e, 0xab, 0xce,
			0x19, 0xe6, 0x72, 0x8c, 0x5f, 0x3d, 0x81, 0x2b,
			0x32, 0xa7, 0xa1, 0x4d, 0xfe, 0x79, 0x92, 0x53,
			0x51, 0x08, 0x24, 0x06, 0xe1, 0x4c, 0x7f, 0x59,
			0x1d, 0x93, 0x1f, 0x1c, 0x51, 0x49, 0x80, 0xe9,
			0x64, 0x69, 0x1a, 0x51, 0xe2, 0x04, 0x4e, 0xbb,
			0x82, 0xc4, 0x0e, 0xaa, 0xce, 0x62, 0xff, 0x74,
			0xeb, 0x66, 0xb2, 0xdb, 0xfc, 0x15, 0xa0, 0x8e,
			0xa4, 0x8c, 0x7a, 0x2a, 0x11, 0x0f, 0xc4, 0x02,
			0xb7, 0xa6, 0x8c, 0xf0, 0x39, 0xc8, 0xea, 0xaf,
			0x43, 0x7d, 0x56, 0x42, 0xa3, 0x51, 0x1d, 0x36,
			0xbc, 0x12, 0xf9, 0x6c, 0xb5, 0xb6, 0xcf, 0xf4,
			0x7c, 0x56, 0x14, 0xef, 0x7c, 0xc2, 0xbe, 0x1f,
			0x13, 0x90, 0x47, 0xa7, 0xc5, 0xdb, 0xfb, 0x1d,
			0x70, 0x18, 0xfb, 0x88, 0x57, 0x21, 0x66, 0x62,
			0xd3, 0xf5, 0xaf, 0x3f, 0x7e, 0x1c, 0xc6, 0x96,
			0xe9, 0xb1, 0xec, 0x95, 0x82, 0x95, 0x21, 0x84,
			0x48, 0xe1, 0x96, 0x25, 0xa1, 0xe6, 0x5a, 0xe9,
			0x2b, 0xe6, 0xd6, 0x0f, 0xde, 0x3d, 0x2e, 0x6a,
			0x0b, 0x30, 0x93, 0xef, 0xcc, 0x77, 0x54, 0xc9,
		},
	},
	/* SHA1 [4] */
	{
		/* Msg4 : 128 byte */
		{
			0xb7, 0x96, 0xc3, 0x4f, 0x1d, 0x4e, 0x1d, 0xfb,
			0x30, 0x10, 0x28, 0x2b, 0xee, 0x33, 0xeb, 0x9d,
			0xa9, 0x0e, 0x73, 0xf7, 0xff, 0x18, 0x6b, 0x0c,
			0x0d, 0x4e, 0xed, 0x5b, 0xe0, 0xd5, 0x98, 0xd8,
			0x2c, 0xe1, 0xe3, 0xf0, 0x41, 0xd5, 0xb0, 0xc7,
			0x3a, 0xac, 0x25, 0xc4, 0x78, 0x97, 0xb7, 0x4f,
			0x4f, 0xe7, 0x87, 0xd9, 0xfe, 0x2e, 0xf2, 0x1d,
			0xe5, 0xa1, 0x63, 0xa6, 0xf2, 0xc1, 0x6c, 0x92,
			0x5d, 0x3b, 0x16, 0x95, 0x95, 0x0c, 0x75, 0x41,
			0x7a, 0xe8, 0x7f, 0x84, 0xcc, 0xdd, 0x1e, 0x72,
			0xe3, 0x34, 0x83, 0x44, 0xa1, 0x98, 0xbe, 0xa1,
			0xa6, 0x7a, 0x8b, 0x1d, 0xc2, 0xb3, 0x6f, 0x00,
			0xb0, 0x6b, 0x04, 0x48, 0x01, 0x3a, 0x91, 0xf1,
			0x56, 0x8e, 0xde, 0x73, 0xd2, 0x4d, 0x47, 0x8d,
			0xcf, 0xbb, 0x0e, 0x41, 0xd0, 0x9d, 0xf6, 0x20,
			0xb7, 0x9f, 0x0d, 0xc7, 0x39, 0xf3, 0xc9, 0xaa,
		},
		/* S4 : 256 byte */
		{
			0x9e, 0x32, 0x4f, 0x82, 0x7c, 0xa1, 0x7e, 0x50,
			0xfb, 0x0c, 0xd1, 0x7b, 0x8f, 0x71, 0x4d, 0x7d,
			0xa1, 0x92, 0x8e, 0x1c, 0x58, 0x6a, 0x83, 0xd4,
			0x37, 0xe9, 0x89, 0x1c, 0x78, 0x66, 0x44, 0x63,
			0x8a, 0xf2, 0x25, 0xe9, 0x28, 0x41, 0xca, 0x1d,
			0xf6, 0xd9, 0x4e, 0x6e, 0xed, 0x65, 0xb5, 0xf0,
			0x76, 0xca, 0xe3, 0xae, 0xb9, 0x7a, 0xc9, 0x6f,
			0x00, 0x3a, 0xdd, 0xde, 0xf6, 0xce, 0xbe, 0x80,
			0xde, 0x99, 0xc5, 0x84, 0x84, 0x9a, 0x1c, 0x18,
			0x32, 0x81, 0x3c, 0xbb, 0x63, 0xfc, 0x61, 0x90,
			0x79, 0x25, 0x2a, 0xd4, 0xd8, 0x88, 0x1e, 0xf7,
			0x2e, 0x63, 0x0e, 0xa0, 0x6f, 0xb3, 0xb0, 0xe1,
			0xb5, 0x1b, 0xfa, 0x37, 0x9b, 0x1d, 0xec, 0xfb,
			0x92, 0xe9, 0x64, 0xcd, 0xc6, 0x88, 0x09, 0xaf,
			0xb9, 0xd5, 0x3b, 0x3c, 0x43, 0xda, 0xd1, 0x19,
			0xba, 0x67, 0xb5, 0xec, 0x1a, 0xce, 0x10, 0x93,
			0xfe, 0x2e, 0x14, 0x4d, 0x49, 0x8b, 0x81, 0x12,
			0x5f, 0xa6, 0x9b, 0x51, 0x81, 0x4f, 0xa3, 0xc1,
			0x23, 0x0f, 0x0b, 0x42, 0xf9, 0xd7, 0x76, 0x3b,
			0x14, 0x47, 0xec, 0x57, 0xbd, 0x0d, 0x93, 0xa9,
			0x6a, 0x89, 0x28, 0xbb, 0x7f, 0x45, 0x60, 0xbe,
			0x95, 0xfc, 0x10, 0x0d, 0xc6, 0x43, 0x06, 0x74,
			0x10, 0x75, 0x11, 0xf7, 0xf4, 0x66, 0xa1, 0x8f,
			0xe1, 0x02, 0xa7, 0xbb, 0x0c, 0x35, 0x36, 0xee,
			0x9d, 0x3a, 0x7c, 0x45, 0x63, 0x11, 0x53, 0xcc,
			0xcf, 0x77, 0x4f, 0xa6, 0x5f, 0x20, 0xd0, 0x7a,
			0x52, 0x55, 0xa0, 0x90, 0x2d, 0x4d, 0xd3, 0xc9,
			0x1c, 0xda, 0x03, 0xc0, 0x77, 0x8d, 0xd7, 0x27,
			0x8b, 0xee, 0xab, 0x6a, 0xfb, 0x93, 0xcb, 0xce,
			0x0c, 0x9f, 0xd6, 0xb2, 0x02, 0xd5, 0x7d, 0x81,
			0x1d, 0xd7, 0xee, 0x50, 0x33, 0x1f, 0x72, 0x43,
			0x16, 0x8d, 0xf1, 0x07, 0x59, 0x7d, 0x25, 0xa6,
		},
	},
	/* SHA1 [5] */
	{
		/* Msg5 : 128 byte */
		{
			0x4b, 0x63, 0x08, 0xbe, 0x5b, 0x3d, 0x99, 0xee,
			0x67, 0x85, 0xbc, 0xce, 0x25, 0x66, 0x04, 0x7a,
			0xd9, 0x6a, 0xdf, 0x76, 0x80, 0xe2, 0x6b, 0x36,
			0x4e, 0x87, 0x8b, 0xe4, 0x5b, 0x61, 0x3b, 0x5d,
			0x9a, 0xe8, 0x20, 0x7d, 0x0a, 0x6a, 0x63, 0x9c,
			0x30, 0xac, 0xc0, 0x58, 0xc4, 0xd4, 0xda, 0x95,
			0xab, 0x86, 0xd2, 0xc3, 0x25, 0x4e, 0x17, 0x60,
			0x48, 0x3e, 0x80, 0xbd, 0xad, 0xd8, 0x98, 0x04,
			0x69, 0x2e, 0x39, 0x7a, 0x3e, 0x47, 0x5c, 0x02,
			0x13, 0xc5, 0x2f, 0xe3, 0xa2, 0xc5, 0x68, 0xca,
			0x71, 0x07, 0xd9, 0x13, 0x03, 0x4f, 0x45, 0x44,
			0x4f, 0x0a, 0x73, 0xda, 0x71, 0x35, 0x80, 0x49,
			0xa0, 0x7b, 0x79, 0x3e, 0x60, 0x9d, 0x2a, 0x27,
			0xf8, 0x17, 0x30, 0xf5, 0x27, 0x01, 0x56, 0x20,
			0x13, 0x33, 0x1e, 0xec, 0x82, 0xac, 0x9d, 0xec,
			0x4c, 0x35, 0x8c, 0xc4, 0x11, 0x41, 0x9d, 0x32,
		},
		/* S5 : 256 byte */
		{
			0xac, 0x40, 0x2c, 0xa5, 0x8c, 0x3a, 0x5e, 0x42,
			0xba, 0xfb, 0x21, 0x35, 0x50, 0x3a, 0x17, 0x61,
			0x74, 0xcf, 0x1b, 0xb8, 0x6d, 0x5b, 0xc4, 0xa5,
			0xd7, 0xf6, 0xb3, 0xe4, 0x12, 0x51, 0xc0, 0xa6,
			0x17, 0x9d, 0xf8, 0x69, 0x6b, 0xf4, 0x18, 0xac,
			0x2e, 0xbb, 0x52, 0x68, 0x2a, 0x8b, 0x5f, 0x3c,
			0xd2, 0x3f, 0x0e, 0x1a, 0xfb, 0x58, 0xc8, 0xb1,
			0x99, 0x6d, 0x48, 0x6b, 0x90, 0xbf, 0xdf, 0x6d,
			0x7c, 0x1e, 0x5e, 0x25, 0x57, 0x5a, 0xe5, 0xb3,
			0x70, 0xea, 0x34, 0x37, 0xd5, 0x4a, 0x2f, 0x98,
			0xf9, 0x6d, 0x99, 0xac, 0x60, 0x1f, 0xbb, 0x93,
			0xdc, 0x81, 0xc7, 0x31, 0xfa, 0x10, 0xa6, 0x15,
			0x8b, 0xaa, 0xf0, 0x40, 0xfe, 0x57, 0x18, 0x4f,
			0xa7, 0x9a, 0xf7, 0xa4, 0xea, 0x36, 0x06, 0xb0,
			0x8b, 0x32, 0x9c, 0xa4, 0x55, 0xf3, 0x5c, 0xdf,
			0x5c, 0xae, 0x9a, 0x97, 0x91, 0xe8, 0xd7, 0x0f,
			0x03, 0xed, 0x82, 0x26, 0x03, 0x1d, 0x7d, 0xe3,
			0x52, 0xec, 0x4b, 0x99, 0x9e, 0x11, 0x3c, 0x23,
			0xe9, 0xec, 0x16, 0xcc, 0xe9, 0xab, 0x1b, 0xaf,
			0x49, 0xca, 0x09, 0x0a, 0xbf, 0x00, 0x93, 0x89,
			0x56, 0x1d, 0x25, 0x01, 0x39, 0x63, 0xf9, 0x3d,
			0x18, 0x2c, 0x1b, 0x8e, 0x3a, 0xb6, 0xd8, 0xc5,
			0x63, 0xe6, 0xf8, 0xeb, 0xba, 0x12, 0x52, 0x81,
			0xe9, 0x3a, 0x1f, 0x5b, 0x84, 0xf3, 0x70, 0xeb,
			0xb5, 0x1b, 0x03, 0xe3, 0x62, 0x12, 0x69, 0x7b,
			0x32, 0xb7, 0xc2, 0x72, 0xf6, 0xe4, 0xdc, 0x0b,
			0xe8, 0x63, 0x64, 0x02, 0x0b, 0x65, 0x9b, 0x1d,
			0xcb, 0x36, 0x04, 0x32, 0x2a, 0xf2, 0xd5, 0x12,
			0x2e, 0x3b, 0x6b, 0x68, 0xcb, 0x26, 0xec, 0x8a,
			0xbb, 0x4e, 0xad, 0x01, 0xf9, 0xb1, 0x3d, 0x8a,
			0x1a, 0x7d, 0xb2, 0x93, 0x31, 0xb1, 0xce, 0x9b,
			0x56, 0x01, 0x58, 0xb4, 0xd8, 0x9b, 0xb9, 0x61,
		},
	},
	/* SHA1 [6] */
	{
		/* Msg6 : 128 byte */
		{
			0x69, 0x3b, 0x32, 0x35, 0xe6, 0x57, 0x6d, 0x1f,
			0x9d, 0x17, 0xb9, 0xd2, 0x00, 0xb9, 0xb2, 0x89,
			0x30, 0x6a, 0x1f, 0x03, 0xc0, 0xff, 0xd2, 0xd7,
			0xbc, 0xe5, 0xd0, 0x08, 0xe9, 0x5b, 0xb2, 0xd9,
			0x4f, 0xde, 0x4b, 0xe2, 0xf5, 0xe5, 0x8b, 0x64,
			0xec, 0xcf, 0xa3, 0xda, 0x8e, 0x1a, 0x6a, 0xd0,
			0x08, 0xd5, 0x00, 0xf8, 0x16, 0x58, 0xb1, 0x7b,
			0x0e, 0x32, 0x1c, 0x8d, 0x20, 0x63, 0x94, 0x44,
			0xdc, 0xcc, 0xc6, 0xaa, 0xf4, 0xe3, 0x9c, 0x11,
			0x44, 0xab, 0x62, 0xa6, 0x0f, 0xe4, 0x28, 0x49,
			0x8c, 0x7e, 0x67, 0x9c, 0xa1, 0x54, 0xe7, 0x5a,
			0xee, 0x17, 0xdf, 0xeb, 0x0d, 0x88, 0x5f, 0x35,
			0x18, 0xeb, 0xeb, 0xb4, 0x6c, 0xb8, 0x68, 0xcd,
			0xad, 0x93, 0x3d, 0x5f, 0x0b, 0x7e, 0xb2, 0x9c,
			0xc3, 0x4e, 0x9b, 0x17, 0xe8, 0x5b, 0x3b, 0x1d,
			0x63, 0x7c, 0x63, 0x49, 0x39, 0x33, 0xda, 0x53,
		},
		/* S6 : 256 byte */
		{
			0x54, 0xb7, 0x8b, 0xec, 0x48, 0x55, 0x76, 0x5b,
			0x4c, 0x51, 0x92, 0x57, 0x78, 0xab, 0xcc, 0x02,
			0x75, 0xb6, 0xe9, 0xf5, 0x54, 0x19, 0xbb, 0x54,
			0xad, 0x66, 0xf0, 0xd8, 0xe7, 0xf3, 0xcf, 0x68,
			0xcd, 0x3d, 0x5b, 0x29, 0x9e, 0x63, 0x4b, 0x2b,
			0x26, 0xbb, 0x78, 0xfe, 0x9e, 0xae, 0xb6, 0xf8,
			0x82, 0x6c, 0xec, 0xe7, 0x15, 0x62, 0xf9, 0x76,
			0x05, 0x54, 0xc9, 0xb2, 0xda, 0xde, 0x54, 0x92,
			0x2a, 0x36, 0x7a, 0x93, 0x7d, 0xd9, 0xc9, 0x9e,
			0x60, 0xdf, 0x11, 0xa5, 0xda, 0xf4, 0xb1, 0x0f,
			0x6e, 0x75, 0x69, 0x61, 0xf2, 0xbb, 0xff, 0x96,
			0xd5, 0xca, 0x39, 0x33, 0xb3, 0xba, 0xb1, 0x3c,
			0x33, 0x8a, 0x46, 0x46, 0x9c, 0x8b, 0x51, 0x18,
			0xe8, 0xe2, 0xb0, 0x6b, 0x57, 0xf0, 0x48, 0x7c,
			0x23, 0xa5, 0xd1, 0x45, 0xc3, 0x30, 0x89, 0x89,
			0xd8, 0xe4, 0x69, 0x69, 0x0e, 0xbf, 0xb1, 0x40,
			0x19, 0x89, 0xb5, 0x67, 0x7d, 0x1b, 0x92, 0x62,
			0xf0, 0xa6, 0x2d, 0x38, 0x75, 0x30, 0x41, 0xca,
			0x6e, 0xb0, 0x90, 0x69, 0xd4, 0xa6, 0x79, 0xeb,
			0x68, 0xd4, 0xd9, 0xee, 0x7b, 0x64, 0xfc, 0x1e,
			0x1c, 0x82, 0x60, 0xfc, 0xba, 0xee, 0xaa, 0x83,
			0xc8, 0x8e, 0xa6, 0x03, 0x10, 0x9e, 0x76, 0xc8,
			0x85, 0xe8, 0xba, 0x1e, 0xe9, 0x9b, 0xa1, 0xfd,
			0xf3, 0x7a, 0x79, 0x32, 0x39, 0x83, 0x41, 0xf5,
			0x97, 0x71, 0xef, 0xca, 0x03, 0x6b, 0xd9, 0x92,
			0x19, 0x57, 0xec, 0x7b, 0x97, 0x21, 0x25, 0xee,
			0xcf, 0x23, 0x19, 0xf0, 0xce, 0x39, 0xd4, 0xde,
			0x21, 0xfd, 0x78, 0xe9, 0x85, 0x74, 0x79, 0x4d,
			0xea, 0xdd, 0x8f, 0x55, 0xbb, 0x8c, 0x03, 0xf4,
			0x75, 0x92, 0xd6, 0x87, 0x7a, 0x1f, 0xa0, 0xb6,
			0x6d, 0x6d, 0x80, 0x09, 0xec, 0xfe, 0x58, 0xa7,
			0x1f, 0xc0, 0x7e, 0x02, 0x15, 0x05, 0xe8, 0xad,
		},
	},
	/* SHA1 [7] */
	{
		/* Msg7 : 128 byte */
		{
			0xc7, 0x96, 0x0d, 0xec, 0xb7, 0x93, 0xf6, 0xd8,
			0x41, 0x49, 0x18, 0xea, 0xe6, 0x07, 0x16, 0x86,
			0x8b, 0xee, 0x1c, 0x7d, 0xcd, 0xf9, 0xce, 0x30,
			0x94, 0x3b, 0x7f, 0xf9, 0xeb, 0x68, 0xa4, 0xc6,
			0x0f, 0x97, 0x88, 0x07, 0xc5, 0x46, 0x41, 0xcb,
			0xf1, 0x9f, 0xe2, 0x25, 0x65, 0xfa, 0xf2, 0xd5,
			0xf7, 0xa2, 0x1d, 0x24, 0xd6, 0xdc, 0x2a, 0x10,
			0x1e, 0x25, 0x2d, 0xa9, 0xa9, 0xbc, 0xfe, 0xbb,
			0x29, 0x60, 0xe9, 0xad, 0x73, 0x5b, 0xa7, 0xa9,
			0x1e, 0xbf, 0x8d, 0xfe, 0x4d, 0xf0, 0x04, 0xc2,
			0xc9, 0x62, 0x39, 0xbb, 0x53, 0xa4, 0x16, 0x80,
			0x38, 0x9e, 0x70, 0xdb, 0x25, 0x17, 0x82, 0x72,
			0x3d, 0x7a, 0x9a, 0xa6, 0x69, 0xd9, 0x12, 0xbc,
			0xef, 0x32, 0x82, 0x3a, 0x47, 0xf1, 0x34, 0x94,
			0x2a, 0xb7, 0xd8, 0x08, 0xeb, 0x5a, 0x79, 0xc7,
			0x0a, 0x2d, 0xb0, 0x55, 0x07, 0x81, 0x18, 0x32,
		},
		/* S7 : 256 byte */
		{
			0xde, 0x64, 0xbe, 0x44, 0xee, 0x64, 0x13, 0x1b,
			0x4e, 0xfc, 0xc3, 0x29, 0x82, 0xed, 0x33, 0xb5,
			0x2e, 0x58, 0xf3, 0x16, 0x91, 0x39, 0xd0, 0x02,
			0xf9, 0xb6, 0x11, 0x60, 0xdf, 0xed, 0x8c, 0xff,
			0x95, 0x5a, 0xcd, 0xcf, 0x28, 0x16, 0x5a, 0x99,
			0x79, 0x59, 0x49, 0x1d, 0x9b, 0x20, 0xd0, 0x3e,
			0x4e, 0x29, 0x72, 0x89, 0xa6, 0x8e, 0xfb, 0x1e,
			0x9e, 0xc3, 0x47, 0x6a, 0xe7, 0x25, 0x3f, 0xfc,
			0xe7, 0x43, 0xba, 0x4a, 0xbe, 0x64, 0xc1, 0xc7,
			0x13, 0x10, 0xd6, 0xa8, 0x12, 0xb7, 0x5e, 0xaf,
			0x2c, 0x18, 0xe6, 0x74, 0x5d, 0xa1, 0x46, 0xda,
			0x87, 0xe8, 0x52, 0x80, 0xed, 0x8c, 0xc0, 0x1f,
			0x43, 0x30, 0xd5, 0x1b, 0x1e, 0x77, 0x23, 0x1e,
			0x25, 0x02, 0x1b, 0x77, 0x12, 0x79, 0x3f, 0x6e,
			0x87, 0x5e, 0xb7, 0x23, 0x3b, 0x11, 0xc9, 0xc0,
			0x03, 0xda, 0x59, 0x78, 0xf6, 0xaf, 0x3d, 0xc5,
			0x1c, 0xce, 0x82, 0x49, 0xec, 0x53, 0xbc, 0xae,
			0xfb, 0x3a, 0x52, 0xc9, 0xb9, 0xef, 0x93, 0x92,
			0xa8, 0x90, 0x51, 0xbb, 0x0b, 0xfa, 0x67, 0xcf,
			0x32, 0x75, 0x31, 0x8d, 0x35, 0xca, 0x44, 0xdd,
			0x71, 0xa5, 0xd6, 0x78, 0x09, 0xbe, 0x05, 0xc0,
			0x54, 0xac, 0x97, 0xc5, 0xa6, 0xf6, 0x5f, 0x73,
			0xb7, 0xfe, 0x14, 0x24, 0x95, 0x26, 0x0c, 0x88,
			0x2c, 0xf9, 0xf5, 0xd5, 0xb4, 0x55, 0xb2, 0x26,
			0x12, 0x02, 0x1b, 0x03, 0x6e, 0x11, 0x97, 0x80,
			0x3d, 0xfb, 0x1b, 0x45, 0xc5, 0x22, 0xb6, 0x91,
			0x56, 0xdc, 0x54, 0x99, 0x74, 0xb8, 0x65, 0xc2,
			0xd6, 0x6d, 0x38, 0x71, 0xcd, 0xb7, 0xcb, 0xb1,
			0x2a, 0xb5, 0xbb, 0x30, 0x93, 0x1a, 0x97, 0x10,
			0xb2, 0xff, 0xef, 0x32, 0x6b, 0x39, 0x54, 0x87,
			0x2a, 0x56, 0xeb, 0x4e, 0x62, 0x74, 0xba, 0x4b,
			0xc4, 0x0a, 0x1c, 0x19, 0xca, 0x15, 0x4c, 0xd0,
		},
	},
	/* SHA1 [8] */
	{
		/* Msg8 : 128 byte */
		{
			0x62, 0x78, 0xd8, 0xbc, 0x32, 0xdc, 0x6b, 0x03,
			0x9f, 0x13, 0x8c, 0x92, 0x60, 0xc8, 0xc9, 0x0d,
			0x98, 0x60, 0x7f, 0xaf, 0xaa, 0x82, 0x4c, 0xea,
			0x4f, 0xd7, 0xc7, 0x4d, 0xe6, 0x0e, 0x6f, 0xab,
			0x0b, 0x24, 0xe2, 0x7a, 0x6a, 0xe2, 0x50, 0x79,
			0xd5, 0xa7, 0x2e, 0x96, 0x95, 0x67, 0x2f, 0x0e,
			0xfe, 0xf4, 0x70, 0xd6, 0x47, 0x7c, 0xf2, 0x3a,
			0x98, 0x53, 0x4e, 0xc4, 0x63, 0xf3, 0xa4, 0x5f,
			0xf8, 0x42, 0xd5, 0xbc, 0x54, 0x13, 0xf2, 0xf5,
			0x3a, 0xee, 0xf4, 0x70, 0x86, 0x14, 0xad, 0x07,
			0xbd, 0xbe, 0xfe, 0x65, 0xe8, 0xa6, 0x4b, 0xb3,
			0xa3, 0xc8, 0x2c, 0x75, 0x71, 0x6a, 0x65, 0xae,
			0x52, 0x5a, 0x19, 0x4b, 0x98, 0x77, 0x3a, 0xbe,
			0xf6, 0x72, 0x44, 0xea, 0xda, 0xd6, 0x2b, 0x3f,
			0xfc, 0x46, 0x91, 0x26, 0x37, 0x06, 0x3d, 0x9f,
			0x99, 0xbe, 0xc9, 0x28, 0xb6, 0x7a, 0x9a, 0xe2,
		},
		/* S8 : 256 byte */
		{
			0x98, 0xff, 0x16, 0x7b, 0x98, 0x5e, 0x03, 0x05,
			0x85, 0xd1, 0x70, 0xaa, 0x38, 0xa1, 0xf8, 0x5f,
			0xbf, 0xde, 0xde, 0x90, 0xcb, 0x57, 0xf5, 0x24,
			0x08, 0x76, 0xaa, 0x8a, 0xe6, 0x69, 0x17, 0x7b,
			0x91, 0x7d, 0xbf, 0x8f, 0xc0, 0x08, 0x52, 0xbf,
			0x85, 0x11, 0x6c, 0xbb, 0x90, 0x02, 0xf4, 0x65,
			0xdc, 0x09, 0xb3, 0x40, 0xd3, 0xbf, 0x1a, 0x7f,
			0x96, 0xf8, 0x7f, 0xe7, 0x84, 0x3d, 0x78, 0xe3,
			0x22, 0x4a, 0xf7, 0x61, 0x08, 0xd2, 0x38, 0x26,
			0x05, 0x98, 0xb2, 0xee, 0xe9, 0x30, 0x55, 0x59,
			0x3b, 0x71, 0x4b, 0x0f, 0x3f, 0x42, 0x27, 0x79,
			0x15, 0x56, 0x68, 0xdd, 0xcc, 0x20, 0x78, 0xc7,
			0x4c, 0xf9, 0x35, 0xa2, 0x98, 0x61, 0x9c, 0x66,
			0x1a, 0x9f, 0xd3, 0x13, 0xbd, 0xd5, 0xa6, 0x5a,
			0xc4, 0xed, 0xde, 0x46, 0x25, 0x14, 0x29, 0x05,
			0x02, 0x94, 0x02, 0xa3, 0xbf, 0xbc, 0x11, 0x1e,
			0x16, 0xcf, 0x40, 0x35, 0x52, 0xab, 0xf2, 0xaf,
			0x3b, 0xd1, 0x15, 0x54, 0xe5, 0x0d, 0x58, 0x09,
			0xcc, 0x13, 0xaf, 0x82, 0xae, 0x89, 0x41, 0x13,
			0xdd, 0x04, 0xc6, 0x56, 0x05, 0xde, 0x22, 0x16,
			0xbb, 0xf6, 0x6a, 0x08, 0x40, 0x05, 0x66, 0x45,
			0x1f, 0x42, 0x54, 0xee, 0xb0, 0x22, 0x94, 0xf8,
			0xf8, 0x6b, 0xe0, 0x60, 0x0f, 0x35, 0x34, 0x9d,
			0x91, 0x9a, 0x26, 0x27, 0x24, 0x71, 0xc2, 0x59,
			0x43, 0xb5, 0x31, 0x47, 0xcd, 0xd1, 0x02, 0xd2,
			0x68, 0xff, 0xc7, 0xb3, 0xcf, 0x98, 0x73, 0x8d,
			0x83, 0x78, 0x23, 0x83, 0x11, 0x09, 0xad, 0xb4,
			0x59, 0x3a, 0xa3, 0x86, 0x50, 0x62, 0x2c, 0xe8,
			0xb6, 0x4e, 0x94, 0xdb, 0x3e, 0xd3, 0x50, 0x00,
			0xfe, 0x3c, 0x8c, 0x6c, 0xd0, 0x68, 0x00, 0x9f,
			0xd7, 0x07, 0xd2, 0x3b, 0x5f, 0x94, 0xd0, 0xb3,
			0x38, 0x2e, 0x20, 0x7a, 0x98, 0xe2, 0x55, 0xb2,
		},
	},
	/* SHA1 [9] */
	{
		/* Msg9 : 128 byte */
		{
			0xe8, 0x23, 0xb2, 0xf0, 0x62, 0xbb, 0x10, 0xa4,
			0x1f, 0x3a, 0xb2, 0xa0, 0xc4, 0xbd, 0x11, 0x0b,
			0x2d, 0xc2, 0x84, 0x6f, 0x0f, 0x3a, 0x06, 0x6a,
			0xdb, 0xe0, 0x39, 0xa6, 0xe5, 0xc8, 0xab, 0x0a,
			0xc5, 0x3b, 0x58, 0x32, 0xfd, 0xc2, 0x71, 0x1d,
			0xdd, 0x81, 0x5c, 0x26, 0xa4, 0xc6, 0xfc, 0x36,
			0xe8, 0xe2, 0x32, 0x37, 0x38, 0x38, 0xa4, 0xcc,
			0xff, 0x93, 0xbd, 0x3f, 0xab, 0xbd, 0xf5, 0xbb,
			0x0f, 0x4d, 0x52, 0xbb, 0x06, 0xc0, 0x2e, 0xc2,
			0x5a, 0xcb, 0x3c, 0x4d, 0xe4, 0xf0, 0xc6, 0x05,
			0xf4, 0x50, 0x38, 0x3a, 0xf3, 0xc0, 0xe2, 0x8d,
			0x46, 0x1e, 0xfa, 0xec, 0x76, 0xe6, 0xe0, 0xc4,
			0x8e, 0x00, 0xa6, 0x71, 0xc5, 0xdc, 0xd0, 0xfa,
			0x5d, 0xc1, 0x58, 0xfb, 0xcb, 0x62, 0xf6, 0xe2,
			0x18, 0xb3, 0x9e, 0x5e, 0x87, 0xfa, 0x49, 0x15,
			0x78, 0x29, 0xf8, 0x96, 0x8c, 0x6b, 0xf6, 0x8e,
		},
		/* S9 : 256 byte */
		{
			0x86, 0xf4, 0xb5, 0xc9, 0xb7, 0xdb, 0x9c, 0xf7,
			0xd0, 0x9c, 0xaa, 0xe1, 0xad, 0x6a, 0xb3, 0x04,
			0x3c, 0xe3, 0x9d, 0x14, 0xc5, 0x6c, 0x6e, 0x4f,
			0xd8, 0x70, 0x1a, 0x8e, 0xef, 0xd6, 0x6a, 0x17,
			0x92, 0xc8, 0x9c, 0xc1, 0x05, 0xf3, 0x65, 0x72,
			0x98, 0xb2, 0x93, 0x89, 0x4e, 0x99, 0x9f, 0xb3,
			0x0e, 0x30, 0x07, 0x9a, 0xeb, 0xb1, 0xd4, 0xfa,
			0x0f, 0x5c, 0x6f, 0xcd, 0x50, 0x96, 0xf5, 0x05,
			0x74, 0x59, 0x26, 0x96, 0xa5, 0x59, 0xd0, 0xf2,
			0x28, 0xd1, 0x8d, 0x4a, 0xe8, 0xf7, 0x5b, 0x50,
			0x8b, 0x71, 0x4f, 0xfb, 0x33, 0x93, 0xa4, 0xe5,
			0x60, 0xb0, 0xd0, 0x04, 0xbc, 0x4a, 0x01, 0x29,
			0x38, 0x7b, 0xab, 0xee, 0x46, 0x6e, 0x0c, 0x9b,
			0x1a, 0x22, 0x3f, 0x3a, 0x87, 0x45, 0x0d, 0xe0,
			0xe4, 0x20, 0x07, 0x33, 0xaf, 0x92, 0x74, 0x5c,
			0x88, 0x0a, 0x15, 0x5f, 0x6d, 0x9c, 0xab, 0xba,
			0x81, 0x61, 0x81, 0x07, 0x8f, 0xe4, 0xcd, 0x36,
			0x0b, 0xa2, 0x5a, 0x45, 0x95, 0x4f, 0x4b, 0x52,
			0x35, 0x64, 0x35, 0x96, 0x47, 0x89, 0xf9, 0x50,
			0x3f, 0x88, 0x97, 0x99, 0xe5, 0x5a, 0x3f, 0x3c,
			0x46, 0xfa, 0x32, 0xc5, 0x19, 0x5c, 0x84, 0x95,
			0x6e, 0x56, 0x91, 0x3c, 0xad, 0x42, 0x3d, 0xc4,
			0xc8, 0xa6, 0xed, 0x7f, 0x17, 0xf1, 0x82, 0x5b,
			0xbd, 0xc5, 0x3d, 0xd3, 0x3d, 0x3c, 0x3b, 0x26,
			0x12, 0xda, 0x4c, 0xe5, 0xe8, 0x96, 0x22, 0xd6,
			0x2a, 0xa0, 0x20, 0x5e, 0xe6, 0x67, 0xa9, 0xde,
			0xe2, 0x76, 0xb9, 0x1d, 0xc7, 0xbc, 0x67, 0xa8,
			0xc1, 0xb3, 0x79, 0x93, 0x0a, 0xea, 0x8c, 0x8d,
			0x26, 0xc4, 0x77, 0x3f, 0xde, 0x95, 0x5e, 0x4a,
			0xfc, 0x37, 0x11, 0x97, 0xdc, 0xd8, 0xcf, 0xd6,
			0xc6, 0x19, 0xc2, 0xf0, 0xf5, 0x7c, 0x0b, 0x2f,
			0xa0, 0x8e, 0xa7, 0x3c, 0xc1, 0x8c, 0x15, 0x6e,
		},
	},
};

/* 10 elements */
static mod2048_t SHA224[] = {
	/* SHA224 [0] */
	{
		/* Msg0 : 128 byte */
		{
			0x79, 0xbc, 0xff, 0xbf, 0xd6, 0xbc, 0xf6, 0x38,
			0x93, 0x4b, 0x38, 0xe4, 0x7a, 0x1b, 0x82, 0x1d,
			0xc9, 0x7c, 0xaf, 0xe1, 0xda, 0x75, 0x7f, 0x82,
			0x03, 0x13, 0x98, 0x9e, 0xbc, 0x01, 0xca, 0x52,
			0xff, 0x59, 0x97, 0xab, 0xf5, 0xba, 0xf3, 0x5d,
			0xce, 0x9b, 0x48, 0xb8, 0xf0, 0xde, 0xbd, 0xd7,
			0x55, 0xa8, 0xb8, 0x1b, 0x2e, 0x71, 0xa1, 0xd8,
			0xcd, 0x57, 0xea, 0x4d, 0xc1, 0xb8, 0x4c, 0xda,
			0x43, 0xff, 0x53, 0x6d, 0xd1, 0xbe, 0x1c, 0x3e,
			0x18, 0xfe, 0x5e, 0xbc, 0x17, 0xd3, 0xa7, 0xc6,
			0x82, 0x33, 0xe8, 0x1f, 0x64, 0x07, 0x34, 0x1c,
			0x09, 0x83, 0xc5, 0xa0, 0x1b, 0xb3, 0x40, 0x4a,
			0x0b, 0x57, 0x39, 0xed, 0xb2, 0xf1, 0xfa, 0x41,
			0x39, 0x1c, 0x80, 0xd8, 0x36, 0x1f, 0xc7, 0x53,
			0x17, 0xc2, 0x48, 0xd5, 0xc4, 0x61, 0xbf, 0xb8,
			0x80, 0x3e, 0x31, 0x7f, 0x10, 0x1b, 0x2e, 0x0c,
		},
		/* S0 : 256 byte */
		{
			0x5c, 0xbc, 0x1d, 0x2c, 0x69, 0x6e, 0x7c, 0x5c,
			0x0a, 0x53, 0x8d, 0xb3, 0x5a, 0x79, 0x39, 0x59,
			0x00, 0x85, 0x64, 0xc4, 0x3d, 0x9a, 0xa8, 0xed,
			0x20, 0x81, 0x6b, 0x66, 0xef, 0x77, 0x12, 0x4e,
			0xca, 0x75, 0x84, 0x63, 0x13, 0x08, 0xd0, 0xfd,
			0x73, 0x83, 0xbe, 0x62, 0xea, 0xf7, 0x99, 0xb5,
			0xe6, 0x7e, 0x88, 0x74, 0xcc, 0x9d, 0x88, 0xd5,
			0x07, 0xe1, 0xbd, 0x4f, 0xb9, 0xfd, 0x75, 0x17,
			0xad, 0xeb, 0xe5, 0xd5, 0x83, 0xb0, 0x75, 0x04,
			0x0c, 0xe3, 0xdb, 0x2a, 0xff, 0xcf, 0x77, 0xee,
			0x01, 0x62, 0xbe, 0x2e, 0x57, 0x54, 0x13, 0xf4,
			0x55, 0x84, 0x1c, 0xb6, 0xea, 0x4a, 0x30, 0x59,
			0x5d, 0xae, 0xe4, 0x5e, 0x30, 0x42, 0xb0, 0xb9,
			0xd8, 0xf9, 0xee, 0x70, 0x0d, 0xf3, 0xf1, 0x89,
			0x82, 0x19, 0x77, 0x7c, 0x21, 0xef, 0x36, 0x95,
			0xaf, 0x95, 0x62, 0x8a, 0xe6, 0x42, 0x60, 0xdd,
			0x2c, 0xb7, 0xee, 0x62, 0x70, 0xfb, 0x06, 0xf5,
			0x2e, 0xa1, 0xae, 0xa7, 0x2e, 0x1a, 0x26, 0xa2,
			0x6f, 0x2e, 0x7c, 0xee, 0x56, 0x0a, 0xe0, 0xcb,
			0x8b, 0xe3, 0x23, 0x11, 0x3c, 0x3f, 0x19, 0xc9,
			0x7c, 0xb5, 0xa3, 0xe6, 0x1b, 0x99, 0x8a, 0x68,
			0x43, 0x2a, 0xa2, 0xd1, 0xf8, 0xc8, 0xc0, 0x0a,
			0xc9, 0x2b, 0x0f, 0x35, 0x34, 0x47, 0x10, 0xae,
			0x1d, 0x6d, 0x79, 0xf3, 0x79, 0xfb, 0xb3, 0xdb,
			0xa4, 0x1b, 0x46, 0xb9, 0xc8, 0x14, 0xeb, 0x3a,
			0x25, 0xca, 0x64, 0xa3, 0xff, 0x86, 0xaf, 0x61,
			0x3d, 0x16, 0x3f, 0x94, 0x1a, 0x89, 0x76, 0x76,
			0x65, 0x2e, 0x7c, 0x3f, 0x67, 0x69, 0xfd, 0x96,
			0x4b, 0x86, 0x2d, 0xc5, 0x8c, 0xc2, 0xe6, 0x52,
			0xd0, 0xa4, 0x04, 0xe9, 0x48, 0x53, 0xfb, 0x83,
			0x93, 0x7c, 0x86, 0x2c, 0x1d, 0xf2, 0xdf, 0x9f,
			0xd2, 0x97, 0xf0, 0x58, 0xbf, 0x66, 0x0d, 0x15,
		},
	},
	/* SHA224 [1] */
	{
		/* Msg1 : 128 byte */
		{
			0x8f, 0x27, 0xe8, 0xfb, 0xea, 0x15, 0x5d, 0x20,
			0x33, 0x53, 0x95, 0xdd, 0x11, 0xbc, 0x95, 0x72,
			0xd4, 0x2e, 0x4c, 0x60, 0x09, 0xd5, 0xca, 0xce,
			0x4b, 0xac, 0xae, 0x2b, 0x5c, 0x40, 0xdd, 0x15,
			0x74, 0xb8, 0x7a, 0x79, 0xd8, 0x12, 0x12, 0xfc,
			0xaf, 0xaf, 0x16, 0x9a, 0x11, 0x12, 0x8f, 0x8d,
			0x62, 0xe5, 0x0d, 0x71, 0xde, 0x3c, 0xe0, 0xa5,
			0x74, 0x1e, 0x8b, 0xf4, 0xd8, 0x42, 0x76, 0x75,
			0xd4, 0x16, 0xe3, 0xaf, 0xdf, 0x05, 0x23, 0x01,
			0xf0, 0xfa, 0x0a, 0x42, 0x94, 0x20, 0xa0, 0xa4,
			0x3f, 0xed, 0x19, 0xde, 0xdf, 0x5e, 0x08, 0x8a,
			0xb7, 0x84, 0xcf, 0xcb, 0x6b, 0x3f, 0x5a, 0x34,
			0x57, 0x4a, 0x0d, 0xe5, 0x25, 0x77, 0xfa, 0xf7,
			0x9f, 0x3c, 0x58, 0x1b, 0xc1, 0x6f, 0x30, 0x7d,
			0x13, 0x4e, 0x5a, 0xef, 0x36, 0xc2, 0xa8, 0x43,
			0xbc, 0xe5, 0x61, 0xf8, 0x3d, 0xc1, 0xf1, 0x1a,
		},
		/* S1 : 256 byte */
		{
			0x9a, 0x61, 0x22, 0x3b, 0x98, 0x30, 0x3c, 0x51,
			0xdc, 0xcc, 0x54, 0xd5, 0xfc, 0x83, 0x7c, 0x6f,
			0xec, 0x17, 0x20, 0xfa, 0x22, 0xff, 0x69, 0xc2,
			0x77, 0xbe, 0x46, 0xc3, 0x88, 0x43, 0x02, 0x72,
			0xe3, 0xc8, 0x03, 0x0d, 0x61, 0xb1, 0xc4, 0x94,
			0x6d, 0x32, 0x9f, 0xd2, 0xaa, 0x40, 0x87, 0x49,
			0xa3, 0xac, 0xe2, 0xa6, 0xe1, 0xef, 0xe5, 0x8b,
			0x84, 0xed, 0xaf, 0xec, 0x5d, 0xea, 0xa0, 0x36,
			0x34, 0x1b, 0x40, 0xac, 0x53, 0x10, 0xd1, 0x23,
			0x26, 0xfb, 0x65, 0x63, 0x1c, 0xec, 0xb2, 0x5c,
			0x13, 0xfc, 0xee, 0xcb, 0xab, 0xd4, 0xa8, 0x7c,
			0xea, 0x8f, 0x18, 0x57, 0x51, 0x30, 0x9d, 0x70,
			0x7c, 0x92, 0x0c, 0xe8, 0x7a, 0x09, 0x6a, 0x1b,
			0x94, 0x21, 0x82, 0xe2, 0x09, 0xf5, 0xd7, 0xed,
			0x55, 0xa1, 0x8a, 0x58, 0xcd, 0x4f, 0x2b, 0x52,
			0x49, 0xee, 0x72, 0x3a, 0xe7, 0xc8, 0x58, 0xfc,
			0x53, 0x0e, 0x70, 0x73, 0x0f, 0x25, 0x44, 0x8f,
			0xd6, 0x41, 0xa3, 0x5d, 0x31, 0x4f, 0x5c, 0x51,
			0x1d, 0xca, 0x41, 0x1f, 0x8d, 0xf8, 0x5b, 0x74,
			0xa9, 0xee, 0x86, 0x69, 0x09, 0x5f, 0x5a, 0xeb,
			0xb4, 0x68, 0x7e, 0xfe, 0x05, 0x2a, 0xfe, 0xed,
			0xd5, 0x3e, 0xb1, 0xe6, 0xb1, 0x75, 0x7f, 0x71,
			0xc5, 0x62, 0x2c, 0xc0, 0x3d, 0xec, 0x36, 0x86,
			0x60, 0xed, 0x50, 0xb1, 0x1f, 0x28, 0x70, 0x58,
			0x7e, 0x27, 0x7c, 0x48, 0xe5, 0x54, 0x47, 0x07,
			0x69, 0xfa, 0x49, 0x6e, 0xfe, 0x5d, 0x16, 0x1e,
			0xf3, 0xe6, 0xd0, 0x40, 0x03, 0xf2, 0x82, 0x9f,
			0x7a, 0xff, 0xa6, 0xaa, 0xb9, 0xea, 0x54, 0xcf,
			0x9e, 0x5b, 0xb7, 0x94, 0xba, 0xe4, 0x8f, 0xe2,
			0xf9, 0x2e, 0x12, 0x94, 0xf0, 0x1a, 0xae, 0xf4,
			0x0e, 0x1e, 0x2a, 0x5b, 0xc9, 0x9c, 0x14, 0xb9,
			0x92, 0xc1, 0xde, 0xb6, 0x6a, 0xfa, 0x7f, 0x5f,
		},
	},
	/* SHA224 [2] */
	{
		/* Msg2 : 128 byte */
		{
			0xcf, 0xd6, 0xf7, 0x24, 0x61, 0x14, 0xab, 0x01,
			0x1c, 0x28, 0xdc, 0x65, 0x4a, 0xc7, 0xbe, 0xc4,
			0x65, 0x17, 0x2e, 0x92, 0xd8, 0x64, 0x99, 0xa0,
			0x06, 0x14, 0x1a, 0xa8, 0x8d, 0xdd, 0xe2, 0x27,
			0xcc, 0x35, 0xdd, 0x6a, 0xa3, 0x0a, 0x93, 0xec,
			0x79, 0xb4, 0x4c, 0xdf, 0x84, 0x28, 0x77, 0x09,
			0x44, 0x6e, 0x4c, 0xd1, 0x51, 0x55, 0xb1, 0x9a,
			0x57, 0x65, 0x5a, 0x4f, 0x5f, 0x15, 0x35, 0x3f,
			0x50, 0x3e, 0x05, 0x2c, 0xb5, 0xd0, 0x4c, 0x9e,
			0xc0, 0xc4, 0x6f, 0x7d, 0x8f, 0x51, 0x15, 0xdf,
			0xaf, 0x63, 0xd0, 0x1f, 0xdf, 0x49, 0xff, 0x2f,
			0x16, 0xad, 0xf3, 0x2f, 0xc7, 0xca, 0x50, 0x3e,
			0x63, 0xd9, 0xb6, 0x90, 0x20, 0xcc, 0xa1, 0xc0,
			0xf9, 0x3f, 0x8e, 0x68, 0xf5, 0xac, 0x60, 0xf0,
			0xad, 0xde, 0x01, 0xa3, 0x08, 0xa8, 0x4c, 0x08,
			0x4a, 0xd6, 0x2b, 0x6f, 0x4d, 0x64, 0xfc, 0xca,
		},
		/* S2 : 256 byte */
		{
			0x2c, 0x32, 0xee, 0xd4, 0x1b, 0xf7, 0xa1, 0xaf,
			0xd0, 0xd5, 0x67, 0x06, 0x3f, 0xb2, 0x53, 0xfb,
			0x8e, 0x6b, 0x2c, 0x9f, 0x21, 0x68, 0x9c, 0x1c,
			0x07, 0xa1, 0xb1, 0x3c, 0x85, 0x8e, 0xa0, 0x85,
			0xb9, 0x32, 0xe3, 0xce, 0x60, 0xbc, 0xb7, 0xaf,
			0x3e, 0xed, 0x96, 0x52, 0x3a, 0x6d, 0x77, 0xfb,
			0x92, 0xf9, 0x96, 0xd2, 0xeb, 0x03, 0x57, 0xbf,
			0x7c, 0xfc, 0x25, 0x32, 0xa6, 0xf5, 0x84, 0xcb,
			0x8b, 0xe0, 0xb3, 0xcb, 0x54, 0x5c, 0xe6, 0xa0,
			0xa9, 0x72, 0xff, 0x83, 0x13, 0x7d, 0x94, 0x01,
			0x00, 0xca, 0xa4, 0x30, 0x13, 0x70, 0xc0, 0x2d,
			0xfc, 0xe7, 0x81, 0x07, 0x99, 0x26, 0xca, 0x6a,
			0x38, 0x92, 0x9d, 0x61, 0x8a, 0x8d, 0xc7, 0xe5,
			0x1b, 0x41, 0x42, 0xd6, 0xcd, 0x33, 0x5c, 0xc0,
			0x8d, 0x5c, 0x38, 0x4a, 0x9a, 0x7d, 0xe9, 0xbc,
			0x2f, 0xa1, 0x21, 0xd9, 0x01, 0xed, 0x34, 0x2b,
			0x47, 0x0a, 0xc8, 0x40, 0x75, 0x98, 0x36, 0x6b,
			0xba, 0x7e, 0x12, 0x2b, 0xa9, 0x93, 0xb3, 0xeb,
			0xf3, 0xdf, 0x52, 0x57, 0x09, 0x6c, 0x56, 0x30,
			0x3e, 0xaa, 0x9f, 0x2f, 0xcc, 0x4d, 0xad, 0xdb,
			0xc1, 0x35, 0xb7, 0x6e, 0x2b, 0xff, 0x11, 0x12,
			0x67, 0x59, 0x82, 0xdc, 0xfe, 0x48, 0x3f, 0xc9,
			0xb1, 0xd6, 0xea, 0xf1, 0x9d, 0xbd, 0x0e, 0x52,
			0xcf, 0xa2, 0xbd, 0xf5, 0x8d, 0xff, 0xfa, 0x2b,
			0x2e, 0xd3, 0x84, 0x33, 0xa5, 0xb9, 0x47, 0xbe,
			0xb4, 0x0b, 0x83, 0x43, 0x32, 0x66, 0x91, 0x4a,
			0x16, 0x8d, 0xeb, 0xa8, 0x4b, 0x4c, 0x52, 0x2b,
			0x88, 0xf6, 0x86, 0x1d, 0x40, 0x6d, 0xea, 0x78,
			0xf1, 0x21, 0x2d, 0x13, 0x7e, 0xf1, 0xd1, 0x75,
			0x44, 0xde, 0x96, 0x7a, 0xc5, 0xbb, 0xb2, 0x5d,
			0xc9, 0xd4, 0x46, 0x4c, 0xdf, 0x2d, 0x0b, 0xc7,
			0x0c, 0x1b, 0x28, 0x0e, 0xc8, 0x3a, 0x5b, 0xb4,
		},
	},
	/* SHA224 [3] */
	{
		/* Msg3 : 128 byte */
		{
			0xd7, 0x37, 0xbd, 0x2d, 0x03, 0x7e, 0xc4, 0xbe,
			0x9e, 0x03, 0x78, 0x1a, 0x67, 0x55, 0xbd, 0xe3,
			0x84, 0xd3, 0xfd, 0x2b, 0xd2, 0xb9, 0x1d, 0x94,
			0x7a, 0x5b, 0xb0, 0xb5, 0xc5, 0xab, 0x6b, 0xc0,
			0x31, 0x01, 0xd9, 0x62, 0xc4, 0x1c, 0x50, 0xeb,
			0xa0, 0x64, 0x24, 0xaf, 0xd8, 0x71, 0x1a, 0xac,
			0x82, 0xd1, 0x20, 0x6d, 0x0d, 0x06, 0x3b, 0x2e,
			0xd5, 0xcf, 0xc0, 0x40, 0xf5, 0xa9, 0xc7, 0xaf,
			0x5c, 0x94, 0xdd, 0x23, 0x24, 0x1a, 0xf9, 0x04,
			0x1f, 0x8e, 0xb2, 0xe1, 0xb2, 0x92, 0xae, 0x13,
			0xe6, 0xdb, 0x5e, 0x9d, 0xbc, 0x39, 0xe8, 0x57,
			0xc1, 0xd1, 0x65, 0x4c, 0xe3, 0xad, 0x4d, 0x60,
			0x83, 0x78, 0x2f, 0x36, 0xcb, 0x82, 0xa6, 0x50,
			0x42, 0x0b, 0x88, 0x78, 0x9d, 0xbd, 0x60, 0x5f,
			0xd9, 0x7a, 0x1f, 0x85, 0x86, 0x58, 0x0e, 0x58,
			0x66, 0xea, 0x07, 0xa0, 0x36, 0xc2, 0xe5, 0x1a,
		},
		/* S3 : 256 byte */
		{
			0xbc, 0x61, 0xe5, 0x94, 0x35, 0x7a, 0x5c, 0xcc,
			0xfd, 0xe0, 0xbf, 0x6c, 0x99, 0xfa, 0x14, 0x02,
			0xe2, 0x22, 0x2e, 0x7f, 0x1a, 0x41, 0x6c, 0xa3,
			0x65, 0xd6, 0x71, 0x53, 0x43, 0xb4, 0x81, 0xd7,
			0x0c, 0xa6, 0xf2, 0x53, 0x3a, 0xf8, 0x58, 0x26,
			0xbf, 0x57, 0xf9, 0xab, 0x3f, 0x17, 0x3d, 0xab,
			0x43, 0x3f, 0x34, 0x86, 0x8c, 0x9a, 0x9a, 0x7e,
			0xda, 0x30, 0x92, 0x1b, 0xf8, 0xc9, 0x89, 0x2b,
			0x7b, 0x26, 0xf0, 0xb6, 0x4d, 0x01, 0xb5, 0x26,
			0x2f, 0x87, 0x8c, 0x4d, 0x28, 0xaf, 0x4d, 0x0e,
			0xc0, 0x45, 0x2b, 0xd2, 0x23, 0x5e, 0xcb, 0xc5,
			0x02, 0x3e, 0xe0, 0xad, 0x52, 0x4f, 0xdc, 0x69,
			0x1f, 0xbd, 0x5c, 0xbe, 0xe2, 0x75, 0x07, 0x26,
			0x00, 0x01, 0x56, 0x55, 0x4f, 0xb0, 0xdc, 0xd6,
			0x93, 0x58, 0xad, 0x01, 0xa8, 0x26, 0x36, 0xc9,
			0x02, 0x99, 0xc0, 0x59, 0xb9, 0xf1, 0x5c, 0x74,
			0xec, 0x6c, 0x4d, 0xb2, 0xc7, 0x54, 0x74, 0x2c,
			0x39, 0xef, 0x6d, 0xc6, 0x7e, 0xaf, 0xf2, 0x56,
			0xfc, 0xd1, 0x05, 0x8c, 0x38, 0x92, 0xe3, 0xe4,
			0xc3, 0xfc, 0xa8, 0x93, 0x23, 0x67, 0x5e, 0x92,
			0x12, 0xa8, 0x6b, 0xcc, 0xfc, 0x81, 0xc2, 0xb6,
			0x87, 0x8f, 0xb1, 0xbd, 0xce, 0x1d, 0x22, 0x55,
			0xd3, 0x94, 0x57, 0xa3, 0x87, 0xb5, 0x51, 0x4f,
			0x2a, 0x25, 0x09, 0x9d, 0xea, 0xaf, 0x04, 0x13,
			0xc5, 0x30, 0x4f, 0x5d, 0xfc, 0x6c, 0xe1, 0x63,
			0x45, 0x8c, 0x7f, 0x26, 0x1c, 0xf8, 0xcc, 0x31,
			0x24, 0x4d, 0xb7, 0xfb, 0x76, 0x46, 0x41, 0x35,
			0x42, 0xc5, 0x43, 0xde, 0x6d, 0xac, 0xfc, 0xe8,
			0xb0, 0x2d, 0x95, 0xb9, 0x04, 0x04, 0x6a, 0x94,
			0x17, 0xb8, 0xdd, 0x17, 0x68, 0x8c, 0xad, 0xb8,
			0x82, 0x07, 0x7d, 0x66, 0x3f, 0xea, 0x2e, 0xc4,
			0x70, 0x67, 0x2f, 0x7a, 0xbf, 0xb0, 0xd9, 0x0d,
		},
	},
	/* SHA224 [4] */
	{
		/* Msg4 : 128 byte */
		{
			0x05, 0x32, 0x0d, 0x0d, 0x47, 0x19, 0x93, 0x01,
			0x12, 0x00, 0x46, 0xf6, 0x4d, 0x46, 0xd2, 0x74,
			0xac, 0xda, 0x40, 0xf2, 0x1d, 0x08, 0x77, 0x49,
			0x63, 0x92, 0x02, 0x69, 0x00, 0x03, 0x13, 0x4b,
			0x59, 0x40, 0xc8, 0x27, 0x15, 0x60, 0xae, 0xe6,
			0xc6, 0xbd, 0x84, 0xda, 0xcb, 0x4b, 0x41, 0xad,
			0x75, 0x29, 0x58, 0x97, 0x68, 0x76, 0x3a, 0xd4,
			0x44, 0x66, 0x1c, 0x56, 0x85, 0x95, 0xfb, 0xb7,
			0xa8, 0x9b, 0xde, 0x71, 0x90, 0xe0, 0x5c, 0x51,
			0x27, 0xb2, 0x5d, 0x29, 0x48, 0x94, 0x25, 0xc6,
			0xdd, 0xd9, 0x8e, 0x21, 0x44, 0x72, 0x94, 0xd9,
			0xf8, 0x05, 0x17, 0xe1, 0x6d, 0x3f, 0xdd, 0x76,
			0x3b, 0x6a, 0xd7, 0x55, 0x7f, 0x42, 0xa5, 0x2a,
			0x7e, 0x04, 0x5b, 0x4b, 0x8c, 0xc9, 0x86, 0xa6,
			0x2d, 0x12, 0x6a, 0xf9, 0x79, 0xa4, 0x8e, 0x41,
			0xc5, 0x96, 0x7b, 0x74, 0x7f, 0xa8, 0xc0, 0x72,
		},
		/* S4 : 256 byte */
		{
			0xba, 0x99, 0x44, 0xe9, 0x57, 0x4b, 0x76, 0x3d,
			0xc2, 0xe8, 0x6d, 0x21, 0x89, 0xcb, 0x85, 0x0d,
			0x1b, 0x3f, 0xea, 0x01, 0xe0, 0x3f, 0x61, 0x5c,
			0x1c, 0x56, 0xe0, 0xc6, 0x32, 0xd4, 0x36, 0x72,
			0x48, 0x61, 0x48, 0x53, 0x28, 0xd6, 0x75, 0x92,
			0xc5, 0x94, 0x83, 0xbd, 0xfd, 0x8f, 0x1c, 0x58,
			0x87, 0xcb, 0x51, 0xa0, 0x66, 0x0b, 0xb8, 0x1f,
			0x15, 0x8b, 0x6f, 0xc0, 0x73, 0xc3, 0x63, 0xbc,
			0x31, 0xf9, 0xfa, 0xe1, 0x1c, 0x06, 0xdc, 0x5e,
			0x50, 0x57, 0xf5, 0x70, 0x88, 0x66, 0xe7, 0xa4,
			0x86, 0xd0, 0x08, 0x3c, 0x2a, 0x39, 0xa2, 0xa8,
			0x69, 0x82, 0x93, 0x02, 0x29, 0xd0, 0x2d, 0xa7,
			0xb6, 0x69, 0xed, 0xad, 0x76, 0x4f, 0x82, 0x24,
			0xa5, 0x11, 0xed, 0x51, 0x99, 0x53, 0xf5, 0xe2,
			0x2d, 0xda, 0x95, 0x33, 0x91, 0x43, 0x52, 0xf9,
			0xeb, 0x12, 0xf4, 0x58, 0x0c, 0x02, 0x5d, 0x94,
			0xab, 0x52, 0x0c, 0xe8, 0x0b, 0x14, 0xc6, 0x1a,
			0x4a, 0x4b, 0xb2, 0x3a, 0x0b, 0xb8, 0x9c, 0x09,
			0x20, 0x79, 0xc1, 0x4b, 0x03, 0x99, 0xd8, 0x41,
			0xa9, 0x98, 0x64, 0x4f, 0x8c, 0xb1, 0x39, 0x6a,
			0xd5, 0x47, 0x92, 0xf4, 0xe3, 0x8a, 0x6d, 0xf8,
			0x4d, 0x32, 0xbe, 0xc9, 0x40, 0xff, 0x01, 0xe1,
			0x17, 0x50, 0x6c, 0x06, 0x61, 0xb0, 0x8d, 0xfb,
			0x0b, 0x53, 0xf9, 0x29, 0xf4, 0x3f, 0x28, 0x6d,
			0x3a, 0xd9, 0x4f, 0x5e, 0x47, 0xde, 0xc5, 0xd6,
			0xc3, 0x94, 0xab, 0xd4, 0x75, 0xcf, 0x54, 0x3b,
			0xf4, 0x0d, 0xaf, 0x42, 0xa6, 0xba, 0x49, 0x3e,
			0x95, 0x24, 0x1c, 0x1e, 0xfe, 0x91, 0x50, 0x3c,
			0x6e, 0xb9, 0xff, 0xef, 0x95, 0x95, 0x8a, 0x1a,
			0x3f, 0x54, 0x06, 0xe7, 0xf2, 0x2f, 0x54, 0x3a,
			0xe4, 0x72, 0x6e, 0x3f, 0xea, 0x49, 0x0f, 0x44,
			0xca, 0x09, 0xc8, 0xf8, 0x2a, 0xa5, 0xe2, 0x8d,
		},
	},
	/* SHA224 [5] */
	{
		/* Msg5 : 128 byte */
		{
			0xa0, 0x32, 0xba, 0x95, 0x1d, 0xe8, 0x4e, 0xf9,
			0xd6, 0x51, 0x9b, 0xbb, 0xcd, 0xf3, 0x5b, 0xc4,
			0x18, 0x1f, 0xf2, 0xf5, 0xe5, 0xdb, 0x96, 0xbb,
			0xbb, 0x20, 0xb3, 0xe4, 0x03, 0x46, 0x8e, 0xb1,
			0xc6, 0xbc, 0x28, 0x2c, 0xb8, 0xfc, 0x65, 0xbb,
			0x76, 0xbe, 0x6d, 0xf6, 0x0c, 0x6c, 0x53, 0xb6,
			0xba, 0xd7, 0xf5, 0x6e, 0xf8, 0x28, 0x23, 0xbf,
			0xb7, 0x19, 0x03, 0x46, 0xea, 0x65, 0xb3, 0xb9,
			0x45, 0x7c, 0x31, 0x32, 0x44, 0x7c, 0x78, 0xca,
			0x70, 0x5d, 0xec, 0x6a, 0xde, 0x6b, 0xf8, 0xde,
			0xf8, 0xfa, 0xf6, 0x2b, 0x7f, 0x55, 0x4f, 0x23,
			0xd1, 0xf7, 0xe3, 0x36, 0x68, 0xfe, 0xab, 0x8b,
			0xa4, 0xdc, 0x9c, 0x50, 0xca, 0x50, 0xcf, 0x4e,
			0x4c, 0x95, 0xe0, 0xc0, 0x4b, 0xd9, 0x94, 0x65,
			0x5a, 0xf0, 0xbe, 0xd4, 0x85, 0x4a, 0x63, 0x10,
			0x92, 0x22, 0x1c, 0x5c, 0x86, 0xf9, 0xbc, 0x50,
		},
		/* S5 : 256 byte */
		{
			0xbf, 0xf7, 0xb6, 0xc0, 0x6d, 0x46, 0x4a, 0xd3,
			0xe5, 0x74, 0x76, 0x41, 0xe5, 0xd6, 0x6d, 0xdc,
			0x7e, 0x5f, 0x62, 0x3a, 0x73, 0x5d, 0x6d, 0x04,
			0x37, 0x85, 0x1f, 0xdc, 0x0c, 0xa7, 0x10, 0xd1,
			0x0c, 0x7e, 0x13, 0x82, 0x66, 0xcf, 0x9a, 0x4c,
			0xe9, 0x5e, 0x41, 0x83, 0x8e, 0x29, 0x67, 0x8f,
			0xcb, 0x04, 0xd7, 0xa3, 0xfb, 0xfa, 0x88, 0x4e,
			0x54, 0x0d, 0xc7, 0xc4, 0xdb, 0x38, 0x41, 0x2e,
			0xb9, 0x5c, 0x68, 0x80, 0x09, 0x10, 0xdb, 0xf9,
			0x1f, 0x13, 0xa9, 0xe1, 0x29, 0xf8, 0xf8, 0x2a,
			0xc9, 0x28, 0xcc, 0xa1, 0x10, 0x2e, 0xb6, 0x25,
			0xd9, 0xca, 0x1f, 0x83, 0x83, 0xe5, 0x61, 0xcf,
			0xd3, 0x63, 0x48, 0x87, 0x9b, 0x0b, 0xd7, 0x9c,
			0xe6, 0xd3, 0x25, 0x87, 0x2d, 0xe4, 0x9a, 0xba,
			0x9d, 0x6e, 0x84, 0x47, 0x8c, 0x11, 0xce, 0xe4,
			0x7d, 0xaa, 0x34, 0x71, 0xcf, 0x0f, 0x19, 0x93,
			0xa8, 0x38, 0xa3, 0x38, 0xb6, 0x88, 0xd0, 0x5e,
			0x9a, 0xae, 0x42, 0x6a, 0x02, 0x81, 0xcf, 0x31,
			0xca, 0x7b, 0x63, 0x00, 0x25, 0x14, 0x37, 0xb0,
			0xb4, 0x07, 0x05, 0x7a, 0xd8, 0x41, 0x57, 0x44,
			0x33, 0x84, 0xf1, 0x86, 0xce, 0xe7, 0x95, 0x67,
			0x79, 0x31, 0xb2, 0x1e, 0xf3, 0x40, 0x68, 0x31,
			0x84, 0x31, 0xd3, 0x0b, 0x98, 0x6a, 0xc8, 0x0c,
			0x75, 0xd5, 0xc4, 0x83, 0x01, 0x45, 0x51, 0x05,
			0x89, 0x2f, 0x05, 0x44, 0x28, 0x8c, 0x90, 0xad,
			0x7b, 0xad, 0x6c, 0xa7, 0x8a, 0xcb, 0x82, 0xa4,
			0x8a, 0x9d, 0xf9, 0xc9, 0xa6, 0xdc, 0x98, 0x6d,
			0xe7, 0xdb, 0xe2, 0x9b, 0x3c, 0x96, 0x2a, 0x01,
			0x65, 0xf0, 0xd4, 0x7d, 0x2c, 0xa3, 0x29, 0x76,
			0xcf, 0x5e, 0x17, 0xcd, 0x77, 0x88, 0x23, 0x85,
			0xc9, 0x5c, 0x94, 0x3d, 0x5d, 0x38, 0xb0, 0xa6,
			0xa3, 0x7d, 0x16, 0x92, 0x75, 0xac, 0x7b, 0xd1,
		},
	},
	/* SHA224 [6] */
	{
		/* Msg6 : 128 byte */
		{
			0xe8, 0x71, 0xe6, 0xcb, 0x03, 0x93, 0x6c, 0xb8,
			0xfc, 0xab, 0x5a, 0x87, 0x02, 0x7e, 0x77, 0xb2,
			0x3a, 0xea, 0x33, 0xb9, 0xb4, 0x12, 0x3b, 0x67,
			0x9e, 0xbb, 0x4a, 0x56, 0xb7, 0xf6, 0x42, 0xb5,
			0x07, 0x00, 0x7b, 0x49, 0xce, 0x66, 0x5b, 0xb2,
			0xba, 0x6c, 0x27, 0xf0, 0x5c, 0xb0, 0x18, 0x25,
			0xdd, 0x0b, 0xb2, 0x9c, 0xed, 0xb8, 0x51, 0x0b,
			0xfd, 0xb8, 0x05, 0x15, 0xae, 0x74, 0x9f, 0x13,
			0x89, 0xa5, 0x0c, 0x14, 0xf0, 0x71, 0xe2, 0x22,
			0x54, 0xd6, 0x39, 0xc8, 0xa9, 0x4c, 0xbc, 0xd1,
			0x17, 0xa6, 0x00, 0x51, 0xf3, 0x3a, 0x14, 0xea,
			0xed, 0x41, 0x59, 0x48, 0x8b, 0x81, 0x93, 0xee,
			0xd6, 0x29, 0x41, 0x35, 0x53, 0xfc, 0x2a, 0x91,
			0x34, 0xb1, 0x39, 0x17, 0xd0, 0x9a, 0x8a, 0x3c,
			0x51, 0x85, 0xc5, 0xe0, 0xac, 0xe0, 0xab, 0x8b,
			0xd7, 0x20, 0xee, 0xf6, 0x36, 0x63, 0x46, 0xcd,
		},
		/* S6 : 256 byte */
		{
			0x71, 0x58, 0x62, 0x62, 0xd9, 0x94, 0x0b, 0xf8,
			0xa3, 0x72, 0xa6, 0x4a, 0x31, 0xdf, 0x83, 0x2a,
			0xae, 0x18, 0x99, 0x33, 0xff, 0xa5, 0xd0, 0x3b,
			0x63, 0x6e, 0x89, 0xa3, 0x3f, 0xc1, 0xcb, 0x43,
			0x88, 0xe9, 0x81, 0x58, 0x94, 0x3c, 0xd9, 0x7c,
			0x67, 0x8d, 0xe2, 0x8d, 0x4f, 0x97, 0x66, 0x78,
			0x0b, 0x96, 0x3f, 0x11, 0x2f, 0xdd, 0x6d, 0xef,
			0x39, 0x1b, 0xcc, 0x98, 0xee, 0x82, 0x39, 0xd2,
			0xe8, 0xea, 0x4a, 0x98, 0x12, 0xe3, 0x84, 0x56,
			0xc4, 0x44, 0xda, 0xb3, 0x14, 0xb1, 0x90, 0x32,
			0xc4, 0x1b, 0x20, 0xef, 0xe6, 0x47, 0x19, 0x1d,
			0x74, 0x85, 0x3f, 0x0a, 0x10, 0xda, 0xa9, 0xa9,
			0x99, 0xa2, 0xc7, 0x70, 0xdb, 0x36, 0x5c, 0x4c,
			0x90, 0x3c, 0xd2, 0xe3, 0xb2, 0x27, 0x4c, 0x05,
			0x83, 0xda, 0xcc, 0x40, 0x4a, 0x72, 0x2e, 0xb8,
			0x6d, 0xc4, 0x56, 0xc4, 0x75, 0xf2, 0xa6, 0x52,
			0x4a, 0xff, 0xd0, 0x16, 0xb7, 0xd7, 0xc2, 0x4d,
			0x4f, 0x8c, 0x83, 0xe6, 0x51, 0xea, 0x44, 0x8b,
			0x3b, 0x55, 0x6a, 0xee, 0x7a, 0x33, 0xb3, 0x5c,
			0x35, 0x49, 0xef, 0xb9, 0x61, 0xca, 0xf4, 0x62,
			0xd4, 0x9d, 0xb7, 0xdc, 0x8e, 0xd5, 0xc7, 0x1a,
			0x7d, 0x7d, 0x65, 0x5a, 0x36, 0xa4, 0x09, 0x80,
			0x8b, 0xe8, 0x65, 0x95, 0x0a, 0xa5, 0xbf, 0x5d,
			0x85, 0xb4, 0xb5, 0x20, 0x35, 0x6c, 0x9c, 0x00,
			0x2a, 0x1c, 0x93, 0x98, 0x43, 0x20, 0x67, 0xb1,
			0x61, 0xa5, 0x16, 0x75, 0x93, 0x8b, 0xfb, 0xb4,
			0xde, 0xd9, 0xbc, 0x4b, 0x32, 0x40, 0x1f, 0xe2,
			0x95, 0x35, 0x93, 0xc3, 0xa7, 0x7b, 0x74, 0x15,
			0xb2, 0xa4, 0xed, 0x19, 0x45, 0xf8, 0x41, 0x70,
			0x40, 0xb9, 0x76, 0x97, 0xfb, 0x41, 0x49, 0xe8,
			0xfc, 0xed, 0x86, 0x21, 0x42, 0xcf, 0xac, 0xdb,
			0x09, 0x6b, 0x44, 0x21, 0xad, 0x5a, 0xfd, 0xf0,
		},
	},
	/* SHA224 [7] */
	{
		/* Msg7 : 128 byte */
		{
			0xaf, 0x9a, 0x8b, 0xcf, 0x29, 0x57, 0x0b, 0x64,
			0x6b, 0xd2, 0x14, 0x1e, 0x06, 0xea, 0x57, 0xf3,
			0xe8, 0x5f, 0xe3, 0xcc, 0x25, 0x8a, 0x00, 0xdd,
			0xf7, 0x4b, 0x5b, 0x32, 0x03, 0x42, 0x64, 0x8b,
			0xdd, 0x42, 0xf5, 0x6a, 0xcf, 0x02, 0x34, 0x6a,
			0xd6, 0x16, 0xba, 0xd2, 0xee, 0x1e, 0xf5, 0x6a,
			0x8f, 0x3e, 0xca, 0x8e, 0x78, 0xce, 0x7f, 0x80,
			0xab, 0x52, 0xd9, 0x03, 0xb9, 0xac, 0x81, 0x25,
			0x3f, 0x90, 0xac, 0x5c, 0xb1, 0x39, 0xfb, 0xd4,
			0x56, 0x5a, 0xa0, 0x08, 0x94, 0x58, 0xc3, 0x90,
			0x6e, 0xb6, 0x24, 0x39, 0x4b, 0xd1, 0x01, 0x5b,
			0xf9, 0xcd, 0x3a, 0x67, 0xf1, 0xcf, 0xb3, 0xc0,
			0xdd, 0x6c, 0xfa, 0xcc, 0x57, 0x62, 0x2a, 0x4a,
			0xf4, 0x86, 0x0f, 0xe6, 0x81, 0xfe, 0x8a, 0x0a,
			0x8c, 0xb0, 0x37, 0xf8, 0x27, 0xfa, 0x4e, 0x16,
			0xe8, 0xa4, 0xc7, 0x88, 0x34, 0x13, 0xc2, 0x04,
		},
		/* S7 : 256 byte */
		{
			0x07, 0x25, 0x9c, 0x36, 0x6f, 0xda, 0x80, 0x31,
			0x69, 0xca, 0x35, 0xc9, 0x63, 0xde, 0xba, 0x60,
			0xaf, 0x14, 0xdc, 0x1b, 0xeb, 0x87, 0x68, 0x5b,
			0x3b, 0x07, 0x8b, 0x78, 0x1a, 0xd8, 0xaf, 0x7b,
			0x7b, 0x11, 0xa3, 0x41, 0x45, 0x59, 0xd4, 0xe6,
			0xa6, 0x7e, 0x33, 0x5b, 0xbc, 0x69, 0xca, 0x8e,
			0xdd, 0x5f, 0xf7, 0xe7, 0x17, 0x16, 0xd8, 0x6b,
			0x1e, 0x5b, 0xad, 0x37, 0xca, 0x02, 0x0d, 0x38,
			0x0d, 0xcb, 0x5e, 0x2d, 0x9b, 0x70, 0x40, 0x75,
			0x10, 0x15, 0xa0, 0x61, 0x75, 0x32, 0x30, 0xb1,
			0x55, 0x0e, 0x41, 0xfc, 0x30, 0x60, 0x56, 0xef,
			0xaa, 0x43, 0x47, 0x3d, 0xda, 0x95, 0xd2, 0xaf,
			0xb5, 0x2c, 0x45, 0xda, 0xeb, 0xa2, 0xc2, 0x5b,
			0xb4, 0x46, 0x82, 0x8b, 0x7b, 0x62, 0x15, 0xe1,
			0x92, 0xf3, 0x5f, 0x77, 0x5c, 0x04, 0x74, 0x30,
			0xc5, 0x1f, 0x59, 0x1e, 0x2e, 0xa7, 0x7f, 0x65,
			0xdd, 0x94, 0x38, 0x59, 0x73, 0x14, 0x67, 0x7a,
			0x02, 0x7c, 0x99, 0x47, 0x9f, 0x2d, 0x2e, 0x41,
			0x75, 0xa2, 0xee, 0xdc, 0x1a, 0xe4, 0x81, 0xcc,
			0x9e, 0x84, 0x0d, 0xcd, 0x62, 0xbf, 0x46, 0xda,
			0xbd, 0x50, 0x13, 0x88, 0x24, 0x54, 0x15, 0x45,
			0x3a, 0xdc, 0xd5, 0x7c, 0x42, 0x8c, 0x31, 0x5f,
			0x6b, 0xb2, 0x10, 0xc3, 0x23, 0xdf, 0x50, 0x04,
			0xdf, 0xf3, 0xfb, 0x1f, 0x7c, 0x8b, 0x00, 0xee,
			0xc7, 0x41, 0x60, 0x12, 0x47, 0x91, 0x77, 0x90,
			0x3a, 0xda, 0x20, 0xb1, 0x66, 0x9a, 0x13, 0xee,
			0xe4, 0x35, 0x9c, 0x12, 0xb8, 0xd2, 0x49, 0x72,
			0xae, 0xee, 0x73, 0xd4, 0x15, 0x93, 0xa2, 0x5f,
			0xb8, 0xa3, 0xad, 0x12, 0xf8, 0x66, 0x2c, 0x1b,
			0xe8, 0x7f, 0x37, 0xee, 0xf6, 0x5b, 0x97, 0x96,
			0xbc, 0xb9, 0xfe, 0x53, 0x8f, 0x0f, 0xd7, 0x19,
			0xe8, 0x86, 0xec, 0x96, 0x86, 0x35, 0x2a, 0x87,
		},
	},
	/* SHA224 [8] */
	{
		/* Msg8 : 128 byte */
		{
			0x7d, 0x56, 0x33, 0x4f, 0x10, 0x03, 0x35, 0x6b,
			0x97, 0x1e, 0x13, 0x84, 0x71, 0x59, 0x48, 0x7b,
			0x12, 0x28, 0x04, 0x0a, 0x56, 0xc7, 0x24, 0xef,
			0x15, 0x7e, 0x62, 0x4d, 0xf8, 0x24, 0xc9, 0x4f,
			0x8b, 0xe2, 0x6d, 0x0e, 0x93, 0x39, 0x58, 0xb5,
			0xa1, 0x46, 0xc7, 0xe3, 0xe7, 0x45, 0x97, 0x50,
			0x4b, 0x55, 0xfa, 0xb4, 0xba, 0x7a, 0x6e, 0xe4,
			0xbf, 0xe8, 0xf0, 0x3e, 0x54, 0x7f, 0x6c, 0x48,
			0xf8, 0x92, 0x79, 0x94, 0x01, 0xec, 0x43, 0xe7,
			0x34, 0x15, 0xc8, 0x99, 0x93, 0xd1, 0x48, 0x3f,
			0x76, 0xea, 0xf6, 0x88, 0xdd, 0x2f, 0xf4, 0x65,
			0x05, 0xbd, 0x7e, 0x6d, 0x39, 0x7d, 0x66, 0x7f,
			0xeb, 0xee, 0xc0, 0xa9, 0x03, 0x25, 0xde, 0x48,
			0x77, 0x12, 0x7f, 0x71, 0x1c, 0x04, 0x43, 0x90,
			0xbc, 0x6f, 0x62, 0x4f, 0x68, 0xee, 0x9e, 0xba,
			0x0f, 0x84, 0x76, 0xa0, 0x50, 0x27, 0x9d, 0x3c,
		},
		/* S8 : 256 byte */
		{
			0x46, 0x81, 0xbd, 0xfb, 0xe7, 0x0c, 0x05, 0xf7,
			0x79, 0x55, 0x6f, 0x88, 0x0a, 0x29, 0x3a, 0x73,
			0xe5, 0x45, 0x26, 0xac, 0x6f, 0x52, 0x31, 0xf4,
			0x5c, 0xbc, 0x01, 0x5e, 0x7c, 0xa0, 0x37, 0x67,
			0xa2, 0x91, 0x16, 0x5e, 0x7c, 0xfc, 0xdf, 0xac,
			0x82, 0x95, 0x5c, 0x23, 0xa6, 0x1e, 0xd3, 0x06,
			0x08, 0xa5, 0x7e, 0xc0, 0xe1, 0xf2, 0xe6, 0x1f,
			0xb3, 0x00, 0x28, 0x9c, 0x5f, 0xe2, 0x40, 0x1b,
			0xe5, 0xb0, 0x8f, 0x20, 0xa3, 0x7f, 0xa0, 0x63,
			0x54, 0xa5, 0x70, 0x2a, 0xc4, 0x00, 0x11, 0x55,
			0x3f, 0x16, 0xd9, 0x0a, 0x14, 0x29, 0xc8, 0x51,
			0x55, 0x8d, 0x07, 0x10, 0x31, 0x3c, 0x82, 0x36,
			0x85, 0x9f, 0x88, 0x2d, 0x46, 0x10, 0x0d, 0xee,
			0x4a, 0x30, 0x91, 0xb5, 0x74, 0x2c, 0x74, 0x7b,
			0x84, 0x14, 0xe5, 0xe2, 0xad, 0x67, 0x67, 0xbd,
			0x55, 0x75, 0x05, 0xe9, 0x35, 0x2a, 0xf4, 0x0f,
			0x18, 0x7c, 0xec, 0x49, 0xff, 0xbe, 0xbc, 0x34,
			0xc4, 0xef, 0x33, 0xe6, 0x42, 0x8d, 0xcb, 0xf3,
			0xd4, 0xde, 0x34, 0xc4, 0xb7, 0x82, 0xac, 0x01,
			0x62, 0x03, 0xb7, 0xc0, 0x46, 0x04, 0xca, 0x5e,
			0x7d, 0xd2, 0x3b, 0xb7, 0x8c, 0xfd, 0xdb, 0xc2,
			0x61, 0xb3, 0x96, 0x80, 0x64, 0x44, 0xf1, 0xf9,
			0x1b, 0x1e, 0x8a, 0x5a, 0x39, 0x7c, 0xb4, 0x77,
			0xfb, 0x51, 0x0b, 0x61, 0x70, 0xb9, 0xbd, 0x8c,
			0xc5, 0x11, 0xe6, 0x19, 0xe4, 0x80, 0x52, 0x91,
			0x23, 0x2c, 0xbc, 0x8a, 0x02, 0x67, 0xad, 0x94,
			0xc2, 0x6f, 0x60, 0x3e, 0xc2, 0xf7, 0x3d, 0x38,
			0x07, 0x76, 0x4a, 0x9a, 0x11, 0x4e, 0x20, 0x42,
			0xa7, 0x87, 0xd6, 0x28, 0x46, 0xf4, 0x58, 0xb7,
			0x6b, 0xcb, 0x72, 0x8c, 0xc9, 0xc9, 0xfd, 0xf6,
			0x78, 0x59, 0x71, 0x8a, 0x4e, 0x69, 0x10, 0xac,
			0xf0, 0x6b, 0x6c, 0x22, 0x2b, 0xe8, 0x67, 0xbc,
		},
	},
	/* SHA224 [9] */
	{
		/* Msg9 : 128 byte */
		{
			0xf9, 0x6c, 0x50, 0xdf, 0xae, 0x37, 0x6c, 0x4f,
			0x4d, 0xd0, 0x84, 0x9e, 0xdd, 0xed, 0x04, 0xd7,
			0x4b, 0x99, 0x5e, 0xf3, 0xbc, 0x35, 0xfe, 0xfc,
			0x22, 0xbc, 0x7f, 0x73, 0x0d, 0x4b, 0x1f, 0xf0,
			0xc5, 0xe0, 0x70, 0x08, 0x95, 0x61, 0x51, 0x73,
			0x69, 0xe1, 0x1d, 0x6e, 0x9c, 0x20, 0x22, 0x5f,
			0x0b, 0x50, 0x55, 0xb8, 0x6e, 0x1f, 0x43, 0x1d,
			0xe8, 0xf1, 0x4b, 0xc9, 0xdc, 0x6d, 0x0b, 0x2e,
			0x03, 0x3c, 0x18, 0xdb, 0xbb, 0x0d, 0xf2, 0xa3,
			0xa2, 0xdd, 0x37, 0xfc, 0x64, 0x75, 0x16, 0xa5,
			0xd1, 0x34, 0x07, 0x8c, 0x33, 0x0e, 0xb9, 0xee,
			0xde, 0xd5, 0x4c, 0xc0, 0x08, 0xb7, 0xc1, 0x4e,
			0xdb, 0x09, 0xaf, 0x22, 0xc9, 0x43, 0x37, 0x27,
			0x20, 0x4b, 0x39, 0x0e, 0xde, 0xf6, 0xc8, 0xf1,
			0xc6, 0xcc, 0xdc, 0x36, 0xb3, 0x0b, 0x47, 0xb7,
			0x2d, 0xef, 0xeb, 0x1f, 0x3a, 0x31, 0x29, 0x97,
		},
		/* S9 : 256 byte */
		{
			0x5a, 0xe3, 0x3e, 0x70, 0xf8, 0xbc, 0x70, 0x1a,
			0x97, 0xff, 0x73, 0x91, 0xdd, 0xe8, 0xa1, 0xb4,
			0x98, 0x17, 0x73, 0x30, 0xd4, 0xea, 0x94, 0xc9,
			0x8f, 0x4d, 0x10, 0x9d, 0xcc, 0xe7, 0x45, 0x88,
			0xe9, 0xba, 0xeb, 0x6e, 0xec, 0x78, 0x3d, 0x68,
			0xc1, 0x0b, 0xe4, 0x5a, 0x9a, 0x89, 0x52, 0x53,
			0xd2, 0x4b, 0x28, 0x90, 0x87, 0xc2, 0xa9, 0x01,
			0xe2, 0x13, 0xa2, 0x1c, 0x88, 0xe7, 0x98, 0x7c,
			0x4a, 0x62, 0xa5, 0xf3, 0xb6, 0xb6, 0xe7, 0xc2,
			0x8b, 0xd1, 0xad, 0xb1, 0x2d, 0xf1, 0x75, 0xdb,
			0xde, 0xc2, 0x2f, 0x48, 0xe4, 0x5d, 0x44, 0x1c,
			0xcc, 0xb1, 0x78, 0x18, 0x78, 0xe5, 0xe5, 0x31,
			0xd7, 0x26, 0xe3, 0xd8, 0x65, 0x8d, 0xa8, 0x72,
			0x7a, 0x22, 0x83, 0xdd, 0x9f, 0x7e, 0x78, 0xa8,
			0xb4, 0x6e, 0x56, 0x53, 0x12, 0x8d, 0x95, 0x25,
			0x49, 0x78, 0xf5, 0x20, 0x99, 0xe6, 0xcb, 0x23,
			0x0c, 0xc4, 0x49, 0x89, 0x30, 0x41, 0xfe, 0xf6,
			0x3a, 0x48, 0xe4, 0x99, 0x03, 0x85, 0x74, 0xd1,
			0xfc, 0xc3, 0xe1, 0xe2, 0x6b, 0x6c, 0x85, 0xf3,
			0x8a, 0xa1, 0xcb, 0x14, 0xbe, 0xc8, 0xc7, 0x60,
			0x0c, 0x0b, 0x7f, 0x39, 0x1e, 0x00, 0x6c, 0x9d,
			0x5d, 0xb2, 0x24, 0x71, 0x8c, 0x54, 0x8c, 0x19,
			0xc3, 0x66, 0x7c, 0x43, 0xb5, 0xf4, 0xce, 0x65,
			0x14, 0xba, 0x41, 0xbe, 0xc0, 0xc2, 0xd9, 0xb2,
			0x70, 0xbd, 0xd5, 0xc9, 0x11, 0xd9, 0x2e, 0x27,
			0x34, 0xfd, 0x11, 0xd0, 0x38, 0x7a, 0x3b, 0x65,
			0x00, 0xcb, 0x35, 0x30, 0xd8, 0x7c, 0x2a, 0x64,
			0x7b, 0x1c, 0x7c, 0x05, 0xa4, 0x44, 0x7a, 0x41,
			0x39, 0x70, 0x7a, 0xae, 0x7e, 0xb3, 0x7c, 0x05,
			0xfd, 0x96, 0x6e, 0xcd, 0xca, 0x8b, 0x4c, 0x8d,
			0x11, 0xb1, 0x41, 0xcd, 0x16, 0xc4, 0xd4, 0x7b,
			0xa7, 0x52, 0x0b, 0xc4, 0xd1, 0x6c, 0x1f, 0xba,
		},
	},
};

/* 10 elements */
static mod2048_t SHA256[] = {
	/* SHA256 [0] */
	{
		/* Msg0 : 128 byte */
		{
			0x65, 0x04, 0x92, 0x1a, 0x97, 0xcd, 0x57, 0xaa,
			0x8f, 0x38, 0x63, 0xdc, 0x32, 0xe1, 0xf2, 0xd0,
			0xb5, 0x7a, 0xff, 0x63, 0x10, 0x6e, 0x59, 0xf6,
			0xaf, 0xc3, 0xf9, 0x72, 0x6b, 0x45, 0x93, 0x88,
			0xba, 0xe1, 0x6b, 0x3e, 0x22, 0x4f, 0x6a, 0xa7,
			0xf4, 0xf4, 0x71, 0xf1, 0x36, 0x06, 0xed, 0xa6,
			0xe1, 0xf1, 0xac, 0x2b, 0x4d, 0xf9, 0xef, 0x8d,
			0xe9, 0x21, 0xc0, 0x7c, 0x2f, 0x4c, 0x85, 0x98,
			0xd7, 0xa3, 0xd6, 0xec, 0x4b, 0x36, 0x8c, 0xb8,
			0x5c, 0xe6, 0x1a, 0x74, 0x33, 0x82, 0x21, 0x11,
			0x8a, 0x30, 0x3e, 0x82, 0x1c, 0x0f, 0x27, 0x7b,
			0x59, 0x1a, 0xf6, 0x79, 0x5f, 0x50, 0xc4, 0x02,
			0x26, 0x12, 0x7a, 0x2e, 0xfa, 0xcc, 0xe4, 0x66,
			0x2f, 0xd7, 0x07, 0x6c, 0x10, 0x9e, 0xb5, 0x9b,
			0x18, 0x00, 0x5e, 0x71, 0x65, 0xf6, 0x29, 0x4a,
			0x69, 0x76, 0x43, 0x6e, 0xe3, 0x97, 0x77, 0x4e,
		},
		/* S0 : 256 byte */
		{
			0x33, 0x5f, 0xfa, 0xdc, 0x0b, 0x1b, 0x8b, 0xd2,
			0xb1, 0xeb, 0x67, 0x0d, 0xd2, 0x46, 0xe7, 0x6d,
			0xcc, 0xcd, 0xc9, 0x55, 0xa1, 0x68, 0x7a, 0x15,
			0xf7, 0x4a, 0xa3, 0xe1, 0x59, 0x6e, 0xbd, 0x43,
			0xe6, 0x07, 0xc6, 0x40, 0x52, 0x5f, 0x89, 0xdd,
			0xa9, 0x58, 0x09, 0xcf, 0xd0, 0x65, 0xf1, 0xbe,
			0x4e, 0x4a, 0x24, 0x94, 0x77, 0xd2, 0x4f, 0x40,
			0x0d, 0x4d, 0x4c, 0x94, 0x38, 0xa0, 0xaf, 0x95,
			0xb2, 0x6b, 0x28, 0xb4, 0x16, 0xe4, 0x2a, 0xa9,
			0x50, 0xe2, 0xa5, 0x28, 0x51, 0xb5, 0x21, 0x32,
			0x04, 0x8f, 0x1b, 0x1c, 0xe9, 0x44, 0x32, 0x2f,
			0xc9, 0x9c, 0x1a, 0xab, 0xb4, 0x9b, 0x7f, 0xae,
			0x4c, 0x2f, 0x0f, 0xef, 0x67, 0x4b, 0x50, 0xad,
			0xee, 0x3b, 0xbb, 0x5c, 0x6c, 0x33, 0x82, 0x2b,
			0x60, 0x8e, 0x4b, 0x95, 0x77, 0x27, 0x5c, 0xa2,
			0x0c, 0x71, 0x0a, 0xf9, 0xfc, 0x41, 0xb1, 0xc0,
			0x1d, 0x9c, 0x0f, 0xf6, 0xf0, 0xd8, 0x32, 0x4d,
			0xc0, 0x8e, 0x1a, 0x76, 0xe2, 0x32, 0xd8, 0xfe,
			0xaa, 0x06, 0xc7, 0x3b, 0xbf, 0x64, 0x05, 0x3b,
			0xea, 0x35, 0xf1, 0xc5, 0x28, 0xb2, 0x72, 0x27,
			0x64, 0x82, 0x2e, 0xf1, 0xff, 0x06, 0x24, 0x6e,
			0x75, 0xa9, 0xa2, 0x2a, 0x10, 0xda, 0x4e, 0xa8,
			0x4f, 0xc2, 0x44, 0x1b, 0xea, 0x24, 0xb3, 0x55,
			0x06, 0xf8, 0x44, 0x7f, 0xcf, 0x69, 0x09, 0x3c,
			0x5d, 0x21, 0xab, 0x03, 0x05, 0xcc, 0xe2, 0xc7,
			0xea, 0x9f, 0xfa, 0xc3, 0x57, 0xc6, 0x64, 0xb4,
			0x91, 0xfc, 0x55, 0xf2, 0x91, 0x9e, 0xc4, 0x90,
			0xc3, 0x8a, 0xcc, 0xba, 0xb3, 0x78, 0xc2, 0x52,
			0xac, 0x2d, 0xf3, 0x84, 0x5a, 0xcf, 0xf5, 0x75,
			0xec, 0x75, 0x24, 0xcd, 0x2f, 0x58, 0x6c, 0xca,
			0x14, 0x97, 0xc7, 0x4f, 0x24, 0xb2, 0x99, 0xd6,
			0xd6, 0x25, 0x4c, 0x8c, 0xdb, 0x1d, 0x22, 0x7d,
		},
	},
	/* SHA256 [1] */
	{
		/* Msg1 : 128 byte */
		{
			0x1a, 0x53, 0xa9, 0xd6, 0x31, 0x29, 0x18, 0xf3,
			0xdb, 0x6b, 0xd5, 0x76, 0x6d, 0xa9, 0x81, 0x85,
			0x41, 0x66, 0xdd, 0xf2, 0xb6, 0x13, 0xeb, 0xc8,
			0x79, 0x3f, 0x50, 0x23, 0x03, 0x08, 0xfd, 0x45,
			0x63, 0xd5, 0x0e, 0xe7, 0x3e, 0x47, 0xf2, 0xcd,
			0x14, 0x6c, 0xcd, 0x9d, 0xc4, 0x36, 0x1a, 0xf1,
			0x53, 0x2c, 0x95, 0xab, 0xe9, 0x60, 0x58, 0x89,
			0x1c, 0xa1, 0x44, 0xf9, 0x71, 0xf1, 0xa2, 0x2e,
			0x20, 0x3a, 0x0a, 0x73, 0x18, 0x3c, 0x84, 0xbf,
			0x43, 0xca, 0xee, 0x8a, 0x0b, 0x36, 0x9e, 0xe0,
			0x1d, 0x0a, 0x48, 0xb4, 0x6d, 0xf8, 0x21, 0x76,
			0x7a, 0x14, 0x44, 0xe8, 0xd3, 0x41, 0x55, 0x2d,
			0xda, 0xe9, 0x65, 0x22, 0xc8, 0xf2, 0x16, 0xf2,
			0xf1, 0xed, 0x00, 0xe5, 0x4a, 0x90, 0x53, 0x79,
			0x28, 0x66, 0xbd, 0xb4, 0x4a, 0xc5, 0x8e, 0xb8,
			0x1a, 0x01, 0x1a, 0x98, 0x30, 0xdf, 0x5e, 0x6a,
		},
		/* S1 : 256 byte */
		{
			0x7b, 0x17, 0xb1, 0x3a, 0x5c, 0xe4, 0x48, 0x5c,
			0xa3, 0xb9, 0x79, 0xbe, 0x3b, 0x14, 0xd7, 0x75,
			0x32, 0xfc, 0xba, 0xc1, 0x4e, 0x46, 0x0a, 0x54,
			0x51, 0x5a, 0x6a, 0xa7, 0xd2, 0x13, 0xef, 0x14,
			0x10, 0xca, 0xdd, 0x00, 0x9c, 0xe6, 0x0b, 0xfe,
			0xc4, 0x5b, 0xf4, 0x94, 0x51, 0x43, 0x38, 0x91,
			0x3a, 0x27, 0x92, 0xbb, 0x60, 0x86, 0xa4, 0xcc,
			0x21, 0xdb, 0xe8, 0x52, 0xc2, 0xb5, 0x7a, 0x3f,
			0xf5, 0x93, 0x10, 0x39, 0x97, 0x3c, 0xda, 0xcb,
			0xba, 0x96, 0xe2, 0xee, 0x77, 0xfb, 0x8e, 0xc6,
			0xc8, 0x7c, 0x14, 0xea, 0x10, 0x76, 0x2e, 0x2a,
			0xa9, 0x27, 0x9a, 0xe5, 0x19, 0x2c, 0xa1, 0xc8,
			0x7e, 0xde, 0xdb, 0xed, 0xfb, 0x30, 0x5f, 0xb0,
			0x06, 0xa5, 0x16, 0x02, 0xe6, 0xbf, 0x4d, 0xc4,
			0x3b, 0x99, 0x4f, 0x41, 0x9c, 0x97, 0x9b, 0x4f,
			0x30, 0x71, 0x98, 0x27, 0xa3, 0x48, 0x94, 0x82,
			0x14, 0xee, 0x71, 0x56, 0x53, 0x61, 0xf6, 0x68,
			0xdb, 0xf8, 0x1e, 0xf6, 0xe9, 0x42, 0x97, 0xa3,
			0xcc, 0xd6, 0x83, 0x57, 0xfc, 0xcc, 0xa6, 0xdd,
			0xa2, 0x37, 0x91, 0x1c, 0x93, 0x8d, 0x6e, 0x71,
			0x78, 0x7b, 0x3d, 0x40, 0x85, 0xc6, 0x6c, 0x7c,
			0xa2, 0xaa, 0xd2, 0xdb, 0x16, 0x27, 0x4d, 0xf2,
			0x3a, 0xd1, 0x92, 0x11, 0xaa, 0x63, 0x80, 0xbe,
			0x75, 0xcf, 0x0b, 0x19, 0x25, 0x7a, 0xf4, 0xdf,
			0x5a, 0xf1, 0xe6, 0x20, 0x10, 0xdf, 0xfd, 0x23,
			0xb9, 0x74, 0x2f, 0x53, 0x69, 0xe0, 0x08, 0x22,
			0x4e, 0xe4, 0x03, 0x31, 0xf2, 0x38, 0x74, 0x22,
			0x09, 0x5f, 0x6e, 0x5a, 0xfe, 0x0e, 0x12, 0x5f,
			0x85, 0x5d, 0xe2, 0x20, 0x64, 0x8a, 0x84, 0x5c,
			0xbd, 0xe5, 0x42, 0xff, 0x7f, 0x99, 0xd9, 0x26,
			0x86, 0x88, 0x19, 0xaa, 0xd9, 0x24, 0xb3, 0x91,
			0x96, 0x54, 0x48, 0x3b, 0xbc, 0x6d, 0x8d, 0xd8,
		},
	},
	/* SHA256 [2] */
	{
		/* Msg2 : 128 byte */
		{
			0xdd, 0xf5, 0x75, 0x0a, 0xba, 0x4b, 0xe6, 0x9c,
			0x94, 0x4d, 0x71, 0x89, 0x63, 0x61, 0xf2, 0x10,
			0xf9, 0x61, 0xee, 0x6b, 0x38, 0xf9, 0x6e, 0x54,
			0x81, 0x50, 0x0e, 0xc7, 0x6f, 0xea, 0x51, 0x0a,
			0xc6, 0xcd, 0x37, 0xeb, 0xa6, 0xe2, 0x12, 0x49,
			0x05, 0x9f, 0x95, 0xd5, 0x5c, 0xe3, 0x2e, 0x1a,
			0x9f, 0x21, 0x96, 0xbb, 0x73, 0xc1, 0xa6, 0xfc,
			0x9c, 0xc3, 0x6c, 0x84, 0xb4, 0xa6, 0x7e, 0x62,
			0x23, 0x88, 0x8e, 0x4d, 0x4b, 0x8e, 0x3f, 0x30,
			0x03, 0x86, 0x37, 0xe6, 0x47, 0xcb, 0x75, 0x41,
			0x2d, 0x69, 0xe5, 0x52, 0x1b, 0x82, 0x32, 0xe4,
			0x38, 0xf1, 0xdc, 0x4a, 0x20, 0x2c, 0x8a, 0x5b,
			0xdc, 0x6f, 0xa1, 0xba, 0x11, 0x17, 0x15, 0x5b,
			0x77, 0x4c, 0x80, 0x42, 0x8d, 0xe2, 0x71, 0x8e,
			0x8c, 0x81, 0x06, 0xb7, 0x99, 0x04, 0xbd, 0x14,
			0x3e, 0x20, 0x87, 0xa0, 0x1b, 0x46, 0x1e, 0xfd,
		},
		/* S2 : 256 byte */
		{
			0x9e, 0x32, 0x92, 0x58, 0x45, 0x93, 0x1c, 0x2b,
			0xaa, 0xfb, 0xac, 0xa8, 0xdf, 0x10, 0x9c, 0xcc,
			0xd9, 0x22, 0xba, 0x72, 0xe6, 0xf4, 0xb8, 0x38,
			0xa7, 0x61, 0x98, 0xb1, 0xf3, 0x17, 0x3e, 0x90,
			0x69, 0xcc, 0xf7, 0x5d, 0x0c, 0x96, 0xd6, 0xe2,
			0x64, 0x4a, 0xde, 0x92, 0xb2, 0x90, 0x43, 0xf6,
			0xbd, 0xbd, 0xcf, 0xc8, 0xb0, 0xb2, 0x79, 0x4b,
			0x4e, 0xe1, 0x6b, 0x1a, 0x8e, 0xf8, 0xeb, 0x2d,
			0xd2, 0xfa, 0x3d, 0xa4, 0xba, 0xcf, 0x76, 0x59,
			0xe4, 0x3e, 0x70, 0xd6, 0x9c, 0x13, 0x2b, 0xf9,
			0xcb, 0x1b, 0xa8, 0x58, 0x4b, 0xf3, 0xc1, 0xe0,
			0xa7, 0xc8, 0x80, 0x35, 0x66, 0x17, 0x77, 0x42,
			0xc9, 0x77, 0xe4, 0x47, 0xd3, 0x57, 0xfb, 0x03,
			0x31, 0xdd, 0x31, 0x12, 0xe7, 0xd3, 0xc0, 0xf1,
			0xb5, 0x77, 0x2a, 0x7c, 0xf5, 0xe1, 0xe3, 0x68,
			0xcb, 0x58, 0xb1, 0xa1, 0x88, 0x89, 0xcf, 0xf9,
			0x13, 0x6b, 0xd5, 0x6b, 0x5c, 0xc3, 0xfe, 0x6b,
			0xcf, 0xc5, 0xa9, 0xf2, 0x6d, 0xd6, 0x07, 0x15,
			0xa8, 0x07, 0xf3, 0xc7, 0xca, 0x23, 0x6c, 0x89,
			0xdd, 0xb3, 0x6e, 0xba, 0xfd, 0xe6, 0x2b, 0x35,
			0xa6, 0x24, 0x28, 0x41, 0x21, 0xf5, 0x6d, 0x81,
			0xf5, 0xa4, 0xd2, 0x15, 0xb7, 0xa3, 0x69, 0x76,
			0xee, 0xd2, 0xc7, 0x8a, 0x3c, 0x44, 0xcc, 0x86,
			0x4c, 0x6a, 0x5c, 0x01, 0xf4, 0xef, 0x9f, 0x54,
			0xef, 0xc4, 0xbe, 0xb9, 0x47, 0xb9, 0x6e, 0x9a,
			0xeb, 0x50, 0xaf, 0x62, 0x21, 0xde, 0xa9, 0x6d,
			0x62, 0x0b, 0xaa, 0xad, 0x23, 0x5e, 0x9b, 0xa6,
			0xa0, 0x03, 0xfd, 0xd3, 0x9f, 0x31, 0x38, 0x8a,
			0x4c, 0x35, 0x79, 0xdd, 0xdc, 0x0a, 0x51, 0xe8,
			0x79, 0xe1, 0x28, 0x6a, 0xc1, 0x42, 0x60, 0x1d,
			0x2e, 0x57, 0x25, 0xc1, 0xea, 0x9d, 0x44, 0xaa,
			0x89, 0x6a, 0x12, 0xd2, 0x90, 0x47, 0xaa, 0x3e,
		},
	},
	/* SHA256 [3] */
	{
		/* Msg3 : 128 byte */
		{
			0xf8, 0x66, 0xae, 0x4a, 0x8c, 0x37, 0xce, 0x71,
			0xc0, 0xe0, 0x47, 0xec, 0xdf, 0x0b, 0x6b, 0xd0,
			0x7f, 0x8b, 0x11, 0xad, 0xbd, 0x92, 0xf3, 0x63,
			0xca, 0x24, 0x55, 0x36, 0xa7, 0xcb, 0xe8, 0x24,
			0x2c, 0x8d, 0xed, 0x75, 0x4f, 0x1b, 0x9d, 0x95,
			0xa3, 0x4b, 0xc9, 0x1f, 0x1f, 0xc8, 0xbe, 0x3a,
			0x21, 0x08, 0x6b, 0x28, 0xb2, 0x7f, 0xc6, 0x1c,
			0x0c, 0x13, 0x6b, 0x4c, 0x5a, 0xcf, 0x86, 0x48,
			0xbe, 0xdb, 0xf4, 0x8a, 0x98, 0xac, 0xa5, 0x4e,
			0x06, 0x78, 0x45, 0xa4, 0xa7, 0xed, 0x1b, 0xc3,
			0xa5, 0x22, 0x31, 0xa0, 0xf2, 0xce, 0xb5, 0xbf,
			0xd1, 0xb8, 0x9f, 0x49, 0x99, 0x6e, 0x94, 0x60,
			0xb5, 0x3a, 0x0a, 0xaf, 0xf0, 0x52, 0xae, 0x45,
			0xf0, 0x4f, 0x02, 0xa3, 0xff, 0xe0, 0x4b, 0x13,
			0x12, 0xc0, 0xaa, 0x3c, 0x03, 0xe5, 0x89, 0xf4,
			0x22, 0xfb, 0x38, 0x55, 0xec, 0x10, 0xd8, 0x13,
		},
		/* S3 : 256 byte */
		{
			0xbd, 0x4d, 0x7d, 0xb1, 0xd1, 0x7c, 0x3f, 0x56,
			0x06, 0x2a, 0x1d, 0xd4, 0x30, 0x7d, 0x93, 0x9d,
			0xdd, 0x40, 0x3c, 0xbf, 0x04, 0xb0, 0x86, 0x66,
			0x03, 0x54, 0x1f, 0xa8, 0xde, 0x37, 0xce, 0x80,
			0xbf, 0x06, 0xd7, 0x96, 0xef, 0xde, 0xad, 0x69,
			0x63, 0xf6, 0x03, 0xd8, 0x1e, 0x37, 0x6d, 0xac,
			0x20, 0x45, 0x4c, 0x49, 0x64, 0xc1, 0xe6, 0xfa,
			0x34, 0x7c, 0x8d, 0xd7, 0x68, 0x42, 0x15, 0x58,
			0x07, 0x79, 0xbe, 0x97, 0xf9, 0x4c, 0x82, 0x79,
			0xef, 0xd0, 0x16, 0x9e, 0xa0, 0xcf, 0xdd, 0x28,
			0x2d, 0x35, 0x38, 0xba, 0xfe, 0x06, 0x7f, 0xf5,
			0xad, 0x9e, 0x62, 0x4c, 0xbb, 0x24, 0xf4, 0x2f,
			0x18, 0x11, 0x28, 0x7f, 0xda, 0x09, 0x03, 0xaf,
			0xd3, 0xb5, 0x16, 0x87, 0x5a, 0x8e, 0xbd, 0xbc,
			0x81, 0xb4, 0xa6, 0x32, 0x86, 0xa3, 0x5b, 0xd6,
			0x61, 0x56, 0xf6, 0x57, 0xf1, 0x10, 0xb9, 0x90,
			0x9e, 0x98, 0x30, 0x43, 0x13, 0x3c, 0xbf, 0x0d,
			0x0f, 0xd1, 0xcd, 0xdb, 0x4a, 0x3e, 0x1f, 0xe0,
			0x96, 0x2e, 0x41, 0x2a, 0xf9, 0x16, 0x82, 0xe4,
			0x42, 0x62, 0x86, 0x95, 0x24, 0xc9, 0x25, 0x57,
			0xf5, 0xd8, 0xfb, 0x38, 0x5f, 0xa1, 0x6e, 0x87,
			0x30, 0x4a, 0xaf, 0x53, 0x4e, 0x90, 0xd2, 0x56,
			0x68, 0x46, 0x00, 0x38, 0x17, 0x70, 0xb7, 0x76,
			0x29, 0xd1, 0xa7, 0xe8, 0xf4, 0xcb, 0xc9, 0xf9,
			0x56, 0xa1, 0xe0, 0xd2, 0xe4, 0x1b, 0xf5, 0x72,
			0x07, 0xc6, 0x77, 0xab, 0xf6, 0xf3, 0x80, 0x94,
			0xed, 0x0e, 0x6a, 0xd4, 0x81, 0x0d, 0x49, 0xeb,
			0x09, 0xb5, 0x1e, 0xd2, 0x9a, 0xd6, 0x08, 0x7f,
			0x72, 0xee, 0x01, 0x9a, 0x4f, 0x99, 0xa8, 0x16,
			0xd1, 0x42, 0xc1, 0x55, 0xfe, 0x91, 0xc9, 0x3c,
			0x38, 0xf9, 0x28, 0xfb, 0x15, 0x58, 0xe3, 0x74,
			0x3d, 0x54, 0x5e, 0xc3, 0xcf, 0x8f, 0xf4, 0xb8,
		},
	},
	/* SHA256 [4] */
	{
		/* Msg4 : 128 byte */
		{
			0xd7, 0x37, 0xbd, 0x27, 0x29, 0xd1, 0x83, 0x5f,
			0x24, 0x39, 0x83, 0xfb, 0xc1, 0x52, 0xa1, 0x9a,
			0x2e, 0x65, 0x9a, 0x5d, 0x21, 0x1f, 0xf3, 0x00,
			0x6d, 0xd9, 0x2f, 0x4a, 0xd3, 0x1d, 0x45, 0xa8,
			0x1a, 0x65, 0x51, 0x15, 0x61, 0x25, 0x8a, 0x3c,
			0xb5, 0x0c, 0x74, 0xe1, 0xdf, 0x87, 0x57, 0x7d,
			0x7f, 0x88, 0xef, 0x28, 0x5f, 0x85, 0x65, 0xbc,
			0x01, 0xc3, 0x7e, 0x38, 0x7a, 0xd4, 0x13, 0x62,
			0x83, 0x5f, 0xc1, 0xb1, 0xce, 0x1f, 0xe1, 0x69,
			0x96, 0x2e, 0xba, 0x08, 0x7a, 0x84, 0xf6, 0xe1,
			0x8b, 0xba, 0x53, 0x07, 0xa4, 0x14, 0x9b, 0x6c,
			0xfa, 0xbf, 0xd6, 0x4a, 0xf3, 0x57, 0xbe, 0xc2,
			0x3c, 0xad, 0x73, 0xc4, 0x16, 0xc6, 0x70, 0x2e,
			0xf0, 0x27, 0xbe, 0x38, 0x3b, 0x4f, 0x67, 0x0f,
			0x7a, 0x86, 0x2e, 0xc0, 0x98, 0xd5, 0x7d, 0x58,
			0x7f, 0x56, 0x9f, 0x49, 0xe6, 0xae, 0x2f, 0x10,
		},
		/* S4 : 256 byte */
		{
			0x58, 0x1e, 0x5c, 0x15, 0x7c, 0x6b, 0x96, 0x09,
			0x33, 0xba, 0xfa, 0x5d, 0x7f, 0xee, 0x27, 0x46,
			0x59, 0x6d, 0xb4, 0x90, 0xa5, 0x77, 0x61, 0xad,
			0xe4, 0xae, 0xa0, 0xf7, 0x6e, 0xf6, 0x58, 0xd8,
			0x32, 0xb6, 0x03, 0xe8, 0xcb, 0x9e, 0x03, 0xa8,
			0x53, 0xbe, 0x53, 0xe0, 0x2d, 0x4d, 0xea, 0xec,
			0x2e, 0x77, 0x64, 0xe1, 0x44, 0x15, 0x17, 0x35,
			0x16, 0x93, 0x5d, 0xb1, 0xb8, 0x68, 0xc8, 0xf7,
			0x95, 0x2e, 0xef, 0x47, 0xc0, 0xcc, 0x57, 0xf0,
			0x11, 0x85, 0x3b, 0x6a, 0x77, 0xec, 0x99, 0xb5,
			0x6a, 0x01, 0xc0, 0xf4, 0xa1, 0xb0, 0x83, 0xf1,
			0x23, 0xe3, 0xde, 0xe8, 0xee, 0x13, 0x12, 0x94,
			0x97, 0x89, 0xb3, 0xa4, 0x10, 0x90, 0x8f, 0x2a,
			0xfc, 0xaf, 0x81, 0xa1, 0x8e, 0xa6, 0xdc, 0x68,
			0x53, 0x01, 0xd4, 0x71, 0xf9, 0x1b, 0x1d, 0x73,
			0x06, 0x93, 0x32, 0x96, 0x16, 0xa4, 0xaa, 0x46,
			0x0c, 0x53, 0x82, 0x5c, 0x3e, 0x24, 0x46, 0x95,
			0x71, 0xde, 0x2b, 0x55, 0xfe, 0x7b, 0x9e, 0x2f,
			0xf5, 0x03, 0x1b, 0x2d, 0x3e, 0x2a, 0xce, 0xd2,
			0x43, 0x2f, 0xa8, 0x5c, 0x4e, 0xc2, 0xef, 0x03,
			0x56, 0xc2, 0x3b, 0xa8, 0x1d, 0xc5, 0x89, 0xa6,
			0xaa, 0xa4, 0x70, 0xd1, 0x55, 0x55, 0x63, 0x63,
			0x37, 0x01, 0x4c, 0xee, 0x7c, 0x6c, 0x76, 0xf5,
			0xdd, 0xf3, 0x5e, 0x1a, 0xa0, 0xaa, 0xf3, 0x42,
			0xfa, 0xf8, 0x0d, 0x46, 0x74, 0x69, 0x2b, 0x90,
			0x2c, 0x84, 0x65, 0xf6, 0x0a, 0x8f, 0x55, 0xd6,
			0xb3, 0xc2, 0xd3, 0xea, 0x5a, 0x6b, 0xcc, 0x24,
			0xcc, 0xf3, 0xfb, 0x3d, 0xf7, 0xeb, 0x0e, 0x50,
			0xc8, 0x45, 0x31, 0x4d, 0x26, 0xef, 0x5e, 0xd8,
			0x14, 0x1b, 0x73, 0xf7, 0x9c, 0xe6, 0x4d, 0x25,
			0xd0, 0xe6, 0x47, 0xd6, 0x6c, 0x87, 0x55, 0x03,
			0xc9, 0x21, 0x31, 0x78, 0x92, 0xd1, 0x69, 0xfb,
		},
	},
	/* SHA256 [5] */
	{
		/* Msg5 : 128 byte */
		{
			0x10, 0xe3, 0xb4, 0x53, 0x71, 0x94, 0x69, 0x22,
			0x7b, 0x51, 0xda, 0x0c, 0x41, 0xb5, 0xcf, 0x0f,
			0xd9, 0x4b, 0x32, 0xb6, 0xb3, 0x96, 0x0b, 0x3c,
			0x28, 0x55, 0xaf, 0xf5, 0x56, 0x04, 0x33, 0xea,
			0x2c, 0xa6, 0x27, 0xc3, 0xc1, 0xc2, 0x81, 0xeb,
			0xea, 0xac, 0xd8, 0xee, 0x0b, 0x05, 0xd3, 0x26,
			0x2d, 0x85, 0xe0, 0x96, 0x51, 0xf8, 0x29, 0x16,
			0x04, 0x87, 0xc4, 0xb1, 0x34, 0x39, 0x29, 0x4b,
			0x42, 0xba, 0xea, 0x86, 0x58, 0x5a, 0x9e, 0xe7,
			0xfd, 0x58, 0x1e, 0x35, 0xe7, 0x61, 0xf5, 0x22,
			0x10, 0x54, 0x11, 0x2e, 0x0c, 0x48, 0xbf, 0xc7,
			0x99, 0xd0, 0xd6, 0xb5, 0x78, 0x7e, 0x31, 0xb5,
			0x7b, 0xa5, 0x63, 0x64, 0xe0, 0x63, 0xa7, 0x5f,
			0xdd, 0xdf, 0x16, 0xa9, 0x7c, 0xd0, 0x1d, 0x4d,
			0xa9, 0x3f, 0x2d, 0x44, 0x89, 0x8d, 0xb4, 0x98,
			0x0e, 0xb7, 0x4d, 0xca, 0xc9, 0xd9, 0x33, 0x72,
		},
		/* S5 : 256 byte */
		{
			0xdd, 0x2e, 0xa0, 0x39, 0x39, 0xbc, 0x68, 0xd1,
			0xd4, 0x08, 0x35, 0xa0, 0x99, 0xaa, 0xa3, 0xee,
			0x57, 0xa4, 0xf1, 0x1e, 0x30, 0xad, 0x44, 0x85,
			0x08, 0x90, 0x74, 0xd3, 0x45, 0xe5, 0x73, 0x63,
			0xbd, 0x6d, 0x3c, 0x17, 0xb8, 0x6c, 0xf3, 0x5d,
			0x06, 0x29, 0xea, 0x91, 0x73, 0x0a, 0x0c, 0x8e,
			0xe3, 0x64, 0xac, 0x80, 0xa0, 0x16, 0xcf, 0xdd,
			0xb6, 0x87, 0x5e, 0x1b, 0xff, 0x46, 0x3a, 0xe2,
			0x84, 0xb8, 0x49, 0x59, 0xe5, 0x20, 0x46, 0x94,
			0x5e, 0xe9, 0x16, 0x25, 0x65, 0x82, 0xfa, 0xca,
			0xe7, 0x19, 0xc3, 0x3c, 0x6e, 0x89, 0x2a, 0x3a,
			0x7a, 0xaa, 0xac, 0xdb, 0xc3, 0x00, 0xc7, 0x64,
			0x86, 0x63, 0x3c, 0x87, 0x20, 0xe6, 0x20, 0x7b,
			0xeb, 0x64, 0x01, 0xf1, 0x25, 0x89, 0x97, 0xa0,
			0xbd, 0x33, 0xc7, 0x52, 0xea, 0x47, 0x99, 0xec,
			0x99, 0x68, 0x5a, 0xc1, 0xfb, 0x90, 0x66, 0xca,
			0xe4, 0x5f, 0xc8, 0x61, 0x60, 0x8c, 0xd7, 0x4a,
			0xad, 0xb3, 0x67, 0xfd, 0xeb, 0xd2, 0x8f, 0xcf,
			0x88, 0xf5, 0x2c, 0xe4, 0x94, 0x2f, 0x74, 0xc8,
			0xa5, 0x3e, 0x80, 0x9f, 0xe4, 0x95, 0x34, 0x34,
			0xd6, 0x48, 0x41, 0x13, 0x50, 0x1a, 0x40, 0x60,
			0x5a, 0x11, 0xc4, 0x60, 0xbd, 0x9c, 0xf2, 0x90,
			0xe3, 0x7e, 0xfe, 0x33, 0xb1, 0x61, 0xb9, 0x6b,
			0x63, 0xc2, 0x27, 0x0d, 0xc1, 0xc3, 0x66, 0x91,
			0x00, 0xd1, 0x08, 0x5a, 0xfd, 0x73, 0x8c, 0xf8,
			0x72, 0x3c, 0xc9, 0xf2, 0x32, 0xf6, 0x79, 0xff,
			0xee, 0x07, 0xe1, 0xd5, 0x36, 0xa7, 0xd5, 0x6b,
			0xd2, 0x24, 0x8f, 0x37, 0x61, 0x0f, 0xa5, 0x82,
			0x67, 0x1d, 0x64, 0x14, 0x44, 0x0c, 0xaf, 0xfd,
			0x10, 0xaa, 0x3d, 0x09, 0xb9, 0x5f, 0xad, 0x2c,
			0x2c, 0x41, 0xbf, 0x0c, 0xa3, 0x36, 0x99, 0xcf,
			0x07, 0x49, 0x11, 0x0f, 0x81, 0x7a, 0x4f, 0x63,
		},
	},
	/* SHA256 [6] */
	{
		/* Msg6 : 128 byte */
		{
			0xd1, 0x30, 0xb2, 0xfd, 0x9a, 0x7a, 0x1f, 0x11,
			0x8a, 0x5d, 0x9b, 0x6c, 0x4b, 0xeb, 0xc0, 0xd4,
			0xd4, 0x4f, 0xdb, 0xec, 0x8c, 0x61, 0x37, 0x66,
			0xb2, 0x77, 0x9f, 0x74, 0xfc, 0x7d, 0x1e, 0x7f,
			0x7e, 0x48, 0x09, 0x1c, 0xce, 0x27, 0x3f, 0x3c,
			0x66, 0xbb, 0xb0, 0xa2, 0x49, 0x09, 0x1c, 0x9b,
			0xea, 0xce, 0x1d, 0xe9, 0x49, 0x12, 0x68, 0x00,
			0x5f, 0x00, 0x50, 0x75, 0xbc, 0xf5, 0x8c, 0xb3,
			0x6f, 0xd7, 0x39, 0xf0, 0x26, 0xa8, 0x23, 0x5f,
			0x96, 0x5b, 0x40, 0xa7, 0x1d, 0xe6, 0x7d, 0x95,
			0xa6, 0x98, 0xbd, 0x0d, 0xce, 0xad, 0x1f, 0x47,
			0x45, 0x20, 0x80, 0x38, 0x76, 0xc0, 0x42, 0x4d,
			0x6a, 0x86, 0x4b, 0x5f, 0xe9, 0x26, 0x50, 0xe4,
			0xe3, 0xe4, 0x53, 0x62, 0x0f, 0xa9, 0x6a, 0x2a,
			0xd2, 0x56, 0xc3, 0x42, 0x62, 0x58, 0xe5, 0xa3,
			0x2b, 0x7d, 0x38, 0xa4, 0x72, 0x05, 0xc8, 0xb7,
		},
		/* S6 : 256 byte */
		{
			0x2b, 0x6c, 0x07, 0x65, 0x6b, 0x39, 0x8f, 0x3b,
			0x33, 0x87, 0x62, 0x7f, 0x51, 0xaa, 0xa5, 0x1e,
			0x8f, 0x90, 0x5e, 0xf0, 0x7d, 0x7b, 0xd8, 0x2b,
			0x35, 0x53, 0x96, 0xbf, 0x32, 0x86, 0x52, 0x27,
			0xf5, 0xbf, 0x3e, 0x0c, 0xd3, 0xe8, 0xe1, 0xaa,
			0x44, 0x84, 0x1e, 0x40, 0x28, 0xe6, 0x1c, 0x58,
			0xcb, 0xe8, 0x39, 0xfb, 0x8b, 0x75, 0x82, 0x65,
			0x2c, 0x37, 0xf7, 0xfb, 0xf8, 0xb5, 0x1f, 0xab,
			0x98, 0x0e, 0x76, 0x63, 0x5c, 0x38, 0xac, 0xa9,
			0x8b, 0x99, 0x27, 0xdc, 0x1e, 0x5f, 0x17, 0x63,
			0x33, 0x39, 0xd6, 0xe9, 0x03, 0xbe, 0x5b, 0xbc,
			0x65, 0xfd, 0x7a, 0x7a, 0x92, 0x8d, 0xdf, 0x45,
			0x9b, 0xef, 0x84, 0xa6, 0x37, 0x0c, 0x32, 0x58,
			0xdc, 0xc8, 0x10, 0xcf, 0xe2, 0x72, 0x27, 0x4d,
			0x06, 0xa1, 0xdb, 0xed, 0x89, 0xbf, 0x12, 0x1b,
			0xe3, 0xc1, 0x69, 0x9f, 0xc1, 0x29, 0xd5, 0x5d,
			0x3d, 0xec, 0xa9, 0xd7, 0xb1, 0x0d, 0xe4, 0x1b,
			0xd7, 0xf4, 0x79, 0x44, 0xe2, 0x6d, 0x0e, 0x94,
			0xbe, 0x9a, 0x70, 0x8b, 0x10, 0xb3, 0xa7, 0x29,
			0xef, 0x9a, 0xe5, 0x9a, 0xc9, 0x86, 0xde, 0x71,
			0xfe, 0x45, 0x22, 0x28, 0x48, 0x73, 0xa1, 0x9b,
			0xc1, 0x77, 0x80, 0x4e, 0xcb, 0x9a, 0xca, 0xd6,
			0x51, 0x05, 0x5e, 0x7d, 0xc4, 0xf5, 0xd2, 0x95,
			0x90, 0xeb, 0xc6, 0xd6, 0xf9, 0x65, 0xa5, 0x1d,
			0xc5, 0xb4, 0x58, 0x96, 0x99, 0xe0, 0x1a, 0xc4,
			0x2a, 0xeb, 0x57, 0x90, 0x32, 0xd5, 0x95, 0x4f,
			0x16, 0x0c, 0xde, 0xa3, 0x80, 0xb0, 0xf3, 0xc4,
			0x86, 0x12, 0x4b, 0xf8, 0xed, 0x88, 0x84, 0xc6,
			0x86, 0x13, 0x88, 0xff, 0x7a, 0xfa, 0xa2, 0xfb,
			0x0b, 0x07, 0xcc, 0x99, 0x90, 0x48, 0x13, 0x53,
			0x78, 0xa1, 0x6e, 0x00, 0x6d, 0x83, 0xa9, 0x88,
			0x37, 0xd2, 0x59, 0x56, 0x8e, 0x89, 0x82, 0x3d,
		},
	},
	/* SHA256 [7] */
	{
		/* Msg7 : 128 byte */
		{
			0x81, 0x1f, 0xb8, 0x02, 0x8f, 0x9c, 0x8c, 0xe4,
			0x11, 0xdc, 0xb6, 0xee, 0x9f, 0x6b, 0x9d, 0xb6,
			0x09, 0x28, 0xb9, 0xad, 0x8d, 0xa6, 0x5d, 0xa1,
			0x4d, 0xd3, 0xd4, 0x86, 0x00, 0xd7, 0xb0, 0x75,
			0xe7, 0x3f, 0x5f, 0xf5, 0x02, 0x5b, 0xff, 0x7a,
			0x85, 0xe4, 0x73, 0x2b, 0x86, 0xe2, 0xb7, 0xe8,
			0xf8, 0xcd, 0x70, 0x8c, 0xdc, 0xf3, 0xc8, 0x6f,
			0xb6, 0x19, 0x78, 0x30, 0x3e, 0x65, 0x26, 0xb1,
			0x59, 0x7c, 0xf2, 0x62, 0x47, 0xe7, 0x4c, 0xc3,
			0x1e, 0xbb, 0x08, 0x24, 0x77, 0x79, 0xb4, 0xaf,
			0x67, 0x33, 0x29, 0xa9, 0xb1, 0xf0, 0x60, 0xf5,
			0x39, 0x52, 0x87, 0xda, 0xbc, 0x76, 0x54, 0x06,
			0xbf, 0x1c, 0x9a, 0xd2, 0xc5, 0x08, 0x1a, 0xc7,
			0xc5, 0xa8, 0x9b, 0x61, 0xdb, 0xf6, 0x3d, 0x14,
			0x3e, 0xa0, 0x0a, 0x8d, 0x72, 0x66, 0xce, 0x3a,
			0xbf, 0xc4, 0x28, 0x0c, 0xe1, 0xd2, 0xe2, 0x7c,
		},
		/* S7 : 256 byte */
		{
			0xc3, 0x3f, 0x9d, 0xd3, 0x37, 0xfc, 0x09, 0xda,
			0x68, 0x9d, 0x1b, 0xe3, 0x05, 0x57, 0x19, 0x70,
			0x15, 0x81, 0xc3, 0xc1, 0xb4, 0x1f, 0xf7, 0xe5,
			0x74, 0xdb, 0x69, 0x76, 0xff, 0x7b, 0x99, 0x11,
			0xc5, 0xa4, 0x38, 0x2c, 0x9f, 0xac, 0x34, 0x6b,
			0x8d, 0xd6, 0xef, 0x15, 0x0f, 0x5d, 0x19, 0x48,
			0x53, 0xdf, 0x3b, 0xe3, 0x84, 0xac, 0xb0, 0x3b,
			0x68, 0x1a, 0xab, 0x5c, 0x88, 0x44, 0xe3, 0x1d,
			0x39, 0x65, 0x8f, 0x73, 0x14, 0x17, 0xac, 0x94,
			0x2b, 0x88, 0xb2, 0xbb, 0xa6, 0x74, 0xe0, 0x1e,
			0xb1, 0x51, 0xf3, 0x5a, 0xdd, 0x8f, 0xd0, 0xe6,
			0x5c, 0x47, 0x38, 0xb7, 0x15, 0x0e, 0x97, 0xc2,
			0x0e, 0x57, 0x7b, 0xb3, 0x20, 0xd1, 0x0f, 0x87,
			0x28, 0x00, 0xdf, 0x2d, 0xf5, 0x50, 0x95, 0xac,
			0x67, 0xb2, 0xfe, 0x4b, 0x51, 0x80, 0x5a, 0x7c,
			0x6d, 0xab, 0x3c, 0x28, 0x8e, 0xda, 0x94, 0xc9,
			0x16, 0x99, 0xa7, 0xf8, 0x59, 0x29, 0xa3, 0xf9,
			0x8e, 0xc9, 0x20, 0x08, 0xbf, 0x88, 0x4d, 0x70,
			0x37, 0xaf, 0xfe, 0x06, 0x38, 0xa9, 0x1c, 0x54,
			0x0c, 0x35, 0x1e, 0x2c, 0xd4, 0x1b, 0x3b, 0x26,
			0xf3, 0x8c, 0x4a, 0xe7, 0x03, 0x3f, 0xab, 0x21,
			0x15, 0xf8, 0x40, 0xa6, 0xdf, 0x4c, 0x08, 0x17,
			0x3c, 0x70, 0x52, 0x49, 0x9a, 0xe8, 0x17, 0x05,
			0x2c, 0x06, 0x8c, 0x6c, 0x34, 0x94, 0x2d, 0x47,
			0xa0, 0xad, 0xef, 0xd4, 0x0e, 0xed, 0xbc, 0x7c,
			0xee, 0x3f, 0x48, 0x98, 0xc0, 0x44, 0xf0, 0x57,
			0x90, 0x33, 0x4b, 0xe9, 0x42, 0x3c, 0x52, 0x31,
			0xeb, 0x56, 0x96, 0x26, 0x0a, 0xb8, 0xf7, 0xd6,
			0xfc, 0x6e, 0x5b, 0x1b, 0x86, 0xa7, 0xe3, 0x62,
			0x54, 0x1e, 0x20, 0x51, 0x32, 0x94, 0xb9, 0xd5,
			0x20, 0x64, 0x40, 0xee, 0xe2, 0x19, 0x89, 0x76,
			0x58, 0x4b, 0x58, 0x40, 0xfa, 0x68, 0xe5, 0xa1,
		},
	},
	/* SHA256 [8] */
	{
		/* Msg8 : 128 byte */
		{
			0xce, 0xdf, 0xd1, 0xc0, 0x12, 0x6a, 0x62, 0xae,
			0xa3, 0xe7, 0xa3, 0x0a, 0x73, 0x09, 0xc2, 0x58,
			0xc6, 0x9a, 0xb7, 0xc2, 0xf0, 0x28, 0x27, 0x67,
			0x60, 0xfb, 0x88, 0xf5, 0xdd, 0x4a, 0x87, 0x7a,
			0x10, 0xae, 0xa6, 0x77, 0x43, 0xd6, 0x2a, 0x37,
			0x68, 0x7d, 0x34, 0x5e, 0x5d, 0x99, 0x2e, 0xc5,
			0x6e, 0xd5, 0x68, 0x85, 0x1c, 0x42, 0x03, 0x52,
			0x1c, 0x49, 0x0f, 0x0b, 0xa3, 0xe5, 0xf0, 0x8e,
			0xe1, 0x0f, 0x06, 0xd1, 0xcb, 0x79, 0x8d, 0x2f,
			0x1e, 0x7e, 0xc1, 0xff, 0xa1, 0x59, 0x46, 0x6b,
			0xaa, 0x96, 0xc8, 0x80, 0xe3, 0xc7, 0xdf, 0x81,
			0x4e, 0x78, 0x35, 0x81, 0x87, 0x65, 0xea, 0x30,
			0x4a, 0xea, 0x37, 0xf6, 0x34, 0xba, 0x52, 0x3e,
			0xce, 0xd4, 0x92, 0x15, 0xc7, 0xb3, 0xd4, 0xf3,
			0x81, 0xc5, 0x1d, 0xd8, 0xd0, 0x1f, 0x81, 0x9b,
			0xfe, 0x6f, 0x43, 0x7f, 0x12, 0x32, 0x3d, 0x08,
		},
		/* S8 : 256 byte */
		{
			0x18, 0xc4, 0x54, 0xb5, 0x08, 0x14, 0xf0, 0x0d,
			0xa8, 0x85, 0x89, 0xf5, 0x33, 0xb8, 0x7f, 0x8e,
			0xa5, 0x19, 0x5b, 0xed, 0xbd, 0x3e, 0x1b, 0x2f,
			0xcc, 0xe3, 0xfa, 0xca, 0x0a, 0xb7, 0x68, 0xd7,
			0x1d, 0x93, 0x0a, 0x28, 0xb2, 0x9d, 0x24, 0x04,
			0x4c, 0x23, 0x1c, 0x0f, 0x24, 0x04, 0x18, 0x00,
			0xe7, 0x62, 0xcd, 0x72, 0x71, 0xc5, 0x45, 0xcd,
			0xf7, 0xf9, 0x91, 0x3f, 0x86, 0xca, 0xa5, 0xea,
			0x49, 0x3d, 0x1a, 0x99, 0x49, 0x02, 0xf9, 0xec,
			0xc1, 0xc0, 0xda, 0xf1, 0xc5, 0x71, 0xc2, 0xae,
			0xc7, 0x8c, 0x4f, 0xf7, 0x5e, 0x87, 0x3f, 0xef,
			0x3d, 0x68, 0x61, 0x43, 0x2f, 0x22, 0x7d, 0xd5,
			0xde, 0x63, 0x5d, 0x23, 0x15, 0xc9, 0x3e, 0x10,
			0xbb, 0xb3, 0xcb, 0xab, 0x1e, 0x98, 0x1a, 0xb5,
			0x47, 0xb5, 0x33, 0x83, 0x14, 0x31, 0x53, 0xc0,
			0xa4, 0xa3, 0xce, 0x2d, 0x75, 0x76, 0xd8, 0x9e,
			0x68, 0x83, 0x27, 0xf1, 0x66, 0x36, 0xf3, 0xee,
			0x38, 0xf6, 0xdb, 0xdd, 0xc0, 0xed, 0x42, 0xaf,
			0x36, 0xb0, 0x82, 0x47, 0xd9, 0xc9, 0x12, 0x83,
			0xee, 0x2c, 0x52, 0x81, 0x10, 0x10, 0xfb, 0x0a,
			0x10, 0xa3, 0xde, 0x69, 0xb6, 0xe4, 0x2f, 0xa1,
			0x1a, 0xd4, 0x4f, 0x76, 0xf4, 0x76, 0x6b, 0x9d,
			0x6f, 0xd0, 0xea, 0x17, 0x97, 0x90, 0xcd, 0x37,
			0xee, 0x5a, 0xa2, 0x2b, 0x62, 0xb8, 0x01, 0x0a,
			0x24, 0x2e, 0xa1, 0x5c, 0x2d, 0x0f, 0x9c, 0xd7,
			0x56, 0x4f, 0x16, 0x45, 0xb6, 0x5c, 0xc4, 0x38,
			0x09, 0x39, 0x44, 0xd6, 0x0e, 0xb0, 0xdc, 0x42,
			0xaf, 0xcd, 0x35, 0xb1, 0x6c, 0x54, 0xc9, 0x62,
			0x80, 0x70, 0xe5, 0xeb, 0x93, 0x82, 0x60, 0x03,
			0xc8, 0x4a, 0xe6, 0x65, 0x73, 0xb8, 0x4a, 0x62,
			0x3a, 0x28, 0x89, 0x97, 0xbc, 0x57, 0xa8, 0x7a,
			0x30, 0x34, 0xa3, 0x92, 0xa4, 0xe5, 0x4b, 0x80,
		},
	},
	/* SHA256 [9] */
	{
		/* Msg9 : 128 byte */
		{
			0x7a, 0xd2, 0x0f, 0xc0, 0xe2, 0x88, 0x66, 0x91,
			0x31, 0x9e, 0x5c, 0x41, 0xa6, 0xe4, 0xd4, 0x38,
			0xe3, 0x0b, 0x0b, 0xcf, 0xa9, 0x5a, 0x7b, 0xa8,
			0xe3, 0xa2, 0x00, 0x40, 0xe6, 0x74, 0x3a, 0xc7,
			0xf7, 0x91, 0x32, 0x2f, 0x0d, 0xa2, 0x40, 0x83,
			0xd9, 0x2a, 0x2c, 0x7a, 0x04, 0xb8, 0x93, 0x4c,
			0xb8, 0x61, 0x8c, 0xc4, 0x61, 0x6d, 0x8c, 0x96,
			0xb5, 0x51, 0x87, 0xf4, 0xf2, 0xde, 0x58, 0x5c,
			0x66, 0xb7, 0x63, 0xb4, 0x35, 0x08, 0x79, 0x98,
			0x57, 0x75, 0xfc, 0xf3, 0xe0, 0x51, 0x43, 0xcc,
			0x84, 0x11, 0x3f, 0x63, 0x5a, 0x00, 0x5f, 0x7d,
			0xe0, 0x34, 0xb2, 0xfc, 0x40, 0xc0, 0x4c, 0xb2,
			0xd1, 0x2b, 0xea, 0x77, 0xe1, 0x21, 0xd9, 0x79,
			0xb2, 0x69, 0x13, 0xd4, 0xc2, 0x17, 0xac, 0x63,
			0x4f, 0x03, 0x6c, 0xd5, 0x1b, 0x79, 0xbe, 0x03,
			0x6d, 0x32, 0xc8, 0x80, 0x58, 0x83, 0xdc, 0x72,
		},
		/* S9 : 256 byte */
		{
			0x3f, 0x48, 0xd2, 0xf0, 0x19, 0x74, 0x5b, 0x09,
			0x15, 0x88, 0x18, 0x24, 0x51, 0x53, 0x9c, 0x3b,
			0x1c, 0x76, 0x10, 0x16, 0xa8, 0xd3, 0xbf, 0x38,
			0x6b, 0x3e, 0xf0, 0x46, 0xe7, 0x5c, 0x23, 0x62,
			0x8b, 0xe1, 0x4a, 0xee, 0xe1, 0xdb, 0x6b, 0xb8,
			0x76, 0x48, 0x5a, 0x2b, 0xe2, 0x50, 0x3b, 0x39,
			0x60, 0x3e, 0xd9, 0xe0, 0x7f, 0xe3, 0x5f, 0x61,
			0xcf, 0x20, 0x51, 0xbd, 0x8e, 0x4f, 0xfb, 0x28,
			0x1e, 0xe9, 0x60, 0xb1, 0x71, 0xef, 0xc4, 0x9f,
			0x61, 0xbe, 0x17, 0x35, 0x63, 0x43, 0xaa, 0xc7,
			0xd2, 0x60, 0xa1, 0xf2, 0xb2, 0x9a, 0x77, 0xcc,
			0x81, 0xdf, 0xf3, 0x6d, 0x5d, 0x5e, 0x75, 0xdc,
			0xb1, 0x11, 0x51, 0x50, 0x1c, 0x62, 0x1e, 0x0f,
			0xa1, 0x88, 0x3c, 0xee, 0xe2, 0xb5, 0xbe, 0xfb,
			0x8b, 0x95, 0x27, 0x4f, 0x0b, 0x3b, 0x3f, 0x0a,
			0xf0, 0xc2, 0x28, 0x2a, 0x35, 0x27, 0xa2, 0x00,
			0x34, 0x6f, 0x27, 0xc7, 0xa6, 0x75, 0x5a, 0x5a,
			0x4f, 0x5b, 0xe9, 0x42, 0x49, 0x67, 0xe1, 0xed,
			0x09, 0xa3, 0x12, 0xd0, 0xd9, 0x10, 0x15, 0x6d,
			0xd8, 0xdf, 0x5f, 0x6f, 0x20, 0x9a, 0xb5, 0xbc,
			0x05, 0xb8, 0x6f, 0x02, 0xc3, 0xd3, 0xbd, 0x45,
			0x26, 0xbf, 0xc0, 0xf9, 0x2e, 0x35, 0x42, 0x39,
			0x95, 0x92, 0xb5, 0xff, 0x47, 0x79, 0x2e, 0x3f,
			0xc8, 0xb1, 0x1e, 0x36, 0x74, 0x96, 0xd7, 0xaf,
			0x60, 0x13, 0xaf, 0xff, 0x2c, 0x43, 0x3f, 0x91,
			0xf9, 0xae, 0x47, 0x9e, 0xc7, 0x01, 0x16, 0xe0,
			0x66, 0x3d, 0x53, 0xf8, 0xe4, 0xde, 0x05, 0x3a,
			0x0d, 0xa5, 0xc9, 0x34, 0x63, 0x27, 0x15, 0x64,
			0x76, 0x8a, 0x7c, 0x0d, 0xf0, 0x98, 0xd7, 0x44,
			0x75, 0x86, 0x30, 0x65, 0x9b, 0x84, 0x96, 0x4d,
			0x61, 0xaa, 0x94, 0x0e, 0xe0, 0xaa, 0x3a, 0xed,
			0xa9, 0x6e, 0x8a, 0x14, 0xdb, 0xe0, 0xf8, 0x13,
		},
	},
};

/* 10 elements */
static mod2048_t SHA384[] = {
	/* SHA384 [0] */
	{
		/* Msg0 : 128 byte */
		{
			0xdb, 0x2e, 0x9f, 0xbe, 0xfd, 0x98, 0x32, 0xd2,
			0x9e, 0x60, 0x15, 0xb9, 0x76, 0x73, 0x4f, 0xf1,
			0x5a, 0x5c, 0x11, 0x77, 0xa9, 0x15, 0x3b, 0x38,
			0xe6, 0x1d, 0x22, 0xc8, 0xa6, 0xca, 0x90, 0x56,
			0xad, 0xe1, 0x0d, 0xe0, 0x54, 0x64, 0x5d, 0xa3,
			0x2e, 0xab, 0x4a, 0xd6, 0xea, 0xb6, 0xa4, 0x97,
			0x7b, 0xc2, 0x85, 0x26, 0x77, 0x1a, 0xd9, 0x51,
			0xbd, 0x30, 0x1e, 0x2f, 0x5b, 0xec, 0x69, 0x11,
			0xaf, 0x44, 0xaa, 0xb6, 0xcc, 0x0d, 0x30, 0xbe,
			0x1e, 0x11, 0x70, 0x61, 0x52, 0x61, 0x02, 0x61,
			0x70, 0xed, 0xec, 0x3d, 0x4a, 0x51, 0x23, 0xa8,
			0x1a, 0xf2, 0x4f, 0x39, 0x67, 0x4a, 0xcf, 0x64,
			0x28, 0x80, 0xfd, 0xa9, 0x2c, 0x3c, 0xb3, 0x0b,
			0xb9, 0xb9, 0x0e, 0xc4, 0x74, 0x1c, 0x71, 0x37,
			0x80, 0x04, 0xcd, 0x26, 0xea, 0x62, 0x20, 0x25,
			0x45, 0x8b, 0x3c, 0x4f, 0x91, 0x8b, 0xca, 0x37,
		},
		/* S0 : 256 byte */
		{
			0x21, 0x13, 0x98, 0xc0, 0x68, 0xe6, 0x0a, 0xe4,
			0x9e, 0xe2, 0xb8, 0xb7, 0xcd, 0x96, 0x17, 0x13,
			0x73, 0xf4, 0x66, 0x4c, 0xf4, 0x5b, 0x62, 0x41,
			0x5d, 0x9b, 0xcf, 0x11, 0x91, 0x84, 0xc0, 0x32,
			0x74, 0xae, 0xc2, 0xb3, 0xf0, 0x4c, 0x59, 0x80,
			0x43, 0xd1, 0xd8, 0x64, 0x2d, 0x53, 0xed, 0xad,
			0x68, 0xd0, 0xe0, 0xbc, 0x33, 0xfd, 0xc6, 0x5e,
			0xd6, 0x93, 0x34, 0xab, 0x52, 0x30, 0x3c, 0x83,
			0x9c, 0xbb, 0xaf, 0x05, 0x86, 0x50, 0x80, 0x07,
			0xdc, 0xf4, 0xad, 0x5d, 0x29, 0x7f, 0x56, 0x80,
			0x39, 0xdc, 0x16, 0xa1, 0xe6, 0xc0, 0x81, 0x08,
			0xa0, 0x05, 0x0d, 0x5d, 0xcf, 0x47, 0x52, 0x3e,
			0x48, 0x68, 0xe4, 0xbe, 0x72, 0xf2, 0x0d, 0x78,
			0x9b, 0x06, 0xbc, 0xb9, 0x24, 0x84, 0xef, 0xa2,
			0xfc, 0xd9, 0x03, 0xae, 0x28, 0x0f, 0x42, 0xa5,
			0x09, 0xda, 0xdb, 0xe6, 0x2d, 0xce, 0x1c, 0x6d,
			0x3a, 0xef, 0x6e, 0x4f, 0xf7, 0x8a, 0x74, 0x5c,
			0x85, 0x00, 0xff, 0x05, 0x72, 0x74, 0x8a, 0xbb,
			0x1a, 0x22, 0x04, 0x95, 0xc1, 0xc1, 0x03, 0xa7,
			0x2c, 0x94, 0x02, 0x06, 0x34, 0x7c, 0x16, 0xae,
			0x60, 0x82, 0xdd, 0x1e, 0x46, 0x24, 0x52, 0x5a,
			0xa8, 0xed, 0x8f, 0x11, 0x8d, 0x09, 0xbe, 0x2b,
			0x85, 0x35, 0xd0, 0x42, 0xb2, 0x9e, 0xa3, 0xe2,
			0xc6, 0xab, 0x3c, 0x99, 0x0b, 0x4b, 0x59, 0x50,
			0x1c, 0x3b, 0xb9, 0xd6, 0x02, 0xc7, 0x81, 0x3a,
			0x55, 0xf4, 0xef, 0xc1, 0x29, 0xf4, 0xdf, 0xd0,
			0xfa, 0xbe, 0x0c, 0xf6, 0xb8, 0xc8, 0xc1, 0xd9,
			0x12, 0x6c, 0x54, 0x40, 0xcb, 0xec, 0x54, 0x05,
			0x72, 0x29, 0x27, 0x38, 0x9b, 0x3c, 0xa8, 0x0a,
			0x08, 0x72, 0x71, 0x13, 0x88, 0xb5, 0xb0, 0x99,
			0xcc, 0xe6, 0xef, 0xfe, 0xdf, 0xbd, 0x9b, 0xef,
			0xc9, 0x64, 0x6e, 0xa8, 0xa2, 0x58, 0xfd, 0xd0,
		},
	},
	/* SHA384 [1] */
	{
		/* Msg1 : 128 byte */
		{
			0x65, 0x74, 0xa1, 0xc1, 0x57, 0xe1, 0xd5, 0xf3,
			0x99, 0xda, 0xed, 0xdd, 0x81, 0x6c, 0x94, 0x10,
			0xb0, 0xc8, 0x08, 0x62, 0xf3, 0x96, 0x1e, 0xe4,
			0x67, 0x8b, 0x85, 0x14, 0xe1, 0x3e, 0x4e, 0x54,
			0x8c, 0x37, 0xac, 0x9b, 0xd4, 0x49, 0xf9, 0x6b,
			0x83, 0x23, 0xfa, 0x03, 0x2a, 0x21, 0x64, 0xd5,
			0xc3, 0x68, 0x9f, 0x3a, 0x94, 0x31, 0xc9, 0x65,
			0x57, 0x65, 0xfe, 0x95, 0x97, 0x6b, 0xd7, 0x8f,
			0x5d, 0x3d, 0x30, 0x4c, 0x0c, 0xc2, 0x2f, 0xef,
			0x8a, 0x58, 0x82, 0xfa, 0xa0, 0xaf, 0xe7, 0xc0,
			0xa4, 0xde, 0xf2, 0x1e, 0x55, 0xb0, 0x0b, 0x66,
			0x06, 0x3f, 0xb6, 0x9c, 0xff, 0xc5, 0x17, 0xe5,
			0x20, 0xae, 0xb5, 0x3c, 0xc7, 0xf2, 0x7e, 0x67,
			0xf4, 0xa1, 0x0b, 0x29, 0xab, 0xc0, 0x26, 0xba,
			0x9a, 0x53, 0x89, 0x74, 0xfc, 0xbb, 0xe9, 0xcf,
			0xbd, 0x42, 0x33, 0x8f, 0xdf, 0xf5, 0x16, 0x3c,
		},
		/* S1 : 256 byte */
		{
			0x03, 0xf3, 0x93, 0xbf, 0x6a, 0x20, 0x67, 0x7a,
			0x92, 0x56, 0x50, 0x76, 0xe7, 0xc6, 0x28, 0xa1,
			0x04, 0x90, 0xeb, 0x41, 0xb4, 0x50, 0x9a, 0xa6,
			0xef, 0x99, 0xac, 0xb0, 0xab, 0x88, 0x9c, 0xca,
			0xea, 0xb9, 0x86, 0x17, 0xc5, 0x9d, 0xbe, 0x49,
			0x92, 0x31, 0x39, 0x6e, 0x9d, 0xaf, 0xf7, 0xa2,
			0xbb, 0xae, 0xb3, 0xe3, 0xa1, 0x02, 0x58, 0xd4,
			0xf6, 0x05, 0xb8, 0x0c, 0x41, 0xd0, 0x16, 0x6c,
			0x5f, 0x0a, 0x17, 0x5a, 0x7b, 0x42, 0x47, 0x6c,
			0x03, 0xe5, 0x7f, 0x84, 0x42, 0x6f, 0x4d, 0xe9,
			0x8d, 0x74, 0x82, 0x9d, 0x40, 0xc0, 0x14, 0x53,
			0x99, 0x9c, 0xeb, 0xb9, 0x96, 0xc4, 0x17, 0x56,
			0xd4, 0x7f, 0x0b, 0x79, 0xfb, 0xfd, 0xff, 0x2f,
			0xaa, 0xb1, 0x11, 0xa5, 0xc7, 0xf0, 0x7f, 0x8f,
			0x76, 0x0e, 0x44, 0xd9, 0x53, 0x8f, 0xd1, 0xe3,
			0xb3, 0xc4, 0x30, 0x7a, 0x79, 0x15, 0x8e, 0x7d,
			0xff, 0x4e, 0xb0, 0xf0, 0xe5, 0x67, 0xbf, 0xa0,
			0xb6, 0x7d, 0x13, 0x87, 0x31, 0x0a, 0xc4, 0xf3,
			0x90, 0x67, 0x43, 0x57, 0x33, 0x2e, 0x85, 0x84,
			0x7c, 0x26, 0xfd, 0xaa, 0xc1, 0xdf, 0xe7, 0xc9,
			0x55, 0x85, 0xa6, 0x04, 0xbf, 0x70, 0xe3, 0xd4,
			0xa3, 0x36, 0x49, 0xc6, 0xc4, 0x86, 0x1d, 0xde,
			0x05, 0xff, 0x11, 0xcb, 0x5e, 0x60, 0xae, 0x59,
			0x06, 0x57, 0xd3, 0xf4, 0x55, 0xe6, 0xe6, 0x0e,
			0xc5, 0x5d, 0x17, 0x52, 0x49, 0x37, 0x68, 0xc9,
			0x2e, 0xc9, 0x54, 0xf2, 0x5b, 0x78, 0x0d, 0xac,
			0x22, 0x46, 0xa5, 0x0f, 0x87, 0xcf, 0xfc, 0x11,
			0xce, 0x9f, 0x78, 0xc0, 0xc1, 0x33, 0x9d, 0x9a,
			0x7b, 0xd9, 0xcb, 0x7e, 0x74, 0x7e, 0xbb, 0xfc,
			0x5b, 0x66, 0x69, 0xf4, 0xf4, 0x69, 0x44, 0xe8,
			0x97, 0x69, 0x51, 0x71, 0x72, 0x7b, 0x89, 0x55,
			0x0e, 0x2f, 0x9d, 0xff, 0x74, 0xb3, 0xde, 0x7b,
		},
	},
	/* SHA384 [2] */
	{
		/* Msg2 : 128 byte */
		{
			0x97, 0x67, 0xcc, 0x53, 0x0c, 0xa7, 0x72, 0x70,
			0xc9, 0x73, 0x45, 0x93, 0xcd, 0x5f, 0xd8, 0x11,
			0xea, 0x85, 0x2d, 0xf6, 0xc9, 0x7b, 0xd7, 0x9d,
			0x2e, 0x82, 0x5c, 0x7d, 0x7d, 0x00, 0xdd, 0x46,
			0x7e, 0x31, 0xf9, 0x2d, 0x5d, 0x19, 0xee, 0x83,
			0xf5, 0xbd, 0x01, 0x8d, 0x4d, 0x92, 0x21, 0x90,
			0x63, 0x36, 0xc7, 0x2b, 0x29, 0x5e, 0x20, 0xe9,
			0xce, 0x10, 0x6e, 0x17, 0x3e, 0x12, 0xac, 0xd3,
			0xec, 0xa2, 0x70, 0x66, 0xcf, 0x67, 0x16, 0xd4,
			0xaa, 0xa8, 0x1b, 0xb1, 0x91, 0xbc, 0xc7, 0x35,
			0xa9, 0xc1, 0x0f, 0x93, 0x2f, 0x91, 0xb9, 0x87,
			0xbc, 0xf2, 0xc1, 0x2e, 0xc7, 0x0d, 0xfc, 0x1b,
			0x6b, 0x22, 0xfb, 0xa7, 0x6a, 0x79, 0x32, 0x88,
			0x73, 0x9c, 0x59, 0xa6, 0xa0, 0xc3, 0x13, 0x2a,
			0x43, 0x90, 0xce, 0xd7, 0xe2, 0xfc, 0xea, 0x9d,
			0x80, 0x92, 0x1d, 0x6b, 0x1e, 0xdb, 0x16, 0x46,
		},
		/* S2 : 256 byte */
		{
			0x5f, 0x2a, 0x2b, 0x05, 0x88, 0x37, 0x33, 0x71,
			0xb1, 0xa9, 0xb4, 0x46, 0xa2, 0xa7, 0x5a, 0x10,
			0xf2, 0x14, 0x3e, 0x7a, 0x4d, 0x0c, 0x0b, 0x76,
			0x6e, 0x21, 0x7b, 0x7b, 0x93, 0x8e, 0xef, 0xcf,
			0x8b, 0x1a, 0x46, 0xae, 0x74, 0x2f, 0x9a, 0x39,
			0x0c, 0x3b, 0x02, 0xf6, 0x27, 0xf9, 0x28, 0x7f,
			0xa7, 0x12, 0x6d, 0xc1, 0xe5, 0x71, 0x57, 0x9b,
			0x87, 0xa6, 0xbe, 0xb8, 0x60, 0xa0, 0x12, 0xe7,
			0x3e, 0xfb, 0x7d, 0xf8, 0x53, 0xbb, 0x31, 0xdc,
			0x05, 0x6f, 0x68, 0x37, 0x3a, 0x91, 0xaf, 0x04,
			0x45, 0x92, 0xb2, 0x93, 0x9f, 0xd2, 0xf4, 0x95,
			0x01, 0x78, 0xbf, 0x83, 0xde, 0x1f, 0x0a, 0xff,
			0xe6, 0x06, 0x6d, 0xff, 0x57, 0x3c, 0x3a, 0x1e,
			0xe6, 0xd4, 0x13, 0xb8, 0xdf, 0xf7, 0x72, 0x00,
			0xca, 0xd6, 0x3a, 0x29, 0xba, 0xf6, 0x39, 0x99,
			0x25, 0x8a, 0x49, 0xe5, 0x5c, 0x71, 0x32, 0x81,
			0xea, 0x71, 0xe6, 0x0a, 0xd2, 0x07, 0x8c, 0xd4,
			0xfe, 0xcf, 0x6b, 0xcb, 0xdf, 0x5f, 0xb2, 0x12,
			0x1a, 0x32, 0x19, 0x15, 0x43, 0xa1, 0x6e, 0x51,
			0xde, 0x7d, 0x6b, 0xb0, 0xca, 0x0c, 0x89, 0x7a,
			0x8d, 0x89, 0x3f, 0x00, 0xf6, 0x42, 0x11, 0x13,
			0x93, 0x14, 0x8f, 0x6a, 0xcd, 0x41, 0x7b, 0xcf,
			0x70, 0x2b, 0x31, 0x8d, 0xc4, 0xc4, 0x01, 0x0a,
			0xb1, 0xe5, 0x71, 0x0a, 0x5b, 0x94, 0xf4, 0x11,
			0xbc, 0x5c, 0xb5, 0x4e, 0xa3, 0xbf, 0x21, 0x15,
			0x88, 0xf2, 0xb7, 0x88, 0x9c, 0xb0, 0xc3, 0xaf,
			0x95, 0x45, 0xe9, 0xa1, 0xd5, 0x32, 0x60, 0x62,
			0xec, 0xa6, 0xbd, 0x01, 0x5f, 0x4f, 0xc3, 0x83,
			0xdb, 0x37, 0x1c, 0xf6, 0x40, 0x7e, 0xb4, 0x6b,
			0x50, 0x1b, 0x19, 0xa8, 0x62, 0xed, 0x1e, 0xf9,
			0xe9, 0x43, 0xc9, 0xea, 0xa2, 0xae, 0xbc, 0x9b,
			0x6f, 0x20, 0x3e, 0x39, 0xa9, 0xe6, 0x92, 0xfa,
		},
	},
	/* SHA384 [3] */
	{
		/* Msg3 : 128 byte */
		{
			0x97, 0x4c, 0xd6, 0xe9, 0x8a, 0x4c, 0x88, 0xf9,
			0x27, 0x4b, 0x47, 0xc8, 0xda, 0x14, 0x83, 0x92,
			0x3b, 0xf4, 0x21, 0x3d, 0xea, 0x13, 0x7c, 0x47,
			0xbd, 0x03, 0xaa, 0xfe, 0x1e, 0x9a, 0x00, 0xef,
			0xae, 0xfd, 0xd8, 0xa0, 0x2f, 0xfe, 0x91, 0x82,
			0xa0, 0xa8, 0xd8, 0x21, 0xa9, 0x17, 0x26, 0x9e,
			0x3a, 0x8e, 0x8a, 0x5f, 0x70, 0xc3, 0xa9, 0x05,
			0xb8, 0x7d, 0x03, 0x9e, 0x36, 0x61, 0x78, 0x1c,
			0x68, 0x09, 0x0a, 0x07, 0x06, 0x57, 0xe4, 0x6e,
			0x2d, 0x09, 0x9c, 0x23, 0xbd, 0x8d, 0xb5, 0x28,
			0x00, 0x16, 0x68, 0x64, 0x8c, 0xef, 0xa3, 0x9a,
			0x6a, 0x10, 0x53, 0x9c, 0x77, 0xef, 0xdf, 0xbc,
			0x0b, 0x98, 0xf4, 0x84, 0xd9, 0x00, 0x88, 0xa7,
			0x16, 0x96, 0x19, 0x36, 0xde, 0x1c, 0x36, 0x17,
			0xd3, 0xb5, 0x41, 0xb4, 0x07, 0x3f, 0x73, 0xf0,
			0x1c, 0xe2, 0x20, 0x5f, 0xa9, 0xe9, 0x3d, 0xb6,
		},
		/* S3 : 256 byte */
		{
			0x9c, 0x36, 0xa3, 0xf2, 0x75, 0x03, 0x70, 0xdd,
			0xe8, 0x58, 0x11, 0xca, 0xae, 0x4d, 0x36, 0x1a,
			0x74, 0x99, 0xf8, 0xee, 0x1e, 0xad, 0x65, 0x80,
			0x3f, 0xa8, 0x61, 0x10, 0x00, 0x86, 0xee, 0x0f,
			0x5d, 0x96, 0xcd, 0xb3, 0x32, 0x02, 0x91, 0x6c,
			0x34, 0xb7, 0xd8, 0x61, 0x28, 0xa0, 0x23, 0x00,
			0x3b, 0xfb, 0x55, 0xeb, 0x43, 0xa1, 0x96, 0x93,
			0xfb, 0x32, 0xc1, 0x73, 0x93, 0xb7, 0x77, 0x77,
			0xe3, 0x4f, 0xbe, 0xc7, 0x01, 0xd6, 0xd0, 0xda,
			0xff, 0x8f, 0x89, 0xec, 0x5c, 0x33, 0x6f, 0x68,
			0xe5, 0xf6, 0x80, 0xda, 0x08, 0xbc, 0xe0, 0xe8,
			0xe5, 0x67, 0xd8, 0x66, 0x01, 0xc2, 0xce, 0x07,
			0x6c, 0x60, 0x3a, 0xb2, 0x92, 0xde, 0x50, 0xc9,
			0x78, 0x57, 0xfe, 0x34, 0xd5, 0x9f, 0x41, 0x05,
			0xc6, 0xce, 0xd0, 0x54, 0xe5, 0x98, 0x23, 0x97,
			0xcd, 0x9c, 0xbb, 0xf0, 0x8c, 0xeb, 0x53, 0xbd,
			0xfb, 0x90, 0xb6, 0xd7, 0x5f, 0x23, 0x1a, 0x60,
			0x10, 0x98, 0x82, 0x71, 0x86, 0xdf, 0x27, 0x98,
			0x07, 0x36, 0xce, 0x97, 0xe4, 0x09, 0x74, 0xc9,
			0x10, 0x11, 0x69, 0x1c, 0x2d, 0xde, 0x45, 0x37,
			0x60, 0x46, 0x7b, 0x09, 0x4b, 0xde, 0xae, 0xdf,
			0xb0, 0x35, 0x0c, 0x1e, 0xff, 0x96, 0xf2, 0x36,
			0xaf, 0x76, 0x8d, 0xea, 0x38, 0xc6, 0x5f, 0x52,
			0x0c, 0xf0, 0xb3, 0x65, 0x12, 0xdf, 0x93, 0x8b,
			0x31, 0xf9, 0xf7, 0x43, 0x51, 0xb2, 0x21, 0x40,
			0x5b, 0x1c, 0xd0, 0x4e, 0xfa, 0x76, 0x34, 0xac,
			0x7e, 0x96, 0x60, 0x29, 0xf4, 0x5f, 0x77, 0xaf,
			0xb6, 0x4b, 0xd7, 0xd2, 0xbe, 0x4e, 0x59, 0x22,
			0xa1, 0x50, 0xd3, 0xbf, 0xf3, 0x6f, 0x52, 0xa1,
			0x55, 0xba, 0x4a, 0xd1, 0x68, 0x03, 0x6a, 0x44,
			0x0d, 0x50, 0x60, 0xf2, 0xad, 0x6e, 0x32, 0x39,
			0x14, 0xbb, 0x47, 0x5a, 0x46, 0xa5, 0xd3, 0x5d,
		},
	},
	/* SHA384 [4] */
	{
		/* Msg4 : 128 byte */
		{
			0xcd, 0xe7, 0xaa, 0x5c, 0xc4, 0xc1, 0x18, 0x5b,
			0x2a, 0xa5, 0x69, 0xaf, 0x9c, 0x4c, 0xc6, 0xed,
			0x26, 0x1e, 0x3f, 0xf1, 0x08, 0xec, 0xb5, 0x2e,
			0xba, 0xe1, 0xf7, 0x42, 0x2d, 0xb6, 0x2b, 0xcd,
			0x54, 0x26, 0x70, 0x84, 0xe3, 0xa2, 0xc1, 0x81,
			0x57, 0x45, 0x1c, 0xdd, 0x36, 0x0a, 0xe4, 0x81,
			0x98, 0x3d, 0x85, 0x39, 0xe6, 0x2f, 0x56, 0x0b,
			0xe2, 0x2e, 0xc3, 0xc6, 0xe7, 0xb4, 0xab, 0xdd,
			0x72, 0xdf, 0x07, 0x76, 0xe2, 0x21, 0xcd, 0xbf,
			0x7c, 0x39, 0x14, 0x81, 0xb2, 0x62, 0x78, 0xf7,
			0xa5, 0xca, 0xc0, 0xe0, 0xe8, 0x45, 0xbe, 0xd3,
			0x87, 0x43, 0x77, 0xd3, 0x48, 0x00, 0x84, 0x23,
			0x30, 0xfa, 0xb8, 0x5b, 0x49, 0xa8, 0x03, 0xbc,
			0xa3, 0x69, 0x96, 0xc1, 0x99, 0xbb, 0x48, 0xf6,
			0x55, 0xad, 0x39, 0x0d, 0x97, 0x97, 0xb5, 0x2f,
			0xb1, 0x08, 0x5b, 0x90, 0xd7, 0x00, 0x7e, 0x46,
		},
		/* S4 : 256 byte */
		{
			0x2d, 0xbb, 0x21, 0x2c, 0x33, 0xcb, 0x75, 0x5b,
			0x53, 0x46, 0xa0, 0x4e, 0x42, 0x8f, 0xfc, 0xae,
			0xe7, 0x97, 0x8f, 0xcb, 0x2a, 0x58, 0x25, 0x4d,
			0x7d, 0xd9, 0x4b, 0x6d, 0x26, 0x6f, 0xfd, 0x3d,
			0xeb, 0x9b, 0xf5, 0x87, 0xcf, 0xb7, 0x8f, 0x90,
			0x2f, 0xd5, 0xcb, 0x1d, 0x9b, 0xd4, 0x7b, 0xea,
			0x37, 0x59, 0xa4, 0xd8, 0x9e, 0x00, 0xaa, 0xc3,
			0x5f, 0x76, 0xac, 0x88, 0xf2, 0x91, 0xb7, 0x1a,
			0xd7, 0x80, 0x5a, 0x7e, 0x42, 0xd8, 0x28, 0xa9,
			0x99, 0xf7, 0xce, 0x97, 0x16, 0x97, 0xdf, 0x2e,
			0x04, 0x72, 0x4a, 0x35, 0xcf, 0x3f, 0x5a, 0xda,
			0x29, 0xe3, 0x5d, 0xbb, 0x4b, 0x74, 0x2c, 0x31,
			0xf3, 0x53, 0x7b, 0xaf, 0x8b, 0x6d, 0x3b, 0xb5,
			0x06, 0x8a, 0x15, 0xd7, 0xee, 0x61, 0x14, 0x50,
			0xc1, 0x0f, 0xba, 0x36, 0x58, 0x60, 0xdf, 0xdf,
			0x83, 0xbf, 0x64, 0x8d, 0x48, 0xd9, 0xaf, 0x7d,
			0xcc, 0x2f, 0x90, 0x25, 0x4b, 0x65, 0xb5, 0x06,
			0x17, 0x03, 0x6a, 0x93, 0xf7, 0x52, 0x8a, 0x1b,
			0xb8, 0x48, 0xc6, 0xb4, 0xe5, 0xe3, 0x19, 0xa8,
			0xfb, 0x08, 0xe6, 0x02, 0xa7, 0x37, 0x3a, 0x9d,
			0xc4, 0xb3, 0x37, 0x65, 0x2a, 0x04, 0xb5, 0x48,
			0xfd, 0xb1, 0xd3, 0x15, 0x38, 0x20, 0xc5, 0x47,
			0xbb, 0x4d, 0x3f, 0x8a, 0xc1, 0xb3, 0x25, 0x8d,
			0xdd, 0x89, 0xd7, 0xd6, 0xd3, 0x74, 0x2d, 0xc5,
			0xad, 0x5c, 0x6f, 0x45, 0x5e, 0x4b, 0xb7, 0xe8,
			0xdf, 0x6b, 0x64, 0x0b, 0x27, 0xf1, 0xe9, 0xe4,
			0x2e, 0x83, 0x9b, 0xde, 0x60, 0x33, 0xbe, 0xea,
			0x39, 0x4c, 0xda, 0xeb, 0x57, 0x68, 0x63, 0x12,
			0x2d, 0x1f, 0xd5, 0xc5, 0xab, 0xd6, 0xeb, 0x36,
			0x71, 0x94, 0xaf, 0x71, 0xcc, 0xae, 0x19, 0x8f,
			0x2a, 0x46, 0x77, 0x98, 0x8c, 0x59, 0x13, 0xaa,
			0x3e, 0xc2, 0x94, 0x2f, 0xad, 0x98, 0x95, 0x90,
		},
	},
	/* SHA384 [5] */
	{
		/* Msg5 : 128 byte */
		{
			0xa4, 0x8b, 0x30, 0xa2, 0xdd, 0x6d, 0x26, 0x29,
			0x47, 0x6c, 0xb4, 0x24, 0xac, 0x7b, 0x0f, 0xc0,
			0x14, 0xd2, 0x9d, 0x99, 0x39, 0x93, 0x0b, 0x7f,
			0x3b, 0xad, 0x9a, 0x7a, 0x95, 0x00, 0xb9, 0x0b,
			0x50, 0xc3, 0xd9, 0xb5, 0x76, 0x23, 0x7d, 0xbc,
			0xca, 0x2d, 0x90, 0x2d, 0xb6, 0xee, 0xfc, 0x1e,
			0x85, 0xd9, 0x78, 0x37, 0xd2, 0x69, 0xa1, 0x72,
			0x40, 0x07, 0x4d, 0x1e, 0x6c, 0x2d, 0x1c, 0x2a,
			0x20, 0xcc, 0x50, 0xa0, 0xca, 0xeb, 0xde, 0x70,
			0x2c, 0x91, 0xc4, 0x6f, 0x54, 0xe6, 0x9e, 0x9f,
			0xcf, 0x95, 0x74, 0xb1, 0x1a, 0x74, 0xd7, 0xc8,
			0x59, 0x67, 0x2c, 0x80, 0x4b, 0x82, 0x47, 0x2f,
			0x7e, 0x6d, 0x3c, 0x6b, 0xbf, 0x0d, 0x71, 0xcc,
			0xd5, 0x60, 0xf8, 0xf2, 0x6f, 0xa9, 0x1c, 0xca,
			0x5a, 0xce, 0x3a, 0x0e, 0xf7, 0xfe, 0xd3, 0x0b,
			0xed, 0x96, 0xde, 0xa7, 0x1b, 0x46, 0x63, 0xa2,
		},
		/* S5 : 256 byte */
		{
			0x16, 0xec, 0xba, 0x74, 0xf9, 0x24, 0x9e, 0xfb,
			0x94, 0x8d, 0xd4, 0x2b, 0xde, 0x29, 0xcc, 0x44,
			0xe2, 0x59, 0x7d, 0xed, 0x40, 0xa3, 0x45, 0xc5,
			0xfd, 0xf0, 0x3c, 0x48, 0x50, 0x80, 0xd2, 0x86,
			0x51, 0x38, 0xe9, 0x37, 0xc0, 0x90, 0xb9, 0x37,
			0x94, 0xb2, 0x18, 0x7b, 0x6d, 0x7e, 0xcb, 0xe5,
			0x16, 0x6a, 0xb3, 0x11, 0x47, 0x8e, 0xa9, 0x3f,
			0xcc, 0x71, 0x43, 0xea, 0xe4, 0x10, 0x61, 0x54,
			0xbf, 0x2d, 0x49, 0x46, 0x52, 0x16, 0x3c, 0xcf,
			0x1b, 0x4d, 0xf0, 0x0b, 0x63, 0x8c, 0xd0, 0x1b,
			0x05, 0x74, 0x6f, 0x28, 0x2b, 0x1b, 0xbc, 0xf1,
			0x2d, 0x91, 0x74, 0x33, 0x0e, 0x66, 0x56, 0x76,
			0x62, 0x0d, 0x40, 0x90, 0x71, 0x19, 0x29, 0x97,
			0x69, 0xe8, 0xf6, 0x1e, 0x56, 0xe7, 0x14, 0xbe,
			0x23, 0x7c, 0xa8, 0x61, 0x19, 0x78, 0x07, 0xfd,
			0xe2, 0xfe, 0xae, 0xac, 0xe3, 0x1d, 0x0f, 0xec,
			0x0b, 0x30, 0x88, 0x54, 0x20, 0x53, 0xf7, 0xd5,
			0x4e, 0x1c, 0x30, 0xa0, 0x69, 0xb3, 0x96, 0x7c,
			0xee, 0xb2, 0xdb, 0x7a, 0x1f, 0x9f, 0x6d, 0x0b,
			0x67, 0x3a, 0xd2, 0x79, 0xa1, 0x85, 0xd8, 0x73,
			0x0e, 0x4e, 0xbe, 0x40, 0x2a, 0xd2, 0x02, 0x80,
			0xbd, 0x7e, 0x7f, 0x28, 0x6e, 0xd8, 0x7a, 0x25,
			0xc6, 0xc1, 0xcb, 0x3c, 0x66, 0xe5, 0xcd, 0x04,
			0x81, 0x70, 0xc9, 0x75, 0x9d, 0xba, 0x3f, 0x49,
			0xc3, 0xad, 0xcf, 0x68, 0xc7, 0x77, 0xf3, 0xcc,
			0x9a, 0xcb, 0x4b, 0x17, 0xb2, 0x7a, 0xb7, 0xa3,
			0x6a, 0x4d, 0x6b, 0x5f, 0x1f, 0xdf, 0x8d, 0xf9,
			0x18, 0x13, 0xc6, 0x37, 0x8a, 0xee, 0x60, 0x55,
			0x9d, 0x85, 0xa6, 0xee, 0x7e, 0x9f, 0xc8, 0xaf,
			0xaf, 0x31, 0x18, 0xda, 0xde, 0x7d, 0x7a, 0x0a,
			0x8f, 0x74, 0x49, 0xa0, 0x98, 0xe8, 0x29, 0x3b,
			0x59, 0x35, 0x9d, 0x96, 0x73, 0x10, 0xcf, 0xb6,
		},
	},
	/* SHA384 [6] */
	{
		/* Msg6 : 128 byte */
		{
			0xe2, 0x58, 0x79, 0xfb, 0x75, 0xfb, 0xb8, 0x02,
			0x55, 0xb7, 0xab, 0xf6, 0x53, 0x6c, 0xc0, 0x5c,
			0x71, 0x64, 0x2a, 0x6c, 0x96, 0x35, 0x34, 0x15,
			0x86, 0xe8, 0xd5, 0x41, 0x10, 0x5a, 0x85, 0x5a,
			0x8a, 0xe3, 0x50, 0x0d, 0x7a, 0x36, 0x29, 0x4e,
			0x96, 0x88, 0x80, 0x9c, 0xef, 0xf5, 0x17, 0x86,
			0x69, 0x1f, 0x11, 0x6e, 0x6e, 0x18, 0x4c, 0x8d,
			0xe3, 0x82, 0xf0, 0x37, 0x5b, 0xf4, 0x48, 0x60,
			0x8b, 0xa0, 0xd1, 0x60, 0xff, 0x33, 0x91, 0xf3,
			0x0b, 0xfd, 0xaa, 0x84, 0x03, 0x52, 0x2f, 0xab,
			0xae, 0x30, 0x36, 0xf4, 0xf9, 0x21, 0x2f, 0xe2,
			0xe9, 0x63, 0x74, 0x33, 0xd3, 0x47, 0x21, 0x66,
			0xcf, 0xd7, 0x25, 0x7b, 0x6a, 0xbb, 0x99, 0xfa,
			0x9b, 0x5e, 0x51, 0x36, 0xf9, 0x4c, 0xb1, 0xd3,
			0x2a, 0xdf, 0xc2, 0x86, 0x9f, 0x1a, 0x85, 0x1c,
			0x7e, 0xd5, 0x88, 0xbe, 0xe0, 0x1a, 0xb6, 0x73,
		},
		/* S6 : 256 byte */
		{
			0xd3, 0x43, 0x9a, 0x13, 0x90, 0xfa, 0x18, 0x48,
			0xa7, 0xf9, 0xd5, 0x40, 0x78, 0x53, 0x8d, 0x35,
			0x16, 0xcf, 0x17, 0xb5, 0x35, 0xd1, 0xc8, 0x60,
			0x38, 0x36, 0x2c, 0x21, 0xf8, 0xaa, 0x59, 0x3c,
			0xfd, 0x0e, 0xc2, 0xe3, 0x3a, 0xa6, 0x86, 0x00,
			0xe1, 0xc0, 0x3e, 0x4b, 0xbb, 0x8f, 0x2f, 0xd1,
			0x74, 0xb8, 0x2f, 0xb8, 0x30, 0x59, 0xfb, 0x88,
			0x36, 0x28, 0x3c, 0xf4, 0xba, 0x28, 0x8d, 0x1e,
			0xcd, 0x7b, 0x48, 0xc9, 0xc4, 0x93, 0x85, 0xaa,
			0x9d, 0x84, 0xeb, 0x89, 0xc3, 0x04, 0xf5, 0x0a,
			0xb1, 0xd1, 0xf6, 0x57, 0x65, 0xb7, 0x64, 0x12,
			0x47, 0xa6, 0xc2, 0x1b, 0x4d, 0x66, 0xa3, 0xa5,
			0x4c, 0xf2, 0xaf, 0x11, 0xcb, 0xbf, 0xc1, 0x07,
			0x55, 0xee, 0xf4, 0x9c, 0x3d, 0xf8, 0x1b, 0x9b,
			0x53, 0xbc, 0xa9, 0x92, 0xe8, 0x8b, 0xb9, 0x8d,
			0xe1, 0xe0, 0x73, 0x29, 0x9b, 0x81, 0xdf, 0xd9,
			0x7e, 0x1a, 0xae, 0xb2, 0x46, 0x12, 0xd5, 0xb7,
			0x3c, 0x0a, 0x97, 0xf2, 0xd0, 0xbb, 0x1e, 0x2b,
			0xf7, 0xeb, 0x45, 0x2b, 0xd2, 0xcc, 0x51, 0xdd,
			0xfc, 0xfe, 0x47, 0xd6, 0x69, 0x0a, 0x00, 0x1e,
			0x51, 0x40, 0x5a, 0x7e, 0x93, 0xd8, 0x73, 0x1b,
			0xef, 0x10, 0x93, 0xdd, 0x21, 0xd1, 0xe3, 0x20,
			0xa6, 0xaa, 0x01, 0x1e, 0x97, 0x3e, 0x7e, 0x98,
			0x5e, 0x2d, 0xe5, 0x9a, 0x00, 0x09, 0x39, 0xe2,
			0x01, 0xb0, 0xf1, 0x09, 0x84, 0x44, 0xf4, 0x22,
			0xb9, 0x78, 0x17, 0xfc, 0x60, 0x15, 0x4b, 0xa5,
			0x8a, 0x27, 0xec, 0x3a, 0x82, 0xe2, 0x7d, 0x99,
			0x8b, 0x9b, 0x3a, 0xb7, 0x4c, 0xc4, 0xf9, 0x51,
			0x01, 0x63, 0x5c, 0xce, 0x10, 0xc0, 0xa8, 0xd4,
			0x37, 0x98, 0x78, 0x18, 0x3e, 0xc7, 0xa1, 0xb6,
			0xf6, 0xca, 0xe9, 0x4c, 0x72, 0xe7, 0x56, 0xc4,
			0x15, 0xbe, 0xcc, 0x2c, 0x21, 0x1b, 0x26, 0x0b,
		},
	},
	/* SHA384 [7] */
	{
		/* Msg7 : 128 byte */
		{
			0x64, 0x8d, 0xe8, 0xc4, 0x18, 0x55, 0x1d, 0xbb,
			0xb7, 0x31, 0xa5, 0x0e, 0x33, 0x94, 0x36, 0x71,
			0x08, 0x5e, 0x3d, 0x6c, 0x2a, 0x02, 0x73, 0xa3,
			0x3b, 0xe8, 0xb1, 0x5a, 0x02, 0x10, 0x05, 0x38,
			0x19, 0xf9, 0x05, 0x4b, 0xe5, 0xc1, 0x63, 0x4d,
			0xcb, 0x8d, 0xc2, 0x26, 0xa1, 0x2b, 0xc8, 0xb1,
			0x63, 0xf6, 0x75, 0xc3, 0x28, 0xfa, 0xb3, 0x6a,
			0x54, 0x59, 0x2e, 0x72, 0x0e, 0xee, 0x65, 0x2e,
			0xf5, 0x2f, 0x02, 0x75, 0x0e, 0x58, 0x66, 0xea,
			0x01, 0xc6, 0x89, 0x80, 0x86, 0xa0, 0x01, 0x3e,
			0x1a, 0xbd, 0x60, 0x40, 0xf6, 0xc2, 0xc3, 0xff,
			0x41, 0x8b, 0xa8, 0xd2, 0x85, 0xcd, 0x00, 0xb4,
			0x60, 0xf9, 0x86, 0x47, 0x7c, 0x63, 0x4e, 0x19,
			0xc0, 0xa3, 0xa1, 0x26, 0xc8, 0x3b, 0x08, 0x9f,
			0x93, 0x7b, 0xa7, 0xea, 0x7c, 0xa2, 0xcc, 0xea,
			0x6c, 0x46, 0xc8, 0x80, 0x4d, 0xf6, 0xfe, 0x52,
		},
		/* S7 : 256 byte */
		{
			0x34, 0xde, 0x98, 0xac, 0x56, 0x40, 0x92, 0xd4,
			0xad, 0xcc, 0xa8, 0x59, 0x86, 0xe8, 0x34, 0x02,
			0xe6, 0x59, 0x82, 0x81, 0x3a, 0xae, 0x6d, 0x50,
			0xf2, 0xa8, 0x5a, 0xf7, 0xfd, 0x22, 0xea, 0xa6,
			0x1d, 0x47, 0x53, 0x26, 0xbc, 0xc6, 0x79, 0x8a,
			0x5f, 0x34, 0xb4, 0x73, 0x6c, 0x8b, 0xc0, 0xbf,
			0x59, 0x1c, 0x10, 0x91, 0xd8, 0x6a, 0x09, 0xbf,
			0xf4, 0x61, 0x99, 0xae, 0xd1, 0xef, 0x78, 0xdb,
			0x34, 0xe5, 0x75, 0xc1, 0xce, 0x47, 0x78, 0xde,
			0x14, 0xea, 0xc3, 0xa1, 0x39, 0x2a, 0x62, 0xc4,
			0xb0, 0x85, 0x4d, 0xcf, 0x5b, 0x33, 0x20, 0x85,
			0x6c, 0xb3, 0x4c, 0x42, 0x37, 0x03, 0x4e, 0xfa,
			0x1e, 0x55, 0x1f, 0xf2, 0x6f, 0x93, 0xa8, 0x6a,
			0xc0, 0xa4, 0x74, 0xde, 0x6d, 0xfd, 0x70, 0xcc,
			0x49, 0x00, 0x03, 0x83, 0x99, 0x2e, 0x65, 0x57,
			0xbd, 0xe5, 0xc4, 0x46, 0x86, 0x28, 0xd7, 0xf1,
			0xcb, 0x0b, 0xa9, 0x87, 0xec, 0x39, 0xcd, 0x59,
			0x57, 0x57, 0xa4, 0x8c, 0x25, 0x51, 0x04, 0x61,
			0xfc, 0xa5, 0x63, 0x08, 0xc1, 0x61, 0xa0, 0xa7,
			0x90, 0x79, 0xfc, 0x71, 0x4f, 0x06, 0x11, 0xe0,
			0xf3, 0xff, 0xf1, 0x1c, 0x2b, 0x36, 0xa8, 0xf5,
			0x04, 0xca, 0x90, 0x3d, 0x71, 0x64, 0x5c, 0x08,
			0xa9, 0x92, 0x31, 0x85, 0x35, 0x3b, 0x45, 0x4e,
			0x78, 0x84, 0x3e, 0x2a, 0xe6, 0x92, 0xda, 0x65,
			0x6c, 0x7c, 0xdb, 0x45, 0xa8, 0x06, 0x68, 0x84,
			0x3e, 0x91, 0x54, 0xb8, 0x80, 0x73, 0xfa, 0x04,
			0xb9, 0x47, 0xcf, 0xdb, 0x6f, 0x5b, 0x97, 0xe6,
			0x74, 0x27, 0x90, 0xf8, 0xd4, 0x85, 0x75, 0x01,
			0x48, 0xd3, 0xb6, 0xd0, 0xf7, 0xf8, 0xd9, 0x9a,
			0x7a, 0x8c, 0xcc, 0xd2, 0x1c, 0x4c, 0x8e, 0xf3,
			0x75, 0x7b, 0x32, 0x1e, 0x3c, 0x05, 0x10, 0x9a,
			0xee, 0x90, 0xa4, 0xc1, 0x68, 0xef, 0x10, 0x9f,
		},
	},
	/* SHA384 [8] */
	{
		/* Msg8 : 128 byte */
		{
			0xbb, 0x70, 0xb6, 0x63, 0xd1, 0x57, 0xc3, 0x30,
			0xc7, 0x9b, 0xc6, 0x03, 0xff, 0x28, 0xc3, 0x5d,
			0x41, 0xb3, 0x71, 0xa6, 0xa4, 0x05, 0x41, 0x22,
			0xb2, 0x97, 0x9b, 0x22, 0xc7, 0x60, 0x6b, 0x77,
			0xba, 0xeb, 0xdc, 0x2c, 0xbf, 0xac, 0x63, 0x75,
			0x8c, 0x94, 0x00, 0xe2, 0xbb, 0xe3, 0xc1, 0xd8,
			0x70, 0x3e, 0x87, 0x42, 0x3b, 0x01, 0x0c, 0x84,
			0x40, 0xd6, 0x25, 0xb0, 0x95, 0x87, 0x45, 0xfd,
			0xeb, 0x10, 0x43, 0x75, 0x71, 0xf9, 0x5d, 0xed,
			0xf5, 0xe2, 0x7c, 0x3a, 0x4c, 0x60, 0xba, 0xa2,
			0xf5, 0x07, 0x21, 0x91, 0xf9, 0xc8, 0xb5, 0x8d,
			0x15, 0x7e, 0xb5, 0x6c, 0x1b, 0xc3, 0x1f, 0xc5,
			0x96, 0x08, 0x72, 0xa4, 0xad, 0xe5, 0xb7, 0x82,
			0x4a, 0xad, 0xc2, 0x74, 0x7b, 0x46, 0xb6, 0xa2,
			0x18, 0x37, 0xc7, 0xfb, 0xa6, 0x03, 0x44, 0x27,
			0x7b, 0xb6, 0xd4, 0xbd, 0x23, 0xbd, 0x00, 0xb7,
		},
		/* S8 : 256 byte */
		{
			0xa9, 0xf9, 0x44, 0x3f, 0x14, 0xa8, 0x01, 0x95,
			0xbd, 0x63, 0x25, 0x60, 0x6d, 0x67, 0x5c, 0x4a,
			0xcc, 0x6d, 0x38, 0x37, 0x77, 0xeb, 0xa9, 0x44,
			0x0b, 0x95, 0x57, 0xcd, 0xc5, 0xd9, 0x9d, 0x22,
			0x17, 0x32, 0xbe, 0x50, 0x54, 0x04, 0x10, 0x71,
			0x4b, 0x40, 0x34, 0x3b, 0xc9, 0x08, 0xb0, 0x58,
			0xaa, 0x94, 0xdb, 0x24, 0x26, 0xaf, 0xca, 0x19,
			0x8b, 0x01, 0x18, 0x8f, 0xc2, 0xce, 0x53, 0x0e,
			0x75, 0x52, 0xb3, 0xfa, 0x3c, 0x1d, 0xd9, 0x0d,
			0xcf, 0xdd, 0xcb, 0x55, 0x82, 0x30, 0x38, 0x61,
			0x43, 0x3a, 0x46, 0x5a, 0xac, 0x61, 0x04, 0x10,
			0xe4, 0x5c, 0xf2, 0xa6, 0x99, 0xc7, 0xb3, 0x64,
			0xac, 0x8d, 0x72, 0x49, 0x3e, 0x53, 0x84, 0x26,
			0xc4, 0x54, 0xb6, 0x94, 0xac, 0x2d, 0xbb, 0xdd,
			0xa9, 0x2f, 0xc5, 0xad, 0x0b, 0x60, 0x0d, 0xbf,
			0x02, 0x16, 0x6b, 0x1e, 0x2b, 0x21, 0xea, 0x47,
			0x0d, 0x7d, 0xf3, 0x43, 0x59, 0x92, 0x5c, 0x29,
			0xd6, 0x28, 0x49, 0x22, 0xfb, 0xa0, 0x5b, 0x7b,
			0x13, 0x73, 0xdc, 0x3f, 0xf1, 0xa4, 0xe8, 0xe0,
			0xe8, 0xcd, 0x68, 0xef, 0xea, 0xdf, 0xe7, 0xbf,
			0x52, 0x89, 0xa4, 0x60, 0x8a, 0xae, 0xd2, 0x30,
			0x90, 0xda, 0x39, 0x1d, 0x30, 0xfd, 0x2d, 0xab,
			0xcc, 0xb7, 0xe9, 0x38, 0xe1, 0x28, 0xbb, 0xb3,
			0x7b, 0xb4, 0xab, 0xb4, 0x68, 0xc2, 0xc2, 0xea,
			0xe5, 0x97, 0xde, 0x1b, 0x96, 0x4c, 0x40, 0xc6,
			0x91, 0xd6, 0x94, 0xd2, 0x7f, 0xbe, 0xfb, 0xbc,
			0x28, 0x76, 0x32, 0x92, 0x60, 0xd0, 0x2c, 0xc6,
			0x3e, 0xe7, 0x11, 0xef, 0x47, 0x55, 0x82, 0xee,
			0x4d, 0xe3, 0xb0, 0x79, 0xc1, 0x80, 0x5b, 0xd8,
			0xc9, 0x01, 0x30, 0xbf, 0x13, 0xc7, 0xe5, 0x2e,
			0x95, 0x5e, 0x58, 0x87, 0x8e, 0x07, 0x5d, 0x7f,
			0x2b, 0xff, 0xc7, 0x5e, 0x9b, 0xad, 0xc8, 0x82,
		},
	},
	/* SHA384 [9] */
	{
		/* Msg9 : 128 byte */
		{
			0x62, 0x7a, 0xcc, 0xf6, 0x48, 0x51, 0xe9, 0xf1,
			0x9b, 0xc8, 0x6e, 0xe8, 0x69, 0x8a, 0xe6, 0x87,
			0xb9, 0x50, 0xb9, 0xe2, 0x63, 0x5e, 0xa6, 0x15,
			0x25, 0x50, 0x6d, 0x27, 0xf2, 0x16, 0xcc, 0x35,
			0x8d, 0x3e, 0xad, 0xcc, 0x57, 0x71, 0x9e, 0x96,
			0x66, 0x41, 0x81, 0x39, 0xd6, 0x22, 0x85, 0x7c,
			0x64, 0xb5, 0x55, 0xac, 0x38, 0x4d, 0x8f, 0x3e,
			0x03, 0xac, 0x77, 0xb5, 0x4a, 0x0d, 0xed, 0xc6,
			0x02, 0x68, 0x9c, 0xba, 0x5c, 0xf1, 0x75, 0x15,
			0xe2, 0xe1, 0x5c, 0x75, 0xc3, 0x7a, 0x20, 0xbc,
			0x6b, 0x45, 0xb1, 0x71, 0x57, 0x9f, 0x8d, 0x64,
			0x28, 0x73, 0x7c, 0x91, 0xf6, 0x49, 0x7d, 0x47,
			0xe6, 0x80, 0x00, 0x8a, 0xff, 0xd7, 0x55, 0xb5,
			0x39, 0x33, 0x65, 0x64, 0xd7, 0x9c, 0xa0, 0x90,
			0xf7, 0x88, 0x36, 0xfc, 0x68, 0x5c, 0x8a, 0xd0,
			0xbb, 0x30, 0xe4, 0x84, 0x9d, 0xd2, 0x65, 0x00,
		},
		/* S9 : 256 byte */
		{
			0xb5, 0x33, 0xcf, 0x67, 0xe4, 0x4e, 0x2d, 0xa3,
			0xc4, 0xac, 0xd7, 0xcd, 0x33, 0xaf, 0x39, 0x4d,
			0x26, 0xce, 0x2e, 0xff, 0xa5, 0x5d, 0x7b, 0x82,
			0xd3, 0x1f, 0x38, 0xaf, 0xa7, 0x19, 0x82, 0x21,
			0x7f, 0x66, 0x42, 0x0c, 0xa7, 0x7f, 0xb9, 0x4a,
			0x0f, 0x55, 0xd5, 0xc1, 0x8c, 0x5e, 0x01, 0x82,
			0xc3, 0xea, 0x64, 0xf4, 0xfd, 0xaa, 0x3f, 0x62,
			0xb6, 0xe4, 0x54, 0x82, 0x53, 0x29, 0x69, 0xdd,
			0xb8, 0xa9, 0x8a, 0xcb, 0xa3, 0x62, 0x17, 0xf3,
			0x32, 0x11, 0x56, 0x7e, 0xe8, 0x46, 0x56, 0xf2,
			0xd6, 0x89, 0x44, 0x0b, 0xfc, 0xae, 0xf4, 0x36,
			0x7e, 0x7b, 0xbb, 0x2d, 0x7b, 0x59, 0xb9, 0x37,
			0x17, 0x86, 0x81, 0x3e, 0x6a, 0x26, 0x2d, 0x97,
			0xa6, 0x35, 0x4a, 0x5d, 0x70, 0x4d, 0x05, 0xb2,
			0x6d, 0x92, 0xf8, 0xb5, 0x3f, 0x44, 0x04, 0xb4,
			0x82, 0xb7, 0x87, 0xaa, 0xbf, 0x20, 0xea, 0x51,
			0x2f, 0x10, 0x22, 0x3f, 0xdc, 0x97, 0x60, 0x16,
			0x19, 0xaa, 0x96, 0x29, 0xda, 0xfb, 0xf3, 0xd0,
			0x61, 0x14, 0x31, 0xab, 0xd8, 0x2d, 0xc9, 0x04,
			0x47, 0x8e, 0x11, 0x9a, 0x97, 0x2a, 0x7b, 0x4d,
			0xf0, 0x49, 0x7a, 0x2e, 0x4d, 0x40, 0xa0, 0x56,
			0x55, 0x87, 0x40, 0x1e, 0x84, 0x2a, 0x31, 0x9e,
			0x06, 0xf1, 0x01, 0xb2, 0x07, 0x4e, 0x35, 0x16,
			0xd0, 0x7b, 0xb7, 0x87, 0x33, 0x61, 0x1a, 0xdf,
			0x21, 0x05, 0xe3, 0xca, 0x30, 0xd2, 0x4b, 0xe1,
			0xc9, 0x25, 0xaf, 0x3d, 0x37, 0x7e, 0xdd, 0xd0,
			0x40, 0x0c, 0x27, 0x3d, 0x67, 0x3f, 0x6b, 0x03,
			0xcc, 0xec, 0xdb, 0x5e, 0x32, 0xdd, 0x89, 0x4b,
			0x85, 0x44, 0xaf, 0x97, 0x4c, 0xcb, 0xa5, 0x8a,
			0x21, 0x24, 0xfb, 0xb7, 0x15, 0x2a, 0xdd, 0x41,
			0x82, 0xb5, 0x53, 0xd6, 0x6a, 0xee, 0x70, 0xaf,
			0xcb, 0x21, 0x93, 0xd4, 0xdb, 0x48, 0xa0, 0xf7,
		},
	},
};

/* 10 elements */
static mod2048_t SHA512[] = {
	/* SHA512 [0] */
	{
		/* Msg0 : 128 byte */
		{
			0xe4, 0xdb, 0xa4, 0x69, 0x2a, 0x66, 0x28, 0xb5,
			0x01, 0xf7, 0x76, 0xfe, 0xc7, 0xfe, 0x97, 0x3d,
			0x65, 0x51, 0x54, 0x26, 0x8f, 0x66, 0x9b, 0xfd,
			0x47, 0xc6, 0x24, 0xab, 0xa3, 0xbe, 0x53, 0x11,
			0xd1, 0x58, 0x61, 0x9c, 0x58, 0x8a, 0xb7, 0x1a,
			0xa0, 0xac, 0x9a, 0xcc, 0xb5, 0x2f, 0x0d, 0xbc,
			0x48, 0x8d, 0xf3, 0x50, 0xf7, 0x7c, 0x75, 0x20,
			0xce, 0x67, 0xa3, 0x05, 0x0d, 0x1e, 0x5e, 0x72,
			0x2b, 0xcd, 0x75, 0x08, 0x1c, 0x2b, 0x0e, 0x64,
			0xd0, 0xf3, 0x48, 0x3c, 0xfc, 0x98, 0x1e, 0xaa,
			0x1c, 0x35, 0x8f, 0xc7, 0xb9, 0xc2, 0xfb, 0x7c,
			0xe7, 0x8e, 0xd1, 0x95, 0x13, 0xe9, 0x67, 0x17,
			0xfb, 0x21, 0x29, 0xd4, 0xfe, 0xb1, 0xf6, 0x3c,
			0x96, 0xb4, 0xc7, 0x76, 0x23, 0xa0, 0x92, 0xb0,
			0xea, 0x30, 0x6e, 0xb3, 0x5d, 0xa2, 0xf7, 0xba,
			0x9d, 0x23, 0xf4, 0x84, 0x3d, 0x88, 0x37, 0xa8,
		},
		/* S0 : 256 byte */
		{
			0xdf, 0xe5, 0x8c, 0x84, 0xec, 0x3e, 0xe5, 0xf1,
			0x1b, 0x26, 0x5e, 0x8e, 0x7d, 0x99, 0xb4, 0x16,
			0xd8, 0xe7, 0xb1, 0x66, 0xa3, 0x8d, 0x2b, 0x0f,
			0x90, 0x27, 0xbe, 0x73, 0x88, 0x7f, 0xad, 0x28,
			0x94, 0x79, 0x94, 0xa2, 0xbc, 0x22, 0x7d, 0xaf,
			0xcb, 0x27, 0x2d, 0x2d, 0x41, 0x0a, 0xf3, 0x1a,
			0xfe, 0x16, 0xb9, 0x6f, 0x51, 0xc9, 0xdd, 0xf6,
			0x2b, 0x41, 0x7d, 0x03, 0xe2, 0xaf, 0x63, 0xea,
			0x4a, 0x58, 0xd4, 0x1e, 0x46, 0x49, 0x71, 0x21,
			0x77, 0xc8, 0x57, 0x88, 0xd8, 0x37, 0xfa, 0xdd,
			0x22, 0x3c, 0x4e, 0xa7, 0xf6, 0x35, 0x23, 0x7a,
			0x93, 0xb1, 0x81, 0xfe, 0x1c, 0x0f, 0xd3, 0xbf,
			0x2d, 0x8a, 0x79, 0x97, 0xcc, 0x9b, 0xb6, 0xca,
			0x09, 0x9a, 0x0a, 0x36, 0xc4, 0xb9, 0xe9, 0x1a,
			0xa7, 0x80, 0xa3, 0xd5, 0xed, 0xbc, 0x28, 0x3c,
			0xc3, 0x16, 0xa1, 0x53, 0xa1, 0x01, 0xfc, 0x8c,
			0x33, 0xd0, 0x03, 0x5e, 0x6c, 0x1e, 0x1a, 0xca,
			0x73, 0x1e, 0xa7, 0x65, 0xa1, 0xe5, 0xfe, 0x14,
			0x06, 0xef, 0x7b, 0xa8, 0xbb, 0x8f, 0x33, 0x5b,
			0x8d, 0x2e, 0x6c, 0xe0, 0xb9, 0xfe, 0xe2, 0xf5,
			0x41, 0x6e, 0x45, 0x36, 0xb2, 0x80, 0xfd, 0xc4,
			0x08, 0x60, 0xc1, 0x7e, 0x9d, 0xa6, 0xbb, 0x36,
			0x11, 0x28, 0xee, 0x53, 0x75, 0x4b, 0xf6, 0x8f,
			0x54, 0xc2, 0x87, 0x8a, 0x4a, 0xc4, 0xd3, 0x49,
			0x70, 0x30, 0x66, 0xa6, 0xfb, 0x96, 0x22, 0x0e,
			0x15, 0x28, 0x5f, 0xcb, 0x41, 0xb3, 0x98, 0xb4,
			0x56, 0x7c, 0x0c, 0x16, 0x77, 0x62, 0xeb, 0x6c,
			0xeb, 0x4f, 0x05, 0x37, 0xc7, 0xfb, 0x71, 0x03,
			0x48, 0x7c, 0x78, 0xa9, 0x80, 0x93, 0x20, 0x97,
			0x71, 0xfc, 0x4f, 0x4a, 0x98, 0x21, 0xcc, 0x8e,
			0xb1, 0x1f, 0x15, 0xa0, 0xe3, 0x5c, 0x54, 0xf6,
			0xd5, 0xd3, 0x1d, 0x8e, 0x86, 0x46, 0xc2, 0x29,
		},
	},
	/* SHA512 [1] */
	{
		/* Msg1 : 128 byte */
		{
			0x0f, 0xf8, 0x15, 0xe8, 0xe1, 0xcc, 0xf6, 0x6c,
			0x1a, 0x09, 0xc3, 0xb1, 0x87, 0x59, 0x53, 0xc4,
			0x45, 0x71, 0x54, 0x27, 0x29, 0xe5, 0xd8, 0x39,
			0x5e, 0x41, 0x10, 0xf2, 0x50, 0x55, 0x56, 0xd3,
			0xc9, 0xd0, 0x71, 0x1d, 0x5a, 0x11, 0x15, 0x42,
			0xfd, 0x39, 0xaa, 0x99, 0xf8, 0x85, 0x4e, 0x55,
			0x05, 0xdb, 0x1d, 0xb8, 0xaf, 0xa2, 0xb0, 0x84,
			0xff, 0xd7, 0xe3, 0xb3, 0x58, 0x5d, 0xdc, 0x67,
			0xa0, 0x95, 0x49, 0x24, 0xa0, 0x2f, 0xe8, 0x3d,
			0xae, 0x40, 0x4d, 0x8c, 0x89, 0x94, 0xe0, 0x66,
			0x84, 0x45, 0x25, 0xce, 0xe7, 0x8c, 0x40, 0xe9,
			0x92, 0xd8, 0xb8, 0xb3, 0xe3, 0x1d, 0x7b, 0xef,
			0xda, 0x6f, 0x22, 0x64, 0x7b, 0xcf, 0x77, 0x46,
			0x74, 0x45, 0x34, 0xf3, 0x00, 0x2f, 0x0e, 0xe0,
			0x0b, 0xd8, 0xf2, 0xd2, 0x97, 0x4c, 0x8f, 0x51,
			0x5e, 0x6b, 0x14, 0x59, 0xb9, 0x3d, 0x3b, 0x54,
		},
		/* S1 : 256 byte */
		{
			0x19, 0xc4, 0x5b, 0xc7, 0xc6, 0xb4, 0x44, 0x5a,
			0x2e, 0x4e, 0xab, 0x51, 0x1d, 0xe0, 0x11, 0x82,
			0x0a, 0xe0, 0xa0, 0x48, 0x3e, 0x95, 0x7b, 0x92,
			0x2f, 0xc3, 0x03, 0xb2, 0xb3, 0xb9, 0x4b, 0x31,
			0x20, 0x5c, 0x0e, 0xb8, 0x21, 0xa8, 0xf3, 0x3b,
			0x3e, 0xe5, 0x3d, 0x16, 0x11, 0x6c, 0x6a, 0x7b,
			0xe9, 0x95, 0x95, 0xb2, 0xc1, 0x6c, 0xbb, 0x11,
			0x62, 0xf1, 0x47, 0xe7, 0x53, 0x0e, 0x48, 0xc6,
			0x08, 0x61, 0x41, 0x1b, 0x59, 0x5d, 0x4e, 0x7d,
			0x1a, 0x1e, 0x85, 0x23, 0x89, 0xeb, 0x98, 0xca,
			0x68, 0x56, 0xe9, 0x9c, 0xbf, 0x12, 0x13, 0x77,
			0xdb, 0x96, 0x96, 0x1b, 0x4a, 0x55, 0x47, 0x8f,
			0x54, 0xe1, 0xcc, 0x0e, 0xcc, 0xa3, 0x49, 0xd2,
			0x98, 0xdd, 0x55, 0xb7, 0xdb, 0xfd, 0x9a, 0x1e,
			0x97, 0xa1, 0xe2, 0x48, 0xed, 0x9c, 0x3e, 0x48,
			0x79, 0x18, 0x99, 0x25, 0xb1, 0x84, 0x60, 0x10,
			0xe5, 0x67, 0x26, 0x93, 0x76, 0xa5, 0x32, 0x14,
			0x76, 0xcd, 0xb6, 0xfa, 0x6b, 0xa3, 0xd3, 0x58,
			0xcc, 0xf7, 0x37, 0x96, 0x44, 0x57, 0x76, 0x54,
			0x19, 0x24, 0x5e, 0x53, 0xbf, 0xd0, 0x06, 0x75,
			0x3e, 0xb6, 0x40, 0x54, 0xe9, 0xf8, 0x3e, 0xef,
			0x41, 0x9a, 0x7c, 0xb9, 0x9e, 0xd4, 0xbe, 0xbf,
			0x31, 0x82, 0x3e, 0x3f, 0x8b, 0x6b, 0xe8, 0x18,
			0x33, 0xae, 0x16, 0x47, 0x74, 0xb0, 0x44, 0x78,
			0x8b, 0x4f, 0xdd, 0x61, 0x70, 0xac, 0x49, 0x9b,
			0xa6, 0x0b, 0x87, 0xe8, 0xb1, 0x51, 0x5d, 0x4d,
			0x1f, 0xa7, 0x51, 0xfb, 0x4f, 0x74, 0xea, 0x67,
			0x42, 0x90, 0xa1, 0xa8, 0xf2, 0x4c, 0x0d, 0x76,
			0x9d, 0x5d, 0x8a, 0xa6, 0x0e, 0xd2, 0xe4, 0xf7,
			0x9f, 0xa7, 0xe2, 0xae, 0xdb, 0x42, 0xe5, 0xf1,
			0x88, 0x11, 0xb9, 0x0d, 0x96, 0x04, 0x1d, 0xca,
			0xf4, 0x1e, 0x25, 0xb7, 0xb2, 0xe3, 0xe9, 0x98,
		},
	},
	/* SHA512 [2] */
	{
		/* Msg2 : 128 byte */
		{
			0x64, 0x69, 0x19, 0xbe, 0xe4, 0xa4, 0x7d, 0x97,
			0x8d, 0x4b, 0xe1, 0x9f, 0x18, 0x06, 0xde, 0x5e,
			0xf8, 0x49, 0xa9, 0x84, 0x33, 0xd6, 0x8a, 0x87,
			0x71, 0x83, 0x90, 0x8e, 0x52, 0x3d, 0x84, 0x8e,
			0x05, 0x4d, 0x1b, 0xb2, 0x17, 0xda, 0x6f, 0x01,
			0x88, 0xaf, 0xb0, 0x3b, 0x24, 0x3f, 0x17, 0x03,
			0x10, 0xe6, 0x1c, 0x43, 0xa4, 0x72, 0xe9, 0xcd,
			0x78, 0xe2, 0x0e, 0x3e, 0xc2, 0x6e, 0x76, 0x28,
			0xdf, 0xc7, 0x9a, 0x70, 0x2f, 0x9f, 0xf4, 0xf4,
			0x26, 0x6c, 0xb7, 0x71, 0xa0, 0x69, 0xbd, 0xa5,
			0x75, 0xde, 0xc1, 0xb0, 0x4e, 0xa2, 0xce, 0xc0,
			0xb7, 0xde, 0xf7, 0xed, 0x75, 0x13, 0x49, 0x62,
			0x19, 0x5f, 0xfe, 0xbe, 0xd5, 0xfc, 0xf3, 0xba,
			0x8f, 0x09, 0x5d, 0x0b, 0x34, 0x8d, 0xb7, 0x8a,
			0x4f, 0xb9, 0xff, 0x92, 0xda, 0x6d, 0x21, 0xa9,
			0x53, 0xfe, 0xb4, 0x63, 0x13, 0x37, 0xe4, 0x84,
		},
		/* S2 : 256 byte */
		{
			0x08, 0x4f, 0xcf, 0x4c, 0xe6, 0x6c, 0x15, 0x43,
			0x6d, 0xba, 0xf0, 0x57, 0xe9, 0xde, 0x7d, 0xbe,
			0x99, 0xa2, 0x0f, 0xdf, 0x1a, 0xc4, 0x91, 0xa9,
			0x20, 0x58, 0x0a, 0x6e, 0x3b, 0x30, 0x46, 0x29,
			0x21, 0x15, 0x77, 0xda, 0xa0, 0x7a, 0x38, 0x88,
			0x8e, 0xb6, 0x5f, 0xe9, 0x50, 0x7e, 0x91, 0x99,
			0x07, 0x83, 0xe0, 0x5f, 0x0d, 0x98, 0x20, 0xaf,
			0xc3, 0x76, 0x23, 0xec, 0xf4, 0x22, 0x41, 0xc6,
			0x6a, 0x8b, 0xc7, 0xad, 0x0e, 0x0f, 0x1f, 0x43,
			0xb3, 0x21, 0xfe, 0xcf, 0x4a, 0x9d, 0x76, 0x10,
			0x6d, 0x60, 0x40, 0x58, 0x8d, 0x13, 0xb5, 0x8a,
			0xef, 0x68, 0x03, 0x7f, 0x73, 0x50, 0x0a, 0x8d,
			0x34, 0xa9, 0x71, 0x17, 0xea, 0x41, 0xc0, 0xd2,
			0xab, 0x51, 0x42, 0x5e, 0xb6, 0x2d, 0x86, 0x3a,
			0x82, 0xed, 0x56, 0xe7, 0x08, 0x25, 0x89, 0xcf,
			0xa3, 0xd5, 0x5f, 0xac, 0xab, 0x67, 0x59, 0x0e,
			0xd6, 0x03, 0xfa, 0x8f, 0xe8, 0x95, 0x53, 0xaf,
			0x27, 0x9f, 0x36, 0xbf, 0x32, 0xd7, 0xe7, 0xf8,
			0x1f, 0x24, 0xf1, 0x7c, 0xf0, 0x66, 0xba, 0x66,
			0xd0, 0x90, 0x13, 0x0a, 0x7c, 0xcd, 0xc4, 0x48,
			0x48, 0xa2, 0x3b, 0x69, 0x18, 0x37, 0xf5, 0x1f,
			0x58, 0x9c, 0xe3, 0x07, 0x6b, 0xbd, 0x53, 0x08,
			0x8e, 0x80, 0x95, 0x86, 0x81, 0xd4, 0x86, 0x8b,
			0x0f, 0x95, 0x7e, 0xda, 0xf9, 0x5e, 0x17, 0x5d,
			0xae, 0x09, 0xce, 0xcb, 0xbd, 0xd3, 0x9e, 0x01,
			0xca, 0xe1, 0x43, 0x95, 0x69, 0x0a, 0x61, 0xaf,
			0x5d, 0x7c, 0x4a, 0xe8, 0x82, 0x09, 0x2e, 0x84,
			0x02, 0x04, 0x82, 0x3a, 0x07, 0x10, 0xe8, 0x0f,
			0x81, 0xc4, 0x01, 0x1f, 0x10, 0xa6, 0x04, 0x4c,
			0x79, 0xa0, 0x73, 0x74, 0xb7, 0x5f, 0x13, 0x84,
			0x3d, 0xed, 0x1f, 0x7e, 0xe3, 0xfd, 0x9a, 0xbb,
			0x85, 0x91, 0x4f, 0x1a, 0x25, 0xb3, 0xda, 0xd5,
		},
	},
	/* SHA512 [3] */
	{
		/* Msg3 : 128 byte */
		{
			0x32, 0xd9, 0x82, 0x9c, 0x40, 0xee, 0xc9, 0x78,
			0xd8, 0xdb, 0x1b, 0x74, 0x4f, 0x77, 0x84, 0xb9,
			0x37, 0xd9, 0x55, 0xab, 0x78, 0x17, 0xd3, 0xc8,
			0xa3, 0x53, 0x2c, 0xd2, 0x82, 0xf9, 0xaf, 0x30,
			0xf4, 0x42, 0x3b, 0x92, 0xf7, 0xfd, 0xf8, 0xd4,
			0x07, 0x8e, 0x46, 0x25, 0xa7, 0x37, 0xf3, 0x68,
			0x3d, 0x96, 0xb1, 0xda, 0x22, 0x6f, 0xc7, 0xf5,
			0xfa, 0xac, 0x06, 0x95, 0x41, 0xa2, 0xff, 0x5a,
			0x27, 0x96, 0x73, 0x4d, 0x9e, 0x80, 0x0b, 0xc6,
			0xb1, 0x0e, 0x49, 0x8d, 0x17, 0xec, 0xbf, 0x3f,
			0x08, 0x43, 0x7f, 0xf3, 0x4f, 0x80, 0xd2, 0x1e,
			0xa1, 0x56, 0x2d, 0xb4, 0x2d, 0x06, 0x60, 0x90,
			0x74, 0xde, 0x11, 0x16, 0x5b, 0xff, 0x69, 0x17,
			0x7e, 0x64, 0x0d, 0xf4, 0xc8, 0x20, 0x50, 0x07,
			0x41, 0xe7, 0xa7, 0x3e, 0x26, 0xd0, 0x5d, 0x09,
			0x3f, 0x59, 0x87, 0x77, 0x6d, 0xac, 0x3b, 0x9c,
		},
		/* S3 : 256 byte */
		{
			0x92, 0xf7, 0x50, 0x93, 0x66, 0xd0, 0xd7, 0x9e,
			0x4a, 0x35, 0x0c, 0xea, 0xc7, 0x59, 0x74, 0x81,
			0xb3, 0xc4, 0x04, 0x4a, 0x76, 0x58, 0xf2, 0xaa,
			0x65, 0x16, 0x5f, 0xdc, 0xfa, 0x0b, 0xa9, 0x5c,
			0x90, 0x83, 0x15, 0x6c, 0x9b, 0x9c, 0xbc, 0x22,
			0x0f, 0xba, 0xa6, 0x94, 0xbc, 0x5d, 0xdd, 0x54,
			0x05, 0x97, 0x6b, 0xe4, 0x58, 0x45, 0xfe, 0x9a,
			0x2f, 0xac, 0xd2, 0xbc, 0x1f, 0x1a, 0x37, 0x91,
			0x35, 0x41, 0xa9, 0x18, 0xff, 0x75, 0xa8, 0xef,
			0x26, 0x50, 0x66, 0x54, 0xeb, 0xfe, 0x05, 0x01,
			0xad, 0x46, 0xbd, 0x57, 0xe3, 0x86, 0x92, 0x61,
			0x36, 0xc3, 0x8b, 0xe1, 0x6d, 0x00, 0x4b, 0x1c,
			0x8c, 0x3d, 0xa2, 0x3c, 0x58, 0x63, 0x2c, 0xcb,
			0xa9, 0x6d, 0xd1, 0x85, 0x74, 0x05, 0xe4, 0x71,
			0x24, 0x88, 0xc2, 0xc8, 0x4d, 0xb2, 0x0f, 0x82,
			0x71, 0x12, 0x12, 0x22, 0x2d, 0xef, 0x48, 0xea,
			0x20, 0xef, 0xe0, 0x9e, 0x5b, 0x47, 0x6e, 0x28,
			0xa6, 0x01, 0x70, 0xcf, 0xdb, 0x17, 0x5c, 0x74,
			0x63, 0x44, 0x3f, 0x82, 0x91, 0xe8, 0x94, 0xee,
			0xbe, 0x95, 0xdf, 0x13, 0xb0, 0xf5, 0xed, 0x0d,
			0x50, 0x49, 0x58, 0x81, 0x3c, 0xa9, 0x90, 0xd2,
			0xe3, 0x2e, 0x96, 0x9c, 0x58, 0x54, 0x3f, 0x77,
			0xef, 0x52, 0xdc, 0x6f, 0x8e, 0xa5, 0x39, 0x10,
			0x7a, 0x4d, 0xee, 0x46, 0x73, 0x5c, 0xc4, 0x99,
			0x03, 0x66, 0x4c, 0xa1, 0x0a, 0x90, 0x26, 0x34,
			0x73, 0x3f, 0x27, 0x5a, 0x0a, 0x1f, 0x14, 0x5a,
			0x9b, 0xb9, 0x12, 0xff, 0xb4, 0xaf, 0x55, 0x0e,
			0xc0, 0x8a, 0xda, 0x90, 0x2f, 0x15, 0x21, 0x64,
			0xc9, 0x2e, 0x71, 0x17, 0xf2, 0xf2, 0x64, 0x95,
			0x49, 0xf5, 0x9e, 0x1e, 0xf5, 0x39, 0x8b, 0x51,
			0x54, 0x03, 0xe3, 0xf3, 0x74, 0x8e, 0xae, 0x0b,
			0x98, 0xa0, 0x78, 0x2e, 0x30, 0xa9, 0xc6, 0x9a,
		},
	},
	/* SHA512 [4] */
	{
		/* Msg4 : 128 byte */
		{
			0x04, 0x9b, 0x80, 0xff, 0x6c, 0x1c, 0x14, 0x45,
			0xd4, 0x72, 0xa7, 0x0b, 0x47, 0x0c, 0x40, 0x4c,
			0xa0, 0xea, 0x2e, 0x2a, 0x4c, 0x52, 0xef, 0x3e,
			0x51, 0xc5, 0x50, 0x2c, 0x8f, 0x31, 0xd6, 0x7a,
			0x46, 0x68, 0x5d, 0xa2, 0xd9, 0xd1, 0xff, 0x65,
			0xd2, 0x5d, 0x37, 0x63, 0x25, 0xbd, 0x46, 0xe9,
			0xb9, 0xd3, 0xd6, 0x0a, 0x24, 0x66, 0xde, 0xf1,
			0xb7, 0x19, 0xc5, 0x75, 0xba, 0x9e, 0xca, 0xee,
			0xf8, 0x27, 0xa3, 0x47, 0x7f, 0x1d, 0x64, 0x55,
			0xa1, 0x15, 0xa3, 0x67, 0x3e, 0x00, 0xda, 0x1f,
			0x46, 0xa1, 0x0c, 0x80, 0x79, 0x45, 0xac, 0x47,
			0x71, 0xae, 0xba, 0x7f, 0xe3, 0x50, 0x2f, 0x50,
			0x22, 0xc0, 0x9b, 0x18, 0xe4, 0x69, 0x0d, 0xbd,
			0x49, 0x81, 0x33, 0x41, 0x19, 0x3b, 0xc2, 0x96,
			0x4d, 0x3e, 0x18, 0xb4, 0xd2, 0x57, 0x21, 0xea,
			0x89, 0x6a, 0x77, 0x71, 0x92, 0xaf, 0xcd, 0x47,
		},
		/* S4 : 256 byte */
		{
			0x84, 0x40, 0x74, 0xee, 0xba, 0x27, 0x9c, 0x98,
			0xb7, 0x63, 0xfb, 0xff, 0x66, 0xf7, 0x32, 0x4b,
			0xdc, 0xe0, 0x4b, 0x27, 0xac, 0xca, 0x85, 0xe4,
			0xd5, 0xab, 0xe5, 0x14, 0x60, 0x51, 0x85, 0xba,
			0xd2, 0x12, 0x07, 0xb6, 0x2a, 0x42, 0x7f, 0xce,
			0x1d, 0x9a, 0xc2, 0xb2, 0xf0, 0xd0, 0x26, 0x0d,
			0x45, 0x16, 0x0a, 0x2a, 0x82, 0x2a, 0xba, 0xc1,
			0xda, 0x0a, 0x96, 0x68, 0x36, 0x52, 0x1a, 0xe6,
			0x56, 0x4f, 0x38, 0xe9, 0x96, 0x53, 0x8b, 0x4a,
			0xf3, 0x00, 0xde, 0x69, 0xc4, 0xaa, 0x0a, 0x57,
			0x21, 0xe8, 0xc8, 0x9f, 0x20, 0x32, 0x0e, 0x4e,
			0x09, 0xad, 0x1f, 0x99, 0xb6, 0xa0, 0xba, 0x3f,
			0xa2, 0xb4, 0x13, 0x30, 0xb8, 0x4a, 0x89, 0x0c,
			0x30, 0x27, 0x2f, 0x63, 0x12, 0xb2, 0xcb, 0xad,
			0x7d, 0x38, 0x33, 0x6f, 0xaf, 0x92, 0xa8, 0xc4,
			0x23, 0x4a, 0x08, 0x14, 0xef, 0x66, 0x2f, 0x62,
			0xca, 0x3e, 0xbd, 0x49, 0x2f, 0x80, 0x54, 0x57,
			0x61, 0x3e, 0x04, 0xe2, 0x41, 0xad, 0x95, 0x16,
			0xc1, 0x64, 0x12, 0x96, 0x33, 0x42, 0x28, 0xcc,
			0xcf, 0x24, 0x56, 0x2d, 0x69, 0xab, 0x45, 0x35,
			0x2d, 0x30, 0xc6, 0x8d, 0xfc, 0x7c, 0xb7, 0xe1,
			0x15, 0x9b, 0xcb, 0x5c, 0x0b, 0xec, 0xbd, 0xb3,
			0xff, 0xce, 0xcb, 0x44, 0x6d, 0x0e, 0xa2, 0x50,
			0x7e, 0xbe, 0xbb, 0x6d, 0x9c, 0x8d, 0x93, 0x88,
			0xd6, 0xaf, 0xbb, 0x67, 0xc5, 0xf3, 0x5d, 0xf3,
			0x43, 0xad, 0x4c, 0x23, 0xe0, 0xb6, 0x5b, 0xe1,
			0x1e, 0x0f, 0x8e, 0x11, 0x7f, 0xa2, 0x6a, 0x6a,
			0xbd, 0xcf, 0xe2, 0x15, 0xf8, 0xb0, 0x46, 0x6d,
			0x31, 0xd6, 0x16, 0x86, 0x11, 0xb7, 0x1d, 0xbc,
			0xb9, 0x99, 0x23, 0x3b, 0x50, 0xde, 0xe5, 0x41,
			0x4e, 0x54, 0xd4, 0x44, 0xc3, 0xd3, 0xc4, 0x23,
			0xdc, 0x8c, 0x58, 0x81, 0x3a, 0x57, 0x10, 0x58,
		},
	},
	/* SHA512 [5] */
	{
		/* Msg5 : 128 byte */
		{
			0xd0, 0x43, 0x13, 0x97, 0xe5, 0x60, 0xed, 0xbb,
			0xa3, 0xe0, 0x79, 0x2f, 0x37, 0x91, 0x5f, 0xd2,
			0x96, 0xe3, 0x60, 0x2c, 0xb3, 0x4a, 0x2e, 0xf6,
			0xf5, 0xe4, 0x81, 0xdc, 0xe8, 0x5c, 0x67, 0x81,
			0x33, 0x0e, 0xdb, 0xc4, 0xca, 0x6c, 0x9a, 0x42,
			0x64, 0xa0, 0x32, 0x1b, 0x30, 0x73, 0x5c, 0xfa,
			0xc3, 0x6d, 0x8b, 0x4f, 0x55, 0x3d, 0xc5, 0xdf,
			0x2e, 0x5c, 0xb2, 0x7f, 0x5b, 0xee, 0xf3, 0x1c,
			0xa5, 0xe9, 0xb4, 0xff, 0xc4, 0x78, 0x85, 0x4f,
			0xcf, 0xa2, 0x65, 0xd8, 0xf7, 0x27, 0x20, 0x0a,
			0x75, 0xaa, 0xdc, 0x45, 0xc1, 0x15, 0xee, 0x54,
			0x05, 0x3a, 0xf2, 0x37, 0xd1, 0xb6, 0x1a, 0x25,
			0x10, 0x1b, 0xc6, 0xd1, 0x3b, 0x4e, 0x55, 0xed,
			0xcc, 0x2d, 0x3b, 0xec, 0xf6, 0x75, 0x54, 0x0d,
			0x93, 0xe3, 0x79, 0x95, 0x5e, 0x9a, 0x50, 0x5b,
			0x62, 0xc5, 0x68, 0x8a, 0xb2, 0x7d, 0x85, 0xa3,
		},
		/* S5 : 256 byte */
		{
			0xe0, 0x88, 0x79, 0xc1, 0x23, 0x38, 0xd9, 0xea,
			0xa5, 0xe8, 0x64, 0x83, 0x51, 0xba, 0x51, 0x69,
			0x41, 0xfd, 0xb5, 0x2d, 0x65, 0x78, 0xa0, 0xba,
			0x0c, 0xd8, 0x8e, 0x16, 0x37, 0xd0, 0x41, 0xec,
			0xe3, 0x5b, 0xb3, 0xa4, 0xd6, 0xc5, 0xe8, 0x99,
			0xca, 0x3e, 0xcc, 0x1b, 0x74, 0xa9, 0x23, 0x54,
			0xa7, 0x09, 0x40, 0xf0, 0xf8, 0x3f, 0xfe, 0x25,
			0xa9, 0xaf, 0xca, 0x90, 0x1f, 0xeb, 0x6e, 0xd4,
			0xdc, 0xce, 0x64, 0xfa, 0xa1, 0x00, 0xdd, 0xf0,
			0x43, 0xe5, 0x14, 0x42, 0x6f, 0x4f, 0x1e, 0x6a,
			0xa9, 0x42, 0x32, 0x47, 0xbf, 0x1e, 0x7c, 0xe9,
			0x61, 0x58, 0xae, 0x8f, 0x1e, 0xb1, 0x96, 0x1f,
			0xfa, 0xe1, 0xd2, 0x32, 0xc1, 0x35, 0x04, 0xe9,
			0x9e, 0x09, 0xf0, 0xda, 0x75, 0x13, 0xa2, 0x62,
			0x0e, 0x88, 0xd0, 0x5a, 0xcd, 0xfb, 0xb9, 0x64,
			0x47, 0x48, 0xdf, 0x12, 0x47, 0x5d, 0x01, 0xaf,
			0x7a, 0x17, 0xf3, 0x5a, 0x69, 0x71, 0xd4, 0xe4,
			0x01, 0xf6, 0x2a, 0x90, 0x30, 0x18, 0xf2, 0x9c,
			0x1b, 0x76, 0xfb, 0x8b, 0xf7, 0x16, 0x6e, 0x19,
			0xd7, 0x74, 0xd3, 0x18, 0xc6, 0x7c, 0x83, 0x4c,
			0x4e, 0x8b, 0x0c, 0xc0, 0xb4, 0xd3, 0x6a, 0x54,
			0x58, 0x61, 0x69, 0xf4, 0x3d, 0xdb, 0x1f, 0x26,
			0x9e, 0x62, 0xbe, 0x36, 0x32, 0x22, 0xbc, 0x1a,
			0x1d, 0x1f, 0xe2, 0x1b, 0x48, 0x8a, 0xfd, 0x53,
			0x9b, 0x5f, 0x8e, 0x87, 0xde, 0xd6, 0x79, 0x79,
			0xe6, 0xb1, 0xf1, 0x8f, 0x8e, 0x54, 0x25, 0x87,
			0xae, 0xea, 0xd0, 0x7c, 0x91, 0xb4, 0x35, 0xc9,
			0x33, 0xe5, 0xac, 0xd3, 0x3e, 0xcb, 0xc7, 0xda,
			0x8b, 0x20, 0x94, 0xc5, 0x0f, 0x51, 0x2f, 0xa9,
			0xad, 0xe6, 0x8c, 0x3c, 0x40, 0xec, 0x96, 0x49,
			0xb0, 0xa9, 0x2c, 0x72, 0x07, 0x60, 0xe5, 0xaf,
			0xb7, 0xb6, 0xfd, 0x94, 0xd6, 0xc5, 0x3a, 0xce,
		},
	},
	/* SHA512 [6] */
	{
		/* Msg6 : 128 byte */
		{
			0x29, 0x3b, 0xf1, 0x3d, 0x84, 0xdb, 0x45, 0xe8,
			0xcc, 0x67, 0xb4, 0xa0, 0xd6, 0xf2, 0x59, 0x21,
			0x3e, 0x36, 0x53, 0x23, 0xad, 0xcd, 0x23, 0x2f,
			0x58, 0xa5, 0x55, 0xb0, 0xc9, 0xae, 0x63, 0x4d,
			0xe2, 0xd5, 0xd6, 0x76, 0x1f, 0x36, 0xae, 0x3d,
			0x1b, 0x8d, 0x04, 0x68, 0x56, 0xee, 0xee, 0xc4,
			0x35, 0xb7, 0xa3, 0xbc, 0x4a, 0xc2, 0xdf, 0x29,
			0xd6, 0xdf, 0x89, 0x6c, 0x8c, 0x81, 0x94, 0xbb,
			0x98, 0xb7, 0x23, 0xb8, 0xe0, 0x5e, 0xf0, 0x48,
			0x8a, 0x96, 0xee, 0xa2, 0xbe, 0x72, 0x2d, 0xa6,
			0xad, 0xf4, 0xfe, 0x71, 0xd2, 0x38, 0x59, 0x2e,
			0x77, 0xef, 0x7b, 0x2e, 0x7c, 0x0f, 0xd3, 0x3c,
			0x54, 0xc9, 0x1f, 0x2a, 0x50, 0xbc, 0xd3, 0xb0,
			0x20, 0x68, 0xba, 0x77, 0x97, 0xe5, 0xdf, 0x70,
			0xae, 0xd4, 0xae, 0x6a, 0xcc, 0x97, 0x57, 0xe4,
			0x44, 0xbd, 0x73, 0x1f, 0x1f, 0xc0, 0xea, 0x78,
		},
		/* S6 : 256 byte */
		{
			0xc1, 0x0f, 0x11, 0x5b, 0x8c, 0x93, 0x09, 0x64,
			0xd8, 0x93, 0x55, 0x20, 0x75, 0xc5, 0x0f, 0x9c,
			0x60, 0x68, 0x00, 0xf4, 0x46, 0xd4, 0xd8, 0x02,
			0x26, 0xff, 0xb1, 0x50, 0x25, 0xe7, 0xa0, 0xed,
			0x9c, 0xd3, 0x29, 0xae, 0x73, 0x46, 0x54, 0x66,
			0x47, 0x53, 0x8a, 0x14, 0x21, 0xac, 0xd8, 0x2c,
			0x0a, 0xfb, 0x34, 0x5c, 0xc5, 0x90, 0x99, 0xf3,
			0x0b, 0x94, 0xf8, 0x12, 0xd5, 0xf5, 0xd4, 0x5b,
			0xc8, 0x70, 0xd6, 0xa7, 0xa5, 0x05, 0x33, 0xdb,
			0xc9, 0x7e, 0x44, 0x88, 0xfe, 0xd2, 0x6f, 0x30,
			0x61, 0xa6, 0x54, 0x55, 0x9b, 0x18, 0xa7, 0xba,
			0xfb, 0x3b, 0x90, 0x17, 0x00, 0x20, 0xc0, 0x96,
			0x7f, 0xa5, 0xa1, 0x1d, 0x13, 0x59, 0xb5, 0x61,
			0xc0, 0xed, 0xd5, 0x62, 0xfb, 0xed, 0xdc, 0xe8,
			0xf6, 0x97, 0xab, 0xd1, 0x9c, 0xd3, 0xf5, 0x8b,
			0x9b, 0x0a, 0x3f, 0x5f, 0xc1, 0x31, 0xbb, 0x52,
			0x3a, 0xc2, 0x14, 0x9c, 0xe9, 0x5f, 0x3c, 0x5f,
			0xfc, 0x2c, 0xda, 0x3c, 0x98, 0x80, 0x69, 0xd2,
			0x67, 0x5d, 0x1f, 0xfe, 0xc2, 0x99, 0x73, 0xd5,
			0xbd, 0x7b, 0x61, 0xc6, 0x4d, 0xcc, 0x17, 0x36,
			0x7e, 0x50, 0xaf, 0xd5, 0x55, 0xea, 0x78, 0x73,
			0x8b, 0x75, 0x49, 0x1e, 0xec, 0x3e, 0x1f, 0x0b,
			0x78, 0xfa, 0x32, 0x3e, 0x06, 0xbb, 0x95, 0x18,
			0x74, 0x26, 0x02, 0xf3, 0x41, 0x85, 0x6d, 0x35,
			0x75, 0xf1, 0x8c, 0xe3, 0x5f, 0x4e, 0x42, 0x98,
			0xe1, 0x24, 0xe4, 0x53, 0x7a, 0x3d, 0xe4, 0x20,
			0x37, 0x04, 0xbe, 0x90, 0xdc, 0xfb, 0x84, 0x12,
			0x25, 0xcd, 0x5b, 0xe4, 0xac, 0x69, 0x4c, 0x14,
			0x4e, 0x23, 0x83, 0x45, 0xc3, 0x0a, 0x3c, 0xa2,
			0x3a, 0xcc, 0xb7, 0x11, 0x4f, 0xfc, 0x0b, 0xb8,
			0x9a, 0x14, 0x6b, 0xf1, 0x92, 0xa6, 0xd7, 0x8b,
			0x3a, 0x32, 0x4c, 0x8a, 0x41, 0x8b, 0x7a, 0xf9,
		},
	},
	/* SHA512 [7] */
	{
		/* Msg7 : 128 byte */
		{
			0x91, 0xa9, 0x14, 0x70, 0x7b, 0x2c, 0x0e, 0x33,
			0x58, 0x5e, 0x56, 0x04, 0x2b, 0x50, 0x88, 0x9b,
			0x1f, 0x8a, 0xd9, 0xe8, 0xb2, 0xa1, 0x5b, 0x49,
			0x19, 0x0c, 0x7d, 0x00, 0xe0, 0x33, 0xd1, 0xe4,
			0xd2, 0xc9, 0x13, 0x56, 0x18, 0x5c, 0x66, 0x77,
			0xa5, 0x2a, 0xe0, 0x99, 0xd1, 0x37, 0x49, 0xf3,
			0x43, 0x9c, 0x20, 0x98, 0x15, 0x22, 0xdf, 0xaa,
			0x33, 0x0f, 0x81, 0xca, 0x04, 0x40, 0x40, 0xd4,
			0x4d, 0x78, 0xa3, 0xc9, 0x52, 0xf8, 0xb8, 0x0d,
			0x3e, 0x50, 0x9e, 0xd3, 0xc4, 0x74, 0x47, 0xd5,
			0x07, 0x12, 0x7c, 0x48, 0xb7, 0x23, 0x22, 0x0f,
			0x7d, 0xc1, 0xbb, 0x2f, 0x9a, 0x38, 0x30, 0x83,
			0xcb, 0x5f, 0xcd, 0xb1, 0x6f, 0x29, 0x8d, 0x5c,
			0xeb, 0x77, 0x98, 0x9b, 0x4e, 0x30, 0x0a, 0xaa,
			0x31, 0x94, 0xf6, 0xe0, 0xe2, 0xcd, 0xab, 0xe1,
			0xc1, 0xc7, 0x35, 0x15, 0xe9, 0x42, 0x27, 0x59,
		},
		/* S7 : 256 byte */
		{
			0x77, 0xd1, 0xc6, 0xcf, 0x12, 0x86, 0xcf, 0x21,
			0x35, 0x0e, 0x3d, 0x33, 0x1e, 0x8f, 0xa5, 0x8a,
			0xdd, 0xcf, 0x79, 0x6d, 0xc6, 0x80, 0xaf, 0x1a,
			0x0d, 0x42, 0x60, 0xa3, 0xb4, 0xdf, 0x25, 0x6b,
			0xf0, 0x48, 0x70, 0xa8, 0x52, 0x12, 0x9f, 0xb4,
			0xa9, 0x50, 0xc7, 0x32, 0xda, 0x2f, 0x7b, 0xb0,
			0x6b, 0x41, 0x4d, 0x52, 0xc7, 0xc4, 0x42, 0xb3,
			0xaf, 0x8e, 0xb0, 0xa7, 0x6c, 0x3b, 0x70, 0x1e,
			0xfa, 0x66, 0xd5, 0x7b, 0x2f, 0x04, 0x7d, 0xe9,
			0x94, 0xee, 0x20, 0x9d, 0xff, 0xcc, 0x62, 0x91,
			0x58, 0x7f, 0x0d, 0xe4, 0xf6, 0x95, 0xda, 0x12,
			0x30, 0x0d, 0x5f, 0x74, 0xd0, 0xda, 0xe0, 0x02,
			0x11, 0x4e, 0x0b, 0xe8, 0xba, 0xbe, 0x21, 0xdb,
			0xb0, 0x31, 0xea, 0x3c, 0x2a, 0xab, 0xe9, 0x22,
			0xfc, 0x82, 0x2b, 0xcc, 0x97, 0x3e, 0xa1, 0xc4,
			0xb0, 0xdc, 0x0e, 0x4f, 0x85, 0xf8, 0x3d, 0xb4,
			0xd0, 0x2c, 0xdd, 0xd2, 0x38, 0xe6, 0x87, 0x85,
			0xe8, 0xa3, 0x1d, 0xb7, 0x0b, 0x83, 0xe1, 0xad,
			0xfe, 0x29, 0x1e, 0xb6, 0x3d, 0x93, 0x4e, 0xc9,
			0xc7, 0xb9, 0x3d, 0x0b, 0x36, 0x9a, 0x59, 0x21,
			0x5d, 0x24, 0x21, 0xaa, 0xb8, 0x31, 0xbf, 0xd3,
			0xb9, 0xa6, 0xb1, 0xc5, 0x18, 0x85, 0x34, 0x92,
			0xd8, 0x7c, 0x57, 0x72, 0x90, 0xc4, 0x46, 0xb5,
			0xa9, 0x42, 0xbd, 0x4d, 0x2b, 0xc7, 0x6d, 0x7e,
			0x84, 0x50, 0xee, 0xcb, 0x0d, 0xeb, 0xb5, 0x07,
			0x38, 0x38, 0xa0, 0xfd, 0x52, 0x18, 0x54, 0xcc,
			0x11, 0x27, 0xd5, 0xea, 0x51, 0x49, 0x38, 0xb4,
			0x99, 0xd2, 0x28, 0x9c, 0x1e, 0x89, 0x1e, 0x1c,
			0xf0, 0xbb, 0x46, 0x6e, 0x11, 0xe3, 0x10, 0x32,
			0x4a, 0x56, 0x6c, 0x51, 0xb7, 0x50, 0x72, 0x32,
			0x34, 0x03, 0xdf, 0xc5, 0xeb, 0x5b, 0xfd, 0x0d,
			0xb5, 0x38, 0xfc, 0x45, 0x0e, 0xcb, 0xc9, 0x25,
		},
	},
	/* SHA512 [8] */
	{
		/* Msg8 : 128 byte */
		{
			0x76, 0xee, 0x8e, 0xc9, 0x33, 0x53, 0xc6, 0x27,
			0x49, 0xc4, 0x9c, 0x66, 0x84, 0x6c, 0xe1, 0x28,
			0xcf, 0x17, 0x7c, 0xc3, 0xf9, 0xe8, 0x54, 0x94,
			0xb9, 0x4e, 0x71, 0x96, 0xf0, 0x34, 0x5e, 0x32,
			0x2f, 0x78, 0xd1, 0x59, 0x79, 0x9f, 0x8d, 0xd1,
			0x4a, 0xc7, 0x88, 0xcc, 0xd7, 0xdc, 0x49, 0xbf,
			0x98, 0x0f, 0x95, 0x71, 0x04, 0x84, 0x4a, 0x53,
			0x9c, 0x4b, 0x8b, 0x0f, 0x2a, 0x92, 0x1d, 0x63,
			0x4b, 0x19, 0x11, 0x30, 0x2b, 0xe6, 0xa4, 0xce,
			0x90, 0x39, 0x63, 0xa3, 0x1a, 0xc2, 0x93, 0xf4,
			0xc9, 0x12, 0xcf, 0xfa, 0xbf, 0x50, 0xf3, 0x39,
			0x47, 0x2d, 0x39, 0x0d, 0x17, 0x19, 0xa2, 0x86,
			0xd2, 0xb8, 0x98, 0x75, 0xd1, 0x8f, 0xd1, 0xc7,
			0x23, 0x04, 0x76, 0x12, 0xd2, 0x85, 0x85, 0x6e,
			0x68, 0x07, 0x74, 0x86, 0xb2, 0xb2, 0x17, 0xef,
			0xc4, 0xda, 0xc3, 0xb8, 0x3d, 0x32, 0xb4, 0x42,
		},
		/* S8 : 256 byte */
		{
			0x26, 0x89, 0xf6, 0x8d, 0x42, 0xcb, 0xde, 0x98,
			0xb3, 0x62, 0x7f, 0xe8, 0x09, 0x38, 0x05, 0x98,
			0xfb, 0x1a, 0xea, 0x00, 0x13, 0x66, 0xc9, 0xad,
			0xf8, 0x2e, 0x73, 0x49, 0x51, 0x5a, 0xe1, 0x88,
			0x9a, 0x85, 0xd1, 0x6e, 0x2d, 0xdf, 0xcc, 0x51,
			0xd8, 0x36, 0x99, 0xfa, 0x2b, 0x6d, 0xa5, 0x80,
			0xc1, 0xc5, 0xf3, 0x2a, 0x53, 0x20, 0x8d, 0xc0,
			0x83, 0x5a, 0xe7, 0x45, 0xdd, 0x8a, 0xdd, 0x52,
			0x38, 0xa4, 0x84, 0x24, 0x13, 0xa1, 0x07, 0xbd,
			0x4a, 0x39, 0xbf, 0xaf, 0x54, 0x6b, 0x3c, 0x99,
			0x4c, 0xf5, 0x0e, 0x29, 0xad, 0xd6, 0xdb, 0x3b,
			0x51, 0x38, 0xc3, 0x4f, 0xc7, 0x89, 0x4b, 0x91,
			0x0b, 0x00, 0xa5, 0xd5, 0xec, 0x5c, 0x87, 0xdb,
			0x8a, 0xf0, 0x3e, 0x22, 0x99, 0x7d, 0x51, 0x5d,
			0x14, 0x30, 0xce, 0x3b, 0x47, 0x54, 0x3a, 0x24,
			0xad, 0x95, 0x7e, 0x19, 0x2c, 0x99, 0x6b, 0xb0,
			0xbd, 0x38, 0x8f, 0xd6, 0x58, 0x23, 0xf0, 0xcb,
			0xf4, 0x0d, 0x46, 0x77, 0x6e, 0xd6, 0x47, 0x98,
			0x9e, 0x7a, 0x5d, 0x6a, 0x6c, 0xe4, 0xd4, 0x33,
			0x05, 0x4d, 0x3c, 0x68, 0x73, 0xaa, 0x04, 0xa4,
			0xbd, 0x2f, 0xc2, 0x0a, 0x92, 0xd6, 0x8b, 0x90,
			0xe4, 0x12, 0xe4, 0x4c, 0x44, 0x91, 0x4a, 0x76,
			0xfd, 0x12, 0x66, 0x40, 0x34, 0xc2, 0x07, 0x62,
			0x21, 0x07, 0xc5, 0x1e, 0x92, 0x98, 0x7e, 0x51,
			0xff, 0xd3, 0x81, 0x60, 0x5b, 0x24, 0x6f, 0x01,
			0x6f, 0xb7, 0x84, 0x52, 0xd7, 0xbd, 0xd7, 0x38,
			0x91, 0x17, 0x2d, 0x3f, 0x88, 0xef, 0x2e, 0x2d,
			0xa2, 0x53, 0xa5, 0x80, 0x0b, 0x46, 0x90, 0x91,
			0xd9, 0xa4, 0x3a, 0x94, 0x7e, 0x85, 0xc8, 0xda,
			0x28, 0x55, 0x63, 0x06, 0x30, 0xef, 0xa6, 0x3b,
			0x41, 0x8f, 0x53, 0x45, 0x62, 0x3e, 0x3c, 0x25,
			0x8f, 0x2e, 0x93, 0xdb, 0x3d, 0x09, 0x4a, 0x52,
		},
	},
	/* SHA512 [9] */
	{
		/* Msg9 : 128 byte */
		{
			0xd9, 0xeb, 0x32, 0xd9, 0x9c, 0x9e, 0x6a, 0x80,
			0x01, 0xa3, 0x01, 0x07, 0xc2, 0x9b, 0xa5, 0xbb,
			0x0b, 0xd6, 0xf3, 0x11, 0x89, 0x19, 0x2f, 0x8c,
			0xc5, 0x9e, 0x39, 0xe1, 0xb0, 0x5d, 0xbc, 0x5a,
			0x7e, 0x8a, 0xa9, 0x78, 0xb8, 0x5f, 0xe4, 0xdc,
			0x8d, 0x1b, 0x3d, 0x67, 0x6a, 0x4b, 0xa1, 0xa1,
			0xca, 0x48, 0x91, 0x57, 0x4e, 0x01, 0xd4, 0x89,
			0x10, 0xfa, 0x69, 0x83, 0x35, 0x95, 0xc0, 0x49,
			0xc1, 0x91, 0x2a, 0x38, 0xaf, 0xd0, 0x8d, 0xeb,
			0x42, 0x5d, 0x5c, 0x5c, 0x96, 0xad, 0xc6, 0x4b,
			0x7a, 0x25, 0x2e, 0xe4, 0x82, 0xdd, 0xdc, 0x9c,
			0x57, 0xa4, 0xf2, 0x5c, 0x52, 0x44, 0xa1, 0xe1,
			0x49, 0x07, 0x9c, 0x63, 0xa9, 0x79, 0xcd, 0x74,
			0xc5, 0x70, 0x48, 0x2c, 0x6e, 0x4a, 0x7d, 0x83,
			0xc4, 0x76, 0xb1, 0xfe, 0x4b, 0x36, 0xaf, 0x8e,
			0x42, 0xa2, 0xba, 0xb5, 0x30, 0xf1, 0xc7, 0xea,
		},
		/* S9 : 256 byte */
		{
			0xd2, 0xb2, 0xe8, 0x70, 0x1e, 0x92, 0x68, 0xf0,
			0x50, 0xfe, 0xdd, 0x00, 0x40, 0xed, 0x46, 0x8d,
			0x3e, 0x5a, 0x5a, 0x5e, 0x20, 0xde, 0x15, 0x76,
			0x08, 0xaa, 0x70, 0xdc, 0x70, 0x59, 0xaf, 0x94,
			0xa6, 0xdb, 0xa3, 0x49, 0x54, 0x5d, 0x3b, 0x9c,
			0x65, 0xe6, 0x4e, 0x74, 0xc5, 0x55, 0xcb, 0xc0,
			0xec, 0x46, 0x2d, 0x49, 0x6c, 0xad, 0xf4, 0x5c,
			0x4e, 0xd2, 0x40, 0xa2, 0xa1, 0xd6, 0xcd, 0x02,
			0x18, 0x37, 0xee, 0x85, 0x7c, 0xeb, 0x0e, 0x5a,
			0xa0, 0xc5, 0x2b, 0xbd, 0x9c, 0xd7, 0x0a, 0x49,
			0x5a, 0x59, 0x7a, 0x45, 0xe5, 0x63, 0x0c, 0xae,
			0x62, 0xb6, 0x95, 0x7e, 0xe7, 0xf9, 0x5f, 0x77,
			0x2f, 0xb8, 0x82, 0x1f, 0xe7, 0x81, 0xf7, 0xa3,
			0xec, 0x7a, 0x41, 0xf7, 0xdb, 0x5c, 0xaa, 0xec,
			0xda, 0xd9, 0xaf, 0x8a, 0xb3, 0xc9, 0xb0, 0x58,
			0x29, 0x1d, 0x6b, 0x9c, 0x98, 0xd5, 0x0b, 0x2c,
			0x47, 0x7a, 0xfe, 0x7b, 0xaf, 0x76, 0x9c, 0x42,
			0x4f, 0x60, 0xe3, 0x9a, 0x62, 0xc4, 0xd6, 0x3a,
			0x8d, 0xd9, 0x9b, 0x70, 0x17, 0xae, 0x26, 0x71,
			0x91, 0x56, 0x1c, 0x5e, 0x29, 0x55, 0x76, 0x4c,
			0x89, 0x32, 0xed, 0x9b, 0x4b, 0x75, 0x92, 0x4d,
			0x6e, 0xa6, 0xf8, 0xb6, 0x22, 0x72, 0xea, 0xef,
			0xbe, 0x0b, 0xbc, 0xcb, 0x59, 0xa4, 0x35, 0x11,
			0xab, 0xe4, 0x9e, 0x2a, 0xb4, 0x86, 0xb7, 0xf6,
			0x17, 0x1f, 0x0d, 0xb8, 0xa8, 0x77, 0x0c, 0xfd,
			0xa0, 0xd2, 0x33, 0x9b, 0xe9, 0xe7, 0x8c, 0xb7,
			0x41, 0xc2, 0xdd, 0x0d, 0xe3, 0xd6, 0xc2, 0x72,
			0xc1, 0xa6, 0x1f, 0xd5, 0xde, 0x72, 0xfc, 0xd8,
			0x61, 0x8e, 0xd9, 0x84, 0xd8, 0x91, 0xee, 0x5d,
			0x30, 0x02, 0xeb, 0xce, 0xf8, 0xaf, 0x23, 0x7a,
			0xf4, 0x41, 0x48, 0x4a, 0xa2, 0x29, 0xcf, 0xea,
			0x3a, 0xe2, 0xd5, 0x3f, 0x22, 0x27, 0x7c, 0xe4,
		},
	},
};

typedef mod2048_t tv_t;


#include "siggen15test.c"
