/* siggen15_2_1536_testfc.c */
/*
 * Copyright (c) 2017 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/index.html.
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */

/*
 * This test vector was created based on SigGen15_186-2.txt from
 * https://csrc.nist.gov/CSRC/media/Projects/Cryptographic-Algorithm-Validation-Program/documents/dss/186-2rsatestvectors.zip
 *
 * The link to the archive file exists in the following URL:
 * https://csrc.nist.gov/projects/cryptographic-algorithm-validation-program/digital-signatures/
 */
/*
 * https://csrc.nist.gov/projects/cryptographic-algorithm-validation-program/digital-signatures/
 * https://csrc.nist.gov/CSRC/media/Projects/Cryptographic-Algorithm-Validation-Program/documents/dss/186-2rsatestvectors.zip
 * SigGen15_186-2.txt
 */
#include "siggen15test.h"

static const unsigned short sn1[] = {
	0xa2fb, 0xfe82, 0xfccf, 0x8477, 0x2464, 0x0571, 0xbd39, 0x3ca2,
	0xdbe4, 0xe9a3, 0xad85, 0xcbda, 0xd915, 0x1faf, 0x27b7, 0x127d,
	0x3714, 0x7cb7, 0xfdd3, 0x508d, 0x68b9, 0xa8b5, 0xb914, 0xcacc,
	0x863b, 0x3e18, 0x0665, 0xbad3, 0x2c0c, 0x1ec8, 0xf9d8, 0x7740,
	0xfa58, 0x91de, 0x8f54, 0x085e, 0xb042, 0x4d25, 0x89f5, 0x3adb,
	0x20ac, 0x92ee, 0xc98d, 0x9ce5, 0x378e, 0x9875, 0xee78, 0x90f9,
	0x9b38, 0x2866, 0x2471, 0xb24b, 0xa2ca, 0xad36, 0x2487, 0x0301,
	0x69dd, 0x127c, 0x8e6e, 0x7bf3, 0xc8f0, 0x1f7f, 0xf5e0, 0x9d3e,
	0x9118, 0x9ac6, 0xe373, 0x55dd, 0xa752, 0x6dd5, 0xb63c, 0x6b32,
	0xcc9f, 0x5b86, 0x251f, 0xdc9d, 0xb8ba, 0x9e67, 0x6f84, 0x8a44,
	0xe59c, 0x0955, 0x50d4, 0xf448, 0x0295, 0xae32, 0x7ac7, 0xfb87,
	0x7a28, 0x35a2, 0x16cc, 0x06c3, 0x7866, 0x82d3, 0x1b6d, 0xff19,
};

static const unsigned short se1[] = {
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001,
};

static const unsigned short sd1[] = {
	0x068b, 0x7f86, 0x3390, 0x42c5, 0xc50a, 0x9634, 0x61d0, 0xa358,
	0x77e3, 0x9aa5, 0x45c1, 0xd674, 0x989c, 0x924b, 0xe698, 0xa1af,
	0xb10f, 0x4bcd, 0xd8ad, 0xcc71, 0x8d47, 0xcd58, 0x54d1, 0x1aae,
	0xb962, 0x3625, 0x6156, 0x62f8, 0xf96f, 0x182a, 0x626c, 0x18a7,
	0xdd95, 0xc26f, 0xd14a, 0x22d6, 0xe895, 0x9503, 0x01a5, 0xfd21,
	0xd10f, 0x550c, 0x2d40, 0x5851, 0x5518, 0x8f13, 0x474b, 0x04a9,
	0x4cee, 0x8df7, 0xe6b8, 0x89c4, 0xe9b6, 0x8145, 0x886e, 0xba20,
	0x9577, 0xff4a, 0xd307, 0x2c72, 0x219b, 0x72b0, 0x803b, 0x308f,
	0xb2e4, 0xd9a8, 0xbbd3, 0x7008, 0x8c4d, 0xe857, 0x8271, 0x3661,
	0x2f6e, 0x7731, 0xd569, 0x0031, 0x8c43, 0x3eda, 0x485a, 0x4798,
	0xef7b, 0xe50a, 0x530f, 0x1f3f, 0x173f, 0xc251, 0xee71, 0x92c3,
	0xbceb, 0x598c, 0x1098, 0x72fc, 0xa098, 0xb9f9, 0xd5cc, 0x0001,
};

#define HAS_SHA1_TESTVECTOR

#define HAS_SHA224_TESTVECTOR

#define HAS_SHA256_TESTVECTOR

#define HAS_SHA384_TESTVECTOR

#define HAS_SHA512_TESTVECTOR

/* 10 elements */
static mod1536_t SHA1[] = {
	/* SHA1 [0] */
	{
		/* Msg0 : 128 byte */
		{
			0xf4, 0x46, 0x1d, 0x25, 0x95, 0x1e, 0xa6, 0x96,
			0x5b, 0xbe, 0x2b, 0x16, 0xf1, 0xf9, 0xc7, 0xa2,
			0x71, 0x4e, 0x87, 0x5f, 0x7a, 0xb1, 0x22, 0x81,
			0x83, 0x8f, 0xe4, 0x6b, 0x6f, 0x0c, 0xec, 0x17,
			0x61, 0x8f, 0x97, 0xb9, 0xd1, 0x80, 0x3c, 0x9f,
			0xe0, 0x50, 0x1a, 0x5c, 0xe8, 0xba, 0x8e, 0x25,
			0x58, 0x49, 0x8a, 0x7b, 0xbf, 0x1b, 0x42, 0x0b,
			0x26, 0xe4, 0x28, 0xd2, 0xa3, 0x35, 0x1b, 0x84,
			0x2b, 0xff, 0xdb, 0x2f, 0xa8, 0x53, 0xc1, 0x1b,
			0x4b, 0x6b, 0xad, 0xf6, 0x24, 0xee, 0x3f, 0x2d,
			0xf0, 0x70, 0x4a, 0x9d, 0x32, 0x38, 0x85, 0x6b,
			0x85, 0x47, 0x84, 0x30, 0x30, 0x96, 0xe7, 0x5a,
			0xfb, 0x9e, 0xd2, 0xcf, 0x41, 0x1d, 0x9d, 0xd3,
			0x47, 0x18, 0xcc, 0x2b, 0xcc, 0x1c, 0x41, 0x82,
			0xe1, 0xca, 0xb0, 0x0d, 0xfb, 0x93, 0x54, 0x6b,
			0x47, 0xbf, 0xe0, 0xcf, 0x3d, 0xb4, 0xb9, 0x60,
		},
		/* S0 : 192 byte */
		{
			0x0b, 0x23, 0xb6, 0x4d, 0xc8, 0x69, 0xd8, 0x05,
			0xa9, 0x10, 0xeb, 0x63, 0xf4, 0xcd, 0xdb, 0x68,
			0x22, 0x32, 0xc0, 0x07, 0xb2, 0xe3, 0x5d, 0x98,
			0xf3, 0x4a, 0x0a, 0x4d, 0x3e, 0xa8, 0x80, 0x67,
			0x23, 0x92, 0x19, 0x20, 0x83, 0x5b, 0x06, 0x79,
			0x2f, 0xe0, 0x15, 0x92, 0x5f, 0x7a, 0x8f, 0xef,
			0x1f, 0xc4, 0x44, 0x7e, 0xe4, 0xab, 0x4a, 0x74,
			0xfa, 0xdc, 0xcf, 0x4b, 0x9f, 0x24, 0xc1, 0x94,
			0x8a, 0xab, 0x43, 0x71, 0x58, 0x24, 0xa0, 0xe2,
			0x8e, 0x61, 0xc2, 0x0f, 0xc6, 0x30, 0xe0, 0x7d,
			0x12, 0x3f, 0xd3, 0x44, 0x88, 0x25, 0xdd, 0xdc,
			0xd7, 0x19, 0xba, 0xf0, 0x6e, 0x54, 0xf4, 0x81,
			0xb1, 0x33, 0x41, 0x2a, 0x29, 0xa9, 0x21, 0xa6,
			0x8d, 0xdb, 0x2e, 0xc2, 0xa9, 0xf4, 0xa5, 0xe6,
			0x1c, 0x72, 0x98, 0xeb, 0x1b, 0x18, 0x3d, 0xb9,
			0x26, 0xa1, 0x39, 0x20, 0x04, 0x5a, 0x4d, 0xf0,
			0x86, 0xd6, 0xd6, 0x12, 0xab, 0xb3, 0x9e, 0xd3,
			0x2c, 0x39, 0xae, 0xee, 0x1d, 0xae, 0xb3, 0x52,
			0xdf, 0x54, 0x7b, 0x9f, 0xc3, 0xba, 0x2f, 0xfe,
			0x3f, 0x3e, 0x05, 0x34, 0x59, 0x46, 0x9f, 0x84,
			0x6c, 0x11, 0x67, 0x9e, 0x50, 0x5f, 0x07, 0xc0,
			0x20, 0xe5, 0x05, 0x95, 0x3f, 0xf5, 0x18, 0xb2,
			0xe7, 0xee, 0xe0, 0x15, 0xc7, 0xc5, 0x0c, 0xb8,
			0x77, 0xab, 0x82, 0x7c, 0x4b, 0x8b, 0x06, 0x09,
		},
	},
	/* SHA1 [1] */
	{
		/* Msg1 : 128 byte */
		{
			0x46, 0x0a, 0x92, 0xb1, 0x9b, 0xb8, 0xc0, 0xbd,
			0xf6, 0x6a, 0xa4, 0x65, 0x47, 0xdf, 0x51, 0x7e,
			0xdd, 0xb7, 0x33, 0xd2, 0x2d, 0x2a, 0xf7, 0x72,
			0xcf, 0xfa, 0xa5, 0x4e, 0xc9, 0xa6, 0x0f, 0x02,
			0x10, 0xe1, 0x6f, 0xf3, 0x4c, 0x42, 0x4c, 0x9b,
			0xdc, 0x3d, 0x9d, 0x21, 0x1a, 0x52, 0x31, 0x2d,
			0xe0, 0x84, 0x4e, 0xfa, 0x4b, 0x0d, 0x99, 0xad,
			0xbe, 0x50, 0x35, 0xe5, 0x2a, 0x0f, 0x2f, 0x93,
			0x8d, 0xde, 0x1a, 0x0c, 0xb9, 0xd8, 0xf6, 0x5c,
			0x57, 0x90, 0x57, 0xdd, 0x2b, 0x4b, 0xc3, 0x09,
			0x9a, 0x6c, 0x5b, 0x8d, 0x69, 0x2f, 0xbd, 0x9e,
			0xc7, 0x9a, 0x2a, 0x90, 0x8e, 0xb1, 0xe4, 0xa5,
			0xc6, 0xea, 0xda, 0x23, 0x6b, 0xe0, 0x87, 0xa9,
			0x6f, 0x4b, 0x18, 0xc2, 0x03, 0x30, 0xcd, 0xbb,
			0x13, 0x55, 0xa1, 0xb2, 0x0f, 0xf8, 0x2d, 0xf0,
			0xf1, 0xc0, 0xca, 0x79, 0x7c, 0xf4, 0xf6, 0xe0,
		},
		/* S1 : 192 byte */
		{
			0x9a, 0xef, 0xed, 0xbd, 0x77, 0x9a, 0xca, 0x14,
			0x70, 0x94, 0x10, 0xc5, 0xba, 0xd0, 0xff, 0xeb,
			0x1b, 0x7d, 0x94, 0x62, 0x70, 0x42, 0xc0, 0x96,
			0xd3, 0x3f, 0x11, 0x4a, 0x12, 0x42, 0x8a, 0x49,
			0x43, 0x1c, 0xc1, 0x9c, 0x9a, 0xc3, 0x2f, 0x28,
			0xcf, 0x1b, 0x2d, 0xc4, 0x41, 0xc0, 0x90, 0xd3,
			0xec, 0x21, 0x5a, 0x42, 0x8a, 0x10, 0x7d, 0x74,
			0x32, 0x00, 0xf2, 0xd2, 0x55, 0xfc, 0x36, 0x2c,
			0xd9, 0x93, 0x7f, 0xed, 0x7f, 0x52, 0x6e, 0x52,
			0x0a, 0xf2, 0x19, 0x35, 0xd1, 0x74, 0xa1, 0x51,
			0x6b, 0xa3, 0x35, 0x33, 0xbf, 0x8d, 0xe2, 0x98,
			0x60, 0x95, 0xd3, 0x7d, 0x68, 0x4a, 0xd4, 0x2f,
			0x44, 0x0c, 0xc5, 0x7b, 0x3a, 0x8b, 0x79, 0x4b,
			0xed, 0x56, 0x38, 0xa5, 0x77, 0xa6, 0x0b, 0xfe,
			0x8c, 0x1c, 0xfa, 0x96, 0xd7, 0x3f, 0x15, 0x5c,
			0x7d, 0x03, 0x97, 0x12, 0xf4, 0xda, 0xf3, 0x67,
			0x9e, 0x65, 0x8f, 0x61, 0x43, 0x7d, 0xfe, 0xb6,
			0x9b, 0xe2, 0x58, 0x6c, 0x6a, 0xa7, 0xcf, 0x7a,
			0xa6, 0x28, 0x38, 0xf6, 0x70, 0xad, 0x3b, 0x2a,
			0xa3, 0x75, 0xa4, 0x98, 0x07, 0x35, 0x75, 0x82,
			0xd3, 0xeb, 0x52, 0xc9, 0x59, 0x72, 0x1b, 0xa6,
			0x79, 0x2a, 0x38, 0xe2, 0x37, 0xcb, 0x3e, 0x47,
			0x90, 0x4a, 0xad, 0x36, 0x91, 0xba, 0xc8, 0xca,
			0x8d, 0x1b, 0xe9, 0x5f, 0x42, 0x42, 0x9e, 0x79,
		},
	},
	/* SHA1 [2] */
	{
		/* Msg2 : 128 byte */
		{
			0xa7, 0x37, 0xcc, 0xb2, 0xc3, 0x36, 0x16, 0x3e,
			0x22, 0x4d, 0x77, 0x6d, 0xde, 0x7e, 0xf3, 0x03,
			0x3a, 0x51, 0x0b, 0x4f, 0xd8, 0x2e, 0x8f, 0xb1,
			0x2c, 0x0a, 0xb4, 0x59, 0x30, 0x46, 0x66, 0x51,
			0x59, 0xd3, 0xdf, 0xbe, 0xca, 0x9b, 0x79, 0x63,
			0xc9, 0x1c, 0xc0, 0x66, 0x6f, 0x56, 0xcc, 0x57,
			0xa3, 0xe8, 0xce, 0x6e, 0x49, 0x76, 0xe8, 0x14,
			0xb6, 0x4d, 0x42, 0xa5, 0x67, 0x4a, 0x5a, 0x75,
			0xf3, 0xf8, 0x9b, 0x11, 0x3f, 0xf8, 0x32, 0xc7,
			0xf1, 0xa6, 0x1d, 0x68, 0x27, 0xf9, 0x84, 0x4c,
			0x68, 0xab, 0x4d, 0x97, 0xdb, 0x9a, 0xeb, 0xbb,
			0xb6, 0x6f, 0x76, 0x3e, 0xfa, 0x7d, 0x01, 0xbe,
			0x5e, 0xec, 0x28, 0x32, 0x88, 0x16, 0xe8, 0x72,
			0x83, 0x31, 0xb4, 0xfa, 0x6e, 0x2f, 0xc4, 0xea,
			0x71, 0xe2, 0xb1, 0x52, 0xf6, 0x64, 0x3f, 0xad,
			0x15, 0xb6, 0x79, 0xab, 0x4f, 0xa7, 0x04, 0x34,
		},
		/* S2 : 192 byte */
		{
			0x37, 0x43, 0x59, 0x02, 0x5e, 0x79, 0xa4, 0x51,
			0x95, 0x6e, 0x52, 0xde, 0x8c, 0xac, 0x9c, 0x2b,
			0x24, 0x6e, 0x97, 0x96, 0x2e, 0x5e, 0xef, 0xcf,
			0xd3, 0xd9, 0x3d, 0xc7, 0xfa, 0x88, 0xbf, 0x3f,
			0xb7, 0x0e, 0x2c, 0x3f, 0xa6, 0xd1, 0x02, 0x55,
			0x8f, 0x5e, 0x27, 0x37, 0xcb, 0x0c, 0x2b, 0xa4,
			0x38, 0xce, 0x85, 0x2a, 0xcf, 0x9d, 0x2f, 0xa9,
			0x86, 0x06, 0x63, 0x0d, 0x08, 0x25, 0xcf, 0x1b,
			0xfd, 0xac, 0xd3, 0x9a, 0xbe, 0xb6, 0xa6, 0x87,
			0x84, 0x0e, 0x5f, 0x98, 0x8d, 0x5c, 0x86, 0x58,
			0xe8, 0xfe, 0x22, 0xd4, 0x74, 0xc7, 0xa5, 0xc1,
			0x96, 0x89, 0x7b, 0xa4, 0x00, 0x5e, 0x7b, 0x95,
			0x00, 0x86, 0x37, 0x14, 0xcd, 0xae, 0x8e, 0x54,
			0xa3, 0xdc, 0x75, 0xb0, 0xad, 0xb8, 0x02, 0x27,
			0x8e, 0xab, 0x96, 0xa7, 0x6c, 0x14, 0xce, 0x0a,
			0xe3, 0x02, 0x12, 0x9c, 0x8b, 0x6f, 0x78, 0x27,
			0x82, 0x0a, 0xfb, 0x94, 0xf3, 0xab, 0xe9, 0xd2,
			0xf8, 0x4f, 0x03, 0x73, 0x1f, 0x05, 0xa2, 0x4a,
			0x03, 0x33, 0x0f, 0x84, 0x75, 0x5d, 0x99, 0xbd,
			0x3d, 0xf6, 0xa4, 0x6f, 0xc6, 0x7c, 0x4d, 0xb4,
			0x72, 0x8d, 0x03, 0x6c, 0x6d, 0x44, 0x08, 0x9c,
			0x12, 0xc0, 0x0e, 0x2b, 0x33, 0x0d, 0xcd, 0xf3,
			0x50, 0xff, 0xbc, 0xab, 0xa7, 0xdd, 0x82, 0x97,
			0xca, 0x1c, 0xef, 0xa6, 0x94, 0x6b, 0x3c, 0x3b,
		},
	},
	/* SHA1 [3] */
	{
		/* Msg3 : 128 byte */
		{
			0xd1, 0x4a, 0xae, 0x46, 0xa4, 0xc4, 0xa9, 0x61,
			0x71, 0x45, 0xad, 0xfc, 0xe6, 0x54, 0x78, 0xf1,
			0x47, 0xb2, 0x18, 0x24, 0xb6, 0x8e, 0x50, 0x5c,
			0xb1, 0xf8, 0x3d, 0x51, 0xdc, 0x98, 0x39, 0x06,
			0x01, 0xa0, 0x00, 0x58, 0x55, 0xff, 0x12, 0xd7,
			0xfd, 0xd8, 0x58, 0xd6, 0xd0, 0x32, 0x09, 0xbe,
			0x5f, 0xf1, 0xcf, 0xa8, 0x32, 0x05, 0x26, 0x2a,
			0x55, 0xe1, 0x05, 0x70, 0x14, 0x2e, 0xc1, 0x8f,
			0x02, 0xc1, 0x2e, 0x17, 0x40, 0xcb, 0x07, 0xe7,
			0xfb, 0x50, 0x90, 0x46, 0x37, 0xdb, 0x79, 0x2f,
			0xcb, 0x6f, 0x06, 0xeb, 0xad, 0xc0, 0x6d, 0xe6,
			0x70, 0xa3, 0x80, 0xbb, 0x0b, 0xc4, 0x8b, 0x91,
			0xdc, 0x97, 0x80, 0xaa, 0xed, 0x91, 0x51, 0x39,
			0x75, 0x97, 0x9e, 0x74, 0xa2, 0xb7, 0x90, 0xeb,
			0x95, 0x16, 0x05, 0x18, 0xaf, 0x29, 0xed, 0x37,
			0x0b, 0x28, 0xf3, 0x58, 0x4b, 0xc0, 0x61, 0xb2,
		},
		/* S3 : 192 byte */
		{
			0x15, 0x8c, 0x1a, 0x3c, 0x66, 0xdd, 0x1f, 0x18,
			0xae, 0xe5, 0x7f, 0x85, 0x7f, 0x69, 0x3f, 0x69,
			0xb7, 0xa4, 0x4c, 0xd4, 0x46, 0xfe, 0x75, 0x15,
			0x93, 0x97, 0x40, 0xde, 0xf8, 0xc9, 0x4a, 0xbf,
			0x1f, 0x80, 0x3d, 0x41, 0xb8, 0x38, 0x87, 0x19,
			0x08, 0xab, 0xf2, 0x71, 0xe1, 0x2a, 0xd7, 0xc0,
			0x73, 0x4f, 0x78, 0x9c, 0x44, 0x97, 0x78, 0x08,
			0x8a, 0x67, 0x98, 0x68, 0x38, 0x46, 0xfd, 0xda,
			0x83, 0x44, 0xde, 0x2c, 0x15, 0x65, 0xe1, 0x60,
			0xec, 0xa2, 0xbb, 0xa4, 0x76, 0xb4, 0xd5, 0x90,
			0x01, 0xb5, 0x06, 0xaf, 0xe5, 0xbc, 0x8b, 0x28,
			0xa3, 0x19, 0xa5, 0x90, 0x28, 0x98, 0xa6, 0x4d,
			0x0e, 0x23, 0xee, 0xfa, 0xbe, 0x32, 0x58, 0xbe,
			0x86, 0xd2, 0x99, 0x4d, 0x64, 0xb0, 0x25, 0x84,
			0xf0, 0xba, 0xc1, 0xa5, 0x2f, 0xed, 0x2d, 0xa6,
			0x33, 0x58, 0x99, 0xd2, 0x4e, 0xee, 0x2d, 0x02,
			0xb8, 0x4d, 0x68, 0xbf, 0xfc, 0x3d, 0xe9, 0xbc,
			0xcd, 0x2c, 0xe0, 0x23, 0x9f, 0x95, 0xf7, 0xaf,
			0xf0, 0x5c, 0x15, 0x49, 0x68, 0xff, 0x23, 0x22,
			0xec, 0x2d, 0x31, 0x51, 0xf1, 0x0f, 0x77, 0xe8,
			0x70, 0x44, 0x34, 0x35, 0xc1, 0x6d, 0x6c, 0xad,
			0xa0, 0x73, 0xd5, 0x97, 0x22, 0xaf, 0xf3, 0x92,
			0x92, 0x7d, 0xe2, 0x8d, 0xad, 0x31, 0x5c, 0xd0,
			0xa5, 0x10, 0x2b, 0x51, 0x47, 0xdc, 0xd8, 0x55,
		},
	},
	/* SHA1 [4] */
	{
		/* Msg4 : 128 byte */
		{
			0x88, 0x83, 0x6b, 0x5a, 0x0a, 0x32, 0x00, 0xf8,
			0x57, 0x16, 0x35, 0xf5, 0xd0, 0x99, 0x1e, 0x20,
			0xd8, 0x26, 0xcb, 0x5d, 0x93, 0xde, 0x28, 0xf8,
			0xed, 0x8d, 0x22, 0x39, 0xdf, 0xdc, 0x0b, 0x39,
			0xee, 0xc8, 0x40, 0xf3, 0xf4, 0x52, 0x09, 0x9e,
			0x22, 0x78, 0xc0, 0x3b, 0x46, 0x65, 0x36, 0x6a,
			0x4a, 0xe5, 0x52, 0x81, 0xfd, 0x1b, 0xfb, 0xdf,
			0x17, 0x76, 0x38, 0x7e, 0x77, 0xe1, 0x96, 0xc8,
			0xae, 0x3a, 0xcb, 0xac, 0xc1, 0x06, 0x98, 0xf0,
			0x2b, 0x63, 0xf4, 0xc9, 0x22, 0x3d, 0x66, 0xa9,
			0x1b, 0xc5, 0xb3, 0x58, 0x90, 0x1f, 0xb9, 0x46,
			0x01, 0x5b, 0x9b, 0x20, 0x39, 0xa7, 0x1e, 0xa1,
			0xd2, 0xc3, 0x53, 0xab, 0xfb, 0xb5, 0x77, 0x96,
			0x79, 0xbd, 0x17, 0xc8, 0xec, 0x8b, 0x77, 0x85,
			0x54, 0xb0, 0x35, 0x09, 0xd3, 0x53, 0x2a, 0xd4,
			0xb5, 0x25, 0x91, 0x46, 0xad, 0x97, 0x6b, 0x6b,
		},
		/* S4 : 192 byte */
		{
			0x1a, 0xf3, 0x0b, 0x76, 0x01, 0x79, 0x3c, 0x48,
			0x0e, 0x7a, 0xb8, 0x83, 0x3f, 0x2c, 0x02, 0x20,
			0x39, 0x2c, 0x8a, 0x96, 0x75, 0x06, 0xfd, 0x68,
			0xc8, 0x41, 0x67, 0x0c, 0xb6, 0x05, 0x13, 0xb0,
			0x1e, 0x11, 0x94, 0x29, 0xa1, 0x11, 0xd7, 0x02,
			0xa9, 0x0f, 0x46, 0x47, 0x82, 0x55, 0xd0, 0x09,
			0x5b, 0xf1, 0x91, 0xf7, 0x66, 0x65, 0xb4, 0xea,
			0xfa, 0xf2, 0xef, 0xff, 0xd2, 0x1b, 0x0d, 0xd3,
			0x6d, 0x0f, 0x0f, 0xe7, 0xa1, 0xd8, 0xb2, 0xab,
			0xb9, 0x92, 0x5b, 0xe6, 0x3a, 0x0d, 0x30, 0xcc,
			0xc5, 0xb9, 0x3e, 0x1c, 0x8c, 0xf6, 0x4b, 0xb1,
			0x5b, 0x33, 0x57, 0x1b, 0x4a, 0xf0, 0x4f, 0x75,
			0x1e, 0x79, 0x65, 0x0e, 0x52, 0x57, 0x23, 0xeb,
			0x7f, 0x6d, 0x24, 0xf2, 0xe5, 0x74, 0xe9, 0x91,
			0xa4, 0x05, 0x82, 0xe2, 0x4e, 0xf6, 0x2a, 0x6a,
			0xe8, 0x7a, 0x86, 0x0b, 0x49, 0x10, 0xaa, 0x5f,
			0xd5, 0x65, 0x51, 0xca, 0xaf, 0x7b, 0x5c, 0x95,
			0x25, 0xba, 0x1d, 0x00, 0x37, 0x0e, 0x7f, 0xd3,
			0x4d, 0xfc, 0xd2, 0xc5, 0x0b, 0xee, 0xf9, 0x0b,
			0xe5, 0x60, 0x6b, 0x0e, 0xee, 0x7a, 0x6f, 0xe3,
			0xc9, 0x29, 0xda, 0x9f, 0x8a, 0x7d, 0xd1, 0x33,
			0x74, 0x54, 0x75, 0x8a, 0x4a, 0x70, 0xd1, 0x04,
			0x51, 0x01, 0xd2, 0x57, 0x39, 0x50, 0x30, 0x9d,
			0x4e, 0xb1, 0x15, 0xe8, 0xa0, 0x86, 0xff, 0x21,
		},
	},
	/* SHA1 [5] */
	{
		/* Msg5 : 128 byte */
		{
			0xfd, 0x31, 0xe8, 0x3f, 0x7a, 0xf7, 0x27, 0x13,
			0x8a, 0x63, 0x4e, 0x96, 0x50, 0x5c, 0xbc, 0x80,
			0x3b, 0xe9, 0x6b, 0xb0, 0x36, 0x97, 0xc5, 0xb7,
			0x1f, 0x1c, 0xb9, 0x9a, 0x7b, 0x39, 0x0d, 0xd4,
			0x68, 0xe5, 0xf6, 0x9b, 0xd2, 0xa7, 0xe6, 0x64,
			0xea, 0x44, 0xa5, 0xa9, 0xd4, 0x9a, 0xa3, 0xea,
			0xa0, 0xcc, 0x8d, 0xf2, 0x7c, 0x9f, 0x1e, 0x5b,
			0x28, 0x24, 0x38, 0x54, 0xaa, 0x98, 0x33, 0xa2,
			0x42, 0x88, 0x75, 0xe5, 0xa0, 0x38, 0x42, 0x1d,
			0x55, 0x46, 0xd6, 0x6c, 0x88, 0x8b, 0xb1, 0x1e,
			0xea, 0x42, 0x33, 0xe6, 0xec, 0x6c, 0x68, 0x6a,
			0x2f, 0x73, 0x25, 0x02, 0x3b, 0x0d, 0x54, 0xbd,
			0x75, 0x63, 0x8c, 0xa6, 0x4b, 0x73, 0xe5, 0x45,
			0xb2, 0xb2, 0x0a, 0x68, 0xd2, 0xf6, 0x8f, 0x23,
			0xff, 0x94, 0x85, 0x15, 0xec, 0xc5, 0x4c, 0xed,
			0x1b, 0x4f, 0xa9, 0x2d, 0x98, 0x61, 0x18, 0x2e,
		},
		/* S5 : 192 byte */
		{
			0x9b, 0x99, 0xa6, 0xe4, 0x3c, 0x58, 0xb8, 0x33,
			0x6d, 0x35, 0x77, 0x06, 0xc0, 0xbc, 0xf8, 0xb6,
			0xaa, 0x65, 0xc9, 0xb1, 0xd8, 0x06, 0xf9, 0x32,
			0x97, 0xaa, 0x08, 0x11, 0xb0, 0x53, 0x56, 0x32,
			0xfd, 0xb5, 0x44, 0x08, 0x62, 0x11, 0xa8, 0x30,
			0x40, 0xe5, 0xdb, 0x9f, 0x8b, 0x75, 0x27, 0x00,
			0x44, 0xd8, 0xaa, 0x6d, 0xd6, 0x83, 0x73, 0xc6,
			0x84, 0x8d, 0x5b, 0xad, 0x3a, 0xc7, 0xc6, 0xdb,
			0xe0, 0x0b, 0x62, 0xf1, 0xbe, 0x81, 0x88, 0xb2,
			0xd1, 0x07, 0xb6, 0x37, 0x53, 0x7e, 0x76, 0xa9,
			0x16, 0x6e, 0x9f, 0x1c, 0xdd, 0x27, 0xc6, 0xf0,
			0xbd, 0x91, 0x9e, 0xf1, 0x2a, 0xe2, 0xb3, 0x6a,
			0x8f, 0x9a, 0xc5, 0x5e, 0xec, 0x95, 0x0d, 0x2d,
			0xe8, 0x19, 0xdb, 0x68, 0x9e, 0xd6, 0xcc, 0x62,
			0x4e, 0x85, 0x0f, 0xfd, 0xcf, 0xc2, 0x81, 0x1a,
			0x59, 0xce, 0x75, 0xc2, 0x7b, 0xa1, 0x17, 0x8e,
			0xbb, 0x28, 0x67, 0xa3, 0xa0, 0xd8, 0x25, 0x46,
			0xb4, 0x84, 0x13, 0x50, 0xbd, 0x75, 0x81, 0x77,
			0xf0, 0x86, 0x36, 0xde, 0x24, 0xd0, 0x53, 0xac,
			0x3c, 0xbb, 0x24, 0x97, 0x93, 0x20, 0x3b, 0xe6,
			0x5d, 0xfb, 0x49, 0xce, 0x4c, 0xc5, 0x4a, 0xe9,
			0x72, 0xca, 0xc7, 0x7f, 0xad, 0x72, 0x58, 0x28,
			0x85, 0x3e, 0xd5, 0xf3, 0x9a, 0x89, 0x8e, 0xcf,
			0x2b, 0x48, 0x28, 0xc2, 0xb0, 0x97, 0x07, 0xee,
		},
	},
	/* SHA1 [6] */
	{
		/* Msg6 : 128 byte */
		{
			0xf1, 0x5c, 0xb6, 0xc5, 0x70, 0x5a, 0x8d, 0x0e,
			0x6f, 0x10, 0x92, 0xcd, 0x09, 0xff, 0xd1, 0x2e,
			0xc8, 0x57, 0x48, 0x88, 0xbb, 0xbd, 0x9c, 0x3e,
			0xc8, 0x4b, 0x0b, 0xe3, 0x44, 0xd8, 0xa2, 0xa1,
			0xc1, 0x7a, 0xb0, 0xdb, 0x27, 0x4a, 0x7a, 0x11,
			0x07, 0x67, 0x30, 0x04, 0x2b, 0x3e, 0x20, 0x1b,
			0x72, 0x08, 0x2a, 0x06, 0xdb, 0x93, 0x74, 0xa1,
			0xdf, 0x46, 0x5f, 0x1b, 0x04, 0x60, 0xb9, 0x57,
			0xaf, 0x80, 0x34, 0x92, 0x39, 0x6a, 0x16, 0x47,
			0x46, 0x08, 0x33, 0x4f, 0x52, 0xaf, 0x18, 0x4d,
			0x8d, 0xa4, 0x8a, 0x49, 0xe9, 0xdf, 0x2f, 0x9b,
			0x71, 0x0e, 0x8a, 0x0b, 0xdc, 0xdd, 0x2d, 0x36,
			0x62, 0x75, 0x29, 0x34, 0xce, 0x42, 0xca, 0x77,
			0xd5, 0xfa, 0x81, 0xf6, 0xa6, 0xdb, 0x22, 0x8b,
			0xc2, 0x34, 0x4f, 0x9a, 0x0e, 0x26, 0x34, 0xf4,
			0x26, 0xac, 0x76, 0xfb, 0xf5, 0xd9, 0x65, 0x06,
		},
		/* S6 : 192 byte */
		{
			0x86, 0xc9, 0x99, 0x8e, 0xbe, 0xf6, 0x34, 0xc2,
			0x42, 0x05, 0x30, 0x66, 0x08, 0xa5, 0x0e, 0xaf,
			0x00, 0x78, 0xea, 0xe3, 0xdf, 0x06, 0x62, 0xc9,
			0x89, 0x7b, 0x28, 0x93, 0x33, 0x35, 0x99, 0xc5,
			0xb0, 0x18, 0x5a, 0x86, 0xa2, 0x1a, 0xfc, 0x93,
			0x2c, 0xf6, 0x6b, 0x8f, 0x7f, 0xea, 0x28, 0x71,
			0x95, 0x48, 0x09, 0x5b, 0x2c, 0x76, 0xf1, 0x2a,
			0xb9, 0x24, 0x51, 0x84, 0x2e, 0x5f, 0x5a, 0xfc,
			0x32, 0x66, 0x63, 0x64, 0xb5, 0xec, 0x0a, 0x97,
			0x4b, 0xeb, 0xbf, 0x1a, 0x1e, 0xf8, 0x65, 0x5a,
			0x5a, 0xb1, 0x50, 0x02, 0x3c, 0x35, 0x5c, 0x3b,
			0x6a, 0xec, 0xfd, 0x99, 0x5f, 0xbe, 0xfd, 0x65,
			0x71, 0x96, 0xe5, 0x6c, 0x6e, 0x35, 0x4d, 0xf9,
			0x18, 0x0e, 0xa6, 0x73, 0xa4, 0x77, 0x89, 0x18,
			0x8c, 0x71, 0xee, 0xaa, 0x04, 0xa3, 0x91, 0x22,
			0x6d, 0x64, 0x1b, 0xe6, 0x2a, 0x08, 0x79, 0x9c,
			0xbe, 0x86, 0xc5, 0xcb, 0x3a, 0x61, 0x84, 0xe6,
			0x9d, 0x1d, 0x97, 0xc8, 0xde, 0x1d, 0xfa, 0xa0,
			0x7c, 0x5a, 0x1d, 0x22, 0x4e, 0x26, 0xc3, 0xb0,
			0xb5, 0xcd, 0x2d, 0x22, 0x77, 0x27, 0x1a, 0x45,
			0xff, 0x38, 0x20, 0x1c, 0x3c, 0xad, 0x98, 0xc7,
			0xee, 0x89, 0x15, 0x1e, 0xb2, 0xf2, 0x78, 0x01,
			0xce, 0x4e, 0x9a, 0xdb, 0x9a, 0xb0, 0x7b, 0x24,
			0x99, 0x9d, 0xa4, 0x23, 0x17, 0x4d, 0x45, 0x75,
		},
	},
	/* SHA1 [7] */
	{
		/* Msg7 : 128 byte */
		{
			0xad, 0x35, 0x42, 0x18, 0xcf, 0x73, 0xe0, 0x7d,
			0x26, 0x19, 0x29, 0x33, 0x9a, 0x45, 0x56, 0xda,
			0x53, 0x45, 0x09, 0xe3, 0x17, 0xa3, 0x3b, 0xad,
			0xd3, 0x5e, 0x76, 0xee, 0x77, 0x7b, 0x45, 0x55,
			0x07, 0xbc, 0xea, 0x6e, 0xef, 0xb0, 0x4e, 0xc5,
			0x98, 0xec, 0x3e, 0x4e, 0x38, 0x97, 0xd3, 0x04,
			0xee, 0x2c, 0x32, 0xd1, 0x0e, 0x7b, 0x76, 0xae,
			0xba, 0xf1, 0xeb, 0x0b, 0xb2, 0x1a, 0x7d, 0x71,
			0x6c, 0x64, 0x70, 0x66, 0x68, 0x26, 0x51, 0x91,
			0xbe, 0xe0, 0x2c, 0x1e, 0xf9, 0xc5, 0xff, 0x64,
			0x27, 0x76, 0x6f, 0xc5, 0x31, 0x11, 0xba, 0xd6,
			0x69, 0x6a, 0xed, 0xc0, 0x62, 0x98, 0x57, 0xe7,
			0x04, 0xb4, 0x3d, 0xc9, 0xdf, 0xdd, 0xcf, 0x28,
			0xc0, 0x7f, 0x5b, 0x6b, 0x82, 0xd5, 0xc1, 0x42,
			0x27, 0xad, 0x27, 0x89, 0x28, 0x6c, 0xed, 0x6f,
			0x08, 0x51, 0xe3, 0xd7, 0x2f, 0xfe, 0xba, 0xfe,
		},
		/* S7 : 192 byte */
		{
			0x72, 0xd7, 0xba, 0x63, 0xe6, 0xb4, 0x2d, 0xe1,
			0x49, 0x41, 0x3f, 0x08, 0xc7, 0xd4, 0x9b, 0x5c,
			0xe5, 0x2c, 0x52, 0x44, 0x7a, 0x31, 0xce, 0xd6,
			0xc8, 0x76, 0x6c, 0xf5, 0xa2, 0xb8, 0x89, 0xee,
			0x82, 0x64, 0x64, 0x59, 0x10, 0x36, 0xe9, 0x92,
			0x20, 0x7b, 0xf0, 0xed, 0x09, 0x12, 0xfa, 0xb8,
			0x26, 0x3f, 0x9a, 0x27, 0x27, 0xb6, 0x6b, 0xa2,
			0x82, 0x26, 0xdf, 0x52, 0x6f, 0x36, 0x9e, 0x67,
			0x47, 0x99, 0x5b, 0x9d, 0xeb, 0x46, 0xae, 0x12,
			0x00, 0xb3, 0x49, 0xe4, 0xb0, 0x90, 0xa6, 0x24,
			0x58, 0xe0, 0x3e, 0x43, 0x2d, 0x4e, 0xa1, 0xab,
			0xde, 0x5f, 0x68, 0x39, 0xa9, 0x47, 0x76, 0xfd,
			0x73, 0x11, 0x09, 0x4a, 0x20, 0x9c, 0xcf, 0x2d,
			0x28, 0x4f, 0xf9, 0x54, 0x21, 0x93, 0x06, 0x27,
			0xd6, 0xf4, 0xa3, 0xb5, 0xbf, 0xe2, 0xde, 0xb7,
			0x42, 0x5c, 0xeb, 0x4a, 0x3e, 0xfe, 0x8e, 0x82,
			0xa1, 0x84, 0xd1, 0x37, 0xcd, 0x0a, 0x8d, 0xb2,
			0x2d, 0x12, 0xf2, 0x62, 0x1e, 0x1b, 0x33, 0xe0,
			0xc1, 0x3f, 0x46, 0xd8, 0x5c, 0x4f, 0x3f, 0xc8,
			0xa9, 0x13, 0x8a, 0x69, 0xb1, 0xa9, 0xf1, 0x37,
			0x94, 0x7f, 0xa6, 0x89, 0x15, 0xae, 0x3c, 0xeb,
			0x84, 0x2f, 0xd5, 0x46, 0x15, 0xec, 0x1e, 0x02,
			0x24, 0x06, 0x9f, 0xdf, 0x94, 0x43, 0xb2, 0x24,
			0x74, 0x4c, 0x31, 0xed, 0x1f, 0xdc, 0x9b, 0x1b,
		},
	},
	/* SHA1 [8] */
	{
		/* Msg8 : 128 byte */
		{
			0x89, 0xde, 0x25, 0x2d, 0x69, 0xeb, 0x32, 0xa9,
			0x4b, 0x80, 0xff, 0xdc, 0x2b, 0xbb, 0x04, 0xe8,
			0xf0, 0xf0, 0x15, 0xe9, 0x96, 0x41, 0x9c, 0x2b,
			0x8c, 0x6e, 0x26, 0x9a, 0x5b, 0xee, 0x21, 0x79,
			0x89, 0x3e, 0xe3, 0x57, 0xbd, 0x79, 0xef, 0x3f,
			0x23, 0x29, 0x74, 0x30, 0x12, 0x5c, 0x17, 0xcc,
			0xed, 0xfb, 0xf2, 0x54, 0x47, 0x58, 0xdd, 0xd4,
			0x4a, 0x06, 0xec, 0x9b, 0x59, 0xed, 0x39, 0xee,
			0xf4, 0x9d, 0xe3, 0xfe, 0xdc, 0xe3, 0x56, 0x17,
			0x78, 0x9a, 0xcd, 0x19, 0x78, 0xc4, 0x16, 0x2c,
			0xb8, 0xda, 0x95, 0xb0, 0x67, 0x60, 0x8c, 0x73,
			0x68, 0xbb, 0x9a, 0x27, 0xf8, 0x47, 0x81, 0x13,
			0x92, 0xa5, 0x2c, 0x08, 0x0f, 0x52, 0xf0, 0x97,
			0x12, 0x7e, 0x12, 0x81, 0xa3, 0x1b, 0x89, 0x6f,
			0x1a, 0x34, 0x06, 0xe3, 0x3f, 0x80, 0x32, 0x6f,
			0xaf, 0x37, 0x36, 0x25, 0x82, 0x24, 0x81, 0x4e,
		},
		/* S8 : 192 byte */
		{
			0x78, 0x4f, 0x31, 0x89, 0x0d, 0x7d, 0xa1, 0x37,
			0xba, 0x05, 0xeb, 0xc0, 0xd0, 0x92, 0xe8, 0x6e,
			0xd6, 0xb4, 0x0a, 0x96, 0xa0, 0xd2, 0x42, 0x64,
			0xf0, 0xa5, 0xca, 0x6a, 0x8d, 0x86, 0x31, 0x45,
			0xac, 0xfc, 0xdf, 0xad, 0x09, 0x9e, 0x0c, 0xa5,
			0x23, 0xe0, 0x08, 0xbb, 0xff, 0xbc, 0xeb, 0x8a,
			0xba, 0xe2, 0x60, 0x46, 0x93, 0x7e, 0x79, 0x6e,
			0x0e, 0x73, 0xb4, 0xcc, 0xaa, 0x07, 0xd9, 0xda,
			0x31, 0x7f, 0x19, 0x23, 0x91, 0x2b, 0x23, 0x80,
			0xa0, 0x96, 0x6c, 0x34, 0x7f, 0x94, 0x2e, 0xb4,
			0x12, 0xe4, 0x10, 0x37, 0x00, 0x97, 0x5c, 0x9b,
			0x37, 0x05, 0x12, 0x0b, 0x9f, 0xac, 0x11, 0x30,
			0x5f, 0x29, 0xd5, 0x14, 0x95, 0x5d, 0x40, 0xb7,
			0xc9, 0x4b, 0xde, 0x53, 0x7b, 0xf9, 0xe6, 0x96,
			0x3a, 0x74, 0xa7, 0x77, 0x0a, 0xe3, 0x53, 0x26,
			0x5e, 0x9f, 0x72, 0x61, 0x4e, 0xaf, 0xa4, 0xdf,
			0x3f, 0xf9, 0x12, 0x23, 0xc2, 0x7e, 0x83, 0x70,
			0x9c, 0x15, 0xec, 0x42, 0x5f, 0xe8, 0x97, 0xf6,
			0x22, 0x0c, 0x21, 0xb6, 0x12, 0x7a, 0xb9, 0xcc,
			0x88, 0x70, 0xbd, 0x9a, 0xae, 0xa9, 0xae, 0x00,
			0x1b, 0x64, 0x22, 0xb7, 0xd6, 0x14, 0x08, 0x99,
			0xf2, 0xc5, 0xef, 0x6e, 0x08, 0xc8, 0x3e, 0xd3,
			0xd6, 0x2b, 0x0b, 0x4c, 0x31, 0x0d, 0x2b, 0xdf,
			0x6f, 0x9a, 0xb0, 0x16, 0x8b, 0xb2, 0x4d, 0xd0,
		},
	},
	/* SHA1 [9] */
	{
		/* Msg9 : 128 byte */
		{
			0x14, 0x58, 0x1f, 0xc3, 0xd8, 0xc6, 0xea, 0x6a,
			0x14, 0xc9, 0xfb, 0x21, 0x6c, 0x86, 0xbb, 0x41,
			0x2d, 0x21, 0x87, 0x44, 0x34, 0x1b, 0xb0, 0xc2,
			0x0c, 0xdf, 0xc6, 0xa0, 0x56, 0x97, 0x16, 0x84,
			0x6e, 0x44, 0x71, 0x8b, 0x4b, 0x0e, 0x2f, 0x3f,
			0xa7, 0xd8, 0x74, 0xc3, 0x60, 0x18, 0xb2, 0x51,
			0x1f, 0xe6, 0x6f, 0xe7, 0x37, 0x53, 0x49, 0x3c,
			0xd0, 0xfb, 0x37, 0xf9, 0x44, 0xde, 0x11, 0x26,
			0xc9, 0x6b, 0x53, 0xe2, 0x51, 0xde, 0x1e, 0x58,
			0xae, 0xcc, 0x7f, 0xee, 0xfa, 0xfc, 0xf4, 0xbf,
			0x36, 0x79, 0x2c, 0x4c, 0x31, 0xe5, 0x0f, 0x6e,
			0xab, 0x10, 0xfe, 0x90, 0xbb, 0xca, 0x5c, 0x1a,
			0x6e, 0xf5, 0x4d, 0x30, 0xb1, 0xde, 0xbd, 0x9d,
			0x71, 0xcd, 0xa5, 0x0a, 0x00, 0xda, 0x89, 0x74,
			0xbb, 0x03, 0x46, 0xdd, 0xea, 0x7c, 0x0a, 0x41,
			0xe7, 0x46, 0xa4, 0xcb, 0x83, 0x03, 0xfe, 0x49,
		},
		/* S9 : 192 byte */
		{
			0x3a, 0xa8, 0xc0, 0xa8, 0x14, 0xb9, 0xc7, 0x92,
			0x5f, 0x52, 0xf7, 0xe7, 0x1b, 0xef, 0x18, 0x0f,
			0xfe, 0x91, 0xed, 0xfa, 0x68, 0xec, 0x99, 0x57,
			0x10, 0x2a, 0xb9, 0x4e, 0x51, 0xd7, 0xc3, 0xa0,
			0x7d, 0xbb, 0x69, 0xde, 0x14, 0x3c, 0x89, 0x99,
			0x8e, 0x21, 0x83, 0xd9, 0x35, 0xdb, 0x37, 0xbc,
			0xf7, 0x2f, 0xed, 0x63, 0x61, 0x96, 0xd7, 0x49,
			0x97, 0x72, 0x28, 0xb6, 0x13, 0xd4, 0x04, 0x3b,
			0xb5, 0xcf, 0x59, 0x01, 0x19, 0x81, 0xa1, 0xe8,
			0xbd, 0xaa, 0xb5, 0xe3, 0xa2, 0xdd, 0x46, 0xe6,
			0x93, 0x2a, 0x5f, 0x78, 0xae, 0x41, 0x91, 0xe0,
			0x32, 0xb3, 0xe1, 0x1e, 0x58, 0x26, 0xad, 0x13,
			0xfe, 0xc0, 0x5a, 0xd9, 0x82, 0xf4, 0x5d, 0x16,
			0x52, 0xe1, 0x96, 0x0d, 0x77, 0xad, 0x27, 0xbf,
			0x9c, 0x46, 0x91, 0x42, 0x79, 0x0f, 0x64, 0xef,
			0x95, 0xd2, 0x08, 0x8c, 0x0a, 0xcf, 0xc7, 0xbb,
			0x3f, 0xd3, 0x40, 0x98, 0x35, 0x9e, 0x11, 0xa8,
			0x90, 0xcd, 0x8f, 0xf5, 0x08, 0x4c, 0x7e, 0x04,
			0x26, 0xe4, 0xc0, 0x99, 0xf4, 0x1c, 0xe9, 0xb2,
			0xf5, 0x09, 0x94, 0x0c, 0x81, 0xd9, 0xab, 0xcf,
			0x56, 0xaa, 0x14, 0x4b, 0x88, 0xbf, 0x87, 0x5d,
			0x92, 0xb8, 0xcc, 0xda, 0x73, 0x19, 0x25, 0xb0,
			0x2f, 0xc7, 0x67, 0x75, 0xc5, 0xf4, 0x1c, 0x55,
			0x72, 0x95, 0xe9, 0x3e, 0x13, 0x90, 0x79, 0x2e,
		},
	},
};

/* 10 elements */
static mod1536_t SHA224[] = {
	/* SHA224 [0] */
	{
		/* Msg0 : 128 byte */
		{
			0xf4, 0x46, 0x1d, 0x25, 0x95, 0x1e, 0xa6, 0x96,
			0x5b, 0xbe, 0x2b, 0x16, 0xf1, 0xf9, 0xc7, 0xa2,
			0x71, 0x4e, 0x87, 0x5f, 0x7a, 0xb1, 0x22, 0x81,
			0x83, 0x8f, 0xe4, 0x6b, 0x6f, 0x0c, 0xec, 0x17,
			0x61, 0x8f, 0x97, 0xb9, 0xd1, 0x80, 0x3c, 0x9f,
			0xe0, 0x50, 0x1a, 0x5c, 0xe8, 0xba, 0x8e, 0x25,
			0x58, 0x49, 0x8a, 0x7b, 0xbf, 0x1b, 0x42, 0x0b,
			0x26, 0xe4, 0x28, 0xd2, 0xa3, 0x35, 0x1b, 0x84,
			0x2b, 0xff, 0xdb, 0x2f, 0xa8, 0x53, 0xc1, 0x1b,
			0x4b, 0x6b, 0xad, 0xf6, 0x24, 0xee, 0x3f, 0x2d,
			0xf0, 0x70, 0x4a, 0x9d, 0x32, 0x38, 0x85, 0x6b,
			0x85, 0x47, 0x84, 0x30, 0x30, 0x96, 0xe7, 0x5a,
			0xfb, 0x9e, 0xd2, 0xcf, 0x41, 0x1d, 0x9d, 0xd3,
			0x47, 0x18, 0xcc, 0x2b, 0xcc, 0x1c, 0x41, 0x82,
			0xe1, 0xca, 0xb0, 0x0d, 0xfb, 0x93, 0x54, 0x6b,
			0x47, 0xbf, 0xe0, 0xcf, 0x3d, 0xb4, 0xb9, 0x60,
		},
		/* S0 : 192 byte */
		{
			0x77, 0x72, 0x12, 0x98, 0x48, 0xc4, 0x96, 0x79,
			0x06, 0xda, 0x15, 0xa7, 0xb0, 0x04, 0x4f, 0x07,
			0xf1, 0x50, 0x65, 0x5e, 0x13, 0x39, 0x83, 0x11,
			0x38, 0x51, 0xcf, 0x4d, 0x3c, 0xf5, 0xf0, 0x25,
			0x9b, 0x67, 0x98, 0x8d, 0x38, 0x19, 0xa5, 0x14,
			0x75, 0x06, 0x79, 0x29, 0xe1, 0x46, 0xf0, 0xc3,
			0x1b, 0x3c, 0xa5, 0x5b, 0x82, 0x71, 0x5e, 0x6d,
			0x18, 0xc0, 0x6c, 0x78, 0xe1, 0x3a, 0xeb, 0xcd,
			0x3c, 0x1b, 0xe5, 0xe9, 0xf4, 0x28, 0xf3, 0xaa,
			0xe7, 0x62, 0x6c, 0x9b, 0x81, 0x88, 0x1e, 0x55,
			0x91, 0x12, 0xe0, 0xe4, 0xa4, 0x08, 0x4a, 0x33,
			0x67, 0xee, 0x28, 0x5b, 0xed, 0x91, 0x55, 0x17,
			0x9b, 0x1e, 0xae, 0xf0, 0x32, 0xaa, 0x2e, 0x01,
			0xe7, 0x96, 0x24, 0xb8, 0x08, 0xad, 0xbf, 0x24,
			0x8f, 0x71, 0x67, 0x34, 0x58, 0xa5, 0xa4, 0x4e,
			0xed, 0xb5, 0x81, 0x6b, 0xc3, 0xd1, 0x2e, 0x5d,
			0x3c, 0xb6, 0xbd, 0xc1, 0xf7, 0xf7, 0xfe, 0xa8,
			0xc8, 0xa9, 0xd0, 0x77, 0xdb, 0x88, 0x96, 0xed,
			0x51, 0xa3, 0x42, 0xa6, 0x7e, 0x52, 0x00, 0x70,
			0x1a, 0xcb, 0x7a, 0xac, 0x81, 0xf7, 0xde, 0x33,
			0xd4, 0x23, 0x4b, 0x88, 0x14, 0x4f, 0xb0, 0xda,
			0xc3, 0xe8, 0xa3, 0x57, 0xb2, 0xfa, 0x55, 0xe1,
			0x1e, 0x70, 0x17, 0x10, 0x19, 0xc0, 0x66, 0x13,
			0x44, 0xb7, 0x2f, 0x93, 0xd7, 0x3b, 0xdb, 0xbd,
		},
	},
	/* SHA224 [1] */
	{
		/* Msg1 : 128 byte */
		{
			0x46, 0x0a, 0x92, 0xb1, 0x9b, 0xb8, 0xc0, 0xbd,
			0xf6, 0x6a, 0xa4, 0x65, 0x47, 0xdf, 0x51, 0x7e,
			0xdd, 0xb7, 0x33, 0xd2, 0x2d, 0x2a, 0xf7, 0x72,
			0xcf, 0xfa, 0xa5, 0x4e, 0xc9, 0xa6, 0x0f, 0x02,
			0x10, 0xe1, 0x6f, 0xf3, 0x4c, 0x42, 0x4c, 0x9b,
			0xdc, 0x3d, 0x9d, 0x21, 0x1a, 0x52, 0x31, 0x2d,
			0xe0, 0x84, 0x4e, 0xfa, 0x4b, 0x0d, 0x99, 0xad,
			0xbe, 0x50, 0x35, 0xe5, 0x2a, 0x0f, 0x2f, 0x93,
			0x8d, 0xde, 0x1a, 0x0c, 0xb9, 0xd8, 0xf6, 0x5c,
			0x57, 0x90, 0x57, 0xdd, 0x2b, 0x4b, 0xc3, 0x09,
			0x9a, 0x6c, 0x5b, 0x8d, 0x69, 0x2f, 0xbd, 0x9e,
			0xc7, 0x9a, 0x2a, 0x90, 0x8e, 0xb1, 0xe4, 0xa5,
			0xc6, 0xea, 0xda, 0x23, 0x6b, 0xe0, 0x87, 0xa9,
			0x6f, 0x4b, 0x18, 0xc2, 0x03, 0x30, 0xcd, 0xbb,
			0x13, 0x55, 0xa1, 0xb2, 0x0f, 0xf8, 0x2d, 0xf0,
			0xf1, 0xc0, 0xca, 0x79, 0x7c, 0xf4, 0xf6, 0xe0,
		},
		/* S1 : 192 byte */
		{
			0x31, 0xa6, 0x01, 0x96, 0xe3, 0xa4, 0x66, 0x8d,
			0x34, 0xa5, 0x88, 0xe4, 0x50, 0x42, 0xee, 0xc5,
			0x90, 0x10, 0x53, 0x37, 0xf3, 0x2f, 0xab, 0x96,
			0x66, 0x31, 0xc1, 0xbe, 0xda, 0x84, 0xf1, 0xaa,
			0x34, 0x39, 0xee, 0x87, 0xd3, 0xa2, 0x37, 0xe7,
			0xe2, 0xc4, 0x56, 0xdd, 0xa4, 0x81, 0x99, 0xaf,
			0xc0, 0x10, 0x7e, 0x66, 0xcc, 0xb7, 0xc4, 0x09,
			0xa8, 0x48, 0xb9, 0xec, 0x39, 0x49, 0xbe, 0x87,
			0xd3, 0xfe, 0xf9, 0x2d, 0x0d, 0xa5, 0xec, 0xb0,
			0x49, 0x24, 0x57, 0xb2, 0x1d, 0x59, 0x8c, 0xd1,
			0xc2, 0xdb, 0x6a, 0x04, 0x19, 0xda, 0xcb, 0x7e,
			0xee, 0x38, 0x4c, 0x85, 0xea, 0xfc, 0xc9, 0xf2,
			0x8e, 0x04, 0xbf, 0x18, 0xc1, 0x9b, 0xfb, 0xaf,
			0xb6, 0xfe, 0xc7, 0xa5, 0xc3, 0xc3, 0xb5, 0x57,
			0x87, 0x28, 0x95, 0x22, 0x36, 0x20, 0x78, 0x58,
			0x93, 0xd9, 0xd2, 0x53, 0x3c, 0x76, 0x9b, 0xa4,
			0xcd, 0x36, 0x34, 0x7b, 0x87, 0x01, 0xab, 0x59,
			0x9d, 0xa6, 0xf4, 0x32, 0x25, 0x32, 0xc7, 0x0f,
			0x77, 0xfa, 0x01, 0xb8, 0x0f, 0x22, 0x01, 0xc8,
			0x36, 0xb0, 0x67, 0xef, 0x4c, 0x8f, 0x76, 0x6c,
			0x5e, 0xb1, 0x2c, 0x57, 0xcc, 0x30, 0xd4, 0xaf,
			0xce, 0x8b, 0xed, 0x30, 0x73, 0x4a, 0x1b, 0x02,
			0x8d, 0xb9, 0xd2, 0x6d, 0xe5, 0x29, 0xb3, 0x99,
			0xbd, 0xf4, 0xba, 0xf2, 0x2e, 0x07, 0x8d, 0xf9,
		},
	},
	/* SHA224 [2] */
	{
		/* Msg2 : 128 byte */
		{
			0xb1, 0x2c, 0x24, 0xb0, 0xa3, 0x3a, 0x8f, 0xf0,
			0xa1, 0x41, 0xbb, 0xf1, 0x4f, 0x65, 0x03, 0x31,
			0x80, 0x3c, 0x7f, 0xfd, 0x9e, 0x99, 0x83, 0xe5,
			0x4d, 0xa2, 0x69, 0x6c, 0x4b, 0x29, 0x91, 0x04,
			0x9a, 0x39, 0xa5, 0x39, 0xe2, 0xee, 0x22, 0x2c,
			0x11, 0x8a, 0x14, 0x43, 0x44, 0xc6, 0x21, 0x1f,
			0xea, 0x66, 0xc8, 0xce, 0x26, 0x10, 0xeb, 0x42,
			0x76, 0x5e, 0x8b, 0x02, 0x93, 0x32, 0xd4, 0x20,
			0x98, 0x4a, 0x59, 0x6b, 0x65, 0x14, 0xa0, 0xe5,
			0x46, 0xc3, 0xe1, 0x78, 0xd0, 0xa2, 0x0b, 0xe4,
			0x0c, 0xa8, 0x08, 0xfc, 0xd8, 0x4d, 0x42, 0x12,
			0x89, 0x9d, 0x66, 0xb0, 0xd5, 0x8b, 0x68, 0x89,
			0xf1, 0x87, 0xc7, 0xae, 0xf6, 0x53, 0x12, 0x05,
			0x89, 0x12, 0xab, 0xf8, 0xbb, 0xa2, 0xcb, 0x6a,
			0x2e, 0x2b, 0xc6, 0xef, 0x7a, 0xf8, 0x90, 0x3c,
			0xce, 0x86, 0x80, 0xdc, 0xdb, 0xdb, 0x55, 0x25,
		},
		/* S2 : 192 byte */
		{
			0x52, 0xd0, 0x7e, 0xb7, 0x34, 0xff, 0x31, 0x91,
			0xae, 0x02, 0x39, 0xe0, 0x93, 0x83, 0x49, 0xb0,
			0x24, 0x9e, 0xd4, 0xde, 0x2a, 0xad, 0x93, 0xaa,
			0x26, 0xbd, 0x06, 0x5d, 0x1f, 0xd6, 0x93, 0x2f,
			0x7d, 0xa6, 0x89, 0x52, 0x99, 0x29, 0xb0, 0x2b,
			0x32, 0x9f, 0xe2, 0xf5, 0xef, 0x72, 0x98, 0x18,
			0x93, 0x27, 0x63, 0x62, 0x00, 0xc7, 0xea, 0xf2,
			0x7a, 0xef, 0xd6, 0x91, 0x6f, 0x59, 0x72, 0x34,
			0x32, 0x2a, 0x25, 0x5e, 0x08, 0x6a, 0x77, 0x2b,
			0x7b, 0x26, 0xe2, 0x69, 0x28, 0x4d, 0x42, 0x05,
			0xaf, 0x6b, 0x90, 0xbd, 0xff, 0x0a, 0xe9, 0x40,
			0x13, 0x8a, 0xbe, 0xd6, 0x8f, 0xa4, 0xbc, 0xe2,
			0x17, 0xd3, 0x85, 0x05, 0x95, 0x77, 0x38, 0x4f,
			0xb0, 0x09, 0xb1, 0x1e, 0x19, 0x5e, 0x35, 0x5e,
			0xc2, 0x5b, 0x81, 0xd1, 0xb8, 0x49, 0x6f, 0x64,
			0x43, 0xb4, 0xf8, 0xdc, 0x26, 0xed, 0xd9, 0x5b,
			0x99, 0xec, 0x3e, 0x2a, 0xbb, 0x37, 0x97, 0xa6,
			0xd3, 0x98, 0xfe, 0x87, 0x39, 0x64, 0x6f, 0xcd,
			0xa3, 0x3c, 0x81, 0x43, 0x73, 0x49, 0xd4, 0x98,
			0x09, 0x03, 0x6c, 0x20, 0x64, 0xf4, 0xd8, 0x97,
			0x39, 0xfb, 0x97, 0xe4, 0xbe, 0xa4, 0x51, 0x72,
			0xce, 0x64, 0xa4, 0xf8, 0x39, 0x2c, 0xe4, 0xf5,
			0x30, 0xb1, 0xf4, 0x52, 0x2a, 0x10, 0xc8, 0xdf,
			0xc8, 0xf7, 0xd6, 0xe1, 0xb9, 0x1c, 0xdc, 0xfb,
		},
	},
	/* SHA224 [3] */
	{
		/* Msg3 : 128 byte */
		{
			0x66, 0x2f, 0xfc, 0xca, 0xb1, 0x34, 0x72, 0x14,
			0x0d, 0xb8, 0x66, 0xfa, 0x56, 0x2f, 0x49, 0xba,
			0x20, 0xf0, 0xe9, 0x76, 0x58, 0x43, 0x39, 0xe4,
			0x29, 0xbb, 0x55, 0x48, 0x1d, 0xc6, 0xc1, 0x9f,
			0x85, 0x82, 0xf1, 0x1d, 0x1a, 0xd2, 0x0f, 0xda,
			0xe4, 0xb2, 0xf8, 0xc9, 0x5b, 0xc7, 0x88, 0xe9,
			0xcd, 0x3a, 0x17, 0xbf, 0xff, 0xc7, 0x43, 0x03,
			0x17, 0x11, 0xf0, 0x9a, 0xb9, 0x39, 0x8e, 0xc4,
			0x71, 0xae, 0x9b, 0x97, 0x51, 0x47, 0x68, 0xac,
			0xdb, 0x8f, 0x1f, 0x18, 0x21, 0x60, 0x05, 0x9d,
			0x2a, 0xb3, 0xfd, 0x22, 0x98, 0xb6, 0x4e, 0x61,
			0x88, 0x1f, 0xa5, 0xe0, 0xba, 0xc0, 0x5e, 0x22,
			0xf2, 0x5c, 0xff, 0x1e, 0x9d, 0xba, 0x05, 0xf0,
			0xb8, 0xf7, 0xe4, 0xcf, 0xee, 0x20, 0x49, 0x3f,
			0x00, 0x01, 0xa2, 0x87, 0x6a, 0x37, 0xe0, 0x66,
			0x44, 0x8d, 0x7b, 0x02, 0x66, 0x85, 0xb7, 0x21,
		},
		/* S3 : 192 byte */
		{
			0x03, 0xf9, 0x4f, 0x48, 0x52, 0xda, 0x9e, 0x29,
			0x7b, 0xc4, 0xf3, 0x43, 0xe7, 0xe0, 0x3f, 0x5a,
			0x12, 0x27, 0xe6, 0xc0, 0x5f, 0x22, 0x33, 0x59,
			0xaf, 0xc3, 0xcb, 0xd2, 0xed, 0xdf, 0xd4, 0x87,
			0x74, 0x29, 0xf4, 0x04, 0x65, 0x71, 0xce, 0x66,
			0x9b, 0xc7, 0x02, 0x21, 0x87, 0xc5, 0xfc, 0xb8,
			0x12, 0x6c, 0xdc, 0xdc, 0xc1, 0xe2, 0x58, 0x01,
			0xf1, 0x28, 0x98, 0xab, 0x75, 0xc8, 0x89, 0x1e,
			0x48, 0x93, 0xf1, 0xd8, 0xd5, 0x89, 0x74, 0x78,
			0x84, 0x35, 0x97, 0x62, 0xbc, 0x7d, 0x96, 0x72,
			0x4f, 0x33, 0x79, 0x9a, 0x8c, 0x77, 0x46, 0x74,
			0xa1, 0xd6, 0x77, 0xa4, 0xc2, 0x2d, 0xf2, 0x14,
			0xe3, 0xdb, 0x25, 0xfa, 0x1f, 0x09, 0xd4, 0x86,
			0xdc, 0xc0, 0xbf, 0x21, 0x7d, 0x41, 0x0a, 0x86,
			0xf2, 0x38, 0xf4, 0x5f, 0xc8, 0x0a, 0x0f, 0x5f,
			0xc3, 0x37, 0x0e, 0x01, 0xca, 0x51, 0x65, 0x5e,
			0x68, 0xba, 0x14, 0xb8, 0x84, 0x69, 0xa9, 0x0c,
			0x2b, 0x71, 0xdb, 0x22, 0x91, 0xcc, 0x40, 0x9f,
			0xda, 0x54, 0x8d, 0x27, 0x41, 0xfd, 0xe4, 0x84,
			0x79, 0x7e, 0x37, 0x90, 0x22, 0x8e, 0x9f, 0xa5,
			0xe8, 0x4c, 0xb2, 0x40, 0xb7, 0x05, 0x94, 0x52,
			0xcb, 0xe7, 0xda, 0xb6, 0x4d, 0x63, 0x8f, 0x9d,
			0x58, 0x94, 0x98, 0x01, 0x90, 0x86, 0xf7, 0xc3,
			0xa2, 0x7e, 0x2f, 0x1f, 0x23, 0x57, 0x74, 0xf3,
		},
	},
	/* SHA224 [4] */
	{
		/* Msg4 : 128 byte */
		{
			0xfb, 0x91, 0xd3, 0x2d, 0x2c, 0xbd, 0x4f, 0xfb,
			0x40, 0x46, 0xa3, 0x6d, 0xe1, 0xbc, 0x73, 0xa6,
			0x77, 0x7b, 0xfa, 0x09, 0xa6, 0x22, 0xaa, 0x4f,
			0x17, 0x46, 0x12, 0xd6, 0x7c, 0x67, 0x05, 0x3c,
			0xce, 0x22, 0xf9, 0x2d, 0xd9, 0xa9, 0xad, 0x79,
			0xfb, 0x71, 0x0f, 0x6a, 0x29, 0x2a, 0x5c, 0x54,
			0x32, 0xf4, 0x89, 0x6d, 0x48, 0xd0, 0xe2, 0xdf,
			0xbc, 0x54, 0xf1, 0x1c, 0x09, 0xa4, 0xa1, 0x72,
			0x14, 0x9d, 0xa3, 0xdf, 0xb2, 0x53, 0x11, 0x26,
			0x6b, 0xbe, 0x51, 0x22, 0x7e, 0xb0, 0x3d, 0x5b,
			0x24, 0x0a, 0x80, 0xd7, 0x19, 0x30, 0x43, 0x33,
			0x59, 0xba, 0x0a, 0xf2, 0x27, 0x6d, 0xd8, 0x14,
			0x54, 0x69, 0x9a, 0xea, 0xbe, 0xa3, 0xc2, 0x2a,
			0x17, 0x96, 0x33, 0x3f, 0xe8, 0x36, 0x5d, 0xe2,
			0xd5, 0x26, 0xa9, 0xee, 0x22, 0x2a, 0x17, 0x70,
			0x76, 0xdf, 0x25, 0xfe, 0xdf, 0xaa, 0xf4, 0x4b,
		},
		/* S4 : 192 byte */
		{
			0x11, 0xe0, 0x23, 0x51, 0x2d, 0x47, 0x59, 0x94,
			0x49, 0xfe, 0x54, 0x7a, 0x6d, 0x92, 0xf1, 0x1c,
			0x40, 0xcf, 0x0f, 0xdb, 0x59, 0x53, 0x5d, 0x44,
			0x74, 0x6e, 0x4c, 0xdd, 0x66, 0x6e, 0xbd, 0xaa,
			0x87, 0xdf, 0xf7, 0x52, 0xa0, 0xa7, 0x44, 0x63,
			0x8a, 0x5d, 0xf8, 0xf6, 0xb2, 0xa4, 0xa0, 0x27,
			0x89, 0x92, 0x7e, 0xd8, 0x7c, 0x55, 0x77, 0xbb,
			0xb9, 0x35, 0x67, 0x8b, 0x1c, 0x03, 0x4f, 0xbb,
			0x56, 0x9b, 0xf3, 0xf3, 0x0e, 0x66, 0xc9, 0xa7,
			0x94, 0xa6, 0x84, 0x99, 0x26, 0x6e, 0x73, 0xce,
			0x16, 0x45, 0xc2, 0x75, 0xa0, 0x67, 0xa0, 0xd6,
			0xdb, 0x01, 0x0a, 0x6d, 0x98, 0x7c, 0x01, 0x74,
			0x13, 0x7e, 0x08, 0x03, 0x74, 0xb1, 0x93, 0xf9,
			0x8d, 0x34, 0x33, 0x5b, 0xcb, 0xa1, 0x33, 0xd2,
			0x7d, 0xf2, 0x1f, 0xdf, 0x03, 0x03, 0xe2, 0x8c,
			0xb8, 0xe2, 0x86, 0x34, 0x27, 0xe7, 0xed, 0xb6,
			0x51, 0xa9, 0xdf, 0x52, 0x00, 0xcf, 0x35, 0x4c,
			0x00, 0xd3, 0x69, 0xd9, 0xce, 0x18, 0x04, 0xf7,
			0xb3, 0x04, 0xb5, 0x99, 0x7d, 0x6e, 0x58, 0x7e,
			0x71, 0xcc, 0x3f, 0x9f, 0x83, 0x96, 0x3e, 0x1d,
			0x54, 0xa9, 0xb0, 0x08, 0x9d, 0xda, 0xaa, 0x89,
			0x90, 0x07, 0x7c, 0xb5, 0x09, 0xa5, 0x5c, 0x89,
			0x27, 0x0c, 0x4d, 0xc1, 0x71, 0x12, 0xf7, 0x73,
			0x8f, 0x1e, 0xf6, 0x21, 0x98, 0xd0, 0x14, 0xbd,
		},
	},
	/* SHA224 [5] */
	{
		/* Msg5 : 128 byte */
		{
			0xa7, 0x0a, 0x6f, 0xc8, 0x94, 0x5a, 0x7c, 0xe5,
			0xa8, 0x18, 0x92, 0xf9, 0xb1, 0x6d, 0x80, 0x9f,
			0xae, 0xec, 0xe6, 0x0a, 0xd6, 0x7d, 0x55, 0x98,
			0xdc, 0x99, 0xb2, 0xa9, 0x72, 0xbd, 0xdb, 0xb1,
			0x0c, 0x18, 0x8d, 0x8c, 0xe6, 0x87, 0x86, 0x12,
			0x48, 0xc4, 0xe6, 0xec, 0x09, 0xdb, 0xdb, 0xa6,
			0x52, 0xdd, 0x7d, 0x04, 0xa4, 0xd7, 0xf7, 0x9a,
			0x1c, 0x05, 0xe8, 0x97, 0xf6, 0x44, 0x09, 0xe2,
			0x51, 0xc6, 0x0f, 0x68, 0x31, 0x09, 0xd3, 0xb4,
			0xca, 0x0a, 0xb0, 0xc0, 0xfc, 0xb6, 0x2c, 0x0a,
			0x1a, 0xa1, 0xdb, 0xeb, 0xef, 0xfa, 0x81, 0x24,
			0x03, 0xbf, 0x77, 0xba, 0x1a, 0x2d, 0x50, 0x05,
			0xfe, 0x7b, 0xbb, 0x03, 0x7e, 0xc7, 0xab, 0xf2,
			0xb7, 0x51, 0xb6, 0x1d, 0x92, 0xe7, 0xbb, 0xf6,
			0x8e, 0xa0, 0xc8, 0x65, 0xc0, 0xcd, 0x3b, 0x60,
			0x18, 0x2d, 0x27, 0xbc, 0xe5, 0x60, 0xf9, 0x42,
		},
		/* S5 : 192 byte */
		{
			0x8c, 0x14, 0xcd, 0x62, 0x32, 0x5c, 0x48, 0x9d,
			0x3b, 0xd2, 0x9f, 0xcf, 0xde, 0xcf, 0x1d, 0xff,
			0x11, 0x8d, 0x62, 0x47, 0xcf, 0x65, 0xc5, 0xe4,
			0xc3, 0x75, 0x23, 0xc7, 0x7e, 0x1f, 0xcf, 0xb3,
			0xc6, 0x65, 0xb5, 0x1c, 0x3b, 0x7c, 0x6e, 0x79,
			0xb0, 0x5c, 0xf1, 0xcb, 0x31, 0x85, 0x4c, 0xf4,
			0x27, 0xd5, 0x99, 0x13, 0x41, 0x70, 0x1a, 0xc5,
			0x94, 0xab, 0xad, 0x62, 0x90, 0xba, 0x12, 0x7b,
			0x93, 0xaa, 0xf0, 0x5d, 0x9e, 0xa0, 0x5a, 0xd8,
			0xb8, 0x16, 0xbf, 0xb2, 0x83, 0x33, 0x82, 0x6c,
			0x4a, 0x30, 0x29, 0x59, 0xc1, 0xba, 0x5a, 0x09,
			0x3c, 0xc0, 0x31, 0x9b, 0x3c, 0x71, 0xc4, 0x43,
			0x02, 0x63, 0xbc, 0x24, 0x9d, 0x55, 0x72, 0xa6,
			0xf9, 0x3f, 0x5d, 0x12, 0xd6, 0x55, 0x6a, 0x27,
			0xae, 0xc1, 0x37, 0x4d, 0x13, 0x63, 0x46, 0x84,
			0xd6, 0x2f, 0x81, 0x9f, 0xdc, 0x3a, 0x8b, 0x7b,
			0xd3, 0xa9, 0x58, 0x5b, 0x38, 0xa6, 0x3a, 0xc4,
			0x6b, 0xa9, 0xfd, 0x46, 0x0d, 0x83, 0xc8, 0x0a,
			0xcb, 0x75, 0xad, 0xe9, 0x13, 0x46, 0xbc, 0xe3,
			0x96, 0x30, 0x0e, 0x6a, 0x7c, 0xe6, 0xad, 0x18,
			0x16, 0x1c, 0x0a, 0x14, 0x39, 0xe5, 0x58, 0xe0,
			0x9a, 0x51, 0x3b, 0x83, 0x92, 0x93, 0x54, 0x1a,
			0x0b, 0xbb, 0xd4, 0xb6, 0x3b, 0x4a, 0x38, 0x1e,
			0xed, 0x07, 0x5c, 0xb8, 0x8d, 0x95, 0x9d, 0x95,
		},
	},
	/* SHA224 [6] */
	{
		/* Msg6 : 128 byte */
		{
			0xe8, 0x44, 0x88, 0xe1, 0xd4, 0xb6, 0xd3, 0x5f,
			0x82, 0x76, 0x75, 0x14, 0xd4, 0x6d, 0x04, 0x4e,
			0xae, 0x85, 0x0f, 0x73, 0xb2, 0x60, 0x01, 0x4d,
			0x4e, 0x4b, 0x48, 0xa6, 0xf9, 0x6d, 0xb7, 0x15,
			0xb9, 0x44, 0x29, 0x17, 0xe9, 0x53, 0x68, 0x61,
			0x39, 0x14, 0x4d, 0x75, 0xf6, 0x34, 0x28, 0x74,
			0x8c, 0xff, 0x61, 0x33, 0x49, 0x1a, 0x60, 0x90,
			0x63, 0x70, 0xab, 0x07, 0x3d, 0x6e, 0x4e, 0x80,
			0xe6, 0x73, 0x80, 0x6b, 0xe2, 0x82, 0x83, 0x0f,
			0x2e, 0x3b, 0xcc, 0x1f, 0x7e, 0x09, 0x64, 0x8f,
			0xc9, 0x9c, 0x8e, 0xa5, 0x07, 0x9a, 0xaa, 0x53,
			0x3a, 0x91, 0x59, 0xc4, 0xab, 0x31, 0xe2, 0x35,
			0x76, 0xb8, 0xd5, 0x06, 0x48, 0xad, 0xee, 0x11,
			0x68, 0xd1, 0x3b, 0x3a, 0xf4, 0x53, 0x81, 0x47,
			0x6e, 0x43, 0xdd, 0xf3, 0x77, 0x49, 0xa7, 0x3d,
			0xd9, 0x97, 0x9b, 0x06, 0xcb, 0x1c, 0x3b, 0xdb,
		},
		/* S6 : 192 byte */
		{
			0x51, 0x27, 0xc8, 0x50, 0x58, 0xdc, 0x71, 0xa4,
			0xa0, 0x75, 0x92, 0xc8, 0x5a, 0x86, 0xf3, 0xfe,
			0xad, 0x0c, 0x49, 0xd6, 0xf6, 0x1b, 0x16, 0xcf,
			0xa7, 0xff, 0x17, 0x01, 0x7b, 0x87, 0x74, 0x53,
			0xa7, 0x5b, 0xae, 0xac, 0x9a, 0x9e, 0x83, 0xef,
			0xa2, 0xe1, 0xf6, 0x49, 0xee, 0xdc, 0x8e, 0x32,
			0x41, 0x4d, 0xb7, 0x8d, 0xcf, 0x39, 0x41, 0x4d,
			0x7f, 0x4a, 0x45, 0x37, 0xa4, 0x76, 0xd3, 0x94,
			0x8a, 0xdc, 0x04, 0x7c, 0x37, 0x76, 0xec, 0xf3,
			0x16, 0x6a, 0x8a, 0x1a, 0x65, 0xda, 0xff, 0x3f,
			0x56, 0xdf, 0x78, 0x66, 0xab, 0xfc, 0x5a, 0x67,
			0x35, 0xad, 0x75, 0x55, 0x89, 0x03, 0x2e, 0xab,
			0x32, 0x16, 0x85, 0x3f, 0xd6, 0x9c, 0x33, 0x37,
			0x69, 0x4f, 0xf1, 0xe5, 0xa5, 0x73, 0x7e, 0x3d,
			0x73, 0xfe, 0x5d, 0x8f, 0xcc, 0xb9, 0x1d, 0x9a,
			0xed, 0xbc, 0xa2, 0x0c, 0x48, 0x33, 0x91, 0x46,
			0x67, 0xbe, 0x43, 0x71, 0xcb, 0xc9, 0x94, 0x42,
			0x56, 0x0a, 0x08, 0xb9, 0x78, 0x16, 0xfc, 0x08,
			0x7a, 0xa5, 0xec, 0x15, 0x52, 0x05, 0xb4, 0x41,
			0x07, 0x21, 0xd0, 0x03, 0x8e, 0x2e, 0xbc, 0x48,
			0x08, 0xa2, 0x15, 0xfa, 0x00, 0x0c, 0x30, 0x8f,
			0xec, 0x9f, 0x2a, 0x84, 0x25, 0x9e, 0xb3, 0x18,
			0x9f, 0x33, 0xf7, 0xaf, 0xb2, 0x62, 0xe7, 0x34,
			0xb1, 0x32, 0x67, 0x74, 0x04, 0x51, 0xd8, 0xb1,
		},
	},
	/* SHA224 [7] */
	{
		/* Msg7 : 128 byte */
		{
			0xcc, 0x8c, 0xf6, 0x69, 0xed, 0xf7, 0x86, 0x83,
			0x7b, 0xfb, 0xb4, 0x8d, 0xea, 0x47, 0x43, 0xc4,
			0xd2, 0x25, 0x27, 0xe4, 0x50, 0x4e, 0xff, 0x9c,
			0xaa, 0x03, 0xe0, 0x3f, 0x31, 0x59, 0x54, 0xbc,
			0x6c, 0xd5, 0xa2, 0xd0, 0x72, 0x38, 0x50, 0x7a,
			0x98, 0x9c, 0xe7, 0xb0, 0x4c, 0xc0, 0xf6, 0x50,
			0x41, 0xa1, 0x59, 0x59, 0xcd, 0x4a, 0xbb, 0x5b,
			0x8f, 0xec, 0x5a, 0x2c, 0x54, 0x31, 0x0a, 0xdd,
			0x3b, 0xce, 0x7d, 0xec, 0x18, 0x58, 0xc1, 0xbb,
			0x17, 0x58, 0x0a, 0x41, 0xa2, 0xa1, 0xb2, 0x00,
			0x84, 0xe1, 0x7e, 0x37, 0x4e, 0x77, 0x23, 0x58,
			0xf9, 0x84, 0x09, 0xbc, 0xce, 0x45, 0x4e, 0x96,
			0x83, 0xa0, 0x0e, 0x26, 0xa7, 0xfc, 0xe2, 0x2f,
			0x40, 0x56, 0xa6, 0xaa, 0xb2, 0x91, 0x80, 0xbc,
			0xe2, 0x0e, 0x1d, 0xe6, 0x9c, 0x7d, 0x3e, 0x7c,
			0x32, 0xf3, 0x74, 0x58, 0x66, 0x3c, 0x27, 0xcf,
		},
		/* S7 : 192 byte */
		{
			0x67, 0x72, 0xd4, 0x80, 0x29, 0x12, 0xfd, 0xd4,
			0xd3, 0x21, 0xda, 0x4c, 0x15, 0xc3, 0xb7, 0x5a,
			0xd4, 0x22, 0x0a, 0x88, 0x35, 0x35, 0x49, 0x88,
			0x00, 0x10, 0xeb, 0xf4, 0x3e, 0x3d, 0x35, 0xf6,
			0x71, 0xef, 0x38, 0x17, 0x3e, 0x9d, 0x4f, 0xbc,
			0x29, 0x04, 0xd2, 0xfd, 0xae, 0x52, 0x78, 0x17,
			0xc9, 0x31, 0x0b, 0x94, 0xeb, 0xef, 0xdc, 0x75,
			0x92, 0x9f, 0x60, 0x2b, 0xcc, 0x18, 0x8b, 0x03,
			0x9c, 0xe3, 0xd9, 0x66, 0xeb, 0x84, 0x47, 0x17,
			0x49, 0x69, 0x49, 0x66, 0x4d, 0x1f, 0xcd, 0xd1,
			0x8b, 0x81, 0x04, 0x81, 0xec, 0xfa, 0xab, 0x65,
			0x40, 0xb2, 0x5a, 0xa5, 0x71, 0xa3, 0x42, 0xb9,
			0xf5, 0x82, 0x4d, 0x5f, 0x4d, 0x94, 0x68, 0x93,
			0x38, 0x1e, 0x22, 0xa5, 0x5f, 0x82, 0xb8, 0x55,
			0xa7, 0x64, 0xc1, 0x1d, 0xd7, 0x80, 0xf6, 0x53,
			0x2d, 0x37, 0x6e, 0x23, 0x16, 0x3c, 0xde, 0x9e,
			0x1b, 0xa2, 0x59, 0x4f, 0x5e, 0x1b, 0x60, 0x2b,
			0x1a, 0x69, 0xad, 0xa4, 0xed, 0xeb, 0x0c, 0x0a,
			0x94, 0xa0, 0x64, 0xd9, 0x3b, 0x73, 0x01, 0x89,
			0x09, 0xfe, 0xe5, 0xa3, 0xd2, 0x1d, 0xbd, 0xe8,
			0x91, 0x7e, 0x48, 0x03, 0xdd, 0xd1, 0x8f, 0x0f,
			0x80, 0xea, 0x64, 0x97, 0xfb, 0x73, 0xd1, 0x71,
			0x24, 0x61, 0x5a, 0x7a, 0x89, 0x20, 0xa6, 0x6b,
			0x85, 0x4c, 0x27, 0x0e, 0x0e, 0xf2, 0x3b, 0xcf,
		},
	},
	/* SHA224 [8] */
	{
		/* Msg8 : 128 byte */
		{
			0x9c, 0xf9, 0x20, 0x60, 0x31, 0xfb, 0x19, 0xbd,
			0x87, 0xfc, 0x50, 0xaa, 0x4d, 0x3b, 0x1b, 0xf3,
			0xb8, 0x6e, 0x66, 0xa3, 0x31, 0xaa, 0x06, 0x0f,
			0x4b, 0x82, 0x4a, 0x16, 0xf7, 0x73, 0xd3, 0xa8,
			0xfb, 0x80, 0xa6, 0x85, 0xa0, 0x19, 0x80, 0x47,
			0xab, 0x41, 0x6a, 0xa3, 0x8f, 0xf0, 0x8c, 0xec,
			0xe1, 0xb6, 0x46, 0xd8, 0x0c, 0xa2, 0x7d, 0x87,
			0x46, 0x62, 0x33, 0xc1, 0xc3, 0xab, 0x5b, 0x80,
			0x28, 0xdc, 0xeb, 0xae, 0x42, 0xde, 0x32, 0x2f,
			0xf8, 0x4e, 0x6c, 0x22, 0x7e, 0xde, 0x94, 0x64,
			0xcc, 0xf8, 0x79, 0x56, 0x4f, 0xa5, 0x14, 0xe1,
			0xde, 0xae, 0x19, 0xb7, 0xef, 0x01, 0xcc, 0xdb,
			0x0b, 0x55, 0x16, 0x63, 0x7f, 0x11, 0xd8, 0x7d,
			0x55, 0x6a, 0x7f, 0xb0, 0x82, 0xcc, 0xd9, 0x64,
			0x61, 0x7c, 0x27, 0xa5, 0x60, 0x7b, 0x73, 0x24,
			0xfa, 0xad, 0x23, 0x7e, 0xe5, 0x3a, 0xcf, 0xc1,
		},
		/* S8 : 192 byte */
		{
			0x42, 0xa5, 0xd8, 0x3f, 0xa6, 0xdc, 0xf0, 0xae,
			0xfa, 0x64, 0xc3, 0xd6, 0x51, 0xc3, 0x9a, 0x08,
			0x8f, 0x43, 0x39, 0x95, 0x2a, 0x6f, 0x4a, 0x32,
			0xce, 0x19, 0x2a, 0x8d, 0xd6, 0xe3, 0x47, 0x36,
			0x93, 0x6b, 0x02, 0x5e, 0xb9, 0xe9, 0xff, 0x35,
			0xcd, 0xce, 0x3a, 0x4d, 0x69, 0x94, 0xb0, 0xd1,
			0xe0, 0xa7, 0x46, 0x49, 0xc6, 0x12, 0x77, 0x6d,
			0xca, 0xdf, 0xf5, 0xfe, 0x3d, 0x73, 0xc1, 0x74,
			0xf4, 0x92, 0xcd, 0xe0, 0x3d, 0x16, 0x29, 0x2a,
			0xbf, 0x08, 0x2c, 0xb7, 0xb7, 0x95, 0x79, 0x5f,
			0xf9, 0x27, 0xe2, 0xb4, 0xc8, 0xcd, 0x89, 0xf4,
			0x3f, 0x24, 0xea, 0xb7, 0x46, 0xc8, 0x25, 0xa6,
			0x15, 0xb1, 0x54, 0xb5, 0xc5, 0xff, 0xb3, 0x0d,
			0x86, 0xff, 0xb1, 0xc3, 0xd3, 0xb8, 0xb2, 0x07,
			0xbc, 0x1d, 0x29, 0xd3, 0x12, 0x30, 0x75, 0x29,
			0xb9, 0x63, 0x47, 0x83, 0xc1, 0xec, 0x59, 0xc0,
			0x7f, 0x45, 0xaf, 0x4d, 0x5b, 0x5a, 0xcc, 0xde,
			0x4a, 0x7c, 0x51, 0xa9, 0x04, 0x88, 0xb3, 0x93,
			0x0d, 0x7c, 0x3c, 0x84, 0xad, 0xe6, 0xc5, 0xe1,
			0xa8, 0x75, 0xe2, 0xf3, 0x84, 0xcc, 0xc9, 0xc8,
			0x5c, 0x9c, 0x84, 0x7b, 0x6b, 0x53, 0xe3, 0x47,
			0x79, 0x56, 0x20, 0x39, 0xd7, 0xe3, 0xdd, 0xb8,
			0x33, 0x8d, 0x19, 0x49, 0x46, 0x09, 0x36, 0x1d,
			0xc3, 0x6c, 0x6c, 0xaf, 0x6b, 0x48, 0xc7, 0x26,
		},
	},
	/* SHA224 [9] */
	{
		/* Msg9 : 128 byte */
		{
			0x41, 0xfb, 0xae, 0xe4, 0x80, 0x5d, 0x64, 0x63,
			0x5b, 0x05, 0x01, 0x13, 0x02, 0x33, 0x50, 0xda,
			0xcc, 0xb0, 0x89, 0x64, 0xcf, 0x0d, 0x83, 0x7d,
			0xad, 0x2f, 0x25, 0xbf, 0xb0, 0x0c, 0x1e, 0x6e,
			0x1a, 0xaf, 0xd5, 0xa0, 0xb6, 0x82, 0xa3, 0xa1,
			0xb3, 0xcc, 0x41, 0x95, 0xb2, 0x79, 0x7c, 0x5f,
			0x1e, 0x1a, 0x30, 0xc2, 0xbc, 0x2c, 0x73, 0xc6,
			0x83, 0x9d, 0x11, 0x5e, 0xad, 0x8c, 0x39, 0x47,
			0x0e, 0x51, 0x75, 0x33, 0xa5, 0xbd, 0xdf, 0x27,
			0x71, 0xa2, 0x93, 0x22, 0x85, 0x96, 0x60, 0xff,
			0x5f, 0xf5, 0xc3, 0x9c, 0x76, 0x25, 0x15, 0x3c,
			0x12, 0x1e, 0x03, 0x2a, 0x60, 0x29, 0x3f, 0xa0,
			0xc6, 0xe7, 0x75, 0xe6, 0x74, 0x96, 0x81, 0xbe,
			0x3c, 0x90, 0xdf, 0x00, 0xa3, 0x14, 0x62, 0x82,
			0x38, 0x49, 0x29, 0x3a, 0x24, 0x80, 0xd0, 0xa7,
			0x03, 0xba, 0xe3, 0x6c, 0xf2, 0x6a, 0x98, 0x3f,
		},
		/* S9 : 192 byte */
		{
			0x5f, 0x9e, 0x46, 0x25, 0xc5, 0x8b, 0x86, 0x1f,
			0xdd, 0xcc, 0x55, 0x8f, 0x3d, 0xe7, 0xd8, 0x5c,
			0x36, 0x43, 0xfc, 0x31, 0x2e, 0x8d, 0x04, 0xd0,
			0xe1, 0x9a, 0xc4, 0xea, 0x13, 0x05, 0xde, 0xa1,
			0xb2, 0xb0, 0x15, 0xe8, 0xcd, 0x5b, 0x8a, 0xe6,
			0xc3, 0x48, 0xf9, 0xe8, 0x8d, 0xd5, 0x1e, 0x56,
			0x9d, 0x9f, 0x0b, 0x8a, 0x36, 0x5b, 0xfe, 0xb3,
			0xd4, 0x93, 0x10, 0x2f, 0xb7, 0xa5, 0x30, 0xf9,
			0xcb, 0x69, 0xce, 0x33, 0x85, 0xab, 0x5c, 0xd0,
			0x47, 0x0f, 0xde, 0x3d, 0x45, 0x1d, 0xb8, 0x2e,
			0xb1, 0xf5, 0xf2, 0x26, 0xd3, 0x9f, 0x9c, 0xc5,
			0xca, 0xe5, 0xe3, 0xac, 0x6c, 0x70, 0x75, 0xb7,
			0x17, 0x0b, 0x1f, 0x2f, 0x3d, 0xdf, 0x49, 0x87,
			0x75, 0x11, 0xee, 0x17, 0x8e, 0x46, 0xba, 0x5d,
			0xe7, 0x51, 0x08, 0xa0, 0xc9, 0xf8, 0xba, 0xd1,
			0x48, 0x88, 0x23, 0x87, 0x3d, 0x49, 0x49, 0xc7,
			0x0f, 0xdf, 0xa1, 0xdf, 0xfc, 0x44, 0x44, 0x40,
			0x1f, 0xdb, 0xd1, 0x34, 0xd7, 0xa3, 0x26, 0xed,
			0xf0, 0xd0, 0xb1, 0x1b, 0x41, 0xb2, 0x17, 0xf7,
			0xc3, 0x88, 0x26, 0x3f, 0x50, 0x23, 0x70, 0x08,
			0xe0, 0xd7, 0x8f, 0xa0, 0x22, 0xa1, 0x49, 0x53,
			0xac, 0xce, 0xd9, 0x2f, 0x1d, 0xc5, 0xd2, 0x47,
			0x5c, 0x95, 0x8d, 0x81, 0xa5, 0xc1, 0x65, 0x3b,
			0x25, 0x5f, 0xb5, 0x66, 0xf8, 0x44, 0x9f, 0x00,
		},
	},
};

/* 10 elements */
static mod1536_t SHA256[] = {
	/* SHA256 [0] */
	{
		/* Msg0 : 128 byte */
		{
			0x37, 0xd7, 0xfe, 0xe3, 0xd3, 0x19, 0x34, 0x91,
			0x21, 0x67, 0xe1, 0xff, 0xb3, 0x5b, 0x4b, 0x2f,
			0x15, 0x9e, 0x84, 0xbd, 0x02, 0x51, 0x3d, 0x65,
			0xd8, 0xab, 0xdb, 0xc4, 0x4a, 0xe3, 0xcd, 0x63,
			0x55, 0x50, 0x1c, 0xf1, 0x75, 0xcf, 0x43, 0xd0,
			0x18, 0x65, 0x42, 0xd4, 0x53, 0x25, 0xee, 0x47,
			0xd4, 0x54, 0x8b, 0x30, 0x18, 0xcc, 0x9c, 0xd4,
			0xde, 0x9e, 0xfa, 0x7e, 0xdb, 0xfb, 0x24, 0x7c,
			0xaf, 0x55, 0xd6, 0x6a, 0x18, 0xc1, 0xdd, 0xb3,
			0x65, 0xa0, 0x29, 0x54, 0x2e, 0x7e, 0x24, 0xe3,
			0x43, 0x3a, 0x42, 0xd0, 0xe2, 0x67, 0xd9, 0xec,
			0x2d, 0xf3, 0x34, 0x27, 0xda, 0x06, 0xe3, 0x9e,
			0x2d, 0x2d, 0x54, 0xd5, 0x23, 0xb8, 0xa8, 0x40,
			0xf1, 0x61, 0xbf, 0x09, 0xac, 0x2e, 0x95, 0x0d,
			0x4a, 0x98, 0xd2, 0x28, 0xc9, 0xec, 0x9c, 0xb2,
			0xae, 0xf2, 0xb0, 0x49, 0xb1, 0xcd, 0xb1, 0xd1,
		},
		/* S0 : 192 byte */
		{
			0x09, 0x2a, 0x25, 0x7b, 0x50, 0xa4, 0xe4, 0xc8,
			0xc7, 0x91, 0x4e, 0x0d, 0x19, 0xc0, 0x08, 0x87,
			0x78, 0xe5, 0xcb, 0x4a, 0x81, 0x5f, 0xd3, 0xa4,
			0xeb, 0x59, 0xcc, 0xf3, 0xe7, 0x12, 0x33, 0x93,
			0x4f, 0x9b, 0xcb, 0xa2, 0xe0, 0x34, 0x65, 0xf2,
			0xc1, 0x2d, 0x21, 0x00, 0xe7, 0x22, 0xc7, 0x03,
			0xac, 0xc6, 0xbd, 0xb8, 0x62, 0x6c, 0xac, 0x09,
			0xf9, 0x64, 0xf9, 0xf4, 0xba, 0x52, 0x7d, 0x9c,
			0x49, 0xa6, 0xd6, 0xa2, 0x13, 0x68, 0x73, 0x66,
			0x6b, 0xdc, 0xba, 0x0a, 0x29, 0x7a, 0x3c, 0x38,
			0xfe, 0x48, 0x73, 0x1f, 0xce, 0x5a, 0x72, 0x76,
			0x01, 0x5c, 0x4d, 0x75, 0x0d, 0xe6, 0xfc, 0x55,
			0x07, 0x18, 0x54, 0x47, 0x67, 0xc8, 0x6d, 0xf1,
			0x6b, 0x04, 0x8c, 0xbd, 0x8a, 0xb8, 0xa8, 0x78,
			0xb6, 0xba, 0xb2, 0x5a, 0xd6, 0x42, 0xdd, 0x57,
			0x10, 0x2f, 0x32, 0x34, 0x71, 0xe2, 0xfe, 0xcb,
			0x84, 0xf4, 0x0b, 0xe0, 0x0c, 0x79, 0xf7, 0x5d,
			0xb6, 0xbf, 0x01, 0xab, 0x07, 0x0f, 0xb2, 0x87,
			0x4c, 0xf1, 0x1a, 0x3d, 0x4e, 0x81, 0xe1, 0x5f,
			0x87, 0x8b, 0x07, 0x97, 0xb5, 0x34, 0x74, 0x3e,
			0x96, 0x66, 0xc9, 0x3f, 0x78, 0x2f, 0x0a, 0x11,
			0x53, 0x9c, 0x01, 0x54, 0xf4, 0x06, 0xc7, 0x10,
			0xf1, 0xf5, 0xe2, 0x4b, 0x49, 0x0d, 0x7f, 0x46,
			0x86, 0x91, 0xca, 0x28, 0x73, 0x0a, 0x48, 0x02,
		},
	},
	/* SHA256 [1] */
	{
		/* Msg1 : 128 byte */
		{
			0x15, 0x75, 0x0e, 0x41, 0x1e, 0xd6, 0xb1, 0x48,
			0x7e, 0x9b, 0xfa, 0xe9, 0x6a, 0xaf, 0x75, 0x8f,
			0x6c, 0x05, 0x9c, 0xe1, 0x66, 0x8a, 0xf8, 0x4f,
			0xd4, 0x58, 0x89, 0xeb, 0x51, 0x2c, 0x68, 0x7b,
			0x5d, 0x1a, 0xab, 0xcc, 0x5d, 0x7f, 0x89, 0x49,
			0xe3, 0x38, 0xbf, 0xcb, 0x30, 0x11, 0x31, 0xb3,
			0xf7, 0x80, 0xd5, 0x37, 0x64, 0x94, 0xcd, 0xf9,
			0x5d, 0x28, 0xd3, 0xde, 0x08, 0x5c, 0xda, 0x1d,
			0x8d, 0x46, 0xf2, 0x96, 0x1d, 0xe4, 0x6d, 0x66,
			0x33, 0x55, 0x40, 0xb8, 0x19, 0x49, 0xac, 0xdd,
			0xaf, 0xb7, 0x1d, 0xa0, 0x68, 0xce, 0x52, 0xd3,
			0x95, 0x2d, 0xbe, 0x2e, 0xe6, 0x56, 0x2e, 0x5a,
			0x2d, 0x60, 0xad, 0x48, 0x66, 0xed, 0xa4, 0xc7,
			0xf5, 0x5c, 0x46, 0x56, 0x2e, 0x40, 0x2b, 0x36,
			0x1a, 0x10, 0x3b, 0xc4, 0x78, 0x20, 0xce, 0x06,
			0x03, 0xcf, 0x12, 0x84, 0xf3, 0x02, 0xac, 0x59,
		},
		/* S1 : 192 byte */
		{
			0x45, 0xf6, 0x20, 0x2a, 0x02, 0x9a, 0x0b, 0x57,
			0x51, 0xca, 0x6a, 0xa8, 0x1f, 0x87, 0x12, 0xda,
			0x94, 0x64, 0x6b, 0x05, 0xa4, 0x49, 0x01, 0xf8,
			0xf9, 0x72, 0x83, 0x4f, 0xbd, 0x87, 0x45, 0xe0,
			0x71, 0x68, 0x88, 0xe2, 0x6f, 0xa9, 0x31, 0x9e,
			0xaf, 0x30, 0x95, 0x13, 0x87, 0xbf, 0x93, 0x70,
			0xa3, 0xe0, 0x05, 0xc9, 0x70, 0xda, 0xe2, 0x95,
			0x8e, 0x8c, 0x3a, 0xef, 0x1e, 0x4b, 0xba, 0x80,
			0x2a, 0xf8, 0x77, 0x14, 0x0b, 0x39, 0xc4, 0x67,
			0x59, 0x51, 0x47, 0x21, 0x5f, 0x44, 0xa5, 0x72,
			0x6f, 0xfe, 0x4b, 0xe1, 0x70, 0x04, 0xd6, 0x1d,
			0x05, 0xf3, 0x95, 0x05, 0x02, 0x3a, 0x29, 0x42,
			0xcd, 0x8c, 0x9b, 0xc0, 0xa2, 0xa8, 0xef, 0x8b,
			0x8a, 0xbc, 0xc4, 0xbf, 0x02, 0xc6, 0x94, 0xb5,
			0xb2, 0xd9, 0x0c, 0xc5, 0xf2, 0x7a, 0xef, 0xf2,
			0xf3, 0x07, 0x8e, 0xb7, 0xda, 0xd4, 0xd0, 0xc2,
			0x92, 0xd4, 0x38, 0x01, 0xcd, 0xae, 0xb8, 0xc5,
			0x9c, 0x5e, 0x97, 0xa6, 0xbe, 0xb5, 0xfe, 0x03,
			0xe3, 0x20, 0xf9, 0xff, 0xd5, 0xcd, 0xde, 0xa1,
			0x44, 0x8d, 0x3d, 0x30, 0x8b, 0x6d, 0x8b, 0xde,
			0x90, 0xfe, 0xfc, 0x10, 0x83, 0xc5, 0x0f, 0x78,
			0xe8, 0xf2, 0xe2, 0x7c, 0x7c, 0x2a, 0x1b, 0x54,
			0xd5, 0xdf, 0xd8, 0x9d, 0x9a, 0x76, 0xa4, 0x0b,
			0x6d, 0xbe, 0x11, 0x8d, 0x57, 0x33, 0x6a, 0x31,
		},
	},
	/* SHA256 [2] */
	{
		/* Msg2 : 128 byte */
		{
			0x36, 0x9d, 0x20, 0xe1, 0x6d, 0x4a, 0x65, 0x74,
			0xd4, 0xf9, 0xee, 0x51, 0x11, 0x06, 0xbc, 0x49,
			0x42, 0x68, 0xf7, 0xb5, 0xee, 0xd9, 0x82, 0xb7,
			0x3b, 0x38, 0xd3, 0xc2, 0x62, 0x2b, 0x02, 0x5c,
			0x61, 0x08, 0x1f, 0x22, 0xf0, 0xf6, 0xc9, 0x0d,
			0xb5, 0x4f, 0xfc, 0xf5, 0xbb, 0x49, 0x2b, 0x53,
			0x21, 0xd6, 0x8f, 0x4b, 0x0f, 0xc8, 0xbe, 0xea,
			0xee, 0x39, 0x7f, 0xac, 0xd9, 0x2a, 0xdd, 0x41,
			0x4e, 0x6a, 0x7a, 0x90, 0x2a, 0xba, 0x26, 0xfd,
			0xd4, 0x2e, 0xb0, 0xe7, 0xb8, 0xd6, 0xfc, 0x75,
			0xf7, 0x9e, 0x56, 0x93, 0x5c, 0x73, 0x06, 0x37,
			0x93, 0xa7, 0x25, 0xe9, 0x95, 0x97, 0xaf, 0x82,
			0x67, 0x8b, 0xd9, 0x34, 0x04, 0xdd, 0xa4, 0xca,
			0x98, 0x5e, 0xb2, 0x31, 0xee, 0xf5, 0x58, 0x38,
			0x2c, 0x89, 0xf6, 0x94, 0xbe, 0x21, 0x83, 0x27,
			0x90, 0x4a, 0x6c, 0x82, 0x80, 0xba, 0x9f, 0xa8,
		},
		/* S2 : 192 byte */
		{
			0x23, 0x52, 0xb1, 0x5d, 0x1c, 0x53, 0x61, 0x46,
			0x66, 0x0f, 0x89, 0xd7, 0xa6, 0xb5, 0x4a, 0xdc,
			0x9d, 0x68, 0xc0, 0xd9, 0x44, 0x4f, 0xa5, 0x27,
			0x32, 0x1e, 0x19, 0xf5, 0x44, 0x4f, 0x41, 0x18,
			0xc3, 0x2b, 0x83, 0x45, 0x33, 0x9b, 0xb6, 0xba,
			0x35, 0xc8, 0x52, 0xdd, 0x57, 0x5d, 0xb7, 0xe3,
			0x69, 0x5f, 0xbf, 0xef, 0xd4, 0x2a, 0xac, 0xa0,
			0x46, 0xb6, 0xce, 0x65, 0x71, 0x37, 0xc9, 0xed,
			0x4d, 0x01, 0x0a, 0x15, 0xfa, 0xef, 0x7f, 0x60,
			0xbd, 0x4e, 0x6b, 0xef, 0xca, 0xbb, 0x41, 0x39,
			0x96, 0x4a, 0xf9, 0x6f, 0x6b, 0xe6, 0xa9, 0x91,
			0x1d, 0xce, 0x31, 0xca, 0xc2, 0x6b, 0x9e, 0xc7,
			0xeb, 0x21, 0xbe, 0x01, 0xb9, 0x06, 0x8c, 0x8b,
			0x03, 0x48, 0x3b, 0x47, 0x87, 0x4a, 0x6a, 0x3c,
			0x15, 0xf0, 0x85, 0x34, 0xad, 0xa6, 0x89, 0xa9,
			0xb4, 0xbb, 0x64, 0x1b, 0x9d, 0xd8, 0xa1, 0x25,
			0x92, 0xb8, 0xb1, 0x0c, 0x7f, 0x43, 0x7c, 0x6c,
			0xe7, 0x14, 0xc3, 0x09, 0x7e, 0xe4, 0x04, 0x9c,
			0xe1, 0x92, 0x03, 0xdc, 0xf5, 0xe0, 0xee, 0xf7,
			0x6c, 0x0f, 0x93, 0x3b, 0xed, 0x0e, 0x62, 0x4f,
			0x8c, 0x4a, 0x2d, 0x35, 0x7d, 0x23, 0x79, 0xc4,
			0xe3, 0xa1, 0xd3, 0x82, 0xde, 0xf0, 0xdf, 0xbe,
			0xc8, 0x5d, 0x48, 0xc6, 0x31, 0x4b, 0xbd, 0x69,
			0x18, 0xa5, 0x83, 0xc4, 0xc0, 0xdc, 0x37, 0xeb,
		},
	},
	/* SHA256 [3] */
	{
		/* Msg3 : 128 byte */
		{
			0x1f, 0x75, 0xef, 0x43, 0x71, 0x17, 0x83, 0x56,
			0x08, 0x1e, 0x4b, 0xab, 0x44, 0xfc, 0x3c, 0x70,
			0x6a, 0x70, 0x6f, 0x6e, 0xec, 0xb5, 0x80, 0xe0,
			0xeb, 0xf9, 0x34, 0x85, 0xfa, 0x10, 0x5e, 0xf4,
			0x25, 0x6a, 0x03, 0x30, 0x32, 0x42, 0xbc, 0x7c,
			0x26, 0x19, 0x5c, 0x70, 0x0b, 0x63, 0xd3, 0x4d,
			0xf1, 0x80, 0x52, 0x8e, 0x33, 0xed, 0xb0, 0xbf,
			0xfb, 0xbc, 0x0d, 0x92, 0x08, 0x41, 0xb5, 0x30,
			0xaf, 0x0f, 0x46, 0xcd, 0x20, 0x23, 0x16, 0x7f,
			0xeb, 0x5e, 0xcf, 0x50, 0xc3, 0x39, 0x5c, 0x92,
			0x81, 0xb4, 0x09, 0x72, 0x6c, 0x8f, 0xe5, 0xd0,
			0xb7, 0xbd, 0x6b, 0x4e, 0x4b, 0x16, 0x62, 0xa7,
			0xc7, 0x4c, 0x02, 0x43, 0xc5, 0x20, 0x58, 0x08,
			0x60, 0xd5, 0xec, 0x72, 0xf3, 0xe5, 0xa0, 0xe6,
			0x22, 0xf4, 0xdb, 0x43, 0x1f, 0x02, 0xe7, 0xbb,
			0x26, 0xe4, 0x98, 0xe1, 0x4a, 0xf5, 0x2f, 0x02,
		},
		/* S3 : 192 byte */
		{
			0x64, 0x3a, 0x46, 0xe1, 0x67, 0x63, 0xec, 0xbc,
			0xd7, 0x28, 0x7b, 0x66, 0xa9, 0x3c, 0x89, 0x7d,
			0x2e, 0x84, 0xd3, 0xe4, 0xed, 0xa2, 0x4f, 0x2e,
			0x51, 0x8f, 0x04, 0x81, 0x4d, 0x3d, 0x9d, 0x5a,
			0xac, 0x33, 0x65, 0xd9, 0x54, 0x1f, 0x5e, 0xdc,
			0xd1, 0x65, 0x04, 0x9b, 0x22, 0xa9, 0x06, 0x6f,
			0xdc, 0x95, 0x25, 0xae, 0x6d, 0xd5, 0xe5, 0x42,
			0x83, 0x02, 0x53, 0xf0, 0x08, 0x64, 0xce, 0x8b,
			0x40, 0xc9, 0x38, 0x9a, 0xa2, 0x85, 0x74, 0x53,
			0xf3, 0x69, 0x96, 0x95, 0x7e, 0x0b, 0xa5, 0xec,
			0x26, 0x18, 0xd4, 0x7a, 0x6f, 0x51, 0x4e, 0x2e,
			0x04, 0x51, 0x68, 0x42, 0x89, 0xba, 0xa8, 0x97,
			0x04, 0xa3, 0x3f, 0x35, 0xf2, 0x42, 0xc6, 0xf9,
			0x4e, 0xd2, 0x86, 0xd0, 0xac, 0x73, 0x01, 0xc3,
			0x5f, 0x43, 0x61, 0xe7, 0xb6, 0xdf, 0x12, 0x32,
			0xe7, 0x87, 0xd0, 0x81, 0xda, 0xb1, 0xad, 0x98,
			0xbb, 0xbd, 0xcf, 0xac, 0xde, 0x59, 0x96, 0x13,
			0x8d, 0x52, 0xad, 0x8c, 0x98, 0x84, 0x3d, 0x3a,
			0xd2, 0x45, 0x8c, 0x1c, 0xb0, 0x14, 0x3d, 0xe6,
			0x05, 0x85, 0xe6, 0x66, 0xc8, 0xa8, 0x28, 0x43,
			0xc7, 0x50, 0xe8, 0xd2, 0x8c, 0x41, 0xb0, 0x01,
			0xae, 0x73, 0xc8, 0x42, 0x52, 0x7e, 0x60, 0xd5,
			0x4f, 0x1d, 0xc2, 0x03, 0x20, 0xf9, 0x0a, 0x66,
			0x3c, 0x70, 0x1f, 0x2b, 0xab, 0x86, 0x96, 0xe9,
		},
	},
	/* SHA256 [4] */
	{
		/* Msg4 : 128 byte */
		{
			0x7f, 0x07, 0xb5, 0xc7, 0x6d, 0x5b, 0x9e, 0x9d,
			0x77, 0xd3, 0xb0, 0x3b, 0x69, 0xde, 0x2f, 0x21,
			0xce, 0xa9, 0x22, 0x8b, 0x06, 0xe5, 0x07, 0x50,
			0x98, 0xca, 0xc6, 0x0a, 0xc9, 0x5c, 0xe4, 0x77,
			0x6d, 0xed, 0xf9, 0x1f, 0xfd, 0xe3, 0x64, 0x37,
			0xea, 0xbb, 0x3d, 0xc6, 0x31, 0x4e, 0x8b, 0x06,
			0x30, 0x53, 0xb7, 0x0d, 0xb7, 0x26, 0x41, 0xac,
			0x63, 0xc8, 0xb2, 0x98, 0x27, 0x26, 0xd2, 0xc7,
			0x2c, 0x9e, 0x1a, 0x1d, 0xdb, 0xbf, 0x6c, 0x48,
			0x38, 0x50, 0x02, 0xe9, 0x71, 0x94, 0xa5, 0xf4,
			0xb6, 0xcd, 0x1f, 0x59, 0x4c, 0xff, 0xf2, 0xe4,
			0xdd, 0xf6, 0x4a, 0x61, 0x13, 0x8a, 0x31, 0x05,
			0x65, 0x22, 0x02, 0x09, 0x30, 0x77, 0x20, 0x98,
			0x09, 0x9b, 0xe7, 0xeb, 0x52, 0x39, 0xe3, 0xb3,
			0x0b, 0x1e, 0x40, 0xb7, 0xeb, 0xf8, 0x82, 0xbe,
			0xaf, 0x5e, 0x77, 0xaf, 0xb3, 0x11, 0x69, 0xf7,
		},
		/* S4 : 192 byte */
		{
			0x88, 0x14, 0xeb, 0x97, 0x4e, 0x33, 0x02, 0x7b,
			0x3e, 0xd4, 0x7c, 0xa9, 0xcb, 0xe7, 0x13, 0x5e,
			0x4a, 0xab, 0x75, 0x54, 0x7b, 0xe3, 0xb6, 0x61,
			0xbe, 0xc4, 0x8d, 0xd1, 0x5e, 0x13, 0xbf, 0x37,
			0x97, 0x68, 0x1e, 0x9a, 0x96, 0xc8, 0x3a, 0x40,
			0x9d, 0x46, 0x79, 0x6d, 0xec, 0xfa, 0x31, 0x55,
			0x25, 0x5a, 0xf5, 0xd5, 0x34, 0xd6, 0x60, 0x59,
			0x60, 0x66, 0xf8, 0x76, 0x11, 0x40, 0x8c, 0x93,
			0xc9, 0x0a, 0x40, 0x3e, 0x04, 0x8f, 0x0f, 0xfc,
			0x44, 0xd4, 0xb0, 0x79, 0xa9, 0x60, 0x00, 0x68,
			0x4c, 0x99, 0x8f, 0xdc, 0x82, 0xf6, 0x62, 0xe8,
			0x2d, 0xf7, 0x11, 0xb0, 0x57, 0xec, 0x7d, 0xe0,
			0x1b, 0x5f, 0x42, 0xf3, 0x48, 0xc0, 0xfb, 0x44,
			0x5d, 0x3f, 0xa8, 0xd8, 0x37, 0x3d, 0x0a, 0xd9,
			0xa5, 0x37, 0x18, 0x04, 0xd9, 0x99, 0xe7, 0x7b,
			0x6a, 0x69, 0x77, 0xfb, 0xa6, 0x5a, 0x6e, 0xca,
			0x76, 0xc4, 0xa8, 0x4a, 0xf4, 0xff, 0x38, 0x05,
			0x02, 0x0d, 0x6e, 0xd3, 0xdc, 0x5f, 0x75, 0xe1,
			0xae, 0x88, 0x97, 0x2d, 0xd7, 0x0c, 0x1c, 0x00,
			0x95, 0x6f, 0x39, 0xcd, 0x8b, 0x22, 0xe5, 0xfc,
			0x2a, 0x61, 0x3a, 0xa3, 0x64, 0xce, 0x45, 0xcd,
			0xfc, 0xdf, 0x02, 0xce, 0xe9, 0x09, 0xab, 0x0c,
			0x54, 0xea, 0x0e, 0xb1, 0x99, 0x7a, 0x8b, 0xc9,
			0x7d, 0x39, 0x9f, 0xa3, 0x62, 0x43, 0xa1, 0x62,
		},
	},
	/* SHA256 [5] */
	{
		/* Msg5 : 128 byte */
		{
			0x57, 0x67, 0x8a, 0x5b, 0xaa, 0x2b, 0x4a, 0x39,
			0xf8, 0xc3, 0x3f, 0x62, 0xa3, 0x97, 0x7f, 0xa9,
			0xf9, 0x51, 0x61, 0x16, 0xb6, 0x4a, 0x27, 0xf4,
			0xca, 0x41, 0xe1, 0x26, 0x5d, 0x53, 0x8e, 0xba,
			0x11, 0x27, 0x83, 0xc1, 0x87, 0x6a, 0x11, 0x5d,
			0x24, 0x7b, 0x62, 0x1b, 0x15, 0x67, 0xa4, 0x83,
			0x90, 0x17, 0x69, 0xee, 0x5d, 0xc8, 0x4e, 0x98,
			0x96, 0xbc, 0xdb, 0xf6, 0xab, 0x2f, 0xab, 0x4a,
			0xa8, 0x8d, 0xcd, 0x74, 0xbb, 0xe2, 0x69, 0x0b,
			0xf1, 0x92, 0xa7, 0xac, 0x40, 0x4a, 0xcc, 0x92,
			0xca, 0x36, 0xa7, 0x67, 0x60, 0x75, 0x2b, 0x5a,
			0x45, 0xca, 0x5d, 0x72, 0x35, 0x94, 0x71, 0x22,
			0xa6, 0x00, 0x2f, 0x1d, 0x4e, 0x7d, 0x9c, 0x6b,
			0xe5, 0x70, 0xd7, 0xbd, 0x2c, 0x29, 0x41, 0xfe,
			0x2e, 0x16, 0xe0, 0x2a, 0xc6, 0x37, 0x06, 0x63,
			0x61, 0xd2, 0x2d, 0x42, 0x05, 0x68, 0x26, 0x6b,
		},
		/* S5 : 192 byte */
		{
			0x56, 0x58, 0xd6, 0xba, 0xce, 0x6f, 0x80, 0xae,
			0x25, 0xff, 0x1c, 0xdd, 0xd8, 0x64, 0x3b, 0xfe,
			0x19, 0x7b, 0x76, 0x99, 0xed, 0xb3, 0x5a, 0x20,
			0x35, 0xfe, 0x32, 0x5d, 0x01, 0xe9, 0x7c, 0xff,
			0xa8, 0x94, 0xa2, 0xe9, 0x3c, 0x22, 0xb7, 0x7d,
			0xe7, 0x99, 0x53, 0x1f, 0x08, 0x12, 0xb4, 0x93,
			0x12, 0x24, 0xa7, 0xa5, 0xfb, 0xde, 0x30, 0x2b,
			0x11, 0x39, 0x7f, 0xd8, 0x80, 0x4f, 0xf4, 0x84,
			0x71, 0xbe, 0xb3, 0xc5, 0x0f, 0xf9, 0x0a, 0xbf,
			0x95, 0xd8, 0x0c, 0x3b, 0x13, 0x8d, 0x5a, 0xb3,
			0xa7, 0x91, 0x08, 0xfe, 0x5f, 0xf7, 0xc8, 0x9d,
			0x1a, 0xbe, 0x4b, 0xb9, 0x4c, 0xd4, 0x87, 0x5f,
			0xea, 0xf4, 0x38, 0x4f, 0x5c, 0x3c, 0x32, 0xff,
			0x31, 0x18, 0xb2, 0x00, 0x48, 0xd2, 0x47, 0x33,
			0x68, 0xbc, 0xfa, 0x5b, 0x30, 0x75, 0x60, 0x6d,
			0xca, 0x2e, 0x54, 0xff, 0x6e, 0x27, 0xf0, 0x04,
			0x57, 0xd6, 0xbc, 0x5b, 0x8f, 0x7c, 0x6c, 0x86,
			0x67, 0x5d, 0x47, 0xfa, 0x03, 0x2e, 0x7c, 0x39,
			0x5e, 0xda, 0x97, 0x7b, 0x84, 0x1c, 0xf2, 0xe7,
			0x20, 0x67, 0xd1, 0x28, 0x51, 0x13, 0xc5, 0x08,
			0x1f, 0x8d, 0x6b, 0x14, 0x65, 0x9e, 0xe1, 0xbf,
			0x49, 0xc7, 0x82, 0x14, 0xef, 0xdf, 0xd8, 0x66,
			0xed, 0x4d, 0x2c, 0x0f, 0x72, 0xca, 0x66, 0x1a,
			0x59, 0x84, 0x4a, 0x9f, 0x83, 0xc3, 0x96, 0x6f,
		},
	},
	/* SHA256 [6] */
	{
		/* Msg6 : 128 byte */
		{
			0x15, 0xb1, 0xe0, 0x7d, 0x9a, 0x1b, 0xfe, 0x53,
			0xc7, 0xbe, 0xcf, 0xed, 0x15, 0xc7, 0x21, 0xef,
			0x60, 0x2b, 0x64, 0x1d, 0x33, 0xdd, 0x0c, 0x29,
			0x46, 0x44, 0x37, 0xc8, 0x45, 0xec, 0x90, 0x0b,
			0xd3, 0x7c, 0x73, 0xed, 0xcf, 0xe8, 0x52, 0x29,
			0xd6, 0xe7, 0x57, 0x4e, 0x09, 0xa8, 0x4a, 0x14,
			0x10, 0xc0, 0xb6, 0xf1, 0x5f, 0x68, 0x47, 0xe8,
			0xb7, 0xe5, 0x77, 0xa2, 0xf0, 0x47, 0x69, 0xbf,
			0xf7, 0x56, 0x15, 0x6e, 0x13, 0xca, 0xa6, 0x3b,
			0x6c, 0xba, 0x20, 0x29, 0xcd, 0x57, 0x46, 0x01,
			0xa9, 0xda, 0xbb, 0xe9, 0x5c, 0xbb, 0x67, 0x38,
			0xb4, 0x24, 0x1c, 0x89, 0xb0, 0xa5, 0x7a, 0x0f,
			0x87, 0x29, 0x10, 0x28, 0xec, 0x29, 0xc3, 0x34,
			0x91, 0x1f, 0x74, 0xa7, 0xea, 0x3e, 0xdd, 0x5d,
			0x33, 0x60, 0xbc, 0x2e, 0xb4, 0x40, 0x34, 0xc3,
			0x44, 0xe9, 0x70, 0xa7, 0x0c, 0x6e, 0x89, 0xa1,
		},
		/* S6 : 192 byte */
		{
			0x4a, 0x5b, 0x9a, 0xf9, 0xc1, 0x2d, 0x40, 0x41,
			0x77, 0x50, 0x70, 0xe6, 0xf2, 0xb1, 0xd8, 0xb5,
			0xa3, 0xc7, 0xb4, 0x96, 0x6e, 0xce, 0x2c, 0xdf,
			0x60, 0x31, 0xe9, 0xaf, 0x8a, 0x86, 0x07, 0xad,
			0x5d, 0x3a, 0x79, 0x03, 0x26, 0x3c, 0x94, 0x67,
			0xa3, 0xe0, 0x99, 0xd2, 0xd9, 0x37, 0xf8, 0x11,
			0x11, 0x64, 0xee, 0x8a, 0xd3, 0xb0, 0xb8, 0xd4,
			0xb7, 0x86, 0x2b, 0x26, 0x78, 0xdf, 0x2b, 0xb7,
			0x65, 0xdd, 0x03, 0x37, 0x55, 0x91, 0xd9, 0x02,
			0x65, 0xd1, 0x36, 0xed, 0xab, 0x69, 0x51, 0x8b,
			0x33, 0xbb, 0xed, 0x38, 0x9c, 0x77, 0x46, 0x86,
			0x9e, 0x59, 0x8f, 0x82, 0x96, 0x58, 0x51, 0xd1,
			0x6b, 0x3d, 0x8b, 0x7c, 0x4f, 0x83, 0xd0, 0x73,
			0xc5, 0x8e, 0xf3, 0x36, 0x01, 0x12, 0xe5, 0xa7,
			0x75, 0xdf, 0xd0, 0xa3, 0x43, 0x3f, 0xfe, 0x72,
			0xdf, 0x03, 0x01, 0x45, 0x96, 0x9a, 0xca, 0xf0,
			0x7f, 0xfb, 0x98, 0x74, 0x30, 0x4c, 0x1f, 0xf2,
			0x0e, 0x4d, 0xf0, 0x2b, 0x94, 0x36, 0xcc, 0x03,
			0xdb, 0xb4, 0x85, 0x95, 0x5e, 0xeb, 0x7b, 0x6a,
			0x02, 0x66, 0x5f, 0x61, 0xed, 0xcc, 0x22, 0xfd,
			0x90, 0x8a, 0x0e, 0xa8, 0xfa, 0x61, 0xb9, 0xae,
			0x52, 0xa3, 0x46, 0xa6, 0x91, 0x82, 0x8c, 0x9c,
			0xcb, 0xe8, 0xd1, 0x2f, 0x38, 0x9f, 0x6a, 0xff,
			0x37, 0xbb, 0xd9, 0xcd, 0x0f, 0xfb, 0x8c, 0x1b,
		},
	},
	/* SHA256 [7] */
	{
		/* Msg7 : 128 byte */
		{
			0x50, 0xb0, 0xb8, 0xda, 0xb5, 0x92, 0x1f, 0xbb,
			0x12, 0xb8, 0x35, 0x22, 0x20, 0x08, 0x16, 0x4e,
			0x6d, 0xe9, 0x5b, 0x04, 0xff, 0x58, 0xe0, 0x3d,
			0x3a, 0x39, 0xcb, 0x1c, 0x04, 0xea, 0xc9, 0x22,
			0x26, 0x1e, 0x9b, 0xa5, 0xf5, 0xe9, 0xd2, 0x7e,
			0x33, 0x17, 0xd6, 0x03, 0x30, 0xc2, 0x2d, 0x35,
			0x34, 0x24, 0xfa, 0x3a, 0x21, 0xa9, 0xc4, 0x0d,
			0x55, 0x48, 0x79, 0x74, 0xce, 0x14, 0xb3, 0x32,
			0x91, 0x0e, 0x39, 0x7e, 0x4c, 0x3e, 0xc9, 0xb5,
			0x3a, 0x02, 0x15, 0x4c, 0x47, 0xa5, 0x0b, 0x08,
			0x75, 0x33, 0x59, 0x71, 0x7e, 0x8c, 0x31, 0x84,
			0xbb, 0xb8, 0x49, 0xa8, 0x44, 0x7a, 0x27, 0xe3,
			0x59, 0x28, 0x9b, 0x4e, 0x00, 0xb9, 0x8d, 0xc6,
			0xf0, 0x20, 0xf8, 0xe5, 0xae, 0xd9, 0x37, 0x30,
			0xf6, 0xc1, 0x80, 0x92, 0x5c, 0x2a, 0xae, 0x0a,
			0x33, 0x2f, 0x43, 0xa0, 0xae, 0x45, 0xad, 0x9d,
		},
		/* S7 : 192 byte */
		{
			0x2c, 0xd9, 0xc7, 0xf5, 0x55, 0xf8, 0x4e, 0x77,
			0xaa, 0xa5, 0x44, 0xab, 0x5f, 0xce, 0x57, 0xa0,
			0x19, 0x51, 0x9e, 0x09, 0x4d, 0x1c, 0x76, 0x28,
			0x32, 0xfb, 0xf9, 0x40, 0x25, 0x98, 0x33, 0xf1,
			0x26, 0x53, 0x1f, 0x47, 0x58, 0x27, 0x8d, 0x3b,
			0x24, 0xcb, 0x43, 0x88, 0x16, 0xcc, 0x9c, 0x0c,
			0x1b, 0x80, 0x3d, 0x90, 0x53, 0x39, 0x14, 0xc2,
			0x0e, 0x73, 0x29, 0xd9, 0x2c, 0x0c, 0xbb, 0xb8,
			0x7b, 0xd4, 0xc1, 0x6d, 0x1f, 0x1f, 0x0b, 0x9a,
			0xbe, 0xe5, 0x39, 0xb7, 0xaf, 0xf3, 0x50, 0xc1,
			0xa4, 0xd6, 0x5d, 0x29, 0xe8, 0x0f, 0x77, 0x65,
			0xba, 0x09, 0xf2, 0x0d, 0x8f, 0xab, 0xdd, 0x1f,
			0x7a, 0xd7, 0xfe, 0xaf, 0x41, 0x91, 0x15, 0x7d,
			0xc7, 0x61, 0x7b, 0x17, 0xb0, 0x32, 0x5b, 0x1d,
			0x9f, 0xd5, 0x1d, 0x2b, 0x7e, 0x0b, 0xe5, 0xd0,
			0xc0, 0x0b, 0x15, 0x78, 0x71, 0x07, 0x94, 0x90,
			0x76, 0x89, 0xca, 0xd4, 0x6b, 0xfa, 0x7b, 0xe9,
			0x5b, 0xc7, 0xad, 0x92, 0xde, 0x5e, 0xad, 0xd5,
			0xd9, 0x71, 0x68, 0x98, 0xcd, 0xc3, 0x09, 0xc2,
			0x6e, 0x8e, 0xc7, 0x96, 0x7b, 0x71, 0x37, 0xde,
			0x73, 0xa5, 0x74, 0x2c, 0x1a, 0x4b, 0x55, 0xad,
			0xa7, 0x70, 0x0d, 0x47, 0x0e, 0xcf, 0x87, 0x27,
			0xb2, 0x7d, 0x3b, 0xe9, 0xd6, 0xc0, 0x6e, 0xf4,
			0x4f, 0x6a, 0x19, 0x67, 0x1b, 0x53, 0xd0, 0xfb,
		},
	},
	/* SHA256 [8] */
	{
		/* Msg8 : 128 byte */
		{
			0x55, 0x11, 0xc2, 0xb0, 0xd2, 0xdf, 0xd2, 0x59,
			0x92, 0xad, 0x78, 0x73, 0x5f, 0x32, 0x63, 0x82,
			0xff, 0x2b, 0x2a, 0x53, 0x59, 0xf4, 0x8e, 0x32,
			0xda, 0x55, 0x00, 0x5e, 0x17, 0x9e, 0x63, 0xba,
			0xb4, 0xf6, 0x12, 0xc5, 0x84, 0xf0, 0x25, 0xcc,
			0xf1, 0x5f, 0xf0, 0x5f, 0x9f, 0x6c, 0xcd, 0x01,
			0x4c, 0xe5, 0x1c, 0x23, 0xfb, 0xd8, 0x87, 0x54,
			0x51, 0x61, 0x8b, 0xb2, 0x3f, 0xc0, 0x33, 0xa4,
			0xe1, 0xae, 0x27, 0xcb, 0xa6, 0xf2, 0xe6, 0x35,
			0xb2, 0x2f, 0x50, 0xd4, 0x80, 0x00, 0x67, 0x2f,
			0xcc, 0x46, 0x56, 0x58, 0xb0, 0xc1, 0xb3, 0x1e,
			0x0d, 0xde, 0x01, 0x83, 0x2c, 0xd0, 0x79, 0x71,
			0xa5, 0xe2, 0x0a, 0xa8, 0x80, 0x0c, 0x9e, 0xfb,
			0x9b, 0xc4, 0x9f, 0xbc, 0x4b, 0x16, 0xb9, 0x75,
			0x46, 0xf7, 0xe2, 0xd8, 0xc1, 0xd7, 0x98, 0xf9,
			0xd5, 0x75, 0x6a, 0xbb, 0x27, 0xf7, 0xba, 0x88,
		},
		/* S8 : 192 byte */
		{
			0x11, 0x7b, 0x98, 0x7b, 0x4c, 0x79, 0xfe, 0x56,
			0x9b, 0xb0, 0x03, 0x1c, 0xb6, 0x3e, 0xc6, 0x10,
			0xb9, 0xfc, 0x4d, 0xa8, 0xae, 0x05, 0xb2, 0x0c,
			0xa2, 0xfd, 0x06, 0x08, 0xc6, 0xc8, 0x96, 0x7b,
			0xaf, 0x7f, 0xd3, 0x4f, 0xc4, 0x5e, 0xf9, 0xe4,
			0x53, 0x20, 0x13, 0xa0, 0xa3, 0x50, 0x2e, 0x60,
			0x85, 0x44, 0xa6, 0x3a, 0x5e, 0x21, 0x81, 0x09,
			0xe5, 0x85, 0x68, 0xcc, 0xc2, 0xbe, 0xdc, 0xe3,
			0xb4, 0x8c, 0x0f, 0xdf, 0x47, 0x48, 0xb0, 0xba,
			0x4b, 0x4b, 0xf5, 0x69, 0xd8, 0xe9, 0xc5, 0x02,
			0x31, 0xbc, 0xb0, 0xca, 0xba, 0x31, 0xe3, 0x2b,
			0x2c, 0xf8, 0xd5, 0x7e, 0xdd, 0xa8, 0xbf, 0x97,
			0x70, 0x70, 0x5f, 0xa0, 0x72, 0xcf, 0xcb, 0xf0,
			0x35, 0x59, 0x79, 0x08, 0x0d, 0x8e, 0x72, 0x91,
			0x17, 0x92, 0x46, 0xf1, 0xbe, 0x59, 0xa4, 0xd7,
			0x78, 0x6e, 0x8d, 0xbc, 0x54, 0x85, 0x98, 0xd8,
			0xfc, 0xb3, 0xab, 0x29, 0x3c, 0x95, 0xb9, 0xc8,
			0x97, 0xd4, 0xfe, 0x28, 0x5c, 0xe6, 0x86, 0x3f,
			0x1e, 0xb9, 0x0e, 0x95, 0x3f, 0xea, 0x9a, 0x36,
			0xd6, 0xa5, 0xb3, 0x59, 0xf0, 0x8d, 0x35, 0xa8,
			0x85, 0x49, 0x25, 0x94, 0x0a, 0xa0, 0x6f, 0xec,
			0x66, 0x17, 0x65, 0x49, 0xe7, 0x9d, 0xc9, 0x90,
			0x54, 0xbe, 0x00, 0xf0, 0xbd, 0x92, 0x11, 0x78,
			0x2d, 0xe7, 0xa3, 0x39, 0x27, 0x40, 0x68, 0x4d,
		},
	},
	/* SHA256 [9] */
	{
		/* Msg9 : 128 byte */
		{
			0x67, 0x56, 0x73, 0x51, 0x45, 0x2f, 0xd3, 0xae,
			0xfc, 0xe4, 0x67, 0x1f, 0x63, 0xc1, 0xd5, 0x03,
			0x6d, 0xc1, 0xc0, 0xbf, 0xfb, 0x0c, 0x3f, 0x62,
			0xf4, 0xbe, 0x8e, 0x85, 0x98, 0xea, 0x04, 0x76,
			0x11, 0xdf, 0x45, 0x95, 0x4b, 0xa9, 0xb9, 0xfd,
			0x06, 0xdb, 0x3d, 0x67, 0x2a, 0x8c, 0x18, 0x4c,
			0x5a, 0xa0, 0x30, 0x4a, 0xcb, 0x49, 0x7e, 0xc9,
			0x57, 0xcc, 0xbf, 0xde, 0xcd, 0x89, 0x6c, 0x70,
			0x8c, 0x36, 0xed, 0x99, 0x50, 0x6b, 0x0a, 0x4e,
			0x4b, 0x63, 0xa2, 0x43, 0x78, 0x01, 0x9f, 0x09,
			0x2c, 0x11, 0x29, 0x79, 0xee, 0xd1, 0x1a, 0x56,
			0x88, 0xaf, 0xb2, 0x2e, 0x5e, 0x55, 0x8d, 0x81,
			0xff, 0xe3, 0xd1, 0x26, 0xfa, 0x7b, 0xac, 0xe9,
			0xf3, 0x03, 0xfe, 0x79, 0xf5, 0x26, 0x52, 0x82,
			0x0a, 0x9c, 0x13, 0x16, 0x09, 0xac, 0xfd, 0x51,
			0xb0, 0xef, 0xd1, 0x3d, 0xf2, 0x56, 0x4d, 0xf3,
		},
		/* S9 : 192 byte */
		{
			0x2b, 0xc0, 0xa0, 0x94, 0x93, 0xa5, 0x7b, 0x56,
			0xa5, 0xec, 0x1e, 0x3b, 0x47, 0x33, 0x45, 0x0e,
			0x06, 0xbc, 0x64, 0x64, 0x4b, 0x3a, 0x9c, 0x3a,
			0xf8, 0x6b, 0x30, 0x86, 0x60, 0x22, 0x70, 0x2f,
			0x1d, 0x01, 0x8b, 0x4f, 0x56, 0x25, 0x4e, 0x74,
			0xfd, 0x99, 0x78, 0x77, 0xdb, 0x8a, 0x86, 0x83,
			0xb2, 0xfe, 0x15, 0x71, 0xf4, 0x94, 0xac, 0xe3,
			0xa7, 0x64, 0x8f, 0xd9, 0x40, 0xb9, 0x57, 0xb0,
			0xb7, 0xe9, 0x83, 0x83, 0xb9, 0xd4, 0x2f, 0xa5,
			0xb4, 0x85, 0x28, 0xdf, 0x65, 0x34, 0x89, 0xec,
			0xbf, 0x7f, 0x92, 0xaf, 0x73, 0x85, 0xda, 0x03,
			0xaf, 0x27, 0x47, 0x5d, 0xb8, 0x72, 0xc6, 0x27,
			0x3f, 0x2c, 0xc7, 0x97, 0x62, 0xb0, 0x5e, 0xe0,
			0xab, 0x2a, 0xef, 0xbb, 0x68, 0x2a, 0x0d, 0x41,
			0x56, 0x14, 0xde, 0x31, 0x37, 0x0a, 0xaa, 0x26,
			0x34, 0x48, 0x0f, 0x5c, 0xa7, 0xba, 0x0e, 0x50,
			0x3b, 0x45, 0xd4, 0x4c, 0x31, 0xf5, 0x64, 0x02,
			0xfd, 0x58, 0xba, 0xcf, 0x34, 0x44, 0x0a, 0x26,
			0xbc, 0xb0, 0xf8, 0xdc, 0x18, 0x7d, 0x77, 0x61,
			0xe4, 0xcf, 0xcc, 0x17, 0xc7, 0x8a, 0xdc, 0xaf,
			0x0c, 0x54, 0xa1, 0x0f, 0xf6, 0x97, 0x7d, 0xef,
			0x47, 0x7b, 0xef, 0xeb, 0x9a, 0x85, 0xaa, 0xc6,
			0x45, 0x55, 0x36, 0x9c, 0x11, 0x31, 0x9b, 0x0c,
			0x97, 0xcb, 0xfc, 0x5e, 0x47, 0x41, 0xdd, 0x0f,
		},
	},
};

/* 10 elements */
static mod1536_t SHA384[] = {
	/* SHA384 [0] */
	{
		/* Msg0 : 128 byte */
		{
			0x37, 0xd7, 0xfe, 0xe3, 0xd3, 0x19, 0x34, 0x91,
			0x21, 0x67, 0xe1, 0xff, 0xb3, 0x5b, 0x4b, 0x2f,
			0x15, 0x9e, 0x84, 0xbd, 0x02, 0x51, 0x3d, 0x65,
			0xd8, 0xab, 0xdb, 0xc4, 0x4a, 0xe3, 0xcd, 0x63,
			0x55, 0x50, 0x1c, 0xf1, 0x75, 0xcf, 0x43, 0xd0,
			0x18, 0x65, 0x42, 0xd4, 0x53, 0x25, 0xee, 0x47,
			0xd4, 0x54, 0x8b, 0x30, 0x18, 0xcc, 0x9c, 0xd4,
			0xde, 0x9e, 0xfa, 0x7e, 0xdb, 0xfb, 0x24, 0x7c,
			0xaf, 0x55, 0xd6, 0x6a, 0x18, 0xc1, 0xdd, 0xb3,
			0x65, 0xa0, 0x29, 0x54, 0x2e, 0x7e, 0x24, 0xe3,
			0x43, 0x3a, 0x42, 0xd0, 0xe2, 0x67, 0xd9, 0xec,
			0x2d, 0xf3, 0x34, 0x27, 0xda, 0x06, 0xe3, 0x9e,
			0x2d, 0x2d, 0x54, 0xd5, 0x23, 0xb8, 0xa8, 0x40,
			0xf1, 0x61, 0xbf, 0x09, 0xac, 0x2e, 0x95, 0x0d,
			0x4a, 0x98, 0xd2, 0x28, 0xc9, 0xec, 0x9c, 0xb2,
			0xae, 0xf2, 0xb0, 0x49, 0xb1, 0xcd, 0xb1, 0xd1,
		},
		/* S0 : 192 byte */
		{
			0x7f, 0xbe, 0x7b, 0xf0, 0xb9, 0xee, 0xf0, 0xdc,
			0x76, 0x34, 0x60, 0x6c, 0xed, 0xf5, 0x5f, 0xda,
			0xc9, 0xe6, 0xd6, 0x54, 0xd6, 0xe7, 0xe1, 0xe8,
			0x3a, 0x77, 0x6d, 0x8e, 0x4f, 0x58, 0x5f, 0x59,
			0xfa, 0xd1, 0x2d, 0xdf, 0xb1, 0xd0, 0x80, 0x56,
			0x79, 0x49, 0x7d, 0xdd, 0xdb, 0x83, 0x4b, 0x24,
			0x8c, 0xbb, 0xf7, 0x60, 0xa3, 0x52, 0xae, 0x53,
			0x45, 0x3b, 0xc3, 0x02, 0x6f, 0xe7, 0x69, 0x4b,
			0xf1, 0x53, 0xc4, 0xe1, 0x2b, 0xa0, 0x7e, 0xb5,
			0xbc, 0x0f, 0x9c, 0x65, 0x03, 0x8b, 0xb5, 0xd7,
			0x23, 0x68, 0xbb, 0xaf, 0x23, 0xdd, 0xd4, 0xc1,
			0xda, 0x6a, 0x92, 0x03, 0xcb, 0x51, 0xcb, 0x7e,
			0x2b, 0x9e, 0xfb, 0x5b, 0x5b, 0xaf, 0xa9, 0x27,
			0x88, 0x5b, 0x49, 0xf4, 0x79, 0x70, 0x8a, 0xae,
			0x9f, 0x77, 0x0e, 0xea, 0x2e, 0x5f, 0x8a, 0xd4,
			0x05, 0x0e, 0xdd, 0x68, 0x6c, 0xab, 0x35, 0x56,
			0x9d, 0x27, 0xc0, 0x0d, 0x45, 0xc2, 0x1b, 0x5a,
			0xec, 0xf2, 0xd9, 0x46, 0x48, 0x40, 0x44, 0x31,
			0x8c, 0x89, 0x09, 0x11, 0x5c, 0x23, 0x3c, 0x9a,
			0xf8, 0x52, 0x7a, 0x9d, 0x9d, 0xb4, 0x0b, 0x8d,
			0xcb, 0xa3, 0x28, 0x18, 0x77, 0x75, 0x18, 0x45,
			0xb4, 0xc2, 0x77, 0x59, 0x68, 0xb0, 0x4e, 0xd8,
			0x13, 0xa7, 0xa0, 0x3d, 0x99, 0xd9, 0x0f, 0xc1,
			0x40, 0x80, 0x78, 0xbd, 0x60, 0xaa, 0xb4, 0x80,
		},
	},
	/* SHA384 [1] */
	{
		/* Msg1 : 128 byte */
		{
			0x15, 0x75, 0x0e, 0x41, 0x1e, 0xd6, 0xb1, 0x48,
			0x7e, 0x9b, 0xfa, 0xe9, 0x6a, 0xaf, 0x75, 0x8f,
			0x6c, 0x05, 0x9c, 0xe1, 0x66, 0x8a, 0xf8, 0x4f,
			0xd4, 0x58, 0x89, 0xeb, 0x51, 0x2c, 0x68, 0x7b,
			0x5d, 0x1a, 0xab, 0xcc, 0x5d, 0x7f, 0x89, 0x49,
			0xe3, 0x38, 0xbf, 0xcb, 0x30, 0x11, 0x31, 0xb3,
			0xf7, 0x80, 0xd5, 0x37, 0x64, 0x94, 0xcd, 0xf9,
			0x5d, 0x28, 0xd3, 0xde, 0x08, 0x5c, 0xda, 0x1d,
			0x8d, 0x46, 0xf2, 0x96, 0x1d, 0xe4, 0x6d, 0x66,
			0x33, 0x55, 0x40, 0xb8, 0x19, 0x49, 0xac, 0xdd,
			0xaf, 0xb7, 0x1d, 0xa0, 0x68, 0xce, 0x52, 0xd3,
			0x95, 0x2d, 0xbe, 0x2e, 0xe6, 0x56, 0x2e, 0x5a,
			0x2d, 0x60, 0xad, 0x48, 0x66, 0xed, 0xa4, 0xc7,
			0xf5, 0x5c, 0x46, 0x56, 0x2e, 0x40, 0x2b, 0x36,
			0x1a, 0x10, 0x3b, 0xc4, 0x78, 0x20, 0xce, 0x06,
			0x03, 0xcf, 0x12, 0x84, 0xf3, 0x02, 0xac, 0x59,
		},
		/* S1 : 192 byte */
		{
			0x38, 0x32, 0xd9, 0x37, 0x2c, 0xcb, 0xc0, 0xe7,
			0x0c, 0x20, 0x3e, 0x46, 0xeb, 0xc7, 0xdf, 0x8b,
			0x47, 0xde, 0x57, 0xa5, 0x39, 0xa3, 0x44, 0x90,
			0xd1, 0x01, 0x27, 0x9b, 0x99, 0x01, 0x77, 0x54,
			0xe9, 0x73, 0xd9, 0x2d, 0x07, 0x35, 0x9c, 0x3d,
			0x86, 0x94, 0x70, 0x4b, 0x66, 0x14, 0xe9, 0x72,
			0x91, 0xbe, 0x4e, 0xbe, 0x74, 0xdb, 0x19, 0xa9,
			0x67, 0x49, 0x26, 0x1f, 0x5b, 0xb0, 0xab, 0x7f,
			0x9a, 0xc4, 0x2b, 0x04, 0x18, 0xba, 0x8d, 0x24,
			0x18, 0xf4, 0x98, 0xf9, 0x26, 0x6e, 0x5a, 0xfd,
			0x43, 0x25, 0x5f, 0x55, 0xe0, 0x4f, 0xf7, 0x13,
			0xde, 0x11, 0xf4, 0xa4, 0x30, 0x28, 0xa2, 0xca,
			0x12, 0x75, 0xc7, 0xc7, 0x8b, 0xf4, 0xd3, 0x6e,
			0x22, 0x4d, 0xe0, 0xc5, 0x50, 0x18, 0x48, 0xfa,
			0x08, 0xef, 0xcb, 0xc7, 0x48, 0x80, 0x18, 0xef,
			0xec, 0x4a, 0x49, 0x28, 0x92, 0xcd, 0xdf, 0xd3,
			0x3b, 0x96, 0x03, 0x86, 0xf1, 0xf8, 0x56, 0x25,
			0x3a, 0x11, 0xa0, 0xe5, 0x26, 0xce, 0xba, 0x41,
			0x7f, 0xfa, 0xde, 0x4a, 0xbd, 0xdb, 0x4e, 0x54,
			0x79, 0xe6, 0x23, 0xbd, 0x3f, 0xa2, 0x47, 0xd9,
			0x8d, 0x20, 0x01, 0xb5, 0x51, 0x8f, 0x75, 0x65,
			0x45, 0xd0, 0x69, 0x0e, 0xc9, 0x13, 0x04, 0xde,
			0xb0, 0xe1, 0xf3, 0xb8, 0x54, 0xe3, 0xe1, 0x27,
			0x32, 0x00, 0xbf, 0x67, 0x73, 0x5c, 0xca, 0x15,
		},
	},
	/* SHA384 [2] */
	{
		/* Msg2 : 128 byte */
		{
			0x36, 0x9d, 0x20, 0xe1, 0x6d, 0x4a, 0x65, 0x74,
			0xd4, 0xf9, 0xee, 0x51, 0x11, 0x06, 0xbc, 0x49,
			0x42, 0x68, 0xf7, 0xb5, 0xee, 0xd9, 0x82, 0xb7,
			0x3b, 0x38, 0xd3, 0xc2, 0x62, 0x2b, 0x02, 0x5c,
			0x61, 0x08, 0x1f, 0x22, 0xf0, 0xf6, 0xc9, 0x0d,
			0xb5, 0x4f, 0xfc, 0xf5, 0xbb, 0x49, 0x2b, 0x53,
			0x21, 0xd6, 0x8f, 0x4b, 0x0f, 0xc8, 0xbe, 0xea,
			0xee, 0x39, 0x7f, 0xac, 0xd9, 0x2a, 0xdd, 0x41,
			0x4e, 0x6a, 0x7a, 0x90, 0x2a, 0xba, 0x26, 0xfd,
			0xd4, 0x2e, 0xb0, 0xe7, 0xb8, 0xd6, 0xfc, 0x75,
			0xf7, 0x9e, 0x56, 0x93, 0x5c, 0x73, 0x06, 0x37,
			0x93, 0xa7, 0x25, 0xe9, 0x95, 0x97, 0xaf, 0x82,
			0x67, 0x8b, 0xd9, 0x34, 0x04, 0xdd, 0xa4, 0xca,
			0x98, 0x5e, 0xb2, 0x31, 0xee, 0xf5, 0x58, 0x38,
			0x2c, 0x89, 0xf6, 0x94, 0xbe, 0x21, 0x83, 0x27,
			0x90, 0x4a, 0x6c, 0x82, 0x80, 0xba, 0x9f, 0xa8,
		},
		/* S2 : 192 byte */
		{
			0x0e, 0x29, 0x6e, 0x48, 0x21, 0xf1, 0xba, 0x34,
			0x98, 0x10, 0x00, 0xbc, 0x92, 0xe5, 0xda, 0xc9,
			0xbb, 0x0c, 0x9b, 0x58, 0x54, 0x35, 0x2a, 0xdb,
			0x8b, 0x3f, 0x5b, 0x2c, 0xe7, 0x9d, 0x31, 0xec,
			0x16, 0xb5, 0x6a, 0x9b, 0xd1, 0xe1, 0xf3, 0x38,
			0x50, 0xa3, 0x10, 0x0b, 0xec, 0x1d, 0xfa, 0x58,
			0x71, 0xc2, 0xc1, 0x8a, 0x83, 0x34, 0x99, 0xc7,
			0x34, 0x6b, 0x52, 0x6c, 0xa7, 0x9f, 0x8f, 0x55,
			0x12, 0x74, 0x59, 0x89, 0xd0, 0x86, 0x31, 0x44,
			0x38, 0xd4, 0x66, 0xec, 0x57, 0xb4, 0x07, 0xbc,
			0xf6, 0xe9, 0xd7, 0x08, 0xe7, 0x85, 0x8f, 0x14,
			0x16, 0x19, 0x59, 0x12, 0xa4, 0x4c, 0x66, 0x1f,
			0x4d, 0xa3, 0x56, 0x9a, 0xd8, 0x55, 0xd7, 0x49,
			0xbd, 0xcf, 0x35, 0xde, 0x35, 0x3b, 0x10, 0xc0,
			0x5e, 0x13, 0x89, 0x43, 0x87, 0xd0, 0x4c, 0x7c,
			0x24, 0x1f, 0x0e, 0x5e, 0xee, 0x57, 0x9b, 0xb1,
			0x56, 0x4e, 0x19, 0xba, 0x61, 0xd8, 0xba, 0x69,
			0xc0, 0x05, 0x8e, 0x63, 0x7f, 0x71, 0x9f, 0xc8,
			0x67, 0xc5, 0x14, 0x68, 0x52, 0x70, 0x27, 0x2e,
			0x73, 0xe6, 0xd7, 0x86, 0x2f, 0x88, 0x8b, 0x97,
			0x4e, 0xa9, 0xd5, 0xf2, 0x52, 0x14, 0x2c, 0x92,
			0x05, 0x37, 0x5c, 0x9a, 0x37, 0x5d, 0x73, 0x1f,
			0x10, 0x0c, 0x18, 0x78, 0x47, 0xb2, 0x90, 0xe9,
			0xb2, 0x5b, 0xb6, 0xf8, 0x82, 0xb1, 0x11, 0x14,
		},
	},
	/* SHA384 [3] */
	{
		/* Msg3 : 128 byte */
		{
			0x1f, 0x75, 0xef, 0x43, 0x71, 0x17, 0x83, 0x56,
			0x08, 0x1e, 0x4b, 0xab, 0x44, 0xfc, 0x3c, 0x70,
			0x6a, 0x70, 0x6f, 0x6e, 0xec, 0xb5, 0x80, 0xe0,
			0xeb, 0xf9, 0x34, 0x85, 0xfa, 0x10, 0x5e, 0xf4,
			0x25, 0x6a, 0x03, 0x30, 0x32, 0x42, 0xbc, 0x7c,
			0x26, 0x19, 0x5c, 0x70, 0x0b, 0x63, 0xd3, 0x4d,
			0xf1, 0x80, 0x52, 0x8e, 0x33, 0xed, 0xb0, 0xbf,
			0xfb, 0xbc, 0x0d, 0x92, 0x08, 0x41, 0xb5, 0x30,
			0xaf, 0x0f, 0x46, 0xcd, 0x20, 0x23, 0x16, 0x7f,
			0xeb, 0x5e, 0xcf, 0x50, 0xc3, 0x39, 0x5c, 0x92,
			0x81, 0xb4, 0x09, 0x72, 0x6c, 0x8f, 0xe5, 0xd0,
			0xb7, 0xbd, 0x6b, 0x4e, 0x4b, 0x16, 0x62, 0xa7,
			0xc7, 0x4c, 0x02, 0x43, 0xc5, 0x20, 0x58, 0x08,
			0x60, 0xd5, 0xec, 0x72, 0xf3, 0xe5, 0xa0, 0xe6,
			0x22, 0xf4, 0xdb, 0x43, 0x1f, 0x02, 0xe7, 0xbb,
			0x26, 0xe4, 0x98, 0xe1, 0x4a, 0xf5, 0x2f, 0x02,
		},
		/* S3 : 192 byte */
		{
			0x4b, 0xc7, 0x82, 0x03, 0x1a, 0x32, 0x88, 0x67,
			0x27, 0x15, 0x66, 0x98, 0x46, 0x98, 0x4e, 0x87,
			0x42, 0x8e, 0x22, 0x62, 0xc0, 0x66, 0xc4, 0x51,
			0x02, 0x37, 0x49, 0x1f, 0xa3, 0x5f, 0x7c, 0xa5,
			0xc9, 0x00, 0xf1, 0xbb, 0x5c, 0x0e, 0x53, 0x91,
			0x48, 0x9c, 0x51, 0xa1, 0x40, 0xd9, 0xd2, 0xa1,
			0x3b, 0x29, 0x7c, 0xea, 0xf1, 0x4b, 0x1b, 0x4b,
			0x04, 0xab, 0xa0, 0xf6, 0x94, 0x38, 0x01, 0x97,
			0x6d, 0x66, 0x37, 0x03, 0x34, 0xdc, 0xe5, 0x4d,
			0x08, 0xdf, 0x08, 0x13, 0xa5, 0xd9, 0xeb, 0x5e,
			0xce, 0xa6, 0xe9, 0xcf, 0xd7, 0xb2, 0x29, 0xc1,
			0x0a, 0x44, 0x40, 0xb7, 0xad, 0x29, 0xb1, 0xa4,
			0xe9, 0x61, 0x48, 0xfb, 0x60, 0xfa, 0x01, 0x17,
			0xc7, 0x03, 0xa7, 0x6b, 0x9b, 0xc4, 0x84, 0xaf,
			0x00, 0xa2, 0x89, 0x89, 0xf8, 0x40, 0xa2, 0x4b,
			0x8e, 0xf2, 0x8d, 0x5b, 0xf4, 0xc9, 0x8d, 0x0b,
			0x8e, 0x00, 0xef, 0x56, 0xef, 0x5f, 0x57, 0x4f,
			0xae, 0x05, 0xda, 0x3d, 0xd7, 0xa4, 0x47, 0x06,
			0x11, 0x21, 0xd8, 0x04, 0x44, 0x8e, 0x3e, 0x7d,
			0xad, 0x8e, 0xf9, 0x5a, 0x4f, 0x2d, 0x71, 0x74,
			0xf5, 0x40, 0x48, 0xa2, 0xb4, 0x2a, 0xdd, 0x71,
			0xeb, 0x91, 0x30, 0xde, 0x8f, 0x83, 0xd7, 0xd8,
			0xf4, 0x9b, 0x6d, 0x80, 0x29, 0xcd, 0x13, 0xb2,
			0xe6, 0x65, 0x89, 0x18, 0xca, 0x50, 0xfe, 0x49,
		},
	},
	/* SHA384 [4] */
	{
		/* Msg4 : 128 byte */
		{
			0x82, 0x03, 0x7e, 0xc6, 0xb8, 0xb2, 0xc7, 0x2e,
			0xf7, 0xcf, 0x1c, 0x67, 0xe4, 0x80, 0xdf, 0xdb,
			0x90, 0xa2, 0x49, 0x6f, 0x9d, 0x5e, 0xae, 0xb7,
			0xa3, 0xfd, 0x02, 0x65, 0xd1, 0xfd, 0x9d, 0x08,
			0xd8, 0x64, 0x3b, 0xf3, 0x04, 0x54, 0x47, 0x7a,
			0xac, 0xe0, 0x59, 0x65, 0xcd, 0x1e, 0xfd, 0x9e,
			0xf2, 0x7d, 0xb6, 0x2d, 0x57, 0x59, 0x42, 0x66,
			0x4d, 0xcd, 0x20, 0x61, 0xe0, 0xc9, 0x50, 0xab,
			0xb8, 0x64, 0x5a, 0x3b, 0x3d, 0x73, 0x91, 0xa8,
			0xff, 0x5a, 0x99, 0x99, 0x54, 0x22, 0x27, 0x7c,
			0x43, 0xcc, 0x08, 0x7b, 0xa0, 0xe5, 0x65, 0xab,
			0x79, 0x5b, 0x45, 0x87, 0xb1, 0x8f, 0x53, 0x9e,
			0xeb, 0xab, 0xe2, 0x88, 0xa9, 0x36, 0x2e, 0x1e,
			0xb5, 0xe6, 0xe4, 0xeb, 0xc1, 0xb5, 0xe5, 0xdd,
			0x4a, 0x36, 0x47, 0x40, 0xc2, 0x2a, 0x9d, 0xed,
			0xed, 0x4f, 0x79, 0xbf, 0x8c, 0x78, 0x2f, 0x47,
		},
		/* S4 : 192 byte */
		{
			0x8a, 0xd5, 0xad, 0xa5, 0x33, 0x57, 0xfb, 0x45,
			0xe8, 0x20, 0x2a, 0xdf, 0x81, 0x8e, 0xeb, 0x8d,
			0x65, 0x50, 0x76, 0x70, 0xb0, 0x37, 0x30, 0x7c,
			0x94, 0xe9, 0x8f, 0x4e, 0x66, 0xca, 0xa2, 0xea,
			0x4d, 0x7c, 0x66, 0x79, 0xcd, 0x4a, 0x35, 0x75,
			0xaf, 0x81, 0xc3, 0x34, 0xda, 0x1b, 0x34, 0x0c,
			0x99, 0xf6, 0x47, 0x3e, 0x4d, 0x59, 0x84, 0xed,
			0xa3, 0xff, 0x07, 0x68, 0xc2, 0x23, 0x3d, 0x8a,
			0x4b, 0x11, 0xa7, 0xb4, 0xb0, 0x10, 0x13, 0x68,
			0xbd, 0x50, 0xf6, 0xe0, 0x1c, 0x5f, 0xd8, 0xa0,
			0xfd, 0x62, 0x61, 0xa4, 0xed, 0xa8, 0x8c, 0x9a,
			0x72, 0x01, 0xcc, 0x55, 0xaa, 0xe7, 0x01, 0x90,
			0x47, 0xeb, 0x89, 0xcf, 0x44, 0x6a, 0x1a, 0x22,
			0x21, 0xbe, 0x64, 0xbd, 0xaa, 0x9a, 0x0e, 0xc1,
			0xd7, 0x8c, 0x52, 0xf8, 0x8e, 0x9a, 0x01, 0xf3,
			0xf5, 0x10, 0xd1, 0x08, 0x74, 0xc0, 0x2d, 0xb7,
			0x4b, 0x73, 0xe0, 0xcf, 0x54, 0x2e, 0xbd, 0xc3,
			0x23, 0x26, 0xae, 0x61, 0xe0, 0xdb, 0x59, 0x94,
			0x34, 0xd2, 0xe2, 0x39, 0x1d, 0xc3, 0x3b, 0xad,
			0x2a, 0xbc, 0x66, 0xdb, 0xbe, 0xf2, 0xe2, 0x6c,
			0x83, 0xe2, 0x5f, 0x14, 0x4c, 0x37, 0x3f, 0x3e,
			0x23, 0xc7, 0xfa, 0xc8, 0xce, 0x89, 0x8c, 0x62,
			0xc0, 0xb1, 0x60, 0x7c, 0xcd, 0xd7, 0x31, 0xc3,
			0x1d, 0x8e, 0x29, 0x8c, 0x13, 0x7f, 0xa3, 0x82,
		},
	},
	/* SHA384 [5] */
	{
		/* Msg5 : 128 byte */
		{
			0x06, 0xa2, 0x1c, 0xb4, 0x06, 0x2d, 0x11, 0x4a,
			0x1c, 0xa2, 0xd0, 0xf7, 0x9c, 0xd1, 0x74, 0xb4,
			0xa8, 0x27, 0x49, 0xf1, 0x00, 0x30, 0x3b, 0x37,
			0x1a, 0x5a, 0x8e, 0x0c, 0x76, 0xfc, 0xcf, 0x17,
			0x2c, 0x96, 0x0a, 0x84, 0xc7, 0x5b, 0x3d, 0xaa,
			0x55, 0xec, 0x0d, 0xeb, 0xbf, 0x67, 0xb8, 0xdc,
			0x57, 0xa0, 0x4b, 0xa6, 0xb0, 0xae, 0x15, 0xad,
			0xb2, 0xaa, 0x5b, 0x6f, 0xed, 0xb3, 0x4d, 0xae,
			0x2e, 0x35, 0x39, 0xd1, 0x50, 0x6b, 0xff, 0x88,
			0x55, 0x23, 0xc5, 0xaf, 0xb6, 0xc2, 0xeb, 0x75,
			0xf6, 0x87, 0x41, 0xbd, 0x7d, 0x14, 0x78, 0xc4,
			0xa4, 0x2a, 0xd7, 0x04, 0x0d, 0xb4, 0x2f, 0x59,
			0x35, 0x07, 0x11, 0x63, 0x4c, 0x68, 0x3e, 0x2b,
			0x44, 0xce, 0x5f, 0x09, 0x28, 0xea, 0xf7, 0xc5,
			0xaf, 0x65, 0x95, 0xfc, 0x11, 0x69, 0x4e, 0xc5,
			0x19, 0x62, 0x6a, 0x95, 0x7b, 0x06, 0x5e, 0x60,
		},
		/* S5 : 192 byte */
		{
			0x82, 0xda, 0x93, 0x73, 0xd2, 0xe5, 0x0e, 0x49,
			0xe9, 0x1d, 0x56, 0xe3, 0x76, 0xaf, 0x44, 0xe4,
			0x4d, 0x00, 0x28, 0x34, 0x4c, 0xf6, 0xed, 0x03,
			0xaf, 0x1b, 0x68, 0xc7, 0x45, 0xb7, 0xe4, 0x24,
			0x10, 0x6c, 0xd0, 0xe0, 0x05, 0x7f, 0x42, 0x98,
			0x8b, 0x83, 0x4d, 0xb9, 0xef, 0x82, 0xc6, 0x08,
			0x1c, 0xfe, 0x0c, 0xc3, 0xb4, 0xba, 0x3b, 0xb4,
			0x37, 0x5f, 0x4d, 0x17, 0x78, 0x0b, 0x7f, 0x98,
			0x8d, 0x56, 0xa8, 0x27, 0x84, 0x77, 0x2c, 0xf6,
			0x3a, 0x56, 0x1e, 0xd4, 0xe8, 0x09, 0x02, 0x44,
			0x0a, 0x85, 0x34, 0x59, 0x0f, 0xa5, 0x69, 0xee,
			0xc3, 0xfd, 0x7a, 0xfc, 0x13, 0xad, 0xb2, 0x8a,
			0x8b, 0x11, 0x1c, 0x17, 0x7f, 0xc6, 0xf5, 0x40,
			0x11, 0xca, 0x8d, 0x00, 0xce, 0xad, 0x4e, 0x24,
			0xc1, 0xed, 0x7c, 0x8e, 0x7c, 0x41, 0xc3, 0x2c,
			0x6b, 0x6f, 0xcc, 0x17, 0x97, 0xcb, 0x1c, 0x61,
			0xe7, 0xe8, 0xed, 0x25, 0x65, 0x8c, 0x7f, 0x6f,
			0x32, 0xca, 0x95, 0xba, 0x08, 0x44, 0xde, 0xa6,
			0x84, 0x6e, 0xd4, 0xde, 0xb0, 0x8c, 0x0d, 0x8a,
			0xc5, 0xb5, 0x70, 0xd5, 0x2b, 0xfe, 0x0f, 0x8b,
			0xb1, 0x10, 0xa5, 0x88, 0xe5, 0xbf, 0x1e, 0xd9,
			0x50, 0x6d, 0x68, 0x55, 0x3a, 0x62, 0x16, 0x25,
			0xaa, 0xe2, 0xe4, 0x8f, 0x20, 0x21, 0xcb, 0x35,
			0xe7, 0xc3, 0x85, 0xd4, 0x35, 0x51, 0x6f, 0x21,
		},
	},
	/* SHA384 [6] */
	{
		/* Msg6 : 128 byte */
		{
			0xa9, 0xc8, 0x72, 0x52, 0x4d, 0xf7, 0xda, 0x7d,
			0xe2, 0x3b, 0x47, 0xcb, 0x77, 0x35, 0x67, 0x7f,
			0x5b, 0xd0, 0x0a, 0x7f, 0xe7, 0xc6, 0x8e, 0xfa,
			0x9f, 0x67, 0x9a, 0x4d, 0x7a, 0x96, 0x10, 0x28,
			0x7d, 0x14, 0x3c, 0xec, 0x8e, 0x01, 0x52, 0x58,
			0x88, 0x9f, 0x17, 0x65, 0x8b, 0x5a, 0xde, 0x6e,
			0x96, 0x05, 0xb6, 0x94, 0x57, 0x67, 0xe2, 0x61,
			0x41, 0xf6, 0x89, 0xac, 0xe0, 0xe2, 0xaf, 0xbc,
			0x69, 0x55, 0x64, 0xb0, 0x96, 0xfa, 0x3b, 0x1d,
			0xb0, 0xbc, 0xfe, 0xfa, 0xed, 0xd0, 0xa0, 0xb9,
			0xfd, 0xf5, 0x73, 0xb7, 0xe0, 0xfa, 0x9b, 0xd6,
			0xfa, 0x81, 0xc3, 0x68, 0x69, 0x04, 0x0f, 0x50,
			0x96, 0x15, 0x51, 0x63, 0x0a, 0xea, 0x7f, 0x15,
			0x84, 0x18, 0x65, 0x51, 0x48, 0x9f, 0x97, 0xa8,
			0xb9, 0x27, 0xaa, 0xae, 0x2a, 0x89, 0xa3, 0xa1,
			0xf2, 0x91, 0xb0, 0x4c, 0xbe, 0x03, 0x16, 0x2b,
		},
		/* S6 : 192 byte */
		{
			0x09, 0x93, 0x5b, 0x30, 0x1c, 0xcc, 0x38, 0x49,
			0xef, 0xac, 0x6d, 0x00, 0x37, 0x31, 0x90, 0x02,
			0x6e, 0x53, 0xc0, 0x7c, 0x51, 0x4a, 0x91, 0xdf,
			0x1b, 0x85, 0x41, 0x84, 0x35, 0x62, 0x02, 0x43,
			0x93, 0xc9, 0xa6, 0x0b, 0x96, 0x51, 0x39, 0xe6,
			0x40, 0xc3, 0xeb, 0xca, 0x7d, 0xcb, 0x7a, 0x86,
			0x2a, 0xab, 0xc1, 0xc2, 0x96, 0xe7, 0xa1, 0x69,
			0x78, 0x21, 0xac, 0x17, 0xc4, 0xdc, 0x71, 0x9c,
			0xb7, 0x29, 0x31, 0xab, 0x13, 0x81, 0x51, 0x1e,
			0x80, 0xb9, 0xbb, 0xa3, 0xc5, 0xd6, 0x39, 0x04,
			0x98, 0x42, 0x62, 0x1b, 0xb7, 0x88, 0x9f, 0xd7,
			0xfa, 0x87, 0xe5, 0x2a, 0xf3, 0x60, 0xbf, 0xa0,
			0xcb, 0x5c, 0xa3, 0x85, 0x42, 0x5e, 0xd3, 0xf9,
			0xa6, 0x97, 0x5e, 0xfd, 0x8b, 0xd7, 0x25, 0x56,
			0x0e, 0x07, 0xb2, 0x23, 0x17, 0x30, 0xe6, 0xb9,
			0xee, 0x1b, 0x9c, 0x87, 0x3d, 0xf9, 0x82, 0x0e,
			0x02, 0x29, 0x77, 0x6a, 0xa6, 0xdd, 0xbc, 0xa0,
			0x30, 0xf3, 0xf9, 0x6a, 0x60, 0xc7, 0xc0, 0x9d,
			0xbb, 0xb8, 0xb3, 0x34, 0x71, 0x1e, 0xeb, 0x07,
			0xe3, 0xde, 0x9a, 0x6f, 0x40, 0x96, 0x39, 0x46,
			0x8e, 0xd1, 0xea, 0x71, 0xdd, 0xa8, 0x50, 0x26,
			0x2e, 0x69, 0x17, 0xa2, 0xeb, 0x9c, 0x7f, 0xfc,
			0x99, 0x17, 0x21, 0x89, 0x8d, 0x72, 0x09, 0x71,
			0x7e, 0xc1, 0xe5, 0x95, 0x0a, 0x7b, 0x65, 0xd2,
		},
	},
	/* SHA384 [7] */
	{
		/* Msg7 : 128 byte */
		{
			0xe3, 0x3f, 0x32, 0xf8, 0xb4, 0x87, 0x70, 0x3a,
			0x38, 0x60, 0xf3, 0xc5, 0xa2, 0x45, 0x1e, 0xfb,
			0x19, 0xcd, 0xf5, 0x62, 0x5f, 0xc8, 0xdf, 0x56,
			0xb1, 0x8b, 0xa9, 0xfb, 0xef, 0x88, 0xcf, 0x76,
			0xfd, 0x22, 0xf7, 0x5d, 0x69, 0xbf, 0xbf, 0x6b,
			0x4e, 0x1e, 0xb8, 0x79, 0x78, 0xeb, 0xb2, 0xa9,
			0xc8, 0x90, 0x3b, 0xe5, 0xda, 0x4f, 0x62, 0x88,
			0xe6, 0x8d, 0xc1, 0x5a, 0xe4, 0x71, 0xba, 0xc2,
			0xf4, 0xae, 0x00, 0x37, 0xfc, 0x9d, 0x59, 0xf8,
			0x93, 0x8f, 0xa3, 0xfd, 0x1e, 0x61, 0x15, 0x2d,
			0x38, 0x51, 0xc8, 0xd1, 0x58, 0x0f, 0x76, 0x49,
			0xad, 0x18, 0x81, 0xfd, 0x4d, 0x3f, 0x37, 0x97,
			0x8f, 0x8c, 0x54, 0x70, 0xb5, 0x4a, 0xc8, 0x47,
			0xcf, 0x5c, 0xbb, 0x39, 0xdc, 0xd0, 0xcf, 0xed,
			0x31, 0xb7, 0xa5, 0x10, 0x1f, 0x33, 0xa2, 0x01,
			0xd0, 0xd1, 0xf3, 0xcd, 0x72, 0x19, 0xce, 0x5d,
		},
		/* S7 : 192 byte */
		{
			0x7b, 0xcd, 0xfe, 0x9f, 0x7a, 0xdd, 0x38, 0x41,
			0xb7, 0x17, 0x95, 0x4f, 0x7d, 0x95, 0xee, 0x90,
			0xde, 0x98, 0x81, 0xb8, 0xcd, 0x86, 0xdc, 0x7c,
			0x15, 0x52, 0x8d, 0x25, 0x39, 0xb1, 0x94, 0xfb,
			0xf2, 0xa2, 0xe4, 0x19, 0x95, 0x86, 0x49, 0x35,
			0xc3, 0x96, 0x38, 0x09, 0x61, 0xe0, 0x20, 0x0e,
			0x3f, 0x8c, 0x53, 0x2d, 0x81, 0xea, 0x26, 0x9a,
			0xea, 0xe7, 0x63, 0x03, 0x6b, 0xe5, 0x3d, 0x6b,
			0xe9, 0x92, 0xd5, 0xbc, 0xf3, 0x07, 0xe7, 0x9a,
			0xf3, 0x9f, 0x51, 0x8f, 0xb6, 0x89, 0x47, 0x2e,
			0x2d, 0xd5, 0x6d, 0x71, 0xed, 0x97, 0x03, 0x03,
			0x34, 0x65, 0xc0, 0xd6, 0xd8, 0x51, 0x4f, 0x56,
			0xad, 0x58, 0xca, 0x37, 0x47, 0xd8, 0x8a, 0x84,
			0xd9, 0xec, 0x3e, 0x5e, 0x27, 0xf1, 0x08, 0x3e,
			0x66, 0xdb, 0xac, 0x7e, 0x7e, 0x18, 0x17, 0xc5,
			0x5d, 0x88, 0xe8, 0xeb, 0x59, 0xb9, 0xea, 0x47,
			0x40, 0xea, 0xd9, 0xae, 0x0c, 0x7a, 0xaa, 0x6f,
			0x31, 0x05, 0x88, 0x79, 0x38, 0xbe, 0x67, 0x5b,
			0x3c, 0x64, 0x78, 0x7c, 0x9b, 0x12, 0xe9, 0x7f,
			0x2a, 0x67, 0xf9, 0x36, 0x8a, 0xe2, 0x74, 0x6e,
			0xcb, 0x13, 0x04, 0x12, 0x71, 0xff, 0x11, 0x02,
			0x4b, 0x2d, 0x3e, 0xff, 0xd9, 0xaa, 0x50, 0x60,
			0x3f, 0x4b, 0x95, 0x30, 0xbb, 0xea, 0xc8, 0x95,
			0x3e, 0x74, 0xf6, 0x40, 0xaf, 0xa9, 0xec, 0xe4,
		},
	},
	/* SHA384 [8] */
	{
		/* Msg8 : 128 byte */
		{
			0x95, 0x62, 0x2a, 0xb7, 0x10, 0xf9, 0x93, 0x32,
			0xc2, 0xb8, 0x12, 0xc2, 0x29, 0x7a, 0x24, 0xc2,
			0xc8, 0x09, 0x7e, 0xe2, 0x19, 0x3e, 0xa2, 0x6f,
			0xc9, 0x69, 0xb1, 0xd5, 0x24, 0xf2, 0x80, 0x62,
			0xcf, 0x41, 0xed, 0x4c, 0xb5, 0xdc, 0x74, 0xf6,
			0x43, 0xcf, 0xfd, 0x6f, 0xd8, 0x51, 0xf8, 0x3b,
			0x77, 0xa4, 0xac, 0x57, 0xc0, 0x3d, 0xcc, 0x77,
			0x1e, 0x25, 0x4c, 0x92, 0x41, 0x9f, 0x72, 0xa0,
			0xcf, 0x0b, 0x30, 0xa3, 0x56, 0x0a, 0xb1, 0xe4,
			0x86, 0xe3, 0x32, 0x7f, 0x9d, 0x26, 0x13, 0x21,
			0x22, 0x8f, 0x2e, 0x11, 0xd6, 0x2c, 0x67, 0x6d,
			0xe8, 0xc2, 0x84, 0xb7, 0x68, 0x6e, 0x40, 0x90,
			0xfe, 0x88, 0x9a, 0xc2, 0xdc, 0xcc, 0x73, 0x84,
			0xf1, 0xbc, 0x58, 0xfa, 0x5f, 0x40, 0x9d, 0xfc,
			0x30, 0x90, 0xab, 0x18, 0x44, 0x53, 0x9a, 0xda,
			0x8e, 0x09, 0x03, 0x4a, 0x81, 0xa6, 0x0f, 0xb7,
		},
		/* S8 : 192 byte */
		{
			0x4b, 0x46, 0x81, 0x48, 0x0e, 0xcb, 0x8e, 0xe5,
			0x14, 0xa2, 0x8b, 0x08, 0x60, 0x90, 0x26, 0xe1,
			0x0e, 0x73, 0xc7, 0x79, 0x53, 0x41, 0xa5, 0x86,
			0x02, 0x29, 0x11, 0x1f, 0x5e, 0xb4, 0xe6, 0xe3,
			0x43, 0xa0, 0xcc, 0x33, 0x5c, 0x4f, 0xc1, 0x6c,
			0x56, 0xd3, 0xdd, 0x10, 0x4b, 0x62, 0xb8, 0xa9,
			0x52, 0x77, 0x69, 0x65, 0x9f, 0x05, 0x93, 0xfe,
			0x79, 0x5c, 0x1a, 0x63, 0xb1, 0xe9, 0x42, 0x51,
			0x7f, 0x6a, 0xc5, 0xb0, 0xc9, 0x3e, 0xcc, 0x07,
			0x1a, 0x88, 0x67, 0x1e, 0xc5, 0x31, 0x0d, 0x0e,
			0xee, 0xf8, 0xe7, 0x35, 0xca, 0x37, 0x88, 0x88,
			0x60, 0x99, 0x82, 0x76, 0x58, 0xec, 0xda, 0x30,
			0x50, 0x67, 0x22, 0xbe, 0x05, 0x6d, 0xa0, 0x9a,
			0x1a, 0x1b, 0xd6, 0x6c, 0x7f, 0x6c, 0xd0, 0xdb,
			0xa7, 0xa6, 0x42, 0x77, 0x50, 0xc3, 0x3d, 0x30,
			0x1c, 0x49, 0x7e, 0xb6, 0x1f, 0xae, 0x99, 0x05,
			0x09, 0x92, 0xcc, 0x30, 0xab, 0xa5, 0xb8, 0x15,
			0x9a, 0x44, 0xcd, 0x8b, 0xe3, 0x6d, 0x73, 0x8c,
			0x0a, 0x6f, 0xd4, 0x64, 0xd7, 0x33, 0xaf, 0x37,
			0xb9, 0x91, 0x53, 0x98, 0xa1, 0x3c, 0x67, 0x69,
			0x49, 0x0b, 0xf3, 0x2e, 0x1e, 0xd2, 0xb3, 0xe7,
			0xd0, 0x85, 0xea, 0xdb, 0x8b, 0x6b, 0x59, 0x53,
			0x2e, 0x85, 0xdf, 0xa5, 0x3d, 0x67, 0x9d, 0x3e,
			0xd6, 0x4e, 0xa7, 0xbb, 0x71, 0xcd, 0xa3, 0xa0,
		},
	},
	/* SHA384 [9] */
	{
		/* Msg9 : 128 byte */
		{
			0x24, 0x3c, 0x80, 0xbc, 0xda, 0x3b, 0x5c, 0xe1,
			0x86, 0x26, 0x0b, 0xbf, 0x69, 0x4b, 0x75, 0x31,
			0x3f, 0x81, 0xe9, 0xdd, 0x6a, 0xb8, 0x5f, 0x66,
			0x4c, 0xd4, 0x00, 0xe4, 0xf5, 0xbc, 0xe8, 0x91,
			0xfe, 0xad, 0x2a, 0xc4, 0xb4, 0xd5, 0x14, 0x24,
			0x7a, 0x1d, 0xb5, 0x15, 0x68, 0x46, 0x9d, 0x77,
			0x38, 0x37, 0xe4, 0x90, 0x63, 0x95, 0x6e, 0x46,
			0x87, 0x95, 0x6c, 0x92, 0x0c, 0x0e, 0x26, 0x31,
			0x07, 0xd3, 0xf9, 0x9d, 0x5e, 0x3f, 0x9b, 0x3b,
			0x2e, 0x11, 0xa7, 0xd6, 0x69, 0x7a, 0x55, 0x4c,
			0xc4, 0x75, 0x88, 0x87, 0xd0, 0x57, 0x0f, 0xaf,
			0x66, 0xa7, 0x24, 0x9e, 0x49, 0x2f, 0x39, 0x95,
			0x07, 0x53, 0xf5, 0x2d, 0x20, 0xa2, 0x79, 0x90,
			0x6a, 0xab, 0xe7, 0xe8, 0xb4, 0x12, 0x25, 0x18,
			0xaa, 0xe3, 0xde, 0xab, 0xf9, 0x25, 0xca, 0x09,
			0xb3, 0xb3, 0x30, 0xf1, 0xf4, 0x47, 0xa9, 0x23,
		},
		/* S9 : 192 byte */
		{
			0x5b, 0x26, 0x95, 0xb3, 0x8d, 0x1a, 0xb3, 0x96,
			0xc7, 0x3d, 0xc2, 0x51, 0x7e, 0x4a, 0x80, 0xb1,
			0xb9, 0x61, 0xeb, 0x58, 0xf9, 0x09, 0x7a, 0xa9,
			0x69, 0xb5, 0xf5, 0x5b, 0xbe, 0x6e, 0xf1, 0x05,
			0x87, 0x9c, 0x52, 0x26, 0xd4, 0x30, 0x5b, 0x11,
			0x3b, 0xe4, 0x8f, 0x33, 0x3e, 0x04, 0xef, 0x03,
			0xfe, 0xdf, 0xd2, 0xf3, 0x11, 0xbd, 0xa7, 0x49,
			0x5b, 0xa4, 0x78, 0xd0, 0xad, 0x62, 0x54, 0x3a,
			0xed, 0x3f, 0x00, 0xc2, 0x9e, 0x41, 0x9a, 0xb5,
			0x72, 0xb8, 0x89, 0xe8, 0x89, 0x4e, 0x7f, 0xbd,
			0x2b, 0x4f, 0x34, 0xff, 0x8b, 0x77, 0x59, 0x0e,
			0xa6, 0xc2, 0x87, 0xbe, 0xd2, 0x7e, 0x58, 0xf8,
			0x07, 0xef, 0xf8, 0xbe, 0x4e, 0xd6, 0x60, 0x11,
			0xd5, 0x0c, 0x85, 0xd1, 0xd2, 0xb6, 0xa7, 0xba,
			0xbe, 0x53, 0x23, 0xc9, 0xa1, 0xa4, 0xfe, 0x53,
			0xf7, 0xe9, 0x68, 0xc1, 0x19, 0x41, 0x71, 0x3d,
			0x54, 0xb2, 0xa9, 0x7c, 0x21, 0x45, 0xbc, 0x58,
			0x5e, 0x1d, 0xe1, 0x4e, 0x67, 0x53, 0xb4, 0x01,
			0x27, 0x64, 0x2a, 0x0d, 0x08, 0xc2, 0x9f, 0x4f,
			0xa0, 0x7b, 0x16, 0xe2, 0xd6, 0xee, 0xcf, 0x87,
			0x34, 0x34, 0x30, 0xc6, 0x8b, 0xab, 0x4d, 0xa1,
			0xf9, 0x48, 0xfb, 0x30, 0x72, 0x87, 0xeb, 0x6d,
			0x59, 0xdb, 0x67, 0xae, 0x29, 0x52, 0x04, 0xed,
			0x8d, 0xea, 0xf5, 0xba, 0xb0, 0x3b, 0x06, 0x20,
		},
	},
};

/* 10 elements */
static mod1536_t SHA512[] = {
	/* SHA512 [0] */
	{
		/* Msg0 : 128 byte */
		{
			0x28, 0x15, 0x73, 0xd6, 0x68, 0xf1, 0x44, 0x75,
			0x97, 0x7c, 0x9f, 0xb6, 0x20, 0x43, 0x69, 0x39,
			0x2d, 0x94, 0x4a, 0x5a, 0xbf, 0x40, 0x5f, 0x10,
			0xfe, 0x9f, 0x2f, 0x15, 0xce, 0xd5, 0xe1, 0x48,
			0xa2, 0x54, 0xac, 0x4f, 0x95, 0xa2, 0x8e, 0x80,
			0xb7, 0x5d, 0x41, 0x02, 0xa4, 0x7c, 0x6b, 0x2f,
			0x5c, 0xd7, 0x15, 0x3d, 0x4e, 0xea, 0x5e, 0x1e,
			0xb6, 0xd5, 0x70, 0xa4, 0x29, 0xa8, 0xb4, 0xe9,
			0x6e, 0xde, 0x42, 0xee, 0x90, 0x27, 0x9c, 0x82,
			0x31, 0x6b, 0x9b, 0x66, 0x21, 0x0b, 0xa9, 0xae,
			0x30, 0x6a, 0x31, 0x6a, 0x40, 0xac, 0x54, 0x86,
			0x9e, 0xbd, 0xde, 0xef, 0x92, 0x95, 0x78, 0xf7,
			0x34, 0xbb, 0x1f, 0xfb, 0x82, 0x08, 0xd4, 0x43,
			0xb0, 0xae, 0x95, 0x29, 0xbf, 0x79, 0x8d, 0x7e,
			0x51, 0x54, 0x88, 0x29, 0xbc, 0x0e, 0xa9, 0x11,
			0x5d, 0x5e, 0x5f, 0x3e, 0x2f, 0x25, 0x95, 0x3b,
		},
		/* S0 : 192 byte */
		{
			0x4d, 0xcc, 0xb5, 0xf5, 0x1c, 0x58, 0x83, 0x28,
			0xad, 0x02, 0xfe, 0x48, 0xc3, 0x0c, 0x5c, 0x9b,
			0x4d, 0x87, 0x05, 0xe0, 0xa4, 0xee, 0x15, 0xe6,
			0x3f, 0xb9, 0x44, 0x1b, 0x74, 0xae, 0x28, 0xf6,
			0x18, 0xda, 0x18, 0x4e, 0x7d, 0x27, 0x8c, 0x08,
			0x8b, 0xf6, 0x2d, 0x2d, 0xcf, 0x6a, 0xd1, 0xdf,
			0xb6, 0x01, 0xe5, 0x5f, 0xfb, 0xf2, 0xd9, 0x21,
			0x0e, 0x8d, 0xf3, 0xfa, 0xe1, 0x04, 0xc8, 0xe6,
			0xaf, 0xf8, 0x81, 0x96, 0xd3, 0x39, 0x57, 0x06,
			0xa3, 0x46, 0x75, 0x4c, 0x91, 0x10, 0x4a, 0x60,
			0x90, 0x46, 0x06, 0x9e, 0x5b, 0x23, 0xa3, 0xa5,
			0x8c, 0x2d, 0x2d, 0xd1, 0x15, 0x8d, 0x75, 0xd9,
			0x1c, 0x7f, 0x48, 0x2f, 0x8e, 0x8e, 0xae, 0xfc,
			0xc9, 0x3b, 0xb7, 0x26, 0x88, 0xd8, 0xd5, 0xd6,
			0xe8, 0xac, 0x67, 0x94, 0xfb, 0x56, 0xcd, 0x3c,
			0x49, 0x9e, 0x1d, 0x2b, 0x30, 0x66, 0x4d, 0x6b,
			0xbd, 0xe8, 0x4a, 0x65, 0xfb, 0xbe, 0x5e, 0x2b,
			0xad, 0x5a, 0x56, 0x9a, 0x04, 0x71, 0x02, 0xb7,
			0x29, 0x9f, 0x42, 0x88, 0x3a, 0x85, 0xc1, 0x46,
			0xe2, 0x21, 0xe8, 0x99, 0x3a, 0xb9, 0x29, 0xb2,
			0x33, 0x9b, 0xdf, 0x21, 0xdb, 0xad, 0xbd, 0x5b,
			0xba, 0x92, 0xea, 0x97, 0x65, 0x62, 0x8c, 0x81,
			0x17, 0x3f, 0xc4, 0x2a, 0xbe, 0x20, 0x7a, 0xa9,
			0x56, 0xc0, 0x17, 0x71, 0xb1, 0x68, 0x5d, 0x92,
		},
	},
	/* SHA512 [1] */
	{
		/* Msg1 : 128 byte */
		{
			0xc4, 0x09, 0x5a, 0x74, 0xb4, 0x3f, 0xec, 0x6a,
			0x10, 0xaf, 0x4a, 0x84, 0x63, 0x0d, 0x6c, 0xaa,
			0x89, 0x14, 0x30, 0x16, 0x64, 0x6d, 0xaa, 0x58,
			0xd0, 0xd3, 0xbb, 0x9d, 0xd8, 0x75, 0xe5, 0x30,
			0x2a, 0x9b, 0x5d, 0x41, 0xc8, 0x8d, 0x62, 0xe6,
			0x01, 0xb1, 0xce, 0x5f, 0xa0, 0xf3, 0xeb, 0x9e,
			0x63, 0x69, 0x87, 0x07, 0xae, 0x37, 0x4b, 0x74,
			0x81, 0xb1, 0x48, 0x7c, 0xa8, 0xc0, 0xd3, 0xf5,
			0x31, 0x87, 0x93, 0xb7, 0x23, 0x46, 0xd8, 0xa3,
			0x6d, 0x7e, 0x2e, 0xe4, 0x1d, 0x56, 0x33, 0x75,
			0xd2, 0x3d, 0xa5, 0xe3, 0x74, 0xd1, 0xbf, 0x55,
			0x22, 0xff, 0xc6, 0xc9, 0x6c, 0x6c, 0xdf, 0xa0,
			0xc3, 0x14, 0x23, 0x5d, 0x2d, 0x32, 0xf5, 0xaa,
			0x3e, 0x5f, 0x93, 0x9c, 0x43, 0xfd, 0xec, 0x37,
			0xc0, 0xd6, 0xb2, 0x35, 0x1d, 0x01, 0xaf, 0x03,
			0x9c, 0x06, 0x5c, 0x0d, 0x8e, 0x41, 0xb0, 0x3b,
		},
		/* S1 : 192 byte */
		{
			0x50, 0xdf, 0xbe, 0xb3, 0x6c, 0xd2, 0x6a, 0x3f,
			0x25, 0x68, 0x32, 0x6b, 0x99, 0xd9, 0xca, 0x4c,
			0x7b, 0xde, 0xfc, 0x58, 0x57, 0x9a, 0x2d, 0xdc,
			0xe9, 0xd7, 0x80, 0x38, 0x99, 0x32, 0x93, 0x01,
			0x34, 0x04, 0x1f, 0x43, 0x57, 0x1f, 0x76, 0x44,
			0xb5, 0xc7, 0x61, 0xbe, 0xba, 0xc9, 0x61, 0x3c,
			0xe5, 0xc7, 0x8e, 0xc7, 0x91, 0x14, 0xa7, 0x33,
			0xab, 0x8d, 0x87, 0x81, 0xfe, 0x3c, 0x89, 0x26,
			0x00, 0x09, 0x0a, 0x29, 0x4e, 0x3c, 0x9e, 0xd9,
			0x91, 0x5d, 0xed, 0x25, 0x18, 0xeb, 0x64, 0xd7,
			0x9a, 0x48, 0x8e, 0xa6, 0x36, 0x62, 0x6f, 0xea,
			0x4a, 0x23, 0xd9, 0x0d, 0x56, 0x75, 0x2e, 0xd4,
			0x20, 0x94, 0x88, 0x6e, 0x17, 0x80, 0xa4, 0x6c,
			0x8f, 0xd8, 0x38, 0xfd, 0xa5, 0x57, 0xbd, 0xbc,
			0xaa, 0x2b, 0xa3, 0xf6, 0x0d, 0x91, 0x02, 0xfa,
			0xe0, 0x5b, 0x61, 0x1d, 0x91, 0xf7, 0x46, 0xec,
			0x05, 0xbc, 0xa5, 0x23, 0x7a, 0x88, 0xee, 0x1d,
			0xa9, 0x70, 0xd2, 0xc9, 0xcd, 0x94, 0x57, 0xca,
			0xce, 0x65, 0xf6, 0x9d, 0x64, 0x6e, 0xb7, 0xb6,
			0x42, 0x19, 0xe2, 0x5d, 0xa8, 0x39, 0xcd, 0x04,
			0x8d, 0x5f, 0x65, 0xc7, 0xa0, 0x8a, 0xf4, 0x68,
			0xc8, 0x3b, 0x53, 0xc2, 0xc9, 0xfd, 0x2e, 0x9a,
			0xd7, 0xf7, 0x10, 0xc0, 0x09, 0x71, 0x86, 0x70,
			0xec, 0x22, 0x67, 0x0a, 0x65, 0xd4, 0xa0, 0x54,
		},
	},
	/* SHA512 [2] */
	{
		/* Msg2 : 128 byte */
		{
			0x4e, 0x0e, 0xa4, 0xcd, 0x41, 0x06, 0x88, 0x02,
			0x42, 0x66, 0x7f, 0x17, 0x58, 0x6a, 0xe8, 0xbd,
			0xff, 0xe9, 0x4c, 0x2c, 0x1f, 0x7d, 0xef, 0x68,
			0x3f, 0xe4, 0xa5, 0xc3, 0xf6, 0xa6, 0xe7, 0xa3,
			0xa3, 0xf8, 0x26, 0x85, 0x5e, 0xe1, 0x5f, 0x42,
			0x2f, 0x9b, 0xf0, 0x91, 0x7d, 0x3c, 0xaa, 0xce,
			0xc9, 0x96, 0x27, 0xfa, 0x9c, 0x5b, 0x5e, 0x02,
			0xbd, 0x85, 0x74, 0x44, 0xa8, 0xf4, 0xd6, 0x4f,
			0x3c, 0x59, 0x84, 0xea, 0xb4, 0x54, 0xb0, 0x59,
			0xd8, 0xd9, 0x87, 0xdb, 0x74, 0xd8, 0x4f, 0x77,
			0x0a, 0x1d, 0xb2, 0xf8, 0xc4, 0x75, 0x59, 0x37,
			0xac, 0x12, 0xbd, 0x98, 0x1f, 0x30, 0x3a, 0xd7,
			0x7f, 0xf9, 0x66, 0x05, 0x29, 0xa6, 0xa0, 0xcd,
			0xa7, 0xe8, 0xec, 0xfc, 0x26, 0x86, 0xfe, 0x41,
			0x2a, 0x47, 0x94, 0x30, 0x80, 0x12, 0x09, 0x8d,
			0x75, 0x54, 0x27, 0xc8, 0x45, 0xa2, 0x3e, 0xc4,
		},
		/* S2 : 192 byte */
		{
			0x20, 0x8c, 0x20, 0xd4, 0xe2, 0x17, 0x09, 0x01,
			0x68, 0x62, 0xd7, 0xf9, 0xfd, 0xe9, 0x96, 0x6a,
			0xa1, 0x88, 0x86, 0x26, 0xb1, 0xba, 0xef, 0x87,
			0x7e, 0x56, 0xad, 0x28, 0x92, 0x1f, 0xd4, 0x1f,
			0x4f, 0x53, 0x45, 0x99, 0x6a, 0xf0, 0xa0, 0xeb,
			0x26, 0x09, 0x7c, 0x54, 0xc1, 0x92, 0x4b, 0x53,
			0x6b, 0x23, 0x23, 0x12, 0xb6, 0x5b, 0x3a, 0x61,
			0xa0, 0xb2, 0x5f, 0xfe, 0x85, 0x21, 0x28, 0xd0,
			0x48, 0xd4, 0x93, 0x94, 0x47, 0xce, 0x49, 0x5c,
			0x5a, 0x6d, 0x34, 0x4c, 0xa8, 0x47, 0xb6, 0x19,
			0x01, 0x87, 0x76, 0x82, 0x45, 0xa2, 0x5b, 0x54,
			0x47, 0x58, 0x1c, 0x4f, 0xb2, 0xd8, 0x97, 0x41,
			0x1e, 0x6b, 0x8f, 0xc7, 0x3f, 0xdc, 0x0a, 0x7c,
			0x7d, 0x03, 0x26, 0xcd, 0x41, 0xce, 0xe8, 0xb5,
			0x90, 0xb7, 0xff, 0x7f, 0xf7, 0x73, 0x36, 0x72,
			0x63, 0x51, 0xeb, 0xe5, 0xe0, 0xaa, 0x64, 0xf1,
			0xa2, 0x20, 0x0a, 0xcd, 0x27, 0xaf, 0xe9, 0xbc,
			0xf9, 0xd9, 0xce, 0x3a, 0xa6, 0x68, 0x56, 0xa5,
			0x7f, 0xb8, 0xde, 0x60, 0x06, 0xa3, 0x6f, 0x7d,
			0x0e, 0xff, 0x06, 0x27, 0xaf, 0x3f, 0xc8, 0xca,
			0x9a, 0x7a, 0xeb, 0x44, 0x39, 0x88, 0x32, 0x80,
			0xbc, 0xbe, 0x07, 0x0a, 0x05, 0x78, 0xa6, 0x51,
			0xa0, 0x6a, 0x44, 0x81, 0x6c, 0x99, 0x07, 0x04,
			0x5f, 0x7e, 0x2d, 0x7d, 0x88, 0x93, 0x9c, 0x5d,
		},
	},
	/* SHA512 [3] */
	{
		/* Msg3 : 128 byte */
		{
			0x2d, 0xe2, 0xa6, 0xe5, 0xf4, 0x15, 0xba, 0xdf,
			0xa2, 0x74, 0x9d, 0x7b, 0x42, 0x74, 0x3b, 0x01,
			0xcf, 0xb3, 0x10, 0x0f, 0x3c, 0xe6, 0x48, 0x31,
			0xb7, 0x12, 0x25, 0xb1, 0x2f, 0x00, 0xa2, 0xb1,
			0x14, 0xeb, 0x56, 0x76, 0x5e, 0x7b, 0x9a, 0x07,
			0xd0, 0xf7, 0xee, 0xf7, 0x7e, 0xb6, 0x99, 0x7f,
			0x8d, 0xd6, 0x90, 0xd0, 0x3a, 0x31, 0x99, 0xa6,
			0x1d, 0x8d, 0xb0, 0x21, 0xaf, 0x13, 0xaa, 0xd1,
			0x0b, 0x03, 0x18, 0x0f, 0xf1, 0xa5, 0x6e, 0x94,
			0x10, 0x83, 0x65, 0x44, 0x85, 0xd5, 0x9d, 0x4b,
			0x9f, 0x3d, 0x87, 0x6b, 0xe5, 0xb4, 0x82, 0x94,
			0x5a, 0xc4, 0x44, 0xb6, 0xff, 0xf9, 0x7c, 0xd3,
			0x9a, 0x92, 0xb5, 0x58, 0xb6, 0x7b, 0x7e, 0xad,
			0xeb, 0x80, 0xc8, 0x0b, 0x5f, 0xbb, 0x8f, 0x8e,
			0x8d, 0x4e, 0xbd, 0x8b, 0x45, 0x58, 0x4b, 0x23,
			0xf4, 0x21, 0xa9, 0x18, 0x26, 0x98, 0x60, 0xe0,
		},
		/* S3 : 192 byte */
		{
			0x33, 0xa7, 0x6b, 0xdf, 0x4c, 0xb6, 0x7d, 0xbe,
			0x60, 0xa3, 0x85, 0xe5, 0x20, 0x3d, 0x3d, 0x38,
			0xa7, 0x0b, 0xf1, 0x10, 0x42, 0xd9, 0x58, 0xd8,
			0xf0, 0x3f, 0xca, 0x07, 0x2b, 0x15, 0x85, 0x03,
			0xc2, 0xe4, 0xd1, 0x9d, 0xfb, 0xd7, 0x60, 0x8a,
			0x5a, 0x1a, 0xaa, 0xa9, 0x3f, 0x29, 0x2f, 0xee,
			0x63, 0x76, 0x97, 0xe6, 0x24, 0x35, 0x10, 0xb0,
			0x36, 0x3d, 0xdb, 0xa3, 0xd4, 0xc1, 0xf8, 0x77,
			0xc2, 0x30, 0xba, 0xd3, 0x83, 0x2e, 0xfd, 0xce,
			0x6a, 0x87, 0xf6, 0x5a, 0x89, 0x7e, 0x63, 0x66,
			0x98, 0xa9, 0xf1, 0xc8, 0xf4, 0x64, 0xe5, 0xdb,
			0x0b, 0x5e, 0x87, 0xee, 0x0e, 0xa4, 0x2c, 0x04,
			0x21, 0x93, 0x3b, 0x21, 0x39, 0x85, 0xde, 0x4e,
			0x35, 0x73, 0x63, 0xfc, 0x3a, 0xf5, 0x2c, 0x34,
			0xa2, 0x9b, 0xb8, 0xd5, 0xf1, 0x2a, 0xd7, 0xc7,
			0x67, 0xd4, 0xd9, 0x5b, 0xda, 0x4e, 0x33, 0xea,
			0x4f, 0xfa, 0x3f, 0x04, 0x1f, 0x3e, 0x73, 0x49,
			0x6d, 0xc4, 0xf4, 0x66, 0xe9, 0xa1, 0x23, 0xef,
			0x2c, 0xbd, 0x90, 0x7d, 0x18, 0x10, 0x36, 0xbf,
			0x7f, 0x10, 0xd4, 0x42, 0xf3, 0xea, 0x78, 0x1a,
			0xa1, 0x2e, 0xf2, 0x4a, 0xa8, 0x5a, 0xf4, 0xe5,
			0x28, 0x39, 0x40, 0xa7, 0x34, 0x94, 0x01, 0xeb,
			0x98, 0x4f, 0xe1, 0xae, 0x11, 0xb9, 0xff, 0xd5,
			0x49, 0x86, 0xa4, 0xa8, 0xa0, 0x5a, 0x31, 0xad,
		},
	},
	/* SHA512 [4] */
	{
		/* Msg4 : 128 byte */
		{
			0x66, 0x61, 0x40, 0x22, 0x32, 0x4d, 0xc6, 0xea,
			0x06, 0x8c, 0x1a, 0xfa, 0xef, 0xc4, 0xda, 0xc9,
			0x98, 0xc5, 0x20, 0x54, 0x1b, 0x11, 0xfc, 0xc0,
			0x17, 0x9c, 0x22, 0x41, 0x03, 0xd0, 0xdf, 0x3a,
			0xc1, 0xd4, 0x52, 0xa6, 0x76, 0x0e, 0xd8, 0xb6,
			0x9a, 0xe7, 0xc8, 0xbb, 0x4b, 0xce, 0x61, 0x47,
			0xe7, 0x7f, 0x00, 0x8f, 0xd9, 0x85, 0x96, 0x14,
			0xb3, 0xfd, 0x5a, 0x83, 0x7e, 0x9e, 0xbb, 0xd9,
			0x4d, 0xf6, 0x99, 0xca, 0x19, 0xf6, 0xb4, 0x64,
			0xc8, 0xb1, 0x65, 0xf0, 0x8f, 0x61, 0x8c, 0x19,
			0x7a, 0xab, 0xc9, 0x50, 0x49, 0x24, 0xef, 0x6e,
			0x7e, 0x13, 0xb5, 0x9b, 0xb4, 0x79, 0xaf, 0x6f,
			0x32, 0x4e, 0x7d, 0x58, 0xc0, 0x0e, 0x43, 0x3c,
			0xba, 0x74, 0x59, 0x5f, 0x62, 0x85, 0x43, 0x86,
			0x7a, 0xd1, 0xe3, 0x5d, 0x13, 0xf6, 0xed, 0x16,
			0xa0, 0x65, 0x9c, 0x53, 0x4e, 0x69, 0xa3, 0x46,
		},
		/* S4 : 192 byte */
		{
			0x10, 0xd9, 0x92, 0x4e, 0xc0, 0x58, 0x4a, 0x45,
			0x42, 0x9b, 0x13, 0x6f, 0x70, 0xe4, 0x96, 0x67,
			0xc0, 0xde, 0xbe, 0xc0, 0xa0, 0xc3, 0xd3, 0xef,
			0xe2, 0x82, 0xbd, 0xc8, 0xe7, 0xd4, 0x3d, 0x3c,
			0x16, 0x69, 0xac, 0x97, 0xf3, 0xa9, 0x7d, 0x9f,
			0x3d, 0x89, 0xbc, 0x81, 0xdc, 0x42, 0xe3, 0x05,
			0x7f, 0x40, 0xea, 0x29, 0x16, 0xb1, 0xbc, 0x1a,
			0x60, 0x11, 0xcf, 0x63, 0x3b, 0xa2, 0xde, 0xde,
			0xfc, 0x60, 0x68, 0xd5, 0xcc, 0x7e, 0x02, 0xaf,
			0xdc, 0xbe, 0x52, 0xef, 0x0e, 0xaa, 0xdb, 0xde,
			0xea, 0xde, 0xca, 0xf4, 0x5b, 0x86, 0xc4, 0x63,
			0x9c, 0x8a, 0xa9, 0x0e, 0x2b, 0x85, 0x4a, 0x8f,
			0x24, 0x45, 0x72, 0xf4, 0x82, 0xdf, 0xbf, 0x44,
			0x74, 0xaa, 0x17, 0x89, 0x5d, 0xce, 0xe6, 0x85,
			0xfa, 0xc6, 0x82, 0x52, 0xd8, 0xc1, 0x64, 0xf0,
			0x53, 0xa5, 0x58, 0x1d, 0x37, 0x77, 0x28, 0xca,
			0x5b, 0x52, 0x35, 0x1b, 0x9f, 0x11, 0xec, 0xdf,
			0x5a, 0x1a, 0xf3, 0x86, 0x1f, 0x86, 0x2b, 0xa0,
			0xaf, 0xd6, 0xfd, 0xb3, 0x41, 0xbb, 0xa6, 0xd6,
			0x5d, 0xa5, 0x5f, 0xdd, 0x6d, 0x88, 0x7f, 0xfa,
			0x7c, 0x23, 0x81, 0x59, 0x23, 0x0f, 0x84, 0x62,
			0x21, 0xf2, 0xc3, 0x24, 0x7c, 0x0d, 0xf5, 0x0e,
			0x5c, 0x12, 0x3a, 0xf2, 0xb8, 0x3f, 0xba, 0x89,
			0xf7, 0x3c, 0xa6, 0x77, 0x40, 0xff, 0xb6, 0x43,
		},
	},
	/* SHA512 [5] */
	{
		/* Msg5 : 128 byte */
		{
			0x32, 0xa7, 0x3e, 0x45, 0xbf, 0xd5, 0x75, 0xa2,
			0xdf, 0x07, 0x67, 0x74, 0xb6, 0xe3, 0xf3, 0xaa,
			0xbf, 0x03, 0x1d, 0xcc, 0xb6, 0x49, 0x10, 0xec,
			0xb5, 0x72, 0x5f, 0xd9, 0x9d, 0xee, 0x90, 0x95,
			0xb7, 0xef, 0xdb, 0x09, 0x9b, 0xc1, 0x2f, 0xf8,
			0x51, 0x59, 0x76, 0x32, 0xb7, 0x30, 0x1a, 0x0a,
			0x22, 0x52, 0xc8, 0x09, 0x48, 0xb1, 0x74, 0xe4,
			0x5e, 0xc0, 0x9d, 0xac, 0x7d, 0x3d, 0xd2, 0x45,
			0x4a, 0x4e, 0x75, 0x19, 0xd6, 0xd0, 0xbf, 0x0d,
			0xc3, 0xec, 0x04, 0xb5, 0xa9, 0xeb, 0x38, 0xc3,
			0xb7, 0x4b, 0xb3, 0xc6, 0x9e, 0x12, 0x31, 0x11,
			0xaa, 0x62, 0x1d, 0xf8, 0x32, 0x4e, 0x0f, 0x43,
			0x33, 0xec, 0x93, 0xdc, 0x38, 0xab, 0x2c, 0xcb,
			0x7d, 0xe7, 0x98, 0x64, 0x53, 0xbb, 0x56, 0xbf,
			0xc6, 0x17, 0x66, 0x69, 0x7e, 0x12, 0x50, 0x59,
			0xe3, 0x81, 0x67, 0x26, 0x85, 0xc8, 0x4f, 0x77,
		},
		/* S5 : 192 byte */
		{
			0x12, 0x46, 0xdd, 0x0d, 0x02, 0xb8, 0x96, 0xb6,
			0xb2, 0xad, 0xf6, 0x5b, 0x5b, 0x12, 0xc0, 0x33,
			0x3a, 0xbe, 0x60, 0x48, 0xd5, 0xb6, 0x2c, 0x11,
			0x6b, 0xbc, 0xb0, 0xd0, 0x97, 0x4c, 0xdd, 0x30,
			0x38, 0x60, 0xb6, 0x45, 0x16, 0xf9, 0x99, 0x03,
			0xf9, 0x2d, 0xbe, 0xb3, 0x68, 0xdb, 0x19, 0xe9,
			0x2e, 0xd2, 0x4d, 0xfa, 0x1e, 0xd2, 0x33, 0x62,
			0xa8, 0xad, 0xe5, 0x52, 0x39, 0xdd, 0xb1, 0x3f,
			0xe9, 0x8e, 0x09, 0x91, 0x9b, 0xad, 0x11, 0x6e,
			0x5c, 0x95, 0x26, 0x9c, 0x62, 0xb1, 0x98, 0x67,
			0x2f, 0x27, 0xf5, 0x29, 0x69, 0xe2, 0x54, 0xed,
			0xb2, 0x7e, 0x9e, 0x3b, 0xea, 0x0c, 0xbb, 0x18,
			0xcf, 0x98, 0xab, 0xfe, 0x11, 0xd8, 0xbe, 0x73,
			0xe2, 0xa2, 0x10, 0x43, 0x6b, 0xe7, 0xd2, 0xeb,
			0x1b, 0x6a, 0x14, 0xc0, 0xfb, 0x28, 0xc5, 0x67,
			0x7b, 0x9d, 0x4c, 0xc2, 0x22, 0x9a, 0xff, 0xce,
			0xc9, 0x9d, 0x09, 0xda, 0xf9, 0x83, 0xc0, 0xf9,
			0x6c, 0x40, 0x2e, 0x39, 0x24, 0xfd, 0xd2, 0xa2,
			0x6c, 0x5e, 0x5b, 0x27, 0x4f, 0x18, 0x1d, 0xa4,
			0xe4, 0x3b, 0x57, 0x41, 0x81, 0x60, 0x9f, 0xea,
			0x05, 0xa6, 0x27, 0x38, 0x4f, 0x5a, 0x16, 0x14,
			0xa7, 0x61, 0x8c, 0x6b, 0x54, 0xd5, 0x9b, 0x21,
			0x84, 0x68, 0xe1, 0x0c, 0x3d, 0xda, 0xd1, 0x7c,
			0xbf, 0xf0, 0xbc, 0x3e, 0x53, 0xfc, 0x04, 0x2a,
		},
	},
	/* SHA512 [6] */
	{
		/* Msg6 : 128 byte */
		{
			0x78, 0xe2, 0xc1, 0xf9, 0x46, 0x35, 0xd3, 0xeb,
			0x3f, 0x1b, 0xe9, 0x8b, 0xf8, 0x69, 0xdc, 0x62,
			0xa3, 0x12, 0x1c, 0x2e, 0xd9, 0xe3, 0x97, 0x35,
			0x97, 0x70, 0xdd, 0xda, 0x86, 0x4e, 0x82, 0x6e,
			0x7f, 0x82, 0xc4, 0x48, 0x4e, 0x3a, 0x6e, 0x18,
			0xb6, 0xbb, 0xfd, 0x78, 0xb6, 0x9b, 0x00, 0xc4,
			0x0b, 0x30, 0xc5, 0x2c, 0xf6, 0x48, 0x31, 0x07,
			0x3f, 0x1a, 0xf0, 0x6a, 0x7a, 0x7d, 0xcf, 0xfa,
			0x89, 0x58, 0x65, 0xfe, 0x62, 0x5a, 0xf9, 0xb9,
			0x13, 0xeb, 0xa0, 0xf6, 0x03, 0x62, 0xa6, 0xe4,
			0x7a, 0x78, 0x2f, 0x24, 0x63, 0xfc, 0x1e, 0x21,
			0x51, 0xc9, 0x36, 0xa0, 0xc1, 0xf6, 0x7f, 0x98,
			0x9f, 0x4c, 0xec, 0x43, 0x0b, 0xfd, 0x3a, 0x75,
			0x5c, 0x92, 0x1b, 0x2d, 0x65, 0x26, 0x94, 0x69,
			0xf8, 0xd2, 0xa4, 0x3f, 0xa9, 0x68, 0x26, 0x2a,
			0xd4, 0x64, 0xf8, 0xa2, 0xe2, 0x1f, 0x5d, 0xef,
		},
		/* S6 : 192 byte */
		{
			0x18, 0x66, 0xae, 0xe1, 0x78, 0x76, 0x99, 0xe0,
			0xf5, 0x18, 0x80, 0x07, 0xe6, 0x7e, 0x2d, 0xb9,
			0x23, 0xcb, 0xa0, 0x96, 0x35, 0xd2, 0x95, 0xfb,
			0x72, 0xd0, 0xa1, 0x9c, 0xf0, 0x7f, 0xb8, 0x73,
			0x5e, 0x90, 0xf7, 0x96, 0x77, 0x50, 0x62, 0x75,
			0x69, 0x12, 0x0b, 0xbb, 0xa4, 0x82, 0xea, 0x7a,
			0xeb, 0xe0, 0x52, 0xb9, 0x9e, 0x99, 0x68, 0x60,
			0x5b, 0x97, 0x1c, 0x51, 0x21, 0xfc, 0x54, 0xcc,
			0x9b, 0x19, 0xcb, 0x57, 0x88, 0x31, 0xae, 0xfc,
			0x8e, 0x92, 0x27, 0xb6, 0x1c, 0xf8, 0xc1, 0xbb,
			0xf1, 0x23, 0xa6, 0xa1, 0x9f, 0x85, 0x5b, 0xc4,
			0x96, 0x42, 0x20, 0xb8, 0x38, 0xbe, 0x52, 0x7c,
			0x72, 0xcc, 0xea, 0xc3, 0x57, 0xeb, 0x8a, 0x90,
			0x2e, 0xfd, 0xe3, 0x22, 0x68, 0xba, 0x1f, 0xa7,
			0x94, 0x6b, 0x7b, 0x2a, 0xe8, 0xd4, 0x60, 0xda,
			0x6b, 0x85, 0xf4, 0x0a, 0x21, 0x6e, 0xdd, 0x43,
			0xc6, 0x03, 0xa2, 0xc7, 0xd6, 0x70, 0xdc, 0x81,
			0xda, 0xe7, 0x28, 0xba, 0x45, 0x76, 0x43, 0x82,
			0xc4, 0xdb, 0x1d, 0x07, 0x3f, 0x8a, 0xcb, 0x0d,
			0x7e, 0xd0, 0xe8, 0x7f, 0x23, 0x70, 0x53, 0x37,
			0x8f, 0x4c, 0xa3, 0x69, 0x53, 0xb5, 0x88, 0xeb,
			0x58, 0xc6, 0x38, 0xa0, 0x51, 0x67, 0x1d, 0xee,
			0x3b, 0xf1, 0x33, 0x88, 0x95, 0xef, 0x61, 0x77,
			0x6f, 0x88, 0xc3, 0xea, 0xbc, 0xf7, 0xe5, 0x81,
		},
	},
	/* SHA512 [7] */
	{
		/* Msg7 : 128 byte */
		{
			0xc6, 0x3e, 0x4c, 0x2d, 0x1b, 0x90, 0xa1, 0x8f,
			0x14, 0x89, 0x4f, 0xff, 0x97, 0xc3, 0x95, 0x8f,
			0x02, 0x76, 0xdc, 0xd5, 0x1d, 0x9d, 0x48, 0x36,
			0x4d, 0x54, 0x8d, 0x65, 0x0a, 0x85, 0x04, 0x26,
			0x92, 0xc3, 0xfe, 0x58, 0xdf, 0x76, 0x58, 0x32,
			0xd7, 0x39, 0x4f, 0xcd, 0xc4, 0x80, 0x96, 0xe2,
			0x03, 0x7e, 0xa6, 0xd6, 0x00, 0x46, 0x56, 0xf3,
			0x62, 0x30, 0xab, 0xf9, 0x82, 0x7e, 0xf1, 0xd5,
			0x22, 0x3f, 0x0a, 0xb0, 0x5c, 0x74, 0x07, 0x2b,
			0xd8, 0x72, 0xf5, 0xe9, 0x42, 0x87, 0xf9, 0x4f,
			0xfb, 0xe0, 0xa0, 0x87, 0x0f, 0xaa, 0x70, 0xcb,
			0x68, 0x78, 0xc3, 0xe0, 0x41, 0xe5, 0xd5, 0xe0,
			0xdd, 0x7a, 0x1b, 0x3d, 0x78, 0xd2, 0xd6, 0x03,
			0x7e, 0xfb, 0xe9, 0x5d, 0xfb, 0x20, 0xe7, 0x5b,
			0x52, 0x65, 0x71, 0xf2, 0x33, 0x13, 0xbf, 0x45,
			0xc7, 0xf5, 0x7c, 0x22, 0x2d, 0x02, 0xd7, 0xd0,
		},
		/* S7 : 192 byte */
		{
			0x93, 0x02, 0x51, 0x3e, 0x38, 0x91, 0x54, 0x38,
			0xf6, 0x28, 0x2d, 0xb4, 0x6c, 0xef, 0xdf, 0x35,
			0xd8, 0x7a, 0x0d, 0xe5, 0x9a, 0xc4, 0xd4, 0x96,
			0x3c, 0x21, 0x78, 0x10, 0x04, 0x40, 0x87, 0x3d,
			0xfe, 0xdf, 0x38, 0x60, 0x43, 0x20, 0xb8, 0x62,
			0xd4, 0x1d, 0x93, 0xf2, 0xd1, 0xcb, 0x41, 0xe0,
			0x67, 0x94, 0x4d, 0x48, 0xc2, 0xfc, 0x86, 0x5d,
			0xd9, 0xa6, 0x77, 0x7e, 0xe2, 0x8c, 0x16, 0x16,
			0x91, 0x48, 0x67, 0x6d, 0x7d, 0xec, 0x19, 0x0e,
			0xd1, 0xc1, 0xb5, 0xa2, 0x8a, 0xa3, 0xaf, 0x3f,
			0x0c, 0x64, 0xf3, 0xd5, 0xc1, 0x64, 0x3d, 0x13,
			0x48, 0x8b, 0xaf, 0x24, 0x4f, 0xf9, 0x74, 0x37,
			0x05, 0x5a, 0x7a, 0xc1, 0x72, 0x57, 0x42, 0x34,
			0x04, 0xe3, 0x1e, 0xdc, 0x92, 0x71, 0x62, 0xe6,
			0xd0, 0x87, 0x4f, 0xa1, 0xb6, 0x61, 0x52, 0x78,
			0x87, 0xe5, 0x6e, 0xc4, 0x79, 0x81, 0x7c, 0xee,
			0xf9, 0xd7, 0x7c, 0x7f, 0x49, 0x95, 0xff, 0x63,
			0xe9, 0xc3, 0x6b, 0xef, 0xc1, 0x7e, 0xba, 0x89,
			0x06, 0xdf, 0xcd, 0x56, 0x44, 0x95, 0x10, 0x6d,
			0x62, 0x22, 0x6d, 0x64, 0x4c, 0x8c, 0x3b, 0x01,
			0x53, 0x52, 0x01, 0xf5, 0xac, 0xa8, 0x87, 0x2b,
			0xcb, 0x7b, 0xb2, 0x2f, 0xa5, 0x73, 0x8c, 0xbe,
			0x2d, 0xf5, 0xbc, 0xd0, 0x8c, 0xe2, 0x59, 0x82,
			0x48, 0x5f, 0xac, 0xf6, 0x7d, 0x31, 0x60, 0x90,
		},
	},
	/* SHA512 [8] */
	{
		/* Msg8 : 128 byte */
		{
			0x21, 0xe9, 0xa5, 0x66, 0xb5, 0xc7, 0x80, 0xb6,
			0x5e, 0x3a, 0x1c, 0x42, 0xdf, 0x89, 0xf7, 0x9d,
			0x4c, 0x0b, 0x59, 0x00, 0xca, 0xdf, 0x37, 0x9b,
			0x96, 0xdc, 0x57, 0x2d, 0x49, 0xcb, 0xb5, 0xd3,
			0x5a, 0xd4, 0x26, 0x1d, 0xe4, 0x37, 0x3b, 0x67,
			0xa9, 0x3d, 0x68, 0x67, 0x58, 0x6d, 0x65, 0x02,
			0x0b, 0x02, 0xd5, 0x64, 0x14, 0x9d, 0x26, 0x4f,
			0xf9, 0x38, 0xb8, 0xb3, 0xbd, 0x5b, 0x41, 0x80,
			0x61, 0x92, 0x70, 0xb8, 0xab, 0x1e, 0xd0, 0xc8,
			0x26, 0xeb, 0xf0, 0x18, 0x6a, 0xc2, 0xc1, 0xe1,
			0x9d, 0xc0, 0x3f, 0x3f, 0x3a, 0x07, 0x53, 0x87,
			0x11, 0xb3, 0xf8, 0xda, 0x90, 0x10, 0x9e, 0xfa,
			0x40, 0x0a, 0xcb, 0x5d, 0x92, 0xe4, 0x08, 0x80,
			0xdc, 0x2d, 0xfb, 0x7e, 0x9f, 0xf0, 0xd1, 0xe1,
			0x0b, 0x2c, 0xdf, 0xb8, 0xc5, 0x83, 0x88, 0xea,
			0xe7, 0x36, 0x61, 0xc9, 0x49, 0x51, 0x93, 0xea,
		},
		/* S8 : 192 byte */
		{
			0x84, 0x71, 0xe6, 0xb4, 0x5d, 0xb1, 0x65, 0xc4,
			0x1b, 0xc9, 0xdd, 0x6f, 0xc6, 0xfc, 0x9f, 0xeb,
			0xce, 0x68, 0xb5, 0x37, 0x74, 0xdf, 0x10, 0x78,
			0x11, 0x80, 0x97, 0x43, 0x6e, 0xb3, 0x22, 0x7c,
			0x9d, 0x3d, 0x02, 0xa5, 0x4a, 0xb6, 0xe1, 0x40,
			0xe6, 0xbf, 0xac, 0xa1, 0xdb, 0xbf, 0xb2, 0xaa,
			0xfa, 0x79, 0x1b, 0x92, 0x2a, 0x41, 0xd7, 0xd1,
			0x3a, 0x7c, 0x3a, 0x6f, 0x7a, 0x64, 0x29, 0xd0,
			0x01, 0x2a, 0x03, 0x6b, 0x0d, 0x99, 0xe9, 0x56,
			0x03, 0x47, 0xd4, 0x3b, 0xe0, 0xca, 0x8c, 0xad,
			0x62, 0xc4, 0xc9, 0x42, 0xd7, 0x53, 0xd5, 0x48,
			0xab, 0x13, 0x8d, 0x66, 0xb7, 0xa6, 0x44, 0x84,
			0xcc, 0x64, 0x09, 0xac, 0x02, 0xc9, 0x1a, 0x8a,
			0xde, 0x51, 0xbc, 0x13, 0x52, 0x36, 0xc0, 0xa4,
			0x83, 0x37, 0x01, 0x92, 0xfa, 0x1f, 0x08, 0xae,
			0x2b, 0x3f, 0xb1, 0xd9, 0xf7, 0x97, 0x8f, 0x75,
			0x52, 0xa9, 0x41, 0xf1, 0x8c, 0xd5, 0x9e, 0xb5,
			0xf3, 0x11, 0x58, 0x71, 0x78, 0x7a, 0x3d, 0xd6,
			0xd5, 0x9c, 0xec, 0x46, 0x57, 0x21, 0xc8, 0x81,
			0x2a, 0x9c, 0x96, 0x02, 0xfa, 0x0a, 0x74, 0x16,
			0xd5, 0xd8, 0x09, 0x09, 0xf1, 0x42, 0x33, 0x86,
			0x87, 0x84, 0x39, 0x54, 0x71, 0xbc, 0x99, 0x83,
			0x94, 0x58, 0xe9, 0xa0, 0x3e, 0x54, 0xd4, 0xa7,
			0x10, 0xcc, 0x3b, 0xfd, 0xaa, 0x27, 0x5b, 0x14,
		},
	},
	/* SHA512 [9] */
	{
		/* Msg9 : 128 byte */
		{
			0xa1, 0x9e, 0xdc, 0xee, 0x04, 0xd1, 0x71, 0xec,
			0x1c, 0x94, 0x42, 0x6a, 0x08, 0xdd, 0x7c, 0xba,
			0x64, 0x2b, 0xb7, 0xdc, 0xbc, 0x21, 0x14, 0x45,
			0x46, 0x74, 0x88, 0xe0, 0xd0, 0x08, 0x77, 0x53,
			0xf7, 0x56, 0x85, 0x83, 0x9a, 0x11, 0xa9, 0x5a,
			0x8e, 0x09, 0x83, 0xc8, 0x93, 0x4f, 0xef, 0x07,
			0x87, 0x9a, 0xda, 0x24, 0xda, 0xe9, 0x54, 0xbb,
			0x42, 0x6a, 0xe7, 0x02, 0xb0, 0x9b, 0x27, 0x08,
			0x82, 0xaf, 0x8b, 0x3f, 0xfa, 0x33, 0x7b, 0x39,
			0xef, 0xf1, 0xaa, 0xaf, 0xc2, 0x15, 0xa6, 0xc7,
			0x94, 0x8e, 0xae, 0x96, 0xb6, 0xb7, 0xc3, 0xe4,
			0x61, 0x37, 0x01, 0x30, 0xa8, 0x26, 0x30, 0xf4,
			0xaa, 0x71, 0x97, 0x2b, 0x0c, 0x7f, 0x10, 0x0f,
			0xa7, 0x14, 0x62, 0x27, 0x7d, 0x76, 0xca, 0x81,
			0xf2, 0xcf, 0xdb, 0x3d, 0x39, 0xd3, 0x89, 0x4b,
			0x0c, 0xa2, 0x80, 0x74, 0xa0, 0xf0, 0xba, 0x9f,
		},
		/* S9 : 192 byte */
		{
			0x89, 0xf1, 0x74, 0x83, 0x50, 0x86, 0xd4, 0x09,
			0x6e, 0xe4, 0xbd, 0x71, 0xd5, 0xaf, 0xc2, 0xa8,
			0x93, 0x75, 0x13, 0x85, 0xd8, 0x33, 0x57, 0x7c,
			0xc3, 0xb9, 0xae, 0xcd, 0xde, 0xc1, 0x05, 0x8c,
			0x5e, 0xd7, 0x61, 0x2e, 0x1a, 0x11, 0x7f, 0x19,
			0x7d, 0x82, 0xff, 0x1b, 0xae, 0x9a, 0x4d, 0x2b,
			0xf2, 0x38, 0xda, 0xe5, 0xc2, 0x7c, 0x1b, 0xdc,
			0xee, 0x9e, 0x30, 0x23, 0xe3, 0x0c, 0xa9, 0xfe,
			0xaf, 0x12, 0xb3, 0x02, 0x51, 0x4b, 0x2e, 0x57,
			0x48, 0xed, 0xf3, 0x49, 0xa4, 0xa9, 0x74, 0x29,
			0xc4, 0x8f, 0xba, 0x8c, 0xf5, 0xab, 0x5e, 0x4d,
			0x2b, 0x9d, 0x10, 0xb8, 0x98, 0x82, 0xf7, 0x40,
			0x17, 0x16, 0x6c, 0x9c, 0x09, 0xa7, 0x8d, 0x40,
			0x01, 0xc8, 0x27, 0x90, 0x38, 0xeb, 0x64, 0xb5,
			0xae, 0xf6, 0x47, 0x3b, 0x45, 0x9e, 0x3f, 0x32,
			0x1d, 0x49, 0x06, 0x7e, 0xb4, 0x87, 0xf1, 0x34,
			0x38, 0xf8, 0x62, 0x48, 0xc3, 0x9c, 0x89, 0xb8,
			0x37, 0x1a, 0x4c, 0x4c, 0xce, 0x59, 0xda, 0x13,
			0x29, 0x95, 0xe8, 0x1c, 0x0a, 0x84, 0xf4, 0x95,
			0x4b, 0x46, 0x7c, 0x18, 0x3f, 0x31, 0xd1, 0x40,
			0xd8, 0xac, 0x7d, 0xb7, 0x2a, 0x08, 0xca, 0xe7,
			0xe1, 0x17, 0x22, 0xa6, 0xe6, 0x3e, 0x0e, 0x0d,
			0xee, 0x9b, 0xc9, 0xda, 0x00, 0x17, 0x90, 0x26,
			0x84, 0x0d, 0x3f, 0xc7, 0xad, 0x3f, 0x13, 0x1a,
		},
	},
};

typedef mod1536_t tv_t;


#include "siggen15test.c"
