/*** RFC 6229 ***/
/*
 * see also <http://crypto.stackexchange.com/questions/20897/what-are-the-plaintexts-for-the-rc4-stream-cipher-test-vectors-in-rfc6229>
 * :-)
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <aicrypto/ok_rc4.h>
#include "test_st.h"

#define NUM_KEYS	14
static unsigned char KEY[NUM_KEYS][32] = {
	{0x01,0x02,0x03,0x04,0x05},
	{0x01,0x02,0x03,0x04,0x05,0x06,0x07},
	{0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08},
	{0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a},
	{0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,
	 0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,0x10},
	{0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,
	 0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,0x10,
	 0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18},
	{0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,
	 0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,0x10,
	 0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,
	 0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,0x20},
	{0x83,0x32,0x22,0x77,0x2a},
	{0x19,0x10,0x83,0x32,0x22,0x77,0x2a},
	{0x64,0x19,0x10,0x83,0x32,0x22,0x77,0x2a},
	{0x8b,0x37,0x64,0x19,0x10,0x83,0x32,0x22,0x77,0x2a},
	{0xeb,0xb4,0x62,0x27,0xc6,0xcc,0x8b,0x37,
	 0x64,0x19,0x10,0x83,0x32,0x22,0x77,0x2a},
	{0xc1,0x09,0x16,0x39,0x08,0xeb,0xe5,0x1d,
	 0xeb,0xb4,0x62,0x27,0xc6,0xcc,0x8b,0x37,
	 0x64,0x19,0x10,0x83,0x32,0x22,0x77,0x2a},
	{0x1a,0xda,0x31,0xd5,0xcf,0x68,0x82,0x21,
	 0xc1,0x09,0x16,0x39,0x08,0xeb,0xe5,0x1d,
	 0xeb,0xb4,0x62,0x27,0xc6,0xcc,0x8b,0x37,
	 0x64,0x19,0x10,0x83,0x32,0x22,0x77,0x2a}
};
static const size_t kLen[] = {5, 7, 8, 10, 16, 24, 32};	// [j%7] two times.
static const size_t offSZ[] = {
	16,	// DEC   16
	224,	// DEC  240
	16,	// DEC  256
	240,	// DEC  496
	16,	// DEC  512
	240,	// DEC  752
	16,	// DEC  768
	240,	// DEC 1008
	16,	// DEC 1024
	496,	// DEC 1520
	16,	// DEC 1536
	496,	// DEC 2032
	16,	// DEC 2048
	1008,	// DEC 3056
	16,	// DEC 3072
	1008,	// DEC 4080
	16,	// DEC 4096
	0
};

int test_rfc6229(void) {
	Key_RC4 *rc4key;
	unsigned char in[4096+16], out[4096+16];
	const unsigned char *st_p = ST;
	int j;

	printf("Test vectors from RFC 6229\n");

	memset(in, 0, sizeof(in));

	for (j = 0; j < NUM_KEYS; j++) {
		unsigned char *p = out;
		int k, dec;
		printf("RC4 test %d -- ", j);
		if ((rc4key = RC4key_new(kLen[j % 7], KEY[j])) == NULL)
			return EXIT_FAILURE;

		RC4_do_crypt(rc4key, sizeof(in), in, out);

		dec = 0;
		for (k = 0; k < 18; k++) {
			int i;
			if (memcmp(st_p, p, 16) != 0) {
				printf("failed\nERROR\n");
				printf("DEC %.4d HEX %.4x:  ", dec, dec);
				for (i = 0; i < 16; i++)
					printf("%.2x ", p[i]);
				printf("\n");
				return EXIT_FAILURE;
			}
			st_p += 16;
			p += offSZ[k];
			dec += offSZ[k];
		}
		printf("ok\n");
		RC4key_free(rc4key);
	}
	return EXIT_SUCCESS;
}
