/*** RFC 2268, Section 5 ***/
/* Test vectors */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <aicrypto/ok_rc2.h>

#define NUM_KEYS	8
static /* const */ unsigned char KEY[NUM_KEYS][33] = {
	{0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00},	// case 0
	{0xff,0xff,0xff,0xff, 0xff,0xff,0xff,0xff},	// case 1
	{0x30,0x00,0x00,0x00, 0x00,0x00,0x00,0x00},	// case 2
	{0x88},						// case 3
	{0x88,0xbc,0xa9,0x0e, 0x90,0x87,0x5a},		// case 4
	{0x88,0xbc,0xa9,0x0e, 0x90,0x87,0x5a,0x7f,	// case 5
	 0x0f,0x79,0xc3,0x84, 0x62,0x7b,0xaf,0xb2},
	{0x88,0xbc,0xa9,0x0e, 0x90,0x87,0x5a,0x7f,	// case 6
	 0x0f,0x79,0xc3,0x84, 0x62,0x7b,0xaf,0xb2},
	{0x88,0xbc,0xa9,0x0e, 0x90,0x87,0x5a,0x7f,	// case 7
	 0x0f,0x79,0xc3,0x84, 0x62,0x7b,0xaf,0xb2,
	 0x16,0xf8,0x0a,0x6f, 0x85,0x92,0x05,0x84,
	 0xc4,0x2f,0xce,0xb0, 0xbe,0x25,0x5d,0xaf,0x1e}
};
static const size_t kLen[] = {8, 8, 8, 1, 7, 16, 16, 33};
static /* const */ unsigned char PT[] = {
	0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,	// case [03-7]
	0xff,0xff,0xff,0xff, 0xff,0xff,0xff,0xff,	// case 1
	0x10,0x00,0x00,0x00, 0x00,0x00,0x00,0x01	// case 2
};
static const size_t pidx[] = {0, 8, 16, 0, 0, 0, 0};
static const unsigned char CT[] = {
	0xeb,0xb7,0x73,0xf9, 0x93,0x27,0x8e,0xff,
	0x27,0x8b,0x27,0xe4, 0x2e,0x2f,0x0d,0x49,
	0x30,0x64,0x9e,0xdf, 0x9b,0xe7,0xd2,0xc2,
	0x61,0xa8,0xa2,0x44, 0xad,0xac,0xcc,0xf0,
	0x6c,0xcf,0x43,0x08, 0x97,0x4c,0x26,0x7f,
	0x1a,0x80,0x7d,0x27, 0x2b,0xbe,0x5d,0xb1,
	0x22,0x69,0x55,0x2a, 0xb0,0xf8,0x5c,0xa6,
	0x5b,0x78,0xd3,0xa4, 0x3d,0xff,0xf1,0xf1
};

/* rc2.c */
void RC2_encrypt(unsigned short *, unsigned short *, unsigned short *);

static void printf_cv(const char *msg, const unsigned char *cv, size_t sz) {
	int j;
	printf("%s = ", msg);
	for (j = 0; j < sz; j++) {
		printf("%02x", cv[j]);
		if (j % 4 == 3)
			printf(" ");
	}
	printf("\n");
}
static void printf_sv(const char *msg, const unsigned short *sv) {
	int j;
	printf("%s = ", msg);
	for (j = 0; j < 4; j++) {
		printf("%04x", sv[j]);
		if (j % 2 == 1)
			printf(" ");
	}
	printf("\n");
}

int test_rfc2268(void) {
	Key_RC2 *rc2key;
	unsigned short in[4], out[4];
	int rt = EXIT_SUCCESS;
	int j;
	const unsigned char *ct_p = CT;
	unsigned char out_c[8];

	printf("Test vectors from RFC 2268\n");
	for (j = 0; j < NUM_KEYS; j++) {
		int k;
		printf("test %d -- ", j);
		/*
		 * tests for cases 3, 4, 5, and 7 failed as of 2017/01/20.
		 * they are temporally skipped but should be fixed.
		 */
#if 0
		if ((j == 3) || (j == 4) || (j == 5) || (j == 7)) {
			printf("skipped\n");
			ct_p += 8;
			continue;
		}
#endif
#ifdef VERBOSE
		printf_cv("\nKey", KEY[j], kLen[j]);
#endif
		rc2key = RC2key_new(kLen[j], KEY[j]);

		uc2usLE(8, &PT[pidx[j]], in);
#ifdef VERBOSE
		printf_sv("Plaintext", in);
		printf_cv("Ciphertext", ct_p, 8);
#endif
		RC2_encrypt(in, out, rc2key->S);
		us2ucLE(4, out, out_c);
		if (memcmp(ct_p, out_c, 8) != 0) {
			printf("failed\nERROR:\n");
			printf_sv("Plaintext", in);
			printf_sv("Ciphertext", out);
			rt = EXIT_FAILURE;
		} else {
			printf("ok\n");
		}
		ct_p += 8;
		RC2key_free(rc2key);
	}
	return rt;
}
