/* rc2testfc.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <aicrypto/ok_rc2.h>

int test_rc2(){
	Key_RC2 *rckey;
	int i,j;
	unsigned char key[]={
		0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
		0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f};
	unsigned short in1[]={
		0xffee,0xddcc,0xbbaa,0x9988,
		0x7766,0x5544,0x3322,0x1100};

	unsigned char in2[]={
		0xff,0xee,0xdd,0xcc,0xbb,0xaa,0x99,0x88,
		0x77,0x66,0x55,0x44,0x33,0x22,0x11,0x00};

	unsigned char c2[32],r2[32];
	unsigned short in[4096],cry[4096],ret[4096];


	rckey = RC2key_new(16,key);
	RC2_set_iv(rckey,key);

	RC2_ecb_encrypt_s(rckey,8,in1,cry);
	RC2_ecb_decrypt_s(rckey,8,cry,ret);
	for(i=0;i<8;i++) printf("%.4x ",cry[i]); printf("\n");
	for(i=0;i<8;i++) printf("%.4x ",ret[i]); printf("\n");

	RC2_ecb_encrypt(rckey,16,in2,c2);
	RC2_ecb_decrypt(rckey,16,c2,r2);
	for(i=0;i<16;i++) printf("%.2x ",c2[i]); printf("\n");
	for(i=0;i<16;i++) printf("%.2x ",r2[i]); printf("\n");

	memcpy(rckey->iv,rckey->oiv,8);
	RC2_cbc_encrypt_s(rckey,8,in1,cry);
	memcpy(rckey->iv,rckey->oiv,8);
	RC2_cbc_decrypt_s(rckey,8,cry,ret);
	for(i=0;i<8;i++) printf("%.4x ",cry[i]); printf("\n");
	for(i=0;i<8;i++) printf("%.4x ",ret[i]); printf("\n");

	memcpy(rckey->iv,rckey->oiv,8);
	RC2_cbc_encrypt(rckey,16,in2,c2);
	memcpy(rckey->iv,rckey->oiv,8);
	RC2_cbc_decrypt(rckey,16,c2,r2);
	for(i=0;i<16;i++) printf("%.2x ",c2[i]); printf("\n");
	for(i=0;i<16;i++) printf("%.2x ",r2[i]); printf("\n");

	for(i=0;i<10;i++){
		for(j=0;j<4096;j++)
			in[j] = rand();

		RC2_ecb_encrypt_s(rckey,4096,in,cry);
		RC2_ecb_decrypt_s(rckey,4096,cry,ret);

		if(memcmp(in,ret,sizeof(short)*4096)){
			printf("error -- %d\n",i);
			return -1;
		}

		memcpy(rckey->iv,rckey->oiv,8);
		RC2_cbc_encrypt_s(rckey,4096,in,cry);
		memcpy(rckey->iv,rckey->oiv,8);
		RC2_cbc_decrypt_s(rckey,4096,cry,ret);

		if(memcmp(in,ret,sizeof(short)*4096)){
			printf("error -- %d\n",i);
			return -1;
		}
		printf("ok -- %d\n",i);
	}

	RC2key_free(rckey);
	return 0;
}
