/* rc2speed.c */
/*
 * Copyright (C) 1998-2002
 * Akira Iwata & Takuto Okuno
 * Akira Iwata Laboratory,
 * Nagoya Institute of Technology in Japan.
 *
 * All rights reserved.
 *
 * This software is written by Takuto Okuno(usapato@anet.ne.jp)
 * And if you want to contact us, send an email to Kimitake Wakayama
 * (wakayama@elcom.nitech.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software must
 *    display the following acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *    Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *     Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *   AKIRA IWATA LABORATORY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *   SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 *   IN NO EVENT SHALL AKIRA IWATA LABORATORY BE LIABLE FOR ANY SPECIAL,
 *   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *   FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *   NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <time.h>
#include <sys/types.h>
#include <sys/times.h>

#include "ok_rc2.h"

#define TIMES

/* The following if from times(3) man page.  It may need to be changed */
#ifndef HZ
# ifndef CLK_TCK
#  ifndef _BSD_CLK_TCK_ /* FreeBSD hack */
#   define HZ   100.0
#  else /* _BSD_CLK_TCK_ */
#   define HZ ((double)_BSD_CLK_TCK_)
#  endif
# else /* CLK_TCK */
#  define HZ ((double)CLK_TCK)
# endif
#endif

#define START   0
#define STOP    1

static double Time_F(int s){
    double ret;
#ifdef TIMES
    static struct tms tstart,tend;

    if (s == START)
    {
	times(&tstart);
	return(0);
    }
    else
    {
	times(&tend);
	ret=((double)(tend.tms_utime-tstart.tms_utime))/HZ;
	return((ret < 1e-3)?1e-3:ret);
    }
#else /* !times() */
    static destruct timeb tstart,tend;
    long i;

    if (s == START)
    {
	ftime(&tstart);
	return(0);
    }
    else
    {
	ftime(&tend);
	i=(long)tend.millitm-(long)tstart.millitm;
	ret=((double)(tend.time-tstart.time))+((double)i)/1000.0;
	return((ret < 0.001)?0.001:ret);
    }
#endif
}


int main(int argc,char **argv){
    Key_RC2 *rckey;
    int i,j;
    unsigned short S[64];
    unsigned char key[]={
	0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
	0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f};
    unsigned short in[4096],cry[4096],ret[4096];
    double tm;

    rckey = RC2key_new(16,key);
    RC2_set_iv(rckey,key);

    for(j=0;j<4096;j++)
	in[j] = rand();
    
    printf("----------RC2-SPEED-TEST----------\n");
    /* RC2 (64bit) ecb mode encryption */
    Time_F(START);
    for(i=0;i<400;i++){
	RC2_ecb_encrypt_s(rckey,4096,in,cry);
    }
    tm=Time_F(STOP);
    i = (int)(((double)3200)/tm); /* 3200 = (4096*2*400)/1024 */
    printf("RC2 (64bit) ecb-encryption   -> %d KB/s\n",i);


    /* RC2 (64bit) ecb mode decryption */
    Time_F(START);
    for(i=0;i<400;i++){
	RC2_ecb_decrypt_s(rckey,4096,cry,ret);
    }
    tm=Time_F(STOP);
    i = (int)(((double)3200)/tm); /* 3200 = (4096*2*400)/1024 */
    printf("RC2 (64bit) ecb-decryption   -> %d KB/s\n",i);


    /* RC2 (64bit) cbc mode encryption */
    Time_F(START);
    for(i=0;i<400;i++){
	RC2_cbc_encrypt_s(rckey,4096,in,cry);
    }
    tm=Time_F(STOP);
    i = (int)(((double)3200)/tm); /* 3200 = (4096*2*400)/1024 */
    printf("RC2 (64bit) cbc-encryption   -> %d KB/s\n",i);


    /* RC2 (64bit) cbc mode decryption */
    Time_F(START);
    for(i=0;i<400;i++){
	RC2_cbc_decrypt_s(rckey,4096,cry,ret);
    }
    tm=Time_F(STOP);
    i = (int)(((double)3200)/tm); /* 3200 = (4096*2*400)/1024 */
    printf("RC2 (64bit) cbc-decryption   -> %d KB/s\n",i);

    RC2key_free(rckey);
    return 0;
}



