/* poly1305.c */
/*
 * Copyright (c) 2017 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/index.html.
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */

#include <string.h>
#include <aicrypto/nrg_poly1305.h>

#include "poly1305-donna/poly1305-donna.c"

void poly1305_mac(const uint8_t *msg, const size_t bytes, const uint8_t *key,
		  uint8_t *tag)
{
	poly1305_context ctx;
	const uint8_t *p;
	size_t _bytes;
	int i;

	_bytes = bytes;
	for (i = 0; i < 16; i++)
		tag[i] = 0;

	poly1305_init(&ctx, key);
	p = msg;
	while (_bytes > poly1305_block_size) {
		poly1305_update(&ctx, p, poly1305_block_size);
		_bytes -= poly1305_block_size;
		p += poly1305_block_size;
	}
	poly1305_update(&ctx, p, _bytes);
	poly1305_finish(&ctx, tag);
}
