/*** RFC 4648 ***/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <aicrypto/ok_base64.h>

static const char in[7][7] = {
	"",
	"f",
	"fo",
	"foo",
	"foob",
	"fooba",
	"foobar"
};

static const char ans[7][9] = {
	"",
	"Zg==",
	"Zm8=",
	"Zm9v",
	"Zm9vYg==",
	"Zm9vYmE=",
	"Zm9vYmFy"
};

static const size_t sz[] = {1, 4, 4, 4, 8, 8, 8};

int test_rfc4648()
{
	char *out = NULL;
	int j, rsz;

	printf("Test vectors from RFC 4648\n");

	for (j = 0; j < 7; j++) {
		if ((out = Base64_encode(j, in[j], sz[j])) == NULL)
			return EXIT_FAILURE;

		printf("base64 encode %d -- ", j);
	
		if (memcmp(ans[j], out, sz[j]) != 0) {
			printf("failed\n");
			printf(" in = %s\nans = %s\nout = %s\n",
			       in[j], ans[j], out);
			return EXIT_FAILURE;
		}
		printf("ok\n");

		if ((out = Base64_decode(ans[j], &rsz)) == NULL)
			return EXIT_FAILURE;

		printf("base64 decode %d(%d) -- ", j, rsz);
		if (memcmp(in[j], out, j) != 0) {
			printf("failed\n");
			printf("in = %s, out = %s\n", in[j], out);
			return EXIT_FAILURE;
		}
		printf("ok\n");

		free(out);
	}
	return EXIT_SUCCESS;
}

int main(void)
{
	if (test_rfc4648())
		return EXIT_FAILURE;
	return EXIT_SUCCESS;
}
