/* gcmtestfc.c */
/*
 * Copyright (c) 2016 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/index.html.
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <aicrypto/nrg_modes.h>
#include <aicrypto/ok_aes.h>

#include "aesgcm_testvec.h"

#include "gcm.c"

#define TEST_OK(label, n)	printf("test gcm %s -- OK : %d\n", label, n);
#define TEST_NG(label, n)	printf("test gcm %s -- NG : %d\n", label, n);
#define TEST_ERROR(label, n)	printf("test gcm %s -- error! : %d\n", label, n);

#define TEST_AES_VEC(label)\
	gcm_param_t gcm_param;\
	Key *key;\
\
	key = (Key *) AESkey_new(sizeof(K), K, 16);\
\
	/* encrypt */\
	uint8_t dest[sizeof(T)];\
	gcm_param_set_key(&gcm_param, key);\
	gcm_param_set_iv(&gcm_param, IV, sizeof(IV));\
	gcm_param_set_aad(&gcm_param, NULL, 0);\
\
	bs128_t *h;  /* Hash subkey */\
	h = new_hash_subkey128(key, AES_encrypt_128);\
	if (memcmp(h->buf, H, sizeof(H)) == 0) {\
		TEST_OK(label, 1);\
	} else {\
		TEST_NG(label, 1);\
		bs_free(h);\
		return -1;\
	}\
\
	bs128_t *y0;\
	y0 = gen_pre_counter_block(&gcm_param.iv, h);\
	if (memcmp(y0->buf, Y0, sizeof(Y0)) == 0) {\
		TEST_OK(label, 2);\
	} else {\
		TEST_NG(label, 2);\
		bs_free(y0);\
		bs_free(h);\
		return -1;\
	}\
\
	uint8_t c[sizeof(P)]; /* ciphertext */\
	inccb_gctr(key, y0, P, sizeof(P), c, AES_encrypt_128);\
	if (memcmp(c, C, sizeof(C)) == 0) {\
		TEST_OK(label, 3);\
	} else {\
		TEST_NG(label, 3);\
	}\
\
	uint8_t p[sizeof(C)]; /* plaintext */\
	inccb_gctr(key, y0, C, sizeof(C), p, AES_encrypt_128);\
	if (memcmp(p, P, sizeof(P)) == 0) {\
		TEST_OK(label, 4);\
	} else {\
		TEST_NG(label, 4);\
	}\
\
	bs128_t *S; /* ghash */\
	S = ghash(h, NULL, 0, C, sizeof(C));			\
	if (memcmp(S->buf, GHASH_H_A_C_, sizeof(GHASH_H_A_C_)) == 0) {\
		TEST_OK(label, 5);\
	} else {\
		TEST_NG(label, 5);\
	}\
\
	uint8_t t[sizeof(S->buf)];\
	gctr(key, y0, S->buf, sizeof(S->buf), t, AES_encrypt_128);\
	if (memcmp(t, T, sizeof(T)) == 0) {\
		TEST_OK(label, 6);\
	} else {\
		TEST_NG(label, 6);\
	}\
\
	AESkey_free((Key_AES *) key);\
	gcm_param.ciph_key = NULL;


#define TEST_AES_VEC_A(label)\
	gcm_param_t gcm_param;\
	Key *key;\
\
	key = (Key *) AESkey_new(sizeof(K), K, 16);\
\
	/* encrypt */\
	uint8_t dest[sizeof(T)];\
	gcm_param_set_key(&gcm_param, key);\
	gcm_param_set_iv(&gcm_param, IV, sizeof(IV));\
	gcm_param_set_aad(&gcm_param, A, sizeof(A)); \
\
	bs128_t *h;  /* Hash subkey */\
	h = new_hash_subkey128(key, AES_encrypt_128);\
	if (memcmp(h->buf, H, sizeof(H)) == 0) {\
		TEST_OK(label, 1);\
	} else {\
		TEST_NG(label, 1);\
		bs_free(h);\
		return -1;\
	}\
\
	bs128_t *y0;\
	y0 = gen_pre_counter_block(&gcm_param.iv, h);\
	if (memcmp(y0->buf, Y0, sizeof(Y0)) == 0) {\
		TEST_OK(label, 2);\
	} else {\
		TEST_NG(label, 2);\
		bs_free(y0);\
		bs_free(h);\
		return -1;\
	}\
\
	uint8_t c[sizeof(P)]; /* ciphertext */\
	inccb_gctr(key, y0, P, sizeof(P), c, AES_encrypt_128);\
	if (memcmp(c, C, sizeof(C)) == 0) {\
		TEST_OK(label, 3);\
	} else {\
		TEST_NG(label, 3);\
	}\
\
	uint8_t p[sizeof(C)]; /* plaintext */\
	inccb_gctr(key, y0, C, sizeof(C), p, AES_encrypt_128);\
	if (memcmp(p, P, sizeof(P)) == 0) {\
		TEST_OK(label, 4);\
	} else {\
		TEST_NG(label, 4);\
	}\
\
	bs128_t *S; /* ghash */\
	S = ghash(h, A, sizeof(A), C, sizeof(C));			\
	if (memcmp(S->buf, GHASH_H_A_C_, sizeof(GHASH_H_A_C_)) == 0) {\
		TEST_OK(label, 5);\
	} else {\
		TEST_NG(label, 5);\
	}\
\
	uint8_t t[sizeof(S->buf)];\
	gctr(key, y0, S->buf, sizeof(S->buf), t, AES_encrypt_128);\
	if (memcmp(t, T, sizeof(T)) == 0) {\
		TEST_OK(label, 6);\
	} else {\
		TEST_NG(label, 6);\
	}\
\
	AESkey_free((Key_AES *) key);\
	gcm_param.ciph_key = NULL;

inline void _printhex(uint8_t *a, int32_t len)
{
	int i;

	printf("0x");
	for (i = 0; i < len; i++) {
		printf("%.2x", a[i]);
	}
	printf("\n");
}

int test_vec_01();
int test_vec_02();
int test_vec_03();
int test_vec_04();
int test_vec_05();
int test_vec_06();
int test_vec_07();
int test_vec_08();
int test_vec_09();
int test_vec_10();
int test_vec_11();
int test_vec_12();
int test_vec_13();
int test_vec_14();
int test_vec_15();
int test_vec_16();
int test_vec_17();
int test_vec_18();

/**
 * gcm-test-vectors/vec-01.txt
 */
int test_vec_01()
{
	AESGCM_TEST_VEC_01;

	TEST_AES_VEC("vec_01");

	return 0;
}
/**
 * gcm-test-vectors/vec-02.txt
 */
int test_vec_02()
{
	AESGCM_TEST_VEC_02;

	TEST_AES_VEC("vec_02");

	y0 = gen_pre_counter_block(&gcm_param.iv, h);
	inc_counter_block(y0, 128);
	if (memcmp(y0->buf, Y1, sizeof(Y1)) == 0) {
		TEST_OK("vec_02", 7);
	} else {
		TEST_NG("vec_02", 7);
	}

	return 0;
}
/**
 * gcm-test-vectors/vec-03.txt
 */
int test_vec_03()
{
	AESGCM_TEST_VEC_03;

	TEST_AES_VEC("vec_03");

	y0 = gen_pre_counter_block(&gcm_param.iv, h);
	inc_counter_block(y0, 128);
	if (memcmp(y0->buf, Y1, sizeof(Y1)) == 0) {
		TEST_OK("vec_03", 7);
	} else {
		TEST_NG("vec_03", 7);
	}
	inc_counter_block(y0, 128);
	if (memcmp(y0->buf, Y2, sizeof(Y2)) == 0) {
		TEST_OK("vec_03", 8);
	} else {
		TEST_NG("vec_03", 8);
	}
	inc_counter_block(y0, 128);
	if (memcmp(y0->buf, Y3, sizeof(Y3)) == 0) {
		TEST_OK("vec_03", 9);
	} else {
		TEST_NG("vec_03", 9);
	}
	inc_counter_block(y0, 128);
	if (memcmp(y0->buf, Y4, sizeof(Y4)) == 0) {
		TEST_OK("vec_03", 10);
	} else {
		TEST_NG("vec_03", 10);
	}

	return 0;
}
/**
 * gcm-test-vectors/vec-04.txt
 */
int test_vec_04()
{
	AESGCM_TEST_VEC_04;

	TEST_AES_VEC_A("vec_04");

	/* test inc_counter_block() */
	y0 = gen_pre_counter_block(&gcm_param.iv, h);
	inc_counter_block(y0, 128);
	if (memcmp(y0->buf, Y1, sizeof(Y1)) == 0) {
		TEST_OK("vec_04", 7);
	} else {
		TEST_NG("vec_04", 7);
	}
	inc_counter_block(y0, 128);
	if (memcmp(y0->buf, Y2, sizeof(Y2)) == 0) {
		TEST_OK("vec_04", 8);
	} else {
		TEST_NG("vec_04", 8);
	}
	inc_counter_block(y0, 128);
	if (memcmp(y0->buf, Y3, sizeof(Y3)) == 0) {
		TEST_OK("vec_04", 9);
	} else {
		TEST_NG("vec_04", 9);
	}
	inc_counter_block(y0, 128);
	if (memcmp(y0->buf, Y4, sizeof(Y4)) == 0) {
		TEST_OK("vec_04", 10);
	} else {
		TEST_NG("vec_04", 10);
	}

	return 0;
}
/**
 * gcm-test-vectors/vec-05.txt
 */
int test_vec_05()
{
	AESGCM_TEST_VEC_05;

	TEST_AES_VEC_A("vec_05");

	/* test inc_counter_block() */
	y0 = gen_pre_counter_block(&gcm_param.iv, h);
	inc_counter_block(y0, 128);
	if (memcmp(y0->buf, Y1, sizeof(Y1)) == 0) {
		TEST_OK("vec_05", 7);
	} else {
		TEST_NG("vec_05", 7);
	}
	inc_counter_block(y0, 128);
	if (memcmp(y0->buf, Y2, sizeof(Y2)) == 0) {
		TEST_OK("vec_05", 8);
	} else {
		TEST_NG("vec_05", 8);
	}
	inc_counter_block(y0, 128);
	if (memcmp(y0->buf, Y3, sizeof(Y3)) == 0) {
		TEST_OK("vec_05", 9);
	} else {
		TEST_NG("vec_05", 9);
	}
	inc_counter_block(y0, 128);
	if (memcmp(y0->buf, Y4, sizeof(Y4)) == 0) {
		TEST_OK("vec_05", 10);
	} else {
		TEST_NG("vec_05", 10);
	}

	return 0;
}
/**
 * gcm-test-vectors/vec-06.txt
 */
int test_vec_06()
{
	AESGCM_TEST_VEC_06;

	TEST_AES_VEC_A("vec_06");

	/* test inc_counter_block() */
	y0 = gen_pre_counter_block(&gcm_param.iv, h);
	inc_counter_block(y0, 128);
	if (memcmp(y0->buf, Y1, sizeof(Y1)) == 0) {
		TEST_OK("vec_06", 7);
	} else {
		TEST_NG("vec_06", 7);
	}
	inc_counter_block(y0, 128);
	if (memcmp(y0->buf, Y2, sizeof(Y2)) == 0) {
		TEST_OK("vec_06", 8);
	} else {
		TEST_NG("vec_06", 8);
	}
	inc_counter_block(y0, 128);
	if (memcmp(y0->buf, Y3, sizeof(Y3)) == 0) {
		TEST_OK("vec_06", 9);
	} else {
		TEST_NG("vec_06", 9);
	}
	inc_counter_block(y0, 128);
	if (memcmp(y0->buf, Y4, sizeof(Y4)) == 0) {
		TEST_OK("vec_06", 10);
	} else {
		TEST_NG("vec_06", 10);
	}

	return 0;
}
/**
 * gcm-test-vectors/vec-07.txt
 */
int test_vec_07()
{
	AESGCM_TEST_VEC_07;

	TEST_AES_VEC("vec_07");

	return 0;
}
/**
 * gcm-test-vectors/vec-08.txt
 */
int test_vec_08()
{
	AESGCM_TEST_VEC_08;

	TEST_AES_VEC("vec_08");

	return 0;
}
/**
 * gcm-test-vectors/vec-09.txt
 */
int test_vec_09()
{
	AESGCM_TEST_VEC_09;

	TEST_AES_VEC("vec_09");

	/* test inc_counter_block() */
	y0 = gen_pre_counter_block(&gcm_param.iv, h);
	inc_counter_block(y0, 128);
	if (memcmp(y0->buf, Y1, sizeof(Y1)) == 0) {
		TEST_OK("vec_09", 7);
	} else {
		TEST_NG("vec_09", 7);
	}
	inc_counter_block(y0, 128);
	if (memcmp(y0->buf, Y2, sizeof(Y2)) == 0) {
		TEST_OK("vec_09", 8);
	} else {
		TEST_NG("vec_09", 8);
	}
	inc_counter_block(y0, 128);
	if (memcmp(y0->buf, Y3, sizeof(Y3)) == 0) {
		TEST_OK("vec_09", 9);
	} else {
		TEST_NG("vec_09", 9);
	}
	inc_counter_block(y0, 128);
	if (memcmp(y0->buf, Y4, sizeof(Y4)) == 0) {
		TEST_OK("vec_09", 10);
	} else {
		TEST_NG("vec_09", 10);
	}

	return 0;
}
/**
 * gcm-test-vectors/vec-10.txt
 */
int test_vec_10()
{
	AESGCM_TEST_VEC_10;

	TEST_AES_VEC_A("vec_10");

	return 0;
}
/**
 * gcm-test-vectors/vec-11.txt
 */
int test_vec_11()
{
	AESGCM_TEST_VEC_11;

	TEST_AES_VEC_A("vec_11");

	return 0;
}
/**
 * gcm-test-vectors/vec-12.txt
 */
int test_vec_12()
{
	AESGCM_TEST_VEC_12;

	TEST_AES_VEC_A("vec_12");

	return 0;
}
/**
 * gcm-test-vectors/vec-13.txt
 */
int test_vec_13()
{
	AESGCM_TEST_VEC_13;

	TEST_AES_VEC("vec_13");

	return 0;
}
/**
 * gcm-test-vectors/vec-14.txt
 */
int test_vec_14()
{
	AESGCM_TEST_VEC_14;

	TEST_AES_VEC("vec_14");

	return 0;
}
/**
 * gcm-test-vectors/vec-15.txt
 */
int test_vec_15()
{
	AESGCM_TEST_VEC_15;

	TEST_AES_VEC("vec_15");

	return 0;
}
/**
 * gcm-test-vectors/vec-16.txt
 */
int test_vec_16()
{
	AESGCM_TEST_VEC_16;

	TEST_AES_VEC_A("vec_16");

	return 0;
}
/**
 * gcm-test-vectors/vec-17.txt
 */
int test_vec_17()
{
	AESGCM_TEST_VEC_17;

	TEST_AES_VEC_A("vec_17");

	return 0;
}
/**
 * gcm-test-vectors/vec-18.txt
 */
int test_vec_18()
{
	AESGCM_TEST_VEC_18;

	TEST_AES_VEC_A("vec_18");

	return 0;
}
