/* bs128test.c */
/*
 * Copyright (c) 2016 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/index.html.
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */

#include <stdio.h>
#include <stdlib.h>

int test_bs128_all(char *);
int test_bs_new(void);
int test_bs_get_len_1(void);
int test_bs_get_len_2(void);
int test_bs_set_zero_1(void);
int test_bs_set_zero_2(void);
int test_bs_set_zero_3(void);
int test_bs_get_data(void);
int test_bs_set_data(void);
int test_bs_copy(void);
int test_bs_clone(void);
int test_bs_check_bit_1(void);
int test_bs_check_bit_2(void);
int test_bs_xor(void);
int test_bs_rshift_1(void);

int main(int argc, char **argv)
{
	if (argc >= 2) {
		test_bs128_all(argv[1]);
		return EXIT_SUCCESS;
	}

	if (test_bs_new())
		exit(EXIT_FAILURE);

	if (test_bs_get_len_1())
		exit(EXIT_FAILURE);

	if (test_bs_get_len_2())
		exit(EXIT_FAILURE);

	if (test_bs_set_zero_1())
		exit(EXIT_FAILURE);

	if (test_bs_set_zero_2())
		exit(EXIT_FAILURE);

	if (test_bs_set_zero_3())
		exit(EXIT_FAILURE);

	if (test_bs_get_data()) {
		exit(EXIT_FAILURE);
	}

	if (test_bs_copy()) {
		exit(EXIT_FAILURE);
	}

	if (test_bs_clone()) {
		exit(EXIT_FAILURE);
	}

	if (test_bs_check_bit_1()) {
		exit(EXIT_FAILURE);
	}

	if (test_bs_check_bit_2()) {
		exit(EXIT_FAILURE);
	}

	if (test_bs_rshift_1()) {
		exit(EXIT_FAILURE);
	}

	return EXIT_SUCCESS;
}
