/* aesgcm_teestvec.h */
/*
 * Copyright (c) 2016 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/index.html.
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */
#ifndef INCLUSION_GUARD_UUID_C0C4DC92_A360_43CC_A2DD_258ED220FE74
#define INCLUSION_GUARD_UUID_C0C4DC92_A360_43CC_A2DD_258ED220FE74

#include <stdint.h>

/**
 * The test vector was obtained from the following URL:
 *
 * http://csrc.nist.gov/groups/ST/toolkit/BCM/documents/proposedmodes/gcm/gcm-test-vectors.tar.gz
 */

/**
 * gcm-test-vectors/vec-01.txt
 */
#define AESGCM_TEST_VEC_01 \
	/* K */\
	static uint8_t K[] = {\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00\
	};\
	/* P */\
	static uint8_t P[] = {	};\
	/* A (undefined) */\
	static uint8_t A[] = {	};\
	/* IV */\
	static uint8_t IV[] = {\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,\
		0x00, 0x00, 0x00, 0x00\
	};\
	/* H */\
	static uint8_t H[] = {\
		0x66, 0xe9, 0x4b, 0xd4, 0xef, 0x8a, 0x2c, 0x3b,\
		0x88, 0x4c, 0xfa, 0x59, 0xca, 0x34, 0x2b, 0x2e\
	};\
	/* Y_0 */\
	static uint8_t Y0[] = {\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01\
	};\
	/* E(K,Y_0) */\
	static uint8_t E_K_Y0_[] = {\
		0x58, 0xe2, 0xfc, 0xce, 0xfa, 0x7e, 0x30, 0x61,\
		0x36, 0x7f, 0x1d, 0x57, 0xa4, 0xe7, 0x45, 0x5a\
	};\
	/* len(A)||len(C) */\
	static uint8_t len_A_len_C_[] = {\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00\
	};\
	/* GHASH(H,A,C) */\
	static uint8_t GHASH_H_A_C_[] = {\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00\
	};\
	/* C */\
	static uint8_t C[] = {	};\
	/* T */\
	static uint8_t T[] = {\
		0x58, 0xe2, 0xfc, 0xce, 0xfa, 0x7e, 0x30, 0x61,\
		0x36, 0x7f, 0x1d, 0x57, 0xa4, 0xe7, 0x45, 0x5a\
	};

/**
 * gcm-test-vectors/vec-02.txt
 */
#define AESGCM_TEST_VEC_02 \
	/* K */\
	static uint8_t K[] = {\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00\
	};\
	/* P */\
	static uint8_t P[] = {\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00\
	};\
	/* A (undefined) */\
	static uint8_t A[] = {	};\
	/* IV */\
	static uint8_t IV[] = {\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,\
		0x00, 0x00, 0x00, 0x00\
	};\
	/* H */\
	static uint8_t H[] = {\
		0x66, 0xe9, 0x4b, 0xd4, 0xef, 0x8a, 0x2c, 0x3b,\
		0x88, 0x4c, 0xfa, 0x59, 0xca, 0x34, 0x2b, 0x2e\
	};\
	/* Y_0 */\
	static uint8_t Y0[] = {\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01\
	};\
	/* E(K,Y_0) */\
	static uint8_t E_K_Y0_[] = {\
		0x58, 0xe2, 0xfc, 0xce, 0xfa, 0x7e, 0x30, 0x61,\
		0x36, 0x7f, 0x1d, 0x57, 0xa4, 0xe7, 0x45, 0x5a\
	};\
	/* Y_1 */\
	static uint8_t Y1[] = {\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02\
	};\
	/* E(K,Y_1) */\
	static uint8_t E_K_Y1_[] = {\
		0x03, 0x88, 0xda, 0xce, 0x60, 0xb6, 0xa3, 0x92,\
		0xf3, 0x28, 0xc2, 0xb9, 0x71, 0xb2, 0xfe, 0x78\
	};\
	/* X_1 */\
	static uint8_t X1[] = {\
		0x5e, 0x2e, 0xc7, 0x46, 0x91, 0x70, 0x62, 0x88,\
		0x2c, 0x85, 0xb0, 0x68, 0x53, 0x53, 0xde, 0xb7\
	};\
	/* len(A)||len(C) */\
	static uint8_t len_A_len_C_[] = {\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80\
	};\
	/* GHASH(H,A,C) */\
	static uint8_t GHASH_H_A_C_[] = {\
		0xf3, 0x8c, 0xbb, 0x1a, 0xd6, 0x92, 0x23, 0xdc,\
		0xc3, 0x45, 0x7a, 0xe5, 0xb6, 0xb0, 0xf8, 0x85\
	};\
	/* C */\
	static uint8_t C[] = {\
		0x03, 0x88, 0xda, 0xce, 0x60, 0xb6, 0xa3, 0x92,\
		0xf3, 0x28, 0xc2, 0xb9, 0x71, 0xb2, 0xfe, 0x78\
	};\
	/* T */\
	static uint8_t T[] = {\
		0xab, 0x6e, 0x47, 0xd4, 0x2c, 0xec, 0x13, 0xbd,\
		0xf5, 0x3a, 0x67, 0xb2, 0x12, 0x57, 0xbd, 0xdf\
	};

/**
 * gcm-test-vectors/vec-03.txt
 */
#define AESGCM_TEST_VEC_03 \
	/* K */\
	static uint8_t K[] = {\
		0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,\
		0x6d, 0x6a, 0x8f, 0x94, 0x67, 0x30, 0x83, 0x08\
	};\
	/* P */\
	static uint8_t P[] = {\
		0xd9, 0x31, 0x32, 0x25, 0xf8, 0x84, 0x06, 0xe5,\
		0xa5, 0x59, 0x09, 0xc5, 0xaf, 0xf5, 0x26, 0x9a,\
		0x86, 0xa7, 0xa9, 0x53, 0x15, 0x34, 0xf7, 0xda,\
		0x2e, 0x4c, 0x30, 0x3d, 0x8a, 0x31, 0x8a, 0x72,\
		0x1c, 0x3c, 0x0c, 0x95, 0x95, 0x68, 0x09, 0x53,\
		0x2f, 0xcf, 0x0e, 0x24, 0x49, 0xa6, 0xb5, 0x25,\
		0xb1, 0x6a, 0xed, 0xf5, 0xaa, 0x0d, 0xe6, 0x57,\
		0xba, 0x63, 0x7b, 0x39, 0x1a, 0xaf, 0xd2, 0x55\
	};\
	/* A (undefined) */\
	static uint8_t A[] = {	};\
	/* IV */\
	static uint8_t IV[] = {\
		0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad,\
		0xde, 0xca, 0xf8, 0x88\
	};\
	/* H */\
	static uint8_t H[] = {\
		0xb8, 0x3b, 0x53, 0x37, 0x08, 0xbf, 0x53, 0x5d,\
		0x0a, 0xa6, 0xe5, 0x29, 0x80, 0xd5, 0x3b, 0x78\
	};\
	/* Y_0 */\
	static uint8_t Y0[] = {\
		0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad,\
		0xde, 0xca, 0xf8, 0x88, 0x00, 0x00, 0x00, 0x01\
	};\
	/* E(K,Y_0) */\
	static uint8_t E_K_Y0_[] = {\
		0x32, 0x47, 0x18, 0x4b, 0x3c, 0x4f, 0x69, 0xa4,\
		0x4d, 0xbc, 0xd2, 0x28, 0x87, 0xbb, 0xb4, 0x18\
	};\
	/* Y_1 */\
	static uint8_t Y1[] = {\
		0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad,\
		0xde, 0xca, 0xf8, 0x88, 0x00, 0x00, 0x00, 0x02\
	};\
	/* E(K,Y_1) */\
	static uint8_t E_K_Y1_[] = {\
		0x9b, 0xb2, 0x2c, 0xe7, 0xd9, 0xf3, 0x72, 0xc1,\
		0xee, 0x2b, 0x28, 0x72, 0x2b, 0x25, 0xf2, 0x06\
	};\
	/* Y_2 */\
	static uint8_t Y2[] = {\
		0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad,\
		0xde, 0xca, 0xf8, 0x88, 0x00, 0x00, 0x00, 0x03\
	};\
	/* E(K,Y_2) */\
	static uint8_t E_K_Y2_[] = {\
		0x65, 0x0d, 0x88, 0x7c, 0x39, 0x36, 0x53, 0x3a,\
		0x1b, 0x8d, 0x4e, 0x1e, 0xa3, 0x9d, 0x2b, 0x5c\
	};\
	/* Y_3 */\
	static uint8_t Y3[] = {\
		0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad,\
		0xde, 0xca, 0xf8, 0x88, 0x00, 0x00, 0x00, 0x04\
	};\
	/* E(K,Y_3) */\
	static uint8_t E_K_Y3_[] = {\
		0x3d, 0xe9, 0x18, 0x27, 0xc1, 0x0e, 0x9a, 0x4f,\
		0x52, 0x40, 0x64, 0x7e, 0xe5, 0x22, 0x1f, 0x20\
	};\
	/* Y_4 */\
	static uint8_t Y4[] = {\
		0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad,\
		0xde, 0xca, 0xf8, 0x88, 0x00, 0x00, 0x00, 0x05\
	};\
	/* E(K,Y_4) */\
	static uint8_t E_K_Y4_[] = {\
		0xaa, 0xc9, 0xe6, 0xcc, 0xc0, 0x07, 0x4a, 0xc0,\
		0x87, 0x3b, 0x9b, 0xa8, 0x5d, 0x90, 0x8b, 0xd0\
	};\
	/* X_1 */\
	static uint8_t X1[] = {\
		0x59, 0xed, 0x3f, 0x2b, 0xb1, 0xa0, 0xaa, 0xa0,\
		0x7c, 0x9f, 0x56, 0xc6, 0xa5, 0x04, 0x64, 0x7b\
	};\
	/* X_2 */\
	static uint8_t X2[] = {\
		0xb7, 0x14, 0xc9, 0x04, 0x83, 0x89, 0xaf, 0xd9,\
		0xf9, 0xbc, 0x5c, 0x1d, 0x43, 0x78, 0xe0, 0x52\
	};\
	/* X_3 */\
	static uint8_t X3[] = {\
		0x47, 0x40, 0x0c, 0x65, 0x77, 0xb1, 0xee, 0x8d,\
		0x8f, 0x40, 0xb2, 0x72, 0x1e, 0x86, 0xff, 0x10\
	};\
	/* X_4 */\
	static uint8_t X4[] = {\
		0x47, 0x96, 0xcf, 0x49, 0x46, 0x47, 0x04, 0xb5,\
		0xdd, 0x91, 0xf1, 0x59, 0xbb, 0x1b, 0x7f, 0x95\
	};\
	/* len(A)||len(C) */\
	static uint8_t len_A_len_C_[] = {\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00\
	};\
	/* GHASH(H,A,C) */\
	static uint8_t GHASH_H_A_C_[] = {\
		0x7f, 0x1b, 0x32, 0xb8, 0x1b, 0x82, 0x0d, 0x02,\
		0x61, 0x4f, 0x88, 0x95, 0xac, 0x1d, 0x4e, 0xac\
	};\
	/* C */\
	static uint8_t C[] = {\
		0x42, 0x83, 0x1e, 0xc2, 0x21, 0x77, 0x74, 0x24,\
		0x4b, 0x72, 0x21, 0xb7, 0x84, 0xd0, 0xd4, 0x9c,\
		0xe3, 0xaa, 0x21, 0x2f, 0x2c, 0x02, 0xa4, 0xe0,\
		0x35, 0xc1, 0x7e, 0x23, 0x29, 0xac, 0xa1, 0x2e,\
		0x21, 0xd5, 0x14, 0xb2, 0x54, 0x66, 0x93, 0x1c,\
		0x7d, 0x8f, 0x6a, 0x5a, 0xac, 0x84, 0xaa, 0x05,\
		0x1b, 0xa3, 0x0b, 0x39, 0x6a, 0x0a, 0xac, 0x97,\
		0x3d, 0x58, 0xe0, 0x91, 0x47, 0x3f, 0x59, 0x85\
	};\
	/* T */\
	static uint8_t T[] = {\
		0x4d, 0x5c, 0x2a, 0xf3, 0x27, 0xcd, 0x64, 0xa6,\
		0x2c, 0xf3, 0x5a, 0xbd, 0x2b, 0xa6, 0xfa, 0xb4\
	};

/**
 * gcm-test-vectors/vec-04.txt
 */
#define AESGCM_TEST_VEC_04 \
	/* K */\
	static uint8_t K[] = {\
		0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,\
		0x6d, 0x6a, 0x8f, 0x94, 0x67, 0x30, 0x83, 0x08\
	};\
	/* P */\
	static uint8_t P[] = {\
		0xd9, 0x31, 0x32, 0x25, 0xf8, 0x84, 0x06, 0xe5,\
		0xa5, 0x59, 0x09, 0xc5, 0xaf, 0xf5, 0x26, 0x9a,\
		0x86, 0xa7, 0xa9, 0x53, 0x15, 0x34, 0xf7, 0xda,\
		0x2e, 0x4c, 0x30, 0x3d, 0x8a, 0x31, 0x8a, 0x72,\
		0x1c, 0x3c, 0x0c, 0x95, 0x95, 0x68, 0x09, 0x53,\
		0x2f, 0xcf, 0x0e, 0x24, 0x49, 0xa6, 0xb5, 0x25,\
		0xb1, 0x6a, 0xed, 0xf5, 0xaa, 0x0d, 0xe6, 0x57,\
		0xba, 0x63, 0x7b, 0x39\
	};\
	/* A */\
	static uint8_t A[] = {\
		0xfe, 0xed, 0xfa, 0xce, 0xde, 0xad, 0xbe, 0xef,\
		0xfe, 0xed, 0xfa, 0xce, 0xde, 0xad, 0xbe, 0xef,\
		0xab, 0xad, 0xda, 0xd2\
	};\
	/* IV */\
	static uint8_t IV[] = {\
		0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad,\
		0xde, 0xca, 0xf8, 0x88\
	};\
	/* H */\
	static uint8_t H[] = {\
		0xb8, 0x3b, 0x53, 0x37, 0x08, 0xbf, 0x53, 0x5d,\
		0x0a, 0xa6, 0xe5, 0x29, 0x80, 0xd5, 0x3b, 0x78\
	};\
	/* Y_0 */\
	static uint8_t Y0[] = {\
		0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad,\
		0xde, 0xca, 0xf8, 0x88, 0x00, 0x00, 0x00, 0x01\
	};\
	/* E(K,Y_0) */\
	static uint8_t E_K_Y0_[] = {\
		0x32, 0x47, 0x18, 0x4b, 0x3c, 0x4f, 0x69, 0xa4,\
		0x4d, 0xbc, 0xd2, 0x28, 0x87, 0xbb, 0xb4, 0x18\
	};\
	/* X_1 */\
	static uint8_t X1[] = {\
		0xed, 0x56, 0xaa, 0xf8, 0xa7, 0x2d, 0x67, 0x04,\
		0x9f, 0xdb, 0x92, 0x28, 0xed, 0xba, 0x13, 0x22\
	};\
	/* X_2 */\
	static uint8_t X2[] = {\
		0xcd, 0x47, 0x22, 0x1c, 0xce, 0xf0, 0x55, 0x4e,\
		0xe4, 0xbb, 0x04, 0x4c, 0x88, 0x15, 0x03, 0x52\
	};\
	/* Y_1 */\
	static uint8_t Y1[] = {\
		0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad,\
		0xde, 0xca, 0xf8, 0x88, 0x00, 0x00, 0x00, 0x02\
	};\
	/* E(K,Y_1) */\
	static uint8_t E_K_Y1_[] = {\
		0x9b, 0xb2, 0x2c, 0xe7, 0xd9, 0xf3, 0x72, 0xc1,\
		0xee, 0x2b, 0x28, 0x72, 0x2b, 0x25, 0xf2, 0x06\
	};\
	/* Y_2 */\
	static uint8_t Y2[] = {\
		0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad,\
		0xde, 0xca, 0xf8, 0x88, 0x00, 0x00, 0x00, 0x03\
	};\
	/* E(K,Y_2) */\
	static uint8_t E_K_Y2_[] = {\
		0x65, 0x0d, 0x88, 0x7c, 0x39, 0x36, 0x53, 0x3a,\
		0x1b, 0x8d, 0x4e, 0x1e, 0xa3, 0x9d, 0x2b, 0x5c\
	};\
	/* Y_3 */\
	static uint8_t Y3[] = {\
		0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad,\
		0xde, 0xca, 0xf8, 0x88, 0x00, 0x00, 0x00, 0x04\
	};\
	/* E(K,Y_3) */\
	static uint8_t E_K_Y3_[] = {\
		0x3d, 0xe9, 0x18, 0x27, 0xc1, 0x0e, 0x9a, 0x4f,\
		0x52, 0x40, 0x64, 0x7e, 0xe5, 0x22, 0x1f, 0x20\
	};\
	/* Y_4 */\
	static uint8_t Y4[] = {\
		0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad,\
		0xde, 0xca, 0xf8, 0x88, 0x00, 0x00, 0x00, 0x05\
	};\
	/* E(K,Y_4) */\
	static uint8_t E_K_Y4_[] = {\
		0xaa, 0xc9, 0xe6, 0xcc, 0xc0, 0x07, 0x4a, 0xc0,\
		0x87, 0x3b, 0x9b, 0xa8, 0x5d, 0x90, 0x8b, 0xd0\
	};\
	/* X_3 */\
	static uint8_t X3[] = {\
		0x54, 0xf5, 0xe1, 0xb2, 0xb5, 0xa8, 0xf9, 0x52,\
		0x5c, 0x23, 0x92, 0x47, 0x51, 0xa3, 0xca, 0x51\
	};\
	/* X_4 */\
	static uint8_t X4[] = {\
		0x32, 0x4f, 0x58, 0x5c, 0x6f, 0xfc, 0x13, 0x59,\
		0xab, 0x37, 0x15, 0x65, 0xd6, 0xc4, 0x5f, 0x93\
	};\
	/* X_5 */\
	static uint8_t X5[] = {\
		0xca, 0x7d, 0xd4, 0x46, 0xaf, 0x4a, 0xa7, 0x0c,\
		0xc3, 0xc0, 0xcd, 0x5a, 0xbb, 0xa6, 0xaa, 0x1c\
	};\
	/* X_6 */\
	static uint8_t X6[] = {\
		0x15, 0x90, 0xdf, 0x9b, 0x2e, 0xb6, 0x76, 0x82,\
		0x89, 0xe5, 0x7d, 0x56, 0x27, 0x4c, 0x85, 0x70\
	};\
	/* len(A)||len(C) */\
	static uint8_t len_A_len_C_[] = {\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0,\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xe0\
	};\
	/* GHASH(H,A,C) */\
	static uint8_t GHASH_H_A_C_[] = {\
		0x69, 0x8e, 0x57, 0xf7, 0x0e, 0x6e, 0xcc, 0x7f,\
		0xd9, 0x46, 0x3b, 0x72, 0x60, 0xa9, 0xae, 0x5f\
	};\
	/* C */\
	static uint8_t C[] = {\
		0x42, 0x83, 0x1e, 0xc2, 0x21, 0x77, 0x74, 0x24,\
		0x4b, 0x72, 0x21, 0xb7, 0x84, 0xd0, 0xd4, 0x9c,\
		0xe3, 0xaa, 0x21, 0x2f, 0x2c, 0x02, 0xa4, 0xe0,\
		0x35, 0xc1, 0x7e, 0x23, 0x29, 0xac, 0xa1, 0x2e,\
		0x21, 0xd5, 0x14, 0xb2, 0x54, 0x66, 0x93, 0x1c,\
		0x7d, 0x8f, 0x6a, 0x5a, 0xac, 0x84, 0xaa, 0x05,\
		0x1b, 0xa3, 0x0b, 0x39, 0x6a, 0x0a, 0xac, 0x97,\
		0x3d, 0x58, 0xe0, 0x91\
	};\
	/* T */\
	static uint8_t T[] = {\
		0x5b, 0xc9, 0x4f, 0xbc, 0x32, 0x21, 0xa5, 0xdb,\
		0x94, 0xfa, 0xe9, 0x5a, 0xe7, 0x12, 0x1a, 0x47\
	};

/**
 * gcm-test-vectors/vec-05.txt
 */
#define AESGCM_TEST_VEC_05 \
	/* K */\
	static uint8_t K[] = {\
		0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,\
		0x6d, 0x6a, 0x8f, 0x94, 0x67, 0x30, 0x83, 0x08\
	};\
	/* P */\
	static uint8_t P[] = {\
		0xd9, 0x31, 0x32, 0x25, 0xf8, 0x84, 0x06, 0xe5,\
		0xa5, 0x59, 0x09, 0xc5, 0xaf, 0xf5, 0x26, 0x9a,\
		0x86, 0xa7, 0xa9, 0x53, 0x15, 0x34, 0xf7, 0xda,\
		0x2e, 0x4c, 0x30, 0x3d, 0x8a, 0x31, 0x8a, 0x72,\
		0x1c, 0x3c, 0x0c, 0x95, 0x95, 0x68, 0x09, 0x53,\
		0x2f, 0xcf, 0x0e, 0x24, 0x49, 0xa6, 0xb5, 0x25,\
		0xb1, 0x6a, 0xed, 0xf5, 0xaa, 0x0d, 0xe6, 0x57,\
		0xba, 0x63, 0x7b, 0x39\
	};\
	/* A */\
	static uint8_t A[] = {\
		0xfe, 0xed, 0xfa, 0xce, 0xde, 0xad, 0xbe, 0xef,\
		0xfe, 0xed, 0xfa, 0xce, 0xde, 0xad, 0xbe, 0xef,\
		0xab, 0xad, 0xda, 0xd2\
	};\
	/* IV */\
	static uint8_t IV[] = {\
		0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad\
	};\
	/* H */\
	static uint8_t H[] = {\
		0xb8, 0x3b, 0x53, 0x37, 0x08, 0xbf, 0x53, 0x5d,\
		0x0a, 0xa6, 0xe5, 0x29, 0x80, 0xd5, 0x3b, 0x78\
	};\
	/* N_1 */\
	static uint8_t N1[] = {\
		0x6f, 0x28, 0x8b, 0x84, 0x6e, 0x5f, 0xed, 0x9a,\
		0x18, 0x37, 0x68, 0x29, 0xc8, 0x6a, 0x6a, 0x16\
	};\
	/* 0^{64}||len(IV) */\
	static uint8_t O64len_IV_[] = {\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40\
	};\
	/* Y_0 */\
	static uint8_t Y0[] = {\
		0xc4, 0x3a, 0x83, 0xc4, 0xc4, 0xba, 0xde, 0xc4,\
		0x35, 0x4c, 0xa9, 0x84, 0xdb, 0x25, 0x2f, 0x7d\
	};\
	/* E(K,Y_0) */\
	static uint8_t E_K_Y0_[] = {\
		0xe9, 0x4a, 0xb9, 0x53, 0x5c, 0x72, 0xbe, 0xa9,\
		0xe0, 0x89, 0xc9, 0x3d, 0x48, 0xe6, 0x2f, 0xb0\
	};\
	/* X_1 */\
	static uint8_t X1[] = {\
		0xed, 0x56, 0xaa, 0xf8, 0xa7, 0x2d, 0x67, 0x04,\
		0x9f, 0xdb, 0x92, 0x28, 0xed, 0xba, 0x13, 0x22\
	};\
	/* X_2 */\
	static uint8_t X2[] = {\
		0xcd, 0x47, 0x22, 0x1c, 0xce, 0xf0, 0x55, 0x4e,\
		0xe4, 0xbb, 0x04, 0x4c, 0x88, 0x15, 0x03, 0x52\
	};\
	/* Y_1 */\
	static uint8_t Y1[] = {\
		0xc4, 0x3a, 0x83, 0xc4, 0xc4, 0xba, 0xde, 0xc4,\
		0x35, 0x4c, 0xa9, 0x84, 0xdb, 0x25, 0x2f, 0x7e\
	};\
	/* E(K,Y_1) */\
	static uint8_t E_K_Y1_[] = {\
		0xb8, 0x04, 0x09, 0x69, 0xd0, 0x82, 0x95, 0xaf,\
		0xd2, 0x26, 0xfc, 0xda, 0x0d, 0xdf, 0x61, 0xcf\
	};\
	/* Y_2 */\
	static uint8_t Y2[] = {\
		0xc4, 0x3a, 0x83, 0xc4, 0xc4, 0xba, 0xde, 0xc4,\
		0x35, 0x4c, 0xa9, 0x84, 0xdb, 0x25, 0x2f, 0x7f\
	};\
	/* E(K,Y_2) */\
	static uint8_t E_K_Y2_[] = {\
		0xef, 0x3c, 0x83, 0x22, 0x5a, 0xf9, 0x31, 0x22,\
		0x19, 0x2a, 0xd5, 0xc4, 0xf1, 0x5d, 0xfe, 0x51\
	};\
	/* Y_3 */\
	static uint8_t Y3[] = {\
		0xc4, 0x3a, 0x83, 0xc4, 0xc4, 0xba, 0xde, 0xc4,\
		0x35, 0x4c, 0xa9, 0x84, 0xdb, 0x25, 0x2f, 0x80\
	};\
	/* E(K,Y_3) */\
	static uint8_t E_K_Y3_[] = {\
		0x6f, 0xbc, 0x65, 0x95, 0x71, 0xf7, 0x2d, 0xe1,\
		0x04, 0xc6, 0x7b, 0x60, 0x9d, 0x2f, 0xde, 0x67\
	};\
	/* Y_4 */\
	static uint8_t Y4[] = {\
		0xc4, 0x3a, 0x83, 0xc4, 0xc4, 0xba, 0xde, 0xc4,\
		0x35, 0x4c, 0xa9, 0x84, 0xdb, 0x25, 0x2f, 0x81\
	};\
	/* E(K,Y_4) */\
	static uint8_t E_K_Y4_[] = {\
		0xf8, 0xe3, 0x58, 0x14, 0x41, 0xa1, 0xe9, 0x50,\
		0x78, 0x5c, 0x3e, 0xa1, 0x43, 0x0c, 0x6f, 0xa6\
	};\
	/* X_3 */\
	static uint8_t X3[] = {\
		0x93, 0x79, 0xe2, 0xfe, 0xae, 0x14, 0x64, 0x9c,\
		0x86, 0xcf, 0x22, 0x50, 0xe3, 0xa8, 0x19, 0x16\
	};\
	/* X_4 */\
	static uint8_t X4[] = {\
		0x65, 0xdd, 0xe9, 0x04, 0xc9, 0x2a, 0x6b, 0x3d,\
		0xb8, 0x77, 0xc4, 0x81, 0x7b, 0x50, 0xa5, 0xf4\
	};\
	/* X_5 */\
	static uint8_t X5[] = {\
		0x48, 0xc5, 0x3c, 0xf8, 0x63, 0xb4, 0x9a, 0x1b,\
		0x0b, 0xbf, 0xc4, 0x8c, 0x3b, 0xaa, 0xa8, 0x9d\
	};\
	/* X_6 */\
	static uint8_t X6[] = {\
		0x08, 0xc8, 0x73, 0xf1, 0xc8, 0xce, 0xc3, 0xef,\
		0xfc, 0x20, 0x9a, 0x07, 0x46, 0x8c, 0xaa, 0xb1\
	};\
	/* len(A)||len(C) */\
	static uint8_t len_A_len_C_[] = {\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0,\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xe0\
	};\
	/* GHASH(H,A,C) */\
	static uint8_t GHASH_H_A_C_[] = {\
		0xdf, 0x58, 0x6b, 0xb4, 0xc2, 0x49, 0xb9, 0x2c,\
		0xb6, 0x92, 0x28, 0x77, 0xe4, 0x44, 0xd3, 0x7b\
	};\
	/* C */\
	static uint8_t C[] = {\
		0x61, 0x35, 0x3b, 0x4c, 0x28, 0x06, 0x93, 0x4a,\
		0x77, 0x7f, 0xf5, 0x1f, 0xa2, 0x2a, 0x47, 0x55,\
		0x69, 0x9b, 0x2a, 0x71, 0x4f, 0xcd, 0xc6, 0xf8,\
		0x37, 0x66, 0xe5, 0xf9, 0x7b, 0x6c, 0x74, 0x23,\
		0x73, 0x80, 0x69, 0x00, 0xe4, 0x9f, 0x24, 0xb2,\
		0x2b, 0x09, 0x75, 0x44, 0xd4, 0x89, 0x6b, 0x42,\
		0x49, 0x89, 0xb5, 0xe1, 0xeb, 0xac, 0x0f, 0x07,\
		0xc2, 0x3f, 0x45, 0x98\
	};\
	/* T */\
	static uint8_t T[] = {\
		0x36, 0x12, 0xd2, 0xe7, 0x9e, 0x3b, 0x07, 0x85,\
		0x56, 0x1b, 0xe1, 0x4a, 0xac, 0xa2, 0xfc, 0xcb\
	};

/**
 * gcm-test-vectors/vec-06.txt
 */
#define AESGCM_TEST_VEC_06 \
	/* K */\
	static uint8_t K[] = {\
		0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,\
		0x6d, 0x6a, 0x8f, 0x94, 0x67, 0x30, 0x83, 0x08\
	};\
	/* P */\
	static uint8_t P[] = {\
		0xd9, 0x31, 0x32, 0x25, 0xf8, 0x84, 0x06, 0xe5,\
		0xa5, 0x59, 0x09, 0xc5, 0xaf, 0xf5, 0x26, 0x9a,\
		0x86, 0xa7, 0xa9, 0x53, 0x15, 0x34, 0xf7, 0xda,\
		0x2e, 0x4c, 0x30, 0x3d, 0x8a, 0x31, 0x8a, 0x72,\
		0x1c, 0x3c, 0x0c, 0x95, 0x95, 0x68, 0x09, 0x53,\
		0x2f, 0xcf, 0x0e, 0x24, 0x49, 0xa6, 0xb5, 0x25,\
		0xb1, 0x6a, 0xed, 0xf5, 0xaa, 0x0d, 0xe6, 0x57,\
		0xba, 0x63, 0x7b, 0x39\
	};\
	/* A */\
	static uint8_t A[] = {\
		0xfe, 0xed, 0xfa, 0xce, 0xde, 0xad, 0xbe, 0xef,\
		0xfe, 0xed, 0xfa, 0xce, 0xde, 0xad, 0xbe, 0xef,\
		0xab, 0xad, 0xda, 0xd2\
	};\
	/* IV */\
	static uint8_t IV[] = {\
		0x93, 0x13, 0x22, 0x5d, 0xf8, 0x84, 0x06, 0xe5,\
		0x55, 0x90, 0x9c, 0x5a, 0xff, 0x52, 0x69, 0xaa,\
		0x6a, 0x7a, 0x95, 0x38, 0x53, 0x4f, 0x7d, 0xa1,\
		0xe4, 0xc3, 0x03, 0xd2, 0xa3, 0x18, 0xa7, 0x28,\
		0xc3, 0xc0, 0xc9, 0x51, 0x56, 0x80, 0x95, 0x39,\
		0xfc, 0xf0, 0xe2, 0x42, 0x9a, 0x6b, 0x52, 0x54,\
		0x16, 0xae, 0xdb, 0xf5, 0xa0, 0xde, 0x6a, 0x57,\
		0xa6, 0x37, 0xb3, 0x9b\
	};\
	/* H */\
	static uint8_t H[] = {\
		0xb8, 0x3b, 0x53, 0x37, 0x08, 0xbf, 0x53, 0x5d,\
		0x0a, 0xa6, 0xe5, 0x29, 0x80, 0xd5, 0x3b, 0x78\
	};\
	/* N_1 */\
	static uint8_t N1[] = {\
		0x00, 0x4d, 0x65, 0x99, 0xd7, 0xfb, 0x16, 0x34,\
		0x75, 0x6e, 0x1e, 0x29, 0x9d, 0x81, 0x63, 0x0f\
	};\
	/* N_2 */\
	static uint8_t N2[] = {\
		0x88, 0xff, 0xe8, 0xa3, 0xc8, 0x03, 0x3d, 0xf4,\
		0xb5, 0x4d, 0x73, 0x2f, 0x7f, 0x88, 0x40, 0x8e\
	};\
	/* N_3 */\
	static uint8_t N3[] = {\
		0x24, 0xe6, 0x94, 0xcf, 0xab, 0x65, 0x7b, 0xea,\
		0xbb, 0xa8, 0x05, 0x5a, 0xad, 0x49, 0x5e, 0x23\
	};\
	/* N_4 */\
	static uint8_t N4[] = {\
		0xd8, 0x34, 0x9a, 0x5e, 0xda, 0x24, 0x94, 0x3c,\
		0x8f, 0xbb, 0x2e, 0xf5, 0x16, 0x8b, 0x20, 0xcb\
	};\
	/* 0^{64}||len(IV) */\
	static uint8_t O64len_IV_[] = {\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xe0\
	};\
	/* Y_0 */\
	static uint8_t Y0[] = {\
		0x3b, 0xab, 0x75, 0x78, 0x0a, 0x31, 0xc0, 0x59,\
		0xf8, 0x3d, 0x2a, 0x44, 0x75, 0x2f, 0x98, 0x64\
	};\
	/* E(K,Y_0) */\
	static uint8_t E_K_Y0_[] = {\
		0x7d, 0xc6, 0x3b, 0x39, 0x9f, 0x2d, 0x98, 0xd5,\
		0x7a, 0xb0, 0x73, 0xb6, 0xba, 0xa4, 0x13, 0x8e\
	};\
	/* X_1 */\
	static uint8_t X1[] = {\
		0xed, 0x56, 0xaa, 0xf8, 0xa7, 0x2d, 0x67, 0x04,\
		0x9f, 0xdb, 0x92, 0x28, 0xed, 0xba, 0x13, 0x22\
	};\
	/* X_2 */\
	static uint8_t X2[] = {\
		0xcd, 0x47, 0x22, 0x1c, 0xce, 0xf0, 0x55, 0x4e,\
		0xe4, 0xbb, 0x04, 0x4c, 0x88, 0x15, 0x03, 0x52\
	};\
	/* Y_1 */\
	static uint8_t Y1[] = {\
		0x3b, 0xab, 0x75, 0x78, 0x0a, 0x31, 0xc0, 0x59,\
		0xf8, 0x3d, 0x2a, 0x44, 0x75, 0x2f, 0x98, 0x65\
	};\
	/* E(K,Y_1) */\
	static uint8_t E_K_Y1_[] = {\
		0x55, 0xd3, 0x7b, 0xbd, 0x9a, 0xd2, 0x13, 0x53,\
		0xa6, 0xf9, 0x3a, 0x69, 0x0e, 0xca, 0x9e, 0x0e\
	};\
	/* Y_2 */\
	static uint8_t Y2[] = {\
		0x3b, 0xab, 0x75, 0x78, 0x0a, 0x31, 0xc0, 0x59,\
		0xf8, 0x3d, 0x2a, 0x44, 0x75, 0x2f, 0x98, 0x66\
	};\
	/* E(K,Y_2) */\
	static uint8_t E_K_Y2_[] = {\
		0x38, 0x36, 0xbb, 0xf6, 0xd6, 0x96, 0xe6, 0x72,\
		0x94, 0x6a, 0x1a, 0x01, 0x40, 0x4f, 0xa6, 0xd5\
	};\
	/* Y_3 */\
	static uint8_t Y3[] = {\
		0x3b, 0xab, 0x75, 0x78, 0x0a, 0x31, 0xc0, 0x59,\
		0xf8, 0x3d, 0x2a, 0x44, 0x75, 0x2f, 0x98, 0x67\
	};\
	/* E(K,Y_3) */\
	static uint8_t E_K_Y3_[] = {\
		0x1d, 0xd8, 0xa5, 0x31, 0x6e, 0xcc, 0x35, 0xc3,\
		0xe3, 0x13, 0xbc, 0xa5, 0x9d, 0x2a, 0xc9, 0x4a\
	};\
	/* Y_4 */\
	static uint8_t Y4[] = {\
		0x3b, 0xab, 0x75, 0x78, 0x0a, 0x31, 0xc0, 0x59,\
		0xf8, 0x3d, 0x2a, 0x44, 0x75, 0x2f, 0x98, 0x68\
	};\
	/* E(K,Y_4) */\
	static uint8_t E_K_Y4_[] = {\
		0x67, 0x42, 0x98, 0x27, 0x06, 0xa9, 0xf1, 0x54,\
		0xf6, 0x57, 0xd5, 0xdc, 0x94, 0xb7, 0x46, 0xdb\
	};\
	/* X_3 */\
	static uint8_t X3[] = {\
		0x31, 0x72, 0x76, 0x69, 0xc6, 0x3c, 0x6f, 0x07,\
		0x8b, 0x5d, 0x22, 0xad, 0xbb, 0xbc, 0xa3, 0x84\
	};\
	/* X_4 */\
	static uint8_t X4[] = {\
		0x48, 0x0c, 0x00, 0xdb, 0x26, 0x79, 0x06, 0x5a,\
		0x7e, 0xd2, 0xf7, 0x71, 0xa5, 0x3a, 0xca, 0xcd\
	};\
	/* X_5 */\
	static uint8_t X5[] = {\
		0x1c, 0x1a, 0xe3, 0xc3, 0x55, 0xe2, 0x21, 0x44,\
		0x66, 0xa9, 0x92, 0x3d, 0x2b, 0xa6, 0xab, 0x35\
	};\
	/* X_6 */\
	static uint8_t X6[] = {\
		0x06, 0x94, 0xc6, 0xf1, 0x6b, 0xb0, 0x27, 0x5a,\
		0x48, 0x89, 0x1d, 0x06, 0x59, 0x03, 0x44, 0xb0\
	};\
	/* len(A)||len(C) */\
	static uint8_t len_A_len_C_[] = {\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0,\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xe0\
	};\
	/* GHASH(H,A,C) */\
	static uint8_t GHASH_H_A_C_[] = {\
		0x1c, 0x5a, 0xfe, 0x97, 0x60, 0xd3, 0x93, 0x2f,\
		0x3c, 0x9a, 0x87, 0x8a, 0xac, 0x3d, 0xc3, 0xde\
	};\
	/* C */\
	static uint8_t C[] = {\
		0x8c, 0xe2, 0x49, 0x98, 0x62, 0x56, 0x15, 0xb6,\
		0x03, 0xa0, 0x33, 0xac, 0xa1, 0x3f, 0xb8, 0x94,\
		0xbe, 0x91, 0x12, 0xa5, 0xc3, 0xa2, 0x11, 0xa8,\
		0xba, 0x26, 0x2a, 0x3c, 0xca, 0x7e, 0x2c, 0xa7,\
		0x01, 0xe4, 0xa9, 0xa4, 0xfb, 0xa4, 0x3c, 0x90,\
		0xcc, 0xdc, 0xb2, 0x81, 0xd4, 0x8c, 0x7c, 0x6f,\
		0xd6, 0x28, 0x75, 0xd2, 0xac, 0xa4, 0x17, 0x03,\
		0x4c, 0x34, 0xae, 0xe5\
	};\
	/* T */\
	static uint8_t T[] = {\
		0x61, 0x9c, 0xc5, 0xae, 0xff, 0xfe, 0x0b, 0xfa,\
		0x46, 0x2a, 0xf4, 0x3c, 0x16, 0x99, 0xd0, 0x50\
	};

/**
 * gcm-test-vectors/vec-07.txt
 */
#define AESGCM_TEST_VEC_07 \
	/* K */\
	static uint8_t K[] = {\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00\
	};\
	/* P */\
	static uint8_t P[] = {	};\
	/* A (undefined) */\
	static uint8_t A[] = {	};\
	/* IV */\
	static uint8_t IV[] = {\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,\
		0x00, 0x00, 0x00, 0x00\
	};\
	/* H */\
	static uint8_t H[] = {\
		0xaa, 0xe0, 0x69, 0x92, 0xac, 0xbf, 0x52, 0xa3,\
		0xe8, 0xf4, 0xa9, 0x6e, 0xc9, 0x30, 0x0b, 0xd7\
	};\
	/* Y_0 */\
	static uint8_t Y0[] = {\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01\
	};\
	/* E(K,Y_0) */\
	static uint8_t E_K_Y0_[] = {\
		0xcd, 0x33, 0xb2, 0x8a, 0xc7, 0x73, 0xf7, 0x4b,\
		0xa0, 0x0e, 0xd1, 0xf3, 0x12, 0x57, 0x24, 0x35\
	};\
	/* len(A)||len(C) */\
	static uint8_t len_A_len_C_[] = {\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00\
	};\
	/* GHASH(H,A,C) */\
	static uint8_t GHASH_H_A_C_[] = {\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00\
	};\
	/* C */\
	static uint8_t C[] = {	};\
	/* T */\
	static uint8_t T[] = {\
		0xcd, 0x33, 0xb2, 0x8a, 0xc7, 0x73, 0xf7, 0x4b,\
		0xa0, 0x0e, 0xd1, 0xf3, 0x12, 0x57, 0x24, 0x35\
	};

/**
 * gcm-test-vectors/vec-08.txt
 */
#define AESGCM_TEST_VEC_08 \
	/* K */\
	static uint8_t K[] = {\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00\
	};\
	/* P */\
	static uint8_t P[] = {\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00\
	};\
	/* A (undefined) */\
	static uint8_t A[] = {	};\
	/* IV */\
	static uint8_t IV[] = {\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,\
		0x00, 0x00, 0x00, 0x00\
	};\
	/* H */\
	static uint8_t H[] = {\
		0xaa, 0xe0, 0x69, 0x92, 0xac, 0xbf, 0x52, 0xa3,\
		0xe8, 0xf4, 0xa9, 0x6e, 0xc9, 0x30, 0x0b, 0xd7\
	};\
	/* Y_0 */\
	static uint8_t Y0[] = {\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01\
	};\
	/* E(K,Y_0) */\
	static uint8_t E_K_Y0_[] = {\
		0xcd, 0x33, 0xb2, 0x8a, 0xc7, 0x73, 0xf7, 0x4b,\
		0xa0, 0x0e, 0xd1, 0xf3, 0x12, 0x57, 0x24, 0x35\
	};\
	/* Y_1 */\
	static uint8_t Y1[] = {\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02\
	};\
	/* E(K,Y_1) */\
	static uint8_t E_K_Y1_[] = {\
		0x98, 0xe7, 0x24, 0x7c, 0x07, 0xf0, 0xfe, 0x41,\
		0x1c, 0x26, 0x7e, 0x43, 0x84, 0xb0, 0xf6, 0x00\
	};\
	/* X_1 */\
	static uint8_t X1[] = {\
		0x90, 0xe8, 0x73, 0x15, 0xfb, 0x7d, 0x4e, 0x1b,\
		0x40, 0x92, 0xec, 0x0c, 0xbf, 0xda, 0x5d, 0x7d\
	};\
	/* len(A)||len(C) */\
	static uint8_t len_A_len_C_[] = {\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80\
	};\
	/* GHASH(H,A,C) */\
	static uint8_t GHASH_H_A_C_[] = {\
		0xe2, 0xc6, 0x3f, 0x0a, 0xc4, 0x4a, 0xd0, 0xe0,\
		0x2e, 0xfa, 0x05, 0xab, 0x67, 0x43, 0xd4, 0xce\
	};\
	/* C */\
	static uint8_t C[] = {\
		0x98, 0xe7, 0x24, 0x7c, 0x07, 0xf0, 0xfe, 0x41,\
		0x1c, 0x26, 0x7e, 0x43, 0x84, 0xb0, 0xf6, 0x00\
	};\
	/* T */\
	static uint8_t T[] = {\
		0x2f, 0xf5, 0x8d, 0x80, 0x03, 0x39, 0x27, 0xab,\
		0x8e, 0xf4, 0xd4, 0x58, 0x75, 0x14, 0xf0, 0xfb\
	};

/**
 * gcm-test-vectors/vec-09.txt
 */
#define AESGCM_TEST_VEC_09 \
	/* K */\
	static uint8_t K[] = {\
		0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,\
		0x6d, 0x6a, 0x8f, 0x94, 0x67, 0x30, 0x83, 0x08,\
		0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c\
	};\
	/* P */\
	static uint8_t P[] = {\
		0xd9, 0x31, 0x32, 0x25, 0xf8, 0x84, 0x06, 0xe5,\
		0xa5, 0x59, 0x09, 0xc5, 0xaf, 0xf5, 0x26, 0x9a,\
		0x86, 0xa7, 0xa9, 0x53, 0x15, 0x34, 0xf7, 0xda,\
		0x2e, 0x4c, 0x30, 0x3d, 0x8a, 0x31, 0x8a, 0x72,\
		0x1c, 0x3c, 0x0c, 0x95, 0x95, 0x68, 0x09, 0x53,\
		0x2f, 0xcf, 0x0e, 0x24, 0x49, 0xa6, 0xb5, 0x25,\
		0xb1, 0x6a, 0xed, 0xf5, 0xaa, 0x0d, 0xe6, 0x57,\
		0xba, 0x63, 0x7b, 0x39, 0x1a, 0xaf, 0xd2, 0x55\
	};\
	/* A (undefined) */\
	static uint8_t A[] = {	};\
	/* IV */\
	static uint8_t IV[] = {\
		0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad,\
		0xde, 0xca, 0xf8, 0x88\
	};\
	/* H */\
	static uint8_t H[] = {\
		0x46, 0x69, 0x23, 0xec, 0x9a, 0xe6, 0x82, 0x21,\
		0x4f, 0x2c, 0x08, 0x2b, 0xad, 0xb3, 0x92, 0x49\
	};\
	/* Y_0 */\
	static uint8_t Y0[] = {\
		0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad,\
		0xde, 0xca, 0xf8, 0x88, 0x00, 0x00, 0x00, 0x01\
	};\
	/* E(K,Y_0) */\
	static uint8_t E_K_Y0_[] = {\
		0xc8, 0x35, 0xaa, 0x88, 0xae, 0xbb, 0xc9, 0x4f,\
		0x5a, 0x02, 0xe1, 0x79, 0xfd, 0xcf, 0xc3, 0xe4\
	};\
	/* Y_1 */\
	static uint8_t Y1[] = {\
		0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad,\
		0xde, 0xca, 0xf8, 0x88, 0x00, 0x00, 0x00, 0x02\
	};\
	/* E(K,Y_1) */\
	static uint8_t E_K_Y1_[] = {\
		0xe0, 0xb1, 0xf8, 0x2e, 0xc4, 0x84, 0xee, 0xa4,\
		0x4e, 0x5f, 0xf3, 0x01, 0x28, 0xdf, 0x01, 0xcd\
	};\
	/* Y_2 */\
	static uint8_t Y2[] = {\
		0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad,\
		0xde, 0xca, 0xf8, 0x88, 0x00, 0x00, 0x00, 0x03\
	};\
	/* E(K,Y_2) */\
	static uint8_t E_K_Y2_[] = {\
		0x03, 0x39, 0xb5, 0xb9, 0xb3, 0xdb, 0x2e, 0x5e,\
		0x4c, 0xc9, 0xa3, 0x89, 0x86, 0x90, 0x6b, 0xee\
	};\
	/* Y_3 */\
	static uint8_t Y3[] = {\
		0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad,\
		0xde, 0xca, 0xf8, 0x88, 0x00, 0x00, 0x00, 0x04\
	};\
	/* E(K,Y_3) */\
	static uint8_t E_K_Y3_[] = {\
		0x61, 0x4b, 0x31, 0x95, 0x54, 0x2c, 0xcc, 0x76,\
		0x83, 0xae, 0x93, 0x3c, 0x81, 0xec, 0x8a, 0x62\
	};\
	/* Y_4 */\
	static uint8_t Y4[] = {\
		0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad,\
		0xde, 0xca, 0xf8, 0x88, 0x00, 0x00, 0x00, 0x05\
	};\
	/* E(K,Y_4) */\
	static uint8_t E_K_Y4_[] = {\
		0xa9, 0x88, 0xa9, 0x7e, 0x85, 0xee, 0xc2, 0x8e,\
		0x76, 0xb9, 0x5c, 0x29, 0xb6, 0x02, 0x30, 0x03\
	};\
	/* X_1 */\
	static uint8_t X1[] = {\
		0xdd, 0xdc, 0xa3, 0xf9, 0x1c, 0x17, 0x82, 0x1f,\
		0xfa, 0xc4, 0xa6, 0xd0, 0xfe, 0xd1, 0x76, 0xf7\
	};\
	/* X_2 */\
	static uint8_t X2[] = {\
		0xa4, 0xe8, 0x4a, 0xc6, 0x0e, 0x27, 0x30, 0xf4,\
		0xa7, 0xe0, 0xe1, 0xee, 0xf7, 0x08, 0xb1, 0x98\
	};\
	/* X_3 */\
	static uint8_t X3[] = {\
		0xe6, 0x75, 0x92, 0x04, 0x8d, 0xd7, 0x15, 0x39,\
		0x73, 0xa0, 0xdb, 0xbb, 0x88, 0x04, 0xbe, 0xe2\
	};\
	/* X_4 */\
	static uint8_t X4[] = {\
		0x50, 0x3e, 0x86, 0x62, 0x85, 0x36, 0x62, 0x5f,\
		0xb7, 0x46, 0xce, 0x3c, 0xec, 0xea, 0x43, 0x3f\
	};\
	/* len(A)||len(C) */\
	static uint8_t len_A_len_C_[] = {\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00\
	};\
	/* GHASH(H,A,C) */\
	static uint8_t GHASH_H_A_C_[] = {\
		0x51, 0x11, 0x0d, 0x40, 0xf6, 0xc8, 0xff, 0xf0,\
		0xeb, 0x1a, 0xe3, 0x34, 0x45, 0xa8, 0x89, 0xf0\
	};\
	/* C */\
	static uint8_t C[] = {\
		0x39, 0x80, 0xca, 0x0b, 0x3c, 0x00, 0xe8, 0x41,\
		0xeb, 0x06, 0xfa, 0xc4, 0x87, 0x2a, 0x27, 0x57,\
		0x85, 0x9e, 0x1c, 0xea, 0xa6, 0xef, 0xd9, 0x84,\
		0x62, 0x85, 0x93, 0xb4, 0x0c, 0xa1, 0xe1, 0x9c,\
		0x7d, 0x77, 0x3d, 0x00, 0xc1, 0x44, 0xc5, 0x25,\
		0xac, 0x61, 0x9d, 0x18, 0xc8, 0x4a, 0x3f, 0x47,\
		0x18, 0xe2, 0x44, 0x8b, 0x2f, 0xe3, 0x24, 0xd9,\
		0xcc, 0xda, 0x27, 0x10, 0xac, 0xad, 0xe2, 0x56\
	};\
	/* T */\
	static uint8_t T[] = {\
		0x99, 0x24, 0xa7, 0xc8, 0x58, 0x73, 0x36, 0xbf,\
		0xb1, 0x18, 0x02, 0x4d, 0xb8, 0x67, 0x4a, 0x14\
	};

/**
 * gcm-test-vectors/vec-10.txt
 */
#define AESGCM_TEST_VEC_10 \
	/* K */\
	static uint8_t K[] = {\
		0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,\
		0x6d, 0x6a, 0x8f, 0x94, 0x67, 0x30, 0x83, 0x08,\
		0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c\
	};\
	/* P */\
	static uint8_t P[] = {\
		0xd9, 0x31, 0x32, 0x25, 0xf8, 0x84, 0x06, 0xe5,\
		0xa5, 0x59, 0x09, 0xc5, 0xaf, 0xf5, 0x26, 0x9a,\
		0x86, 0xa7, 0xa9, 0x53, 0x15, 0x34, 0xf7, 0xda,\
		0x2e, 0x4c, 0x30, 0x3d, 0x8a, 0x31, 0x8a, 0x72,\
		0x1c, 0x3c, 0x0c, 0x95, 0x95, 0x68, 0x09, 0x53,\
		0x2f, 0xcf, 0x0e, 0x24, 0x49, 0xa6, 0xb5, 0x25,\
		0xb1, 0x6a, 0xed, 0xf5, 0xaa, 0x0d, 0xe6, 0x57,\
		0xba, 0x63, 0x7b, 0x39\
	};\
	/* A */\
	static uint8_t A[] = {\
		0xfe, 0xed, 0xfa, 0xce, 0xde, 0xad, 0xbe, 0xef,\
		0xfe, 0xed, 0xfa, 0xce, 0xde, 0xad, 0xbe, 0xef,\
		0xab, 0xad, 0xda, 0xd2\
	};\
	/* IV */\
	static uint8_t IV[] = {\
		0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad,\
		0xde, 0xca, 0xf8, 0x88\
	};\
	/* H */\
	static uint8_t H[] = {\
		0x46, 0x69, 0x23, 0xec, 0x9a, 0xe6, 0x82, 0x21,\
		0x4f, 0x2c, 0x08, 0x2b, 0xad, 0xb3, 0x92, 0x49\
	};\
	/* Y_0 */\
	static uint8_t Y0[] = {\
		0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad,\
		0xde, 0xca, 0xf8, 0x88, 0x00, 0x00, 0x00, 0x01\
	};\
	/* E(K,Y_0) */\
	static uint8_t E_K_Y0_[] = {\
		0xc8, 0x35, 0xaa, 0x88, 0xae, 0xbb, 0xc9, 0x4f,\
		0x5a, 0x02, 0xe1, 0x79, 0xfd, 0xcf, 0xc3, 0xe4\
	};\
	/* X_1 */\
	static uint8_t X1[] = {\
		0xf3, 0xbf, 0x7b, 0xa3, 0xe3, 0x05, 0xae, 0xb0,\
		0x5e, 0xd0, 0xd2, 0xe4, 0xfe, 0x07, 0x66, 0x66\
	};\
	/* X_2 */\
	static uint8_t X2[] = {\
		0x20, 0xa5, 0x1f, 0xa2, 0x30, 0x2e, 0x9c, 0x01,\
		0xb8, 0x7c, 0x48, 0xf2, 0xc3, 0xd9, 0x1a, 0x56\
	};\
	/* Y_1 */\
	static uint8_t Y1[] = {\
		0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad,\
		0xde, 0xca, 0xf8, 0x88, 0x00, 0x00, 0x00, 0x02\
	};\
	/* E(K,Y_1) */\
	static uint8_t E_K_Y1_[] = {\
		0xe0, 0xb1, 0xf8, 0x2e, 0xc4, 0x84, 0xee, 0xa4,\
		0x4e, 0x5f, 0xf3, 0x01, 0x28, 0xdf, 0x01, 0xcd\
	};\
	/* Y_2 */\
	static uint8_t Y2[] = {\
		0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad,\
		0xde, 0xca, 0xf8, 0x88, 0x00, 0x00, 0x00, 0x03\
	};\
	/* E(K,Y_2) */\
	static uint8_t E_K_Y2_[] = {\
		0x03, 0x39, 0xb5, 0xb9, 0xb3, 0xdb, 0x2e, 0x5e,\
		0x4c, 0xc9, 0xa3, 0x89, 0x86, 0x90, 0x6b, 0xee\
	};\
	/* Y_3 */\
	static uint8_t Y3[] = {\
		0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad,\
		0xde, 0xca, 0xf8, 0x88, 0x00, 0x00, 0x00, 0x04\
	};\
	/* E(K,Y_3) */\
	static uint8_t E_K_Y3_[] = {\
		0x61, 0x4b, 0x31, 0x95, 0x54, 0x2c, 0xcc, 0x76,\
		0x83, 0xae, 0x93, 0x3c, 0x81, 0xec, 0x8a, 0x62\
	};\
	/* Y_4 */\
	static uint8_t Y4[] = {\
		0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad,\
		0xde, 0xca, 0xf8, 0x88, 0x00, 0x00, 0x00, 0x05\
	};\
	/* E(K,Y_4) */\
	static uint8_t E_K_Y4_[] = {\
		0xa9, 0x88, 0xa9, 0x7e, 0x85, 0xee, 0xc2, 0x8e,\
		0x76, 0xb9, 0x5c, 0x29, 0xb6, 0x02, 0x30, 0x03\
	};\
	/* X_3 */\
	static uint8_t X3[] = {\
		0x71, 0x4f, 0x97, 0x00, 0xdd, 0xf5, 0x20, 0xf2,\
		0x06, 0x95, 0xf6, 0x18, 0x0c, 0x6e, 0x66, 0x9d\
	};\
	/* X_4 */\
	static uint8_t X4[] = {\
		0xe8, 0x58, 0x68, 0x0b, 0x7b, 0x24, 0x0d, 0x2e,\
		0xcf, 0x7e, 0x06, 0xbb, 0xad, 0x45, 0x24, 0xe2\
	};\
	/* X_5 */\
	static uint8_t X5[] = {\
		0x3f, 0x48, 0x65, 0xab, 0xd6, 0xbb, 0x3f, 0xb9,\
		0xf5, 0xc4, 0xa8, 0x16, 0xf0, 0xa9, 0xb7, 0x78\
	};\
	/* X_6 */\
	static uint8_t X6[] = {\
		0x42, 0x56, 0xf6, 0x7f, 0xe8, 0x7b, 0x4f, 0x49,\
		0x42, 0x2b, 0xa1, 0x1a, 0xf8, 0x57, 0xc9, 0x73\
	};\
	/* len(A)||len(C) */\
	static uint8_t len_A_len_C_[] = {\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0,\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xe0\
	};\
	/* GHASH(H,A,C) */\
	static uint8_t GHASH_H_A_C_[] = {\
		0xed, 0x2c, 0xe3, 0x06, 0x2e, 0x4a, 0x8e, 0xc0,\
		0x6d, 0xb8, 0xb4, 0xc4, 0x90, 0xe8, 0xa2, 0x68\
	};\
	/* C */\
	static uint8_t C[] = {\
		0x39, 0x80, 0xca, 0x0b, 0x3c, 0x00, 0xe8, 0x41,\
		0xeb, 0x06, 0xfa, 0xc4, 0x87, 0x2a, 0x27, 0x57,\
		0x85, 0x9e, 0x1c, 0xea, 0xa6, 0xef, 0xd9, 0x84,\
		0x62, 0x85, 0x93, 0xb4, 0x0c, 0xa1, 0xe1, 0x9c,\
		0x7d, 0x77, 0x3d, 0x00, 0xc1, 0x44, 0xc5, 0x25,\
		0xac, 0x61, 0x9d, 0x18, 0xc8, 0x4a, 0x3f, 0x47,\
		0x18, 0xe2, 0x44, 0x8b, 0x2f, 0xe3, 0x24, 0xd9,\
		0xcc, 0xda, 0x27, 0x10\
	};\
	/* T */\
	static uint8_t T[] = {\
		0x25, 0x19, 0x49, 0x8e, 0x80, 0xf1, 0x47, 0x8f,\
		0x37, 0xba, 0x55, 0xbd, 0x6d, 0x27, 0x61, 0x8c\
	};

/**
 * gcm-test-vectors/vec-11.txt
 */
#define AESGCM_TEST_VEC_11 \
	/* K */\
	static uint8_t K[] = {\
		0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,\
		0x6d, 0x6a, 0x8f, 0x94, 0x67, 0x30, 0x83, 0x08,\
		0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c\
	};\
	/* P */\
	static uint8_t P[] = {\
		0xd9, 0x31, 0x32, 0x25, 0xf8, 0x84, 0x06, 0xe5,\
		0xa5, 0x59, 0x09, 0xc5, 0xaf, 0xf5, 0x26, 0x9a,\
		0x86, 0xa7, 0xa9, 0x53, 0x15, 0x34, 0xf7, 0xda,\
		0x2e, 0x4c, 0x30, 0x3d, 0x8a, 0x31, 0x8a, 0x72,\
		0x1c, 0x3c, 0x0c, 0x95, 0x95, 0x68, 0x09, 0x53,\
		0x2f, 0xcf, 0x0e, 0x24, 0x49, 0xa6, 0xb5, 0x25,\
		0xb1, 0x6a, 0xed, 0xf5, 0xaa, 0x0d, 0xe6, 0x57,\
		0xba, 0x63, 0x7b, 0x39\
	};\
	/* A */\
	static uint8_t A[] = {\
		0xfe, 0xed, 0xfa, 0xce, 0xde, 0xad, 0xbe, 0xef,\
		0xfe, 0xed, 0xfa, 0xce, 0xde, 0xad, 0xbe, 0xef,\
		0xab, 0xad, 0xda, 0xd2\
	};\
	/* IV */\
	static uint8_t IV[] = {\
		0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad\
	};\
	/* H */\
	static uint8_t H[] = {\
		0x46, 0x69, 0x23, 0xec, 0x9a, 0xe6, 0x82, 0x21,\
		0x4f, 0x2c, 0x08, 0x2b, 0xad, 0xb3, 0x92, 0x49\
	};\
	/* N_1 */\
	static uint8_t N1[] = {\
		0x94, 0x73, 0xc0, 0x7b, 0x02, 0x54, 0x42, 0x99,\
		0xcf, 0x00, 0x7c, 0x42, 0xc5, 0x77, 0x82, 0x18\
	};\
	/* 0^{64}||len(IV) */\
	static uint8_t O64len_IV_[] = {\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40\
	};\
	/* Y_0 */\
	static uint8_t Y0[] = {\
		0xa1, 0x43, 0x78, 0x07, 0x8d, 0x27, 0x25, 0x8a,\
		0x62, 0x92, 0x73, 0x7e, 0x18, 0x02, 0xad, 0xa5\
	};\
	/* E(K,Y_0) */\
	static uint8_t E_K_Y0_[] = {\
		0x7b, 0xb6, 0xd6, 0x47, 0xc9, 0x02, 0x42, 0x7c,\
		0xe7, 0xcf, 0x26, 0x56, 0x3a, 0x33, 0x73, 0x71\
	};\
	/* X_1 */\
	static uint8_t X1[] = {\
		0xf3, 0xbf, 0x7b, 0xa3, 0xe3, 0x05, 0xae, 0xb0,\
		0x5e, 0xd0, 0xd2, 0xe4, 0xfe, 0x07, 0x66, 0x66\
	};\
	/* X_2 */\
	static uint8_t X2[] = {\
		0x20, 0xa5, 0x1f, 0xa2, 0x30, 0x2e, 0x9c, 0x01,\
		0xb8, 0x7c, 0x48, 0xf2, 0xc3, 0xd9, 0x1a, 0x56\
	};\
	/* Y_1 */\
	static uint8_t Y1[] = {\
		0xa1, 0x43, 0x78, 0x07, 0x8d, 0x27, 0x25, 0x8a,\
		0x62, 0x92, 0x73, 0x7e, 0x18, 0x02, 0xad, 0xa6\
	};\
	/* E(K,Y_1) */\
	static uint8_t E_K_Y1_[] = {\
		0xd6, 0x21, 0xc7, 0xbc, 0x56, 0x90, 0xa7, 0xb1,\
		0x48, 0x7d, 0xba, 0xab, 0x8a, 0xc7, 0x6b, 0x22\
	};\
	/* Y_2 */\
	static uint8_t Y2[] = {\
		0xa1, 0x43, 0x78, 0x07, 0x8d, 0x27, 0x25, 0x8a,\
		0x62, 0x92, 0x73, 0x7e, 0x18, 0x02, 0xad, 0xa7\
	};\
	/* E(K,Y_2) */\
	static uint8_t E_K_Y2_[] = {\
		0x43, 0xc1, 0xca, 0x7d, 0xe7, 0x8f, 0x44, 0x95,\
		0xad, 0x0b, 0x18, 0x32, 0x4e, 0x61, 0xfa, 0x25\
	};\
	/* Y_3 */\
	static uint8_t Y3[] = {\
		0xa1, 0x43, 0x78, 0x07, 0x8d, 0x27, 0x25, 0x8a,\
		0x62, 0x92, 0x73, 0x7e, 0x18, 0x02, 0xad, 0xa8\
	};\
	/* E(K,Y_3) */\
	static uint8_t E_K_Y3_[] = {\
		0xe1, 0xe0, 0x25, 0x4a, 0x0f, 0x2f, 0x16, 0x26,\
		0xe9, 0xaa, 0x4f, 0xf0, 0x9d, 0x7c, 0x64, 0xec\
	};\
	/* Y_4 */\
	static uint8_t Y4[] = {\
		0xa1, 0x43, 0x78, 0x07, 0x8d, 0x27, 0x25, 0x8a,\
		0x62, 0x92, 0x73, 0x7e, 0x18, 0x02, 0xad, 0xa9\
	};\
	/* E(K,Y_4) */\
	static uint8_t E_K_Y4_[] = {\
		0x58, 0x50, 0xf4, 0x50, 0x24, 0x86, 0xa1, 0x68,\
		0x1a, 0x93, 0x19, 0xce, 0x7d, 0x0a, 0xfa, 0x59\
	};\
	/* X_3 */\
	static uint8_t X3[] = {\
		0x8b, 0xde, 0xda, 0xfd, 0x6e, 0xe8, 0xe5, 0x29,\
		0x68, 0x9d, 0xe3, 0xa2, 0x69, 0xb8, 0x24, 0x0d\
	};\
	/* X_4 */\
	static uint8_t X4[] = {\
		0x66, 0x07, 0xfe, 0xb3, 0x77, 0xb4, 0x9c, 0x9e,\
		0xcd, 0xbc, 0x69, 0x63, 0x44, 0xfe, 0x22, 0xd8\
	};\
	/* X_5 */\
	static uint8_t X5[] = {\
		0x8a, 0x19, 0x57, 0x0a, 0x06, 0x50, 0x0b, 0xa9,\
		0x40, 0x5f, 0xce, 0xce, 0x4a, 0x73, 0xfb, 0x48\
	};\
	/* X_6 */\
	static uint8_t X6[] = {\
		0x85, 0x32, 0x82, 0x6e, 0x63, 0xce, 0x4a, 0x5b,\
		0x89, 0xb7, 0x0f, 0xa2, 0x8f, 0x80, 0x70, 0xfe\
	};\
	/* len(A)||len(C) */\
	static uint8_t len_A_len_C_[] = {\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0,\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xe0\
	};\
	/* GHASH(H,A,C) */\
	static uint8_t GHASH_H_A_C_[] = {\
		0x1e, 0x6a, 0x13, 0x38, 0x06, 0x60, 0x78, 0x58,\
		0xee, 0x80, 0xea, 0xf2, 0x37, 0x06, 0x40, 0x89\
	};\
	/* C */\
	static uint8_t C[] = {\
		0x0f, 0x10, 0xf5, 0x99, 0xae, 0x14, 0xa1, 0x54,\
		0xed, 0x24, 0xb3, 0x6e, 0x25, 0x32, 0x4d, 0xb8,\
		0xc5, 0x66, 0x63, 0x2e, 0xf2, 0xbb, 0xb3, 0x4f,\
		0x83, 0x47, 0x28, 0x0f, 0xc4, 0x50, 0x70, 0x57,\
		0xfd, 0xdc, 0x29, 0xdf, 0x9a, 0x47, 0x1f, 0x75,\
		0xc6, 0x65, 0x41, 0xd4, 0xd4, 0xda, 0xd1, 0xc9,\
		0xe9, 0x3a, 0x19, 0xa5, 0x8e, 0x8b, 0x47, 0x3f,\
		0xa0, 0xf0, 0x62, 0xf7\
	};\
	/* T */\
	static uint8_t T[] = {\
		0x65, 0xdc, 0xc5, 0x7f, 0xcf, 0x62, 0x3a, 0x24,\
		0x09, 0x4f, 0xcc, 0xa4, 0x0d, 0x35, 0x33, 0xf8\
	};

/**
 * gcm-test-vectors/vec-12.txt
 */
#define AESGCM_TEST_VEC_12 \
	/* K */\
	static uint8_t K[] = {\
		0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,\
		0x6d, 0x6a, 0x8f, 0x94, 0x67, 0x30, 0x83, 0x08,\
		0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c\
	};\
	/* P */\
	static uint8_t P[] = {\
		0xd9, 0x31, 0x32, 0x25, 0xf8, 0x84, 0x06, 0xe5,\
		0xa5, 0x59, 0x09, 0xc5, 0xaf, 0xf5, 0x26, 0x9a,\
		0x86, 0xa7, 0xa9, 0x53, 0x15, 0x34, 0xf7, 0xda,\
		0x2e, 0x4c, 0x30, 0x3d, 0x8a, 0x31, 0x8a, 0x72,\
		0x1c, 0x3c, 0x0c, 0x95, 0x95, 0x68, 0x09, 0x53,\
		0x2f, 0xcf, 0x0e, 0x24, 0x49, 0xa6, 0xb5, 0x25,\
		0xb1, 0x6a, 0xed, 0xf5, 0xaa, 0x0d, 0xe6, 0x57,\
		0xba, 0x63, 0x7b, 0x39\
	};\
	/* A */\
	static uint8_t A[] = {\
		0xfe, 0xed, 0xfa, 0xce, 0xde, 0xad, 0xbe, 0xef,\
		0xfe, 0xed, 0xfa, 0xce, 0xde, 0xad, 0xbe, 0xef,\
		0xab, 0xad, 0xda, 0xd2\
	};\
	/* IV */\
	static uint8_t IV[] = {\
		0x93, 0x13, 0x22, 0x5d, 0xf8, 0x84, 0x06, 0xe5,\
		0x55, 0x90, 0x9c, 0x5a, 0xff, 0x52, 0x69, 0xaa,\
		0x6a, 0x7a, 0x95, 0x38, 0x53, 0x4f, 0x7d, 0xa1,\
		0xe4, 0xc3, 0x03, 0xd2, 0xa3, 0x18, 0xa7, 0x28,\
		0xc3, 0xc0, 0xc9, 0x51, 0x56, 0x80, 0x95, 0x39,\
		0xfc, 0xf0, 0xe2, 0x42, 0x9a, 0x6b, 0x52, 0x54,\
		0x16, 0xae, 0xdb, 0xf5, 0xa0, 0xde, 0x6a, 0x57,\
		0xa6, 0x37, 0xb3, 0x9b\
	};\
	/* H */\
	static uint8_t H[] = {\
		0x46, 0x69, 0x23, 0xec, 0x9a, 0xe6, 0x82, 0x21,\
		0x4f, 0x2c, 0x08, 0x2b, 0xad, 0xb3, 0x92, 0x49\
	};\
	/* N_1 */\
	static uint8_t N1[] = {\
		0x19, 0xae, 0xf0, 0xf0, 0x47, 0x63, 0xb0, 0xc8,\
		0x79, 0x03, 0xc5, 0xa2, 0x17, 0xd5, 0x31, 0x4f\
	};\
	/* N_2 */\
	static uint8_t N2[] = {\
		0x62, 0x12, 0x02, 0x53, 0xf7, 0x9e, 0xfc, 0x97,\
		0x86, 0x25, 0xd1, 0xfe, 0xb0, 0x3b, 0x5b, 0x5b\
	};\
	/* N_3 */\
	static uint8_t N3[] = {\
		0xb6, 0xce, 0x2a, 0x84, 0xe3, 0x66, 0xde, 0x90,\
		0x0f, 0xa7, 0x8a, 0x16, 0x53, 0xdf, 0x77, 0xfb\
	};\
	/* N_4 */\
	static uint8_t N4[] = {\
		0x37, 0x4e, 0xca, 0xd9, 0x04, 0x87, 0xf0, 0xbb,\
		0x26, 0x1b, 0xa8, 0x17, 0x44, 0x7e, 0x02, 0x2c\
	};\
	/* 0^{64}||len(IV) */\
	static uint8_t O64len_IV_[] = {\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xe0\
	};\
	/* Y_0 */\
	static uint8_t Y0[] = {\
		0x45, 0x05, 0xcd, 0xc3, 0x67, 0xa0, 0x54, 0xc5,\
		0x00, 0x28, 0x20, 0xe9, 0x6a, 0xeb, 0xef, 0x27\
	};\
	/* E(K,Y_0) */\
	static uint8_t E_K_Y0_[] = {\
		0x5e, 0xa3, 0x19, 0x4f, 0x9d, 0xd0, 0x12, 0xa3,\
		0xb9, 0xbc, 0x51, 0x03, 0xd6, 0xe0, 0x28, 0x4d\
	};\
	/* X_1 */\
	static uint8_t X1[] = {\
		0xf3, 0xbf, 0x7b, 0xa3, 0xe3, 0x05, 0xae, 0xb0,\
		0x5e, 0xd0, 0xd2, 0xe4, 0xfe, 0x07, 0x66, 0x66\
	};\
	/* X_2 */\
	static uint8_t X2[] = {\
		0x20, 0xa5, 0x1f, 0xa2, 0x30, 0x2e, 0x9c, 0x01,\
		0xb8, 0x7c, 0x48, 0xf2, 0xc3, 0xd9, 0x1a, 0x56\
	};\
	/* Y_1 */\
	static uint8_t Y1[] = {\
		0x45, 0x05, 0xcd, 0xc3, 0x67, 0xa0, 0x54, 0xc5,\
		0x00, 0x28, 0x20, 0xe9, 0x6a, 0xeb, 0xef, 0x28\
	};\
	/* E(K,Y_1) */\
	static uint8_t E_K_Y1_[] = {\
		0x0b, 0x4f, 0xba, 0x4d, 0xe4, 0x67, 0x22, 0xd9,\
		0xed, 0x69, 0x1f, 0x9f, 0x20, 0x29, 0xdf, 0x65\
	};\
	/* Y_2 */\
	static uint8_t Y2[] = {\
		0x45, 0x05, 0xcd, 0xc3, 0x67, 0xa0, 0x54, 0xc5,\
		0x00, 0x28, 0x20, 0xe9, 0x6a, 0xeb, 0xef, 0x29\
	};\
	/* E(K,Y_2) */\
	static uint8_t E_K_Y2_[] = {\
		0x9b, 0x4e, 0x08, 0x8b, 0xf3, 0x80, 0xb0, 0x35,\
		0x40, 0xbb, 0x87, 0xa5, 0xa2, 0x57, 0xe4, 0x37\
	};\
	/* Y_3 */\
	static uint8_t Y3[] = {\
		0x45, 0x05, 0xcd, 0xc3, 0x67, 0xa0, 0x54, 0xc5,\
		0x00, 0x28, 0x20, 0xe9, 0x6a, 0xeb, 0xef, 0x2a\
	};\
	/* E(K,Y_3) */\
	static uint8_t E_K_Y3_[] = {\
		0x9d, 0xdb, 0x9c, 0x87, 0x3a, 0x5c, 0xd4, 0x8a,\
		0xcd, 0x3f, 0x39, 0x7c, 0xd2, 0x8f, 0x98, 0x96\
	};\
	/* Y_4 */\
	static uint8_t Y4[] = {\
		0x45, 0x05, 0xcd, 0xc3, 0x67, 0xa0, 0x54, 0xc5,\
		0x00, 0x28, 0x20, 0xe9, 0x6a, 0xeb, 0xef, 0x2b\
	};\
	/* E(K,Y_4) */\
	static uint8_t E_K_Y4_[] = {\
		0x57, 0x16, 0xee, 0x92, 0xef, 0xf7, 0xc4, 0xb0,\
		0x53, 0xd4, 0x4c, 0x02, 0x94, 0xea, 0x88, 0xcd\
	};\
	/* X_3 */\
	static uint8_t X3[] = {\
		0xf7, 0x0d, 0x61, 0x69, 0x3e, 0xa7, 0xf5, 0x3f,\
		0x08, 0xc8, 0x66, 0xd6, 0xee, 0xdb, 0x1e, 0x4b\
	};\
	/* X_4 */\
	static uint8_t X4[] = {\
		0xdc, 0x40, 0xbc, 0x9a, 0x18, 0x1b, 0x35, 0xae,\
		0xd6, 0x64, 0x88, 0x07, 0x1e, 0xf2, 0x82, 0xae\
	};\
	/* X_5 */\
	static uint8_t X5[] = {\
		0x85, 0xff, 0xa4, 0x24, 0xb8, 0x7b, 0x35, 0xca,\
		0xc7, 0xbe, 0x9c, 0x45, 0x0f, 0x0d, 0x7a, 0xee\
	};\
	/* X_6 */\
	static uint8_t X6[] = {\
		0x65, 0x23, 0x3c, 0xbe, 0x52, 0x51, 0xf7, 0xd2,\
		0x46, 0xbf, 0xc9, 0x67, 0xa8, 0x67, 0x86, 0x47\
	};\
	/* len(A)||len(C) */\
	static uint8_t len_A_len_C_[] = {\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0,\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xe0\
	};\
	/* GHASH(H,A,C) */\
	static uint8_t GHASH_H_A_C_[] = {\
		0x82, 0x56, 0x7f, 0xb0, 0xb4, 0xcc, 0x37, 0x18,\
		0x01, 0xea, 0xde, 0xc0, 0x05, 0x96, 0x8e, 0x94\
	};\
	/* C */\
	static uint8_t C[] = {\
		0xd2, 0x7e, 0x88, 0x68, 0x1c, 0xe3, 0x24, 0x3c,\
		0x48, 0x30, 0x16, 0x5a, 0x8f, 0xdc, 0xf9, 0xff,\
		0x1d, 0xe9, 0xa1, 0xd8, 0xe6, 0xb4, 0x47, 0xef,\
		0x6e, 0xf7, 0xb7, 0x98, 0x28, 0x66, 0x6e, 0x45,\
		0x81, 0xe7, 0x90, 0x12, 0xaf, 0x34, 0xdd, 0xd9,\
		0xe2, 0xf0, 0x37, 0x58, 0x9b, 0x29, 0x2d, 0xb3,\
		0xe6, 0x7c, 0x03, 0x67, 0x45, 0xfa, 0x22, 0xe7,\
		0xe9, 0xb7, 0x37, 0x3b\
	};\
	/* T */\
	static uint8_t T[] = {\
		0xdc, 0xf5, 0x66, 0xff, 0x29, 0x1c, 0x25, 0xbb,\
		0xb8, 0x56, 0x8f, 0xc3, 0xd3, 0x76, 0xa6, 0xd9\
	};

/**
 * gcm-test-vectors/vec-13.txt
 */
#define AESGCM_TEST_VEC_13 \
	/* K */\
	static uint8_t K[] = {\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00\
	};\
	/* P */\
	static uint8_t P[] = {	};\
	/* A (undefined) */\
	static uint8_t A[] = {	};\
	/* IV */\
	static uint8_t IV[] = {\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,\
		0x00, 0x00, 0x00, 0x00\
	};\
	/* H */\
	static uint8_t H[] = {\
		0xdc, 0x95, 0xc0, 0x78, 0xa2, 0x40, 0x89, 0x89,\
		0xad, 0x48, 0xa2, 0x14, 0x92, 0x84, 0x20, 0x87\
	};\
	/* Y_0 */\
	static uint8_t Y0[] = {\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01\
	};\
	/* E(K,Y_0) */\
	static uint8_t E_K_Y0_[] = {\
		0x53, 0x0f, 0x8a, 0xfb, 0xc7, 0x45, 0x36, 0xb9,\
		0xa9, 0x63, 0xb4, 0xf1, 0xc4, 0xcb, 0x73, 0x8b\
	};\
	/* len(A)||len(C) */\
	static uint8_t len_A_len_C_[] = {\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00\
	};\
	/* GHASH(H,A,C) */\
	static uint8_t GHASH_H_A_C_[] = {\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00\
	};\
	/* C */\
	static uint8_t C[] = {	};\
	/* T */\
	static uint8_t T[] = {\
		0x53, 0x0f, 0x8a, 0xfb, 0xc7, 0x45, 0x36, 0xb9,\
		0xa9, 0x63, 0xb4, 0xf1, 0xc4, 0xcb, 0x73, 0x8b\
	};

/**
 * gcm-test-vectors/vec-14.txt
 */
#define AESGCM_TEST_VEC_14 \
	/* K */\
	static uint8_t K[] = {\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00\
	};\
	/* P */\
	static uint8_t P[] = {\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00\
	};\
	/* A (undefined) */\
	static uint8_t A[] = {	};\
	/* IV */\
	static uint8_t IV[] = {\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,\
		0x00, 0x00, 0x00, 0x00\
	};\
	/* H */\
	static uint8_t H[] = {\
		0xdc, 0x95, 0xc0, 0x78, 0xa2, 0x40, 0x89, 0x89,\
		0xad, 0x48, 0xa2, 0x14, 0x92, 0x84, 0x20, 0x87\
	};\
	/* Y_0 */\
	static uint8_t Y0[] = {\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01\
	};\
	/* E(K,Y_0) */\
	static uint8_t E_K_Y0_[] = {\
		0x53, 0x0f, 0x8a, 0xfb, 0xc7, 0x45, 0x36, 0xb9,\
		0xa9, 0x63, 0xb4, 0xf1, 0xc4, 0xcb, 0x73, 0x8b\
	};\
	/* Y_1 */\
	static uint8_t Y1[] = {\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02\
	};\
	/* E(K,Y_1) */\
	static uint8_t E_K_Y1_[] = {\
		0xce, 0xa7, 0x40, 0x3d, 0x4d, 0x60, 0x6b, 0x6e,\
		0x07, 0x4e, 0xc5, 0xd3, 0xba, 0xf3, 0x9d, 0x18\
	};\
	/* X_1 */\
	static uint8_t X1[] = {\
		0xfd, 0x6a, 0xb7, 0x58, 0x6e, 0x55, 0x6d, 0xba,\
		0x06, 0xd6, 0x9c, 0xfe, 0x62, 0x23, 0xb2, 0x62\
	};\
	/* len(A)||len(C) */\
	static uint8_t len_A_len_C_[] = {\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80\
	};\
	/* GHASH(H,A,C) */\
	static uint8_t GHASH_H_A_C_[] = {\
		0x83, 0xde, 0x42, 0x5c, 0x5e, 0xdc, 0x5d, 0x49,\
		0x8f, 0x38, 0x2c, 0x44, 0x10, 0x41, 0xca, 0x92\
	};\
	/* C */\
	static uint8_t C[] = {\
		0xce, 0xa7, 0x40, 0x3d, 0x4d, 0x60, 0x6b, 0x6e,\
		0x07, 0x4e, 0xc5, 0xd3, 0xba, 0xf3, 0x9d, 0x18\
	};\
	/* T */\
	static uint8_t T[] = {\
		0xd0, 0xd1, 0xc8, 0xa7, 0x99, 0x99, 0x6b, 0xf0,\
		0x26, 0x5b, 0x98, 0xb5, 0xd4, 0x8a, 0xb9, 0x19\
	};

/**
 * gcm-test-vectors/vec-15.txt
 */
#define AESGCM_TEST_VEC_15 \
	/* K */\
	static uint8_t K[] = {\
		0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,\
		0x6d, 0x6a, 0x8f, 0x94, 0x67, 0x30, 0x83, 0x08,\
		0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,\
		0x6d, 0x6a, 0x8f, 0x94, 0x67, 0x30, 0x83, 0x08\
	};\
	/* P */\
	static uint8_t P[] = {\
		0xd9, 0x31, 0x32, 0x25, 0xf8, 0x84, 0x06, 0xe5,\
		0xa5, 0x59, 0x09, 0xc5, 0xaf, 0xf5, 0x26, 0x9a,\
		0x86, 0xa7, 0xa9, 0x53, 0x15, 0x34, 0xf7, 0xda,\
		0x2e, 0x4c, 0x30, 0x3d, 0x8a, 0x31, 0x8a, 0x72,\
		0x1c, 0x3c, 0x0c, 0x95, 0x95, 0x68, 0x09, 0x53,\
		0x2f, 0xcf, 0x0e, 0x24, 0x49, 0xa6, 0xb5, 0x25,\
		0xb1, 0x6a, 0xed, 0xf5, 0xaa, 0x0d, 0xe6, 0x57,\
		0xba, 0x63, 0x7b, 0x39, 0x1a, 0xaf, 0xd2, 0x55\
	};\
	/* A (undefined) */\
	static uint8_t A[] = {	};\
	/* IV */\
	static uint8_t IV[] = {\
		0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad,\
		0xde, 0xca, 0xf8, 0x88\
	};\
	/* H */\
	static uint8_t H[] = {\
		0xac, 0xbe, 0xf2, 0x05, 0x79, 0xb4, 0xb8, 0xeb,\
		0xce, 0x88, 0x9b, 0xac, 0x87, 0x32, 0xda, 0xd7\
	};\
	/* Y_0 */\
	static uint8_t Y0[] = {\
		0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad,\
		0xde, 0xca, 0xf8, 0x88, 0x00, 0x00, 0x00, 0x01\
	};\
	/* E(K,Y_0) */\
	static uint8_t E_K_Y0_[] = {\
		0xfd, 0x2c, 0xaa, 0x16, 0xa5, 0x83, 0x2e, 0x76,\
		0xaa, 0x13, 0x2c, 0x14, 0x53, 0xee, 0xda, 0x7e\
	};\
	/* Y_1 */\
	static uint8_t Y1[] = {\
		0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad,\
		0xde, 0xca, 0xf8, 0x88, 0x00, 0x00, 0x00, 0x02\
	};\
	/* E(K,Y_1) */\
	static uint8_t E_K_Y1_[] = {\
		0x8b, 0x1c, 0xf3, 0xd5, 0x61, 0xd2, 0x7b, 0xe2,\
		0x51, 0x26, 0x3e, 0x66, 0x85, 0x71, 0x64, 0xe7\
	};\
	/* Y_2 */\
	static uint8_t Y2[] = {\
		0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad,\
		0xde, 0xca, 0xf8, 0x88, 0x00, 0x00, 0x00, 0x03\
	};\
	/* E(K,Y_2) */\
	static uint8_t E_K_Y2_[] = {\
		0xe2, 0x9d, 0x25, 0x8f, 0xaa, 0xd1, 0x37, 0x13,\
		0x5b, 0xd4, 0x92, 0x80, 0xaf, 0x64, 0x5b, 0xd8\
	};\
	/* Y_3 */\
	static uint8_t Y3[] = {\
		0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad,\
		0xde, 0xca, 0xf8, 0x88, 0x00, 0x00, 0x00, 0x04\
	};\
	/* E(K,Y_3) */\
	static uint8_t E_K_Y3_[] = {\
		0x90, 0x8c, 0x82, 0xdd, 0xcc, 0x65, 0xb2, 0x6e,\
		0x88, 0x7f, 0x85, 0x34, 0x1f, 0x24, 0x3d, 0x1d\
	};\
	/* Y_4 */\
	static uint8_t Y4[] = {\
		0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad,\
		0xde, 0xca, 0xf8, 0x88, 0x00, 0x00, 0x00, 0x05\
	};\
	/* E(K,Y_4) */\
	static uint8_t E_K_Y4_[] = {\
		0x74, 0x9c, 0xf3, 0x96, 0x39, 0xb7, 0x9c, 0x5d,\
		0x06, 0xaa, 0x8d, 0x5b, 0x93, 0x2f, 0xc7, 0xf8\
	};\
	/* X_1 */\
	static uint8_t X1[] = {\
		0xfc, 0xbe, 0xfb, 0x78, 0x63, 0x5d, 0x59, 0x8e,\
		0xdd, 0xaf, 0x98, 0x23, 0x10, 0x67, 0x0f, 0x35\
	};\
	/* X_2 */\
	static uint8_t X2[] = {\
		0x29, 0xde, 0x81, 0x23, 0x09, 0xd3, 0x11, 0x6a,\
		0x6e, 0xff, 0x7e, 0xc8, 0x44, 0x48, 0x4f, 0x3e\
	};\
	/* X_3 */\
	static uint8_t X3[] = {\
		0x45, 0xfa, 0xd9, 0xde, 0xed, 0xa9, 0xea, 0x56,\
		0x1b, 0x8f, 0x19, 0x9c, 0x36, 0x13, 0x84, 0x5b\
	};\
	/* X_4 */\
	static uint8_t X4[] = {\
		0xed, 0x95, 0xf8, 0xe1, 0x64, 0xbf, 0x32, 0x13,\
		0xfe, 0xbc, 0x74, 0x0f, 0x0b, 0xd9, 0xc6, 0xaf\
	};\
	/* len(A)||len(C) */\
	static uint8_t len_A_len_C_[] = {\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00\
	};\
	/* GHASH(H,A,C) */\
	static uint8_t GHASH_H_A_C_[] = {\
		0x4d, 0xb8, 0x70, 0xd3, 0x7c, 0xb7, 0x5f, 0xcb,\
		0x46, 0x09, 0x7c, 0x36, 0x23, 0x0d, 0x16, 0x12\
	};\
	/* C */\
	static uint8_t C[] = {\
		0x52, 0x2d, 0xc1, 0xf0, 0x99, 0x56, 0x7d, 0x07,\
		0xf4, 0x7f, 0x37, 0xa3, 0x2a, 0x84, 0x42, 0x7d,\
		0x64, 0x3a, 0x8c, 0xdc, 0xbf, 0xe5, 0xc0, 0xc9,\
		0x75, 0x98, 0xa2, 0xbd, 0x25, 0x55, 0xd1, 0xaa,\
		0x8c, 0xb0, 0x8e, 0x48, 0x59, 0x0d, 0xbb, 0x3d,\
		0xa7, 0xb0, 0x8b, 0x10, 0x56, 0x82, 0x88, 0x38,\
		0xc5, 0xf6, 0x1e, 0x63, 0x93, 0xba, 0x7a, 0x0a,\
		0xbc, 0xc9, 0xf6, 0x62, 0x89, 0x80, 0x15, 0xad\
	};\
	/* T */\
	static uint8_t T[] = {\
		0xb0, 0x94, 0xda, 0xc5, 0xd9, 0x34, 0x71, 0xbd,\
		0xec, 0x1a, 0x50, 0x22, 0x70, 0xe3, 0xcc, 0x6c\
	};

/**
 * gcm-test-vectors/vec-16.txt
 */
#define AESGCM_TEST_VEC_16 \
	/* K */\
	static uint8_t K[] = {\
		0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,\
		0x6d, 0x6a, 0x8f, 0x94, 0x67, 0x30, 0x83, 0x08,\
		0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,\
		0x6d, 0x6a, 0x8f, 0x94, 0x67, 0x30, 0x83, 0x08\
	};\
	/* P */\
	static uint8_t P[] = {\
		0xd9, 0x31, 0x32, 0x25, 0xf8, 0x84, 0x06, 0xe5,\
		0xa5, 0x59, 0x09, 0xc5, 0xaf, 0xf5, 0x26, 0x9a,\
		0x86, 0xa7, 0xa9, 0x53, 0x15, 0x34, 0xf7, 0xda,\
		0x2e, 0x4c, 0x30, 0x3d, 0x8a, 0x31, 0x8a, 0x72,\
		0x1c, 0x3c, 0x0c, 0x95, 0x95, 0x68, 0x09, 0x53,\
		0x2f, 0xcf, 0x0e, 0x24, 0x49, 0xa6, 0xb5, 0x25,\
		0xb1, 0x6a, 0xed, 0xf5, 0xaa, 0x0d, 0xe6, 0x57,\
		0xba, 0x63, 0x7b, 0x39\
	};\
	/* A */\
	static uint8_t A[] = {\
		0xfe, 0xed, 0xfa, 0xce, 0xde, 0xad, 0xbe, 0xef,\
		0xfe, 0xed, 0xfa, 0xce, 0xde, 0xad, 0xbe, 0xef,\
		0xab, 0xad, 0xda, 0xd2\
	};\
	/* IV */\
	static uint8_t IV[] = {\
		0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad,\
		0xde, 0xca, 0xf8, 0x88\
	};\
	/* H */\
	static uint8_t H[] = {\
		0xac, 0xbe, 0xf2, 0x05, 0x79, 0xb4, 0xb8, 0xeb,\
		0xce, 0x88, 0x9b, 0xac, 0x87, 0x32, 0xda, 0xd7\
	};\
	/* Y_0 */\
	static uint8_t Y0[] = {\
		0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad,\
		0xde, 0xca, 0xf8, 0x88, 0x00, 0x00, 0x00, 0x01\
	};\
	/* E(K,Y_0) */\
	static uint8_t E_K_Y0_[] = {\
		0xfd, 0x2c, 0xaa, 0x16, 0xa5, 0x83, 0x2e, 0x76,\
		0xaa, 0x13, 0x2c, 0x14, 0x53, 0xee, 0xda, 0x7e\
	};\
	/* X_1 */\
	static uint8_t X1[] = {\
		0x51, 0x65, 0xd2, 0x42, 0xc2, 0x59, 0x2c, 0x0a,\
		0x63, 0x75, 0xe2, 0x62, 0x2c, 0xf9, 0x25, 0xd2\
	};\
	/* X_2 */\
	static uint8_t X2[] = {\
		0x8e, 0xfa, 0x30, 0xce, 0x83, 0x29, 0x8b, 0x85,\
		0xfe, 0x71, 0xab, 0xef, 0xc0, 0xcd, 0xd0, 0x1d\
	};\
	/* Y_1 */\
	static uint8_t Y1[] = {\
		0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad,\
		0xde, 0xca, 0xf8, 0x88, 0x00, 0x00, 0x00, 0x02\
	};\
	/* E(K,Y_1) */\
	static uint8_t E_K_Y1_[] = {\
		0x8b, 0x1c, 0xf3, 0xd5, 0x61, 0xd2, 0x7b, 0xe2,\
		0x51, 0x26, 0x3e, 0x66, 0x85, 0x71, 0x64, 0xe7\
	};\
	/* Y_2 */\
	static uint8_t Y2[] = {\
		0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad,\
		0xde, 0xca, 0xf8, 0x88, 0x00, 0x00, 0x00, 0x03\
	};\
	/* E(K,Y_2) */\
	static uint8_t E_K_Y2_[] = {\
		0xe2, 0x9d, 0x25, 0x8f, 0xaa, 0xd1, 0x37, 0x13,\
		0x5b, 0xd4, 0x92, 0x80, 0xaf, 0x64, 0x5b, 0xd8\
	};\
	/* Y_3 */\
	static uint8_t Y3[] = {\
		0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad,\
		0xde, 0xca, 0xf8, 0x88, 0x00, 0x00, 0x00, 0x04\
	};\
	/* E(K,Y_3) */\
	static uint8_t E_K_Y3_[] = {\
		0x90, 0x8c, 0x82, 0xdd, 0xcc, 0x65, 0xb2, 0x6e,\
		0x88, 0x7f, 0x85, 0x34, 0x1f, 0x24, 0x3d, 0x1d\
	};\
	/* Y_4 */\
	static uint8_t Y4[] = {\
		0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad,\
		0xde, 0xca, 0xf8, 0x88, 0x00, 0x00, 0x00, 0x05\
	};\
	/* E(K,Y_4) */\
	static uint8_t E_K_Y4_[] = {\
		0x74, 0x9c, 0xf3, 0x96, 0x39, 0xb7, 0x9c, 0x5d,\
		0x06, 0xaa, 0x8d, 0x5b, 0x93, 0x2f, 0xc7, 0xf8\
	};\
	/* X_3 */\
	static uint8_t X3[] = {\
		0xab, 0xe0, 0x7e, 0x0b, 0xb6, 0x23, 0x54, 0x17,\
		0x74, 0x80, 0xb5, 0x50, 0xf9, 0xf6, 0xcd, 0xcc\
	};\
	/* X_4 */\
	static uint8_t X4[] = {\
		0x39, 0x78, 0xe4, 0xf1, 0x41, 0xb9, 0x5f, 0x3b,\
		0x46, 0x99, 0x75, 0x6b, 0x1c, 0x3c, 0x20, 0x82\
	};\
	/* X_5 */\
	static uint8_t X5[] = {\
		0x8a, 0xbf, 0x3c, 0x48, 0x90, 0x1d, 0xeb, 0xe7,\
		0x68, 0x37, 0xd8, 0xa0, 0x5c, 0x7d, 0x6e, 0x87\
	};\
	/* X_6 */\
	static uint8_t X6[] = {\
		0x92, 0x49, 0xbe, 0xaf, 0x52, 0x0c, 0x48, 0xb9,\
		0x12, 0xfa, 0x12, 0x0b, 0xbf, 0x39, 0x1d, 0xc8\
	};\
	/* len(A)||len(C) */\
	static uint8_t len_A_len_C_[] = {\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0,\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xe0\
	};\
	/* GHASH(H,A,C) */\
	static uint8_t GHASH_H_A_C_[] = {\
		0x8b, 0xd0, 0xc4, 0xd8, 0xaa, 0xcd, 0x39, 0x1e,\
		0x67, 0xcc, 0xa4, 0x47, 0xe8, 0xc3, 0x8f, 0x65\
	};\
	/* C */\
	static uint8_t C[] = {\
		0x52, 0x2d, 0xc1, 0xf0, 0x99, 0x56, 0x7d, 0x07,\
		0xf4, 0x7f, 0x37, 0xa3, 0x2a, 0x84, 0x42, 0x7d,\
		0x64, 0x3a, 0x8c, 0xdc, 0xbf, 0xe5, 0xc0, 0xc9,\
		0x75, 0x98, 0xa2, 0xbd, 0x25, 0x55, 0xd1, 0xaa,\
		0x8c, 0xb0, 0x8e, 0x48, 0x59, 0x0d, 0xbb, 0x3d,\
		0xa7, 0xb0, 0x8b, 0x10, 0x56, 0x82, 0x88, 0x38,\
		0xc5, 0xf6, 0x1e, 0x63, 0x93, 0xba, 0x7a, 0x0a,\
		0xbc, 0xc9, 0xf6, 0x62\
	};\
	/* T */\
	static uint8_t T[] = {\
		0x76, 0xfc, 0x6e, 0xce, 0x0f, 0x4e, 0x17, 0x68,\
		0xcd, 0xdf, 0x88, 0x53, 0xbb, 0x2d, 0x55, 0x1b\
	};

/**
 * gcm-test-vectors/vec-17.txt
 */
#define AESGCM_TEST_VEC_17 \
	/* K */\
	static uint8_t K[] = {\
		0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,\
		0x6d, 0x6a, 0x8f, 0x94, 0x67, 0x30, 0x83, 0x08,\
		0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,\
		0x6d, 0x6a, 0x8f, 0x94, 0x67, 0x30, 0x83, 0x08\
	};\
	/* P */\
	static uint8_t P[] = {\
		0xd9, 0x31, 0x32, 0x25, 0xf8, 0x84, 0x06, 0xe5,\
		0xa5, 0x59, 0x09, 0xc5, 0xaf, 0xf5, 0x26, 0x9a,\
		0x86, 0xa7, 0xa9, 0x53, 0x15, 0x34, 0xf7, 0xda,\
		0x2e, 0x4c, 0x30, 0x3d, 0x8a, 0x31, 0x8a, 0x72,\
		0x1c, 0x3c, 0x0c, 0x95, 0x95, 0x68, 0x09, 0x53,\
		0x2f, 0xcf, 0x0e, 0x24, 0x49, 0xa6, 0xb5, 0x25,\
		0xb1, 0x6a, 0xed, 0xf5, 0xaa, 0x0d, 0xe6, 0x57,\
		0xba, 0x63, 0x7b, 0x39\
	};\
	/* A */\
	static uint8_t A[] = {\
		0xfe, 0xed, 0xfa, 0xce, 0xde, 0xad, 0xbe, 0xef,\
		0xfe, 0xed, 0xfa, 0xce, 0xde, 0xad, 0xbe, 0xef,\
		0xab, 0xad, 0xda, 0xd2\
	};\
	/* IV */\
	static uint8_t IV[] = {\
		0xca, 0xfe, 0xba, 0xbe, 0xfa, 0xce, 0xdb, 0xad\
	};\
	/* H */\
	static uint8_t H[] = {\
		0xac, 0xbe, 0xf2, 0x05, 0x79, 0xb4, 0xb8, 0xeb,\
		0xce, 0x88, 0x9b, 0xac, 0x87, 0x32, 0xda, 0xd7\
	};\
	/* N_1 */\
	static uint8_t N1[] = {\
		0x90, 0xc2, 0x2e, 0x3d, 0x2a, 0xca, 0x34, 0xb9,\
		0x71, 0xe8, 0xbd, 0x09, 0x70, 0x8f, 0xae, 0x5c\
	};\
	/* 0^{64}||len(IV) */\
	static uint8_t O64len_IV_[] = {\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40\
	};\
	/* Y_0 */\
	static uint8_t Y0[] = {\
		0x00, 0x95, 0xdf, 0x49, 0xdd, 0x90, 0xab, 0xe3,\
		0xe4, 0xd2, 0x52, 0x47, 0x57, 0x48, 0xf5, 0xd4\
	};\
	/* E(K,Y_0) */\
	static uint8_t E_K_Y0_[] = {\
		0x4f, 0x90, 0x3f, 0x37, 0xfe, 0x61, 0x1d, 0x45,\
		0x42, 0x17, 0xfb, 0xfa, 0x5c, 0xd7, 0xd7, 0x91\
	};\
	/* X_1 */\
	static uint8_t X1[] = {\
		0x51, 0x65, 0xd2, 0x42, 0xc2, 0x59, 0x2c, 0x0a,\
		0x63, 0x75, 0xe2, 0x62, 0x2c, 0xf9, 0x25, 0xd2\
	};\
	/* X_2 */\
	static uint8_t X2[] = {\
		0x8e, 0xfa, 0x30, 0xce, 0x83, 0x29, 0x8b, 0x85,\
		0xfe, 0x71, 0xab, 0xef, 0xc0, 0xcd, 0xd0, 0x1d\
	};\
	/* Y_1 */\
	static uint8_t Y1[] = {\
		0x00, 0x95, 0xdf, 0x49, 0xdd, 0x90, 0xab, 0xe3,\
		0xe4, 0xd2, 0x52, 0x47, 0x57, 0x48, 0xf5, 0xd5\
	};\
	/* E(K,Y_1) */\
	static uint8_t E_K_Y1_[] = {\
		0x1a, 0x47, 0x1f, 0xd4, 0x32, 0xfc, 0x7b, 0xd7,\
		0x0b, 0x1e, 0xc8, 0xfe, 0x5e, 0x6d, 0x62, 0x51\
	};\
	/* Y_2 */\
	static uint8_t Y2[] = {\
		0x00, 0x95, 0xdf, 0x49, 0xdd, 0x90, 0xab, 0xe3,\
		0xe4, 0xd2, 0x52, 0x47, 0x57, 0x48, 0xf5, 0xd6\
	};\
	/* E(K,Y_2) */\
	static uint8_t E_K_Y2_[] = {\
		0x29, 0xbd, 0x48, 0x1e, 0x1e, 0xa3, 0x9d, 0x20,\
		0xeb, 0x63, 0xc7, 0xea, 0x11, 0x8b, 0x17, 0x92\
	};\
	/* Y_3 */\
	static uint8_t Y3[] = {\
		0x00, 0x95, 0xdf, 0x49, 0xdd, 0x90, 0xab, 0xe3,\
		0xe4, 0xd2, 0x52, 0x47, 0x57, 0x48, 0xf5, 0xd7\
	};\
	/* E(K,Y_3) */\
	static uint8_t E_K_Y3_[] = {\
		0xe2, 0x89, 0x8e, 0x46, 0xac, 0x5c, 0xad, 0xa3,\
		0xba, 0x83, 0xcc, 0x12, 0x72, 0x61, 0x8a, 0x5d\
	};\
	/* Y_4 */\
	static uint8_t Y4[] = {\
		0x00, 0x95, 0xdf, 0x49, 0xdd, 0x90, 0xab, 0xe3,\
		0xe4, 0xd2, 0x52, 0x47, 0x57, 0x48, 0xf5, 0xd8\
	};\
	/* E(K,Y_4) */\
	static uint8_t E_K_Y4_[] = {\
		0xd3, 0xc6, 0xae, 0xfb, 0xce, 0xa6, 0x02, 0xce,\
		0x4e, 0x1f, 0xe0, 0x26, 0x06, 0x54, 0x47, 0xbf\
	};\
	/* X_3 */\
	static uint8_t X3[] = {\
		0x55, 0xe1, 0xff, 0x68, 0xf9, 0x24, 0x9e, 0x64,\
		0xb9, 0x52, 0x23, 0x85, 0x8e, 0x5c, 0xb9, 0x36\
	};\
	/* X_4 */\
	static uint8_t X4[] = {\
		0xce, 0xf1, 0xc0, 0x34, 0x38, 0x3d, 0xc9, 0x6f,\
		0x73, 0x3a, 0xaa, 0x4c, 0x99, 0xbd, 0x3e, 0x61\
	};\
	/* X_5 */\
	static uint8_t X5[] = {\
		0x68, 0x58, 0x8d, 0x00, 0x4f, 0xd4, 0x68, 0xf5,\
		0x85, 0x45, 0x15, 0x03, 0x9b, 0x08, 0x16, 0x5d\
	};\
	/* X_6 */\
	static uint8_t X6[] = {\
		0x23, 0x78, 0x94, 0x3c, 0x03, 0x46, 0x97, 0xf7,\
		0x2a, 0x80, 0xfc, 0xe5, 0x05, 0x9b, 0xf3, 0xf3\
	};\
	/* len(A)||len(C) */\
	static uint8_t len_A_len_C_[] = {\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0,\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xe0\
	};\
	/* GHASH(H,A,C) */\
	static uint8_t GHASH_H_A_C_[] = {\
		0x75, 0xa3, 0x42, 0x88, 0xb8, 0xc6, 0x8f, 0x81,\
		0x1c, 0x52, 0xb2, 0xe9, 0xa2, 0xf9, 0x7f, 0x63\
	};\
	/* C */\
	static uint8_t C[] = {\
		0xc3, 0x76, 0x2d, 0xf1, 0xca, 0x78, 0x7d, 0x32,\
		0xae, 0x47, 0xc1, 0x3b, 0xf1, 0x98, 0x44, 0xcb,\
		0xaf, 0x1a, 0xe1, 0x4d, 0x0b, 0x97, 0x6a, 0xfa,\
		0xc5, 0x2f, 0xf7, 0xd7, 0x9b, 0xba, 0x9d, 0xe0,\
		0xfe, 0xb5, 0x82, 0xd3, 0x39, 0x34, 0xa4, 0xf0,\
		0x95, 0x4c, 0xc2, 0x36, 0x3b, 0xc7, 0x3f, 0x78,\
		0x62, 0xac, 0x43, 0x0e, 0x64, 0xab, 0xe4, 0x99,\
		0xf4, 0x7c, 0x9b, 0x1f\
	};\
	/* T */\
	static uint8_t T[] = {\
		0x3a, 0x33, 0x7d, 0xbf, 0x46, 0xa7, 0x92, 0xc4,\
		0x5e, 0x45, 0x49, 0x13, 0xfe, 0x2e, 0xa8, 0xf2\
	};

/**
 * gcm-test-vectors/vec-18.txt
 */
#define AESGCM_TEST_VEC_18 \
	/* K */\
	static uint8_t K[] = {\
		0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,\
		0x6d, 0x6a, 0x8f, 0x94, 0x67, 0x30, 0x83, 0x08,\
		0xfe, 0xff, 0xe9, 0x92, 0x86, 0x65, 0x73, 0x1c,\
		0x6d, 0x6a, 0x8f, 0x94, 0x67, 0x30, 0x83, 0x08\
	};\
	/* P */\
	static uint8_t P[] = {\
		0xd9, 0x31, 0x32, 0x25, 0xf8, 0x84, 0x06, 0xe5,\
		0xa5, 0x59, 0x09, 0xc5, 0xaf, 0xf5, 0x26, 0x9a,\
		0x86, 0xa7, 0xa9, 0x53, 0x15, 0x34, 0xf7, 0xda,\
		0x2e, 0x4c, 0x30, 0x3d, 0x8a, 0x31, 0x8a, 0x72,\
		0x1c, 0x3c, 0x0c, 0x95, 0x95, 0x68, 0x09, 0x53,\
		0x2f, 0xcf, 0x0e, 0x24, 0x49, 0xa6, 0xb5, 0x25,\
		0xb1, 0x6a, 0xed, 0xf5, 0xaa, 0x0d, 0xe6, 0x57,\
		0xba, 0x63, 0x7b, 0x39\
	};\
	/* A */\
	static uint8_t A[] = {\
		0xfe, 0xed, 0xfa, 0xce, 0xde, 0xad, 0xbe, 0xef,\
		0xfe, 0xed, 0xfa, 0xce, 0xde, 0xad, 0xbe, 0xef,\
		0xab, 0xad, 0xda, 0xd2\
	};\
	/* IV */\
	static uint8_t IV[] = {\
		0x93, 0x13, 0x22, 0x5d, 0xf8, 0x84, 0x06, 0xe5,\
		0x55, 0x90, 0x9c, 0x5a, 0xff, 0x52, 0x69, 0xaa,\
		0x6a, 0x7a, 0x95, 0x38, 0x53, 0x4f, 0x7d, 0xa1,\
		0xe4, 0xc3, 0x03, 0xd2, 0xa3, 0x18, 0xa7, 0x28,\
		0xc3, 0xc0, 0xc9, 0x51, 0x56, 0x80, 0x95, 0x39,\
		0xfc, 0xf0, 0xe2, 0x42, 0x9a, 0x6b, 0x52, 0x54,\
		0x16, 0xae, 0xdb, 0xf5, 0xa0, 0xde, 0x6a, 0x57,\
		0xa6, 0x37, 0xb3, 0x9b\
	};\
	/* H */\
	static uint8_t H[] = {\
		0xac, 0xbe, 0xf2, 0x05, 0x79, 0xb4, 0xb8, 0xeb,\
		0xce, 0x88, 0x9b, 0xac, 0x87, 0x32, 0xda, 0xd7\
	};\
	/* N_1 */\
	static uint8_t N1[] = {\
		0x0b, 0xfe, 0x66, 0xe2, 0x03, 0x2f, 0x19, 0x55,\
		0x16, 0x37, 0x9f, 0x5f, 0xb7, 0x10, 0xf9, 0x87\
	};\
	/* N_2 */\
	static uint8_t N2[] = {\
		0xf0, 0x63, 0x15, 0x54, 0xd1, 0x14, 0x09, 0x91,\
		0x5f, 0xee, 0xc8, 0xf9, 0xf5, 0x10, 0x2a, 0xba\
	};\
	/* N_3 */\
	static uint8_t N3[] = {\
		0x74, 0x9b, 0x90, 0xdd, 0xa1, 0x9a, 0x15, 0x57,\
		0xfd, 0x9e, 0x9f, 0xd3, 0x1f, 0xed, 0x1d, 0x14\
	};\
	/* N_4 */\
	static uint8_t N4[] = {\
		0x7a, 0x6a, 0x83, 0x3f, 0x26, 0x0d, 0x84, 0x87,\
		0x93, 0xb3, 0x27, 0xcb, 0x07, 0xd1, 0xb1, 0x90\
	};\
	/* 0^{64}||len(IV) */\
	static uint8_t O64len_IV_[] = {\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xe0\
	};\
	/* Y_0 */\
	static uint8_t Y0[] = {\
		0x0c, 0xd9, 0x53, 0xe2, 0x14, 0x0a, 0x59, 0x76,\
		0x07, 0x9f, 0x8e, 0x24, 0x06, 0xbc, 0x8e, 0xb4\
	};\
	/* E(K,Y_0) */\
	static uint8_t E_K_Y0_[] = {\
		0x71, 0xb5, 0x4d, 0x09, 0x2b, 0xb0, 0xc3, 0xd9,\
		0xba, 0x94, 0x53, 0x8d, 0x40, 0x96, 0xe6, 0x91\
	};\
	/* X_1 */\
	static uint8_t X1[] = {\
		0x51, 0x65, 0xd2, 0x42, 0xc2, 0x59, 0x2c, 0x0a,\
		0x63, 0x75, 0xe2, 0x62, 0x2c, 0xf9, 0x25, 0xd2\
	};\
	/* X_2 */\
	static uint8_t X2[] = {\
		0x8e, 0xfa, 0x30, 0xce, 0x83, 0x29, 0x8b, 0x85,\
		0xfe, 0x71, 0xab, 0xef, 0xc0, 0xcd, 0xd0, 0x1d\
	};\
	/* Y_1 */\
	static uint8_t Y1[] = {\
		0x0c, 0xd9, 0x53, 0xe2, 0x14, 0x0a, 0x59, 0x76,\
		0x07, 0x9f, 0x8e, 0x24, 0x06, 0xbc, 0x8e, 0xb5\
	};\
	/* E(K,Y_1) */\
	static uint8_t E_K_Y1_[] = {\
		0x83, 0xbc, 0xdd, 0x0a, 0xf4, 0x1a, 0x55, 0x14,\
		0x52, 0x04, 0x71, 0x96, 0xca, 0x6b, 0x0c, 0xba\
	};\
	/* Y_2 */\
	static uint8_t Y2[] = {\
		0x0c, 0xd9, 0x53, 0xe2, 0x14, 0x0a, 0x59, 0x76,\
		0x07, 0x9f, 0x8e, 0x24, 0x06, 0xbc, 0x8e, 0xb6\
	};\
	/* E(K,Y_2) */\
	static uint8_t E_K_Y2_[] = {\
		0x68, 0x15, 0x1b, 0x79, 0xba, 0xea, 0x93, 0xc3,\
		0x8e, 0x14, 0x9b, 0x72, 0xe5, 0x45, 0xe1, 0x86\
	};\
	/* Y_3 */\
	static uint8_t Y3[] = {\
		0x0c, 0xd9, 0x53, 0xe2, 0x14, 0x0a, 0x59, 0x76,\
		0x07, 0x9f, 0x8e, 0x24, 0x06, 0xbc, 0x8e, 0xb7\
	};\
	/* E(K,Y_3) */\
	static uint8_t E_K_Y3_[] = {\
		0x13, 0xfc, 0xcf, 0x22, 0x15, 0x9a, 0x4d, 0x16,\
		0x02, 0x6c, 0xe5, 0xd5, 0x8c, 0x7e, 0x99, 0xfb\
	};\
	/* Y_4 */\
	static uint8_t Y4[] = {\
		0x0c, 0xd9, 0x53, 0xe2, 0x14, 0x0a, 0x59, 0x76,\
		0x07, 0x9f, 0x8e, 0x24, 0x06, 0xbc, 0x8e, 0xb8\
	};\
	/* E(K,Y_4) */\
	static uint8_t E_K_Y4_[] = {\
		0x13, 0x2b, 0x64, 0x62, 0x8a, 0x03, 0x1e, 0x79,\
		0xfe, 0xcd, 0x05, 0x06, 0x75, 0xa6, 0x4f, 0x07\
	};\
	/* X_3 */\
	static uint8_t X3[] = {\
		0xe9, 0x63, 0x94, 0x1c, 0xfa, 0x8c, 0x41, 0x7b,\
		0xda, 0xa3, 0xb3, 0xd9, 0x4a, 0xb4, 0xe9, 0x05\
	};\
	/* X_4 */\
	static uint8_t X4[] = {\
		0x21, 0x78, 0xd7, 0xf8, 0x36, 0xe5, 0xfa, 0x10,\
		0x5c, 0xe0, 0xfd, 0xf0, 0xfc, 0x8f, 0x06, 0x54\
	};\
	/* X_5 */\
	static uint8_t X5[] = {\
		0xba, 0xc1, 0x4e, 0xeb, 0xa3, 0x21, 0x6f, 0x96,\
		0x6b, 0x3e, 0x7e, 0x01, 0x14, 0x75, 0xb8, 0x32\
	};\
	/* X_6 */\
	static uint8_t X6[] = {\
		0xcc, 0x9a, 0xe9, 0x17, 0x57, 0x29, 0xa6, 0x49,\
		0x93, 0x6e, 0x89, 0x0b, 0xd9, 0x71, 0xa8, 0xbf\
	};\
	/* len(A)||len(C) */\
	static uint8_t len_A_len_C_[] = {\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0,\
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xe0\
	};\
	/* GHASH(H,A,C) */\
	static uint8_t GHASH_H_A_C_[] = {\
		0xd5, 0xff, 0xcf, 0x6f, 0xc5, 0xac, 0x4d, 0x69,\
		0x72, 0x21, 0x87, 0x42, 0x1a, 0x7f, 0x17, 0x0b\
	};\
	/* C */\
	static uint8_t C[] = {\
		0x5a, 0x8d, 0xef, 0x2f, 0x0c, 0x9e, 0x53, 0xf1,\
		0xf7, 0x5d, 0x78, 0x53, 0x65, 0x9e, 0x2a, 0x20,\
		0xee, 0xb2, 0xb2, 0x2a, 0xaf, 0xde, 0x64, 0x19,\
		0xa0, 0x58, 0xab, 0x4f, 0x6f, 0x74, 0x6b, 0xf4,\
		0x0f, 0xc0, 0xc3, 0xb7, 0x80, 0xf2, 0x44, 0x45,\
		0x2d, 0xa3, 0xeb, 0xf1, 0xc5, 0xd8, 0x2c, 0xde,\
		0xa2, 0x41, 0x89, 0x97, 0x20, 0x0e, 0xf8, 0x2e,\
		0x44, 0xae, 0x7e, 0x3f\
	};\
	/* T */\
	static uint8_t T[] = {\
		0xa4, 0x4a, 0x82, 0x66, 0xee, 0x1c, 0x8e, 0xb0,\
		0xc8, 0xb5, 0xd4, 0xcf, 0x5a, 0xe9, 0xf1, 0x9a\
	};

#endif /* INCLUSION_GUARD_UUID_C0C4DC92_A360_43CC_A2DD_258ED220FE74 */
