/* md2testfc.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <aicrypto/ok_md2.h>

/*
 * A reference suite of strings from RFC 1319.
 */
static const char in[7][128] = {
	"",
	"a",
	"abc",
	"message digest",
	"abcdefghijklmnopqrstuvwxyz",
	"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789",

	"1234567890123456789012345678901234567890"
	"1234567890123456789012345678901234567890"
};
static const unsigned char ans[7][16] = {
	{0x83, 0x50, 0xe5, 0xa3, 0xe2, 0x4c, 0x15, 0x3d, 0xf2, 0x27,
	 0x5c, 0x9f, 0x80, 0x69, 0x27, 0x73},
	{0x32, 0xec, 0x01, 0xec, 0x4a, 0x6d, 0xac, 0x72, 0xc0, 0xab,
	 0x96, 0xfb, 0x34, 0xc0, 0xb5, 0xd1},
	{0xda, 0x85, 0x3b, 0x0d, 0x3f, 0x88, 0xd9, 0x9b, 0x30, 0x28,
	 0x3a, 0x69, 0xe6, 0xde, 0xd6, 0xbb},
	{0xab, 0x4f, 0x49, 0x6b, 0xfb, 0x2a, 0x53, 0x0b, 0x21, 0x9f,
	 0xf3, 0x30, 0x31, 0xfe, 0x06, 0xb0},
	{0x4e, 0x8d, 0xdf, 0xf3, 0x65, 0x02, 0x92, 0xab, 0x5a, 0x41,
	 0x08, 0xc3, 0xaa, 0x47, 0x94, 0x0b},
	{0xda, 0x33, 0xde, 0xf2, 0xa4, 0x2d, 0xf1, 0x39, 0x75, 0x35,
	 0x28, 0x46, 0xc3, 0x03, 0x38, 0xcd},
	{0xd5, 0x97, 0x6f, 0x79, 0xd8, 0x3d, 0x3a, 0x0d, 0xc9, 0x80,
	 0x6c, 0x3c, 0x66, 0xf3, 0xef, 0xd8}
};

int test_md2(void)
{
	unsigned char ret[16];
	int i;

	for (i = 0; i < 7; i++) {
		OK_MD2(strlen(in[i]), (unsigned char *)in[i], ret);

		if (memcmp(ret, ans[i], 16)) {
			printf("error : test md2 %d : %s\n", i, in[i]);
			return EXIT_FAILURE;
		}
		printf("test md2 %d -- ok\n", i);
	}
	return EXIT_SUCCESS;
}
