/* testlnm.c - large number test functions. */
/*
 * Modified by National Institute of Informatics in Japan, 2013-2014.
 *
 */
/*
 * Copyright (C) 1998-2002
 * Akira Iwata & Takuto Okuno
 * Akira Iwata Laboratory,
 * Nagoya Institute of Technology in Japan.
 *
 * All rights reserved.
 *
 * This software is written by Takuto Okuno(usapato@anet.ne.jp)
 * And if you want to contact us, send an email to Kimitake Wakayama
 * (wakayama@elcom.nitech.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *	this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *	this list of conditions and the following disclaimer in the documentation
 *	and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software must
 *	display the following acknowledgment:
 *	"This product includes software developed by Akira Iwata Laboratory,
 *	Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *	acknowledgment:
 *	"This product includes software developed by Akira Iwata Laboratory,
 *	 Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *   AKIRA IWATA LABORATORY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *   SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 *   IN NO EVENT SHALL AKIRA IWATA LABORATORY BE LIABLE FOR ANY SPECIAL,
 *   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *   FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *   NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#include "aiconfig.h"

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include <math.h>
#include <aicrypto/large_num.h>


/*=========================================================
  large number calculation test
=========================================================*/
int main(argc, argv)
     int argc;
     char **argv;
{
	LNm *b, *c, *d, *e;
	int i;
	uint32_t ts;
	unsigned char tc[] = {0x01,0x02,0x03,0x04,0x05};
	unsigned char tctr[16]; /* tray */
	unsigned short tu16[] = {0x0102,0x0304,0x0506,0x0708,0x090a};
	uint32_t tu32[] = {0x01020304, 0x05060708, 0x090a0b0c, 0x0d0e0f00};
	uint32_t tu32tr[16]; /* tray */

	if ((b = LN_alloc()) == NULL) return EXIT_FAILURE;
	if ((c = LN_alloc()) == NULL) return EXIT_FAILURE;
	if ((d = LN_alloc()) == NULL) return EXIT_FAILURE;
	if ((e = LN_alloc()) == NULL) return EXIT_FAILURE;

	/* test for setting and printing LNm object composition */
	for (i = 0; i < sizeof(tc); i++) {
		if ((LN_set_num_c(b, i + 1, tc)) < 0) return EXIT_FAILURE;
		LN_print(b);
	}

	/* test for getting figures from LNm */
	for (i = sizeof(tc); i > 0; i--) {
		int j;
		LN_get_num_c(b, i, tctr);
		for (j = 0; j < i; j++) printf("%.2x ", tctr[j]);
		printf("\n");
	}

	/* test for setting LNm with 16-bit usigned integer */
	LN_set_num_s(c, sizeof(tu16) / sizeof(unsigned short), tu16);
	LN_print(c);
	/* test for setting LNm with 32-bit usigned integer */
	LN_set_num(c, sizeof(tu32) / sizeof(uint32_t), tu32);
	LN_print(c);
	LN_get_num(c, sizeof(tu32) / sizeof(uint32_t), tu32tr);
	for (i = 0; i < sizeof(tu32) / sizeof(uint32_t); i++)
		printf("%.8x ", tu32tr[i]);
	printf("\n");

	/* test for adding an LN_UNIT to the LNm. */
	LN_long_add(b, (LN_UNIT)0xffffffff); /* depending upon sizeof(LN_UNIT) */
	LN_print(b);

	/* test for subtracting an LN_UNIT from the LNm */
	LN_long_sub(b, (LN_UNIT)0xffffffff); /* ditto. */
	LN_long_sub(b, (LN_UNIT)0x02030406);
	LN_print(b);

	/* long mod test */
	LN_set_num_c(b,3,tc);
	LN_long_mod(b,3,&ts);
	printf("mod = %d :: ",ts); LN_print(b);

	printf(" -- print and set test end -- \n");

	if (test_plus_minus())
		exit(EXIT_FAILURE);

	if (test_mul_div_mod())
		exit(EXIT_FAILURE);

	if (test_karatsuba())
		exit(EXIT_FAILURE);

	if (test_shift())
		exit(EXIT_FAILURE);

	if (test_long())
		exit(EXIT_FAILURE);

	if (test_ext_euclid())
		exit(EXIT_FAILURE);

	if (test_exp_mod())
		exit(EXIT_FAILURE);

	if (test_exp_mod2())
		exit(EXIT_FAILURE);

	if (test_rsa())
		exit(EXIT_FAILURE);

	if (test_prime())
		exit(EXIT_FAILURE);

	if (test_sqrt())
		exit(EXIT_FAILURE);

	LN_free(b);
	LN_free(c);
	LN_free(d);
	LN_free(e);

	return EXIT_SUCCESS;
}


