/* test1.c */
/* thread test program.
 *
 * Takuto Okuno
 * Nagoya Institute of Technology in Japan.
 * Nov,9,2000
 */

#include <stdio.h>
#include <pthread.h>

#include "large_num.h"


#define NUM_THREADS 4

/* thread function */
void *pth_test(void *arg);

/* global value */
pthread_t threads[NUM_THREADS];
pthread_mutex_t lock;
int num=2;

/*---------------------------------------
  test main
---------------------------------------*/
int main(int argc,char **argv){
  int i,j;

  printf("start main routine.\n");

  pthread_mutex_init(&lock,NULL);

  for(i=0;i<NUM_THREADS;i++){
    pthread_create(&threads[i],NULL,pth_test,(void*)i);
  }
  printf("\n");

  for(i=0;i<NUM_THREADS;i++){
    pthread_join(threads[i],NULL);
  }
  printf("end main routine.\n");

  pthread_exit((void*)0);
}

/*---------------------------------------
  POSIX thread
---------------------------------------*/
void *pth_test(void *arg){
    LNm *b,*c,*d,*e;
    int i;
    ULONG ts;
    unsigned char tc[]={0x01,0x02,0x03,0x04,0x05};
    unsigned char td[16];

    b = LN_alloc();
    c = LN_alloc();
    d = LN_alloc();
    e = LN_alloc();

    /* set and print test */
    LN_set_num_c(b,1,tc);
    LN_print(b);

    LN_set_num_c(b,2,tc);
    LN_print(b);

    LN_set_num_c(b,3,tc);
    LN_print(b);

    LN_set_num_c(b,4,tc);
    LN_print(b);

    LN_set_num_c(b,5,tc);
    LN_print(b);

    LN_get_num_c(b,5,td);
    for(i=0;i<5;i++) printf("%.2x ",td[i]);
    printf("\n");

    LN_get_num_c(b,4,td);
    for(i=0;i<4;i++) printf("%.2x ",td[i]);
    printf("\n");

    LN_get_num_c(b,3,td);
    for(i=0;i<3;i++) printf("%.2x ",td[i]);
    printf("\n");

    LN_get_num_c(b,2,td);
    for(i=0;i<2;i++) printf("%.2x ",td[i]);
    printf("\n");

    LN_get_num_c(b,1,td);
    for(i=0;i<1;i++) printf("%.2x ",td[i]);
    printf("\n");

    /* long add test */
    LN_long_add(b,0xffffffff);
    LN_print(b);

    /* long mod test */
    LN_set_num_c(b,3,tc);
    LN_long_mod(b,3,&ts);
    printf("mod = %d :: ",ts); LN_print(b);

    printf(" -- print and set test end -- \n");

    test_plus_minus();

    test_mul_div_mod();

    /* karatsuba-multi uses recursive functions.
     * therefore, error might be occured in many cases.
     * LN_multi_kara should be critical section >:(
     */
/*    pthread_mutex_lock(&lock);
    test_karatsuba();
    pthread_mutex_unlock(&lock);*/

    test_shift();

    test_long();

    test_ext_euclid();

    test_exp_mod();

    test_rsa();

    test_prime();

    test_sqrt();

    LN_free(b);
    LN_free(c);
    LN_free(d);
    LN_free(e);

    pthread_exit((void*)0);
}
